"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUrlIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpUrlIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param url the URL to proxy to
     * @param props properties to configure the integration
     */
    constructor(id, url, props = {}) {
        super(id);
        this.url = url;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpUrlIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpUrlIntegration);
            }
            throw error;
        }
    }
    bind(_) {
        return {
            method: this.props.method ?? aws_apigatewayv2_alpha_1.HttpMethod.ANY,
            payloadFormatVersion: aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_1_0,
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.url,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpUrlIntegration = HttpUrlIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpUrlIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpUrlIntegration", version: "2.28.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cC1wcm94eS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImh0dHAtcHJveHkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsNEVBUXlDO0FBb0J6Qzs7R0FFRztBQUNILE1BQWEsa0JBQW1CLFNBQVEsNkNBQW9CO0lBQzFEOzs7O09BSUc7SUFDSCxZQUFZLEVBQVUsRUFBbUIsR0FBVyxFQUFtQixRQUFpQyxFQUFFO1FBQ3hHLEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUQ2QixRQUFHLEdBQUgsR0FBRyxDQUFRO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQThCOzs7Ozs7K0NBTi9GLGtCQUFrQjs7OztLQVE1QjtJQUVNLElBQUksQ0FBQyxDQUFrQztRQUM1QyxPQUFPO1lBQ0wsTUFBTSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxJQUFJLG1DQUFVLENBQUMsR0FBRztZQUMzQyxvQkFBb0IsRUFBRSw2Q0FBb0IsQ0FBQyxXQUFXO1lBQ3RELElBQUksRUFBRSw0Q0FBbUIsQ0FBQyxVQUFVO1lBQ3BDLEdBQUcsRUFBRSxJQUFJLENBQUMsR0FBRztZQUNiLGdCQUFnQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCO1NBQzlDLENBQUM7S0FDSDs7QUFsQkgsZ0RBbUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgSHR0cEludGVncmF0aW9uVHlwZSxcbiAgSHR0cFJvdXRlSW50ZWdyYXRpb25CaW5kT3B0aW9ucyxcbiAgSHR0cFJvdXRlSW50ZWdyYXRpb25Db25maWcsXG4gIEh0dHBNZXRob2QsXG4gIEh0dHBSb3V0ZUludGVncmF0aW9uLFxuICBQYXJhbWV0ZXJNYXBwaW5nLFxuICBQYXlsb2FkRm9ybWF0VmVyc2lvbixcbn0gZnJvbSAnQGF3cy1jZGsvYXdzLWFwaWdhdGV3YXl2Mi1hbHBoYSc7XG5cbi8qKlxuICogUHJvcGVydGllcyB0byBpbml0aWFsaXplIGEgbmV3IGBIdHRwUHJveHlJbnRlZ3JhdGlvbmAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSHR0cFVybEludGVncmF0aW9uUHJvcHMge1xuICAvKipcbiAgICogVGhlIEhUVFAgbWV0aG9kIHRoYXQgbXVzdCBiZSB1c2VkIHRvIGludm9rZSB0aGUgdW5kZXJseWluZyBIVFRQIHByb3h5LlxuICAgKiBAZGVmYXVsdCBIdHRwTWV0aG9kLkFOWVxuICAgKi9cbiAgcmVhZG9ubHkgbWV0aG9kPzogSHR0cE1ldGhvZDtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIGhvdyB0byB0cmFuc2Zvcm0gSFRUUCByZXF1ZXN0cyBiZWZvcmUgc2VuZGluZyB0aGVtIHRvIHRoZSBiYWNrZW5kXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwaWdhdGV3YXkvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2h0dHAtYXBpLXBhcmFtZXRlci1tYXBwaW5nLmh0bWxcbiAgICogQGRlZmF1bHQgdW5kZWZpbmVkIHJlcXVlc3RzIGFyZSBzZW50IHRvIHRoZSBiYWNrZW5kIHVubW9kaWZpZWRcbiAgICovXG4gIHJlYWRvbmx5IHBhcmFtZXRlck1hcHBpbmc/OiBQYXJhbWV0ZXJNYXBwaW5nO1xufVxuXG4vKipcbiAqIFRoZSBIVFRQIFByb3h5IGludGVncmF0aW9uIHJlc291cmNlIGZvciBIVFRQIEFQSVxuICovXG5leHBvcnQgY2xhc3MgSHR0cFVybEludGVncmF0aW9uIGV4dGVuZHMgSHR0cFJvdXRlSW50ZWdyYXRpb24ge1xuICAvKipcbiAgICogQHBhcmFtIGlkIGlkIG9mIHRoZSB1bmRlcmx5aW5nIGludGVncmF0aW9uIGNvbnN0cnVjdFxuICAgKiBAcGFyYW0gdXJsIHRoZSBVUkwgdG8gcHJveHkgdG9cbiAgICogQHBhcmFtIHByb3BzIHByb3BlcnRpZXMgdG8gY29uZmlndXJlIHRoZSBpbnRlZ3JhdGlvblxuICAgKi9cbiAgY29uc3RydWN0b3IoaWQ6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSB1cmw6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBwcm9wczogSHR0cFVybEludGVncmF0aW9uUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKGlkKTtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF86IEh0dHBSb3V0ZUludGVncmF0aW9uQmluZE9wdGlvbnMpOiBIdHRwUm91dGVJbnRlZ3JhdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG1ldGhvZDogdGhpcy5wcm9wcy5tZXRob2QgPz8gSHR0cE1ldGhvZC5BTlksXG4gICAgICBwYXlsb2FkRm9ybWF0VmVyc2lvbjogUGF5bG9hZEZvcm1hdFZlcnNpb24uVkVSU0lPTl8xXzAsIC8vIDEuMCBpcyByZXF1aXJlZCBhbmQgaXMgdGhlIG9ubHkgc3VwcG9ydGVkIGZvcm1hdFxuICAgICAgdHlwZTogSHR0cEludGVncmF0aW9uVHlwZS5IVFRQX1BST1hZLFxuICAgICAgdXJpOiB0aGlzLnVybCxcbiAgICAgIHBhcmFtZXRlck1hcHBpbmc6IHRoaXMucHJvcHMucGFyYW1ldGVyTWFwcGluZyxcbiAgICB9O1xuICB9XG59Il19