# -*- coding: utf-8 -*-
# Generated by Django 1.11.23 on 2020-02-06 15:13
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import re


class Migration(migrations.Migration):

    dependencies = [
        ('coverages', '0006_masktype_validity'),
    ]

    operations = [
        migrations.AlterField(
            model_name='arraydataitem',
            name='bands_interpretation',
            field=models.PositiveSmallIntegerField(choices=[(0, 'fields'), (1, 'dimension')], default=0),
        ),
        migrations.AlterField(
            model_name='browsetype',
            name='name',
            field=models.CharField(blank=True, max_length=256, validators=[django.core.validators.RegexValidator(re.compile('^[a-zA-z_][a-zA-Z0-9_]*$', 32), message='This field must contain a valid Name.')]),
        ),
        migrations.AlterField(
            model_name='collectiontype',
            name='name',
            field=models.CharField(max_length=512, unique=True, validators=[django.core.validators.RegexValidator(re.compile('^[a-zA-z_][a-zA-Z0-9_]*$', 32), message='This field must contain a valid Name.')]),
        ),
        migrations.AlterField(
            model_name='coveragetype',
            name='name',
            field=models.CharField(max_length=512, unique=True, validators=[django.core.validators.RegexValidator(re.compile('^[a-zA-z_][a-zA-Z0-9_]*$', 32), message='This field must contain a valid Name.')]),
        ),
        migrations.AlterField(
            model_name='fieldtype',
            name='identifier',
            field=models.CharField(max_length=512, validators=[django.core.validators.RegexValidator(re.compile('^[a-zA-z_][a-zA-Z0-9_.-]*$', 32), message='This field must contain a valid NCName.')]),
        ),
        migrations.AlterField(
            model_name='grid',
            name='axis_1_type',
            field=models.SmallIntegerField(choices=[(0, 'spatial'), (1, 'elevation'), (2, 'temporal'), (3, 'other')]),
        ),
        migrations.AlterField(
            model_name='grid',
            name='axis_2_type',
            field=models.SmallIntegerField(blank=True, choices=[(0, 'spatial'), (1, 'elevation'), (2, 'temporal'), (3, 'other')], null=True),
        ),
        migrations.AlterField(
            model_name='grid',
            name='axis_3_type',
            field=models.SmallIntegerField(blank=True, choices=[(0, 'spatial'), (1, 'elevation'), (2, 'temporal'), (3, 'other')], null=True),
        ),
        migrations.AlterField(
            model_name='grid',
            name='axis_4_type',
            field=models.SmallIntegerField(blank=True, choices=[(0, 'spatial'), (1, 'elevation'), (2, 'temporal'), (3, 'other')], null=True),
        ),
        migrations.AlterField(
            model_name='grid',
            name='name',
            field=models.CharField(max_length=256, null=True, unique=True, validators=[django.core.validators.RegexValidator(re.compile('^[a-zA-z_][a-zA-Z0-9_]*$', 32), message='This field must contain a valid Name.')]),
        ),
        migrations.AlterField(
            model_name='masktype',
            name='name',
            field=models.CharField(max_length=512, validators=[django.core.validators.RegexValidator(re.compile('^[a-zA-z_][a-zA-Z0-9_]*$', 32), message='This field must contain a valid Name.')]),
        ),
        migrations.AlterField(
            model_name='metadataitem',
            name='semantic',
            field=models.SmallIntegerField(blank=True, choices=[(0, 'other'), (1, 'description'), (2, 'documentation'), (3, 'thumbnail')], null=True),
        ),
        migrations.AlterField(
            model_name='nilvalue',
            name='reason',
            field=models.CharField(choices=[('http://www.opengis.net/def/nil/OGC/0/inapplicable', 'Inapplicable (There is no value)'), ('http://www.opengis.net/def/nil/OGC/0/missing', 'Missing'), ('http://www.opengis.net/def/nil/OGC/0/template', 'Template (The value will be available later)'), ('http://www.opengis.net/def/nil/OGC/0/unknown', 'Unknown'), ('http://www.opengis.net/def/nil/OGC/0/withheld', 'Withheld (The value is not divulged)'), ('http://www.opengis.net/def/nil/OGC/0/AboveDetectionRange', 'Above detection range'), ('http://www.opengis.net/def/nil/OGC/0/BelowDetectionRange', 'Below detection range')], max_length=512),
        ),
        migrations.AlterField(
            model_name='productmetadata',
            name='acquisition_type',
            field=models.PositiveSmallIntegerField(blank=True, choices=[(0, 'NOMINAL'), (1, 'CALIBRATION'), (2, 'OTHER')], db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='productmetadata',
            name='antenna_look_direction',
            field=models.PositiveSmallIntegerField(blank=True, choices=[(0, 'LEFT'), (1, 'RIGHT')], db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='productmetadata',
            name='orbit_direction',
            field=models.PositiveSmallIntegerField(blank=True, choices=[(0, 'ASCENDING'), (1, 'DESCENDING')], db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='productmetadata',
            name='polarisation_mode',
            field=models.PositiveSmallIntegerField(blank=True, choices=[(0, 'single'), (1, 'dual'), (2, 'twin'), (3, 'quad'), (4, 'UNDEFINED')], db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='productmetadata',
            name='polarization_channels',
            field=models.PositiveSmallIntegerField(blank=True, choices=[(0, 'HV'), (1, 'HV, VH'), (2, 'VH'), (3, 'VV'), (4, 'HH, VV'), (5, 'HH, VH'), (6, 'HH, HV'), (7, 'VH, VV'), (8, 'VH, HV'), (9, 'VV, HV'), (10, 'VV, VH'), (11, 'HH'), (12, 'HH, HV, VH, VV'), (13, 'UNDEFINED')], db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='productmetadata',
            name='product_quality_status',
            field=models.PositiveSmallIntegerField(blank=True, choices=[(0, 'NOMINAL'), (1, 'DEGRAGED')], db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='productmetadata',
            name='production_status',
            field=models.PositiveSmallIntegerField(blank=True, choices=[(0, 'ARCHIVED'), (1, 'ACQUIRED'), (2, 'CANCELLED')], db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='producttype',
            name='name',
            field=models.CharField(max_length=512, unique=True, validators=[django.core.validators.RegexValidator(re.compile('^[a-zA-z_][a-zA-Z0-9_]*$', 32), message='This field must contain a valid Name.')]),
        ),
    ]
