import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "aws-cdk.aws-apigatewayv2-integrations-alpha",
    "version": "2.3.0.a0",
    "description": "Integrations for AWS APIGateway V2",
    "license": "Apache-2.0",
    "url": "https://github.com/aws/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/aws/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_cdk.aws_apigatewayv2_integrations_alpha",
        "aws_cdk.aws_apigatewayv2_integrations_alpha._jsii"
    ],
    "package_data": {
        "aws_cdk.aws_apigatewayv2_integrations_alpha._jsii": [
            "aws-apigatewayv2-integrations-alpha@2.3.0-alpha.0.jsii.tgz"
        ],
        "aws_cdk.aws_apigatewayv2_integrations_alpha": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "aws-cdk-lib>=2.3.0, <3.0.0",
        "aws-cdk.aws-apigatewayv2-alpha==2.3.0.a0",
        "constructs>=10.0.0, <11.0.0",
        "jsii>=1.47.0, <2.0.0",
        "publication>=0.0.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Typing :: Typed",
        "Development Status :: 4 - Beta",
        "License :: OSI Approved",
        "Framework :: AWS CDK",
        "Framework :: AWS CDK :: 1"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
