#pragma once

#include <bitset>

// 2^8 = 256 bits for 3^5 = 243 bits
static constexpr uint64_t BITSET3_LOG2 = 8;
static constexpr uint64_t BITSET3_LOG3 = 5;
static constexpr uint64_t BITSET3_PER3 = 243;
typedef std::bitset<1ull << BITSET3_LOG2> BITSET3;

// mask for shift=1, word per line
// 2 5 8 11 14 17 20 23 26
// 1 4 7 10 13 16 19 22 25
// 0 3 6 9  12 15 18 21 24

// masks for shift=3, word per line
// 3 4 5  12 13 14  21 22 23
// 6 7 8  15 16 17  24 25 26
// 0 1 2  9  10 11  18 19 20

const BITSET3 MASKS_TERNARY[6] = {
    // note: bitset(char *) is given MSB to LSB, snapped to LSB (missing MSBs are filled with zeroes)
    BITSET3("001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001001"),
    BITSET3("000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111000000111"),
    BITSET3("000000000000000000111111111000000000000000000111111111000000000000000000111111111000000000000000000111111111000000000000000000111111111000000000000000000111111111000000000000000000111111111000000000000000000111111111000000000000000000111111111"),
    BITSET3("000000000000000000000000000000000000000000000000000000111111111111111111111111111000000000000000000000000000000000000000000000000000000111111111111111111111111111000000000000000000000000000000000000000000000000000000111111111111111111111111111"),
    BITSET3("000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111"),
};

static inline uint64_t bin2ter(uint64_t x, int n) {
    uint64_t ret = 0;
    fori(i, n) {
        ret = ret * 3 + ((x >> (n - 1 - i)) & 1);
    }
    return ret;
}