# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkarms.endpoint import endpoint_data

class SearchTracesRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'ARMS', '2019-08-08', 'SearchTraces','arms')
		self.set_method('POST')
		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())


	def get_EndTime(self):
		return self.get_query_params().get('EndTime')

	def set_EndTime(self,EndTime):
		self.add_query_param('EndTime',EndTime)

	def get_StartTime(self):
		return self.get_query_params().get('StartTime')

	def set_StartTime(self,StartTime):
		self.add_query_param('StartTime',StartTime)

	def get_Reverse(self):
		return self.get_query_params().get('Reverse')

	def set_Reverse(self,Reverse):
		self.add_query_param('Reverse',Reverse)

	def get_MinDuration(self):
		return self.get_query_params().get('MinDuration')

	def set_MinDuration(self,MinDuration):
		self.add_query_param('MinDuration',MinDuration)

	def get_ServiceIp(self):
		return self.get_query_params().get('ServiceIp')

	def set_ServiceIp(self,ServiceIp):
		self.add_query_param('ServiceIp',ServiceIp)

	def get_ExclusionFilterss(self):
		return self.get_query_params().get('ExclusionFilterss')

	def set_ExclusionFilterss(self, ExclusionFilterss):
		for depth1 in range(len(ExclusionFilterss)):
			if ExclusionFilterss[depth1].get('Value') is not None:
				self.add_query_param('ExclusionFilters.' + str(depth1 + 1) + '.Value', ExclusionFilterss[depth1].get('Value'))
			if ExclusionFilterss[depth1].get('Key') is not None:
				self.add_query_param('ExclusionFilters.' + str(depth1 + 1) + '.Key', ExclusionFilterss[depth1].get('Key'))

	def get_OperationName(self):
		return self.get_query_params().get('OperationName')

	def set_OperationName(self,OperationName):
		self.add_query_param('OperationName',OperationName)

	def get_ServiceName(self):
		return self.get_query_params().get('ServiceName')

	def set_ServiceName(self,ServiceName):
		self.add_query_param('ServiceName',ServiceName)

	def get_Tags(self):
		return self.get_query_params().get('Tags')

	def set_Tags(self, Tags):
		for depth1 in range(len(Tags)):
			if Tags[depth1].get('Value') is not None:
				self.add_query_param('Tag.' + str(depth1 + 1) + '.Value', Tags[depth1].get('Value'))
			if Tags[depth1].get('Key') is not None:
				self.add_query_param('Tag.' + str(depth1 + 1) + '.Key', Tags[depth1].get('Key'))