"""
    Symphony Profile Manager

    Profile Manager is a microservice to manage users profile and groups  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from symphony.bdk.gen.api_client import ApiClient, Endpoint as _Endpoint
from symphony.bdk.gen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from symphony.bdk.gen.group_model.add_member import AddMember
from symphony.bdk.gen.group_model.create_group import CreateGroup
from symphony.bdk.gen.group_model.error import Error
from symphony.bdk.gen.group_model.group_list import GroupList
from symphony.bdk.gen.group_model.read_group import ReadGroup
from symphony.bdk.gen.group_model.sort_order import SortOrder
from symphony.bdk.gen.group_model.status import Status
from symphony.bdk.gen.group_model.update_group import UpdateGroup
from symphony.bdk.gen.group_model.upload_avatar import UploadAvatar


class GroupApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_member_to_group_endpoint = _Endpoint(
            settings={
                'response_type': (ReadGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/v1/groups/{groupId}/member',
                'operation_id': 'add_member_to_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_symphony_host',
                    'group_id',
                    'add_member',
                ],
                'required': [
                    'x_symphony_host',
                    'group_id',
                    'add_member',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'x_symphony_host',
                ]
            },
            root_map={
                'validations': {
                    ('x_symphony_host',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_symphony_host':
                        (str,),
                    'group_id':
                        (str,),
                    'add_member':
                        (AddMember,),
                },
                'attribute_map': {
                    'x_symphony_host': 'X-Symphony-Host',
                    'group_id': 'groupId',
                },
                'location_map': {
                    'x_symphony_host': 'header',
                    'group_id': 'path',
                    'add_member': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_all_groups_endpoint = _Endpoint(
            settings={
                'response_type': (GroupList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/v1/groups/deleteAll',
                'operation_id': 'delete_all_groups',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_symphony_host',
                ],
                'required': [
                    'x_symphony_host',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'x_symphony_host',
                ]
            },
            root_map={
                'validations': {
                    ('x_symphony_host',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_symphony_host':
                        (str,),
                },
                'attribute_map': {
                    'x_symphony_host': 'X-Symphony-Host',
                },
                'location_map': {
                    'x_symphony_host': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_group_endpoint = _Endpoint(
            settings={
                'response_type': (ReadGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/v1/groups/{groupId}',
                'operation_id': 'get_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_symphony_host',
                    'group_id',
                ],
                'required': [
                    'x_symphony_host',
                    'group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'x_symphony_host',
                ]
            },
            root_map={
                'validations': {
                    ('x_symphony_host',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_symphony_host':
                        (str,),
                    'group_id':
                        (str,),
                },
                'attribute_map': {
                    'x_symphony_host': 'X-Symphony-Host',
                    'group_id': 'groupId',
                },
                'location_map': {
                    'x_symphony_host': 'header',
                    'group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.insert_group_endpoint = _Endpoint(
            settings={
                'response_type': (ReadGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/v1/groups',
                'operation_id': 'insert_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_symphony_host',
                    'create_group',
                ],
                'required': [
                    'x_symphony_host',
                    'create_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'x_symphony_host',
                ]
            },
            root_map={
                'validations': {
                    ('x_symphony_host',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_symphony_host':
                        (str,),
                    'create_group':
                        (CreateGroup,),
                },
                'attribute_map': {
                    'x_symphony_host': 'X-Symphony-Host',
                },
                'location_map': {
                    'x_symphony_host': 'header',
                    'create_group': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.list_groups_endpoint = _Endpoint(
            settings={
                'response_type': (GroupList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/v1/groups/type/{typeId}',
                'operation_id': 'list_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_symphony_host',
                    'type_id',
                    'status',
                    'before',
                    'after',
                    'limit',
                    'sort_order',
                ],
                'required': [
                    'x_symphony_host',
                    'type_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'x_symphony_host',
                ]
            },
            root_map={
                'validations': {
                    ('x_symphony_host',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_symphony_host':
                        (str,),
                    'type_id':
                        (str,),
                    'status':
                        (Status,),
                    'before':
                        (str,),
                    'after':
                        (str,),
                    'limit':
                        (int,),
                    'sort_order':
                        (SortOrder,),
                },
                'attribute_map': {
                    'x_symphony_host': 'X-Symphony-Host',
                    'type_id': 'typeId',
                    'status': 'status',
                    'before': 'before',
                    'after': 'after',
                    'limit': 'limit',
                    'sort_order': 'sortOrder',
                },
                'location_map': {
                    'x_symphony_host': 'header',
                    'type_id': 'path',
                    'status': 'query',
                    'before': 'query',
                    'after': 'query',
                    'limit': 'query',
                    'sort_order': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_avatar_endpoint = _Endpoint(
            settings={
                'response_type': (ReadGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/v1/groups/{groupId}/avatar',
                'operation_id': 'update_avatar',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_symphony_host',
                    'group_id',
                    'upload_avatar',
                ],
                'required': [
                    'x_symphony_host',
                    'group_id',
                    'upload_avatar',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'x_symphony_host',
                ]
            },
            root_map={
                'validations': {
                    ('x_symphony_host',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_symphony_host':
                        (str,),
                    'group_id':
                        (str,),
                    'upload_avatar':
                        (UploadAvatar,),
                },
                'attribute_map': {
                    'x_symphony_host': 'X-Symphony-Host',
                    'group_id': 'groupId',
                },
                'location_map': {
                    'x_symphony_host': 'header',
                    'group_id': 'path',
                    'upload_avatar': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_group_endpoint = _Endpoint(
            settings={
                'response_type': (ReadGroup,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/v1/groups/{groupId}',
                'operation_id': 'update_group',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_symphony_host',
                    'if_match',
                    'group_id',
                    'update_group',
                ],
                'required': [
                    'x_symphony_host',
                    'if_match',
                    'group_id',
                    'update_group',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'x_symphony_host',
                ]
            },
            root_map={
                'validations': {
                    ('x_symphony_host',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_symphony_host':
                        (str,),
                    'if_match':
                        (str,),
                    'group_id':
                        (str,),
                    'update_group':
                        (UpdateGroup,),
                },
                'attribute_map': {
                    'x_symphony_host': 'X-Symphony-Host',
                    'if_match': 'If-Match',
                    'group_id': 'groupId',
                },
                'location_map': {
                    'x_symphony_host': 'header',
                    'if_match': 'header',
                    'group_id': 'path',
                    'update_group': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def add_member_to_group(
        self,
        x_symphony_host,
        group_id,
        add_member,
        **kwargs
    ):
        """Add a new user to a an existing group  # noqa: E501

        Add a new user to a an existing group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = group_api.add_member_to_group(x_symphony_host, group_id, add_member, async_req=True)
        >>> result = thread.get()

        Args:
            x_symphony_host (str):
            group_id (str):
            add_member (AddMember): JSON object containing the user member information and the group on which he will be added to

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ReadGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['x_symphony_host'] = \
            x_symphony_host
        kwargs['group_id'] = \
            group_id
        kwargs['add_member'] = \
            add_member
        return self.add_member_to_group_endpoint.call_with_http_info(**kwargs)

    def delete_all_groups(
        self,
        x_symphony_host,
        **kwargs
    ):
        """Delete all data related to the current pod (extracted from JWT). This endpoint is for maintenance/test and it is usually disabled or restricted  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = group_api.delete_all_groups(x_symphony_host, async_req=True)
        >>> result = thread.get()

        Args:
            x_symphony_host (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GroupList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['x_symphony_host'] = \
            x_symphony_host
        return self.delete_all_groups_endpoint.call_with_http_info(**kwargs)

    def get_group(
        self,
        x_symphony_host,
        group_id,
        **kwargs
    ):
        """Retrieve a group  # noqa: E501

        Retrieve a group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = group_api.get_group(x_symphony_host, group_id, async_req=True)
        >>> result = thread.get()

        Args:
            x_symphony_host (str):
            group_id (str): Group id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ReadGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['x_symphony_host'] = \
            x_symphony_host
        kwargs['group_id'] = \
            group_id
        return self.get_group_endpoint.call_with_http_info(**kwargs)

    def insert_group(
        self,
        x_symphony_host,
        create_group,
        **kwargs
    ):
        """Insert a new group  # noqa: E501

        Insert a new group into database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = group_api.insert_group(x_symphony_host, create_group, async_req=True)
        >>> result = thread.get()

        Args:
            x_symphony_host (str):
            create_group (CreateGroup): JSON object containing Group info

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ReadGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['x_symphony_host'] = \
            x_symphony_host
        kwargs['create_group'] = \
            create_group
        return self.insert_group_endpoint.call_with_http_info(**kwargs)

    def list_groups(
        self,
        x_symphony_host,
        type_id,
        **kwargs
    ):
        """List all groups of specified type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = group_api.list_groups(x_symphony_host, type_id, async_req=True)
        >>> result = thread.get()

        Args:
            x_symphony_host (str):
            type_id (str): Group type id

        Keyword Args:
            status (Status): filter by status, active or deleted. If not specified both are returned. [optional]
            before (str): NOT SUPPORTED YET, currently ignored. Cursor that points to the start of the current page of data. If not present, the current page is the first page. [optional]
            after (str): cursor that points to the end of the current page of data. If not present, the current page is the last page. [optional]
            limit (int): numbers of items to return. [optional]
            sort_order (SortOrder): items sorting direction (ordered by createdDate). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GroupList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['x_symphony_host'] = \
            x_symphony_host
        kwargs['type_id'] = \
            type_id
        return self.list_groups_endpoint.call_with_http_info(**kwargs)

    def update_avatar(
        self,
        x_symphony_host,
        group_id,
        upload_avatar,
        **kwargs
    ):
        """Update the group avatar  # noqa: E501

        Update the group account avatar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = group_api.update_avatar(x_symphony_host, group_id, upload_avatar, async_req=True)
        >>> result = thread.get()

        Args:
            x_symphony_host (str):
            group_id (str): Group id
            upload_avatar (UploadAvatar): JSON object containing Group avatar

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ReadGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['x_symphony_host'] = \
            x_symphony_host
        kwargs['group_id'] = \
            group_id
        kwargs['upload_avatar'] = \
            upload_avatar
        return self.update_avatar_endpoint.call_with_http_info(**kwargs)

    def update_group(
        self,
        x_symphony_host,
        if_match,
        group_id,
        update_group,
        **kwargs
    ):
        """Update a group  # noqa: E501

        Update an existing group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = group_api.update_group(x_symphony_host, if_match, group_id, update_group, async_req=True)
        >>> result = thread.get()

        Args:
            x_symphony_host (str):
            if_match (str):
            group_id (str): Group id
            update_group (UpdateGroup): JSON object containing Group info

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ReadGroup
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['x_symphony_host'] = \
            x_symphony_host
        kwargs['if_match'] = \
            if_match
        kwargs['group_id'] = \
            group_id
        kwargs['update_group'] = \
            update_group
        return self.update_group_endpoint.call_with_http_info(**kwargs)

