"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transport = exports.transportDefaults = exports.FLUSH_METRICS_TO_LOGS_ENV_VAR = exports.SITE_URL_ENV_VAR = exports.KMS_API_KEY_ENV_VAR = exports.API_KEY_ENV_VAR = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const loglevel_1 = require("loglevel");
exports.API_KEY_ENV_VAR = "DD_API_KEY";
exports.KMS_API_KEY_ENV_VAR = "DD_KMS_API_KEY";
exports.SITE_URL_ENV_VAR = "DD_SITE";
exports.FLUSH_METRICS_TO_LOGS_ENV_VAR = "DD_FLUSH_TO_LOG";
exports.transportDefaults = {
    site: "datadoghq.com",
    flushMetricsToLogs: true,
    enableDatadogTracing: true,
};
/**
 * @stability stable
 */
class Transport {
    /**
     * @stability stable
     */
    constructor(flushMetricsToLogs, site, apiKey, apiKmsKey, extensionLayerVersion) {
        if (flushMetricsToLogs === undefined) {
            loglevel_1.default.debug(`No value provided for flushMetricsToLogs, defaulting to ${exports.transportDefaults.flushMetricsToLogs}`);
            this.flushMetricsToLogs = exports.transportDefaults.flushMetricsToLogs;
        }
        else {
            this.flushMetricsToLogs = flushMetricsToLogs;
        }
        this.extensionLayerVersion = extensionLayerVersion;
        // If the extension is used, metrics will be submitted via the extension.
        if (this.extensionLayerVersion !== undefined) {
            loglevel_1.default.debug(`Using extension version ${this.extensionLayerVersion}, metrics will be submitted via the extension`);
            this.flushMetricsToLogs = false;
        }
        if (site === undefined) {
            loglevel_1.default.debug(`No value provided for site, defaulting to ${exports.transportDefaults.site}`);
            this.site = exports.transportDefaults.site;
        }
        else {
            this.site = site;
        }
        this.apiKey = apiKey;
        this.apiKmsKey = apiKmsKey;
    }
    /**
     * @stability stable
     */
    applyEnvVars(lambdas) {
        loglevel_1.default.debug(`Setting Datadog transport environment variables...`);
        lambdas.forEach((lam) => {
            lam.addEnvironment(exports.FLUSH_METRICS_TO_LOGS_ENV_VAR, this.flushMetricsToLogs.toString());
            if (this.site !== undefined && this.flushMetricsToLogs === false) {
                lam.addEnvironment(exports.SITE_URL_ENV_VAR, this.site);
            }
            if (this.apiKey !== undefined) {
                lam.addEnvironment(exports.API_KEY_ENV_VAR, this.apiKey);
            }
            if (this.apiKmsKey !== undefined) {
                lam.addEnvironment(exports.KMS_API_KEY_ENV_VAR, this.apiKmsKey);
            }
        });
    }
}
exports.Transport = Transport;
_a = JSII_RTTI_SYMBOL_1;
Transport[_a] = { fqn: "datadog-cdk-constructs.Transport", version: "0.3.0" };
//# sourceMappingURL=data:application/json;base64,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