"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyEnvVariables = exports.ENABLE_DD_LOGS_ENV_VAR = exports.LOG_LEVEL_ENV_VAR = exports.INJECT_LOG_CONTEXT_ENV_VAR = exports.ENABLE_DD_TRACING_ENV_VAR = void 0;
const loglevel_1 = require("loglevel");
exports.ENABLE_DD_TRACING_ENV_VAR = "DD_TRACE_ENABLED";
exports.INJECT_LOG_CONTEXT_ENV_VAR = "DD_LOGS_INJECTION";
exports.LOG_LEVEL_ENV_VAR = "DD_LOG_LEVEL";
exports.ENABLE_DD_LOGS_ENV_VAR = "DD_SERVERLESS_LOGS_ENABLED";
function applyEnvVariables(lambdas, enableDatadogTracing, injectLogContext, enableDatadogLogs, logLevel) {
    loglevel_1.default.debug(`Setting environment variables...`);
    lambdas.forEach((lam) => {
        lam.addEnvironment(exports.ENABLE_DD_TRACING_ENV_VAR, enableDatadogTracing.toString().toLowerCase());
        lam.addEnvironment(exports.INJECT_LOG_CONTEXT_ENV_VAR, injectLogContext.toString().toLowerCase());
        lam.addEnvironment(exports.ENABLE_DD_LOGS_ENV_VAR, enableDatadogLogs.toString().toLowerCase());
        if (logLevel) {
            lam.addEnvironment(exports.LOG_LEVEL_ENV_VAR, logLevel);
        }
    });
}
exports.applyEnvVariables = applyEnvVariables;
//# sourceMappingURL=data:application/json;base64,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