"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCdkConstructVersionTag = exports.Datadog = exports.defaultProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const loglevel_1 = require("loglevel");
const index_1 = require("./index");
const transport_1 = require("./transport");
const versionJson = require("../version.json");
var TagKeys;
(function (TagKeys) {
    TagKeys["Cdk"] = "dd_cdk_construct";
})(TagKeys || (TagKeys = {}));
exports.defaultProps = {
    addLayers: true,
    enableDatadogTracing: true,
    injectLogContext: true,
    enableDatadogLogs: true,
};
/**
 * @stability stable
 */
class Datadog extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        if (process.env.DD_CONSTRUCT_DEBUG_LOGS == "true")
            loglevel_1.default.setLevel("debug");
        super(scope, id);
        this.scope = scope;
        this.props = props;
        validateProps(this.props);
        this.transport = new transport_1.Transport(this.props.flushMetricsToLogs, this.props.site, this.props.apiKey, this.props.apiKmsKey, this.props.extensionLayerVersion);
    }
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions) {
        let addLayers = this.props.addLayers;
        let enableDatadogTracing = this.props.enableDatadogTracing;
        let injectLogContext = this.props.injectLogContext;
        const logLevel = this.props.logLevel;
        let enableDatadogLogs = this.props.enableDatadogLogs;
        if (addLayers === undefined) {
            loglevel_1.default.debug(`No value provided for addLayers, defaulting to ${exports.defaultProps.addLayers}`);
            addLayers = exports.defaultProps.addLayers;
        }
        if (enableDatadogTracing === undefined) {
            loglevel_1.default.debug(`No value provided for enableDatadogTracing, defaulting to ${exports.defaultProps.enableDatadogTracing}`);
            enableDatadogTracing = exports.defaultProps.enableDatadogTracing;
        }
        if (injectLogContext === undefined) {
            loglevel_1.default.debug(`No value provided for injectLogContext, defaulting to ${exports.defaultProps.injectLogContext}`);
            injectLogContext = exports.defaultProps.injectLogContext;
        }
        if (logLevel === undefined) {
            loglevel_1.default.debug(`No value provided for logLevel`);
        }
        if (enableDatadogLogs === undefined) {
            loglevel_1.default.debug(`No value provided for enableDatadogLogs, defaulting to ${exports.defaultProps.enableDatadogLogs}`);
            enableDatadogLogs = exports.defaultProps.enableDatadogLogs;
        }
        if (this.props !== undefined && lambdaFunctions.length > 0) {
            const region = `${lambdaFunctions[0].env.region}`;
            loglevel_1.default.debug(`Using region: ${region}`);
            index_1.applyLayers(this.scope, region, lambdaFunctions, this.props.pythonLayerVersion, this.props.nodeLayerVersion, this.props.extensionLayerVersion);
            index_1.redirectHandlers(lambdaFunctions, addLayers);
            if (this.props.forwarderArn !== undefined) {
                if (this.props.extensionLayerVersion !== undefined) {
                    loglevel_1.default.debug(`Skipping adding subscriptions to the lambda log groups since the extension is enabled`);
                }
                else {
                    loglevel_1.default.debug(`Adding log subscriptions using provided Forwarder ARN: ${this.props.forwarderArn}`);
                    index_1.addForwarder(this.scope, lambdaFunctions, this.props.forwarderArn);
                }
            }
            else {
                loglevel_1.default.debug("Forwarder ARN not provided, no log group subscriptions will be added");
            }
            addCdkConstructVersionTag(lambdaFunctions);
            index_1.applyEnvVariables(lambdaFunctions, enableDatadogTracing, injectLogContext, enableDatadogLogs, logLevel);
            this.transport.applyEnvVars(lambdaFunctions);
        }
    }
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups) {
        if (this.props.forwarderArn !== undefined) {
            index_1.addForwarderToLogGroups(this.scope, logGroups, this.props.forwarderArn);
        }
        else {
            loglevel_1.default.debug("Forwarder ARN not provided, no non lambda log group subscriptions will be added");
        }
    }
}
exports.Datadog = Datadog;
_a = JSII_RTTI_SYMBOL_1;
Datadog[_a] = { fqn: "datadog-cdk-constructs.Datadog", version: "0.3.0" };
function addCdkConstructVersionTag(lambdaFunctions) {
    loglevel_1.default.debug(`Adding CDK Construct version tag: ${versionJson.version}`);
    lambdaFunctions.forEach((functionName) => {
        cdk.Tags.of(functionName).add(TagKeys.Cdk, `v${versionJson.version}`, {
            includeResourceTypes: ["AWS::Lambda::Function"],
        });
    });
}
exports.addCdkConstructVersionTag = addCdkConstructVersionTag;
function validateProps(props) {
    loglevel_1.default.debug("Validating props...");
    const siteList = ["datadoghq.com", "datadoghq.eu", "us3.datadoghq.com", "ddog-gov.com"];
    if (props.apiKey !== undefined && props.apiKmsKey !== undefined) {
        throw new Error("Both `apiKey` and `apiKmsKey` cannot be set.");
    }
    if (props.site !== undefined && !siteList.includes(props.site.toLowerCase())) {
        throw new Error("Warning: Invalid site URL. Must be either datadoghq.com, datadoghq.eu, us3.datadoghq.com, or ddog-gov.com.");
    }
    if (props.apiKey === undefined && props.apiKmsKey === undefined && props.flushMetricsToLogs === false) {
        throw new Error("When `flushMetricsToLogs` is false, `apiKey` or `apiKmsKey` must also be set.");
    }
    if (props.extensionLayerVersion !== undefined) {
        if (props.apiKey === undefined && props.apiKmsKey === undefined) {
            throw new Error("When `extensionLayer` is set, `apiKey` or `apiKmsKey` must also be set.");
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YWRvZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9kYXRhZG9nLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBVUEscUNBQXFDO0FBQ3JDLHVDQUEyQjtBQUMzQixtQ0FBa0g7QUFDbEgsMkNBQXdDO0FBQ3hDLE1BQU0sV0FBVyxHQUFHLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0FBa0IvQyxJQUFLLE9BRUo7QUFGRCxXQUFLLE9BQU87SUFDVixtQ0FBd0IsQ0FBQTtBQUMxQixDQUFDLEVBRkksT0FBTyxLQUFQLE9BQU8sUUFFWDtBQUVZLFFBQUEsWUFBWSxHQUFHO0lBQzFCLFNBQVMsRUFBRSxJQUFJO0lBQ2Ysb0JBQW9CLEVBQUUsSUFBSTtJQUMxQixnQkFBZ0IsRUFBRSxJQUFJO0lBQ3RCLGlCQUFpQixFQUFFLElBQUk7Q0FDeEIsQ0FBQzs7OztBQUVGLE1BQWEsT0FBUSxTQUFRLEdBQUcsQ0FBQyxTQUFTOzs7O0lBSXhDLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBbUI7UUFDL0QsSUFBSSxPQUFPLENBQUMsR0FBRyxDQUFDLHVCQUF1QixJQUFJLE1BQU07WUFBRSxrQkFBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN6RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLGFBQWEsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDMUIsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLHFCQUFTLENBQzVCLElBQUksQ0FBQyxLQUFLLENBQUMsa0JBQWtCLEVBQzdCLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUNmLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUNqQixJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFDcEIsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FDakMsQ0FBQztJQUNKLENBQUM7Ozs7SUFFTSxrQkFBa0IsQ0FBQyxlQUFrQztRQUMxRCxJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNyQyxJQUFJLG9CQUFvQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLENBQUM7UUFDM0QsSUFBSSxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQ25ELE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQ3JDLElBQUksaUJBQWlCLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUVyRCxJQUFJLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDM0Isa0JBQUcsQ0FBQyxLQUFLLENBQUMsa0RBQWtELG9CQUFZLENBQUMsU0FBUyxFQUFFLENBQUMsQ0FBQztZQUN0RixTQUFTLEdBQUcsb0JBQVksQ0FBQyxTQUFTLENBQUM7U0FDcEM7UUFDRCxJQUFJLG9CQUFvQixLQUFLLFNBQVMsRUFBRTtZQUN0QyxrQkFBRyxDQUFDLEtBQUssQ0FBQyw2REFBNkQsb0JBQVksQ0FBQyxvQkFBb0IsRUFBRSxDQUFDLENBQUM7WUFDNUcsb0JBQW9CLEdBQUcsb0JBQVksQ0FBQyxvQkFBb0IsQ0FBQztTQUMxRDtRQUNELElBQUksZ0JBQWdCLEtBQUssU0FBUyxFQUFFO1lBQ2xDLGtCQUFHLENBQUMsS0FBSyxDQUFDLHlEQUF5RCxvQkFBWSxDQUFDLGdCQUFnQixFQUFFLENBQUMsQ0FBQztZQUNwRyxnQkFBZ0IsR0FBRyxvQkFBWSxDQUFDLGdCQUFnQixDQUFDO1NBQ2xEO1FBQ0QsSUFBSSxRQUFRLEtBQUssU0FBUyxFQUFFO1lBQzFCLGtCQUFHLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7U0FDN0M7UUFDRCxJQUFJLGlCQUFpQixLQUFLLFNBQVMsRUFBRTtZQUNuQyxrQkFBRyxDQUFDLEtBQUssQ0FBQywwREFBMEQsb0JBQVksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLENBQUM7WUFDdEcsaUJBQWlCLEdBQUcsb0JBQVksQ0FBQyxpQkFBaUIsQ0FBQztTQUNwRDtRQUVELElBQUksSUFBSSxDQUFDLEtBQUssS0FBSyxTQUFTLElBQUksZUFBZSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDMUQsTUFBTSxNQUFNLEdBQUcsR0FBRyxlQUFlLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFDO1lBQ2xELGtCQUFHLENBQUMsS0FBSyxDQUFDLGlCQUFpQixNQUFNLEVBQUUsQ0FBQyxDQUFDO1lBQ3JDLG1CQUFXLENBQ1QsSUFBSSxDQUFDLEtBQUssRUFDVixNQUFNLEVBQ04sZUFBZSxFQUNmLElBQUksQ0FBQyxLQUFLLENBQUMsa0JBQWtCLEVBQzdCLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLEVBQzNCLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCLENBQ2pDLENBQUM7WUFDRix3QkFBZ0IsQ0FBQyxlQUFlLEVBQUUsU0FBUyxDQUFDLENBQUM7WUFFN0MsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksS0FBSyxTQUFTLEVBQUU7Z0JBQ3pDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsS0FBSyxTQUFTLEVBQUU7b0JBQ2xELGtCQUFHLENBQUMsS0FBSyxDQUFDLHVGQUF1RixDQUFDLENBQUM7aUJBQ3BHO3FCQUFNO29CQUNMLGtCQUFHLENBQUMsS0FBSyxDQUFDLDBEQUEwRCxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRSxDQUFDLENBQUM7b0JBQy9GLG9CQUFZLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxlQUFlLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQztpQkFDcEU7YUFDRjtpQkFBTTtnQkFDTCxrQkFBRyxDQUFDLEtBQUssQ0FBQyxzRUFBc0UsQ0FBQyxDQUFDO2FBQ25GO1lBRUQseUJBQXlCLENBQUMsZUFBZSxDQUFDLENBQUM7WUFFM0MseUJBQWlCLENBQUMsZUFBZSxFQUFFLG9CQUFvQixFQUFFLGdCQUFnQixFQUFFLGlCQUFpQixFQUFFLFFBQVEsQ0FBQyxDQUFDO1lBQ3hHLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1NBQzlDO0lBQ0gsQ0FBQzs7OztJQUVNLGdDQUFnQyxDQUFDLFNBQTJCO1FBQ2pFLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLEtBQUssU0FBUyxFQUFFO1lBQ3pDLCtCQUF1QixDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLENBQUM7U0FDekU7YUFBTTtZQUNMLGtCQUFHLENBQUMsS0FBSyxDQUFDLGlGQUFpRixDQUFDLENBQUM7U0FDOUY7SUFDSCxDQUFDOztBQW5GSCwwQkFvRkM7OztBQUVELFNBQWdCLHlCQUF5QixDQUFDLGVBQWtDO0lBQzFFLGtCQUFHLENBQUMsS0FBSyxDQUFDLHFDQUFxQyxXQUFXLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQztJQUN0RSxlQUFlLENBQUMsT0FBTyxDQUFDLENBQUMsWUFBWSxFQUFFLEVBQUU7UUFDdkMsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsSUFBSSxXQUFXLENBQUMsT0FBTyxFQUFFLEVBQUU7WUFDcEUsb0JBQW9CLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQztTQUNoRCxDQUFDLENBQUM7SUFDTCxDQUFDLENBQUMsQ0FBQztBQUNMLENBQUM7QUFQRCw4REFPQztBQUVELFNBQVMsYUFBYSxDQUFDLEtBQW1CO0lBQ3hDLGtCQUFHLENBQUMsS0FBSyxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDakMsTUFBTSxRQUFRLEdBQWEsQ0FBQyxlQUFlLEVBQUUsY0FBYyxFQUFFLG1CQUFtQixFQUFFLGNBQWMsQ0FBQyxDQUFDO0lBQ2xHLElBQUksS0FBSyxDQUFDLE1BQU0sS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7UUFDL0QsTUFBTSxJQUFJLEtBQUssQ0FBQyw4Q0FBOEMsQ0FBQyxDQUFDO0tBQ2pFO0lBRUQsSUFBSSxLQUFLLENBQUMsSUFBSSxLQUFLLFNBQVMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQyxFQUFFO1FBQzVFLE1BQU0sSUFBSSxLQUFLLENBQ2IsNEdBQTRHLENBQzdHLENBQUM7S0FDSDtJQUVELElBQUksS0FBSyxDQUFDLE1BQU0sS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLFNBQVMsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLGtCQUFrQixLQUFLLEtBQUssRUFBRTtRQUNyRyxNQUFNLElBQUksS0FBSyxDQUFDLCtFQUErRSxDQUFDLENBQUM7S0FDbEc7SUFDRCxJQUFJLEtBQUssQ0FBQyxxQkFBcUIsS0FBSyxTQUFTLEVBQUU7UUFDN0MsSUFBSSxLQUFLLENBQUMsTUFBTSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsU0FBUyxLQUFLLFNBQVMsRUFBRTtZQUMvRCxNQUFNLElBQUksS0FBSyxDQUFDLHlFQUF5RSxDQUFDLENBQUM7U0FDNUY7S0FDRjtBQUNILENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogVW5sZXNzIGV4cGxpY2l0bHkgc3RhdGVkIG90aGVyd2lzZSBhbGwgZmlsZXMgaW4gdGhpcyByZXBvc2l0b3J5IGFyZSBsaWNlbnNlZFxuICogdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlIFZlcnNpb24gMi4wLlxuICpcbiAqIFRoaXMgcHJvZHVjdCBpbmNsdWRlcyBzb2Z0d2FyZSBkZXZlbG9wZWQgYXQgRGF0YWRvZyAoaHR0cHM6Ly93d3cuZGF0YWRvZ2hxLmNvbS8pLlxuICogQ29weXJpZ2h0IDIwMjEgRGF0YWRvZywgSW5jLlxuICovXG5cbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tIFwiQGF3cy1jZGsvYXdzLWxhbWJkYVwiO1xuaW1wb3J0ICogYXMgbG9ncyBmcm9tIFwiQGF3cy1jZGsvYXdzLWxvZ3NcIjtcbmltcG9ydCAqIGFzIGNkayBmcm9tIFwiQGF3cy1jZGsvY29yZVwiO1xuaW1wb3J0IGxvZyBmcm9tIFwibG9nbGV2ZWxcIjtcbmltcG9ydCB7IGFwcGx5TGF5ZXJzLCByZWRpcmVjdEhhbmRsZXJzLCBhZGRGb3J3YXJkZXIsIGFkZEZvcndhcmRlclRvTG9nR3JvdXBzLCBhcHBseUVudlZhcmlhYmxlcyB9IGZyb20gXCIuL2luZGV4XCI7XG5pbXBvcnQgeyBUcmFuc3BvcnQgfSBmcm9tIFwiLi90cmFuc3BvcnRcIjtcbmNvbnN0IHZlcnNpb25Kc29uID0gcmVxdWlyZShcIi4uL3ZlcnNpb24uanNvblwiKTtcblxuZXhwb3J0IGludGVyZmFjZSBEYXRhZG9nUHJvcHMge1xuICByZWFkb25seSBweXRob25MYXllclZlcnNpb24/OiBudW1iZXI7XG4gIHJlYWRvbmx5IG5vZGVMYXllclZlcnNpb24/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGV4dGVuc2lvbkxheWVyVmVyc2lvbj86IG51bWJlcjtcbiAgcmVhZG9ubHkgYWRkTGF5ZXJzPzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgZm9yd2FyZGVyQXJuPzogc3RyaW5nO1xuICByZWFkb25seSBmbHVzaE1ldHJpY3NUb0xvZ3M/OiBib29sZWFuO1xuICByZWFkb25seSBzaXRlPzogc3RyaW5nO1xuICByZWFkb25seSBhcGlLZXk/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGFwaUttc0tleT86IHN0cmluZztcbiAgcmVhZG9ubHkgZW5hYmxlRGF0YWRvZ1RyYWNpbmc/OiBib29sZWFuO1xuICByZWFkb25seSBpbmplY3RMb2dDb250ZXh0PzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgbG9nTGV2ZWw/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGVuYWJsZURhdGFkb2dMb2dzPzogYm9vbGVhbjtcbn1cblxuZW51bSBUYWdLZXlzIHtcbiAgQ2RrID0gXCJkZF9jZGtfY29uc3RydWN0XCIsXG59XG5cbmV4cG9ydCBjb25zdCBkZWZhdWx0UHJvcHMgPSB7XG4gIGFkZExheWVyczogdHJ1ZSxcbiAgZW5hYmxlRGF0YWRvZ1RyYWNpbmc6IHRydWUsXG4gIGluamVjdExvZ0NvbnRleHQ6IHRydWUsXG4gIGVuYWJsZURhdGFkb2dMb2dzOiB0cnVlLFxufTtcblxuZXhwb3J0IGNsYXNzIERhdGFkb2cgZXh0ZW5kcyBjZGsuQ29uc3RydWN0IHtcbiAgc2NvcGU6IGNkay5Db25zdHJ1Y3Q7XG4gIHByb3BzOiBEYXRhZG9nUHJvcHM7XG4gIHRyYW5zcG9ydDogVHJhbnNwb3J0O1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERhdGFkb2dQcm9wcykge1xuICAgIGlmIChwcm9jZXNzLmVudi5ERF9DT05TVFJVQ1RfREVCVUdfTE9HUyA9PSBcInRydWVcIikgbG9nLnNldExldmVsKFwiZGVidWdcIik7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICB0aGlzLnNjb3BlID0gc2NvcGU7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICAgIHZhbGlkYXRlUHJvcHModGhpcy5wcm9wcyk7XG4gICAgdGhpcy50cmFuc3BvcnQgPSBuZXcgVHJhbnNwb3J0KFxuICAgICAgdGhpcy5wcm9wcy5mbHVzaE1ldHJpY3NUb0xvZ3MsXG4gICAgICB0aGlzLnByb3BzLnNpdGUsXG4gICAgICB0aGlzLnByb3BzLmFwaUtleSxcbiAgICAgIHRoaXMucHJvcHMuYXBpS21zS2V5LFxuICAgICAgdGhpcy5wcm9wcy5leHRlbnNpb25MYXllclZlcnNpb24sXG4gICAgKTtcbiAgfVxuXG4gIHB1YmxpYyBhZGRMYW1iZGFGdW5jdGlvbnMobGFtYmRhRnVuY3Rpb25zOiBsYW1iZGEuRnVuY3Rpb25bXSkge1xuICAgIGxldCBhZGRMYXllcnMgPSB0aGlzLnByb3BzLmFkZExheWVycztcbiAgICBsZXQgZW5hYmxlRGF0YWRvZ1RyYWNpbmcgPSB0aGlzLnByb3BzLmVuYWJsZURhdGFkb2dUcmFjaW5nO1xuICAgIGxldCBpbmplY3RMb2dDb250ZXh0ID0gdGhpcy5wcm9wcy5pbmplY3RMb2dDb250ZXh0O1xuICAgIGNvbnN0IGxvZ0xldmVsID0gdGhpcy5wcm9wcy5sb2dMZXZlbDtcbiAgICBsZXQgZW5hYmxlRGF0YWRvZ0xvZ3MgPSB0aGlzLnByb3BzLmVuYWJsZURhdGFkb2dMb2dzO1xuXG4gICAgaWYgKGFkZExheWVycyA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICBsb2cuZGVidWcoYE5vIHZhbHVlIHByb3ZpZGVkIGZvciBhZGRMYXllcnMsIGRlZmF1bHRpbmcgdG8gJHtkZWZhdWx0UHJvcHMuYWRkTGF5ZXJzfWApO1xuICAgICAgYWRkTGF5ZXJzID0gZGVmYXVsdFByb3BzLmFkZExheWVycztcbiAgICB9XG4gICAgaWYgKGVuYWJsZURhdGFkb2dUcmFjaW5nID09PSB1bmRlZmluZWQpIHtcbiAgICAgIGxvZy5kZWJ1ZyhgTm8gdmFsdWUgcHJvdmlkZWQgZm9yIGVuYWJsZURhdGFkb2dUcmFjaW5nLCBkZWZhdWx0aW5nIHRvICR7ZGVmYXVsdFByb3BzLmVuYWJsZURhdGFkb2dUcmFjaW5nfWApO1xuICAgICAgZW5hYmxlRGF0YWRvZ1RyYWNpbmcgPSBkZWZhdWx0UHJvcHMuZW5hYmxlRGF0YWRvZ1RyYWNpbmc7XG4gICAgfVxuICAgIGlmIChpbmplY3RMb2dDb250ZXh0ID09PSB1bmRlZmluZWQpIHtcbiAgICAgIGxvZy5kZWJ1ZyhgTm8gdmFsdWUgcHJvdmlkZWQgZm9yIGluamVjdExvZ0NvbnRleHQsIGRlZmF1bHRpbmcgdG8gJHtkZWZhdWx0UHJvcHMuaW5qZWN0TG9nQ29udGV4dH1gKTtcbiAgICAgIGluamVjdExvZ0NvbnRleHQgPSBkZWZhdWx0UHJvcHMuaW5qZWN0TG9nQ29udGV4dDtcbiAgICB9XG4gICAgaWYgKGxvZ0xldmVsID09PSB1bmRlZmluZWQpIHtcbiAgICAgIGxvZy5kZWJ1ZyhgTm8gdmFsdWUgcHJvdmlkZWQgZm9yIGxvZ0xldmVsYCk7XG4gICAgfVxuICAgIGlmIChlbmFibGVEYXRhZG9nTG9ncyA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICBsb2cuZGVidWcoYE5vIHZhbHVlIHByb3ZpZGVkIGZvciBlbmFibGVEYXRhZG9nTG9ncywgZGVmYXVsdGluZyB0byAke2RlZmF1bHRQcm9wcy5lbmFibGVEYXRhZG9nTG9nc31gKTtcbiAgICAgIGVuYWJsZURhdGFkb2dMb2dzID0gZGVmYXVsdFByb3BzLmVuYWJsZURhdGFkb2dMb2dzO1xuICAgIH1cblxuICAgIGlmICh0aGlzLnByb3BzICE9PSB1bmRlZmluZWQgJiYgbGFtYmRhRnVuY3Rpb25zLmxlbmd0aCA+IDApIHtcbiAgICAgIGNvbnN0IHJlZ2lvbiA9IGAke2xhbWJkYUZ1bmN0aW9uc1swXS5lbnYucmVnaW9ufWA7XG4gICAgICBsb2cuZGVidWcoYFVzaW5nIHJlZ2lvbjogJHtyZWdpb259YCk7XG4gICAgICBhcHBseUxheWVycyhcbiAgICAgICAgdGhpcy5zY29wZSxcbiAgICAgICAgcmVnaW9uLFxuICAgICAgICBsYW1iZGFGdW5jdGlvbnMsXG4gICAgICAgIHRoaXMucHJvcHMucHl0aG9uTGF5ZXJWZXJzaW9uLFxuICAgICAgICB0aGlzLnByb3BzLm5vZGVMYXllclZlcnNpb24sXG4gICAgICAgIHRoaXMucHJvcHMuZXh0ZW5zaW9uTGF5ZXJWZXJzaW9uLFxuICAgICAgKTtcbiAgICAgIHJlZGlyZWN0SGFuZGxlcnMobGFtYmRhRnVuY3Rpb25zLCBhZGRMYXllcnMpO1xuXG4gICAgICBpZiAodGhpcy5wcm9wcy5mb3J3YXJkZXJBcm4gIT09IHVuZGVmaW5lZCkge1xuICAgICAgICBpZiAodGhpcy5wcm9wcy5leHRlbnNpb25MYXllclZlcnNpb24gIT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgIGxvZy5kZWJ1ZyhgU2tpcHBpbmcgYWRkaW5nIHN1YnNjcmlwdGlvbnMgdG8gdGhlIGxhbWJkYSBsb2cgZ3JvdXBzIHNpbmNlIHRoZSBleHRlbnNpb24gaXMgZW5hYmxlZGApO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGxvZy5kZWJ1ZyhgQWRkaW5nIGxvZyBzdWJzY3JpcHRpb25zIHVzaW5nIHByb3ZpZGVkIEZvcndhcmRlciBBUk46ICR7dGhpcy5wcm9wcy5mb3J3YXJkZXJBcm59YCk7XG4gICAgICAgICAgYWRkRm9yd2FyZGVyKHRoaXMuc2NvcGUsIGxhbWJkYUZ1bmN0aW9ucywgdGhpcy5wcm9wcy5mb3J3YXJkZXJBcm4pO1xuICAgICAgICB9XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBsb2cuZGVidWcoXCJGb3J3YXJkZXIgQVJOIG5vdCBwcm92aWRlZCwgbm8gbG9nIGdyb3VwIHN1YnNjcmlwdGlvbnMgd2lsbCBiZSBhZGRlZFwiKTtcbiAgICAgIH1cblxuICAgICAgYWRkQ2RrQ29uc3RydWN0VmVyc2lvblRhZyhsYW1iZGFGdW5jdGlvbnMpO1xuXG4gICAgICBhcHBseUVudlZhcmlhYmxlcyhsYW1iZGFGdW5jdGlvbnMsIGVuYWJsZURhdGFkb2dUcmFjaW5nLCBpbmplY3RMb2dDb250ZXh0LCBlbmFibGVEYXRhZG9nTG9ncywgbG9nTGV2ZWwpO1xuICAgICAgdGhpcy50cmFuc3BvcnQuYXBwbHlFbnZWYXJzKGxhbWJkYUZ1bmN0aW9ucyk7XG4gICAgfVxuICB9XG5cbiAgcHVibGljIGFkZEZvcndhcmRlclRvTm9uTGFtYmRhTG9nR3JvdXBzKGxvZ0dyb3VwczogbG9ncy5JTG9nR3JvdXBbXSkge1xuICAgIGlmICh0aGlzLnByb3BzLmZvcndhcmRlckFybiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBhZGRGb3J3YXJkZXJUb0xvZ0dyb3Vwcyh0aGlzLnNjb3BlLCBsb2dHcm91cHMsIHRoaXMucHJvcHMuZm9yd2FyZGVyQXJuKTtcbiAgICB9IGVsc2Uge1xuICAgICAgbG9nLmRlYnVnKFwiRm9yd2FyZGVyIEFSTiBub3QgcHJvdmlkZWQsIG5vIG5vbiBsYW1iZGEgbG9nIGdyb3VwIHN1YnNjcmlwdGlvbnMgd2lsbCBiZSBhZGRlZFwiKTtcbiAgICB9XG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGFkZENka0NvbnN0cnVjdFZlcnNpb25UYWcobGFtYmRhRnVuY3Rpb25zOiBsYW1iZGEuRnVuY3Rpb25bXSkge1xuICBsb2cuZGVidWcoYEFkZGluZyBDREsgQ29uc3RydWN0IHZlcnNpb24gdGFnOiAke3ZlcnNpb25Kc29uLnZlcnNpb259YCk7XG4gIGxhbWJkYUZ1bmN0aW9ucy5mb3JFYWNoKChmdW5jdGlvbk5hbWUpID0+IHtcbiAgICBjZGsuVGFncy5vZihmdW5jdGlvbk5hbWUpLmFkZChUYWdLZXlzLkNkaywgYHYke3ZlcnNpb25Kc29uLnZlcnNpb259YCwge1xuICAgICAgaW5jbHVkZVJlc291cmNlVHlwZXM6IFtcIkFXUzo6TGFtYmRhOjpGdW5jdGlvblwiXSxcbiAgICB9KTtcbiAgfSk7XG59XG5cbmZ1bmN0aW9uIHZhbGlkYXRlUHJvcHMocHJvcHM6IERhdGFkb2dQcm9wcykge1xuICBsb2cuZGVidWcoXCJWYWxpZGF0aW5nIHByb3BzLi4uXCIpO1xuICBjb25zdCBzaXRlTGlzdDogc3RyaW5nW10gPSBbXCJkYXRhZG9naHEuY29tXCIsIFwiZGF0YWRvZ2hxLmV1XCIsIFwidXMzLmRhdGFkb2docS5jb21cIiwgXCJkZG9nLWdvdi5jb21cIl07XG4gIGlmIChwcm9wcy5hcGlLZXkgIT09IHVuZGVmaW5lZCAmJiBwcm9wcy5hcGlLbXNLZXkgIT09IHVuZGVmaW5lZCkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkJvdGggYGFwaUtleWAgYW5kIGBhcGlLbXNLZXlgIGNhbm5vdCBiZSBzZXQuXCIpO1xuICB9XG5cbiAgaWYgKHByb3BzLnNpdGUgIT09IHVuZGVmaW5lZCAmJiAhc2l0ZUxpc3QuaW5jbHVkZXMocHJvcHMuc2l0ZS50b0xvd2VyQ2FzZSgpKSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgIFwiV2FybmluZzogSW52YWxpZCBzaXRlIFVSTC4gTXVzdCBiZSBlaXRoZXIgZGF0YWRvZ2hxLmNvbSwgZGF0YWRvZ2hxLmV1LCB1czMuZGF0YWRvZ2hxLmNvbSwgb3IgZGRvZy1nb3YuY29tLlwiLFxuICAgICk7XG4gIH1cblxuICBpZiAocHJvcHMuYXBpS2V5ID09PSB1bmRlZmluZWQgJiYgcHJvcHMuYXBpS21zS2V5ID09PSB1bmRlZmluZWQgJiYgcHJvcHMuZmx1c2hNZXRyaWNzVG9Mb2dzID09PSBmYWxzZSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIldoZW4gYGZsdXNoTWV0cmljc1RvTG9nc2AgaXMgZmFsc2UsIGBhcGlLZXlgIG9yIGBhcGlLbXNLZXlgIG11c3QgYWxzbyBiZSBzZXQuXCIpO1xuICB9XG4gIGlmIChwcm9wcy5leHRlbnNpb25MYXllclZlcnNpb24gIT09IHVuZGVmaW5lZCkge1xuICAgIGlmIChwcm9wcy5hcGlLZXkgPT09IHVuZGVmaW5lZCAmJiBwcm9wcy5hcGlLbXNLZXkgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFwiV2hlbiBgZXh0ZW5zaW9uTGF5ZXJgIGlzIHNldCwgYGFwaUtleWAgb3IgYGFwaUttc0tleWAgbXVzdCBhbHNvIGJlIHNldC5cIik7XG4gICAgfVxuICB9XG59XG4iXX0=