"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
import typing  # noqa: F401

import asyncio

from rockset.api_client import ApiClient, Endpoint as _Endpoint
from rockset.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from rockset.model.create_query_lambda_request import CreateQueryLambdaRequest
from rockset.model.create_query_lambda_tag_request import CreateQueryLambdaTagRequest
from rockset.model.delete_query_lambda_response import DeleteQueryLambdaResponse
from rockset.model.error_model import ErrorModel
from rockset.model.execute_query_lambda_request import ExecuteQueryLambdaRequest
from rockset.model.list_query_lambda_tags_response import ListQueryLambdaTagsResponse
from rockset.model.list_query_lambda_versions_response import ListQueryLambdaVersionsResponse
from rockset.model.list_query_lambdas_response import ListQueryLambdasResponse
from rockset.model.query_lambda_tag_response import QueryLambdaTagResponse
from rockset.model.query_lambda_version_response import QueryLambdaVersionResponse
from rockset.model.query_response import QueryResponse
from rockset.model.update_query_lambda_request import UpdateQueryLambdaRequest
from rockset.models import *


class QueryLambdas(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_query_lambda_endpoint = _Endpoint(
            settings={
                'response_type': (QueryLambdaVersionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas'.split('#')[0],
                'operation_id': 'create_query_lambda',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'create_query_lambda_request',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'create_query_lambda_request':
                        (CreateQueryLambdaRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                    'create_query_lambda_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_query_lambda_tag_endpoint = _Endpoint(
            settings={
                'response_type': (QueryLambdaTagResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags'.split('#')[0],
                'operation_id': 'create_query_lambda_tag',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                    'create_query_lambda_tag_request',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                    'create_query_lambda_tag_request':
                        (CreateQueryLambdaTagRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                    'create_query_lambda_tag_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_query_lambda_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteQueryLambdaResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}'.split('#')[0],
                'operation_id': 'delete_query_lambda',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_query_lambda_tag_endpoint = _Endpoint(
            settings={
                'response_type': (QueryLambdaTagResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag}'.split('#')[0],
                'operation_id': 'delete_query_lambda_tag',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                    'tag',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                    'tag',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                    'tag':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                    'tag': 'tag',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                    'tag': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_query_lambda_version_endpoint = _Endpoint(
            settings={
                'response_type': (QueryLambdaVersionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/version/{version}'.split('#')[0],
                'operation_id': 'delete_query_lambda_version',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                    'version',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                    'version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                    'version':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                    'version': 'version',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                    'version': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.execute_query_lambda_endpoint = _Endpoint(
            settings={
                'response_type': (QueryResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions/{version}'.split('#')[0],
                'operation_id': 'execute_query_lambda',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                    'version',
                    'execute_query_lambda_request',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                    'version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                    'version':
                        (str,),
                    'execute_query_lambda_request':
                        (ExecuteQueryLambdaRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                    'version': 'version',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                    'version': 'path',
                    'execute_query_lambda_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.execute_query_lambda_by_tag_endpoint = _Endpoint(
            settings={
                'response_type': (QueryResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag}'.split('#')[0],
                'operation_id': 'execute_query_lambda_by_tag',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                    'tag',
                    'execute_query_lambda_request',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                    'tag',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                    'tag':
                        (str,),
                    'execute_query_lambda_request':
                        (ExecuteQueryLambdaRequest,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                    'tag': 'tag',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                    'tag': 'path',
                    'execute_query_lambda_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_query_lambda_tag_version_endpoint = _Endpoint(
            settings={
                'response_type': (QueryLambdaTagResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags/{tag}'.split('#')[0],
                'operation_id': 'get_query_lambda_tag_version',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                    'tag',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                    'tag',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                    'tag':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                    'tag': 'tag',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                    'tag': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_query_lambda_version_endpoint = _Endpoint(
            settings={
                'response_type': (QueryLambdaVersionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions/{version}'.split('#')[0],
                'operation_id': 'get_query_lambda_version',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                    'version',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                    'version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                    'version':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                    'version': 'version',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                    'version': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_all_query_lambdas_endpoint = _Endpoint(
            settings={
                'response_type': (ListQueryLambdasResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/lambdas'.split('#')[0],
                'operation_id': 'list_all_query_lambdas',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_query_lambda_tags_endpoint = _Endpoint(
            settings={
                'response_type': (ListQueryLambdaTagsResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/tags'.split('#')[0],
                'operation_id': 'list_query_lambda_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_query_lambda_versions_endpoint = _Endpoint(
            settings={
                'response_type': (ListQueryLambdaVersionsResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions'.split('#')[0],
                'operation_id': 'list_query_lambda_versions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_query_lambdas_in_workspace_endpoint = _Endpoint(
            settings={
                'response_type': (ListQueryLambdasResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas'.split('#')[0],
                'operation_id': 'list_query_lambdas_in_workspace',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                ],
                'required': [
                    'workspace',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                },
                'location_map': {
                    'workspace': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_query_lambda_endpoint = _Endpoint(
            settings={
                'response_type': (QueryLambdaVersionResponse,),
                'auth': [
                    'apikey'
                ],
                'endpoint_path': '/v1/orgs/self/ws/{workspace}/lambdas/{queryLambda}/versions'.split('#')[0],
                'operation_id': 'update_query_lambda',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace',
                    'query_lambda',
                    'update_query_lambda_request',
                    'create',
                ],
                'required': [
                    'workspace',
                    'query_lambda',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace':
                        (str,),
                    'query_lambda':
                        (str,),
                    'update_query_lambda_request':
                        (UpdateQueryLambdaRequest,),
                    'create':
                        (bool,),
                },
                'attribute_map': {
                    'workspace': 'workspace',
                    'query_lambda': 'queryLambda',
                    'create': 'create',
                },
                'location_map': {
                    'workspace': 'path',
                    'query_lambda': 'path',
                    'update_query_lambda_request': 'body',
                    'create': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_query_lambda(
        self,
        *,
        name: str,
        description: str = None,
        sql: QueryLambdaSql = None,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[QueryLambdaVersionResponse, asyncio.Future]:
        """Create Query Lambda  # noqa: E501

        Create a Query Lambda in given workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.create_query_lambda(
            description="production version foo",
            name="myQueryLambda",
            sql=QueryLambdaSql(
                default_parameters=[
                    QueryParameter(
                        name="_id",
                        type="string",
                        value="85beb391",
                    ),
                ],
                query="SELECT 'Foo'",
            ),
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            description (str): optional description. [optional]
            name (str): Query Lambda name. [required]
            sql (QueryLambdaSql): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueryLambdaVersionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['create_query_lambda_request'] = \
            kwargs['create_query_lambda_request']
        return self.create_query_lambda_endpoint.call_with_http_info(**kwargs)

    def create_query_lambda_tag(
        self,
        *,
        query_lambda: str,
        tag_name: str,
        version: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[QueryLambdaTagResponse, asyncio.Future]:
        """Create Query Lambda Tag  # noqa: E501

        Create a tag for a specific Query Lambda version, or update that tag if it already exists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.create_query_lambda_tag(
            query_lambda="queryLambda_example",
            tag_name="production",
            version="123ABC",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            tag_name (str): name of Query Lambda tag. [required]
            version (str): hash identifying a Query Lambda tag. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueryLambdaTagResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        kwargs['create_query_lambda_tag_request'] = \
            kwargs['create_query_lambda_tag_request']
        return self.create_query_lambda_tag_endpoint.call_with_http_info(**kwargs)

    def delete_query_lambda(
        self,
        *,
        query_lambda: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[DeleteQueryLambdaResponse, asyncio.Future]:
        """Delete Query Lambda  # noqa: E501

        Delete a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.delete_query_lambda(
            query_lambda="queryLambda_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            DeleteQueryLambdaResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        return self.delete_query_lambda_endpoint.call_with_http_info(**kwargs)

    def delete_query_lambda_tag(
        self,
        *,
        query_lambda: str,
        tag: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[QueryLambdaTagResponse, asyncio.Future]:
        """Delete Query Lambda Tag Version  # noqa: E501

        Delete a tag for a specific Query Lambda  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.delete_query_lambda_tag(
            query_lambda="queryLambda_example",
            tag="tag_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            tag (str): name of the tag. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueryLambdaTagResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        kwargs['tag'] = \
            tag
        return self.delete_query_lambda_tag_endpoint.call_with_http_info(**kwargs)

    def delete_query_lambda_version(
        self,
        *,
        query_lambda: str,
        version: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[QueryLambdaVersionResponse, asyncio.Future]:
        """Delete Query Lambda Version  # noqa: E501

        Delete a Query Lambda version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.delete_query_lambda_version(
            query_lambda="queryLambda_example",
            version="version_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            version (str): version. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueryLambdaVersionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        kwargs['version'] = \
            version
        return self.delete_query_lambda_version_endpoint.call_with_http_info(**kwargs)

    def execute_query_lambda(
        self,
        *,
        query_lambda: str,
        version: str,
        workspace = "commons",
        execute_query_lambda_request: ExecuteQueryLambdaRequest = None,
        **kwargs
    ) -> typing.Union[QueryResponse, asyncio.Future]:
        """Execute Query Lambda By Version  # noqa: E501

        Execute a particular version of a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.execute_query_lambda(
            query_lambda="queryLambda_example",
            version="version_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            version (str): version. [required]
            execute_query_lambda_request (ExecuteQueryLambdaRequest): JSON object. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueryResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        kwargs['version'] = \
            version
        return self.execute_query_lambda_endpoint.call_with_http_info(**kwargs)

    def execute_query_lambda_by_tag(
        self,
        *,
        query_lambda: str,
        tag: str,
        workspace = "commons",
        execute_query_lambda_request: ExecuteQueryLambdaRequest = None,
        **kwargs
    ) -> typing.Union[QueryResponse, asyncio.Future]:
        """Execute Query Lambda By Tag  # noqa: E501

        Execute the Query Lambda version associated with a given tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.execute_query_lambda_by_tag(
            query_lambda="queryLambda_example",
            tag="tag_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            tag (str): tag. [required]
            execute_query_lambda_request (ExecuteQueryLambdaRequest): JSON object. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueryResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        kwargs['tag'] = \
            tag
        return self.execute_query_lambda_by_tag_endpoint.call_with_http_info(**kwargs)

    def get_query_lambda_tag_version(
        self,
        *,
        query_lambda: str,
        tag: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[QueryLambdaTagResponse, asyncio.Future]:
        """Retrieve Query Lambda Tag  # noqa: E501

        Retrieve the Query Lambda version associated with a given tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.get_query_lambda_tag_version(
            query_lambda="queryLambda_example",
            tag="tag_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            tag (str): name of the tag. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueryLambdaTagResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        kwargs['tag'] = \
            tag
        return self.get_query_lambda_tag_version_endpoint.call_with_http_info(**kwargs)

    def get_query_lambda_version(
        self,
        *,
        query_lambda: str,
        version: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[QueryLambdaVersionResponse, asyncio.Future]:
        """Retrieve Query Lambda Version  # noqa: E501

        Retrieve details for a specified version of a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.get_query_lambda_version(
            query_lambda="queryLambda_example",
            version="version_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            version (str): version. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueryLambdaVersionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        kwargs['version'] = \
            version
        return self.get_query_lambda_version_endpoint.call_with_http_info(**kwargs)

    def list_all_query_lambdas(
        self,
        **kwargs
    ) -> typing.Union[ListQueryLambdasResponse, asyncio.Future]:
        """List Query Lambdas  # noqa: E501

        List all Query Lambdas in an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.list_all_query_lambdas(
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListQueryLambdasResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_all_query_lambdas_endpoint.call_with_http_info(**kwargs)

    def list_query_lambda_tags(
        self,
        *,
        query_lambda: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[ListQueryLambdaTagsResponse, asyncio.Future]:
        """List Query Lambda Tags  # noqa: E501

        List all tags associated with a Query Lambda  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.list_query_lambda_tags(
            query_lambda="queryLambda_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListQueryLambdaTagsResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        return self.list_query_lambda_tags_endpoint.call_with_http_info(**kwargs)

    def list_query_lambda_versions(
        self,
        *,
        query_lambda: str,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[ListQueryLambdaVersionsResponse, asyncio.Future]:
        """List Query Lambda Versions  # noqa: E501

        List all versions of a Query Lambda.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.list_query_lambda_versions(
            query_lambda="queryLambda_example",
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListQueryLambdaVersionsResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        return self.list_query_lambda_versions_endpoint.call_with_http_info(**kwargs)

    def list_query_lambdas_in_workspace(
        self,
        *,
        workspace = "commons",
        **kwargs
    ) -> typing.Union[ListQueryLambdasResponse, asyncio.Future]:
        """List Query Lambdas in Workspace  # noqa: E501

        List all Query Lambdas under given workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.list_query_lambdas_in_workspace(
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListQueryLambdasResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        return self.list_query_lambdas_in_workspace_endpoint.call_with_http_info(**kwargs)

    def update_query_lambda(
        self,
        *,
        query_lambda: str,
        description: str = None,
        sql: QueryLambdaSql = None,
        workspace = "commons",
        create: bool = None,
        **kwargs
    ) -> typing.Union[QueryLambdaVersionResponse, asyncio.Future]:
        """Update Query Lambda  # noqa: E501

        Create a new version of a Query Lambda in given workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        ```python
        rs = RocksetClient(api_key=APIKEY)
        future = rs.QueryLambdas.update_query_lambda(
            query_lambda="queryLambda_example",
            description="production version foo",
            sql=QueryLambdaSql(
                default_parameters=[
                    QueryParameter(
                        name="_id",
                        type="string",
                        value="85beb391",
                    ),
                ],
                query="SELECT 'Foo'",
            ),
            async_req=True,
        )
        result = await future
        ```

        Keyword Args:
            workspace (str): name of the workspace. [required] if omitted the server will use the default value of "commons"
            query_lambda (str): name of the Query Lambda. [required]
            description (str): optional description. [optional]
            sql (QueryLambdaSql): [optional]
            create (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done on the data received from the server.
                If False, the client will also not convert nested inner objects
                into the respective model types (the outermost object
                is still converted to the model).
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueryLambdaVersionResponse
                If the method is called asynchronously, returns an asyncio.Future which resolves to the response.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['workspace'] = \
            workspace
        kwargs['query_lambda'] = \
            query_lambda
        kwargs['update_query_lambda_request'] = \
            kwargs['update_query_lambda_request']
        return self.update_query_lambda_endpoint.call_with_http_info(**kwargs)


    body_params_dict = dict()
    return_types_dict = dict()
    body_params_dict['create_query_lambda'] = 'create_query_lambda_request'
    return_types_dict['create_query_lambda'] = CreateQueryLambdaRequest
    body_params_dict['create_query_lambda_tag'] = 'create_query_lambda_tag_request'
    return_types_dict['create_query_lambda_tag'] = CreateQueryLambdaTagRequest
    body_params_dict['execute_query_lambda'] = 'execute_query_lambda_request'
    return_types_dict['execute_query_lambda'] = ExecuteQueryLambdaRequest
    body_params_dict['execute_query_lambda_by_tag'] = 'execute_query_lambda_request'
    return_types_dict['execute_query_lambda_by_tag'] = ExecuteQueryLambdaRequest
    body_params_dict['update_query_lambda'] = 'update_query_lambda_request'
    return_types_dict['update_query_lambda'] = UpdateQueryLambdaRequest
