# Generated by Django 3.2.16 on 2022-10-24 09:34

from django.db import migrations, models


ROLE_RANKING = {
    'project owner': 10,
    'project delegate': 20,
    'project contributor': 30,
    'project guest': 40,
}


def set_ranks(apps, schema_editor):
    """Set rank values for existing roles"""
    Role = apps.get_model('projectroles', 'Role')
    for role in Role.objects.all():
        if role.name in ROLE_RANKING:
            role.rank = ROLE_RANKING[role.name]
            role.save()


class Migration(migrations.Migration):

    dependencies = [
        ('projectroles', '0021_remove_project_submit_status'),
    ]

    operations = [
        migrations.AddField(
            model_name='role',
            name='rank',
            field=models.IntegerField(default=0, help_text='Role rank for determining role hierarchy'),
        ),
        migrations.RunPython(set_ranks, reverse_code=migrations.RunPython.noop)
    ]
