> **⚠️ Important Notice**:
> This is a very early release of `niwrap`. We do not recommend using `niwrap` in 'production' at this stage unless you are willing to debug, fix, and contribute descriptors.

# `niwrap`

🧠 Python wrappers for neuroimaging command-line tools

[![GitHub stars](https://img.shields.io/github/stars/styx-api/niwrap?style=social)](https://github.com/styx-api/niwrap/stargazers)
[![PyPI](https://img.shields.io/pypi/v/niwrap.svg)](https://pypi.org/project/niwrap/)
![stability-stable](https://img.shields.io/badge/stability-experimental-red.svg)
[![MIT License](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/styx-api/niwrap-python/blob/main/LICENSE)
[![pages](https://img.shields.io/badge/api-docs-blue)](https://styx-api.github.io/niwrap-python)
[![Preprint](https://img.shields.io/badge/bioRxiv-preprint-green?logo=bookstack&logoColor=white)](https://doi.org/10.1101/2025.07.24.666435)
[![Discord](https://dcbadge.limes.pink/api/server/https://discord.gg/QMKUVCFWsR?style=flat)](https://discord.gg/QMKUVCFWsR)

## 🚀 Quick Start

```python
from niwrap import fsl

# Brain extraction using FSL's BET
bet_output = fsl.bet(
    infile="input_image.nii.gz",
)
```

## 📦 Installation

Install the stable version from PyPI:

```bash
pip install niwrap
```

Or install the development version:

```bash
pip install -r https://raw.githubusercontent.com/styx-api/niwrap-python/main/requirements_remote.txt
```

## 🧰 Supported Tools

| Package | Status | Version | API Coverage |
| --- | --- | --- | --- |
| [AFNI](https://afni.nimh.nih.gov/) | Experimental | [`24.2.06`](https://hub.docker.com/r/afni/afni_make_build) | 565/611 (92.5%) |
| [ANTs](https://github.com/ANTsX/ANTs) | Experimental | [`2.5.3`](https://hub.docker.com/r/antsx/ants) | 71/113 (62.8%) |
| [Connectome Workbench](https://github.com/Washington-University/workbench) | Experimental | [`1.5.0`](https://hub.docker.com/r/brainlife/connectome_workbench) | 202/202 (100% 🎉) |
| [Convert3D](http://www.itksnap.org/pmwiki/pmwiki.php?n=Convert3D.Convert3D) | Experimental | [`1.1.0`](https://hub.docker.com/r/pyushkevich/itksnap) | 4/4 (100% 🎉) |
| [FSL](https://fsl.fmrib.ox.ac.uk/fsl/fslwiki) | Experimental | [`6.0.4`](https://hub.docker.com/r/brainlife/fsl) | 245/313 (78.3%) |
| [FastSurfer](https://github.com/Deep-MI/FastSurfer) | Experimental | [`2.3.3`](https://hub.docker.com/r/deepmi/fastsurfer) | 1/1 (100% 🎉) |
| [FreeSurfer](https://github.com/freesurfer/freesurfer) | Experimental | [`7.4.1`](https://hub.docker.com/r/freesurfer/freesurfer) | 696/789 (88.2%) |
| [Greedy](https://sites.google.com/view/greedyreg/about) | Experimental | [`1.0.1`](https://hub.docker.com/r/pyushkevich/itksnap) | 1/1 (100% 🎉) |
| [MRTrix3](https://www.mrtrix.org/) | Well tested | [`3.0.4`](https://hub.docker.com/r/mrtrix3/mrtrix3) | 115/121 (95.0%) |
| [MRTrix3Tissue](https://3tissue.github.io/) | Well tested | [`5.2.8`](https://hub.docker.com/r/brainlife/3tissue) | 1/1 (100% 🎉) |
| [NiftyReg](http://cmictig.cs.ucl.ac.uk/wiki/index.php/NiftyReg) | Experimental | [`1.4.0`](https://hub.docker.com/r/vnmd/niftyreg_1.4.0) | 7/7 (100% 🎉) |
| [dcm2niix](https://github.com/rordenlab/dcm2niix) | Experimental | [`1.0.20240202`](https://hub.docker.com/r/vnmd/dcm2niix_v1.0.20240202) | 1/1 (100% 🎉) |

## 🛠 Usage Examples

Usage examples and tutorials can be found in the [Styx book](https://styx-api.github.io/styxbook/).

## 🔧 Development

All code in this package is automatically generated by [Styx](https://github.com/styx-api/styx).

## 📚 Documentation

For full documentation, visit our [docs site](https://styx-api.github.io/niwrap/niwrap.html).

## 🤝 Contributing

We welcome contributions! Please see our [Contribution Guide](https://github.com/styx-api/niwrap/blob/main/CONTRIBUTING.md) for more details.

## 📄 License

The `niwrap` Python package, including all wrapper code, is licensed under the MIT License. See the LICENSE file for more details.

> **⚠️ Important Notice**:
> While niwrap provides convenient Python wrappers, it does not include or distribute the actual neuroimaging tools. Each tool wrapped by niwrap (e.g., FSL, AFNI, ANTs) is subject to its own license. Users of niwrap must ensure they comply with the licenses of the underlying tools they use. The MIT License of niwrap applies only to the wrapper code, not to the tools themselves.

## 🙋‍♀️ Getting Help

The [Styx book](https://styx-api.github.io/styxbook/) aims to be a starting point for new users.

If you encounter any problems or have any questions, please open an issue on our [GitHub repository](https://github.com/styx-api/niwrap).

## 📚 Citation

If you use NiWrap in your research, please consider citing:

```bibtex
@article {rupprecht2025styx,
	author = {Rupprecht, Florian JM and Kai, Jason and Shrestha, Biraj and Giavasis, Steven and Xu, Ting and Glatard, Tristan and Milham, Michael P and Kiar, Gregory},
	title = {Styx: A multi-language API Generator for Command-Line Tools},
	elocation-id = {2025.07.24.666435},
	year = {2025},
	doi = {10.1101/2025.07.24.666435},
	publisher = {Cold Spring Harbor Laboratory},
	URL = {https://www.biorxiv.org/content/early/2025/07/30/2025.07.24.666435},
	eprint = {https://www.biorxiv.org/content/early/2025/07/30/2025.07.24.666435.full.pdf},
	journal = {bioRxiv}
}
```
