# [Django Admin Gradient](https://appseed.us/product/gradient-able/django/)

Modern template for **Django** that covers `Admin Section`, all authentication pages (registration included) crafted on top of **[Gradient Able](https://appseed.us/product/gradient-able/django/)**, 
an open-source `Bootstrap` design from [CodedThemes](https://bit.ly/37fF9RT).

> Actively supported by [AppSeed](https://appseed.us/) via `Email` and `Discord`.

<br />

> UI Kit: https://github.com/codedthemes/gradient-able-free-bootstrap-admin-template

<br />

**Links & Resources**

- [Django Gradient Able](https://appseed.us/product/gradient-able/django/) - `Product page`
  - `Features`: Fully-configured, `CI/CD` via Render
- UI Kit: **Gradient Able** (open-source, Bootstrap 4 version) by [CodedThemes](https://bit.ly/37fF9RT)
- **Sections Covered**: 
  - `Admin Section`, reserved for `superusers`
  - `All pages` managed by `Django.contrib.AUTH`
  - `Registration` page
  - `Misc pages`: colors, icons, typography, blank-page 
  
<br />

![Gradient Able - Starter generated by AppSeed.](https://user-images.githubusercontent.com/51070104/171583187-c4ca1bef-b535-458e-9250-8d62ba1f5b30.png)

<br />

## Why `Django Admin Gradient`

- Modern [Bootstrap](https://www.admin-dashboards.com/bootstrap-5-templates/) Design
- `Responsive Interface`
- `Minimal Template` overriding
- `Easy integration`

<br />

## How to use it

<br />

> **Install the package** via `PIP` 

```bash
$ pip install django-admin-gradient
// OR
$ pip install git+https://github.com/app-generator/django-admin-gradient.git
```

<br />

> Add `admin_gradient` application to the `INSTALLED_APPS` setting of your Django project `settings.py` file (note it should be before `django.contrib.admin`):

```python
    INSTALLED_APPS = (
        ...
        'admin_gradient.apps.AdminGradientConfig',
        'django.contrib.admin',
    )
```

<br />

> Add `LOGIN_REDIRECT_URL` and `EMAIL_BACKEND` of your Django project `settings.py` file:

```python
    LOGIN_REDIRECT_URL = '/'
    # EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
    EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'
```

<br />

> Add `admin_gradient` urls in your Django Project `urls.py` file

```python
    from django.urls import path, include

    urlpatterns = [
        ...
        path('', include('admin_gradient.urls')),
    ]
```

<br />

> **Collect static** if you are in `production environment`:

```bash
$ python manage.py collectstatic
```

<br />

> **Start the app**

```bash
$ # Set up the database
$ python manage.py makemigrations
$ python manage.py migrate
$
$ # Create the superuser
$ python manage.py createsuperuser
$
$ # Start the application (development mode)
$ python manage.py runserver # default port 8000
```

Access the `admin` section in the browser: `http://127.0.0.1:8000/`

<br />

## How to Customize 

When a template file is loaded, `Django` scans all template directories starting from the ones defined by the user, and returns the first match or an error in case the template is not found. 
The theme used to style this starter provides the following files: 

```bash
# This exists in ENV: LIB/admin_gradient
< UI_LIBRARY_ROOT >                      
   |
   |-- templates/                     # Root Templates Folder 
   |    |          
   |    |-- accounts/       
   |    |    |-- login.html           # Sign IN Page
   |    |    |-- register.html        # Sign UP Page
   |    |
   |    |-- includes/       
   |    |    |-- footer.html          # Footer component
   |    |    |-- sidebar.html         # Sidebar component
   |    |    |-- navigation.html      # Navigation Bar
   |    |    |-- scripts.html         # Scripts Component
   |    |
   |    |-- layouts/       
   |    |    |-- base.html            # Masterpage
   |    |    |-- base-auth.html       # Masterpage for Auth Pages
   |    |
   |    |-- pages/       
   |         |-- index.html           # Dashboard Page
   |         |-- profile.html         # Profile Page
   |         |-- *.html               # All other pages
   |    
   |-- ************************************************************************
```

When the project requires customization, we need to copy the original file that needs an update (from the virtual environment) and place it in the template folder using the same path. 

For instance, if we want to customize the `footer.html` these are the steps:

- `Step 1`: create the `templates` DIRECTORY inside your app 
- `Step 2`: configure the project to use this new template directory
  - Edit `settings.py` TEMPLATES section 
- `Step 3`: copy the `footer.html` from the original location (inside your ENV) and save it to the `YOUR_APP/templates` DIR
  - Source PATH: `<YOUR_ENV>/LIB/admin_gradient/templates/includes/footer.html`
  - Destination PATH: `YOUR_APP/templates/includes/footer.html`
- Edit the `footer.html` (Destination PATH)     

At this point, the default version of the `footer.html` shipped in the library is ignored by Django.

In a similar way, all other files and components can be customized easily.

<br />

## [Gradient Able](https://appseed.us/product/gradient-able-pro/django/) `PRO Version`

> For more components, pages and priority on support, feel free to take a look at this **Django** starter:

Designed for those who like bold elements and beautiful websites, **[Gradient Able](https://appseed.us/product/gradient-able-pro/django/)** is the most stylish Admin Design compare to all other Bootstrap Templates. 
It comes with high feature-rich pages and components with fully developer-centric code. 

- [Gradient Datta PRO](https://appseed.us/product/datta-able-pro/django/) - product page
  - `Enhanced UI` - more pages and components
  - `Priority` on support

<br >

![Gradient Able PRO - Starter generated by AppSeed.](https://user-images.githubusercontent.com/51070104/171583582-d9652e7e-f420-4cf0-8eb1-dda3c79f8c18.png)

<br />

---
**[Django Admin Gradient](https://appseed.us/product/gradient-able/django/)** - Modern Admin Interface provided by **[AppSeed](https://appseed.us/)**
