
from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.1'
DESCRIPTION = "Axtrack extract urls and endpoints in relation to the given domain."
LONG_DESCRIPTION = 'Axtrack grab module extracts urls from all possible timeline.'

# Setting up
setup(
    name="Axtrack",
    version=VERSION,
    author="Deepanjal kumar (Operation Falcon)",
    author_email="operationfalcon6@gmail.com",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=['certifi==2020.12.5', 'chardet==4.0.0', 'idna==2.10', 'requests==2.25.1', 'urllib3==1.26.4'],
    keywords=['python', 'Axtrack', 'grab', 'wayback machine'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix"
    ]
)