/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.applier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import opennlp.tools.util.Span;
import org.cogroo.ContractionUtility;
import org.cogroo.entities.Sentence;
import org.cogroo.entities.SyntacticChunk;
import org.cogroo.entities.Token;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.impl.TokenCogroo;
import org.cogroo.tools.checker.rules.applier.NullToken;
import org.cogroo.tools.checker.rules.dictionary.CogrooTagDictionary;
import org.cogroo.tools.checker.rules.model.Boundaries;
import org.cogroo.tools.checker.rules.model.Rule;
import org.cogroo.tools.checker.rules.model.Suggestion;
import org.cogroo.tools.checker.rules.model.TagMask;
import org.cogroo.tools.checker.rules.util.RuleUtils;
import org.cogroo.tools.checker.rules.util.TagMaskUtils;

public class SuggestionBuilder {
    private final CogrooTagDictionary dictionary;

    public SuggestionBuilder(CogrooTagDictionary dict) {
        this.dictionary = dict;
    }

    public String[] getTokenSuggestions(Sentence sentence, List<Token> matched, Token next, Rule rule) {
        HashSet<String> suggestionsAsString = new HashSet<String>();
        for (Suggestion suggestion : rule.getSuggestion()) {
            String s = this.getTokenSuggestions(sentence, matched, next, suggestion, rule.getBoundaries());
            if (s == null || s.length() <= 0) continue;
            suggestionsAsString.add(s);
        }
        return suggestionsAsString.toArray(new String[suggestionsAsString.size()]);
    }

    public String[] getSyntacticSuggestions(Sentence sentence, List<SyntacticChunk> matched, Token next, Rule rule) {
        HashSet<String> suggestionsAsString = new HashSet<String>();
        for (Suggestion suggestion : rule.getSuggestion()) {
            String s = this.getSyntacticSuggestions(sentence, matched, next, suggestion, rule.getBoundaries());
            if (s == null || s.length() <= 0) continue;
            suggestionsAsString.add(s);
        }
        return suggestionsAsString.toArray(new String[suggestionsAsString.size()]);
    }

    private String getTokenSuggestions(Sentence sentence, List<Token> matched, Token next, Suggestion suggestion, Boundaries boundaries) {
        Token[] underlinedTokens = SuggestionBuilder.tokensSubArray(matched, boundaries);
        String[] mistakenTokensAsString = SuggestionBuilder.tokensSubArrayAsString(underlinedTokens);
        boolean[] replacedByEmptyString = new boolean[mistakenTokensAsString.length];
        boolean reject = false;
        for (Suggestion.Replace replace : suggestion.getReplace()) {
            String[] primitive;
            int replaceIndex;
            if (replace.getTagReference() == null && replace.getLexeme() != null) {
                String replacement = replace.getLexeme();
                replaceIndex = (int)replace.getIndex();
                mistakenTokensAsString[replaceIndex] = RuleUtils.useCasedString(mistakenTokensAsString[(int)replace.getIndex()], replacement);
                replacedByEmptyString[replaceIndex] = replacement.equals("");
                continue;
            }
            replaceIndex = (int)replace.getIndex();
            if (replace.getLexeme() != null) {
                String[] arr = new String[]{replace.getLexeme()};
                primitive = arr;
            } else {
                primitive = matched.get((int)replace.getIndex()).getPrimitive();
            }
            TagMask tagMask = new TagMask();
            int index = 0;
            MorphologicalTag refMorphTag = null;
            if (replace.getTagReference() != null) {
                tagMask = replace.getTagReference().getTagMask();
                index = (int)replace.getTagReference().getIndex();
                refMorphTag = underlinedTokens[index].getMorphologicalTag();
            } else if (replace.getReference() != null) {
                tagMask = new TagMask();
                index = (int)replace.getReference().getIndex();
                refMorphTag = matched.get(index).getMorphologicalTag();
            }
            TagMask cloneTagMask = TagMaskUtils.clone(tagMask);
            if (replace.getReference() != null) {
                cloneTagMask = RuleUtils.createTagMaskFromReference(replace.getReference(), refMorphTag, null, null);
            } else {
                if (cloneTagMask.getGender() == TagMask.Gender.NEUTRAL) {
                    TagMask.Gender gender = refMorphTag.getGenderE();
                    if (TagMask.Gender.MALE.equals((Object)gender)) {
                        cloneTagMask.setGender(TagMask.Gender.MALE);
                    } else if (TagMask.Gender.FEMALE.equals((Object)gender)) {
                        cloneTagMask.setGender(TagMask.Gender.FEMALE);
                    }
                }
                if (cloneTagMask.getNumber() == TagMask.Number.NEUTRAL) {
                    TagMask.Number number = refMorphTag.getNumberE();
                    if (TagMask.Number.SINGULAR.equals((Object)number)) {
                        cloneTagMask.setNumber(TagMask.Number.SINGULAR);
                    } else if (TagMask.Number.PLURAL.equals((Object)number)) {
                        cloneTagMask.setNumber(TagMask.Number.PLURAL);
                    }
                }
            }
            Token originalToken = underlinedTokens[replaceIndex];
            RuleUtils.completeMissingParts(cloneTagMask, originalToken.getMorphologicalTag());
            String flex = this.getBestFlexedWord(originalToken, tagMask);
            if (flex.equals("")) {
                reject = true;
                continue;
            }
            flex = SuggestionBuilder.discardBeginningHyphen(flex);
            mistakenTokensAsString[(int)replace.getIndex()] = flex = RuleUtils.useCasedString(mistakenTokensAsString[(int)replace.getIndex()], flex);
        }
        if (!reject) {
            for (Suggestion.Swap swap : suggestion.getSwap()) {
                int a = (int)swap.getA();
                int b = (int)swap.getB();
                String temp = SuggestionBuilder.discardBeginningHyphen(mistakenTokensAsString[a]);
                mistakenTokensAsString[a] = SuggestionBuilder.discardBeginningHyphen(mistakenTokensAsString[b]);
                mistakenTokensAsString[b] = temp;
            }
            for (Suggestion.ReplaceMapping replaceMapping : suggestion.getReplaceMapping()) {
                long index = replaceMapping.getIndex();
                if (!replaceMapping.getKey().equals(mistakenTokensAsString[(int)index].toLowerCase())) continue;
                mistakenTokensAsString[(int)index] = RuleUtils.useCasedString(mistakenTokensAsString[(int)index], replaceMapping.getValue());
            }
            if (replacedByEmptyString[replacedByEmptyString.length - 1] && next != null) {
                Token removed = matched.get(matched.size() - 1);
                if (next.getSpan().equals(removed.getSpan())) {
                    mistakenTokensAsString[replacedByEmptyString.length - 1] = next.getLexeme();
                    replacedByEmptyString[replacedByEmptyString.length - 1] = false;
                }
            }
            String suggestionAsString = "";
            for (int i = 0; i < mistakenTokensAsString.length; ++i) {
                suggestionAsString = mistakenTokensAsString[i].startsWith("-") || replacedByEmptyString[i] ? suggestionAsString + mistakenTokensAsString[i] : suggestionAsString + " " + mistakenTokensAsString[i];
            }
            return suggestionAsString.trim();
        }
        return null;
    }

    private String getSyntacticSuggestions(Sentence sentence, List<SyntacticChunk> matched, Token next, Suggestion suggestion, Boundaries boundaries) {
        Token[] matchedTokens = this.extractTokens(matched);
        Token[] underlinedTokens = SuggestionBuilder.tokensSubArraySynt(matched, boundaries);
        Span underlinedSpan = new Span(underlinedTokens[0].getSpan().getStart(), underlinedTokens[underlinedTokens.length - 1].getSpan().getEnd());
        Span[] tokenIndex = this.tokenIndex(matched);
        String[] mistakenTokensAsString = SuggestionBuilder.tokensSubArrayAsString(underlinedTokens);
        boolean[] replacedByEmptyString = new boolean[mistakenTokensAsString.length];
        boolean reject = false;
        for (Suggestion.Replace replace : suggestion.getReplace()) {
            int start;
            int replaceIndex;
            if (replace.getTagReference() == null && replace.getLexeme() != null) {
                String replacement = replace.getLexeme();
                replaceIndex = (int)replace.getIndex();
                Span p = tokenIndex[replaceIndex];
                for (int i = p.getStart() + 1; i < p.getEnd(); ++i) {
                    mistakenTokensAsString[i] = "";
                    replacedByEmptyString[i] = true;
                }
                mistakenTokensAsString[p.getStart()] = RuleUtils.useCasedString(mistakenTokensAsString[(int)replace.getIndex()], replacement);
                replacedByEmptyString[p.getStart()] = replacement.equals("");
                continue;
            }
            ArrayList<Object> primitives = new ArrayList<Object>();
            replaceIndex = (int)replace.getIndex();
            if (replace.getLexeme() != null) {
                String[] arr = new String[]{replace.getLexeme()};
                primitives.add(arr);
            } else {
                for (Token toks : matched.get((int)replace.getIndex()).getTokens()) {
                    primitives.add(toks.getPrimitive());
                }
            }
            TagMask tagMask = new TagMask();
            int index = 0;
            MorphologicalTag refMorphTag = null;
            if (replace.getTagReference() != null) {
                tagMask = replace.getTagReference().getTagMask();
                index = (int)replace.getTagReference().getIndex();
                refMorphTag = matched.get(index).getMorphologicalTag();
            } else if (replace.getReference() != null) {
                tagMask = new TagMask();
                index = (int)replace.getReference().getIndex();
                refMorphTag = matched.get(index).getMorphologicalTag();
            }
            TagMask cloneTagMask = TagMaskUtils.clone(tagMask);
            if (replace.getReference() != null) {
                cloneTagMask = RuleUtils.createTagMaskFromReference(replace.getReference(), refMorphTag, null, null);
            } else {
                if (cloneTagMask.getGender() == TagMask.Gender.NEUTRAL) {
                    TagMask.Gender gender = refMorphTag.getGenderE();
                    if (TagMask.Gender.MALE.equals((Object)gender)) {
                        cloneTagMask.setGender(TagMask.Gender.MALE);
                    } else if (TagMask.Gender.FEMALE.equals((Object)gender)) {
                        cloneTagMask.setGender(TagMask.Gender.FEMALE);
                    }
                }
                if (cloneTagMask.getNumber() == TagMask.Number.NEUTRAL) {
                    TagMask.Number number = refMorphTag.getNumberE();
                    if (TagMask.Number.SINGULAR.equals((Object)number)) {
                        cloneTagMask.setNumber(TagMask.Number.SINGULAR);
                    } else if (TagMask.Number.PLURAL.equals((Object)number)) {
                        cloneTagMask.setNumber(TagMask.Number.PLURAL);
                    }
                }
            }
            List<Token> originalTokens = matched.get(replaceIndex).getTokens();
            String[] fixed = new String[matchedTokens.length];
            if (primitives != null) {
                for (int i = 0; i < primitives.size(); ++i) {
                    String f;
                    String[] primitive = (String[])primitives.get(i);
                    Token ot = originalTokens.get(i);
                    TagMask tm = TagMaskUtils.clone(cloneTagMask);
                    RuleUtils.completeMissingParts(tm, ot.getMorphologicalTag());
                    ArrayList<String> flexList = new ArrayList<String>();
                    for (String p : primitive) {
                        String[] farr = this.dictionary.getInflectedPrimitive(p, tm, false);
                        if (farr == null) continue;
                        flexList.addAll(Arrays.asList(farr));
                    }
                    String[] flexArr = flexList.toArray(new String[flexList.size()]);
                    if (flexArr.length > 0) {
                        f = SuggestionBuilder.getBestFlexedWord(flexArr, ot, cloneTagMask);
                        f = SuggestionBuilder.discardBeginningHyphen(f);
                        f = RuleUtils.useCasedString(ot.getLexeme(), f);
                    } else {
                        f = ot.getLexeme();
                    }
                    fixed[tokenIndex[replaceIndex].getStart() + i] = f;
                }
            }
            for (int i = start = tokenIndex[boundaries.getLower()].getStart(); i < start + mistakenTokensAsString.length; ++i) {
                if (fixed[i] == null) continue;
                mistakenTokensAsString[i - start] = fixed[i];
            }
        }
        if (!reject) {
            for (Suggestion.Swap swap : suggestion.getSwap()) {
                int a = (int)swap.getA();
                int b = (int)swap.getB();
                String temp = SuggestionBuilder.discardBeginningHyphen(mistakenTokensAsString[a]);
                mistakenTokensAsString[a] = SuggestionBuilder.discardBeginningHyphen(mistakenTokensAsString[b]);
                mistakenTokensAsString[b] = temp;
            }
            for (Suggestion.ReplaceMapping replaceMapping : suggestion.getReplaceMapping()) {
                long index = replaceMapping.getIndex();
                if (!replaceMapping.getKey().equals(mistakenTokensAsString[(int)index].toLowerCase())) continue;
                mistakenTokensAsString[(int)index] = RuleUtils.useCasedString(mistakenTokensAsString[(int)index], replaceMapping.getValue());
            }
            StringBuilder suggestionAsStr = new StringBuilder(underlinedSpan.getCoveredText(sentence.getSentence()));
            int offset = underlinedTokens[0].getSpan().getStart();
            Span previous = new Span(Integer.MAX_VALUE, Integer.MAX_VALUE);
            for (int i = mistakenTokensAsString.length - 1; i >= 0; --i) {
                if (mistakenTokensAsString[i] != null) {
                    Span s = underlinedTokens[i].getSpan();
                    if (previous.equals(s)) {
                        String contraction = ContractionUtility.toContraction(mistakenTokensAsString[i].toLowerCase(), mistakenTokensAsString[i + 1].toLowerCase());
                        mistakenTokensAsString[i] = RuleUtils.useCasedString(underlinedTokens[i].getSpan().getCoveredText(sentence.getDocumentText()).toString(), contraction);
                        s = new Span(previous.getStart(), previous.getStart() + mistakenTokensAsString[i + 1].length());
                    }
                    previous = s;
                    suggestionAsStr.replace(s.getStart() - offset, s.getEnd() - offset, mistakenTokensAsString[i]);
                }
                if (!replacedByEmptyString[i] || i <= 0 || i >= mistakenTokensAsString.length - 1) continue;
                int end = underlinedTokens[i].getSpan().getStart();
                int start = underlinedTokens[i - 1].getSpan().getEnd();
                suggestionAsStr.replace(start, end, "");
            }
            return suggestionAsStr.toString().trim();
        }
        return null;
    }

    private Token[] extractTokens(List<SyntacticChunk> matched) {
        ArrayList<Token> out = new ArrayList<Token>();
        for (SyntacticChunk sc : matched) {
            out.addAll(sc.getTokens());
        }
        return out.toArray(new Token[out.size()]);
    }

    private Span[] tokenIndex(List<SyntacticChunk> matched) {
        ArrayList<Span> out = new ArrayList<Span>();
        int count = 0;
        for (SyntacticChunk syntacticChunk : matched) {
            int start = count;
            int end = count + syntacticChunk.getTokens().size();
            out.add(new Span(start, end));
            count += syntacticChunk.getTokens().size();
        }
        return out.toArray(new Span[out.size()]);
    }

    private static SyntacticChunk[] getSyntacticChunks(Token[] tokens) {
        Stack<SyntacticChunk> stack = new Stack<SyntacticChunk>();
        for (Token token : tokens) {
            SyntacticChunk s = token.getSyntacticChunk();
            if (!stack.isEmpty() && ((SyntacticChunk)stack.lastElement()).equals(s)) continue;
            stack.add(s);
        }
        return stack.toArray(new SyntacticChunk[stack.size()]);
    }

    private static String[] tokensSubArrayAsString(Token[] tokens) {
        String[] subArray = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            subArray[i] = SuggestionBuilder.isNotNull(tokens[i]) ? ((TokenCogroo)tokens[i]).getLexeme() : null;
        }
        return subArray;
    }

    private static boolean isNotNull(Token token) {
        return token != null && !(token instanceof NullToken);
    }

    private static Token[] tokensSubArray(Sentence sentence, int lower, int upper, boolean considerChunk) {
        List<Token> rootTokens = sentence.getTokens().subList(lower, upper + 1);
        if (considerChunk) {
            ArrayList<Token> resp = new ArrayList<Token>(rootTokens.size());
            for (int i = 0; i < rootTokens.size(); ++i) {
                resp.addAll(SuggestionBuilder.getTokensRecursively(rootTokens.get(i)));
            }
            return rootTokens.toArray(new Token[rootTokens.size()]);
        }
        return rootTokens.toArray(new Token[rootTokens.size()]);
    }

    private static Token[] tokensSubArraySynt(List<SyntacticChunk> matched, Boundaries boundaries) {
        int start = boundaries.getLower();
        int end = matched.size() + boundaries.getUpper();
        List<SyntacticChunk> syntChunks = matched.subList(start, end);
        ArrayList<Token> out = new ArrayList<Token>();
        for (SyntacticChunk sc : syntChunks) {
            out.addAll(sc.getTokens());
        }
        return out.toArray(new Token[out.size()]);
    }

    private static Token[] tokensSubArray(List<Token> tokens, Boundaries boundaries) {
        int start = boundaries.getLower();
        int end = tokens.size() + boundaries.getUpper();
        List<Token> rootTokens = tokens.subList(start, end);
        return rootTokens.toArray(new Token[rootTokens.size()]);
    }

    private static List<Token> getTokensRecursively(Token rootToken) {
        ArrayList<Token> tl = new ArrayList<Token>();
        if (rootToken.getChunk() != null && rootToken.getChunk().getTokens().size() > 1) {
            tl.addAll(rootToken.getChunk().getTokens());
            return tl;
        }
        tl.add(rootToken);
        return tl;
    }

    private static String discardBeginningHyphen(String string) {
        String noHyphenString = string;
        if (string.startsWith("-")) {
            noHyphenString = string.substring(1);
        }
        return noHyphenString;
    }

    private static String getBestFlexedWord(String[] flex, Token original, TagMask tagMask) {
        String lexeme = original.getLexeme().toLowerCase();
        if (flex.length > 1) {
            int minDist = Integer.MAX_VALUE;
            String selected = null;
            for (String candidate : flex) {
                int d = SuggestionBuilder.levenshteinDistance(lexeme, candidate);
                if (d >= minDist) continue;
                minDist = d;
                selected = candidate;
            }
            return selected;
        }
        if (flex.length == 1) {
            return flex[0];
        }
        return "";
    }

    private static int levenshteinDistance(String s, String t) {
        int i;
        if (s == t) {
            return 0;
        }
        if (s.length() == 0) {
            return t.length();
        }
        if (t.length() == 0) {
            return s.length();
        }
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        for (i = 0; i < s.length(); ++i) {
            int j;
            v1[0] = i + 1;
            for (j = 0; j < t.length(); ++j) {
                int cost = s.charAt(i) == t.charAt(j) ? 0 : 1;
                v1[j + 1] = Math.min(Math.min(v1[j] + 1, v0[j + 1] + 1), v0[j] + cost);
            }
            for (j = 0; j < v0.length; ++j) {
                v0[j] = v1[j];
            }
        }
        return v1[t.length()];
    }

    public String getBestFlexedWord(Token token, TagMask tm) {
        ArrayList<String> flexList = new ArrayList<String>();
        String[] primitives = token.getPrimitive();
        TagMask cloneTagMask = TagMaskUtils.clone(tm);
        if (primitives != null) {
            for (String p : primitives) {
                String[] farr = this.dictionary.getInflectedPrimitive(p, cloneTagMask, false);
                if (farr == null) continue;
                flexList.addAll(Arrays.asList(farr));
            }
        }
        String[] flexArr = flexList.toArray(new String[flexList.size()]);
        String flex = SuggestionBuilder.getBestFlexedWord(flexArr, token, cloneTagMask);
        return flex;
    }
}

