/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import opennlp.tools.util.Span;
import org.cogroo.entities.Chunk;
import org.cogroo.entities.SyntacticChunk;
import org.cogroo.entities.Token;
import org.cogroo.entities.TokenGroup;
import org.cogroo.entities.tree.Node;
import org.cogroo.entities.tree.TextModel;
import org.cogroo.util.ToStringHelper;

public class Sentence
implements Serializable,
TokenGroup {
    private static final long serialVersionUID = -5370072688009577273L;
    protected String sentence;
    protected List<Token> tokens;
    protected List<Chunk> chunks;
    private Node root;
    private int offset;
    private Span span;
    private String doc;
    private List<SyntacticChunk> syntacticChunks = null;
    private org.cogroo.text.Sentence newSentence;

    public String toPlainText() {
        return this.sentence;
    }

    public String toString() {
        return ToStringHelper.toStringHelper(this).add("sent", this.sentence).add("tks", this.tokens).add("cks", this.chunks).add("root", this.root).toString();
    }

    public String getSentence() {
        if (this.sentence != null) {
            return this.sentence;
        }
        if (this.doc != null) {
            return this.span.getCoveredText(this.doc).toString();
        }
        return null;
    }

    public String getDocumentText() {
        return this.doc;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public void setDocumentText(String document) {
        this.doc = document;
    }

    public void setSpan(Span aSpan) {
        this.span = aSpan;
    }

    public Span getSpan() {
        return this.span;
    }

    @Override
    public List<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<Token> tokens) {
        this.tokens = tokens;
    }

    public List<Chunk> getChunks() {
        return this.chunks;
    }

    public void setChunks(List<Chunk> chunks) {
        this.chunks = chunks;
    }

    public List<SyntacticChunk> getSyntacticChunks() {
        return this.syntacticChunks;
    }

    public void setSyntacticChunks(List<SyntacticChunk> sc) {
        this.syntacticChunks = sc;
    }

    public void setRoot(Node root) {
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Node getRoot() {
        if (this.root != null) {
            return this.root;
        }
        Sentence sentence = this;
        synchronized (sentence) {
            if (this.root == null) {
                TextModel model = new TextModel(this);
                this.root = model.getRoot();
            }
            return this.root;
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getSyntaxTree() {
        return this.getRoot().toSyntaxTree();
    }

    public String getTree() {
        return this.getRoot().toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Sentence) {
            Sentence that = (Sentence)object;
            return Objects.equals(this.sentence, that.sentence) && Objects.equals(this.tokens, that.tokens) && Objects.equals(this.chunks, that.chunks) && Objects.equals(this.root, that.root) && Objects.equals(this.offset, that.offset);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.sentence, this.tokens, this.chunks, this.root, this.offset);
    }

    public void setTextSentence(org.cogroo.text.Sentence sentence2) {
        this.newSentence = sentence2;
    }

    public org.cogroo.text.Sentence getTextSentence() {
        return this.newSentence;
    }
}

