/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.analyzer;

import java.util.List;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.dictionary.LemmaDictionary;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.Token;

public class Lemmatizer
implements Analyzer {
    private LemmaDictionary dict;

    public Lemmatizer(LemmaDictionary dict) {
        this.dict = dict;
    }

    @Override
    public void analyze(Document document) {
        List<Sentence> sentences = document.getSentences();
        for (Sentence sentence : sentences) {
            List<Token> tokens = sentence.getTokens();
            for (int i = 0; i < tokens.size(); ++i) {
                String tag = tokens.get(i).getPOSTag();
                String word = tokens.get(i).getLexeme();
                String[] lemmas = this.dict.getLemmas(word, tag);
                if (lemmas == null || lemmas.length == 0) {
                    lemmas = this.dict.getLemmas(word.toLowerCase(), tag);
                }
                tokens.get(i).setLemmas(lemmas);
            }
        }
    }
}

