/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.TrainingParameters;
import org.cogroo.tools.chunker2.TokenTag;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.Featurizer;
import org.cogroo.tools.featurizer.FeaturizerContextGenerator;
import org.cogroo.tools.featurizer.FeaturizerEventStream;
import org.cogroo.tools.featurizer.FeaturizerFactory;
import org.cogroo.tools.featurizer.FeaturizerModel;

public class FeaturizerME
implements Featurizer {
    public static final int DEFAULT_BEAM_SIZE = 10;
    private final FeaturizerContextGenerator contextGenerator;
    private final SequenceValidator<TokenTag> sequenceValidator;
    private Sequence bestSequence;
    protected SequenceClassificationModel<TokenTag> model;

    public FeaturizerME(FeaturizerModel model) {
        FeaturizerFactory factory = model.getFactory();
        this.model = model.getChunkerSequenceModel();
        this.contextGenerator = model.getFactory().getFeaturizerContextGenerator();
        this.sequenceValidator = model.getFactory().getSequenceValidator();
    }

    @Override
    public String[] featurize(String[] toks, String[] tags) {
        this.bestSequence = this.model.bestSequence((TokenTag[])TokenTag.create(toks, tags), null, this.contextGenerator, this.sequenceValidator);
        List<String> c = this.bestSequence.getOutcomes();
        return c.toArray(new String[c.size()]);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        return this.model.bestSequences(10, (TokenTag[])TokenTag.create(sentence, tags), new Object[0], this.contextGenerator, this.sequenceValidator);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        return this.model.bestSequences(10, (TokenTag[])TokenTag.create(sentence, tags), new Object[0], minSequenceScore, this.contextGenerator, this.sequenceValidator);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static FeaturizerModel train(String lang, ObjectStream<FeatureSample> in, TrainingParameters mlParams, FeaturizerFactory factory) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        FeaturizerEventStream es = new FeaturizerEventStream(in, factory.getFeaturizerContextGenerator());
        EventTrainer trainer = TrainerFactory.getEventTrainer(mlParams.getSettings(), manifestInfoEntries);
        MaxentModel maxentModel = trainer.train(es);
        return new FeaturizerModel(lang, maxentModel, manifestInfoEntries, factory);
    }
}

