/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.cogroo.tools.checker.rules.applier.AcceptState;
import org.cogroo.tools.checker.rules.applier.RulesProvider;
import org.cogroo.tools.checker.rules.applier.RulesTrees;
import org.cogroo.tools.checker.rules.applier.RulesTreesBuilder;
import org.cogroo.tools.checker.rules.applier.RulesTreesFromScratchAccess;
import org.cogroo.tools.checker.rules.applier.RulesXmlAccess;
import org.cogroo.tools.checker.rules.applier.State;
import org.cogroo.tools.checker.rules.util.RuleUtils;

public class RulesTreesPrinter {
    public static void main(String[] args) throws Exception {
        RulesProvider xmlProvider = new RulesProvider(RulesXmlAccess.getInstance(), false);
        RulesTreesBuilder rtb = new RulesTreesBuilder(xmlProvider);
        RulesTreesFromScratchAccess rta = new RulesTreesFromScratchAccess(rtb);
        OutputStreamWriter xmlOut = new OutputStreamWriter((OutputStream)new FileOutputStream("target/treesXml.txt"), "UTF-8");
        RulesTrees xmlTrees = rta.getTrees();
        RulesTreesPrinter.printRulesTrees(xmlTrees, xmlOut);
        xmlOut.close();
    }

    private static void printRulesTrees(RulesTrees rulesTrees, OutputStreamWriter out) throws Exception {
        RulesTreesPrinter.printRulesTree(rulesTrees.getGeneral().getRoot(), out);
        RulesTreesPrinter.printRulesTree(rulesTrees.getPhraseLocal().getRoot(), out);
        RulesTreesPrinter.printRulesTree(rulesTrees.getSubjectVerb().getRoot(), out);
    }

    private static void printRulesTree(State rootState, OutputStreamWriter out) throws Exception {
        List<State> nextStates = rootState.getNextStates();
        if (nextStates.isEmpty()) {
            return;
        }
        for (int i = 0; i < rootState.getNextStates().size(); ++i) {
            State currState = nextStates.get(i);
            String accept = "";
            String suggestions = "";
            if (currState instanceof AcceptState) {
                AcceptState acceptState = (AcceptState)currState;
                accept = Long.toString(acceptState.getRule().getId());
                suggestions = RuleUtils.getSuggestionsAsString(acceptState.getRule());
            }
            out.append("state[").append(Integer.toString(currState.getName())).append("], ");
            out.append("parent[").append(Integer.toString(rootState.getName())).append("], ");
            out.append("rule[").append(accept).append("], ");
            out.append("element[").append(RuleUtils.getPatternElementAsString(currState.getElement())).append("]");
            out.append("suggestions[").append(suggestions).append("]");
            out.append("\n");
            RulesTreesPrinter.printRulesTree(nextStates.get(i), out);
        }
    }
}

