/*
 * Decompiled with CFR 0.152.
 */
package morfologik.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static InputStream openInputStream(String resource) throws IOException {
        try {
            URL url = new URL(resource);
            return url.openStream();
        }
        catch (MalformedURLException e) {
            InputStream is;
            ClassLoader ldr = Thread.currentThread().getContextClassLoader();
            if (ldr != null && (is = ldr.getResourceAsStream(resource)) != null) {
                return is;
            }
            is = ResourceUtils.class.getResourceAsStream(resource);
            if (is != null) {
                return is;
            }
            is = ClassLoader.getSystemResourceAsStream(resource);
            if (is != null) {
                return is;
            }
            File f = new File(resource);
            if (f.exists() && f.isFile() && f.canRead()) {
                return new FileInputStream(f);
            }
            throw new IOException("Could not locate resource: " + resource);
        }
    }
}

