# Generated by generate_table_columns.py from MySQL system tables. unlike table_definition which generated from our applicative table in the database (should be generated by Sql2Code in the future

table_columns = {
    "innodb_table_stats": (
        "database_name",
        "table_name",
        "last_update",
        "n_rows",
        "clustered_index_size",
        "sum_of_other_index_sizes"
    ),
    "innodb_index_stats": (
        "database_name",
        "table_name",
        "index_name",
        "last_update",
        "stat_name",
        "stat_value",
        "sample_size",
        "stat_description"
    ),
    "general_log": (
        "event_time",
        "user_host",
        "thread_id",
        "server_id",
        "command_type",
        "argument"
    ),
    "slow_log": (
        "start_time",
        "user_host",
        "query_time",
        "lock_time",
        "rows_sent",
        "rows_examined",
        "db",
        "last_insert_id",
        "insert_id",
        "server_id",
        "sql_text",
        "thread_id"
    ),
    "version": (
        "sys_version",
        "mysql_version"
    ),
    "innodb_buffer_stats_by_schema": (
        "object_schema",
        "allocated",
        "data",
        "pages",
        "pages_hashed",
        "pages_old",
        "rows_cached"
    ),
    "x$innodb_buffer_stats_by_schema": (
        "object_schema",
        "allocated",
        "data",
        "pages",
        "pages_hashed",
        "pages_old",
        "rows_cached"
    ),
    "innodb_buffer_stats_by_table": (
        "object_schema",
        "object_name",
        "allocated",
        "data",
        "pages",
        "pages_hashed",
        "pages_old",
        "rows_cached"
    ),
    "x$innodb_buffer_stats_by_table": (
        "object_schema",
        "object_name",
        "allocated",
        "data",
        "pages",
        "pages_hashed",
        "pages_old",
        "rows_cached"
    ),
    "schema_object_overview": (
        "db",
        "object_type",
        "count"
    ),
    "schema_auto_increment_columns": (
        "table_schema",
        "table_name",
        "column_name",
        "data_type",
        "column_type",
        "is_signed",
        "is_unsigned",
        "max_value",
        "auto_increment",
        "auto_increment_ratio"
    ),
    "x$schema_flattened_keys": (
        "table_schema",
        "table_name",
        "index_name",
        "non_unique",
        "subpart_exists",
        "index_columns"
    ),
    "schema_redundant_indexes": (
        "table_schema",
        "table_name",
        "redundant_index_name",
        "redundant_index_columns",
        "redundant_index_non_unique",
        "dominant_index_name",
        "dominant_index_columns",
        "dominant_index_non_unique",
        "subpart_exists",
        "sql_drop_index"
    ),
    "ps_check_lost_instrumentation": (
        "variable_name",
        "variable_value"
    ),
    "latest_file_io": (
        "thread",
        "file",
        "latency",
        "operation",
        "requested"
    ),
    "x$latest_file_io": (
        "thread",
        "file",
        "latency",
        "operation",
        "requested"
    ),
    "io_by_thread_by_latency": (
        "user",
        "total",
        "total_latency",
        "min_latency",
        "avg_latency",
        "max_latency",
        "thread_id",
        "processlist_id"
    ),
    "x$io_by_thread_by_latency": (
        "user",
        "total",
        "total_latency",
        "min_latency",
        "avg_latency",
        "max_latency",
        "thread_id",
        "processlist_id"
    ),
    "io_global_by_file_by_bytes": (
        "file",
        "count_read",
        "total_read",
        "avg_read",
        "count_write",
        "total_written",
        "avg_write",
        "total",
        "write_pct"
    ),
    "x$io_global_by_file_by_bytes": (
        "file",
        "count_read",
        "total_read",
        "avg_read",
        "count_write",
        "total_written",
        "avg_write",
        "total",
        "write_pct"
    ),
    "io_global_by_file_by_latency": (
        "file",
        "total",
        "total_latency",
        "count_read",
        "read_latency",
        "count_write",
        "write_latency",
        "count_misc",
        "misc_latency"
    ),
    "x$io_global_by_file_by_latency": (
        "file",
        "total",
        "total_latency",
        "count_read",
        "read_latency",
        "count_write",
        "write_latency",
        "count_misc",
        "misc_latency"
    ),
    "io_global_by_wait_by_bytes": (
        "event_name",
        "total",
        "total_latency",
        "min_latency",
        "avg_latency",
        "max_latency",
        "count_read",
        "total_read",
        "avg_read",
        "count_write",
        "total_written",
        "avg_written",
        "total_requested"
    ),
    "x$io_global_by_wait_by_bytes": (
        "event_name",
        "total",
        "total_latency",
        "min_latency",
        "avg_latency",
        "max_latency",
        "count_read",
        "total_read",
        "avg_read",
        "count_write",
        "total_written",
        "avg_written",
        "total_requested"
    ),
    "io_global_by_wait_by_latency": (
        "event_name",
        "total",
        "total_latency",
        "avg_latency",
        "max_latency",
        "read_latency",
        "write_latency",
        "misc_latency",
        "count_read",
        "total_read",
        "avg_read",
        "count_write",
        "total_written",
        "avg_written"
    ),
    "x$io_global_by_wait_by_latency": (
        "event_name",
        "total",
        "total_latency",
        "avg_latency",
        "max_latency",
        "read_latency",
        "write_latency",
        "misc_latency",
        "count_read",
        "total_read",
        "avg_read",
        "count_write",
        "total_written",
        "avg_written"
    ),
    "innodb_lock_waits": (
        "wait_started",
        "wait_age",
        "wait_age_secs",
        "locked_table",
        "locked_table_schema",
        "locked_table_name",
        "locked_table_partition",
        "locked_table_subpartition",
        "locked_index",
        "locked_type",
        "waiting_trx_id",
        "waiting_trx_started",
        "waiting_trx_age",
        "waiting_trx_rows_locked",
        "waiting_trx_rows_modified",
        "waiting_pid",
        "waiting_query",
        "waiting_lock_id",
        "waiting_lock_mode",
        "blocking_trx_id",
        "blocking_pid",
        "blocking_query",
        "blocking_lock_id",
        "blocking_lock_mode",
        "blocking_trx_started",
        "blocking_trx_age",
        "blocking_trx_rows_locked",
        "blocking_trx_rows_modified",
        "sql_kill_blocking_query",
        "sql_kill_blocking_connection"
    ),
    "x$innodb_lock_waits": (
        "wait_started",
        "wait_age",
        "wait_age_secs",
        "locked_table",
        "locked_table_schema",
        "locked_table_name",
        "locked_table_partition",
        "locked_table_subpartition",
        "locked_index",
        "locked_type",
        "waiting_trx_id",
        "waiting_trx_started",
        "waiting_trx_age",
        "waiting_trx_rows_locked",
        "waiting_trx_rows_modified",
        "waiting_pid",
        "waiting_query",
        "waiting_lock_id",
        "waiting_lock_mode",
        "blocking_trx_id",
        "blocking_pid",
        "blocking_query",
        "blocking_lock_id",
        "blocking_lock_mode",
        "blocking_trx_started",
        "blocking_trx_age",
        "blocking_trx_rows_locked",
        "blocking_trx_rows_modified",
        "sql_kill_blocking_query",
        "sql_kill_blocking_connection"
    ),
    "memory_by_user_by_current_bytes": (
        "user",
        "current_count_used",
        "current_allocated",
        "current_avg_alloc",
        "current_max_alloc",
        "total_allocated"
    ),
    "x$memory_by_user_by_current_bytes": (
        "user",
        "current_count_used",
        "current_allocated",
        "current_avg_alloc",
        "current_max_alloc",
        "total_allocated"
    ),
    "memory_by_host_by_current_bytes": (
        "host",
        "current_count_used",
        "current_allocated",
        "current_avg_alloc",
        "current_max_alloc",
        "total_allocated"
    ),
    "x$memory_by_host_by_current_bytes": (
        "host",
        "current_count_used",
        "current_allocated",
        "current_avg_alloc",
        "current_max_alloc",
        "total_allocated"
    ),
    "memory_by_thread_by_current_bytes": (
        "thread_id",
        "user",
        "current_count_used",
        "current_allocated",
        "current_avg_alloc",
        "current_max_alloc",
        "total_allocated"
    ),
    "x$memory_by_thread_by_current_bytes": (
        "thread_id",
        "user",
        "current_count_used",
        "current_allocated",
        "current_avg_alloc",
        "current_max_alloc",
        "total_allocated"
    ),
    "memory_global_by_current_bytes": (
        "event_name",
        "current_count",
        "current_alloc",
        "current_avg_alloc",
        "high_count",
        "high_alloc",
        "high_avg_alloc"
    ),
    "x$memory_global_by_current_bytes": (
        "event_name",
        "current_count",
        "current_alloc",
        "current_avg_alloc",
        "high_count",
        "high_alloc",
        "high_avg_alloc"
    ),
    "memory_global_total": (
        "total_allocated"
    ),
    "x$memory_global_total": (
        "total_allocated"
    ),
    "schema_index_statistics": (
        "table_schema",
        "table_name",
        "index_name",
        "rows_selected",
        "select_latency",
        "rows_inserted",
        "insert_latency",
        "rows_updated",
        "update_latency",
        "rows_deleted",
        "delete_latency"
    ),
    "x$schema_index_statistics": (
        "table_schema",
        "table_name",
        "index_name",
        "rows_selected",
        "select_latency",
        "rows_inserted",
        "insert_latency",
        "rows_updated",
        "update_latency",
        "rows_deleted",
        "delete_latency"
    ),
    "x$ps_schema_table_statistics_io": (
        "table_schema",
        "table_name",
        "count_read",
        "sum_number_of_bytes_read",
        "sum_timer_read",
        "count_write",
        "sum_number_of_bytes_write",
        "sum_timer_write",
        "count_misc",
        "sum_timer_misc"
    ),
    "schema_table_statistics": (
        "table_schema",
        "table_name",
        "total_latency",
        "rows_fetched",
        "fetch_latency",
        "rows_inserted",
        "insert_latency",
        "rows_updated",
        "update_latency",
        "rows_deleted",
        "delete_latency",
        "io_read_requests",
        "io_read",
        "io_read_latency",
        "io_write_requests",
        "io_write",
        "io_write_latency",
        "io_misc_requests",
        "io_misc_latency"
    ),
    "x$schema_table_statistics": (
        "table_schema",
        "table_name",
        "total_latency",
        "rows_fetched",
        "fetch_latency",
        "rows_inserted",
        "insert_latency",
        "rows_updated",
        "update_latency",
        "rows_deleted",
        "delete_latency",
        "io_read_requests",
        "io_read",
        "io_read_latency",
        "io_write_requests",
        "io_write",
        "io_write_latency",
        "io_misc_requests",
        "io_misc_latency"
    ),
    "schema_table_statistics_with_buffer": (
        "table_schema",
        "table_name",
        "rows_fetched",
        "fetch_latency",
        "rows_inserted",
        "insert_latency",
        "rows_updated",
        "update_latency",
        "rows_deleted",
        "delete_latency",
        "io_read_requests",
        "io_read",
        "io_read_latency",
        "io_write_requests",
        "io_write",
        "io_write_latency",
        "io_misc_requests",
        "io_misc_latency",
        "innodb_buffer_allocated",
        "innodb_buffer_data",
        "innodb_buffer_free",
        "innodb_buffer_pages",
        "innodb_buffer_pages_hashed",
        "innodb_buffer_pages_old",
        "innodb_buffer_rows_cached"
    ),
    "x$schema_table_statistics_with_buffer": (
        "table_schema",
        "table_name",
        "rows_fetched",
        "fetch_latency",
        "rows_inserted",
        "insert_latency",
        "rows_updated",
        "update_latency",
        "rows_deleted",
        "delete_latency",
        "io_read_requests",
        "io_read",
        "io_read_latency",
        "io_write_requests",
        "io_write",
        "io_write_latency",
        "io_misc_requests",
        "io_misc_latency",
        "innodb_buffer_allocated",
        "innodb_buffer_data",
        "innodb_buffer_free",
        "innodb_buffer_pages",
        "innodb_buffer_pages_hashed",
        "innodb_buffer_pages_old",
        "innodb_buffer_rows_cached"
    ),
    "schema_tables_with_full_table_scans": (
        "object_schema",
        "object_name",
        "rows_full_scanned",
        "latency"
    ),
    "x$schema_tables_with_full_table_scans": (
        "object_schema",
        "object_name",
        "rows_full_scanned",
        "latency"
    ),
    "schema_unused_indexes": (
        "object_schema",
        "object_name",
        "index_name"
    ),
    "schema_table_lock_waits": (
        "object_schema",
        "object_name",
        "waiting_thread_id",
        "waiting_pid",
        "waiting_account",
        "waiting_lock_type",
        "waiting_lock_duration",
        "waiting_query",
        "waiting_query_secs",
        "waiting_query_rows_affected",
        "waiting_query_rows_examined",
        "blocking_thread_id",
        "blocking_pid",
        "blocking_account",
        "blocking_lock_type",
        "blocking_lock_duration",
        "sql_kill_blocking_query",
        "sql_kill_blocking_connection"
    ),
    "x$schema_table_lock_waits": (
        "object_schema",
        "object_name",
        "waiting_thread_id",
        "waiting_pid",
        "waiting_account",
        "waiting_lock_type",
        "waiting_lock_duration",
        "waiting_query",
        "waiting_query_secs",
        "waiting_query_rows_affected",
        "waiting_query_rows_examined",
        "blocking_thread_id",
        "blocking_pid",
        "blocking_account",
        "blocking_lock_type",
        "blocking_lock_duration",
        "sql_kill_blocking_query",
        "sql_kill_blocking_connection"
    ),
    "statement_analysis": (
        "query",
        "db",
        "full_scan",
        "exec_count",
        "err_count",
        "warn_count",
        "total_latency",
        "max_latency",
        "avg_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_sent_avg",
        "rows_examined",
        "rows_examined_avg",
        "rows_affected",
        "rows_affected_avg",
        "tmp_tables",
        "tmp_disk_tables",
        "rows_sorted",
        "sort_merge_passes",
        "max_controlled_memory",
        "max_total_memory",
        "digest",
        "first_seen",
        "last_seen"
    ),
    "x$statement_analysis": (
        "query",
        "db",
        "full_scan",
        "exec_count",
        "exec_secondary_count",
        "err_count",
        "warn_count",
        "total_latency",
        "max_latency",
        "avg_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_sent_avg",
        "rows_examined",
        "rows_examined_avg",
        "rows_affected",
        "rows_affected_avg",
        "tmp_tables",
        "tmp_disk_tables",
        "rows_sorted",
        "sort_merge_passes",
        "max_controlled_memory",
        "max_total_memory",
        "digest",
        "first_seen",
        "last_seen"
    ),
    "statements_with_errors_or_warnings": (
        "query",
        "db",
        "exec_count",
        "errors",
        "error_pct",
        "warnings",
        "warning_pct",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "x$statements_with_errors_or_warnings": (
        "query",
        "db",
        "exec_count",
        "errors",
        "error_pct",
        "warnings",
        "warning_pct",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "statements_with_full_table_scans": (
        "query",
        "db",
        "exec_count",
        "total_latency",
        "no_index_used_count",
        "no_good_index_used_count",
        "no_index_used_pct",
        "rows_sent",
        "rows_examined",
        "rows_sent_avg",
        "rows_examined_avg",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "x$statements_with_full_table_scans": (
        "query",
        "db",
        "exec_count",
        "total_latency",
        "no_index_used_count",
        "no_good_index_used_count",
        "no_index_used_pct",
        "rows_sent",
        "rows_examined",
        "rows_sent_avg",
        "rows_examined_avg",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "x$ps_digest_avg_latency_distribution": (
        "cnt",
        "avg_us"
    ),
    "x$ps_digest_95th_percentile_by_avg_us": (
        "avg_us",
        "percentile"
    ),
    "statements_with_runtimes_in_95th_percentile": (
        "query",
        "db",
        "full_scan",
        "exec_count",
        "err_count",
        "warn_count",
        "total_latency",
        "max_latency",
        "avg_latency",
        "rows_sent",
        "rows_sent_avg",
        "rows_examined",
        "rows_examined_avg",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "x$statements_with_runtimes_in_95th_percentile": (
        "query",
        "db",
        "full_scan",
        "exec_count",
        "err_count",
        "warn_count",
        "total_latency",
        "max_latency",
        "avg_latency",
        "rows_sent",
        "rows_sent_avg",
        "rows_examined",
        "rows_examined_avg",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "statements_with_sorting": (
        "query",
        "db",
        "exec_count",
        "total_latency",
        "sort_merge_passes",
        "avg_sort_merges",
        "sorts_using_scans",
        "sort_using_range",
        "rows_sorted",
        "avg_rows_sorted",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "x$statements_with_sorting": (
        "query",
        "db",
        "exec_count",
        "total_latency",
        "sort_merge_passes",
        "avg_sort_merges",
        "sorts_using_scans",
        "sort_using_range",
        "rows_sorted",
        "avg_rows_sorted",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "statements_with_temp_tables": (
        "query",
        "db",
        "exec_count",
        "total_latency",
        "memory_tmp_tables",
        "disk_tmp_tables",
        "avg_tmp_tables_per_query",
        "tmp_tables_to_disk_pct",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "x$statements_with_temp_tables": (
        "query",
        "db",
        "exec_count",
        "total_latency",
        "memory_tmp_tables",
        "disk_tmp_tables",
        "avg_tmp_tables_per_query",
        "tmp_tables_to_disk_pct",
        "first_seen",
        "last_seen",
        "digest"
    ),
    "user_summary_by_file_io_type": (
        "user",
        "event_name",
        "total",
        "latency",
        "max_latency"
    ),
    "x$user_summary_by_file_io_type": (
        "user",
        "event_name",
        "total",
        "latency",
        "max_latency"
    ),
    "user_summary_by_file_io": (
        "user",
        "ios",
        "io_latency"
    ),
    "x$user_summary_by_file_io": (
        "user",
        "ios",
        "io_latency"
    ),
    "user_summary_by_statement_type": (
        "user",
        "statement",
        "total",
        "total_latency",
        "max_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_examined",
        "rows_affected",
        "full_scans"
    ),
    "x$user_summary_by_statement_type": (
        "user",
        "statement",
        "total",
        "total_latency",
        "max_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_examined",
        "rows_affected",
        "full_scans"
    ),
    "user_summary_by_statement_latency": (
        "user",
        "total",
        "total_latency",
        "max_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_examined",
        "rows_affected",
        "full_scans"
    ),
    "x$user_summary_by_statement_latency": (
        "user",
        "total",
        "total_latency",
        "max_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_examined",
        "rows_affected",
        "full_scans"
    ),
    "user_summary_by_stages": (
        "user",
        "event_name",
        "total",
        "total_latency",
        "avg_latency"
    ),
    "x$user_summary_by_stages": (
        "user",
        "event_name",
        "total",
        "total_latency",
        "avg_latency"
    ),
    "user_summary": (
        "user",
        "statements",
        "statement_latency",
        "statement_avg_latency",
        "table_scans",
        "file_ios",
        "file_io_latency",
        "current_connections",
        "total_connections",
        "unique_hosts",
        "current_memory",
        "total_memory_allocated"
    ),
    "x$user_summary": (
        "user",
        "statements",
        "statement_latency",
        "statement_avg_latency",
        "table_scans",
        "file_ios",
        "file_io_latency",
        "current_connections",
        "total_connections",
        "unique_hosts",
        "current_memory",
        "total_memory_allocated"
    ),
    "host_summary_by_file_io_type": (
        "host",
        "event_name",
        "total",
        "total_latency",
        "max_latency"
    ),
    "x$host_summary_by_file_io_type": (
        "host",
        "event_name",
        "total",
        "total_latency",
        "max_latency"
    ),
    "host_summary_by_file_io": (
        "host",
        "ios",
        "io_latency"
    ),
    "x$host_summary_by_file_io": (
        "host",
        "ios",
        "io_latency"
    ),
    "host_summary_by_statement_type": (
        "host",
        "statement",
        "total",
        "total_latency",
        "max_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_examined",
        "rows_affected",
        "full_scans"
    ),
    "x$host_summary_by_statement_type": (
        "host",
        "statement",
        "total",
        "total_latency",
        "max_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_examined",
        "rows_affected",
        "full_scans"
    ),
    "host_summary_by_statement_latency": (
        "host",
        "total",
        "total_latency",
        "max_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_examined",
        "rows_affected",
        "full_scans"
    ),
    "x$host_summary_by_statement_latency": (
        "host",
        "total",
        "total_latency",
        "max_latency",
        "lock_latency",
        "cpu_latency",
        "rows_sent",
        "rows_examined",
        "rows_affected",
        "full_scans"
    ),
    "host_summary_by_stages": (
        "host",
        "event_name",
        "total",
        "total_latency",
        "avg_latency"
    ),
    "x$host_summary_by_stages": (
        "host",
        "event_name",
        "total",
        "total_latency",
        "avg_latency"
    ),
    "host_summary": (
        "host",
        "statements",
        "statement_latency",
        "statement_avg_latency",
        "table_scans",
        "file_ios",
        "file_io_latency",
        "current_connections",
        "total_connections",
        "unique_users",
        "current_memory",
        "total_memory_allocated"
    ),
    "x$host_summary": (
        "host",
        "statements",
        "statement_latency",
        "statement_avg_latency",
        "table_scans",
        "file_ios",
        "file_io_latency",
        "current_connections",
        "total_connections",
        "unique_users",
        "current_memory",
        "total_memory_allocated"
    ),
    "wait_classes_global_by_avg_latency": (
        "event_class",
        "total",
        "total_latency",
        "min_latency",
        "avg_latency",
        "max_latency"
    ),
    "x$wait_classes_global_by_avg_latency": (
        "event_class",
        "total",
        "total_latency",
        "min_latency",
        "avg_latency",
        "max_latency"
    ),
    "wait_classes_global_by_latency": (
        "event_class",
        "total",
        "total_latency",
        "min_latency",
        "avg_latency",
        "max_latency"
    ),
    "x$wait_classes_global_by_latency": (
        "event_class",
        "total",
        "total_latency",
        "min_latency",
        "avg_latency",
        "max_latency"
    ),
    "waits_by_user_by_latency": (
        "user",
        "event",
        "total",
        "total_latency",
        "avg_latency",
        "max_latency"
    ),
    "x$waits_by_user_by_latency": (
        "user",
        "event",
        "total",
        "total_latency",
        "avg_latency",
        "max_latency"
    ),
    "waits_by_host_by_latency": (
        "host",
        "event",
        "total",
        "total_latency",
        "avg_latency",
        "max_latency"
    ),
    "x$waits_by_host_by_latency": (
        "host",
        "event",
        "total",
        "total_latency",
        "avg_latency",
        "max_latency"
    ),
    "waits_global_by_latency": (
        "events",
        "total",
        "total_latency",
        "avg_latency",
        "max_latency"
    ),
    "x$waits_global_by_latency": (
        "events",
        "total",
        "total_latency",
        "avg_latency",
        "max_latency"
    ),
    "metrics": (
        "Variable_name",
        "Variable_value",
        "Type",
        "Enabled"
    ),
    "processlist": (
        "thd_id",
        "conn_id",
        "user",
        "db",
        "command",
        "state",
        "time",
        "current_statement",
        "execution_engine",
        "statement_latency",
        "progress",
        "lock_latency",
        "cpu_latency",
        "rows_examined",
        "rows_sent",
        "rows_affected",
        "tmp_tables",
        "tmp_disk_tables",
        "full_scan",
        "last_statement",
        "last_statement_latency",
        "current_memory",
        "last_wait",
        "last_wait_latency",
        "source",
        "trx_latency",
        "trx_state",
        "trx_autocommit",
        "pid",
        "program_name",
        "ID",
        "USER",
        "HOST",
        "DB",
        "COMMAND",
        "TIME",
        "STATE",
        "INFO",
        "EXECUTION_ENGINE"
    ),
    "x$processlist": (
        "thd_id",
        "conn_id",
        "user",
        "db",
        "command",
        "state",
        "time",
        "current_statement",
        "execution_engine",
        "statement_latency",
        "progress",
        "lock_latency",
        "cpu_latency",
        "rows_examined",
        "rows_sent",
        "rows_affected",
        "tmp_tables",
        "tmp_disk_tables",
        "full_scan",
        "last_statement",
        "last_statement_latency",
        "current_memory",
        "last_wait",
        "last_wait_latency",
        "source",
        "trx_latency",
        "trx_state",
        "trx_autocommit",
        "pid",
        "program_name"
    ),
    "session": (
        "thd_id",
        "conn_id",
        "user",
        "db",
        "command",
        "state",
        "time",
        "current_statement",
        "execution_engine",
        "statement_latency",
        "progress",
        "lock_latency",
        "cpu_latency",
        "rows_examined",
        "rows_sent",
        "rows_affected",
        "tmp_tables",
        "tmp_disk_tables",
        "full_scan",
        "last_statement",
        "last_statement_latency",
        "current_memory",
        "last_wait",
        "last_wait_latency",
        "source",
        "trx_latency",
        "trx_state",
        "trx_autocommit",
        "pid",
        "program_name"
    ),
    "x$session": (
        "thd_id",
        "conn_id",
        "user",
        "db",
        "command",
        "state",
        "time",
        "current_statement",
        "execution_engine",
        "statement_latency",
        "progress",
        "lock_latency",
        "cpu_latency",
        "rows_examined",
        "rows_sent",
        "rows_affected",
        "tmp_tables",
        "tmp_disk_tables",
        "full_scan",
        "last_statement",
        "last_statement_latency",
        "current_memory",
        "last_wait",
        "last_wait_latency",
        "source",
        "trx_latency",
        "trx_state",
        "trx_autocommit",
        "pid",
        "program_name"
    ),
    "session_ssl_status": (
        "thread_id",
        "ssl_version",
        "ssl_cipher",
        "ssl_sessions_reused"
    ),
    "rds_configuration": (
        "name",
        "value",
        "description"
    ),
    "rds_global_status_history": (
        "collection_end",
        "collection_start",
        "variable_name",
        "variable_value",
        "variable_delta"
    ),
    "rds_global_status_history_old": (
        "collection_end",
        "collection_start",
        "variable_name",
        "variable_value",
        "variable_delta"
    ),
    "general_log_template": (
        "event_time",
        "user_host",
        "thread_id",
        "server_id",
        "command_type",
        "argument"
    ),
    "slow_log_template": (
        "start_time",
        "user_host",
        "query_time",
        "lock_time",
        "rows_sent",
        "rows_examined",
        "db",
        "last_insert_id",
        "insert_id",
        "server_id",
        "sql_text",
        "thread_id"
    ),
    "rds_heartbeat2": (
        "id",
        "value"
    ),
    "rds_sysinfo": (
        "name",
        "value"
    ),
    "aurora_s3_load_history": (
        "load_prefix",
        "file_name",
        "version_number",
        "bytes_loaded",
        "load_timestamp"
    ),
    "general_log_backup": (
        "event_time",
        "user_host",
        "thread_id",
        "server_id",
        "command_type",
        "argument"
    ),
    "slow_log_backup": (
        "start_time",
        "user_host",
        "query_time",
        "lock_time",
        "rows_sent",
        "rows_examined",
        "db",
        "last_insert_id",
        "insert_id",
        "server_id",
        "sql_text",
        "thread_id"
    ),
    "workflow_state_old": (
        "id",
        "timestamp",
        "profile_id",
        "state_id"
    ),
    "user_status_table": (
        "id"
    ),
    "user_status_ml_table": (
        "id",
        "user_status_id",
        "lang_code",
        "title"
    ),
    "user_status_history_table": (
        "id",
        "start_timestamp",
        "end_timestamp",
        "user_status_id"
    ),
    "circlez_team_members": (
        "Title",
        "First Name",
        "Last Name",
        "Gender",
        "Number",
        "Email",
        "Roles",
        "Team(s)",
        "Skills"
    ),
    "profile_ml_view": (
        "profile_id",
        "lang_code",
        "title"
    ),
    "environment": (
        "id",
        "name"
    ),
    "deployment_status": (
        "id",
        "title_en"
    ),
    "deployment": (
        "id",
        "requestor_profile_id",
        "reason",
        "start_datetime",
        "end_datetime",
        "deployment_status_id",
        "branch",
        "environment_id"
    ),
    "user_quota": (
        "user_id",
        "activity_id",
        "soft_quota",
        "hard_quota",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "dialog_workflow_state_history_table_old": (
        "id",
        "timestamp",
        "profile_id",
        "state_id",
        "variable_id",
        "variable_value"
    ),
    "age_media": (
        "id",
        "filename",
        "media",
        "age"
    ),
    "presence": (
        "id"
    ),
    "presence_history": (
        "id",
        "user_id",
        "presence_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "presence_ml": (
        "id",
        "presence_id",
        "lang_code",
        "title"
    ),
    "group_en_approved_main_title_view": (
        "group_id",
        "parent_group_id",
        "is_interest",
        "title",
        "seq"
    ),
    "table_deployments": (
        "id",
        "table_id",
        "environment_id",
        "version",
        "timestamp"
    ),
    "trigger_event": (
        "id",
        "event_name"
    ),
    "checklist_table": (
        "id",
        "triger_event_id",
        "owner_profile_id",
        "subject_profile_id",
        "checklist_template_id",
        "checklist_template_seq",
        "task",
        "due_timestamp",
        "actual_timestamp"
    ),
    "activity_trigger_event": (
        "id",
        "activity_id",
        "trigger_event"
    ),
    "user_list_table": (
        "id"
    ),
    "user_list_old": (
        "id"
    ),
    "user_list_member_table": (
        "id",
        "user_list_id",
        "user_id"
    ),
    "environment_en_view": (
        "environment_id",
        "name"
    ),
    "table_deployment": (
        "id",
        "environment_id",
        "table_id",
        "schema",
        "table_name",
        "version"
    ),
    "table_list_member": (
        "id",
        "table_list_id",
        "table_id"
    ),
    "checklists_templates_table": (
        "checklist_id",
        "tasks",
        "checklist_name"
    ),
    "table_old": (
        "id",
        "schema",
        "table_name",
        "entity_id"
    ),
    "logger_table_old": (
        "ipv4",
        "ipv6",
        "location_id",
        "user_id",
        "profile_id",
        "activity",
        "activity_id",
        "payload",
        "component_id",
        "severity_id",
        "id",
        "timestamp",
        "state_id",
        "variable_id",
        "variable_value_old",
        "variable_value_new",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_datetime",
        "end_datetime"
    ),
    "identity_table": (
        "id",
        "profile_id",
        "email_address_id",
        "phone_id",
        "facebook_id"
    ),
    "activity_list_member_table": (
        "id",
        "activity_list_id",
        "activity_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "os": (
        "id",
        "os_name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "mobile_device": (
        "id",
        "os_id",
        "version",
        "user_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "mobile_account": (
        "id",
        "device_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "mobile_account_profile": (
        "id",
        "mobile_account_id",
        "profile_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "severity_table_old": (
        "id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_datetime",
        "end_datetime"
    ),
    "severity_table_m_old": (
        "id",
        "severity_id",
        "lang_code",
        "description",
        "description_approved"
    ),
    "os_table": (
        "id",
        "os_name",
        "is_mobile_phone",
        "is_desktop",
        "is_tv",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "activity_group_location_occurrence_profile_ml_table": (
        "id",
        "activity_location_occurrence_profile_id",
        "lang_code",
        "title",
        "title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "vacancy_view": (
        "vacancy_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "vacancy_ml_en_view": (
        "lang_code",
        "vacancy_name",
        "vacancy_name_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "employer_profile_vacancy_view": (
        "employer_profile_vacancy_id",
        "employer_profile_id",
        "vacancy_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "employer_profile_profile_view": (
        "employer_profile_profile_id",
        "employer_profile_id",
        "profile_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "service_ml_table": (
        "id",
        "service_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "service_provider_table": (
        "id",
        "profile_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "service_provider_ml_table": (
        "id",
        "service_provider_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "service_receiver_table": (
        "id",
        "profile_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "service_receiver_ml_table": (
        "id",
        "service_receiver_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "service_offer_ml_table": (
        "id",
        "service_offer_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "service_offer_location_table": (
        "id",
        "service_offer_id",
        "location_list_id",
        "extra_price",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "service_review_table": (
        "id",
        "order_id",
        "reaction_id",
        "reaction_value",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "service_review_ml_table": (
        "id",
        "service_review_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "profile_type_ml_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "profile_media_ml_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "location_field_ml_title_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "group_category_ml_title_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "group_category_ml_description_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "location_field_ml_field_name_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "person_ml_first_name_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "person_ml_last_name_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "contact_nickname_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "contact_website1_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "contact_website2_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "contact_website3_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "criteria_vacancy_view": (
        "criteria_vacancy_id",
        "criteria_id",
        "vacancy_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "organization_approved_en_main_view": (
        "organization_id",
        "parent_organization_id",
        "description"
    ),
    "severity_view": (
        "severity id",
        "created timestamp",
        "created user id",
        "updated timestamp",
        "updated user id"
    ),
    "severity_ml_en_view": (
        "severity_ml_id",
        "severity id",
        "language code",
        "description"
    ),
    "computer_vision_storage_view": (
        "computer_vision_storage_id",
        "storage_id",
        "profile_id",
        "coordinate",
        "location_id",
        "json",
        "time_start",
        "time_end",
        "x1",
        "y1",
        "x2",
        "y2",
        "gender_id",
        "min_age",
        "max_age",
        "region",
        "gender_women",
        "gender_man",
        "dominant_gender",
        "black",
        "white",
        "middle eastern",
        "latino_hispanic",
        "angry",
        "disgust",
        "fear",
        "happy",
        "sad",
        "surprise",
        "dominant_emotion",
        "created_timestamp",
        "updated_timestamp",
        "start_timestamp",
        "end_timestamp"
    ),
    "text_category_table": (
        "id",
        "category",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "group_ml_en_view": (
        "group_ml_id",
        "number",
        "identifier",
        "group_id",
        "lang_code",
        "title",
        "is_main_title",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "proxy_profile": (
        "id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "label_email_table_old": (
        "id",
        "label_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "phone_table_old": (
        "id",
        "profile_id",
        "telephone",
        "verification_pin",
        "verification_expiration",
        "approved",
        "approved_timestmp",
        "telephone_label_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_datetime",
        "end_datetime",
        "cira"
    ),
    "proxy_group_list_table": (
        "id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "checklist_group_table": (
        "id",
        "checklist_id",
        "group_id"
    ),
    "product_deal_ml_table": (
        "id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "title",
        "is_title_approved",
        "lang_code",
        "product_deal_id"
    ),
    "status_table": (
        "id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_datetime",
        "end_datetime"
    ),
    "status_table_ml": (
        "id",
        "status_id",
        "lang_code",
        "description"
    ),
    "advertisement_profile": (
        "id",
        "advertisment_id",
        "profile_id",
        "is_clicked",
        "duration_ms"
    ),
    "advertisement_group_table": (
        "id",
        "advertisement_id",
        "group_id"
    ),
    "advertisement_group_list_table": (
        "id",
        "advertisement_id",
        "group_list_id"
    ),
    "logger_group_profile_view": (
        "logger_id",
        "client_ip_v4",
        "client_ip_v6",
        "server_ip_v4",
        "server_ip_v6",
        "location_id",
        "user_id",
        "profile_id",
        "activity",
        "activity_id",
        "message",
        "payload",
        "component_id",
        "error_stack",
        "severity_id",
        "status_id",
        "group_id",
        "relationship_type_id",
        "timestamp",
        "state_id",
        "variable_id",
        "variable_value_old",
        "variable_value_new",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_datetime",
        "end_datetime",
        "component name",
        "programming_language"
    ),
    "logger_severity_level_table": (
        "id",
        "component_id",
        "environment",
        "environment_id",
        "region",
        "region_id",
        "data_store",
        "maximal_severity_level"
    ),
    "campaign_group_table": (
        "id",
        "advertisement_id",
        "group_id"
    ),
    "campaign_group_list_table": (
        "id",
        "advertisement_id",
        "group_list_id"
    ),
    "resource_ml_table": (
        "id",
        "resource_id",
        "language",
        "name"
    ),
    "resource_type_ml_table": (
        "id",
        "resource_type_id",
        "language",
        "name"
    ),
    "resource_type_table": (
        "id",
        "activity_type"
    ),
    "resource_instance_table": (
        "id",
        "resource_id",
        "seq",
        "google_calendar"
    ),
    "resource_instance_ml_table": (
        "id",
        "resource_instance_id",
        "language",
        "name"
    ),
    "shop_seller_table": (
        "id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "shop_id",
        "seller_id",
        "role"
    ),
    "user_age_range": (
        "user_id",
        "age_min",
        "age_max"
    ),
    "user_language": (
        "user_id",
        "lang_code_id"
    ),
    "group_ml_view": (
        "parent_group_id",
        "is_interest",
        "sequence",
        "group_ml_id",
        "number",
        "identifier",
        "group_id",
        "lang_code",
        "title",
        "is_main_title",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_level_ml_table": (
        "id",
        "profile_level_id",
        "lang_code",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved"
    ),
    "location_view": (
        "location_id",
        "name",
        "number",
        "identifier",
        "coordinate",
        "address_local_language",
        "address_english",
        "neighborhood_id",
        "county_id",
        "city_id",
        "region_id",
        "state_id",
        "country_id",
        "postal_code",
        "phonecode",
        "is_approved",
        "is_community_active",
        "group_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "label_question_table": (
        "id",
        "label_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "media_type_table": (
        "id"
    ),
    "media_type_ml_table": (
        "id",
        "media_type_id",
        "lang_code",
        "title"
    ),
    "label_profile_table_old": (
        "id",
        "label_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "profile_profile_level_table": (
        "id",
        "profile_id",
        "profile_level_id"
    ),
    "Groups Not Approved": (
        "Group Category"
    ),
    "logger_view": (
        "logger_id",
        "client_ip_v4",
        "client_ip_v6",
        "server_ip_v4",
        "server_ip_v6",
        "location_id",
        "user_id",
        "profile_id",
        "activity",
        "activity_id",
        "action_id",
        "message",
        "record",
        "payload",
        "component_id",
        "component_name",
        "function_name",
        "error_stack",
        "severity_id",
        "status_id",
        "group_id",
        "relationship_type_id",
        "timestamp",
        "state_id",
        "variable_id",
        "variable_value_old",
        "variable_value_new",
        "field_id",
        "field_value_old",
        "field_value_new",
        "session",
        "thread_id",
        "process_id",
        "api_type",
        "api_type_id",
        "group_id1",
        "group_id2",
        "component_category",
        "testing_framework",
        "component_type",
        "computer_language",
        "developer_email",
        "sql_statement",
        "sql_parameters",
        "sql_formatted",
        "smartlink_identifier",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_datetime",
        "end_datetime",
        "stdout",
        "stderr",
        "return_code",
        "returned_value",
        "return_message",
        "recipient",
        "source_email",
        "destination_emails",
        "message_id",
        "message_template_id",
        "criteria_id",
        "question_id",
        "message_template_text_block_id",
        "is_test_data"
    ),
    "profile_approved_en_main_view": (
        "profile_id",
        "number",
        "profile.main_user_id",
        "main_person_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "is_rip",
        "last_dialog_workflow_state_id_old"
    ),
    "profile_approved_en_view": (
        "id_profile",
        "number",
        "profile.main_user_id",
        "main_person_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "is_rip",
        "last_dialog_workflow_state_id_old"
    ),
    "profile_ml_en_view": (
        "profile_id",
        "number",
        "profile.main_user_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "is_rip",
        "last_dialog_workflow_state_id_old",
        "title"
    ),
    "profile_view": (
        "profile_id",
        "number",
        "identifier",
        "profile.name",
        "profile.main_user_id",
        "main_person_id",
        "is_main",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "main_phone_id",
        "profile.main_email_address",
        "is_rip",
        "profile.gender_id",
        "stars",
        "last_dialog_workflow_state_id_old",
        "is_system",
        "internal_description",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_business_profile"
    ),
    "group_approved_view": (
        "group_id",
        "parent_group_id",
        "parent_group_list_id",
        "is_group_approved",
        "non_members_visibility_id",
        "members_visibility_id",
        "sequence",
        "is_interest",
        "is_job_title",
        "location_id",
        "location_list_id",
        "coordinate",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "group_category_id"
    ),
    "group_view": (
        "group_id",
        "number",
        "identifier",
        "name",
        "system_group_name",
        "hashtag",
        "parent_group_id",
        "parent_group_list_id",
        "is_group_approved",
        "non_members_visibility_id",
        "members_visibility_id",
        "sequence",
        "is_interest",
        "is_job_title",
        "is_role",
        "is_skill",
        "is_organization",
        "is_geo",
        "is_continent",
        "is_country",
        "is_state",
        "is_county",
        "is_region",
        "is_city",
        "is_neighbourhood",
        "is_street",
        "is_zip_code",
        "is_building",
        "is_relationship",
        "is_marital_status",
        "is_official",
        "is_first_name",
        "is_last_name",
        "is_campaign",
        "is_activity",
        "is_sport",
        "is_language",
        "location_id",
        "location_list_id",
        "coordinate",
        "group_category_id",
        "system_id",
        "profile_id",
        "main_group_type_id",
        "is_reddit_group",
        "is_event",
        "is_religion",
        "event_id",
        "profile_list_id",
        "new_group_id",
        "is_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "created_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_community"
    ),
    "component_view": (
        "component_id",
        "name",
        "repo_name",
        "programming_language",
        "programming_language_id",
        "github_repo",
        "parent_component_id",
        "component_type",
        "component_category",
        "testing_framework",
        "api_type"
    ),
    "queue_item_view": (
        "queue_item_id",
        "number",
        "identifier",
        "item_description",
        "action_id",
        "class_parameters_json",
        "function_parameters_json",
        "stdout",
        "stderr",
        "return_code",
        "returned_value",
        "return_message",
        "return_json",
        "queue_status_id",
        "server_ip_v4",
        "server_ip_v6",
        "process_id",
        "thread_id",
        "user_jwt",
        "execution_start_time",
        "execution_end_time",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data"
    ),
    "signature_table": (
        "signature_id",
        "profile_id",
        "lang_code",
        "is_long",
        "template_html"
    ),
    "importer_vacancy_view": (
        "created_timestamp",
        "entity_type_id",
        "title",
        "data_source_type.title",
        "Country",
        "vacancy_name"
    ),
    "business_profile_view": (
        "entity_type_id",
        "entity_type_ml.title",
        "data_source.title",
        "Country",
        "contact_id",
        "name_prefix",
        "full_name",
        "email1",
        "phone1",
        "organization",
        "job_title",
        "department",
        "notes",
        "data_imported_json"
    ),
    "operational_hours_view": (
        "operational_hours_id",
        "profile_id",
        "location_id",
        "day_of_week",
        "from_time",
        "until_time",
        "is_business_hours",
        "operational_hours_type",
        "occurence_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "dialog_workflow_state_view": (
        "dialog_workflow_state_id",
        "state_id",
        "parent_state_id",
        "workflow_action_id",
        "lang_code",
        "parameter1",
        "variable1_id",
        "result_logical",
        "result_figure_min",
        "result_figure_max",
        "next_state_id",
        "no_feedback_milliseconds",
        "next_state_id_if_there_is_no_feedback",
        "message_template_id"
    ),
    "email_address_view": (
        "email_address_id",
        "number",
        "email_address",
        "email_address_approved",
        "verification_pin",
        "verification_expiration",
        "text_block_id",
        "is_verified",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "profile_id_old"
    ),
    "location_profile_view": (
        "location_profile_id",
        "profile_id",
        "location_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "visibility_id"
    ),
    "group_profile_view": (
        "group_profile_id",
        "group_id",
        "profile_id",
        "group_profile_type_id",
        "supplier_category_id",
        "consumer_category_id",
        "participant_category_id",
        "relationship_type_id",
        "is_test_data",
        "start_date_day",
        "start_date_month",
        "start_date_year",
        "start_circa",
        "end_date_day",
        "end_date_year",
        "end_circa",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "file_type_view": (
        "file_type_id",
        "file_type"
    ),
    "storage_view": (
        "storage_id",
        "storage_type_id",
        "path",
        "filename",
        "file_extension_id",
        "file_type_id",
        "region",
        "url",
        "ratio_x",
        "ration_y",
        "width",
        "height",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "location_profile_ml_view": (
        "location_profile_id",
        "profile_id",
        "location_id",
        "lang_code",
        "title",
        "visibility_id",
        "created_effective_profile_id"
    ),
    "profile_reaction_view": (
        "profile_reaction_id",
        "from_profile_id",
        "to_profile_id",
        "reaction_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "test_orm_table": (
        "test_orm_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "community_waiting_list_table": (
        "community_waiting_list_id",
        "profile_id",
        "group_id",
        "timestamp",
        "position",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "age_group_table": (
        "age_group_id",
        "min_age",
        "max_age",
        "age_group_id",
        "min_age",
        "max_age",
        "name"
    ),
    "age_group_group_table": (
        "age_group_group_id",
        "age_group_id",
        "sequence",
        "group_id"
    ),
    "visibility_table": (
        "visibility_id",
        "isEnable"
    ),
    "visibility_ml_table": (
        "visibility_ml_id",
        "visibility_id",
        "lang_code",
        "title"
    ),
    "community_waiting_list_view": (
        "community_waiting_list_id",
        "profile_id",
        "group_id",
        "timestamp",
        "position",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "field_view": (
        "field_id",
        "number",
        "identifier",
        "name",
        "description",
        "variable_id",
        "is_ml_table",
        "table_id",
        "database_field_name",
        "database_sub_field_name",
        "database_sub_field_value",
        "processing_id",
        "processing_database_field_name",
        "internal_description",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "profile_profile_view": (
        "profile_profile_id",
        "number",
        "profile_id1",
        "profile_id2",
        "relationship_type_id",
        "is_potential",
        "profile_profile_role_id",
        "job_title",
        "is_user_request",
        "is_system_recommendation",
        "user_external_id",
        "user_external_level",
        "is_test_data",
        "start_timestamp",
        "start_date_day",
        "start_date_month",
        "start_date_year",
        "start_circa",
        "end_timestamp",
        "end_date_day",
        "end_date_month",
        "end_date_year",
        "end_circa",
        "system_id",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_user_view": (
        "profile_user_id",
        "profile_id",
        "user_id",
        "is_main",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "person_view": (
        "person_id",
        "number",
        "identifier",
        "name",
        "is_approved",
        "is_identity_confirmed",
        "birthday_original",
        "birthday_timestamp",
        "birthday_date",
        "day",
        "month",
        "year",
        "year_cira",
        "gender_id",
        "first_name",
        "is_first_name_approved",
        "nickname",
        "is_nickname_approved",
        "father_name",
        "last_name",
        "last_name_original",
        "is_last_name_approved",
        "is_last_name_sure",
        "is_last_name_auto_generated",
        "person.main_email_address",
        "person.main_email_address_id",
        "main_full_number_normalized",
        "last_coordinate",
        "last_location_id",
        "location_id",
        "is_rip",
        "person.main_profile_id",
        "is_system_data",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "person.preferred_lang_code"
    ),
    "action_view": (
        "action_id",
        "name",
        "is_queue_action",
        "package_name",
        "function_name",
        "function_module",
        "folder_name",
        "filename",
        "is_smartlink_action",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "phone_view": (
        "phone_id",
        "number",
        "number_original",
        "international_code",
        "area_code",
        "local_number_normalized",
        "extension",
        "full_number_normalized",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "package_bank_table": (
        "package_bank_id",
        "amount",
        "message_channel_id",
        "package_id",
        "invoice_id"
    ),
    "profile_account_table": (
        "profile_account_id",
        "profile_id"
    ),
    "invoice_table": (
        "invoice_id",
        "campaign_id",
        "usd",
        "from_profile_account_id",
        "to_profile_accoint_id"
    ),
    "package_template_bank_table": (
        "package_template_bank_id",
        "amount",
        "message_channel_id",
        "package_template_id"
    ),
    "package_table": (
        "package_id",
        "invoice_id",
        "effectove_user_id",
        "package_template_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "package_template_table": (
        "package_template_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "package_template_ml_table": (
        "package_template_ml_id",
        "package_template_id",
        "lang_code",
        "title",
        "title_approved",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "package_ml_table": (
        "package_ml_id",
        "package_id",
        "lang_code",
        "title",
        "title_approved",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "contact_view": (
        "contact_id",
        "number",
        "identifier",
        "owner_profile_id",
        "data_source_instance_id",
        "account_name",
        "person_id",
        "uploaded_timestamp",
        "last_sync_timestamp",
        "name_prefix",
        "original_first_name",
        "first_name",
        "additional_name",
        "original_last_name",
        "last_name",
        "full_name",
        "name_suffix",
        "nickname",
        "display_as",
        "title",
        "organization",
        "organization_profile_id",
        "job_title",
        "job_title_id",
        "job_title_ml_id",
        "department",
        "notes",
        "email1",
        "email2",
        "email3",
        "phone1",
        "phone2",
        "phone3",
        "address1_street",
        "address1_city",
        "address1_state",
        "address1_postal_code",
        "address1_country",
        "address2_street",
        "address2_city",
        "address2_state",
        "address2_postal_code",
        "address2_country",
        "birthday",
        "day",
        "month",
        "year",
        "cira",
        "anniversary",
        "website1",
        "website2",
        "website3",
        "photo_url",
        "photo_file_name",
        "source",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "main_profile_id"
    ),
    "entity_type_view": (
        "entity_type_id",
        "name",
        "system_id",
        "is_item_type",
        "schema_name",
        "table_name",
        "view_name",
        "criteria_schema_name",
        "criteria_table_name",
        "criteria_view_name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "view_with_deleted_and_test_data"
    ),
    "entity_type_ml_en_view": (
        "entity_type_id",
        "entity_type_name",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "country_ml_view": (
        "country_id",
        "coordinate",
        "iso",
        "name",
        "nicename",
        "iso3",
        "numcode",
        "phonecode",
        "lang_code",
        "title",
        "is_title_approved"
    ),
    "county_ml_view": (
        "county_id",
        "state_id",
        "coordinate",
        "lang_code",
        "title",
        "is_title_approved"
    ),
    "neighborhood_ml_view": (
        "neighborhood_id",
        "city_id",
        "name",
        "neighborhood.end_timestamp",
        "lang_code",
        "title",
        "group_id",
        "group.name"
    ),
    "region_ml_view": (
        "region_id",
        "country_id",
        "group_id",
        "is_test_data",
        "lang_code",
        "title",
        "is_title_approved",
        "group.name"
    ),
    "state_ml_view": (
        "state_id",
        "lang_code",
        "title",
        "is_title_approved"
    ),
    "accommodation_table": (
        "accommodation_id"
    ),
    "accommodation_deal_table": (
        "accommodation_deal_id",
        "accommodation_id",
        "start_date",
        "end_date",
        "hospitlity",
        "room_type"
    ),
    "advertisement_type_table": (
        "advertisement_type_id"
    ),
    "event_price_ml_table": (
        "event_price_ml_id",
        "event_price_id",
        "lang_code",
        "description",
        "description_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "event_view": (
        "event_id",
        "number",
        "identifier",
        "name",
        "location_id",
        "organizers_profile_id",
        "website_url",
        "facebook_event_url",
        "meetup_event_url",
        "registration_url",
        "is_event_approved",
        "access_start_timestamp",
        "timezone",
        "segement",
        "genre",
        "sub_genre",
        "type",
        "sub_type",
        "is_family",
        "parent_event_id",
        "is_require_end_user_registration",
        "is_require_organizer_registration_confirmation",
        "is_paid",
        "is_require_end_user_arrival_confirmation",
        "is_can_be_paid_at_the_entrance_in_cash",
        "new_event_id",
        "visibility_id",
        "is_test_data",
        "end_timestamp",
        "is_show_end_timestamp",
        "start_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "event_ml_view": (
        "event_id",
        "lang_code",
        "title"
    ),
    "variable_view": (
        "variable_id",
        "number",
        "identifier",
        "name",
        "description",
        "field_id",
        "person_id",
        "user_id",
        "profile_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "api_limit_view": (
        "api_limit_id",
        "user_external_id",
        "api_type_id",
        "region",
        "soft_limit_value",
        "soft_limit_unit",
        "hard_limit_value",
        "hard_limit_unit",
        "url_to_see_the limit",
        "external_limit_name",
        "external_limit_code",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data"
    ),
    "api_call_view": (
        "api_call_id",
        "user_external_id",
        "api_type_id",
        "number",
        "endpoint_url",
        "outgoing_header_json",
        "outgoing_body_json",
        "outgoing_body_significant_fields_hash",
        "incoming_message_json",
        "http_status_code",
        "response_body_json",
        "is_network",
        "session_token",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "api_type_view": (
        "api_type_id",
        "name",
        "description",
        "is_enabled",
        "endpoint_url",
        "http_method",
        "expiration_unit",
        "expiration_value",
        "interval_min_seconds",
        "interval_max_seconds",
        "from_system_id",
        "from_subsystem_id",
        "to_system_id",
        "to_subsystem_id",
        "message_channel_provider_id",
        "type",
        "action_id",
        "usage_and_billing_url",
        "status_code_when_not_found",
        "github_repo",
        "hander_function_name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "api_type_field_view": (
        "api_type_field_id",
        "api_type_id",
        "field_name",
        "field_significant"
    ),
    "criteria_view": (
        "criteria_id",
        "name",
        "entity_type_id",
        "group_list_id",
        "location_id",
        "location_list_id",
        "coordinate",
        "radius",
        "radius_measure",
        "radius_km",
        "job_group_list_id",
        "job_location_list_id",
        "vacancy_list_id",
        "workplace_profile_list_id",
        "start_date_type_id",
        "job_types_id",
        "user_external_id",
        "visibility_id",
        "where_sql",
        "template_condition",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "internet_domain_id",
        "internet_domain_list_id",
        "organization_name",
        "group_id",
        "profile_list_id",
        "international_code"
    ),
    "recruitment_agency_table": (
        "recruitment_agency_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "profile_recruitment_agency": (
        "profile_recruitment_agency_id",
        "profile_id",
        "recruitment_agency_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "group_recruitment_agency": (
        "group_recruitment_agency_id",
        "group_id",
        "recruitment_agency_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "occurrence_list_table": (
        "occurrence_list_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "occurrence_list_occurrence_table": (
        "occurrence_list_occurrence_id",
        "occurrence_list_id",
        "occurrence_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "occurrence_table": (
        "occurrence_id",
        "start_datetime",
        "is_all_day",
        "repeat_every",
        "repeat_unit",
        "repeat_on_sunday",
        "repeat_on_monday",
        "repeat_on_tuesday",
        "repeat_on_wednesday",
        "repeat_on_thursday",
        "repeat_on_friday",
        "repeat_on_saturday",
        "ends_on",
        "end_datetime",
        "num_occurrences",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "consumer_category_table": (
        "consumer_category_id"
    ),
    "participant_category_table": (
        "participant_category_id"
    ),
    "api_type_field_table": (
        "api_type_field_id",
        "api_type_id",
        "field_name",
        "field_significant"
    ),
    "message_outbox_view": (
        "message_id",
        "identifier",
        "number",
        "label_id",
        "queue_status_id",
        "queue_status_title",
        "compound_message",
        "compound_message_json",
        "compound_message_json_version",
        "process_id",
        "thread_id",
        "user_jwt",
        "class_parameters_json",
        "function_parameters_json",
        "server_ip_v4",
        "server_ip_v6",
        "action_id",
        "exection_start_time",
        "exection_end_time",
        "stdout",
        "stderr",
        "message_label_title",
        "updated_timestamp",
        "return_code",
        "campaign_id",
        "is_test_data",
        "component_id",
        "created_timestamp",
        "is_require_moderator",
        "is_moderator_approved"
    ),
    "message_sent_view": (
        "message_id",
        "identifier",
        "number",
        "actual_send_timestamp",
        "label_id",
        "visibility_id"
    ),
    "importer_per_entity_type_view": (
        "entity_type_ml.title",
        "entity_type_id",
        "created_timestamp",
        "count(importer.importer_table.entity_type_id)"
    ),
    "visibility_id_values_view": (
        "visibility_id",
        "title",
        "isEnable"
    ),
    "relationship_classification_table_old": (
        "id"
    ),
    "profile_metrics_type_table": (
        "profile_metrics_type_id",
        "system_id"
    ),
    "gender_ml_table": (
        "gender_ml_id",
        "gender_id",
        "lang_code",
        "title",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "profile_url_view": (
        "profile_url_id",
        "profile_id",
        "url_id",
        "url_type_id_old",
        "url_old",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "text_block_view": (
        "text_block_id",
        "number",
        "identifier",
        "profile_id",
        "seq",
        "text",
        "text_without_empty_lines",
        "system_id",
        "system_entity_id",
        "text_block_type_id",
        "fields_extracted_json",
        "url",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "text_block_type_view": (
        "text_block_type_id",
        "system_id",
        "system_entity_id",
        "regex",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "text_block_type_regex_view": (
        "text_block_type_regex_id",
        "text_block_type_id",
        "regex",
        "lang_code",
        "description",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "text_block_type_ml_table": (
        "text_block_type_ml_id",
        "text_block_type_id",
        "lang_code",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "text_block_type_ml_en_view": (
        "text_block_type_id",
        "system_id",
        "system_entity_id",
        "regex",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "text_block_type_ml_id",
        "lang_code",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved"
    ),
    "text_block_type_ml_view": (
        "text_block_type_id",
        "system_id",
        "system_entity_id",
        "regex",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "text_block_type_ml_id",
        "lang_code",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved"
    ),
    "profile_metrics_view": (
        "profile_metrics_id",
        "profile_id",
        "profile_metrics_type",
        "value",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "replication_group_configuration_version": (
        "name",
        "version"
    ),
    "ro_replica_status_internal": (
        "Server_id",
        "Session_id",
        "Iops",
        "Read_IOs",
        "Pending_Read_IOs",
        "Cpu",
        "Durable_lsn",
        "Active_lsn",
        "Last_transport_error",
        "Last_error_timestamp",
        "Last_updated_timestamp",
        "Writer_reader_latency_in_usec",
        "Replica_lag_in_msec",
        "Log_stream_speed_in_KiB_per_second",
        "Log_buffer_sequence_number",
        "Is_current",
        "Oldest_read_view_trx_id",
        "Oldest_read_view_lsn",
        "Highest_lsn_received",
        "Current_read_lsn",
        "Current_replay_latency_in_usec",
        "Average_replay_latency_in_usec",
        "Max_replay_latency_in_usec"
    ),
    "ro_replica_status": (
        "Server_id",
        "Session_id",
        "Iops",
        "Read_IOs",
        "Pending_Read_IOs",
        "Cpu",
        "Durable_lsn",
        "Active_lsn",
        "Last_transport_error",
        "Last_error_timestamp",
        "Last_updated_timestamp",
        "Writer_reader_latency_in_usec",
        "Replica_lag_in_msec",
        "Log_stream_speed_in_KiB_per_second",
        "Log_buffer_sequence_number",
        "Is_current",
        "Oldest_read_view_trx_id",
        "Oldest_read_view_lsn",
        "Highest_lsn_received",
        "Current_read_lsn",
        "Current_replay_latency_in_usec",
        "Average_replay_latency_in_usec",
        "Max_replay_latency_in_usec"
    ),
    "channel_provider_table": (
        "channel_provider_id",
        "message_channel_id",
        "message_provider_id"
    ),
    "subscription_ml_table": (
        "subscription_ml_id",
        "subscription_id",
        "lang_code",
        "title",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "employer_profile_profile_table": (
        "employer_profile_profile_id",
        "employer_profile_id",
        "profile_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "employer_name"
    ),
    "criteria_promotional_message_to_person_table": (
        "criteria_promotional_message_to_person_id",
        "criteria_id",
        "multiply_from_yesterday",
        "promotional_message_to_person_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "computer_vision_storage_table": (
        "computer_vision_storage_id",
        "storage_id",
        "profile_id",
        "coordinate",
        "location_id",
        "json",
        "time_start",
        "time_end",
        "x1",
        "y1",
        "x2",
        "y2",
        "gender_id",
        "min_age",
        "max_age",
        "region",
        "gender_women",
        "gender_man",
        "dominant_gender",
        "black",
        "white",
        "middle eastern",
        "latino_hispanic",
        "angry",
        "disgust",
        "fear",
        "happy",
        "sad",
        "surprise",
        "dominant_emotion",
        "created_timestamp",
        "updated_timestamp",
        "start_timestamp",
        "end_timestamp"
    ),
    "buyer_ml_table": (
        "buyer_ml_id",
        "buyer_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "buyer_ml_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "group_category_ml_table": (
        "group_category_ml_id",
        "group_category_id",
        "lang_code",
        "title",
        "is_main_title",
        "description",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "criteria_vacancy_table": (
        "criteria_vacancy_id",
        "criteria_id",
        "vacancy_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "vacancy_table": (
        "vacancy_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "test_location_profile_mapping_ml_table": (
        "test_location_profile_ml_id",
        "test_location_profile_id",
        "lang_code",
        "title",
        "title_approved"
    ),
    "job_title_vacancy_table": (
        "job_title_vacancy_id",
        "job_title_id",
        "vacancy_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "vacancy_ml_table": (
        "vacancy_ml_id",
        "vacancy_id",
        "lang_code",
        "vacancy_name",
        "vacancy_name_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "test_typeorm_ml_table": (
        "test_typeorm_ml_id",
        "test_typeorm_id",
        "title",
        "is_title_approved",
        "lang_code",
        "unique_int_column",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "base_entity_table": (
        "base_entity_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "message_sent_table": (
        "message_sent_id",
        "message_id",
        "message_channel_id",
        "sender_profile_id",
        "request_to_send_timestamp",
        "sent_timestamp"
    ),
    "message_template_table": (
        "message_template_id",
        "name"
    ),
    "advertisement_message_template_table": (
        "advertisement_message_template_id",
        "advertisement_id",
        "message_template_id"
    ),
    "location_news_table": (
        "location_news_id",
        "location_id",
        "news_id"
    ),
    "profile_preference_group_table": (
        "profile_preference_group_id",
        "name"
    ),
    "profile_preference_group_group_table": (
        "profile_preference_group_group_id",
        "profile_preference_group_id",
        "profile_preferences_id"
    ),
    "profile_preference_group_ml_table": (
        "profile_preference_group_ml_id",
        "profile_preference_group_id",
        "lang_code",
        "is_main",
        "name",
        "description"
    ),
    "profile_preference_ml_table": (
        "profile_preference_ml_id",
        "profile_preference_id",
        "lang_code",
        "is_main",
        "name",
        "description"
    ),
    "sport_event_ml_table": (
        "sport_event_ml_id",
        "sport_event_id",
        "lang_code",
        "is_main",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved"
    ),
    "sport_event_table": (
        "sport_event_id",
        "name",
        "is_name_approve",
        "description",
        "is_description_approved",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "news_table": (
        "news_id"
    ),
    "news_ml_table": (
        "news_ml_id",
        "news_id",
        "lang_code",
        "title",
        "is_title_approved",
        "content_html",
        "is_context_html_approved",
        "content_text",
        "is_context_text_approved"
    ),
    "table_history_table": (
        "table_history_id",
        "datetime",
        "schema",
        "table",
        "sql_statement",
        "MAX_EXECUTION_TIME Miliseconds",
        "is_successful",
        "rows",
        "MySQL Workbench Duration Seconds",
        "MySQL Workbench Seconds"
    ),
    "relationship_type_view": (
        "relationship_type_id",
        "party1_profile_category_id",
        "party1_gender_id",
        "party2_profile_category_id",
        "party2_gender_id",
        "is_directional",
        "is_direct_connection",
        "relationship_category_id",
        "past_present_future",
        "profile1_older_than_profile2",
        "is_user_level",
        "relationship_type_classification_id",
        "party1_older_min_years",
        "party1_older_max_years",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "logger_function_start_end_view": (
        "logger_id",
        "created_timestamp",
        "severity_id",
        "severity_description",
        "component_id",
        "logger.component_name",
        "function_name",
        "logger.developer_email",
        "session",
        "process_id",
        "thread_id",
        "component.developer_email",
        "component.component_name"
    ),
    "profile_category_ml_table": (
        "profile_category_ml_id",
        "profile_category_id",
        "lang_code",
        "title",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_category_table": (
        "profile_category_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "campaign_view": (
        "campaign_id",
        "name",
        "start_hour",
        "end_hour",
        "occurrence_id",
        "days_of_week",
        "minimal_days_between_messages_to_the_same_recipient",
        "start_timestamp",
        "end_timestamp",
        "max_audience",
        "message_template_id_old",
        "is_test_data",
        "max_exposure_per_day"
    ),
    "group_storage_blob_table": (
        "group_storage_id",
        "image",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "group_storage_table": (
        "group_storage_id",
        "group_id",
        "file_type_id",
        "storage_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "action_star_subscription_view": (
        "action_star_subscription_id",
        "number",
        "action_id",
        "file_type_id",
        "subscription_id",
        "action_stars",
        "is_conditional",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "subscription_user_view": (
        "user_subscription_id",
        "subscription_id",
        "user_id",
        "start_datetime",
        "end_datetime",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "phone_ml_table": (
        "phone_ml_id",
        "phone_id",
        "lang_code",
        "title",
        "title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "search_result_table": (
        "search_result_id",
        "search_id",
        "entity_type",
        "entity_type_id",
        "result_text",
        "result_json"
    ),
    "search_request_table": (
        "search_request_id",
        "search_request_text",
        "search_request_json"
    ),
    "importer_recent_view": (
        "created_timestamp",
        "importer_id",
        "data_source_type.title",
        "importer_country_name",
        "entity_type_id",
        "entity_type_ml.title",
        "entity_id"
    ),
    "user_general_view": (
        "person_id",
        "person.is_approved",
        "person.main_email_address",
        "user.main_email_address",
        "username",
        "user_id",
        "user.is_approved",
        "user.is_test_data",
        "profile.name",
        "profile.preferred_lang_code",
        "profile.gender_id",
        "profile.main_email_address",
        "user.first_name",
        "user.last_name",
        "user.created_timestamp",
        "profile_id",
        "profile.main_user_id",
        "brand_id",
        "user.active_location_id",
        "user.active_location.country_ml.title",
        "subscription_id",
        "subscription_title",
        "user.stars",
        "profile.stars",
        "person.birthday_date",
        "profile.phone.full_number_normalized",
        "role_name",
        "email_address",
        "last_login_timestamp"
    ),
    "message_type_ml_table": (
        "message_type_ml_id",
        "message_type_id",
        "lang_code",
        "type_id",
        "subeject",
        "body",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "message_type_table": (
        "message_type_table_id",
        "version",
        "channel_type_id"
    ),
    "message_read_table": (
        "message_read_id",
        "message_id",
        "channel_id",
        "profile_id",
        "timestamp"
    ),
    "message_content_ml_table": (
        "message_content_ml_id",
        "message_content_id",
        "lang_code",
        "channel_id",
        "subeject",
        "body",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "message_content_table": (
        "message_content_id",
        "message_id",
        "version",
        "content_type_id"
    ),
    "relationship_type_classification_table": (
        "relationship_type_classification_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "relationship_type_classification_ml_table": (
        "relationship_type_classification_ml_id",
        "relationship_type_classification_id",
        "lang_code",
        "title",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_type_ml_table": (
        "profile_type_ml_id",
        "profile_type_id",
        "lang_code",
        "title",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_list_profile_table_2delete": (
        "profile_list_profile_id",
        "profile_list_id",
        "profile_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "subscription_user_table": (
        "user_subscription_id",
        "subscription_id",
        "user_id",
        "start_datetime",
        "end_datetime",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "profile_media_table": (
        "profile_media_id",
        "profile_id",
        "media_source_url",
        "media_licenses_id",
        "media_type_id",
        "storage_id",
        "image",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "profile_media_ml_table": (
        "profile_media_ml_id",
        "profile_media_id",
        "lang_code",
        "title",
        "description",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "event_external_view": (
        "event_external_id",
        "system_id",
        "subsystem_id",
        "url",
        "external_event_identifier",
        "environment_id",
        "is_approved",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "user_external_view": (
        "user_external_id",
        "number",
        "identifier",
        "system_id",
        "subsystem_id",
        "username",
        "email_address_id",
        "handle",
        "access_token_old",
        "base_credentials_token_old",
        "token_2delete",
        "refresh_token_old",
        "is_refresh_token_valid",
        "expiry_old",
        "oauth_token",
        "oauth_token_secret",
        "oauth_callback_confirmed",
        "oauth_state",
        "environment_id_old",
        "main_profile_id",
        "url_id",
        "credential_storage_id",
        "additional_fields_json",
        "description",
        "customer_id",
        "project_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "message_outgoing_table_shall_we_delete_it": (
        "message_outgoing_id",
        "timestamp",
        "from_profile_id",
        "to_profile_id",
        "cc_profile_id",
        "bcc_profile_id",
        "request_to_send_timestamp",
        "scheduled_sent_timestamp",
        "actual_sent_timestamp",
        "message_type_id",
        "message_channel_id",
        "sending_message_result_id"
    ),
    "profile_user_external_view": (
        "profile_user_external_id",
        "user_external_id",
        "profile_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "activity_ml_table_old": (
        "activity_ml_id",
        "activity_id",
        "lang_code",
        "title",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "activity_list_table": (
        "activity_list_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "activity_star_subscription_table": (
        "activity_star_subscription_id",
        "activity_id",
        "subscription_id",
        "activity_stars"
    ),
    "language_user_table": (
        "language_user_id",
        "lang_code",
        "user_id",
        "language_user_type",
        "rank"
    ),
    "user_preference_table": (
        "user_preference_id",
        "user_id",
        "preferences_internal_name",
        "is_active",
        "value"
    ),
    "preference_table": (
        "preference_id",
        "preferences_internal_name",
        "is_active",
        "default_value"
    ),
    "profile_preference_table": (
        "profile_preference_id",
        "profile_id",
        "preferences_internal_name",
        "is_active",
        "value"
    ),
    "label_message_view": (
        "label_message_id",
        "message_id",
        "label_id"
    ),
    "queue_status_ml_table": (
        "queue_status_ml_id",
        "queue_status_id",
        "lang_code",
        "title"
    ),
    "api_parameter_table": (
        "api_parameters_id",
        "api_type_id",
        "type",
        "name"
    ),
    "currency_ml_table": (
        "currency_ml_id",
        "currency_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "api_budget_table": (
        "api_budget_id",
        "system_id",
        "subsystem_id",
        "unit",
        "priceset_id",
        "text",
        "url"
    ),
    "logger_dialog_workflow_state_history_view": (
        "timestamp",
        "profile_id",
        "state_id",
        "variable_id",
        "variable_value_old",
        "variable_value_new",
        "created_timestamp"
    ),
    "dialog_workflow_state_history_view_old": (
        "timestamp",
        "profile_id",
        "state_id",
        "variable_id",
        "variable_value_new"
    ),
    "smartlink_view": (
        "smartlink_id",
        "identifier",
        "number",
        "smartlink_type_id",
        "from_contact_id",
        "from_person_id",
        "from_user_id",
        "from_profile_id",
        "from_email_address_old",
        "from_email_address_id",
        "from_normalized_phone",
        "from_phone_id",
        "to_contact_id",
        "to_person_id",
        "to_user_id",
        "to_profile_id",
        "to_group_id",
        "to_email_address_old",
        "to_email_address_id",
        "to_normalized_phone_old",
        "to_phone_id",
        "action_id",
        "lang_code",
        "campaign_id",
        "message_template_id",
        "smartlink_message_id",
        "content_message_id",
        "dialog_workflow_script_id",
        "clicked_timestamp",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "url_redirect"
    ),
    "city_ml_view": (
        "city_id",
        "lang_code",
        "is_main",
        "title",
        "coordinate",
        "name",
        "phonecode",
        "location_city_name",
        "city_ml_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "price_set_range_table": (
        "price_set_range_id"
    ),
    "product_deal_table": (
        "product_deal_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "currency_id",
        "quantity",
        "shop_id",
        "product_id",
        "regular_price",
        "price_set_id",
        "max_price_set_id",
        "min_price_set_id",
        "url"
    ),
    "event_status_table": (
        "event_status_id"
    ),
    "event_status_ml_table": (
        "event_status_ml_id",
        "event_status_id",
        "lang_code",
        "title",
        "title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "product_table": (
        "product_id"
    ),
    "product_url_table": (
        "product_url_id",
        "product_id",
        "url_type_id",
        "url",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "event_storage_table": (
        "event_storage_id",
        "event_id",
        "storage_id",
        "is_official"
    ),
    "message_channel_provider_table": (
        "message_channel_provider_id",
        "provider_name",
        "supplier_id"
    ),
    "message_channel_provider_ml_table": (
        "message_channel_provider_ml_id",
        "message_provider_id",
        "lang_code",
        "message_provider_name"
    ),
    "person_kid_table": (
        "person_kids_id",
        "person_id",
        "number_of_kids"
    ),
    "phone_profile_view": (
        "phone_profile_id",
        "profile_id",
        "phone_id",
        "is_main",
        "label_phone_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "phone_profile_main_view": (
        "phone_profile_id",
        "profile_id",
        "phone_id",
        "is_main",
        "label_phone_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "campaign_status_table": (
        "campaign_status_id"
    ),
    "campaign_ml_table": (
        "campaign_ml_id",
        "campaign_id",
        "lang_code",
        "title",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "campaign_status_ml_table": (
        "campaign_status_ml_id",
        "campaign_status_id",
        "lang_code",
        "title",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "role_user_table": (
        "role_user_id",
        "role_id",
        "user_id"
    ),
    "workflow_action_ml_view": (
        "workflow_action_ml_id",
        "workflow_action_id",
        "lang_code",
        "title"
    ),
    "field_alias_view": (
        "field_alias_id",
        "field_name",
        "system_id",
        "subsystem_id",
        "field_id",
        "visibility_id"
    ),
    "email_address_profile_table": (
        "email_address_profile_id",
        "email_address_id",
        "profile_id",
        "is_main",
        "is_sure",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "phone_profile_verification_table": (
        "phone_profile_verification_id",
        "phone_profile_id"
    ),
    "test_mysql_ml_view": (
        "number",
        "test_mysql_ml_id",
        "test_mysql_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "unique_int_column",
        "created_timestamp",
        "created_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "visibility_id"
    ),
    "test_mysql_view": (
        "test_mysql_id",
        "number",
        "identifier",
        "name",
        "group",
        "unique_int_column",
        "point",
        "polygon",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "event_event_external_table": (
        "event_event_external_id",
        "event_external_id",
        "event_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_event_id",
        "updated_timestamp",
        "updated_event_id"
    ),
    "event_event_external_view": (
        "event_event_external_id",
        "event_external_id",
        "event_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_event_id",
        "updated_timestamp",
        "updated_event_id"
    ),
    "campaign_smartlink_table": (
        "campaign_smartlink_id",
        "campaign_id",
        "smartlink_id"
    ),
    "campaign_smartlink_view": (
        "campaign_smartlink_id",
        "campaign_id",
        "smartlink_id"
    ),
    "profile_storage_type_table": (
        "profile_storage_type_id",
        "name",
        "file_type_id"
    ),
    "entity_moderation_history_table": (
        "entity_moderation_history_id",
        "entity_type",
        "entity_id",
        "is_need_more_info",
        "is_approved",
        "update_entity_profile_id",
        "logger_id",
        "session"
    ),
    "entity_moderation_table": (
        "entity_moderation_id",
        "entity_type",
        "entity_id",
        "is_need_more_info",
        "is_approved",
        "create_entity_profile_id",
        "create_entity_logger_id",
        "stars_logger_id",
        "create_session"
    ),
    "role_user_view": (
        "role_user_id",
        "role_id",
        "user_id"
    ),
    "role_ml_view": (
        "role_ml_id",
        "role_id",
        "lang_code",
        "name"
    ),
    "role_user_general_view": (
        "user_id",
        "lang_code",
        "name"
    ),
    "role_ml_table": (
        "role_ml_id",
        "role_id",
        "lang_code",
        "name"
    ),
    "group_list_member_view": (
        "group_list_member_id",
        "group_list_id",
        "group_id"
    ),
    "location_type_ml_table": (
        "location_type_ml_id",
        "location_type_id",
        "lang_code",
        "title",
        "title_approved",
        "is_main",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "user_login_history_view": (
        "user_id",
        "user_first_name",
        "user_last_name",
        "user.main_email_address",
        "user_created_timestamp",
        "login_timestamp"
    ),
    "table_type_table": (
        "table_type_id",
        "name",
        "description"
    ),
    "action_logger_view": (
        "action_id",
        "name",
        "source.system.title",
        "destination.system.title",
        "count(logger.action_id)"
    ),
    "logger_action_view": (
        "timestamp",
        "action_id",
        "name",
        "source system name",
        "destination system name"
    ),
    "programming_language_table": (
        "programming_language_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "item_type_view": (
        "item_type_id",
        "entity_type_id"
    ),
    "item_rendered_view": (
        "item_rendered_id",
        "item_type_id",
        "item_id",
        "profile_id",
        "user_id",
        "view_timestamp",
        "view_duration"
    ),
    "entity_type_ml_view": (
        "entity_type_ml_id",
        "entity_type_id",
        "lang_code",
        "title",
        "is_title_approved",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "message_template_message_template_text_block_view": (
        "message_template_message_template_text_block_type_id",
        "message_template_message_template_text_block_id",
        "message_template_id",
        "message_template_text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "message_template_view": (
        "message_template_id",
        "name"
    ),
    "message_template_text_block_view": (
        "message_template_text_block_id",
        "criteria_id_old",
        "criteria_set_id",
        "question_id",
        "message_template_text_block_type_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "message_template_text_block_ml_view": (
        "message_template_text_block_ml_id",
        "message_template_text_block_id",
        "lang_code",
        "default_subject_template",
        "default_body_template",
        "sms_body_template",
        "email_subject_template",
        "email_body_html_template",
        "whatsapp_body_template"
    ),
    "question_ml_view": (
        "question_ml_id",
        "question_id",
        "lang_code",
        "title"
    ),
    "question_view": (
        "question_id",
        "name",
        "question_type_id",
        "answer_expiration_days",
        "table_id",
        "where_statement",
        "is_required",
        "variable_id",
        "default_value",
        "is_visible",
        "label_question_id",
        "hint",
        "uischema_attributes",
        "schema_attributes",
        "default_question_possible_answer_id"
    ),
    "star_transaction_view": (
        "star_transaction_id",
        "identifier",
        "api_type_id",
        "activity_type_id",
        "action_id",
        "person_id",
        "user_id",
        "subscription_id",
        "action_stars",
        "balance_after_transaction",
        "number",
        "is_test_data"
    ),
    "platform_table": (
        "platform_id",
        "number",
        "platform_name",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "first_name_alias_table": (
        "first_name_alias_id",
        "first_name_id1",
        "first_name_id2"
    ),
    "smartlink_type_view": (
        "smartlink_type_id",
        "smartlink.name",
        "dialog_workflow_script_id_old",
        "action_id",
        "expiration_value",
        "expiration_unit",
        "is_test_data",
        "url_redirect_template"
    ),
    "event_group_table": (
        "event_group_id",
        "event_id",
        "group_id"
    ),
    "url_type_ml_table": (
        "url_type_ml_id",
        "url_type_id",
        "lang_code",
        "title",
        "is_main_title",
        "description",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "brand_url_table": (
        "brand_url_id",
        "brand_id",
        "url_type_id",
        "url"
    ),
    "criteria_group_table": (
        "criteria_group_id",
        "criteria_id",
        "group_id"
    ),
    "sql_structure2code_table": (
        "sql_structure2code_id",
        "name"
    ),
    "message_profile_view": (
        "message_profile_id",
        "message_id",
        "profile_id",
        "reaction_id",
        "user_id",
        "message_status_id"
    ),
    "item_rendered_table": (
        "item_rendered_id",
        "item_type_id",
        "item_id",
        "profile_id",
        "user_id",
        "view_timestamp",
        "view_duration"
    ),
    "item_profile_view": (
        "item_profile_id",
        "item_id",
        "profile_id",
        "message_id",
        "visibility_id",
        "seen_summary_start_timestamp",
        "seen_summary_end_timestamp",
        "seen_body_start_timestamp",
        "seen_body_end_timestamp",
        "exposure_time_miliseconds",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "item_profile_general_view": (
        "source_name",
        "item_id",
        "item_type_id",
        "profile_id",
        "recommendation_model_id"
    ),
    "group_list_member_table": (
        "group_list_member_id",
        "group_list_id",
        "group_id"
    ),
    "database_engine_table": (
        "database_engine_id",
        "product",
        "engine",
        "is_serverless",
        "serverless_version",
        "supplier_id",
        "is_data_api"
    ),
    "environment_repo_table": (
        "environment_repo_id",
        "environment_id",
        "repo_id",
        "status"
    ),
    "device_table": (
        "device_id",
        "os_id",
        "version",
        "user_id",
        "profile_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "profile_metrics_type_ml_table": (
        "profile_metrics_type_ml_id",
        "profile_metrics_type_id",
        "lang_code",
        "is_main",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved",
        "is_test_data"
    ),
    "event_external_approved_view": (
        "event_external_id",
        "system_id",
        "subsystem_id",
        "url",
        "external_event_identifier",
        "environment_id",
        "is_approved",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "dialog_workflow_script_ml_view": (
        "dialog_workflow_script_ml_id",
        "dialog_workflow_script_id",
        "lang_code",
        "title"
    ),
    "dialog_workflow_script_view": (
        "dialog_workflow_script_id",
        "name",
        "start_state_id",
        "max_state_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_page_table": (
        "profile_page_id",
        "profile_id",
        "is_approved",
        "parent_profile_id"
    ),
    "profile_page_ml_table": (
        "profile_page_ml_id",
        "profile_page_id",
        "lang_code",
        "title",
        "is_main"
    ),
    "event_external_table": (
        "event_external_id",
        "system_id",
        "subsystem_id",
        "url",
        "external_event_identifier",
        "environment_id",
        "is_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "workflow_action_ml_table": (
        "workflow_action_ml_id",
        "workflow_action_id",
        "lang_code",
        "title"
    ),
    "internet_domain_view": (
        "internet_domain_id",
        "domain",
        "organization_id",
        "top_level_domain",
        "is_commercial_webmail",
        "profile_id",
        "profile_list_id",
        "is_email_assign_profile_organization_to_people",
        "is_url_assign_profile_organization_to_people"
    ),
    "device_user_external_table": (
        "devicel_user_externa_id",
        "device_id",
        "user_external_id"
    ),
    "contact_email_address_view": (
        "contact_email_address_id",
        "contact_id",
        "email_address_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "dialog_workflow_general_view": (
        "dialog_workflow_script_id",
        "start_state_id",
        "dialog_workflow_script_ml_id",
        "title",
        "dialog_workflow_state_id",
        "state_id",
        "workflow_action_id",
        "workflow action name",
        "description",
        "variable1_id",
        "variable name"
    ),
    "node_table": (
        "node_id",
        "environment_id",
        "cloud_region_id",
        "cloud_region_name",
        "description",
        "min_bigint_id",
        "max_bigint_id"
    ),
    "cloud_vendor_table": (
        "cloud_vendor_id",
        "name",
        "seller_id",
        "cloud_vendor_id",
        "seller_id"
    ),
    "cloud_region_table": (
        "cloud_region_id",
        "name",
        "cloud_vendor_id",
        "cloud_region_id",
        "cloud_vendor_id",
        "name"
    ),
    "campaign_message_template_table": (
        "campaign_message_template_id",
        "campaign_id",
        "message_template_id",
        "percent"
    ),
    "relationship_type_general_view": (
        "relationship_type_id",
        "party1_profile_category_id",
        "party1_profile_category_title",
        "party1_gender_id",
        "gender1",
        "party2_profile_category_id",
        "party2_profile_category_title",
        "party2_gender_id",
        "gender2",
        "description",
        "is_directional",
        "is_direct_connection",
        "relationship_category_id",
        "relationship_type_classification_title",
        "past_present_future",
        "profile1_older_than_profile2",
        "is_user_level",
        "relationship_type_classification_id",
        "party1_older_min_years",
        "party1_older_max_years",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "activity_type_table": (
        "activity_type_id"
    ),
    "activity_type_ml_table": (
        "activity_type_ml_id",
        "activity_type_id",
        "lang_code",
        "title",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "message_template_rfp_table": (
        "message_template_rfp_id",
        "message_template_id",
        "rfp_id"
    ),
    "buyer_table": (
        "buyer_id",
        "profile_id",
        "criteria_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "service_type_table": (
        "service_type_id"
    ),
    "seller_ml_table": (
        "seller_ml_id",
        "seller_id",
        "lang_code",
        "title",
        "is_title_approved",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "rfp_ml_table": (
        "rfp_ml_id",
        "rfp_id",
        "lang_code",
        "title",
        "is_title_approved",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "rfp_requirements_table": (
        "rfp_requirements_id",
        "rfp_id",
        "pririty",
        "field_id",
        "min_value",
        "max_value"
    ),
    "campaign_traction_table": (
        "campaign_traction_id",
        "campaign_id",
        "smartlink_id",
        "person_id",
        "contact_id",
        "message_id",
        "is_exposed_deal_details"
    ),
    "rfp_referral_table": (
        "rfp_referral_id",
        "number",
        "identifier",
        "rfp_id",
        "seller_id",
        "buyer_id",
        "smartlink_id",
        "message_id",
        "press_link_in_content_message_timestamp",
        "seller_exposed_rfp_details_timestmap",
        "seller_exposed_buyer_phone_timestmap",
        "seller_exposed_buyer_email_address_timestmap",
        "seller_exposed_buyer_address_timestmap",
        "seller_interested_in_rfp_timestamp",
        "seller_interested_to_approach_buyer_timestamp",
        "seller_interested_that_buyer_will_approach_seller_timestamp",
        "seller_approach_buyer_using_message_to_phone_timestamp",
        "seller_approach_buyer_using_message_to_email_timestamp",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "repo_dependency_table": (
        "repo_dependency_id",
        "repo_id",
        "dependent_on_repo_id"
    ),
    "source_code_table": (
        "source_code_id",
        "repo_id",
        "path",
        "filename",
        "version",
        "tag",
        "programming_language_id"
    ),
    "message_template_text_block_type_ml_view": (
        "message_template_text_block_type_ml_id",
        "message_template_text_block_type_id",
        "lang_code",
        "title"
    ),
    "operational_hours_table": (
        "operational_hours_id",
        "profile_id",
        "location_id",
        "day_of_week",
        "from_time",
        "until_time",
        "is_business_hours",
        "operational_hours_type",
        "occurence_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data"
    ),
    "contact_reaction_table": (
        "contact_reaction_id",
        "number",
        "identifier",
        "contact_id",
        "reaction_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_contact_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_contact_id"
    ),
    "profile_metrics_table": (
        "profile_metrics_id",
        "profile_id",
        "profile_metrics_type",
        "value",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "person_in_all_table_view": (
        "COUNT(person_id)"
    ),
    "contact_note_text_block_view": (
        "contact_note_text_block_id",
        "contact_note_id",
        "seq",
        "text_block_id"
    ),
    "json_version_source_code_table": (
        "json_version_source_code_id",
        "json_version_id",
        "source_code_id"
    ),
    "json_version_table": (
        "json_version_id",
        "json_name",
        "table_id",
        "field_name",
        "version"
    ),
    "event_news_table": (
        "event_news_id",
        "event_id",
        "news_id"
    ),
    "group_news_table": (
        "group_news_id",
        "number",
        "identifier",
        "group_id",
        "label_id",
        "hashtag",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "event_profile_email_table": (
        "event_profile_email_id",
        "event_id",
        "profile_id",
        "number_of_hours_before_event",
        "channel_id",
        "is_number_of_participants",
        "is_list_with_full_names"
    ),
    "brand_location_table": (
        "brand_location_id",
        "brand_id",
        "location_id"
    ),
    "error_table": (
        "error_id",
        "identifier",
        "description",
        "source_code_id"
    ),
    "avatar_table": (
        "avatar_id",
        "profile_id",
        "name",
        "system",
        "subsystem"
    ),
    "contact_group_view": (
        "contact_group_id",
        "contact_id",
        "group_id",
        "group_ml_id",
        "seq",
        "attribute",
        "contact_group_type_id",
        "supplier_category_id",
        "consumer_category_id",
        "participant_category_id",
        "relationship_type_id",
        "is_sure",
        "is_recommended_by_contact_notes",
        "is_recommende_by_ai",
        "months",
        "is_test_data",
        "start_timestamp",
        "start_date_day",
        "start_date_month",
        "start_date_year",
        "start_circa",
        "end_timestamp",
        "end_date_day",
        "end_date_month",
        "end_date_year",
        "end_circa",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_main_in_category"
    ),
    "contact_importer_view": (
        "contact_importer_id",
        "contact_id",
        "import_contact_id"
    ),
    "contact_note_view": (
        "contact_note_id",
        "number",
        "identifier",
        "contact_id",
        "seq_old",
        "note",
        "last_parsing_timestmp_old",
        "is_passed_regex_old",
        "block_type_id_old",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "contact_person_view": (
        "contact_person_id",
        "contact_id",
        "person_id"
    ),
    "contact_phone_view": (
        "contact_phone_id",
        "number",
        "identifier",
        "contact_id",
        "phone_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_profile_view": (
        "contact_profile_id",
        "number",
        "identifier",
        "contact_id",
        "profile_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_potential",
        "relationship_id"
    ),
    "importer_recent_contact_view": (
        "created_timestamp",
        "importer_id",
        "importer.is_test_data",
        "data_source_type_id",
        "data_source_type.title",
        "importer_country_ml.title",
        "entity_type_id",
        "entity_type_ml.title",
        "entity_id",
        "first_name",
        "last_name",
        "user_external_id"
    ),
    "importer_recent_contact_email_address_view": (
        "created_timestamp",
        "importer_id",
        "data_source_title",
        "importer_country_name",
        "entity_type_ml.title",
        "entity_id",
        "contact_id",
        "first_name",
        "last_name",
        "contact_email_address_id",
        "email_address",
        "email_address_approved",
        "email_address_ml.title",
        "data_source_type_id"
    ),
    "importer_recent_contact_phone_view": (
        "created_timestamp",
        "importer_id",
        "data_source_type.title",
        "importer_country_name",
        "entity_type.title",
        "entity_id",
        "first_name",
        "last_name",
        "number_original",
        "local_number_normalized",
        "label.name",
        "label_phone_ml.title"
    ),
    "brand_type_table": (
        "brand_type_id",
        "name",
        "other companies in this domain"
    ),
    "profile_type_table": (
        "profile_type_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_test_data"
    ),
    "profile_type_view": (
        "profile_type_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_test_data"
    ),
    "profile_profile_role_table": (
        "profile_profile_role_id"
    ),
    "profile_profile_role_ml_table": (
        "profile_profile_role_ml_table",
        "profile_profile_role_id",
        "lang_code",
        "title"
    ),
    "profile_history_table": (
        "profile_history_id",
        "profile_id",
        "field_id",
        "old_value",
        "new_value",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_user_external_view": (
        "contact_user_external_id",
        "contact_id",
        "user_external_id"
    ),
    "permission_repo_table": (
        "permission_repo_id",
        "permision_action",
        "permission_table",
        "repo_id",
        "repo_name_old"
    ),
    "activity_activity_table": (
        "activity_activity_id",
        "activity_id",
        "parent_activity_id"
    ),
    "product_metrics_type_table": (
        "product_metrics_type_id",
        "system_id"
    ),
    "product_metrics_type_ml_table": (
        "product_metrics_type_ml_id",
        "product_metrics_type_id",
        "lang_code",
        "is_main",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved",
        "is_test_data"
    ),
    "product_metrics_table": (
        "product_metrics_id",
        "brand_id",
        "environment_id",
        "regions_id",
        "product_metrics_type",
        "value",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "sql_report_table": (
        "sql_report_id",
        "sql_statement",
        "is_approved",
        "min_time_seconds",
        "max_time_seconds",
        "number_of_records",
        "number_of_records_limit",
        "time_limit_seconds",
        "product_metrics_type_id"
    ),
    "environnment_sql_report_table": (
        "environnment_sql_report_id",
        "environnment_id",
        "sql_report_id",
        "product_metric_id"
    ),
    "table_list_old": (
        "table_id"
    ),
    "data_source_external_user_ml_table": (
        "data_source_type_ml_id",
        "data_source_id",
        "lang_code",
        "data_source_name",
        "data_source_name_approved",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "profile_milestone_table_view": (
        "profile_milestone_id",
        "number",
        "profile_id",
        "is_sure",
        "text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "importer_general_view": (
        "importer_id",
        "data_source_instance_id",
        "importer.is_test_data",
        "data_source_type_id",
        "data_source_instance_name",
        "data_source_type_id_old",
        "data_source_type_ml.title",
        "entity_type_id",
        "entity_id",
        "url",
        "user_external_id",
        "user_external.system_id",
        "system_ml.title",
        "username",
        "handle",
        "profile_id",
        "location_id",
        "country_ml.title",
        "user_external_country_id_old",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "importer_recent_contact_location_view": (
        "created_timestamp",
        "importer_id",
        "data_source.title",
        "importer_country_name",
        "entity_type_ml.title",
        "entity_id",
        "contact_id",
        "first_name",
        "last_name",
        "contact_location_id",
        "contact's_location_id",
        "contact_address_local_language",
        "contact_address_english",
        "contact_country_id",
        "contact_country_name",
        "contact_city_id",
        "contact.city_ml.title",
        "person's_location_id",
        "person_address_local_language",
        "person_address_english",
        "person_country_name",
        "person.city_ml.title"
    ),
    "location_person_table": (
        "location_person_id",
        "location_id",
        "person_id"
    ),
    "contact_location_view": (
        "contact_location_id",
        "contact_id",
        "location_id"
    ),
    "location_person_view": (
        "location_person_id",
        "location_id",
        "person_id"
    ),
    "brand_group_view": (
        "brand_group_id",
        "brand_id",
        "group_id"
    ),
    "brand_group_table": (
        "brand_group_id",
        "brand_id",
        "group_id",
        "is_group_part_of_brand"
    ),
    "importer_recent_contact_group_view": (
        "created_timestamp",
        "importer_id",
        "importer.is_test_data",
        "data_source.title",
        "importer_country_name",
        "entity_type_ml.title",
        "entity_id",
        "contact_id",
        "contact.first_name",
        "contact.last_name",
        "contact_group_id",
        "group_id",
        "title",
        "group_type"
    ),
    "importer_recent_contact_text_block_view": (
        "created_timestamp",
        "importer_id",
        "data_source_type.title",
        "importer_country_name",
        "entity_type_ml.title",
        "entity_id",
        "contact_id",
        "first_name",
        "last_name",
        "contact_note_id",
        "contact_note",
        "contact_note_text_block_id",
        "seq",
        "text_block_id",
        "text_block.text",
        "text_block_type_id",
        "text_block_type_name",
        "group_title",
        "field_profile_text_block.field_id"
    ),
    "location_general_view": (
        "location_id",
        "number",
        "coordinate",
        "address_local_language",
        "address_english",
        "neighborhood_id",
        "city_id",
        "county_id",
        "region_id",
        "state_id",
        "country_id",
        "postal_code",
        "phonecode",
        "is_approved",
        "is_test_data",
        "is_community_active",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "location_ml.title",
        "location.is_title_approved",
        "country_name",
        "country_ml.is_title_approved",
        "state_ml.title",
        "state_ml.is_title_approved",
        "city_ml.title",
        "city_ml.is_title_approved"
    ),
    "email_address_person_table": (
        "email_address_person_id",
        "email_address_id",
        "person_id"
    ),
    "person_phone_view": (
        "person_phone_id",
        "person_id",
        "phone_id"
    ),
    "message_template_general_view": (
        "message_template_id",
        "message_template.name",
        "message_template_text_block.criteria_id_old",
        "message_template_text_block.criteria.name",
        "message_template_text_block_id",
        "message_template_text_block_name",
        "message_template_text_block_is_visible",
        "message_template_text_block.criteria_set_id",
        "message_template_text_block_seq",
        "question_id",
        "default_question_possible_answer_id",
        "question_is_required",
        "message_template_text_block_ml_lang_code",
        "default_subject_template",
        "default_body_template",
        "email_subject_template",
        "email_body_html_template",
        "sms_body_template",
        "whatsapp_body_template",
        "message_template_text_block_type.title",
        "question.title",
        "question_type_id",
        "question_type_name",
        "question_ml_lang_code",
        "question_type_schema_attributes",
        "question_type_uischema_attributes",
        "schema_attributes",
        "uischema_attributes",
        "question_hint",
        "variable_id",
        "variable_name",
        "variable_ml_title",
        "field_id",
        "field_name",
        "possible_answer",
        "action_id",
        "action_name"
    ),
    "group_group_category_table": (
        "group_group_category_id",
        "group_id",
        "group_category_id"
    ),
    "importer_recent_contact_profile_group_view": (
        "created_timestamp",
        "importer_id",
        "data_source.title",
        "importer_country_name",
        "entity_type_ml.title",
        "entity_id",
        "contact_id",
        "first_name",
        "last_name",
        "contact_profile_id",
        "group_profile_id",
        "profile_id",
        "group_id",
        "title"
    ),
    "importer_recent_contact_profile_view": (
        "created_timestamp",
        "importer_id",
        "data_source_type_ml.title",
        "importer_country_name",
        "entity_type_ml.title",
        "entity_id",
        "contact_id",
        "first_name",
        "last_name",
        "contact_profile_id",
        "profile_id",
        "gender"
    ),
    "importer_recent_contact_first_name_view": (
        "created_timestamp",
        "importer_id",
        "data_source.title",
        "importer_country_name",
        "entity_type_ml.title",
        "entity_id",
        "contact_id",
        "first_name",
        "last_name",
        "first_name_ml.first_name",
        "gender_id"
    ),
    "api_call_general_view": (
        "created_timestamp",
        "api_call_id",
        "session_token",
        "user_external_id",
        "username",
        "handle",
        "api_type_id",
        "api_type.name",
        "endpoint_url",
        "created_user_id",
        "is_test_data",
        "outgoing_header_json",
        "outgoing_body_json",
        "outgoing_body_significant_fields_hash",
        "incoming_message_json",
        "http_status_code",
        "response_body_json",
        "is_network"
    ),
    "profile_general_view": (
        "profile_id",
        "number",
        "profile.name",
        "profile.main_user_id",
        "main_person_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "main_phone_id",
        "profile.main_email_address",
        "is_rip",
        "profile.gender_id",
        "stars",
        "is_system",
        "internal_description",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "profile_type_ml.title",
        "profile_ml.title",
        "profile.main_person_id",
        "person.person_id",
        "person.first_name",
        "person.last_name",
        "last_dialog_workflow_state_id_old",
        "last_dialog_workflow_state_id"
    ),
    "message_template_function_table": (
        "message_template_function_id",
        "name",
        "description",
        "is_function",
        "is_expression"
    ),
    "sql2code_table": (
        "sql2code_id",
        "schema_name",
        "view_table_name",
        "refresh_unit",
        "refresh_value"
    ),
    "rfp_type_table": (
        "rfp_type_id",
        "name"
    ),
    "recruitment_rfp_table": (
        "recruitment_rfp_id"
    ),
    "group_general_view": (
        "group_id",
        "group.name",
        "group.is_test_data",
        "new_group_id",
        "group.end_timestamp",
        "group_ml_id",
        "lang_code",
        "title",
        "is_main_title",
        "group_ml.is_test_data",
        "group_ml.end_timestamp",
        "group_category_title",
        "group_type_name",
        "is_location",
        "is_contact_classification",
        "group_id1 (parent)",
        "group_id2 (child)"
    ),
    "group_type_table": (
        "group_type_id",
        "name",
        "is_location",
        "is_organization",
        "is_gender",
        "is_job_title",
        "is_organization_classification",
        "is_contact_classification",
        "examples_old"
    ),
    "importer_recent_contact_user_external_view": (
        "created_timestamp",
        "importer_id",
        "data_source_type.title",
        "importer_country_name",
        "entity_type_ml.title",
        "entity_id",
        "contact_id",
        "first_name",
        "last_name",
        "contact_user_external_id"
    ),
    "importer_view": (
        "importer_id",
        "number",
        "data_source_instance_id",
        "data_source_type_id_old",
        "user_external_id",
        "entity_type_id",
        "entity_id",
        "url",
        "data_imported_json",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "user_external_country_id_old",
        "data_source_external_user_id_old",
        "google_people_api_resource_name",
        "google_calendar_id"
    ),
    "planned_database_schema_change_table": (
        "planned_database_schema_change_",
        "schema",
        "old_object",
        "new_object",
        "old_field_name",
        "new_field_name",
        "change",
        "database_version",
        "team_members_involved"
    ),
    "importer_recent_contact_profile_milestone_view": (
        "created_timestamp",
        "importer_id",
        "data_source_type_ml.title",
        "importer_country_name",
        "entity_type_ml.title",
        "entity_id",
        "contact_id",
        "first_name",
        "last_name",
        "contact_profile_id",
        "profile_id",
        "profile_milestone_id",
        "start_timestamp",
        "is_sure",
        "text_block_id",
        "text"
    ),
    "contact_internet_domain_view": (
        "contact_internet_domain_id",
        "contact_id",
        "internet_domain_id"
    ),
    "form_general_view": (
        "form_id",
        "form_name",
        "min_message_template",
        "max_message_template",
        "form_page",
        "form_message_seq_in_page",
        "form_message_template_id",
        "message_template_id",
        "message_template.name",
        "message_template_text_block_seq",
        "message_template_text_block_id",
        "message_template_text_block_name",
        "default_subject_template",
        "default_body_template",
        "message_template_text_block_ml_lang_code",
        "question_id",
        "question_title",
        "question_is_required",
        "question_ml_lang_code",
        "default_question_possible_answer_id",
        "schema_attribute",
        "uischema_attribute",
        "question_type_id",
        "question_type_name",
        "question_type_uischema_attributes",
        "question_type_schema_attributes",
        "variable_id",
        "variable_name",
        "variable_ml_title",
        "field_name",
        "message_template_text_block_is_visible",
        "possible_answer",
        "message_template_text_block.criteria_set_id"
    ),
    "question_general_view": (
        "question_id",
        "question.name",
        "question_type_id",
        "question_default_value",
        "variable_id",
        "question_type_name",
        "question_type_schema_attributes",
        "question_typeuischema_attributes",
        "title",
        "question_ml_default_value",
        "value",
        "label_question_id",
        "variable_name",
        "variable_ml_title",
        "field_name"
    ),
    "action_item_view": (
        "action_item_id",
        "number",
        "identifier",
        "activity_id",
        "ranking",
        "other_group_id",
        "other_person_id",
        "other_profile_id",
        "name",
        "action_id",
        "action_item_type_id",
        "active_main_profile_id",
        "passive_main_profile_id",
        "passive_main_contact_id1",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "action_item_ml_view": (
        "action_item_ml_id",
        "action_item_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "cicd_workflow_table": (
        "cicd_workflow_id",
        "repo_id",
        "path",
        "filename",
        "cicd_engine"
    ),
    "cicd_workflow_history_table": (
        "cicd_workflow_history_id",
        "name",
        "both_play1_dvlp1_in_same_yml",
        "old_long_approach",
        "using_reusable_workflows"
    ),
    "message_template_text_block_type_table": (
        "message_template_text_block_type_id",
        "name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "label_phone_view": (
        "label_phone_id",
        "phone_id",
        "label_id"
    ),
    "label_profile_view": (
        "label_profile_id",
        "profile_id",
        "label_id"
    ),
    "email_address_label_table": (
        "email_address_label_id",
        "email_address_id",
        "label_id"
    ),
    "email_address_label_view": (
        "email_address_label_id",
        "email_address_id",
        "label_id",
        "email_address_label_id",
        "email_address_id",
        "label_id"
    ),
    "group_category_table": (
        "group_category_id",
        "name",
        "group_type_id",
        "is_hierarchy",
        "is_prioritze",
        "is_location",
        "is_organization",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "organization_profile_view": (
        "organization_profile_id",
        "number",
        "identifier",
        "organization_id",
        "profile_id",
        "job_title_id",
        "job_title_ml_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "organization_view": (
        "organization_id",
        "number",
        "identifier",
        "is_approved",
        "is_main",
        "point",
        "location_id",
        "profile_id",
        "parent_organization_id",
        "non_members_visibility_scope_id",
        "members_visibility_scope_id",
        "Non_members_visibility_profile_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp",
        "main_group_id",
        "name"
    ),
    "organization_ml_view": (
        "organization_ml_id",
        "number",
        "identifier",
        "organization_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "description",
        "is_description_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "group_ml_approved_view": (
        "group_ml_id",
        "number",
        "identifier",
        "group_id",
        "lang_code",
        "title",
        "is_main_title",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "form_transaction_table": (
        "form_transaction_id",
        "form_id",
        "previous_form_id",
        "sender_profile_id",
        "sender_email",
        "to_profile_id",
        "to_profile_list_id",
        "to_email",
        "cc_profile_id",
        "cc_profile_list_id",
        "cc_email",
        "bcc_profile_id",
        "bcc_profile_list_id",
        "bcc_email",
        "group_list_id",
        "occurrence_id",
        "location_id",
        "message_channel_id",
        "form_type_id",
        "push_notification",
        "group_id",
        "session_id",
        "visibility_id",
        "pin",
        "mailbox_id",
        "is_gen_ai",
        "machine_learning_model_id",
        "is_require_moderator",
        "moderator_profile_id",
        "moderator_feedback_type",
        "moderator_feedback_text",
        "is_moderator_approved",
        "queue_status_id",
        "message_status_id",
        "process_id",
        "stdout",
        "stderr",
        "return_code",
        "returned_value",
        "return_form",
        "profile_id",
        "server_ip_v4",
        "server_ip_v6",
        "thread_id",
        "user_jwt",
        "class_parameters_json",
        "function_parameters_json",
        "action_id",
        "campaign_id",
        "requested_channel_id",
        "actual_channel_id",
        "provider_id",
        "is_test_data",
        "request_to_send_timestamp",
        "scheduled_sent_timestamp",
        "actual_sent_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "email_form_id",
        "body",
        "subject",
        "number",
        "compound_form",
        "compound_form_json_version",
        "compound_form_json",
        "session"
    ),
    "dialog_workflow_script_ml_table": (
        "dialog_workflow_script_ml_id",
        "dialog_workflow_script_id",
        "lang_code",
        "title"
    ),
    "dialog_workflow_action_en_general_view": (
        "workflow_action_id",
        "name",
        "description",
        "lang_code",
        "title"
    ),
    "dialog_workflow_state_ml_table": (
        "dialog_workflow_state_ml_id",
        "dialog_workflow_state_id",
        "lang_code",
        "title"
    ),
    "label_phone_table_old": (
        "label_phone_id",
        "label_id",
        "phone_id"
    ),
    "group_ml_also_not_approved_view": (
        "group_ml_id",
        "number",
        "identifier",
        "group_id",
        "lang_code",
        "title",
        "is_main_title",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "group_ml_not_approved_view": (
        "group_ml_id",
        "number",
        "identifier",
        "group_id",
        "lang_code",
        "title",
        "is_main_title",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "group_job_title_general_view": (
        "group_id",
        "group_name",
        "job_title_id",
        "job_titile.name",
        "job_title_ml.title"
    ),
    "table_definition_view": (
        "table_definition_id",
        "entity_type_id1",
        "entity_type_id2",
        "schema",
        "table_name",
        "view_name",
        "seq",
        "table_list_id",
        "is_created_updated_fields",
        "is_logical_delete_fields",
        "contact_mapping_table_id",
        "profile_mapping_table_id",
        "is_ml_parent_table",
        "is_ml_child_table",
        "table_type",
        "is_number_column",
        "is_test_data_column",
        "is_main_column",
        "is_single_and_multi_value",
        "name_of_single_value_column",
        "is_mapping_table",
        "is_entity",
        "is_history",
        "is_one_table_per_all_tenants",
        "is_tree",
        "is_graph",
        "is_metrics",
        "is_pii",
        "is_sensative",
        "sensative_columns",
        "is_visibility"
    ),
    "user_to_be_reviewed_view": (
        "user_id",
        "number",
        "brand_id",
        "username",
        "is_approved",
        "user.main_email_address",
        "first_name",
        "last_name",
        "name_approved",
        "identity_id",
        "stars",
        "default_time_zone",
        "current_time_zone",
        "preferred_lang_code",
        "active_location_id",
        "gender_id",
        "interested_in_gender_id",
        "user_approval_to_get_emails_from_us",
        "password",
        "birthday_original_moved_to_person",
        "birthday_moved_to_person",
        "region",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "presence",
        "start_timestamp",
        "end_timestamp",
        "is_test_data"
    ),
    "message_channel_table": (
        "message_channel_id",
        "version",
        "chanel_type_id",
        "name"
    ),
    "text_block_type_regex_table": (
        "text_block_type_regex_id",
        "text_block_type_id",
        "regex",
        "lang_code",
        "description",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "message_channel_ml_table": (
        "message_channel_ml_id",
        "message_channel_id",
        "lang_code",
        "title",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "action_item_ml_table": (
        "action_item_ml_id",
        "action_item_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "activity_ml_table": (
        "action_item_type_ml_id",
        "action_item_type_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "action_item_profile_view": (
        "action_item_profile_id",
        "number",
        "identifier",
        "action_item_id",
        "action_item_ml_id",
        "active_profile_id",
        "passive_profile_id",
        "passive_contact_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "action_item_priority_table": (
        "action_item_priority_id",
        "default_action_item_ranking"
    ),
    "calendar_item_ml_table": (
        "calendar_item_ml_id",
        "calendar_item_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "event_hashag_table": (
        "event_hashag_id",
        "event_id",
        "hashtag",
        "created_effective_user_id",
        "created_effective_profile_id"
    ),
    "participant_table": (
        "participant_id",
        "profile_id",
        "price",
        "paied",
        "number_of_participants"
    ),
    "calendar_ml_table": (
        "calendar_ml_id",
        "calendar_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "resource_table": (
        "resource_id",
        "resource_type_id",
        "location_id",
        "buy_price_usd",
        "sell_price_usd",
        "buy_price_set",
        "sell_price_set"
    ),
    "calendar_item_resource_table": (
        "calendar_item_resource_id",
        "number",
        "identifier",
        "calendar_item_id",
        "resource_id",
        "resource_status_id",
        "is_optional",
        "is_mandatory",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "calendar_profile_table": (
        "calendar_profile_id",
        "number",
        "identifier",
        "calendar_item_id",
        "profile_id",
        "person_id",
        "profile_person_status_id",
        "resource_id",
        "resource_status_id",
        "is_optional",
        "is_mandatory",
        "attendee_status_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "calendar_item_profile_person_table": (
        "calendar_item_profile_person_id",
        "number",
        "identifier",
        "calendar_item_id",
        "profile_id",
        "person_id",
        "profile_person_status_id",
        "is_optional",
        "is_mandatory",
        "attendee_status_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "activity_table_old": (
        "activity_id",
        "activity_type_id",
        "parent_activity_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "calendar_table": (
        "calendar_id",
        "name",
        "created_effective_profile_id",
        "effective_profile_id",
        "calendar_type"
    ),
    "user_not_deleted_view": (
        "user_id",
        "number",
        "brand_id",
        "username",
        "is_approved",
        "user.main_email_address",
        "first_name",
        "last_name",
        "name_approved",
        "identity_id",
        "stars",
        "default_time_zone",
        "current_time_zone",
        "preferred_lang_code",
        "active_location_id",
        "gender_id",
        "interested_in_gender_id",
        "user_approval_to_get_emails_from_us",
        "password",
        "password_clear_text",
        "password_encrypted",
        "region",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "presence",
        "start_timestamp",
        "end_timestamp"
    ),
    "gender_list_table": (
        "gender_list_id",
        "gender_list_id2",
        "name",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "gender_table": (
        "gender_id",
        "name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "gender_list_member_view": (
        "gender_list_member_id",
        "gender_list_id",
        "gender_id",
        "gender_list_name",
        "gender_name",
        "gender_title"
    ),
    "gender_ml_view": (
        "gender_id",
        "lang_code",
        "title"
    ),
    "first_name_view": (
        "first_name_id",
        "number",
        "identifier",
        "name",
        "gender_id",
        "gender_list_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "first_name_ml_view": (
        "first_name_ml_id",
        "first_name_id",
        "number",
        "identifier",
        "lang_code",
        "is_main",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "last_name_view": (
        "last_name_id",
        "name",
        "number",
        "identifier",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "last_name_ml_view": (
        "last_name_ml_id",
        "number",
        "identifier",
        "last_name_id",
        "lang_code",
        "is_main",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "organization_ml_not_deleted_view": (
        "organization_id",
        "name",
        "organization_ml_id",
        "lang_code",
        "title"
    ),
    "calendar_item_type_ml_table": (
        "calendar_item_type_ml_id",
        "calendar_item_type_id",
        "land_code",
        "title"
    ),
    "calendar_item_type_table": (
        "calendar_item_type_id",
        "name"
    ),
    "table_definition_general_view": (
        "table_defintion_id_main",
        "schema_main",
        "table_name_main",
        "table_defintion_id_mapping",
        "schema_mapping",
        "table_name_mapping"
    ),
    "email_address_profile_view": (
        "email_address_profile_id",
        "email_address_id",
        "profile_id",
        "is_main",
        "is_sure",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "field_text_block_type_view": (
        "field_text_block_type_id",
        "text_block_type_id",
        "regex",
        "index_in_regex",
        "field_id",
        "lang_code",
        "comment",
        "is_multiple",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "text_block_type_general_view": (
        "text_block_type_id",
        "system_id",
        "system_entity_id",
        "regex",
        "text_block_type_name",
        "text_block_type_regex_regex",
        "lang_code",
        "name"
    ),
    "person_profile_view": (
        "person_profile_id",
        "number",
        "identifier",
        "person_id",
        "profile_id",
        "person_profile_role_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "group_ml_not_deleted_view": (
        "group_id",
        "number",
        "identifier",
        "name",
        "hashtag",
        "parent_group_id",
        "parent_group_list_id",
        "is_approved",
        "non_members_visibility_id",
        "members_visibility_id",
        "sequence",
        "is_interest",
        "is_job_title",
        "is_organization",
        "is_geo",
        "is_continent",
        "is_country",
        "is_state",
        "is_county",
        "is_region",
        "is_city",
        "is_neighbourhood",
        "is_street",
        "is_zip_code",
        "is_building",
        "location_id",
        "location_list_id",
        "coordinate",
        "group_category_id",
        "system_id",
        "profile_id",
        "is_official",
        "system_group_name",
        "main_group_type_id",
        "is_event",
        "event_id",
        "is_first_name",
        "is_last_name",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "created_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp",
        "is_campaign",
        "lang_code",
        "title"
    ),
    "user_external_general_view": (
        "user_external_id",
        "number",
        "system_id",
        "system.name",
        "subsystem_id",
        "username",
        "email_address_id",
        "handle",
        "access_token_old",
        "token_2delete",
        "refresh_token_old",
        "expiry_old",
        "oauth_token",
        "oauth_token_secret",
        "oauth_callback_confirmed",
        "environment_id_old",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "profile_user_external_id",
        "profile_id",
        "user_id",
        "person_id",
        "email_account_id",
        "email_account_name",
        "phone.full_number_normalized",
        "scope_json",
        "cloud_project",
        "refresh_token",
        "access_token"
    ),
    "mailbox_profile_table": (
        "mailbox_profile_id",
        "mailbox_id",
        "profile_id",
        "name"
    ),
    "email_account_table": (
        "email_account_id",
        "name",
        "domain",
        "imap_host",
        "imap_port",
        "smtp_host",
        "smtp_port",
        "username",
        "password"
    ),
    "email_account_mailbox_table": (
        "email_account_mailbox_id",
        "email_account_id",
        "mailbox_id"
    ),
    "mailbox_table": (
        "mailbox_id",
        "name"
    ),
    "email_account_user_external_table": (
        "email_account_user_external_id",
        "email_account_id",
        "user_external_id",
        "name",
        "email_address_id",
        "default_group_id"
    ),
    "user_external_email_account_general_view": (
        "user_external_id",
        "number",
        "system_id",
        "subsystem_id",
        "username",
        "email_address_id",
        "handle",
        "access_token_old",
        "token_2delete",
        "refresh_token_old",
        "expiry_old",
        "oauth_token",
        "oauth_token_secret",
        "oauth_callback_confirmed",
        "environment_id_old",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "email_account_id",
        "email_account.name"
    ),
    "url_view": (
        "url_id",
        "number",
        "identifier",
        "url",
        "url_type",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_url_table": (
        "profile_url_id",
        "profile_id",
        "url_id",
        "url_type_id_old",
        "url_old",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "user_external_test_data_view": (
        "user_external_id",
        "number",
        "system_id",
        "subsystem_id",
        "username",
        "email_address_id",
        "handle",
        "access_token_old",
        "token_2delete",
        "refresh_token_old",
        "expiry_old",
        "oauth_token",
        "oauth_token_secret",
        "oauth_callback_confirmed",
        "environment_id_old",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "email_account_id",
        "email_account.name"
    ),
    "person_general_view": (
        "person.person_id",
        "person.first_name",
        "person.last_name",
        "person.main_email_address",
        "person.is_test_data",
        "person.created_timestamp",
        "person.end_timestamp",
        "person_profile.end_timestamp",
        "person.birthday_date",
        "profile.profile_id",
        "profile.name",
        "profile.main_user_id",
        "profile.main_email_address",
        "profile.is_test_data",
        "profile.end_timestamp",
        "user.user_id",
        "number_of_contacts",
        "number_of_profiles",
        "number_of_phones"
    ),
    "person_profile_table": (
        "person_profile_id",
        "number",
        "identifier",
        "person_id",
        "profile_id",
        "person_profile_role_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "person_with_missing_data_view": (
        "person_id",
        "person.first_name",
        "person.last_name",
        "person.main_email_address",
        "person.end_timestamp",
        "person_profile.end_timestamp",
        "profile_id",
        "profile.main_email_address",
        "profile.name",
        "profile.main_user_id",
        "profile.is_test_data",
        "profile.end_timestamp"
    ),
    "phone_profile_general_view": (
        "profile_id",
        "profile.name",
        "profile.main_email_address",
        "profile_is_test_data",
        "phone_profile_id",
        "is_main",
        "label_phone_id",
        "phone_id",
        "full_number_normalized",
        "phone_is_test_data",
        "phone_profile_is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "person.first_name"
    ),
    "phone_with_empty_full_number_normalized_view": (
        "phone_id",
        "number",
        "number_original",
        "international_code",
        "area_code",
        "local_number_normalized",
        "extension",
        "full_number_normalized",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "message_view": (
        "message_id",
        "number",
        "identifier",
        "parent_message_id",
        "message_message_relationship_id",
        "from_profile_id",
        "from_email",
        "from_phone_number",
        "from_provider_id",
        "from_user_external_id",
        "from_system_id",
        "conversation_id",
        "to_phone_number",
        "to_provider_id",
        "to_profile_id",
        "to_profile_list_id",
        "to_email",
        "cc_profile_id",
        "cc_profile_list_id",
        "cc_email",
        "bcc_profile_id",
        "bcc_profile_list_id",
        "bcc_email",
        "group_list_id",
        "occurrence_id",
        "location_id",
        "message_channel_id",
        "message_type_id",
        "is_push_notification",
        "group_id",
        "session_id",
        "visibility_id",
        "is_pin",
        "mailbox_id",
        "is_gen_ai",
        "machine_learning_model_id",
        "is_require_moderator",
        "moderator_profile_id",
        "moderator_feedback_type",
        "moderator_feedback_text",
        "is_moderator_approved",
        "queue_status_id",
        "message_status_id",
        "process_id",
        "stdout",
        "stderr",
        "return_code",
        "returned_value",
        "return_message",
        "profile_id",
        "server_ip_v4",
        "server_ip_v6",
        "thread_id",
        "user_jwt",
        "class_parameters_json",
        "function_parameters_json",
        "action_id",
        "campaign_id",
        "campaign_criteria_set_id",
        "requested_channel_id",
        "actual_channel_id",
        "email_message_id",
        "body",
        "subject",
        "compound_message",
        "compound_message_json_version",
        "compound_message_json",
        "session",
        "channel_id",
        "last_dialog_workflow_state_id",
        "next_dialog_workflow_state_id",
        "from_subsystem_id",
        "updated_effective_profile_id",
        "original_message_id",
        "is_test_data",
        "request_to_send_timestamp",
        "scheduled_sent_timestamp",
        "actual_sent_timestamp",
        "message_template_id",
        "from_api_type_id",
        "inforu_customer_id_old",
        "inforu_project_id_old",
        "inforu_channel_old",
        "inforu_type_old",
        "inforu_value_old",
        "inforu_keyword_old",
        "inforu_network_old",
        "inforu_short_code_old",
        "inforu_application_id_old",
        "inforu_customer_param_old",
        "inforu_mo_session_id_old",
        "inforu_incoming_json_old",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "component_id"
    ),
    "user_pii_table": (
        "user_pii_id",
        "number",
        "identifier",
        "user_id",
        "password_clear_text",
        "password_encrypted",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "action_item_type_ml_table": (
        "action_item_type_ml_id",
        "action_item_type_id",
        "lang_code",
        "title",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "action_item_type_table": (
        "action_item_type_id",
        "version",
        "channel_type_id"
    ),
    "action_item_category_table": (
        "action_item_category_table_id",
        "version",
        "channel_category_id"
    ),
    "action_item_category_ml_table": (
        "action_item_category_ml_id",
        "action_item_category_id",
        "lang_code",
        "category_id",
        "subeject",
        "body",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "contact_text_block_view": (
        "contact_text_block_id",
        "contact_id",
        "text_block_id",
        "is_test_data"
    ),
    "profile_level_table": (
        "profile_id"
    ),
    "profile_user_table_view": (
        "profile_id",
        "profile_user_id",
        "user_id"
    ),
    "user_to_delete_view": (
        "user_id",
        "is_system",
        "is_test_data"
    ),
    "profile_to_delete_view": (
        "profile_id",
        "profile_is_test_data",
        "profile_is_system",
        "user_id",
        "user_is_system",
        "user_is_test_data"
    ),
    "table_size_history_table": (
        "table_size_history_id",
        "number",
        "identifier",
        "timestamp",
        "brand_id",
        "environment_id",
        "environment_name",
        "table_schema",
        "table_name",
        "number_of_records",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "login_history_table": (
        "login_history_id",
        "number",
        "identifier",
        "user_id",
        "real_profile_id",
        "effective_profile_id",
        "ipv4",
        "ipv6",
        "operating_system",
        "browser",
        "session",
        "timestamp",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_person_table": (
        "contact_person_id",
        "number",
        "identifier",
        "contact_id",
        "person_id",
        "contact_person_type_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "field_text_block_type_table": (
        "field_text_block_type_id",
        "regex",
        "index_in_regex",
        "field_id",
        "text_block_type_id",
        "lang_code",
        "comment",
        "is_multiple",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "text_block_type_table": (
        "text_block_type_id",
        "name",
        "system_id",
        "system_entity_id",
        "regex",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "contact_importer_table": (
        "contact_importer_id",
        "number",
        "identifier",
        "contact_id",
        "import_contact_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "import_contact_table_old": (
        "import_contact_id",
        "number",
        "identifier",
        "google_account",
        "facebook_profile_name",
        "facebook_profile_number",
        "importer_table_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_internet_domain_table": (
        "contact_internet_domain_id",
        "number",
        "identifier",
        "contact_id",
        "internet_domain_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_note_text_block_table": (
        "contact_note_text_block_id",
        "number",
        "identifier",
        "contact_note_id",
        "seq",
        "text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_note_group_table": (
        "contact_note_group_id",
        "number",
        "identifier",
        "contact_note_id",
        "group_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_user_external_table": (
        "contact_user_external_id",
        "number",
        "identifier",
        "contact_id",
        "user_external_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_profile_table": (
        "contact_profile_id",
        "number",
        "identifier",
        "contact_id",
        "profile_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_potential",
        "relationship_id"
    ),
    "contact_text_block_table": (
        "contact_text_block_id",
        "number",
        "identifier",
        "contact_id",
        "text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_location_table": (
        "contact_location_id",
        "number",
        "identifier",
        "contact_id",
        "location_id",
        "location_type_str",
        "label_location_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "contact_location_type_id"
    ),
    "contact_location_type_table": (
        "contact_location_type_id",
        "number",
        "identifier",
        "name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_location_type_ml_table": (
        "contact_location_type_ml_id",
        "number",
        "identifier",
        "contact_location_type_id",
        "land_code",
        "title",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_person_type_table": (
        "contact_person_type_id",
        "number",
        "identifier",
        "name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_group_type_table": (
        "contact_group_type_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "number",
        "identifier"
    ),
    "contact_group_type_ml_table": (
        "contact_group_type_ml_id",
        "number",
        "identifier",
        "contact_group_type_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp",
        "is_test_data"
    ),
    "message_profile_table": (
        "message_profile_id",
        "number",
        "identifier",
        "message_id",
        "profile_id",
        "reaction_id",
        "user_id",
        "message_status_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "item_profile_table": (
        "item_profile_id",
        "number",
        "identifier",
        "item_id",
        "item_type_id",
        "profile_id",
        "message_id",
        "recommendation_model_id",
        "visibility_id",
        "seen_summary_start_timestamp",
        "seen_summary_end_timestamp",
        "seen_body_start_timestamp",
        "seen_body_end_timestamp",
        "exposure_time_miliseconds",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "event_profile_type_ml_table": (
        "event_profile_type_ml_id",
        "number",
        "identifier",
        "event_profile_type_id",
        "lang_code",
        "title",
        "is_main_title",
        "description",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp",
        "is_test_data"
    ),
    "profile_text_block_table": (
        "profile_text_block_id",
        "number",
        "identifier",
        "profile_id",
        "text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "group_profile_type_ml_table": (
        "group_profile_type_ml_id",
        "number",
        "identifier",
        "group_profile_type_id",
        "lang_code",
        "title",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "employer_profile_table": (
        "employer_profile_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "number",
        "identifier"
    ),
    "employer_profile_vacancy_table": (
        "employer_profile_vacancy_id",
        "number",
        "identifier",
        "employer_profile_id",
        "vacancy_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "email_address_profile_verification_table": (
        "email_address_profile_verification_id",
        "number",
        "identifier",
        "email_address_profile_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "group_text_block_table": (
        "group_text_block_id",
        "number",
        "identifier",
        "group_id",
        "text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "person_text_block_table": (
        "person_text_block_id",
        "number",
        "identifier",
        "person_id",
        "text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "field_profile_text_block_table": (
        "field_profile_text_block_id",
        "number",
        "identifier",
        "field_id",
        "profile_id",
        "text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "email_address_text_block_table": (
        "email_address_text_block_id",
        "number",
        "identifier",
        "email_address_id",
        "text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "text_table": (
        "text_id",
        "name",
        "text_category_id",
        "component_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "label_profile_table": (
        "label_profile_id",
        "number",
        "identifier",
        "profile_id",
        "label_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_test_data",
        "is_system"
    ),
    "action_item_priority_view": (
        "action_item_priority_id",
        "default_action_item_ranking"
    ),
    "location_profile_ml_table": (
        "location_profile_ml_id",
        "location_profile_id",
        "lang_code",
        "title",
        "title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "test_mysql_ml_table": (
        "test_mysql_ml_id",
        "number",
        "identifier",
        "test_mysql_id",
        "lang_code",
        "title",
        "is_title_approved",
        "is_main",
        "unique_int_column",
        "visibility_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "contact_note_table": (
        "contact_note_id",
        "number",
        "identifier",
        "contact_id",
        "seq_old",
        "note",
        "last_parsing_timestmp_old",
        "is_passed_regex_old",
        "block_type_id_old",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "first_name_table": (
        "first_name_id",
        "number",
        "identifier",
        "name",
        "gender_id",
        "gender_list_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "first_name_ml_table": (
        "first_name_ml_id",
        "first_name_id",
        "number",
        "identifier",
        "lang_code",
        "is_main",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "last_name_ml_table": (
        "last_name_ml_id",
        "number",
        "identifier",
        "last_name_id",
        "lang_code",
        "is_main",
        "name",
        "is_name_approved",
        "description",
        "is_description_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_milestone_table": (
        "profile_milestone_id",
        "number",
        "profile_id",
        "is_sure",
        "text_block_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "variable_ml_table": (
        "variable_ml_id",
        "variable_id",
        "lang_code",
        "title",
        "visibility_id"
    ),
    "gender_list_member_table": (
        "gender_list_member_id",
        "gender_list_id",
        "gender_id"
    ),
    "identifier_view": (
        "identifier_id",
        "identifier",
        "number",
        "entity_type_id",
        "is_test_data"
    ),
    "importer_entity_types_imported_group_by_source_view": (
        "Entity Type Title",
        "Data Source Title",
        "Number of Entries"
    ),
    "identifier_group_by_entity_type_view": (
        "entity_type_ml.title",
        "Number of Entries"
    ),
    "identifier_table": (
        "identifier_id",
        "identifier",
        "number",
        "entity_type_id",
        "is_test_data",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "item_type_table": (
        "item_type_id",
        "entity_type_id",
        "is_personal"
    ),
    "question_type_table": (
        "question_type_id",
        "name",
        "component_name",
        "schema_attributes",
        "uischema_attributes",
        "parent_question_type_id"
    ),
    "question_type_view": (
        "question_type_id",
        "name",
        "component_name",
        "schema_attributes",
        "uischema_attributes",
        "parent_question_type_id"
    ),
    "question_possible_answer_table": (
        "question_possible_answer_id",
        "question_id"
    ),
    "question_possible_answer_ml_table": (
        "question_possible_answer_ml_id",
        "question_possible_answer_id",
        "question_id_old",
        "number",
        "identifier",
        "lang_code",
        "value",
        "action_id",
        "is_approved",
        "is_main",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "question_possible_answer_ml_view": (
        "question_possible_answer_ml_id",
        "question_possible_answer_id",
        "question_id_old",
        "number",
        "identifier",
        "lang_code",
        "value",
        "action_id",
        "is_approved",
        "is_main",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "question_possible_answer_view": (
        "question_possible_answer_id",
        "question_id"
    ),
    "question_table": (
        "question_id",
        "name",
        "question_type_id",
        "answer_expiration_days",
        "table_id",
        "where_statement",
        "is_required",
        "variable_id",
        "default_value",
        "is_visible",
        "label_question_id",
        "hint",
        "uischema_attributes",
        "schema_attributes",
        "default_question_possible_answer_id"
    ),
    "logger_logger_general_view": (
        "logger_id",
        "client_ip_v4",
        "client_ip_v6",
        "server_ip_v4",
        "server_ip_v6",
        "location_id",
        "user_id",
        "profile_id",
        "activity",
        "activity_id",
        "message",
        "payload",
        "component_id",
        "error_stack",
        "severity_id",
        "status_id",
        "group_id",
        "relationship_type_id",
        "timestamp",
        "state_id",
        "variable_id",
        "variable_value_old",
        "variable_value_new",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_datetime",
        "end_datetime",
        "name"
    ),
    "logger_variable_general_view": (
        "timestamp",
        "profile_id",
        "profile.main_email_address",
        "workflow_state_id",
        "variable_id",
        "variable name",
        "variable_value_old",
        "variable_value_new"
    ),
    "importer_contact_google_people_api_sync_view": (
        "last_sync_time",
        "contact_id"
    ),
    "contact_email_address_table": (
        "contact_email_address_id",
        "contact_id",
        "email_address_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "email_address_review_view": (
        "email_address_id",
        "email_address",
        "email_address_approved",
        "is_test_data"
    ),
    "phone_review_view": (
        "phone_id",
        "number_original",
        "local_number_normalized",
        "full_number_normalized",
        "is_test_data",
        "created_timestamp"
    ),
    "contact_phone_table": (
        "contact_phone_id",
        "number",
        "identifier",
        "contact_id",
        "phone_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_phone_general_view": (
        "person_id",
        "contact_id",
        "first_name",
        "last_name",
        "email1",
        "contact.is_test_data",
        "contact_phone_id",
        "phone_id",
        "full_number_normalized",
        "phone.is_test_data"
    ),
    "reaction_table": (
        "reaction_id",
        "name",
        "number",
        "value",
        "text",
        "image",
        "reaction_type_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "reaction_category_table": (
        "reaction_category_id"
    ),
    "reaction_reaction_category_table": (
        "reaction_reaction_category_id",
        "reaction_id",
        "reaction_category_id"
    ),
    "reaction_review_view": (
        "reaction_ml_id",
        "reaction_id",
        "lang_code",
        "title",
        "is_test_data",
        "is_title_approved"
    ),
    "label_message_table": (
        "label_message_id",
        "message_id",
        "label_id"
    ),
    "api_call_by_date_api_type_name_view": (
        "DATE(created_timestamp)",
        "username",
        "api_type_id",
        "api_type.name",
        "count(*)"
    ),
    "person_ml_view": (
        "person_ml_id",
        "person_id",
        "lang_code",
        "first_name",
        "is_first_name_approved",
        "last_name",
        "is_last_name_approved",
        "is_test_data"
    ),
    "environment_ml_table": (
        "environment_ml_id",
        "environment_id",
        "lang_code",
        "name",
        "name_approved",
        "description",
        "description_approved"
    ),
    "api_type_user_external_view": (
        "api_type_user_external_id",
        "api_type_id",
        "environment_id",
        "user_external_id",
        "is_test_data"
    ),
    "event_group_view": (
        "event_group_id",
        "event_id",
        "group_id"
    ),
    "event_location_view": (
        "event_location_id",
        "event_id",
        "location_id"
    ),
    "logger_function_start_end_group_by_component_view": (
        "logger.component_name",
        "function_name",
        "component_id",
        "severity_description",
        "COUNT(*)"
    ),
    "api_call_group_by_date_view": (
        "DATE(created_timestamp)",
        "COUNT(*)"
    ),
    "api_call_group_without_user_extenal_id_by_date_view": (
        "DATE(created_timestamp)",
        "COUNT(*)"
    ),
    "api_call_api_type_user_external_count_view": (
        "DATE(created_timestamp)",
        "api_type.name",
        "api_type_id",
        "username",
        "user_external_id",
        "created_user_id",
        "COUNT(*)"
    ),
    "group_deleted_view": (
        "group_id",
        "title",
        "group_id2 (parent)",
        "group_id2 (child)",
        "group_category_title",
        "group_type_name",
        "is_location",
        "is_contact_classification",
        "group_is_test_data"
    ),
    "message_template_message_template_text_block_general_view": (
        "message_template_message_template_text_block_type_id",
        "message_template_message_template_text_block_id",
        "message_template_id",
        "message_template_text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "default_subject_template",
        "default_body_template"
    ),
    "entity_type_general_view": (
        "entity_type_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "table_definition_id",
        "entity_type_id1",
        "entity_type_id2",
        "schema",
        "table_name",
        "view_name",
        "seq",
        "table_list_id",
        "is_created_updated_fields",
        "is_logical_delete_fields",
        "contact_mapping_table_id",
        "profile_mapping_table_id",
        "is_ml_parent_table",
        "is_ml_child_table",
        "table_type",
        "is_number_column",
        "is_test_data_column",
        "is_main_column",
        "is_single_and_multi_value",
        "name_of_single_value_column",
        "is_mapping_table",
        "is_entity",
        "is_history",
        "is_one_table_per_all_tenants",
        "is_tree",
        "is_graph",
        "is_metrics",
        "is_visibility",
        "is_pii",
        "is_sensative",
        "sensative_columns",
        "TABLE_ROWS"
    ),
    "campaign_message_template_view": (
        "campaign_message_template_id",
        "campaign_id",
        "message_template_id",
        "percent"
    ),
    "criteria_general_view": (
        "criteria_id",
        "criteria_name",
        "entity_type_id",
        "entity_type.name",
        "entity_type.title",
        "min_age",
        "max_age",
        "gender_list_id",
        "gender_list.name",
        "group_list_id",
        "group_id",
        "group_list.name",
        "criteria.location_id",
        "title",
        "group.location.id",
        "group.location.name",
        "group.location.country.name",
        "country_id",
        "city_list_id",
        "location_type_id"
    ),
    "group_list_view": (
        "group_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_and"
    ),
    "group_list_table": (
        "group_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_and"
    ),
    "phone_general_view": (
        "phone_id",
        "number",
        "number_original",
        "international_code",
        "area_code",
        "local_number_normalized",
        "extension",
        "full_number_normalized",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "title",
        "is_verified"
    ),
    "label_phone_general_view": (
        "phone_id",
        "number",
        "number_original",
        "international_code",
        "area_code",
        "local_number_normalized",
        "extension",
        "full_number_normalized",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "label.name",
        "title",
        "profile_id",
        "phone_profile_id",
        "is_verified"
    ),
    "label_phone_table": (
        "label_phone_id",
        "label_id",
        "phone_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "group_job_title_view": (
        "group_job_title_id",
        "group_id",
        "group_ml_id",
        "job_title_id",
        "job_title_ml_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "relationship_type_ml_title2_view": (
        "entity_id",
        "title2",
        "coordinate"
    ),
    "relationship_type_ml_title1_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "goods_ml_table": (
        "goods_ml_id",
        "goods_id",
        "title",
        "is_title_approved",
        "lang_code",
        "description",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "timeline_potential_items_view": (
        "entity_type_id",
        "entity_id",
        "title",
        "lang_code",
        "location_id",
        "coordinate",
        "created_user_id",
        "visibility_id",
        "updated_timestamp"
    ),
    "goods_location_table": (
        "goods_location_id",
        "number",
        "identifier",
        "goods_id",
        "location_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "goods_table": (
        "goods_id",
        "number",
        "identifier",
        "name",
        "group_list_id",
        "visibility_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "group_location_type_table": (
        "group_location_type_id",
        "number",
        "identifier",
        "name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "group_location_table": (
        "group_location_id",
        "number",
        "identifier",
        "group_id",
        "location_id",
        "label_location_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "group_location_type_id"
    ),
    "contact_potential_view": (
        "entity_type_id",
        "entity_id",
        "title",
        "contact_ml_id",
        "lang_code",
        "contact_ml.titile",
        "contact_location_id",
        "location_id",
        "coordinate",
        "created_user_id",
        "visibility_id",
        "updated_timestamp"
    ),
    "event_location_table": (
        "event_location_id",
        "number",
        "identifier",
        "event_id",
        "location_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "event_potential_view": (
        "entity_type_id",
        "entity_id",
        "title",
        "lang_code",
        "location_id",
        "coordinate",
        "created_user_id",
        "visibility_id",
        "updated_timestamp"
    ),
    "group_potential_view": (
        "entity_type_id",
        "entity_id",
        "title",
        "lang_code",
        "location_id",
        "coordinate",
        "created_user_id",
        "visibility_id",
        "updated_timestamp"
    ),
    "goods_potential_view": (
        "entity_type_id",
        "entity_id",
        "title",
        "lang_code",
        "location_id",
        "coordinate",
        "created_user_id",
        "visibility_id",
        "updated_timestamp"
    ),
    "contact_ml_table": (
        "contact_ml_id",
        "number",
        "identifier",
        "contact_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "data_source_external_user_table": (
        "data_source_external_user_id",
        "data_source_id",
        "user_external_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "device_profile_table": (
        "device_profile_id",
        "device_id",
        "profile_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "data_source_service_table_old": (
        "data_source_service_id",
        "name"
    ),
    "criteria_set_general_view": (
        "parent_criteria_set_id",
        "parent_name",
        "child_criteria_set_id",
        "child_name",
        "criteria_id",
        "name",
        "entity_type_id",
        "entity_type_name",
        "group_list_id",
        "location_id",
        "location_list_id",
        "coordinate",
        "radius",
        "radius_measure",
        "radius_km",
        "job_group_list_id",
        "job_location_list_id",
        "vacancy_list_id",
        "workplace_profile_list_id",
        "start_date_type_id",
        "job_types_id",
        "user_external_id",
        "visibility_id",
        "where_sql",
        "template_condition",
        "criteria.is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "internet_domain_id",
        "internet_domain_list_id",
        "organization_name",
        "group_id",
        "profile_list_id",
        "international_code"
    ),
    "person_phone_general_view": (
        "person_id",
        "person.is_test_data",
        "person_phone_id",
        "phone_id",
        "internationa_code",
        "area_code",
        "full_number_normalized",
        "phone.is_test_data",
        "person_phone_id",
        "number",
        "identifier",
        "person_id",
        "phone_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "full_number_normalized"
    ),
    "real_estate_criteria_table": (
        "criteria_id",
        "name",
        "buyer_profile_id",
        "agent_profile_id",
        "budget_local_currency",
        "currency",
        "budget_usd",
        "requested_entrance_date",
        "has_cheq",
        "cash_guarentee_local_currency"
    ),
    "email_address_person_view": (
        "email_address_person_id",
        "email_address_id",
        "person_id"
    ),
    "email_address_person_general_view": (
        "person_id",
        "first_name",
        "last_name",
        "email_address_person_id",
        "contact_id",
        "contact_email_address_id",
        "email_address_id",
        "email_address",
        "email_address_approved"
    ),
    "contact_note_contact_table_old": (
        "contact_note_contact_id",
        "contact_note_id",
        "contact_id"
    ),
    "data_source_category_table": (
        "data_source_category_id",
        "name"
    ),
    "data_source_category_ml_table": (
        "data_source_category_ml_id",
        "data_source_category_id",
        "lang_code",
        "data_source_name",
        "data_source_name_approved",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "data_source_type_ml_en_view": (
        "data_source_type_id",
        "name",
        "title",
        "system_id",
        "system_ml.tite",
        "subsystem_id",
        "subsystem_ml.title"
    ),
    "system_ml_table": (
        "system_ml_id",
        "system_id",
        "lang_code",
        "title"
    ),
    "subsystem_ml_table": (
        "subsystem_ml_id",
        "subsystem_id",
        "lang_code",
        "title"
    ),
    "data_source_type_ml_table": (
        "data_source_type_ml_id",
        "data_source_type_id",
        "lang_code",
        "title",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "subsystem_table": (
        "subsystem_id",
        "name",
        "system_id"
    ),
    "group_profile_general_view": (
        "profile.name",
        "group.name",
        "group_profile_id",
        "group_id",
        "profile_id",
        "relationship_type_id",
        "is_sure",
        "group_profile_type_id",
        "supplier_category_id",
        "consumer_category_id",
        "participant_category_id",
        "months",
        "start_timestamp",
        "start_date_day",
        "start_date_month",
        "start_date_year",
        "start_circa",
        "end_timestamp",
        "end_date_day",
        "end_date_month",
        "end_date_year",
        "end_circa",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "number",
        "identifier",
        "is_test_data",
        "rank",
        "text_block_id",
        "is_recommended",
        "is_request_by_the_user",
        "is_approved_by_group_admin"
    ),
    "data_source_type__field_table": (
        "data_source_field_id",
        "data_source_type_id",
        "field_id",
        "external_field_name",
        "position"
    ),
    "entity_type_ml_table": (
        "entity_type_ml_id",
        "entity_type_id",
        "lang_code",
        "title",
        "is_title_approved",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "api_call_group_by_api_type_date_view": (
        "api_type_id",
        "api_type_name",
        "DATE(created_timestamp)",
        "COUNT(*)"
    ),
    "logger_start_end_group_by_component_date_view": (
        "component_name",
        "component_id",
        "DATE(created_timestamp)",
        "COUNT(*)"
    ),
    "system_table": (
        "system_id",
        "name",
        "parent_system_id"
    ),
    "logger_sessions_group_by_day_view": (
        "date",
        "COUNT(*)"
    ),
    "logger_records_of_last_session_view": (
        "session",
        "created_timestamp",
        "logger_id",
        "user_id",
        "profile_id",
        "component_id",
        "component_name",
        "class_name",
        "function_name",
        "line_number",
        "error_stack",
        "severity_id",
        "status_id",
        "message",
        "payload"
    ),
    "logger_last_session_view": (
        "session",
        "created_timestamp",
        "created_user_id"
    ),
    "storage_recent_view": (
        "storage_id",
        "storage_type_id",
        "path",
        "filename",
        "file_extension_id",
        "ext",
        "file_extension.name",
        "file_type_id",
        "file_type_ml.title",
        "file_type",
        "region",
        "url",
        "ratio_x",
        "ration_y",
        "width",
        "height",
        "stoage.is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "file_type_ml_table": (
        "file_type_ml_id",
        "file_type_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "description",
        "is_description_approved"
    ),
    "file_extension_table": (
        "file_extension_id",
        "ext",
        "name"
    ),
    "file_type_ml_view": (
        "file_type_ml_id",
        "file_type_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "description",
        "is_description_approved"
    ),
    "severity_table": (
        "severity_id",
        "name",
        "level",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_datetime",
        "end_datetime"
    ),
    "severity_ml_table": (
        "severity_ml_id",
        "severity_id",
        "lang_code",
        "title",
        "description"
    ),
    "api_type_table": (
        "api_type_id",
        "name",
        "description",
        "is_enabled",
        "endpoint_url",
        "http_method",
        "expiration_unit",
        "expiration_value",
        "interval_min_seconds",
        "interval_max_seconds",
        "from_system_id",
        "from_subsystem_id",
        "to_system_id",
        "to_subsystem_id",
        "message_channel_provider_id",
        "type",
        "action_id",
        "usage_and_billing_url",
        "status_code_when_not_found",
        "github_repo",
        "hander_function_name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "profile_ml_table": (
        "profile_ml_id",
        "profile_id",
        "lang_code",
        "is_main",
        "title",
        "title_approved",
        "about",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "api_call_table": (
        "api_call_id",
        "user_external_id",
        "api_type_id",
        "number",
        "endpoint_url",
        "outgoing_header_json",
        "outgoing_body_json",
        "outgoing_body_significant_fields_hash",
        "incoming_message_json",
        "http_status_code",
        "response_body_json",
        "is_network",
        "session_token",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "neighborhood_view": (
        "neighborhood_id",
        "number",
        "city_id",
        "coordinate",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "email_address_ml_table": (
        "email_address_ml_id",
        "email_address_id",
        "lang_code",
        "title",
        "title_approved",
        "is_test_data"
    ),
    "profile_storage_type_ml_table": (
        "profile_storage_type_ml_id",
        "profile_storage_type_id",
        "title",
        "lang_code"
    ),
    "criteria_set_table": (
        "criteria_set_id",
        "name",
        "condition_type_id",
        "include_exclude_type_id",
        "criteria_id"
    ),
    "importer_recent_general_view": (
        "importer_id",
        "data_source_instance_id",
        "importer.is_test_data",
        "data_source_type_id",
        "data_source_instance_name",
        "data_source_type_id_old",
        "data_source_type_ml.title",
        "entity_type_id",
        "entity_id",
        "url",
        "user_external_id",
        "user_external.system_id",
        "system_ml.title",
        "username",
        "handle",
        "profile_id",
        "location_id",
        "country_ml.title",
        "user_external_country_id_old",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "api_call_recent_general_view": (
        "created_timestamp",
        "api_call_id",
        "user_external_id",
        "api_type_id",
        "endpoint_url",
        "session_token",
        "is_test_data",
        "outgoing_header_json",
        "outgoing_body_json",
        "outgoing_body_significant_fields_hash",
        "incoming_message_json",
        "http_status_code",
        "response_body_json",
        "is_network"
    ),
    "data_source_instance_recent_general_view": (
        "created_timestamp",
        "data_source_instance_id",
        "name",
        "data_source_type_id",
        "file_or_api",
        "computer_name",
        "path",
        "filename",
        "imported_file_created_timestamp",
        "import_or_last_sync_timestamp",
        "user_external_id",
        "start_index",
        "end_index",
        "is_test_data",
        "start_timestamp",
        "end_timestamp"
    ),
    "url_type_table": (
        "url_type_id",
        "name",
        "url_prefix_old",
        "file_type_id",
        "system_id",
        "subsystem_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "data_source_instance_general_view": (
        "created_timestamp",
        "data_source_instance_id",
        "name",
        "data_source_type_id",
        "file_or_api",
        "computer_name",
        "path",
        "filename",
        "imported_file_created_timestamp",
        "import_or_last_sync_timestamp",
        "user_external_id",
        "start_index",
        "end_index",
        "is_test_data",
        "start_timestamp",
        "end_timestamp"
    ),
    "importer_recent_contact_url_view": (
        "created_timestamp",
        "importer_id",
        "data_source_type.title",
        "importer_country_name",
        "entity_type_id",
        "entity_type_ml.title",
        "entity_id",
        "url",
        "normalized_url",
        "url_type",
        "user_external_id",
        "username"
    ),
    "importer_recent_contact_storage_view": (
        "created_timestamp",
        "importer_id",
        "data_source_type.title",
        "importer_country_name",
        "entity_type_id",
        "entity_type_ml.title",
        "entity_id",
        "storage_id",
        "storage.url",
        "filename"
    ),
    "campaign_criteria_set_view": (
        "campaign_criteria_set_id",
        "campaign_id",
        "criteria_set_id",
        "criteria_id_old",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "email_address_ml_view": (
        "email_address_ml_id",
        "email_address_id",
        "lang_code",
        "title",
        "title_approved",
        "is_test_data"
    ),
    "campaign_criteria_set_general_view": (
        "campaign_criteria_set_id",
        "campaign_id",
        "criteria_id_old",
        "criteria_set_id",
        "is_test_data",
        "campaign.name",
        "criteria_set.name"
    ),
    "test_mysql_without_is_main_ml_table": (
        "test_mysql_ml_id",
        "number",
        "identifier",
        "test_mysql_id",
        "lang_code",
        "title",
        "is_title_approved",
        "unique_int_column",
        "visibility_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "test_mysql_without_is_main_ml_view": (
        "test_mysql_ml_id",
        "number",
        "identifier",
        "test_mysql_id",
        "lang_code",
        "title",
        "is_title_approved",
        "unique_int_column",
        "visibility_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "location_profile_table": (
        "location_profile_id",
        "profile_id",
        "location_id",
        "location_type_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "county_ml_general_view": (
        "county_ml_id",
        "number",
        "identifier",
        "county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "criteria_set_view": (
        "criteria_set_id",
        "name",
        "condition_type_id",
        "include_exclude_type_id",
        "criteria_id"
    ),
    "profile_storage_view": (
        "profile_storage_id",
        "profile_id",
        "storage_id"
    ),
    "location_list_table": (
        "location_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "location_list_member_table": (
        "location_list_member_id",
        "location_list_id",
        "location_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "location_profile_general_view": (
        "location_profile_id",
        "location_id",
        "name",
        "number",
        "identifier",
        "coordinate",
        "address_local_language",
        "address_english",
        "neighborhood_id",
        "county_id",
        "city_id",
        "region_id",
        "state_id",
        "country_id",
        "postal_code",
        "phonecode",
        "is_approved",
        "is_community_active",
        "group_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "profile_id"
    ),
    "label_location_view": (
        "label_location_id",
        "label_id",
        "location_id",
        "is_approved"
    ),
    "label_ml_table": (
        "label_ml_id",
        "label_id",
        "lang_code",
        "title",
        "is_title_approved",
        "is_main",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data"
    ),
    "country_general_view": (
        "country_id",
        "identifier",
        "coordinate",
        "iso",
        "name",
        "nicename",
        "iso3",
        "numcode",
        "phonecode",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "title",
        "group.name",
        "group.title"
    ),
    "criteria_set_parents_table": (
        "criteria_set_parents_id",
        "criteria_set_id",
        "parent_criteria_set_id",
        "condition_type_id",
        "include_exclude_type_id"
    ),
    "location_field_ml_table": (
        "locaton_field_ml_id",
        "location_id",
        "field_name",
        "prime",
        "lang_code",
        "title",
        "title_approved",
        "is_test_data"
    ),
    "country_ml_table": (
        "country_ml_id",
        "number",
        "identifier",
        "country_id",
        "country_id_old",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "county_ml_table": (
        "county_ml_id",
        "number",
        "identifier",
        "county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "state_table": (
        "state_id",
        "name",
        "number",
        "country_id",
        "coordinate",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestmap"
    ),
    "county_ml_with_deleted_and_test_data_view": (
        "county_ml_id",
        "number",
        "identifier",
        "county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "state_id"
    ),
    "test_county_ml_with_deleted_and_test_data_view": (
        "test_county_ml_id",
        "number",
        "identifier",
        "test_county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "test_state_id"
    ),
    "entity_type_table": (
        "entity_type_id",
        "name",
        "system_id",
        "is_item_type",
        "schema_name",
        "table_name",
        "view_name",
        "criteria_schema_name",
        "criteria_table_name",
        "criteria_view_name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "view_with_deleted_and_test_data"
    ),
    "activity_group_location_occurrence_profile_table": (
        "activity_group_location_occurrence_profile_id",
        "activity_id",
        "activity_list_id",
        "group_id",
        "group_list_id",
        "location_id",
        "location_list_id",
        "occurrence_id",
        "occurrence_list_id",
        "profile_id",
        "profile_list_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "county_table": (
        "county_id",
        "number",
        "state_id",
        "country_id",
        "name",
        "coordinate",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "region_ml_with_deleted_and_test_data_view": (
        "region_ml_id",
        "region_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data",
        "country_id",
        "group_id",
        "region.end_timestamp",
        "region_ml.end_timestamp"
    ),
    "neighborhood_ml_with_deleted_and_test_data_view": (
        "neighborhood_ml_id",
        "neighborhood_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data",
        "city_id"
    ),
    "criteria_profile_view": (
        "criteria_profile_id",
        "number",
        "identifier",
        "batch_timestamp",
        "criteria_id",
        "profile_id",
        "visibility_id",
        "is_approved",
        "is_test_data",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "location_ml_view": (
        "location_ml_id",
        "location_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data"
    ),
    "location_ml_table": (
        "location_ml_id",
        "location_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data"
    ),
    "city_ml_table": (
        "city_ml_id",
        "city_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data"
    ),
    "country_table": (
        "country_id",
        "identifier",
        "coordinate",
        "iso",
        "name",
        "nicename",
        "iso3",
        "numcode",
        "phonecode",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "neighborhood_ml_table": (
        "neighborhood_ml_id",
        "neighborhood_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "neighborhood_table": (
        "neighborhood_id",
        "number",
        "name",
        "city_id",
        "coordinate",
        "group_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "region_table": (
        "region_id",
        "number",
        "name",
        "country_id",
        "coordinate",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "region_ml_table": (
        "region_ml_id",
        "region_id",
        "lang_code",
        "title",
        "is_title_approved",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "country_view": (
        "country_id",
        "identifier",
        "coordinate",
        "iso",
        "name",
        "nicename",
        "iso3",
        "numcode",
        "phonecode",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "message_template_text_block_type_ml_table": (
        "message_template_text_block_type_ml_id",
        "number",
        "identifier",
        "message_template_text_block_type_id",
        "lang_code",
        "title",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "email_address_profile_general_view": (
        "email_address_profile_id",
        "email_address_id",
        "profile_id",
        "is_main",
        "is_sure",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "email_address_of_profile",
        "person_id",
        "email_address_person_id",
        "email_address_of_person",
        "contact_id",
        "contact_email_address_id",
        "email_address_of_contact"
    ),
    "text_block_table": (
        "text_block_id",
        "number",
        "identifier",
        "profile_id",
        "seq",
        "text",
        "text_without_empty_lines",
        "system_id",
        "system_entity_id",
        "text_block_type_id",
        "fields_extracted_json",
        "url",
        "visibility_id",
        "is_test_data",
        "effective_timestamp",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "criteria_set_profile_view": (
        "criteria_set_profile_id",
        "number",
        "identifier",
        "batch_timestamp",
        "criteria_set_id",
        "profile_id",
        "visibility_id",
        "is_test_data",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "form_type_table": (
        "form_type_table_id",
        "name",
        "version",
        "channel_type_id"
    ),
    "form_table": (
        "form_id",
        "number",
        "identifier",
        "name",
        "form_type_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "location_list_member_view": (
        "location_list_member_id",
        "location_list_id",
        "location_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "label_list_table": (
        "label_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "label_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "label_list_member_table": (
        "label_list_member_id",
        "label_list_id",
        "label_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "label_list_member_view": (
        "label_list_member_id",
        "label_list_id",
        "label_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "city_list_member_table": (
        "city_list_member_id",
        "city_list_id",
        "city_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "city_list_member_view": (
        "city_list_member_id",
        "city_list_id",
        "city_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "state_list_table": (
        "state_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "state_list_member_table": (
        "state_list_member_id",
        "state_list_id",
        "state_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "state_list_member_view": (
        "state_list_member_id",
        "state_list_id",
        "state_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "country_list_table": (
        "country_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "country_list_member_table": (
        "country_list_member_id",
        "country_list_id",
        "country_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "country_list_member_view": (
        "country_list_member_id",
        "country_list_id",
        "country_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "county_list_table": (
        "county_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "county_list_member_table": (
        "county_list_member_id",
        "county_list_id",
        "county_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "county_list_member_view": (
        "county_list_member_id",
        "county_list_id",
        "county_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "reaction_type_view": (
        "reaction_id",
        "name",
        "number",
        "value",
        "text",
        "image",
        "reaction_type_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "reaction_type_ml_view": (
        "reaction_type_id",
        "name",
        "lang_code",
        "title"
    ),
    "organization_ml_table": (
        "organization_ml_id",
        "number",
        "identifier",
        "organization_id",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "description",
        "is_description_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "action_general_view": (
        "action_id",
        "name",
        "description",
        "is_queue_action",
        "is_smartlink_action",
        "package_name",
        "function_name",
        "function_module",
        "folder_name",
        "filename",
        "source_system_id",
        "destination_system_id",
        "destination_subsystem_id",
        "expiration_unit",
        "expiration_value",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "action_stars"
    ),
    "reaction_type_ml_general_view": (
        "reaction_id",
        "name",
        "number",
        "value",
        "text",
        "image",
        "reaction_type_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "reaction_type_ml.lang_code",
        "title",
        "reaction_type_ml.is_test_data",
        "reaction_type_ml.end_timestamp"
    ),
    "reaction_type_ml_with_deleted_and_test_data_view": (
        "reaction_type_id",
        "name",
        "is_test_data",
        "end_timestamp",
        "lang_code",
        "title",
        "reaction_type_ml.is_test_data",
        "reaction_type_ml.end_timestamp"
    ),
    "reaction_ml_with_deleted_and_test_data_view": (
        "reaction_id",
        "value",
        "text",
        "image",
        "reaction.is_test_data",
        "lang_code",
        "reaction.title",
        "reaction_ml.is_test_data",
        "reaction_type_id",
        "reaction_type_ml.lang_code",
        "title",
        "reaction_type_ml.is_test_data",
        "reaction_category_id",
        "reaction_category_ml.lang_code",
        "reaction_category_ml.title",
        "reaction_category_ml.is_test_data"
    ),
    "reaction_ml_general_view": (
        "reaction_id",
        "value",
        "text",
        "image",
        "is_test_data",
        "reaction.title",
        "lang_code",
        "is_main",
        "reaction_type_id",
        "title",
        "reaction_category_id",
        "reaction_category_ml.title"
    ),
    "smartlink_type_general_view": (
        "smartlink_type_id",
        "number",
        "identifier",
        "smartlink.name",
        "dialog_workflow_script_id_old",
        "action_id",
        "expiration_value",
        "expiration_unit",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "dialog_workflow_script_id",
        "start_state_id"
    ),
    "reaction_category_ml_table": (
        "id",
        "reaction_category_id",
        "lang_code",
        "title",
        "description",
        "is_test_data"
    ),
    "reaction_ml_view_old": (
        "reaction_id",
        "value",
        "text",
        "image",
        "reaction_type_id",
        "reaction_table.is_test_data",
        "reaction_ml_id",
        "lang_code",
        "title",
        "description",
        "updated_timestamp"
    ),
    "reaction_ml_view": (
        "reaction_id",
        "value",
        "image",
        "reaction_type_id",
        "reaction_ml_id",
        "lang_code",
        "title",
        "description"
    ),
    "reaction_ml_table": (
        "reaction_ml_id",
        "number",
        "identifier",
        "reaction_id",
        "lang_code",
        "title",
        "is_main",
        "is_title_approved",
        "description",
        "is_description_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "data_source_instance_table": (
        "data_source_instance_id",
        "number",
        "identifier",
        "name",
        "data_source_type_id",
        "file_or_api",
        "computer_name",
        "path",
        "filename",
        "imported_file_created_timestamp",
        "import_or_last_sync_timestamp",
        "user_external_id",
        "start_index",
        "end_index",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "system_entity_table": (
        "system_entity_id",
        "system_id",
        "title"
    ),
    "system_view": (
        "system_id",
        "name",
        "parent_system_id"
    ),
    "system_ml_view": (
        "system_ml_id",
        "system_id",
        "lang_code",
        "title"
    ),
    "url_type_regex_table": (
        "url_type_regex_id",
        "url_type_id",
        "url_type_regex",
        "example"
    ),
    "field_general_view": (
        "field_id",
        "number",
        "identifier",
        "name",
        "description",
        "variable_id",
        "variable.name",
        "is_ml_table",
        "table_id",
        "table_name",
        "visibility_id",
        "database_field_name",
        "database_sub_field_name",
        "database_sub_field_value",
        "processing_id",
        "processing_database_field_name",
        "internal_description",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "variable_table": (
        "variable_id",
        "number",
        "identifier",
        "name",
        "description",
        "field_id",
        "person_id",
        "user_id",
        "profile_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "data_source_type_general_view": (
        "data_source_type_id",
        "name",
        "system_id",
        "subsystem_id",
        "data_source_category_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "data_source_type_ml.title"
    ),
    "smartlink_table": (
        "smartlink_id",
        "identifier",
        "number",
        "smartlink_type_id",
        "from_contact_id",
        "from_person_id",
        "from_user_id",
        "from_profile_id",
        "from_email_address_old",
        "from_email_address_id",
        "from_normalized_phone",
        "from_phone_id",
        "to_contact_id",
        "to_person_id",
        "to_user_id",
        "to_profile_id",
        "to_group_id",
        "to_email_address_old",
        "to_email_address_id",
        "to_normalized_phone_old",
        "to_phone_id",
        "action_id",
        "lang_code",
        "campaign_id",
        "message_template_id",
        "smartlink_message_id",
        "content_message_id",
        "dialog_workflow_script_id",
        "clicked_timestamp",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "url_redirect"
    ),
    "smartlink_type_table": (
        "smartlink_type_id",
        "number",
        "identifier",
        "name",
        "dialog_workflow_script_id_old",
        "action_id",
        "expiration_value",
        "expiration_unit",
        "url_redirect_template",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "location_ml_with_deleted_and_test_data_view": (
        "location_id",
        "name",
        "number",
        "identifier",
        "coordinate",
        "address_local_language",
        "address_english",
        "neighborhood_id",
        "county_id",
        "city_id",
        "region_id",
        "state_id",
        "country_id",
        "postal_code",
        "phonecode",
        "is_approved",
        "is_community_active",
        "group_id",
        "location.visibility_id",
        "location.is_test_data",
        "location.start_timestamp",
        "location.end_timestamp",
        "location.created_timestamp",
        "location.created_user_id",
        "location.created_real_user_id",
        "location.created_effective_user_id",
        "location.created_effective_profile_id",
        "location.updated_timestamp",
        "location.updated_user_id",
        "location.updated_real_user_id",
        "location.updated_effective_user_id",
        "location.updated_effective_profile_id",
        "location_ml_id",
        "lang_code",
        "title",
        "is_title_approved",
        "created_timestamp",
        "location_ml.created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data"
    ),
    "form_message_template_table": (
        "form_message_template_id",
        "form_id",
        "page",
        "seq",
        "message_template_id",
        "min_message_template",
        "max_message_template",
        "criteria_set_id"
    ),
    "url_table": (
        "url_id",
        "number",
        "identifier",
        "url",
        "normalized_url",
        "url_type",
        "storage_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "logger_all_fields_updates": (
        "name",
        "variable.name",
        "Website",
        "internal_description"
    ),
    "person_profile_general_view": (
        "person.first_name",
        "person.last_name",
        "person.main_email_address",
        "person.end_timestamp",
        "person_profile_id",
        "number",
        "identifier",
        "person_id",
        "profile_id",
        "person_profile_role_id",
        "is_test_data",
        "start_timestamp",
        "person_profile.end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "profile.profile_id",
        "profile.name",
        "profile.main_email_address",
        "profile.main_user_id",
        "profile.is_test_data",
        "profile.end_timestamp"
    ),
    "campaign_message_template_general_view": (
        "campaign_id",
        "campaign_message_template.percent",
        "message_template_id",
        "message_template.name",
        "message_template_text_block_seq",
        "message_template_text_block_name",
        "email_subject_template",
        "email_body_html_template",
        "sms_body_template",
        "whatsapp_body_template",
        "message_template_text_block_type.title",
        "question_id",
        "question.name",
        "question.title"
    ),
    "job_title_ml_en_view": (
        "job_title_ml_id",
        "job_title_id",
        "job_title_ml.lang_code",
        "job_title.name",
        "job_title_ml.title",
        "job_title_ml.is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "job_title_vacancy_view": (
        "job_title_vacancy_id",
        "job_title_id",
        "vacancy_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "last_name_table": (
        "last_name_id",
        "name",
        "number",
        "identifier",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_recent_general_view": (
        "updated_timestamp",
        "contact_id",
        "first_name",
        "last_name",
        "email1"
    ),
    "logger_last_session_general_view": (
        "session",
        "created_timestamp"
    ),
    "group_type_ml_table": (
        "group_type_ml_id",
        "group_type_id",
        "lang_code",
        "title"
    ),
    "state_ml_table": (
        "state_ml_id",
        "number",
        "identifier",
        "state_id",
        "lang_code",
        "title",
        "is_title_approved",
        "state_abbr",
        "state_abbr_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "created_user_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "updated_user_id"
    ),
    "table_definition_table": (
        "table_definition_id",
        "entity_type_id1",
        "entity_type_id2",
        "schema",
        "table_name",
        "view_name",
        "seq",
        "table_list_id",
        "is_created_updated_fields",
        "is_logical_delete_fields",
        "contact_mapping_table_id",
        "profile_mapping_table_id",
        "is_ml_parent_table",
        "is_ml_child_table",
        "table_type",
        "is_number_column",
        "is_test_data_column",
        "is_main_column",
        "is_single_and_multi_value",
        "name_of_single_value_column",
        "is_mapping_table",
        "is_entity",
        "is_history",
        "is_one_table_per_all_tenants",
        "is_tree",
        "is_graph",
        "is_metrics",
        "is_visibility",
        "is_pii",
        "is_sensative",
        "sensative_columns",
        "is_dynamic",
        "description",
        "insert_is_undelete",
        "is_metadata",
        "is_metadata_whole_table",
        "is_user_data",
        "is_user_data_whole_table",
        "end_timestamp"
    ),
    "campaign_type_table": (
        "campaign_type_id",
        "name"
    ),
    "campaign_campaign_type_table": (
        "campaign_campaign_type_id",
        "campaign_id",
        "campaign_type_id"
    ),
    "group_group_type_view": (
        "group_group_type_id",
        "group_id",
        "group_type_id"
    ),
    "role_table": (
        "role_id",
        "name",
        "group_id"
    ),
    "group_type_ml_view": (
        "group_type_ml_id",
        "group_type_id",
        "lang_code",
        "title",
        "name"
    ),
    "message_status_type_table": (
        "message_status_id",
        "name"
    ),
    "message_status_ml_table": (
        "message_status_type_ml_id",
        "message_status_type_id",
        "lang_code",
        "title",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "person_ml_table": (
        "person_ml_id",
        "number",
        "identifier",
        "person_id",
        "lang_code",
        "first_name",
        "is_first_name_approved",
        "last_name",
        "is_last_name_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id"
    ),
    "data_source_instance_view": (
        "data_source_instance_id",
        "number",
        "identifier",
        "name",
        "data_source_type_id",
        "file_or_api",
        "computer_name",
        "path",
        "filename",
        "imported_file_created_timestamp",
        "import_or_last_sync_timestamp",
        "user_external_id",
        "start_index",
        "end_index",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "action_item_profile_table_old": (
        "action_item_profile_id",
        "number",
        "identifier",
        "action_item_id",
        "profile_id1",
        "profile_id2",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_general_circ_view": (
        "profile_id",
        "number",
        "profile.name",
        "profile.main_user_id",
        "main_person_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "main_phone_id",
        "profile.main_email_address",
        "is_rip",
        "profile.gender_id",
        "stars",
        "last_dialog_workflow_state_id",
        "is_system",
        "internal_description",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "profile_ml.title",
        "profile_type_ml.title",
        "profile.main_person_id",
        "person.person_id",
        "person.first_name",
        "person.last_name"
    ),
    "contact_group_table": (
        "contact_group_id",
        "number",
        "identifier",
        "contact_id",
        "group_id",
        "group_ml_id",
        "seq",
        "attribute",
        "contact_group_type_id",
        "supplier_category_id",
        "consumer_category_id",
        "participant_category_id",
        "relationship_type_id",
        "is_sure",
        "is_recommended_by_contact_notes",
        "is_recommende_by_ai",
        "months",
        "is_test_data",
        "start_timestamp",
        "start_date_day",
        "start_date_month",
        "start_date_year",
        "start_circa",
        "end_timestamp",
        "end_date_day",
        "end_date_month",
        "end_date_year",
        "end_circa",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_main_in_category",
        "is_potential"
    ),
    "job_title_profile_view": (
        "job_title_profile_id",
        "job_title_id",
        "job_title_ml_id",
        "profile_id",
        "end_timestamp"
    ),
    "importer_recent_contact_job_title_view": (
        "importer_id",
        "data_source_instance_id",
        "data_source_instance_name",
        "data_source_type_id_old",
        "data_source_type_id",
        "data_source_type_ml.title",
        "entity_type_id",
        "entity_id",
        "url",
        "user_external_id",
        "user_external.system_id",
        "username",
        "handle",
        "profile_id",
        "location_id",
        "user_external_country_id_old",
        "is_test_data",
        "contact.job_title",
        "job_title_ml_from_contact.job_title_ml_id",
        "job_title_ml_from_contact.title",
        "job_title_ml_from_profile.job_title_ml_id",
        "job_title_ml_from_profile.title",
        "job_title_profile_id",
        "name",
        "group_ml.title"
    ),
    "group_profile_type_table": (
        "group_profile_type_id",
        "number",
        "identifier",
        "name",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "importer_recent_contact_action_item_view": (
        "importer_id",
        "data_source_instance_id",
        "data_source_instance_name",
        "data_source_type_id_old",
        "data_source_type_id",
        "data_source_type_ml.title",
        "entity_type_id",
        "entity_id",
        "url",
        "user_external_id",
        "user_external.system_id",
        "username",
        "handle",
        "profile_id",
        "location_id",
        "system_ml.title",
        "country_ml.title",
        "user_external_country_id_old",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "action_item_profile_id",
        "profile.name",
        "action_item.name",
        "activity_id",
        "action_item_ml.title"
    ),
    "campaign_message_profile_general_view": (
        "campaign_message_profile_id",
        "number",
        "identifier",
        "campaign_id",
        "message_id",
        "profile_id",
        "channel_id_old",
        "last_dialog_workflow_state_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "channel_id"
    ),
    "campaign_message_profile_view": (
        "campaign_message_profile_id",
        "number",
        "identifier",
        "campaign_id",
        "message_id",
        "profile_id",
        "channel_id_old",
        "last_dialog_workflow_state_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "profile_user_table": (
        "profile_user_id",
        "profile_id",
        "user_id",
        "is_main",
        "is_active",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "action_item_general_view": (
        "action_item_id",
        "number",
        "identifier",
        "activity_id",
        "ranking",
        "other_group_id",
        "other_person_id",
        "other_profile_id",
        "name",
        "action_id",
        "action_item_type_id",
        "active_main_profile_id",
        "passive_main_profile_id",
        "passive_main_contact_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "action_item_profile_table": (
        "action_item_profile_id",
        "number",
        "identifier",
        "action_item_id",
        "action_item_ml_id",
        "active_profile_id",
        "passive_profile_id",
        "passive_contact_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "job_title_ml_with_deleted_and_test_data_view": (
        "job_title_id",
        "job_title.name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "job_title_ml_id",
        "job_title_ml.lang_code",
        "job_title_ml.title",
        "job_title_ml.is_title_approved",
        "job_title_ml.created_timestamp",
        "job_title_ml.created_user_id",
        "job_title_ml.updated_timestamp",
        "job_title_ml.updated_user_id",
        "job_title_ml.start_timestamp",
        "job_title_ml.end_timestamp"
    ),
    "job_title_table": (
        "job_title_id",
        "job_title.name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "job_title_ml_table": (
        "job_title_ml_id",
        "job_title_id",
        "job_title_ml.lang_code",
        "job_title_ml.title",
        "job_title_ml.is_main",
        "job_title_ml.is_title_approved",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "subsystem_ml_genetal_view": (
        "system_id",
        "name",
        "parent_system_id",
        "system_ml.title",
        "subsystem_ml.title"
    ),
    "dialog_workflow_script_with_forms_view": (
        "dialog_workflow_state_id",
        "state_id",
        "parent_state_id",
        "workflow_action_id",
        "title",
        "next_state_id_if_there_is_no_feedback",
        "lang_code",
        "parameter1",
        "name"
    ),
    "message_template_message_template_text_block_table": (
        "message_template_message_template_text_block_id",
        "message_template_id",
        "seq",
        "message_template_text_block_type_id",
        "message_template_text_block_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "workflow_action_table": (
        "workflow_action_id",
        "name",
        "description",
        "software_development_status"
    ),
    "importer_table": (
        "importer_id",
        "number",
        "data_source_instance_id",
        "data_source_type_id_old",
        "user_external_id",
        "entity_type_id",
        "entity_id",
        "url",
        "data_imported_json",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "user_external_country_id_old",
        "data_source_external_user_id_old",
        "google_people_api_resource_name",
        "google_calendar_id"
    ),
    "profile_variable_table": (
        "profile_variable_id",
        "profile_id",
        "variable_id",
        "answer_text",
        "answer_number",
        "created_timestamp",
        "expiration_timestamp"
    ),
    "user_general_circles_view": (
        "person_id",
        "person.is_approved",
        "person.main_email_address",
        "user.main_email_address",
        "username",
        "user_id",
        "profile_id",
        "profile.preferred_lang_code",
        "profile.gender_id",
        "profile.main_email_address",
        "user.first_name",
        "user.last_name",
        "user.created_timestamp",
        "brand_id",
        "user.active_location_id",
        "user.active_location.country_ml.title",
        "subscription_id",
        "subscription_title",
        "user.stars",
        "profile.stars",
        "person.birthday_date",
        "profile.phone.full_number_normalized",
        "role_name"
    ),
    "profile_question_table": (
        "profile_question_id",
        "question_id",
        "user_id",
        "profile_id",
        "answer_text",
        "answer_number",
        "created_timestamp",
        "expiration_timestamp"
    ),
    "content_set_table": (
        "content_set_id",
        "name",
        "parent_content_set_id"
    ),
    "message_channel_content_set_profile_table": (
        "message_channel_content_set_profile_table",
        "message_channel_id",
        "content_set_id",
        "profile_id",
        "is_subscribed",
        "is_opt_out"
    ),
    "criteria_person_table_old": (
        "criteria_person_id",
        "number",
        "identifier",
        "batch_timestamp",
        "criteria_id",
        "profile_id",
        "visibility_id",
        "is_approved",
        "is_test_data",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "dialog_workflow_script_table": (
        "dialog_workflow_script_id",
        "name",
        "min_state_id",
        "max_state_id",
        "start_state_id",
        "dialog_workflow_script_status_text",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "dialog_workflow_state_table": (
        "dialog_workflow_state_id",
        "state_id",
        "parent_state_id",
        "name",
        "remark",
        "workflow_action_id",
        "message_template_id",
        "lang_code",
        "parameter1",
        "variable1_id",
        "variable2_id",
        "result_logical",
        "result_figure_min",
        "result_figure_max",
        "next_state_id",
        "no_feedback_milliseconds",
        "next_state_id_if_there_is_no_feedback",
        "version",
        "checked_in",
        "criteria_id",
        "channel_id",
        "criteria_set_id",
        "end_timestamp"
    ),
    "job_title_profile_table": (
        "job_title_profile_id",
        "job_title_id",
        "job_title_ml_id",
        "profile_id",
        "end_timestamp"
    ),
    "group_job_title_table": (
        "group_job_title_id",
        "group_id",
        "group_ml_id",
        "job_title_id",
        "job_title_ml_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "seller_category_table": (
        "seller_category_id"
    ),
    "cloud_region_county_table": (
        "cloud_region_country_id",
        "cloud_region_id",
        "county_id"
    ),
    "brand_cloud_region_county_table": (
        "brand_cloud_region_country_id",
        "brand_id",
        "cloud_region_id",
        "county_id",
        "error_message"
    ),
    "criteria_profile_general_view": (
        "criteria_profile_id",
        "number",
        "identifier",
        "batch_timestamp",
        "criteria_id",
        "profile_id",
        "visibility_id",
        "is_approved",
        "is_test_data",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_main"
    ),
    "advertisement_costs_table": (
        "advertisement_costs_id",
        "subscription_id",
        "model",
        "per",
        "country_id",
        "vertical_id",
        "category_id",
        "activity_id",
        "cost_min_usd",
        "cost_max_usd",
        "source",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "advertisement_type_ml_table": (
        "advertisement_type_ml_id",
        "advertisement_type_id",
        "lang_code",
        "title"
    ),
    "real_estate_listing_view": (
        "real_estate_listing_id",
        "number",
        "identifier",
        "agent_name",
        "agent_office_phone",
        "price",
        "property_type",
        "land_size",
        "building_size",
        "num_of_bedrooms",
        "num_of_bathrooms",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "importer_recent_real_estate_view": (
        "importer_id",
        "data_source_instance_id",
        "importer.is_test_data",
        "data_source_type_id",
        "data_source_instance_name",
        "data_source_type_id_old",
        "data_source_type_ml.title",
        "entity_type_id",
        "entity_id",
        "url",
        "user_external_id",
        "user_external.system_id",
        "system_ml.title",
        "username",
        "handle",
        "profile_id",
        "location_id",
        "country_ml.title",
        "user_external_country_id_old",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "real_estate_listing_id",
        "number",
        "identifier",
        "agent_name",
        "agent_office_phone",
        "price",
        "property_type",
        "land_size",
        "building_size",
        "num_of_bedrooms",
        "num_of_bathrooms",
        "re.visibility_id",
        "re.is_test_data",
        "re.start_timestamp",
        "re.end_timestamp",
        "re.created_timestamp",
        "re.created_user_id",
        "re.created_real_user_id",
        "re.created_effective_user_id",
        "re.created_effective_profile_id",
        "re.updated_timestamp",
        "re.updated_user_id",
        "re.updated_real_user_id",
        "re.updated_effective_user_id",
        "re.updated_effective_profile_id"
    ),
    "person_promotional_message_ml_table": (
        "person_promotional_message_ml_id",
        "person_promotional_message_id",
        "lang_code",
        "title",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "real_estate_listing_table": (
        "real_estate_listing_id",
        "number",
        "identifier",
        "agent_name",
        "agent_office_phone",
        "price",
        "property_type",
        "land_size",
        "building_size",
        "num_of_bedrooms",
        "num_of_bathrooms",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "label_location_general_view": (
        "label_location_id",
        "label_id",
        "label.name",
        "label_ml.title",
        "location_id",
        "location.name",
        "location_ml.title",
        "is_approved"
    ),
    "location_type_table": (
        "location_type_id",
        "name",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "label_location_table": (
        "label_location_id",
        "label_id",
        "label_ml_id",
        "location_id",
        "location_ml_id",
        "is_approved"
    ),
    "location_location_type_view": (
        "location_location_type_id",
        "location_id",
        "location_ml_id",
        "location_type_id",
        "location_type_ml_id"
    ),
    "location_location_type_geneal_view": (
        "location_location_type_id",
        "location_id",
        "location_ml_id",
        "location_type_id",
        "location_type_ml_id",
        "location.name",
        "location_ml.title",
        "location_type.name",
        "location_type_ml.title"
    ),
    "location_location_type_table": (
        "location_location_type_id",
        "location_id",
        "location_ml_id",
        "location_type_id",
        "location_type_ml_id"
    ),
    "message_template_text_block_question_review_view": (
        "message_template_text_block_id",
        "name",
        "lang_code",
        "default_body_template",
        "question_id"
    ),
    "question_ml_table": (
        "question_ml_id",
        "question_id",
        "gender_id",
        "lang_code",
        "title",
        "default_value"
    ),
    "conversation_ml_table": (
        "conversation_ml_table",
        "conversation_id",
        "lang_code",
        "title"
    ),
    "location_table": (
        "location_id",
        "name",
        "number",
        "identifier",
        "coordinate",
        "address_local_language",
        "address_english",
        "neighborhood_id",
        "county_id",
        "city_id",
        "city_ml_id",
        "region_id",
        "state_id",
        "country_id",
        "postal_code",
        "phonecode",
        "is_approved",
        "is_community_active",
        "group_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_official"
    ),
    "city_list_table": (
        "city_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "city_table": (
        "city_id",
        "new_city_id",
        "number",
        "name",
        "coordinate",
        "phonecode",
        "group_id",
        "state_id",
        "country_id",
        "country_id_old",
        "is_test_data",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "criteria_table": (
        "criteria_id",
        "name",
        "entity_type_id",
        "min_age_old",
        "max_age_old",
        "group_id",
        "group_list_id",
        "min_number_of_kids_old",
        "max_number_of_kids_old",
        "min_kids_age_old",
        "max_kids_age_old",
        "gender_list_id_old",
        "min_height_old",
        "max_height_old",
        "partner_experience_level_old",
        "number_of_partners_old",
        "location_id",
        "location_list_id",
        "coordinate",
        "radius",
        "radius_measure",
        "radius_km",
        "job_group_list_id",
        "job_location_list_id",
        "vacancy_list_id",
        "workplace_profile_list_id",
        "start_date_type_id",
        "job_types_id",
        "user_external_id",
        "visibility_id",
        "where_sql",
        "template_condition",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "internet_domain_id",
        "internet_domain_list_id",
        "organization_name",
        "profile_list_id",
        "international_code",
        "country_id_old",
        "county_id_old",
        "label_id",
        "location_type_id"
    ),
    "organization_table": (
        "organization_id",
        "number",
        "identifier",
        "is_approved",
        "is_main",
        "point",
        "location_id",
        "profile_id",
        "parent_organization_id",
        "non_members_visibility_scope_id",
        "members_visibility_scope_id",
        "Non_members_visibility_profile_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp",
        "main_group_id",
        "name"
    ),
    "organization_profile_table": (
        "organization_profile_id",
        "number",
        "identifier",
        "organization_id",
        "organization_ml_id",
        "profile_id",
        "job_title_id",
        "job_title_ml_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_table": (
        "contact_id",
        "number",
        "identifier",
        "owner_profile_id",
        "data_source_instance_id",
        "account_name",
        "person_id",
        "uploaded_timestamp",
        "last_sync_timestamp",
        "name_prefix",
        "original_first_name",
        "first_name",
        "additional_name",
        "original_last_name",
        "last_name",
        "full_name",
        "name_suffix",
        "nickname",
        "display_as",
        "title",
        "organization",
        "organization_profile_id",
        "job_title",
        "job_title_id",
        "job_title_ml_id",
        "main_profile_id",
        "department",
        "notes",
        "email1",
        "email2",
        "email3",
        "phone1",
        "phone2",
        "phone3",
        "address1_street",
        "address1_city",
        "address1_state",
        "address1_postal_code",
        "address1_country",
        "address2_street",
        "address2_city",
        "address2_state",
        "address2_postal_code",
        "address2_country",
        "birthday",
        "day",
        "month",
        "year",
        "cira",
        "anniversary",
        "website1",
        "website2",
        "website3",
        "photo_url",
        "photo_file_name",
        "source",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "contact_organization_general_view": (
        "contact_id",
        "contact.first_name",
        "contact.last_name",
        "organization_ml.title",
        "contact_profile_id",
        "profile_id",
        "job_title_ml.title",
        "contact.job_title_ml.job_title_ml_id",
        "contact.job_title_ml.title",
        "profile.job_title_ml.job_title_ml_id",
        "profile.job_title_ml.title",
        "group_id",
        "group.name",
        "group_ml.title",
        "organization_profile.job_title_ml.title"
    ),
    "location_criteria_table": (
        "criteria_id",
        "state_id",
        "country_id",
        "county_id",
        "city_id",
        "neighbourhood_id",
        "street_id",
        "location_id_old",
        "location_list_id_old",
        "city_list_id",
        "location_type_id"
    ),
    "smartlink_general_view": (
        "smartlink_id",
        "identifier",
        "smartlink.number",
        "smartlink_type_id",
        "smartlink.name",
        "dialog_workflow_script_id_old",
        "from_email_address_old",
        "to_email_address_old",
        "smartlink.action_id",
        "lang_code",
        "campaign_id",
        "smartlink.is_test_data",
        "smartlink_type.action_id",
        "smartlink.created_timestamp",
        "created_user_id",
        "created_user.username"
    ),
    "smartlink_general_recent_view": (
        "smartlink_id",
        "identifier",
        "smartlink.number",
        "smartlink_type_id",
        "smartlink.name",
        "dialog_workflow_script_id_old",
        "from_email_address_old",
        "to_email_address_old",
        "smartlink.action_id",
        "lang_code",
        "campaign_id",
        "smartlink.is_test_data",
        "smartlink_type.action_id",
        "smartlink.created_timestamp",
        "created_user_id",
        "created_user.username"
    ),
    "logger_general_view": (
        "logger_id",
        "created_timestamp",
        "server_ip_v4",
        "server_ip_v6",
        "component_id",
        "name",
        "programming_language_id",
        "programming_language"
    ),
    "logger_general_recent_view": (
        "logger_id",
        "created_timestamp",
        "server_ip_v4",
        "server_ip_v6",
        "component_id",
        "name",
        "programming_language_id",
        "programming_language"
    ),
    "activity_table": (
        "activity_id",
        "number",
        "identifier",
        "name",
        "ranking",
        "action_item_category_id",
        "action_id",
        "activity_type_id",
        "parent_activity_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "star_transaction_table": (
        "star_transaction_id",
        "identifier",
        "number",
        "api_type_id",
        "activity_type_id",
        "action_id",
        "person_id",
        "user_id",
        "profile_id",
        "subscription_id",
        "invitation_id",
        "action_stars",
        "is_conditional",
        "balance_after_transaction",
        "parent_star_transaction_id",
        "session",
        "profile_id2",
        "user_id2",
        "person_id2",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "subject_table": (
        "subject_id",
        "name"
    ),
    "lesson_table": (
        "lesson_id",
        "description",
        "teacher_id",
        "platform_id",
        "subject_id",
        "price_local_currency",
        "local_curency_id",
        "duration_minutes",
        "platform",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "course_table": (
        "course_id",
        "name",
        "business_education_profile_id",
        "semester",
        "subject_id"
    ),
    "lang_code_table": (
        "lang_code_id",
        "lang_code",
        "name"
    ),
    "group_user_external_table": (
        "group_user_external_id",
        "group_id",
        "user_external_id"
    ),
    "importer_recent_general_facebook_view": (
        "importer_id",
        "data_source_instance_id",
        "importer.is_test_data",
        "data_source_type_id",
        "data_source_instance_name",
        "data_source_type_id_old",
        "data_source_type_ml.title",
        "entity_type_id",
        "entity_id",
        "url",
        "user_external_id",
        "user_external.system_id",
        "system_ml.title",
        "username",
        "handle",
        "profile_id",
        "location_id",
        "country_ml.title",
        "user_external_country_id_old",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "group_label_view": (
        "group_label_id",
        "number",
        "identifier",
        "group_id",
        "label_id",
        "hashtag",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "group_label_table": (
        "group_label_id",
        "number",
        "identifier",
        "group_id",
        "label_id",
        "hashtag",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "queue_item_table": (
        "queue_item_id",
        "item_description",
        "action_id",
        "class_parameters_json",
        "function_parameters_json",
        "stdout",
        "stderr",
        "return_code",
        "returned_value",
        "return_message",
        "return_json",
        "queue_status_id",
        "server_ip_v4",
        "server_ip_v6",
        "process_id",
        "thread_id",
        "user_jwt",
        "number",
        "execution_start_time",
        "execution_end_time",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "session",
        "identifier",
        "is_test_data"
    ),
    "group_url_table": (
        "group_url_id",
        "group_id",
        "url_id",
        "url_temp",
        "system_id_temp",
        "created_timestamp",
        "number_of_members_temp",
        "is_tal_il_joined_temp",
        "is_active"
    ),
    "subscription_table": (
        "subscription_id",
        "name",
        "brand_id",
        "is_paid",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "subscription_action_limit_template_table": (
        "subscription_action_limit_template_id",
        "subscription_id",
        "action_id",
        "fixed_limit",
        "fix_limit_units",
        "limit_unit",
        "soft_limit_value",
        "hard_limit_value",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "brand_ml_table": (
        "id",
        "brand_id",
        "lang_code",
        "title",
        "is_main_title",
        "description",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "test_profile_table": (
        "test_profile_id",
        "name"
    ),
    "test_location_profile_mapping_table": (
        "test_location_profile_id",
        "test_profile_id",
        "test_location_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "test_location_profile_mapping_view": (
        "test_location_profile_id",
        "test_profile_id",
        "test_location_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "subscription_general_view": (
        "brand_id",
        "brand_name",
        "subscription_id",
        "subscription.name",
        "title",
        "action_id",
        "action.name",
        "hard_limit_value",
        "is_paid",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "subscription_addons_table": (
        "subscription_addons_id",
        "name",
        "action_id"
    ),
    "action_general_without_subscription_view": (
        "action_id",
        "name",
        "description",
        "is_queue_action",
        "is_smartlink_action",
        "package_name",
        "function_name",
        "function_module",
        "folder_name",
        "filename",
        "source_system_id",
        "destination_system_id",
        "destination_subsystem_id",
        "expiration_unit",
        "expiration_value",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "action_stars"
    ),
    "seller_ml_view": (
        "entity_type_id",
        "seller.name",
        "seller.title",
        "coordinate"
    ),
    "seller_table": (
        "seller_id",
        "name",
        "profile_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "shop_table": (
        "shop_id",
        "name",
        "owner_seller_id",
        "coordinate",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "shop_ml_table": (
        "id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "title",
        "is_title_approved",
        "lang_code",
        "shop_id",
        "description",
        "is_test_data"
    ),
    "shop_general_view": (
        "shop.name",
        "seller.name",
        "seller_ml.title",
        "profile.name"
    ),
    "profile_ml_general_view": (
        "profile_id",
        "number",
        "profile.name",
        "profile.main_user_id",
        "main_person_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "main_phone_id",
        "profile.main_email_address",
        "is_rip",
        "profile.gender_id",
        "stars",
        "is_system",
        "internal_description",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "profile_type_ml.title",
        "profile_ml.title",
        "profile.main_person_id",
        "person.person_id",
        "person.first_name",
        "person.last_name",
        "last_dialog_workflow_state_id_old",
        "last_dialog_workflow_state_id"
    ),
    "test_county_view": (
        "test_county_id",
        "number",
        "test_state_id",
        "test_country_id",
        "name",
        "coordinate",
        "new_test_county_id",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "test_county_location_mapping_view": (
        "test_county_location_mapping_id",
        "test_county_id",
        "test_location_id",
        "is_test_data"
    ),
    "test_county_ml_view": (
        "test_county_ml_id",
        "number",
        "identifier",
        "test_county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "person_promotional_message_view": (
        "person_promotional_message_id",
        "name",
        "person_id",
        "sql_where",
        "promotional_message_id",
        "message_template_id",
        "criteria_set_id",
        "priority",
        "dialog_workflow_state_id",
        "join_group_list_id_if_choosen",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "person_promotional_message_table": (
        "person_promotional_message_id",
        "name",
        "person_id",
        "sql_where",
        "criteria_set_id",
        "promotional_message_id",
        "question_id",
        "message_template_id",
        "priority",
        "dialog_workflow_script_id",
        "dialog_workflow_state_id",
        "join_group_list_id_if_choosen",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "subscription_costs_view": (
        "subscription_id",
        "subsctiption.name",
        "action_id",
        "action.name",
        "action.is_messaging",
        "hard_limit_value",
        "price_per_unit",
        "hard_limit_value*price_per_unit"
    ),
    "newsletter_table": (
        "newsletter_id",
        "name",
        "system_id",
        "owner_profile_id",
        "owner_profile_name_temp",
        "url_id",
        "url_temp",
        "duration",
        "root_message_id"
    ),
    "advertisement_table": (
        "advertisement_id",
        "seller_id",
        "is_actionable"
    ),
    "advertisement_campaign_table": (
        "advertisement_campaign_id",
        "advertisement_id",
        "campaign_id"
    ),
    "advertisement_storage_table": (
        "advertisement_storage_id",
        "advertisement_id",
        "storge_id",
        "is_actionable",
        "html_map_tag"
    ),
    "coupon_table": (
        "coupon_id",
        "name",
        "from.profile_id",
        "event_id",
        "quantity",
        "number",
        "identifier"
    ),
    "event_participant_table": (
        "event_participant_id",
        "event_id",
        "participant_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "brand_event_table": (
        "brand_event_id",
        "brand_id",
        "event_id"
    ),
    "event_sponsor_table": (
        "event_sponsor_id",
        "event_id",
        "sponsor_profile_id",
        "event_sponsorship_type"
    ),
    "test_typeorm_table": (
        "test_typeorm_id",
        "unique_int_column",
        "new_test_typeorm_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "action_table": (
        "action_id",
        "name",
        "description",
        "is_queue_action",
        "is_smartlink_action",
        "package_name",
        "function_name",
        "function_module",
        "folder_name",
        "filename",
        "source_system_id",
        "destination_system_id",
        "destination_subsystem_id",
        "expiration_unit",
        "expiration_value",
        "dialog_workflow_script_id",
        "is_messaging",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "event_ml_table": (
        "event_ml_id",
        "number",
        "identifier",
        "event_id",
        "lang_code",
        "is_main_title",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "event_event_table": (
        "event_event_id",
        "event_id1",
        "event_id2",
        "relationship_type_id",
        "action_id",
        "is_move_everything_from_event1_to_event2",
        "is_main"
    ),
    "event_event_category_table": (
        "event_event_category_id",
        "event_id",
        "event_category_id"
    ),
    "event_category_table": (
        "event_category_id",
        "name",
        "event_type_id",
        "is_hierarchy",
        "is_prioritze",
        "is_location",
        "is_organization",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "event_category_ml_table": (
        "event_category_ml_id",
        "event_category_id",
        "lang_code",
        "title",
        "is_main_title",
        "description",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "event_type_table": (
        "event_type_id",
        "name",
        "is_location",
        "is_organization",
        "is_gender",
        "is_job_title",
        "is_organization_classification",
        "is_contact_classification",
        "examples_old"
    ),
    "event_type_ml_table": (
        "event_type_ml_id",
        "event_type_id",
        "lang_code",
        "title"
    ),
    "event_event_type_table": (
        "event_event_type_id",
        "event_id",
        "event_type_id"
    ),
    "event_general_test_data_view_temp": (
        "event_id",
        "event.name",
        "event.is_test_data",
        "new_event_id",
        "event.end_timestamp",
        "event_ml_id",
        "lang_code",
        "title",
        "is_main_title",
        "event_ml.is_test_data",
        "event_ml.end_timestamp",
        "event_category_title",
        "event_type_name",
        "is_location",
        "is_contact_classification",
        "event_id1 (parent)",
        "event_id2 (child)"
    ),
    "group_ml_table": (
        "group_ml_id",
        "number",
        "identifier",
        "group_id",
        "lang_code",
        "title",
        "is_main_title",
        "is_title_approved",
        "description",
        "is_description_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "event_number_of_main_title_per_event_and_language_review_view": (
        "event_ml_id",
        "title",
        "is_main_title"
    ),
    "group_number_of_main_title_per_group_and_language_review_view": (
        "group_ml_id",
        "title",
        "is_main_title"
    ),
    "platform_invitation_view": (
        "platform_invitation_id",
        "number",
        "identifier",
        "from_profile_id",
        "to_profile_id",
        "to_contact_id",
        "to_email_address",
        "to_email_address_id",
        "to_phone_number",
        "to_phone_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "queue_status_id",
        "action_id",
        "process_id",
        "user_jwt"
    ),
    "group_table": (
        "group_id",
        "number",
        "identifier",
        "name",
        "system_group_name",
        "hashtag",
        "parent_group_id",
        "parent_group_list_id",
        "is_group_approved",
        "non_members_visibility_id",
        "members_visibility_id",
        "sequence",
        "is_interest",
        "is_job_title",
        "is_role",
        "is_skill",
        "is_organization",
        "is_geo",
        "is_continent",
        "is_country",
        "is_state",
        "is_county",
        "is_region",
        "is_city",
        "is_neighbourhood",
        "is_street",
        "is_zip_code",
        "is_building",
        "is_relationship",
        "is_marital_status",
        "is_official",
        "is_first_name",
        "is_last_name",
        "is_campaign",
        "is_activity",
        "is_sport",
        "is_language",
        "location_id",
        "location_list_id",
        "coordinate",
        "group_category_id",
        "system_id",
        "profile_id",
        "main_group_type_id",
        "is_reddit_group",
        "is_event",
        "is_religion",
        "event_id",
        "profile_list_id",
        "new_group_id",
        "is_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "created_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_community"
    ),
    "group_group_type_general_view": (
        "group_group_type_id",
        "group_id",
        "group_group_type.end_timestamp",
        "group_group_type.is_test_data",
        "group_type_id",
        "group.name",
        "group_type.name",
        "title"
    ),
    "event_profile_view": (
        "event_profile_id",
        "number",
        "identifier",
        "event_id",
        "old_event_id",
        "from_profile_id",
        "to_invited_profile_id",
        "to_registered_profile_id",
        "coupon_id",
        "event_profile_type",
        "is_invited",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_user_filled_registration",
        "is_gave_payment_method",
        "is_not_interested",
        "is_approved_by_admin",
        "is_will_not_arrive",
        "is_checked_in",
        "is_can_be_paid_at_the_entrance_in_cash",
        "is_charged",
        "is_will_arrive",
        "is_tentative",
        "is_join_virtually",
        "rank",
        "event_price_id",
        "qrcode_storage_id",
        "is_admin",
        "is_checkin_checker"
    ),
    "event_profile_general_view": (
        "event_id",
        "event.name",
        "old_event_id",
        "old_event.name",
        "event_profile_id",
        "to_registered_profile.profile_id",
        "to_registered_profile.name"
    ),
    "event_profile_type_table": (
        "event_profile_type_id",
        "number",
        "identifier",
        "group_type_id",
        "is_hierarchy",
        "is_prioritze",
        "is_location",
        "is_organization",
        "is_include_logo",
        "is_marketing_partner",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "group_group_type_table": (
        "group_group_type_id",
        "number",
        "identifier",
        "group_id",
        "group_type_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "event_price_view": (
        "event_price_id",
        "event_id",
        "price",
        "coupon_id",
        "currency",
        "price_usd",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "event_price_number",
        "event_price_identifier",
        "is_test_data"
    ),
    "subscription_user_profile_action_limit_table": (
        "subscription_profile_action_limit_id",
        "subscription_id",
        "profile_id",
        "action_id",
        "limit_unit",
        "soft_limit_value",
        "hard_limit_value",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "event_price_table": (
        "event_price_id",
        "event_id",
        "price",
        "coupon_id",
        "currency",
        "price_usd",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "event_price_number",
        "event_price_identifier",
        "is_test_data"
    ),
    "age_group_group_view": (
        "age_group_group_id",
        "age_group_id",
        "sequence",
        "group_id"
    ),
    "event_profile_table": (
        "event_profile_id",
        "number",
        "identifier",
        "event_id",
        "old_event_id",
        "from_profile_id",
        "to_invited_profile_id",
        "to_registered_profile_id",
        "coupon_id",
        "event_profile_type",
        "is_invited",
        "is_user_filled_registration",
        "event_price_id",
        "is_gave_payment_method",
        "is_not_interested",
        "is_approved_by_admin",
        "qrcode_storage_id",
        "is_will_not_arrive",
        "is_checked_in",
        "is_can_be_paid_at_the_entrance_in_cash",
        "is_charged",
        "is_will_arrive",
        "is_tentative",
        "is_join_virtually",
        "rank",
        "is_admin",
        "is_promoter",
        "is_checkin_checker",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "payment_request_table": (
        "payment_request_id",
        "from_profile_id",
        "to_profile_id",
        "amount",
        "payment_due_timestamp",
        "payment_url",
        "payment_category",
        "first_reminder_timestmap",
        "last_reminder_timestamp",
        "remark"
    ),
    "message_payment_request_table": (
        "message_payment_request_id",
        "message_id",
        "payment_request_id"
    ),
    "invoice_payment_request_table": (
        "invoice_payment_request_id",
        "invoice_id",
        "payment_request_id"
    ),
    "actual_payment_table": (
        "actual_payment_id",
        "timestamp",
        "price_id",
        "payment_method_id"
    ),
    "actual_payment_payment_request_table": (
        "actual_payment_payment_request_id",
        "actual_payment_id",
        "payment_request_id",
        "price_id"
    ),
    "payment_requst_text_block_table": (
        "payment_requst_text_block_id",
        "payment_request_id",
        "text_block_id"
    ),
    "action_item_payment_request_table": (
        "action_item_payment_request_id",
        "action_item_id",
        "payment_request_id"
    ),
    "user_external_pii_view": (
        "user_external_id",
        "number",
        "identifier",
        "password_clear_text",
        "password_encrypted",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "user_external_pii_general_view": (
        "user_external_id",
        "system_id",
        "main_profile_id",
        "username",
        "password_clear_text"
    ),
    "payment_terms_service_offer_table": (
        "payment_terms_service_offer_id",
        "payment_terms_id",
        "service_offer_id"
    ),
    "marketplace_payment_terms_table": (
        "marketplace_payment_terms_id",
        "down_payment_percentage",
        "downpayment"
    ),
    "group_profile_table": (
        "group_profile_id",
        "group_id",
        "profile_id",
        "relationship_type_id",
        "is_sure",
        "group_profile_type_id",
        "supplier_category_id",
        "consumer_category_id",
        "participant_category_id",
        "months",
        "start_timestamp",
        "start_date_day",
        "start_date_month",
        "start_date_year",
        "start_circa",
        "end_timestamp",
        "end_date_day",
        "end_date_month",
        "end_date_year",
        "end_circa",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "number",
        "identifier",
        "is_test_data",
        "rank",
        "text_block_id",
        "is_recommended",
        "is_request_by_the_user",
        "is_approved_by_group_admin",
        "is_admin",
        "is_moderator",
        "transaction_fee_percentage",
        "transaction_fee_amount"
    ),
    "service_transaction_table": (
        "service_transaction_id",
        "name",
        "group_profile_id",
        "price_id",
        "is_paid",
        "description"
    ),
    "service_order_table": (
        "id",
        "service_receiver_id",
        "service_provider_id",
        "service_offer_id",
        "price",
        "currency_id",
        "location_id",
        "order_time",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "group_supplier_id"
    ),
    "group_seller_table": (
        "group_seller_id",
        "group_id",
        "seller_id",
        "relationship_type_id",
        "is_sure",
        "group_profile_type_id",
        "seller_category_id",
        "consumer_category_id",
        "participant_category_id",
        "months",
        "number",
        "identifier",
        "is_test_data",
        "rank",
        "text_block_id",
        "is_recommended",
        "is_request_by_the_user",
        "is_approved_by_group_admin",
        "is_admin",
        "is_moderator",
        "transaction_fee_percentage",
        "transaction_fee_amount",
        "start_timestamp",
        "start_date_day",
        "start_date_month",
        "start_date_year",
        "start_circa",
        "end_timestamp",
        "end_date_day",
        "end_date_month",
        "end_date_year",
        "end_circa",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "service_transaction_transaction_benfit_table": (
        "benfit_service_transaction_id",
        "transaction_benefit_id",
        "service_transaction_id",
        "name"
    ),
    "goods_provider_table": (
        "id",
        "profile_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "transaction_benefit_table": (
        "transaction_benefit_id",
        "name",
        "service_offer_id",
        "goods_offer_id"
    ),
    "service_offer_table": (
        "service_offer_id",
        "service_provider_id",
        "service_seller_id",
        "service_id",
        "experience",
        "reaction_id",
        "reaction_value",
        "price_id",
        "base_price",
        "main_currency_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "price_set_table": (
        "price_set_id",
        "is_all_currencies"
    ),
    "currency_table": (
        "currency_id",
        "code",
        "is_digital_currency",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "digital_currency_table": (
        "digital_currency_id",
        "name"
    ),
    "service_messaging_general_view": (
        "service_messaging_id",
        "action_id",
        "action.name",
        "system_id",
        "system.name",
        "price_per_unit",
        "unit_name",
        "pricing_url_temp",
        "seller_id",
        "name",
        "profile_id"
    ),
    "service_messaging_table": (
        "service_messaging_id",
        "action_id",
        "to_country_id",
        "max_number_of_characters",
        "seller_id",
        "system_id",
        "quantity",
        "price_per_unit",
        "unit_name",
        "pricing_url_temp",
        "description"
    ),
    "profile_user_external_general_view": (
        "profile_id",
        "user_external_id",
        "system_id",
        "password_clear_text"
    ),
    "group.group_group_category_view": (
        "group_category_id",
        "name",
        "group_type_id",
        "is_hierarchy",
        "is_prioritze",
        "is_location",
        "is_organization",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "group_group.group_group_view": (
        "group_group_id",
        "group_id1",
        "group_id2",
        "relationship_type_id",
        "action_id",
        "is_move_everything_from_group1_to_group2",
        "is_main"
    ),
    "activity_group_location_occurrence_profile_view": (
        "activity_group_location_occurrence_profile_id",
        "activity_id",
        "activity_list_id",
        "group_id",
        "group_list_id",
        "location_id",
        "location_list_id",
        "occurrence_id",
        "occurrence_list_id",
        "profile_id",
        "profile_list_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "group_group_view": (
        "group_group_id",
        "group_id1",
        "group_id2",
        "relationship_type_id",
        "action_id",
        "is_move_everything_from_group1_to_group2",
        "is_main"
    ),
    "job_title_profile_general_view": (
        "job_title_id",
        "job_title.name",
        "profile_id",
        "profile.name"
    ),
    "profile_profile_general_view": (
        "profile_id1",
        "profile1.name",
        "profile_id2",
        "profile2.name",
        "relationship_type_id",
        "relationship_type.name",
        "party1_for_party2_title",
        "job_title",
        "job_title_id",
        "job_title_ml.title"
    ),
    "component_test_table": (
        "component_test_id",
        "component_id",
        "name",
        "test_type_id",
        "test_type_name_temp"
    ),
    "cond_instances": (
        "NAME",
        "OBJECT_INSTANCE_BEGIN"
    ),
    "error_log": (
        "LOGGED",
        "THREAD_ID",
        "PRIO",
        "ERROR_CODE",
        "SUBSYSTEM",
        "DATA"
    ),
    "events_waits_current": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "SPINS",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "INDEX_NAME",
        "OBJECT_TYPE",
        "OBJECT_INSTANCE_BEGIN",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE",
        "OPERATION",
        "NUMBER_OF_BYTES",
        "FLAGS"
    ),
    "events_waits_history": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "SPINS",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "INDEX_NAME",
        "OBJECT_TYPE",
        "OBJECT_INSTANCE_BEGIN",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE",
        "OPERATION",
        "NUMBER_OF_BYTES",
        "FLAGS"
    ),
    "events_waits_history_long": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "SPINS",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "INDEX_NAME",
        "OBJECT_TYPE",
        "OBJECT_INSTANCE_BEGIN",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE",
        "OPERATION",
        "NUMBER_OF_BYTES",
        "FLAGS"
    ),
    "events_waits_summary_by_host_by_event_name": (
        "HOST",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_waits_summary_by_instance": (
        "EVENT_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_waits_summary_by_thread_by_event_name": (
        "THREAD_ID",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_waits_summary_by_user_by_event_name": (
        "USER",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_waits_summary_by_account_by_event_name": (
        "USER",
        "HOST",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_waits_summary_global_by_event_name": (
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "file_instances": (
        "FILE_NAME",
        "EVENT_NAME",
        "OPEN_COUNT"
    ),
    "file_summary_by_event_name": (
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ",
        "SUM_TIMER_READ",
        "MIN_TIMER_READ",
        "AVG_TIMER_READ",
        "MAX_TIMER_READ",
        "SUM_NUMBER_OF_BYTES_READ",
        "COUNT_WRITE",
        "SUM_TIMER_WRITE",
        "MIN_TIMER_WRITE",
        "AVG_TIMER_WRITE",
        "MAX_TIMER_WRITE",
        "SUM_NUMBER_OF_BYTES_WRITE",
        "COUNT_MISC",
        "SUM_TIMER_MISC",
        "MIN_TIMER_MISC",
        "AVG_TIMER_MISC",
        "MAX_TIMER_MISC"
    ),
    "file_summary_by_instance": (
        "FILE_NAME",
        "EVENT_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ",
        "SUM_TIMER_READ",
        "MIN_TIMER_READ",
        "AVG_TIMER_READ",
        "MAX_TIMER_READ",
        "SUM_NUMBER_OF_BYTES_READ",
        "COUNT_WRITE",
        "SUM_TIMER_WRITE",
        "MIN_TIMER_WRITE",
        "AVG_TIMER_WRITE",
        "MAX_TIMER_WRITE",
        "SUM_NUMBER_OF_BYTES_WRITE",
        "COUNT_MISC",
        "SUM_TIMER_MISC",
        "MIN_TIMER_MISC",
        "AVG_TIMER_MISC",
        "MAX_TIMER_MISC"
    ),
    "host_cache": (
        "IP",
        "HOST",
        "HOST_VALIDATED",
        "SUM_CONNECT_ERRORS",
        "COUNT_HOST_BLOCKED_ERRORS",
        "COUNT_NAMEINFO_TRANSIENT_ERRORS",
        "COUNT_NAMEINFO_PERMANENT_ERRORS",
        "COUNT_FORMAT_ERRORS",
        "COUNT_ADDRINFO_TRANSIENT_ERRORS",
        "COUNT_ADDRINFO_PERMANENT_ERRORS",
        "COUNT_FCRDNS_ERRORS",
        "COUNT_HOST_ACL_ERRORS",
        "COUNT_NO_AUTH_PLUGIN_ERRORS",
        "COUNT_AUTH_PLUGIN_ERRORS",
        "COUNT_HANDSHAKE_ERRORS",
        "COUNT_PROXY_USER_ERRORS",
        "COUNT_PROXY_USER_ACL_ERRORS",
        "COUNT_AUTHENTICATION_ERRORS",
        "COUNT_SSL_ERRORS",
        "COUNT_MAX_USER_CONNECTIONS_ERRORS",
        "COUNT_MAX_USER_CONNECTIONS_PER_HOUR_ERRORS",
        "COUNT_DEFAULT_DATABASE_ERRORS",
        "COUNT_INIT_CONNECT_ERRORS",
        "COUNT_LOCAL_ERRORS",
        "COUNT_UNKNOWN_ERRORS",
        "FIRST_SEEN",
        "LAST_SEEN",
        "FIRST_ERROR_SEEN",
        "LAST_ERROR_SEEN"
    ),
    "mutex_instances": (
        "NAME",
        "OBJECT_INSTANCE_BEGIN",
        "LOCKED_BY_THREAD_ID"
    ),
    "objects_summary_global_by_type": (
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "performance_timers": (
        "TIMER_NAME",
        "TIMER_FREQUENCY",
        "TIMER_RESOLUTION",
        "TIMER_OVERHEAD"
    ),
    "rwlock_instances": (
        "NAME",
        "OBJECT_INSTANCE_BEGIN",
        "WRITE_LOCKED_BY_THREAD_ID",
        "READ_LOCKED_BY_COUNT"
    ),
    "setup_actors": (
        "HOST",
        "USER",
        "ROLE",
        "ENABLED",
        "HISTORY"
    ),
    "setup_consumers": (
        "NAME",
        "ENABLED"
    ),
    "setup_instruments": (
        "NAME",
        "ENABLED",
        "TIMED",
        "PROPERTIES",
        "FLAGS",
        "VOLATILITY",
        "DOCUMENTATION"
    ),
    "setup_objects": (
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "ENABLED",
        "TIMED"
    ),
    "setup_threads": (
        "NAME",
        "ENABLED",
        "HISTORY",
        "PROPERTIES",
        "VOLATILITY",
        "DOCUMENTATION"
    ),
    "table_io_waits_summary_by_index_usage": (
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "INDEX_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ",
        "SUM_TIMER_READ",
        "MIN_TIMER_READ",
        "AVG_TIMER_READ",
        "MAX_TIMER_READ",
        "COUNT_WRITE",
        "SUM_TIMER_WRITE",
        "MIN_TIMER_WRITE",
        "AVG_TIMER_WRITE",
        "MAX_TIMER_WRITE",
        "COUNT_FETCH",
        "SUM_TIMER_FETCH",
        "MIN_TIMER_FETCH",
        "AVG_TIMER_FETCH",
        "MAX_TIMER_FETCH",
        "COUNT_INSERT",
        "SUM_TIMER_INSERT",
        "MIN_TIMER_INSERT",
        "AVG_TIMER_INSERT",
        "MAX_TIMER_INSERT",
        "COUNT_UPDATE",
        "SUM_TIMER_UPDATE",
        "MIN_TIMER_UPDATE",
        "AVG_TIMER_UPDATE",
        "MAX_TIMER_UPDATE",
        "COUNT_DELETE",
        "SUM_TIMER_DELETE",
        "MIN_TIMER_DELETE",
        "AVG_TIMER_DELETE",
        "MAX_TIMER_DELETE"
    ),
    "table_io_waits_summary_by_table": (
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ",
        "SUM_TIMER_READ",
        "MIN_TIMER_READ",
        "AVG_TIMER_READ",
        "MAX_TIMER_READ",
        "COUNT_WRITE",
        "SUM_TIMER_WRITE",
        "MIN_TIMER_WRITE",
        "AVG_TIMER_WRITE",
        "MAX_TIMER_WRITE",
        "COUNT_FETCH",
        "SUM_TIMER_FETCH",
        "MIN_TIMER_FETCH",
        "AVG_TIMER_FETCH",
        "MAX_TIMER_FETCH",
        "COUNT_INSERT",
        "SUM_TIMER_INSERT",
        "MIN_TIMER_INSERT",
        "AVG_TIMER_INSERT",
        "MAX_TIMER_INSERT",
        "COUNT_UPDATE",
        "SUM_TIMER_UPDATE",
        "MIN_TIMER_UPDATE",
        "AVG_TIMER_UPDATE",
        "MAX_TIMER_UPDATE",
        "COUNT_DELETE",
        "SUM_TIMER_DELETE",
        "MIN_TIMER_DELETE",
        "AVG_TIMER_DELETE",
        "MAX_TIMER_DELETE"
    ),
    "table_lock_waits_summary_by_table": (
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ",
        "SUM_TIMER_READ",
        "MIN_TIMER_READ",
        "AVG_TIMER_READ",
        "MAX_TIMER_READ",
        "COUNT_WRITE",
        "SUM_TIMER_WRITE",
        "MIN_TIMER_WRITE",
        "AVG_TIMER_WRITE",
        "MAX_TIMER_WRITE",
        "COUNT_READ_NORMAL",
        "SUM_TIMER_READ_NORMAL",
        "MIN_TIMER_READ_NORMAL",
        "AVG_TIMER_READ_NORMAL",
        "MAX_TIMER_READ_NORMAL",
        "COUNT_READ_WITH_SHARED_LOCKS",
        "SUM_TIMER_READ_WITH_SHARED_LOCKS",
        "MIN_TIMER_READ_WITH_SHARED_LOCKS",
        "AVG_TIMER_READ_WITH_SHARED_LOCKS",
        "MAX_TIMER_READ_WITH_SHARED_LOCKS",
        "COUNT_READ_HIGH_PRIORITY",
        "SUM_TIMER_READ_HIGH_PRIORITY",
        "MIN_TIMER_READ_HIGH_PRIORITY",
        "AVG_TIMER_READ_HIGH_PRIORITY",
        "MAX_TIMER_READ_HIGH_PRIORITY",
        "COUNT_READ_NO_INSERT",
        "SUM_TIMER_READ_NO_INSERT",
        "MIN_TIMER_READ_NO_INSERT",
        "AVG_TIMER_READ_NO_INSERT",
        "MAX_TIMER_READ_NO_INSERT",
        "COUNT_READ_EXTERNAL",
        "SUM_TIMER_READ_EXTERNAL",
        "MIN_TIMER_READ_EXTERNAL",
        "AVG_TIMER_READ_EXTERNAL",
        "MAX_TIMER_READ_EXTERNAL",
        "COUNT_WRITE_ALLOW_WRITE",
        "SUM_TIMER_WRITE_ALLOW_WRITE",
        "MIN_TIMER_WRITE_ALLOW_WRITE",
        "AVG_TIMER_WRITE_ALLOW_WRITE",
        "MAX_TIMER_WRITE_ALLOW_WRITE",
        "COUNT_WRITE_CONCURRENT_INSERT",
        "SUM_TIMER_WRITE_CONCURRENT_INSERT",
        "MIN_TIMER_WRITE_CONCURRENT_INSERT",
        "AVG_TIMER_WRITE_CONCURRENT_INSERT",
        "MAX_TIMER_WRITE_CONCURRENT_INSERT",
        "COUNT_WRITE_LOW_PRIORITY",
        "SUM_TIMER_WRITE_LOW_PRIORITY",
        "MIN_TIMER_WRITE_LOW_PRIORITY",
        "AVG_TIMER_WRITE_LOW_PRIORITY",
        "MAX_TIMER_WRITE_LOW_PRIORITY",
        "COUNT_WRITE_NORMAL",
        "SUM_TIMER_WRITE_NORMAL",
        "MIN_TIMER_WRITE_NORMAL",
        "AVG_TIMER_WRITE_NORMAL",
        "MAX_TIMER_WRITE_NORMAL",
        "COUNT_WRITE_EXTERNAL",
        "SUM_TIMER_WRITE_EXTERNAL",
        "MIN_TIMER_WRITE_EXTERNAL",
        "AVG_TIMER_WRITE_EXTERNAL",
        "MAX_TIMER_WRITE_EXTERNAL"
    ),
    "threads": (
        "THREAD_ID",
        "NAME",
        "TYPE",
        "PROCESSLIST_ID",
        "PROCESSLIST_USER",
        "PROCESSLIST_HOST",
        "PROCESSLIST_DB",
        "PROCESSLIST_COMMAND",
        "PROCESSLIST_TIME",
        "PROCESSLIST_STATE",
        "PROCESSLIST_INFO",
        "PARENT_THREAD_ID",
        "ROLE",
        "INSTRUMENTED",
        "HISTORY",
        "CONNECTION_TYPE",
        "THREAD_OS_ID",
        "RESOURCE_GROUP",
        "EXECUTION_ENGINE",
        "CONTROLLED_MEMORY",
        "MAX_CONTROLLED_MEMORY",
        "TOTAL_MEMORY",
        "MAX_TOTAL_MEMORY"
    ),
    "events_stages_current": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "WORK_COMPLETED",
        "WORK_ESTIMATED",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE"
    ),
    "events_stages_history": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "WORK_COMPLETED",
        "WORK_ESTIMATED",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE"
    ),
    "events_stages_history_long": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "WORK_COMPLETED",
        "WORK_ESTIMATED",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE"
    ),
    "events_stages_summary_by_thread_by_event_name": (
        "THREAD_ID",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_stages_summary_by_account_by_event_name": (
        "USER",
        "HOST",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_stages_summary_by_user_by_event_name": (
        "USER",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_stages_summary_by_host_by_event_name": (
        "HOST",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_stages_summary_global_by_event_name": (
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT"
    ),
    "events_statements_current": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "LOCK_TIME",
        "SQL_TEXT",
        "DIGEST",
        "DIGEST_TEXT",
        "CURRENT_SCHEMA",
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "MYSQL_ERRNO",
        "RETURNED_SQLSTATE",
        "MESSAGE_TEXT",
        "ERRORS",
        "WARNINGS",
        "ROWS_AFFECTED",
        "ROWS_SENT",
        "ROWS_EXAMINED",
        "CREATED_TMP_DISK_TABLES",
        "CREATED_TMP_TABLES",
        "SELECT_FULL_JOIN",
        "SELECT_FULL_RANGE_JOIN",
        "SELECT_RANGE",
        "SELECT_RANGE_CHECK",
        "SELECT_SCAN",
        "SORT_MERGE_PASSES",
        "SORT_RANGE",
        "SORT_ROWS",
        "SORT_SCAN",
        "NO_INDEX_USED",
        "NO_GOOD_INDEX_USED",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE",
        "NESTING_EVENT_LEVEL",
        "STATEMENT_ID",
        "CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "EXECUTION_ENGINE"
    ),
    "events_statements_history": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "LOCK_TIME",
        "SQL_TEXT",
        "DIGEST",
        "DIGEST_TEXT",
        "CURRENT_SCHEMA",
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "MYSQL_ERRNO",
        "RETURNED_SQLSTATE",
        "MESSAGE_TEXT",
        "ERRORS",
        "WARNINGS",
        "ROWS_AFFECTED",
        "ROWS_SENT",
        "ROWS_EXAMINED",
        "CREATED_TMP_DISK_TABLES",
        "CREATED_TMP_TABLES",
        "SELECT_FULL_JOIN",
        "SELECT_FULL_RANGE_JOIN",
        "SELECT_RANGE",
        "SELECT_RANGE_CHECK",
        "SELECT_SCAN",
        "SORT_MERGE_PASSES",
        "SORT_RANGE",
        "SORT_ROWS",
        "SORT_SCAN",
        "NO_INDEX_USED",
        "NO_GOOD_INDEX_USED",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE",
        "NESTING_EVENT_LEVEL",
        "STATEMENT_ID",
        "CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "EXECUTION_ENGINE"
    ),
    "events_statements_history_long": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "LOCK_TIME",
        "SQL_TEXT",
        "DIGEST",
        "DIGEST_TEXT",
        "CURRENT_SCHEMA",
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "MYSQL_ERRNO",
        "RETURNED_SQLSTATE",
        "MESSAGE_TEXT",
        "ERRORS",
        "WARNINGS",
        "ROWS_AFFECTED",
        "ROWS_SENT",
        "ROWS_EXAMINED",
        "CREATED_TMP_DISK_TABLES",
        "CREATED_TMP_TABLES",
        "SELECT_FULL_JOIN",
        "SELECT_FULL_RANGE_JOIN",
        "SELECT_RANGE",
        "SELECT_RANGE_CHECK",
        "SELECT_SCAN",
        "SORT_MERGE_PASSES",
        "SORT_RANGE",
        "SORT_ROWS",
        "SORT_SCAN",
        "NO_INDEX_USED",
        "NO_GOOD_INDEX_USED",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE",
        "NESTING_EVENT_LEVEL",
        "STATEMENT_ID",
        "CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "EXECUTION_ENGINE"
    ),
    "events_statements_summary_by_thread_by_event_name": (
        "THREAD_ID",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "SUM_LOCK_TIME",
        "SUM_ERRORS",
        "SUM_WARNINGS",
        "SUM_ROWS_AFFECTED",
        "SUM_ROWS_SENT",
        "SUM_ROWS_EXAMINED",
        "SUM_CREATED_TMP_DISK_TABLES",
        "SUM_CREATED_TMP_TABLES",
        "SUM_SELECT_FULL_JOIN",
        "SUM_SELECT_FULL_RANGE_JOIN",
        "SUM_SELECT_RANGE",
        "SUM_SELECT_RANGE_CHECK",
        "SUM_SELECT_SCAN",
        "SUM_SORT_MERGE_PASSES",
        "SUM_SORT_RANGE",
        "SUM_SORT_ROWS",
        "SUM_SORT_SCAN",
        "SUM_NO_INDEX_USED",
        "SUM_NO_GOOD_INDEX_USED",
        "SUM_CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "COUNT_SECONDARY"
    ),
    "events_statements_summary_by_account_by_event_name": (
        "USER",
        "HOST",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "SUM_LOCK_TIME",
        "SUM_ERRORS",
        "SUM_WARNINGS",
        "SUM_ROWS_AFFECTED",
        "SUM_ROWS_SENT",
        "SUM_ROWS_EXAMINED",
        "SUM_CREATED_TMP_DISK_TABLES",
        "SUM_CREATED_TMP_TABLES",
        "SUM_SELECT_FULL_JOIN",
        "SUM_SELECT_FULL_RANGE_JOIN",
        "SUM_SELECT_RANGE",
        "SUM_SELECT_RANGE_CHECK",
        "SUM_SELECT_SCAN",
        "SUM_SORT_MERGE_PASSES",
        "SUM_SORT_RANGE",
        "SUM_SORT_ROWS",
        "SUM_SORT_SCAN",
        "SUM_NO_INDEX_USED",
        "SUM_NO_GOOD_INDEX_USED",
        "SUM_CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "COUNT_SECONDARY"
    ),
    "events_statements_summary_by_user_by_event_name": (
        "USER",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "SUM_LOCK_TIME",
        "SUM_ERRORS",
        "SUM_WARNINGS",
        "SUM_ROWS_AFFECTED",
        "SUM_ROWS_SENT",
        "SUM_ROWS_EXAMINED",
        "SUM_CREATED_TMP_DISK_TABLES",
        "SUM_CREATED_TMP_TABLES",
        "SUM_SELECT_FULL_JOIN",
        "SUM_SELECT_FULL_RANGE_JOIN",
        "SUM_SELECT_RANGE",
        "SUM_SELECT_RANGE_CHECK",
        "SUM_SELECT_SCAN",
        "SUM_SORT_MERGE_PASSES",
        "SUM_SORT_RANGE",
        "SUM_SORT_ROWS",
        "SUM_SORT_SCAN",
        "SUM_NO_INDEX_USED",
        "SUM_NO_GOOD_INDEX_USED",
        "SUM_CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "COUNT_SECONDARY"
    ),
    "events_statements_summary_by_host_by_event_name": (
        "HOST",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "SUM_LOCK_TIME",
        "SUM_ERRORS",
        "SUM_WARNINGS",
        "SUM_ROWS_AFFECTED",
        "SUM_ROWS_SENT",
        "SUM_ROWS_EXAMINED",
        "SUM_CREATED_TMP_DISK_TABLES",
        "SUM_CREATED_TMP_TABLES",
        "SUM_SELECT_FULL_JOIN",
        "SUM_SELECT_FULL_RANGE_JOIN",
        "SUM_SELECT_RANGE",
        "SUM_SELECT_RANGE_CHECK",
        "SUM_SELECT_SCAN",
        "SUM_SORT_MERGE_PASSES",
        "SUM_SORT_RANGE",
        "SUM_SORT_ROWS",
        "SUM_SORT_SCAN",
        "SUM_NO_INDEX_USED",
        "SUM_NO_GOOD_INDEX_USED",
        "SUM_CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "COUNT_SECONDARY"
    ),
    "events_statements_summary_global_by_event_name": (
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "SUM_LOCK_TIME",
        "SUM_ERRORS",
        "SUM_WARNINGS",
        "SUM_ROWS_AFFECTED",
        "SUM_ROWS_SENT",
        "SUM_ROWS_EXAMINED",
        "SUM_CREATED_TMP_DISK_TABLES",
        "SUM_CREATED_TMP_TABLES",
        "SUM_SELECT_FULL_JOIN",
        "SUM_SELECT_FULL_RANGE_JOIN",
        "SUM_SELECT_RANGE",
        "SUM_SELECT_RANGE_CHECK",
        "SUM_SELECT_SCAN",
        "SUM_SORT_MERGE_PASSES",
        "SUM_SORT_RANGE",
        "SUM_SORT_ROWS",
        "SUM_SORT_SCAN",
        "SUM_NO_INDEX_USED",
        "SUM_NO_GOOD_INDEX_USED",
        "SUM_CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "COUNT_SECONDARY"
    ),
    "events_statements_summary_by_digest": (
        "SCHEMA_NAME",
        "DIGEST",
        "DIGEST_TEXT",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "SUM_LOCK_TIME",
        "SUM_ERRORS",
        "SUM_WARNINGS",
        "SUM_ROWS_AFFECTED",
        "SUM_ROWS_SENT",
        "SUM_ROWS_EXAMINED",
        "SUM_CREATED_TMP_DISK_TABLES",
        "SUM_CREATED_TMP_TABLES",
        "SUM_SELECT_FULL_JOIN",
        "SUM_SELECT_FULL_RANGE_JOIN",
        "SUM_SELECT_RANGE",
        "SUM_SELECT_RANGE_CHECK",
        "SUM_SELECT_SCAN",
        "SUM_SORT_MERGE_PASSES",
        "SUM_SORT_RANGE",
        "SUM_SORT_ROWS",
        "SUM_SORT_SCAN",
        "SUM_NO_INDEX_USED",
        "SUM_NO_GOOD_INDEX_USED",
        "SUM_CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "COUNT_SECONDARY",
        "FIRST_SEEN",
        "LAST_SEEN",
        "QUANTILE_95",
        "QUANTILE_99",
        "QUANTILE_999",
        "QUERY_SAMPLE_TEXT",
        "QUERY_SAMPLE_SEEN",
        "QUERY_SAMPLE_TIMER_WAIT"
    ),
    "events_statements_summary_by_program": (
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_STATEMENTS",
        "SUM_STATEMENTS_WAIT",
        "MIN_STATEMENTS_WAIT",
        "AVG_STATEMENTS_WAIT",
        "MAX_STATEMENTS_WAIT",
        "SUM_LOCK_TIME",
        "SUM_ERRORS",
        "SUM_WARNINGS",
        "SUM_ROWS_AFFECTED",
        "SUM_ROWS_SENT",
        "SUM_ROWS_EXAMINED",
        "SUM_CREATED_TMP_DISK_TABLES",
        "SUM_CREATED_TMP_TABLES",
        "SUM_SELECT_FULL_JOIN",
        "SUM_SELECT_FULL_RANGE_JOIN",
        "SUM_SELECT_RANGE",
        "SUM_SELECT_RANGE_CHECK",
        "SUM_SELECT_SCAN",
        "SUM_SORT_MERGE_PASSES",
        "SUM_SORT_RANGE",
        "SUM_SORT_ROWS",
        "SUM_SORT_SCAN",
        "SUM_NO_INDEX_USED",
        "SUM_NO_GOOD_INDEX_USED",
        "SUM_CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "COUNT_SECONDARY"
    ),
    "events_statements_histogram_global": (
        "BUCKET_NUMBER",
        "BUCKET_TIMER_LOW",
        "BUCKET_TIMER_HIGH",
        "COUNT_BUCKET",
        "COUNT_BUCKET_AND_LOWER",
        "BUCKET_QUANTILE"
    ),
    "events_statements_histogram_by_digest": (
        "SCHEMA_NAME",
        "DIGEST",
        "BUCKET_NUMBER",
        "BUCKET_TIMER_LOW",
        "BUCKET_TIMER_HIGH",
        "COUNT_BUCKET",
        "COUNT_BUCKET_AND_LOWER",
        "BUCKET_QUANTILE"
    ),
    "events_transactions_current": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "STATE",
        "TRX_ID",
        "GTID",
        "XID_FORMAT_ID",
        "XID_GTRID",
        "XID_BQUAL",
        "XA_STATE",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "ACCESS_MODE",
        "ISOLATION_LEVEL",
        "AUTOCOMMIT",
        "NUMBER_OF_SAVEPOINTS",
        "NUMBER_OF_ROLLBACK_TO_SAVEPOINT",
        "NUMBER_OF_RELEASE_SAVEPOINT",
        "OBJECT_INSTANCE_BEGIN",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE"
    ),
    "events_transactions_history": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "STATE",
        "TRX_ID",
        "GTID",
        "XID_FORMAT_ID",
        "XID_GTRID",
        "XID_BQUAL",
        "XA_STATE",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "ACCESS_MODE",
        "ISOLATION_LEVEL",
        "AUTOCOMMIT",
        "NUMBER_OF_SAVEPOINTS",
        "NUMBER_OF_ROLLBACK_TO_SAVEPOINT",
        "NUMBER_OF_RELEASE_SAVEPOINT",
        "OBJECT_INSTANCE_BEGIN",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE"
    ),
    "events_transactions_history_long": (
        "THREAD_ID",
        "EVENT_ID",
        "END_EVENT_ID",
        "EVENT_NAME",
        "STATE",
        "TRX_ID",
        "GTID",
        "XID_FORMAT_ID",
        "XID_GTRID",
        "XID_BQUAL",
        "XA_STATE",
        "SOURCE",
        "TIMER_START",
        "TIMER_END",
        "TIMER_WAIT",
        "ACCESS_MODE",
        "ISOLATION_LEVEL",
        "AUTOCOMMIT",
        "NUMBER_OF_SAVEPOINTS",
        "NUMBER_OF_ROLLBACK_TO_SAVEPOINT",
        "NUMBER_OF_RELEASE_SAVEPOINT",
        "OBJECT_INSTANCE_BEGIN",
        "NESTING_EVENT_ID",
        "NESTING_EVENT_TYPE"
    ),
    "events_transactions_summary_by_thread_by_event_name": (
        "THREAD_ID",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ_WRITE",
        "SUM_TIMER_READ_WRITE",
        "MIN_TIMER_READ_WRITE",
        "AVG_TIMER_READ_WRITE",
        "MAX_TIMER_READ_WRITE",
        "COUNT_READ_ONLY",
        "SUM_TIMER_READ_ONLY",
        "MIN_TIMER_READ_ONLY",
        "AVG_TIMER_READ_ONLY",
        "MAX_TIMER_READ_ONLY"
    ),
    "events_transactions_summary_by_account_by_event_name": (
        "USER",
        "HOST",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ_WRITE",
        "SUM_TIMER_READ_WRITE",
        "MIN_TIMER_READ_WRITE",
        "AVG_TIMER_READ_WRITE",
        "MAX_TIMER_READ_WRITE",
        "COUNT_READ_ONLY",
        "SUM_TIMER_READ_ONLY",
        "MIN_TIMER_READ_ONLY",
        "AVG_TIMER_READ_ONLY",
        "MAX_TIMER_READ_ONLY"
    ),
    "events_transactions_summary_by_user_by_event_name": (
        "USER",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ_WRITE",
        "SUM_TIMER_READ_WRITE",
        "MIN_TIMER_READ_WRITE",
        "AVG_TIMER_READ_WRITE",
        "MAX_TIMER_READ_WRITE",
        "COUNT_READ_ONLY",
        "SUM_TIMER_READ_ONLY",
        "MIN_TIMER_READ_ONLY",
        "AVG_TIMER_READ_ONLY",
        "MAX_TIMER_READ_ONLY"
    ),
    "events_transactions_summary_by_host_by_event_name": (
        "HOST",
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ_WRITE",
        "SUM_TIMER_READ_WRITE",
        "MIN_TIMER_READ_WRITE",
        "AVG_TIMER_READ_WRITE",
        "MAX_TIMER_READ_WRITE",
        "COUNT_READ_ONLY",
        "SUM_TIMER_READ_ONLY",
        "MIN_TIMER_READ_ONLY",
        "AVG_TIMER_READ_ONLY",
        "MAX_TIMER_READ_ONLY"
    ),
    "events_transactions_summary_global_by_event_name": (
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ_WRITE",
        "SUM_TIMER_READ_WRITE",
        "MIN_TIMER_READ_WRITE",
        "AVG_TIMER_READ_WRITE",
        "MAX_TIMER_READ_WRITE",
        "COUNT_READ_ONLY",
        "SUM_TIMER_READ_ONLY",
        "MIN_TIMER_READ_ONLY",
        "AVG_TIMER_READ_ONLY",
        "MAX_TIMER_READ_ONLY"
    ),
    "events_errors_summary_by_user_by_error": (
        "USER",
        "ERROR_NUMBER",
        "ERROR_NAME",
        "SQL_STATE",
        "SUM_ERROR_RAISED",
        "SUM_ERROR_HANDLED",
        "FIRST_SEEN",
        "LAST_SEEN"
    ),
    "events_errors_summary_by_host_by_error": (
        "HOST",
        "ERROR_NUMBER",
        "ERROR_NAME",
        "SQL_STATE",
        "SUM_ERROR_RAISED",
        "SUM_ERROR_HANDLED",
        "FIRST_SEEN",
        "LAST_SEEN"
    ),
    "events_errors_summary_by_account_by_error": (
        "USER",
        "HOST",
        "ERROR_NUMBER",
        "ERROR_NAME",
        "SQL_STATE",
        "SUM_ERROR_RAISED",
        "SUM_ERROR_HANDLED",
        "FIRST_SEEN",
        "LAST_SEEN"
    ),
    "events_errors_summary_by_thread_by_error": (
        "THREAD_ID",
        "ERROR_NUMBER",
        "ERROR_NAME",
        "SQL_STATE",
        "SUM_ERROR_RAISED",
        "SUM_ERROR_HANDLED",
        "FIRST_SEEN",
        "LAST_SEEN"
    ),
    "events_errors_summary_global_by_error": (
        "ERROR_NUMBER",
        "ERROR_NAME",
        "SQL_STATE",
        "SUM_ERROR_RAISED",
        "SUM_ERROR_HANDLED",
        "FIRST_SEEN",
        "LAST_SEEN"
    ),
    "users": (
        "USER",
        "CURRENT_CONNECTIONS",
        "TOTAL_CONNECTIONS",
        "MAX_SESSION_CONTROLLED_MEMORY",
        "MAX_SESSION_TOTAL_MEMORY"
    ),
    "accounts": (
        "USER",
        "HOST",
        "CURRENT_CONNECTIONS",
        "TOTAL_CONNECTIONS",
        "MAX_SESSION_CONTROLLED_MEMORY",
        "MAX_SESSION_TOTAL_MEMORY"
    ),
    "hosts": (
        "HOST",
        "CURRENT_CONNECTIONS",
        "TOTAL_CONNECTIONS",
        "MAX_SESSION_CONTROLLED_MEMORY",
        "MAX_SESSION_TOTAL_MEMORY"
    ),
    "socket_instances": (
        "EVENT_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "THREAD_ID",
        "SOCKET_ID",
        "IP",
        "PORT",
        "STATE"
    ),
    "socket_summary_by_instance": (
        "EVENT_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ",
        "SUM_TIMER_READ",
        "MIN_TIMER_READ",
        "AVG_TIMER_READ",
        "MAX_TIMER_READ",
        "SUM_NUMBER_OF_BYTES_READ",
        "COUNT_WRITE",
        "SUM_TIMER_WRITE",
        "MIN_TIMER_WRITE",
        "AVG_TIMER_WRITE",
        "MAX_TIMER_WRITE",
        "SUM_NUMBER_OF_BYTES_WRITE",
        "COUNT_MISC",
        "SUM_TIMER_MISC",
        "MIN_TIMER_MISC",
        "AVG_TIMER_MISC",
        "MAX_TIMER_MISC"
    ),
    "socket_summary_by_event_name": (
        "EVENT_NAME",
        "COUNT_STAR",
        "SUM_TIMER_WAIT",
        "MIN_TIMER_WAIT",
        "AVG_TIMER_WAIT",
        "MAX_TIMER_WAIT",
        "COUNT_READ",
        "SUM_TIMER_READ",
        "MIN_TIMER_READ",
        "AVG_TIMER_READ",
        "MAX_TIMER_READ",
        "SUM_NUMBER_OF_BYTES_READ",
        "COUNT_WRITE",
        "SUM_TIMER_WRITE",
        "MIN_TIMER_WRITE",
        "AVG_TIMER_WRITE",
        "MAX_TIMER_WRITE",
        "SUM_NUMBER_OF_BYTES_WRITE",
        "COUNT_MISC",
        "SUM_TIMER_MISC",
        "MIN_TIMER_MISC",
        "AVG_TIMER_MISC",
        "MAX_TIMER_MISC"
    ),
    "session_connect_attrs": (
        "PROCESSLIST_ID",
        "ATTR_NAME",
        "ATTR_VALUE",
        "ORDINAL_POSITION"
    ),
    "session_account_connect_attrs": (
        "PROCESSLIST_ID",
        "ATTR_NAME",
        "ATTR_VALUE",
        "ORDINAL_POSITION"
    ),
    "keyring_keys": (
        "KEY_ID",
        "KEY_OWNER",
        "BACKEND_KEY_ID"
    ),
    "memory_summary_global_by_event_name": (
        "EVENT_NAME",
        "COUNT_ALLOC",
        "COUNT_FREE",
        "SUM_NUMBER_OF_BYTES_ALLOC",
        "SUM_NUMBER_OF_BYTES_FREE",
        "LOW_COUNT_USED",
        "CURRENT_COUNT_USED",
        "HIGH_COUNT_USED",
        "LOW_NUMBER_OF_BYTES_USED",
        "CURRENT_NUMBER_OF_BYTES_USED",
        "HIGH_NUMBER_OF_BYTES_USED"
    ),
    "memory_summary_by_account_by_event_name": (
        "USER",
        "HOST",
        "EVENT_NAME",
        "COUNT_ALLOC",
        "COUNT_FREE",
        "SUM_NUMBER_OF_BYTES_ALLOC",
        "SUM_NUMBER_OF_BYTES_FREE",
        "LOW_COUNT_USED",
        "CURRENT_COUNT_USED",
        "HIGH_COUNT_USED",
        "LOW_NUMBER_OF_BYTES_USED",
        "CURRENT_NUMBER_OF_BYTES_USED",
        "HIGH_NUMBER_OF_BYTES_USED"
    ),
    "memory_summary_by_host_by_event_name": (
        "HOST",
        "EVENT_NAME",
        "COUNT_ALLOC",
        "COUNT_FREE",
        "SUM_NUMBER_OF_BYTES_ALLOC",
        "SUM_NUMBER_OF_BYTES_FREE",
        "LOW_COUNT_USED",
        "CURRENT_COUNT_USED",
        "HIGH_COUNT_USED",
        "LOW_NUMBER_OF_BYTES_USED",
        "CURRENT_NUMBER_OF_BYTES_USED",
        "HIGH_NUMBER_OF_BYTES_USED"
    ),
    "memory_summary_by_thread_by_event_name": (
        "THREAD_ID",
        "EVENT_NAME",
        "COUNT_ALLOC",
        "COUNT_FREE",
        "SUM_NUMBER_OF_BYTES_ALLOC",
        "SUM_NUMBER_OF_BYTES_FREE",
        "LOW_COUNT_USED",
        "CURRENT_COUNT_USED",
        "HIGH_COUNT_USED",
        "LOW_NUMBER_OF_BYTES_USED",
        "CURRENT_NUMBER_OF_BYTES_USED",
        "HIGH_NUMBER_OF_BYTES_USED"
    ),
    "memory_summary_by_user_by_event_name": (
        "USER",
        "EVENT_NAME",
        "COUNT_ALLOC",
        "COUNT_FREE",
        "SUM_NUMBER_OF_BYTES_ALLOC",
        "SUM_NUMBER_OF_BYTES_FREE",
        "LOW_COUNT_USED",
        "CURRENT_COUNT_USED",
        "HIGH_COUNT_USED",
        "LOW_NUMBER_OF_BYTES_USED",
        "CURRENT_NUMBER_OF_BYTES_USED",
        "HIGH_NUMBER_OF_BYTES_USED"
    ),
    "table_handles": (
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "OWNER_THREAD_ID",
        "OWNER_EVENT_ID",
        "INTERNAL_LOCK",
        "EXTERNAL_LOCK"
    ),
    "metadata_locks": (
        "OBJECT_TYPE",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "COLUMN_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "LOCK_TYPE",
        "LOCK_DURATION",
        "LOCK_STATUS",
        "SOURCE",
        "OWNER_THREAD_ID",
        "OWNER_EVENT_ID"
    ),
    "data_locks": (
        "ENGINE",
        "ENGINE_LOCK_ID",
        "ENGINE_TRANSACTION_ID",
        "THREAD_ID",
        "EVENT_ID",
        "OBJECT_SCHEMA",
        "OBJECT_NAME",
        "PARTITION_NAME",
        "SUBPARTITION_NAME",
        "INDEX_NAME",
        "OBJECT_INSTANCE_BEGIN",
        "LOCK_TYPE",
        "LOCK_MODE",
        "LOCK_STATUS",
        "LOCK_DATA"
    ),
    "data_lock_waits": (
        "ENGINE",
        "REQUESTING_ENGINE_LOCK_ID",
        "REQUESTING_ENGINE_TRANSACTION_ID",
        "REQUESTING_THREAD_ID",
        "REQUESTING_EVENT_ID",
        "REQUESTING_OBJECT_INSTANCE_BEGIN",
        "BLOCKING_ENGINE_LOCK_ID",
        "BLOCKING_ENGINE_TRANSACTION_ID",
        "BLOCKING_THREAD_ID",
        "BLOCKING_EVENT_ID",
        "BLOCKING_OBJECT_INSTANCE_BEGIN"
    ),
    "replication_connection_configuration": (
        "CHANNEL_NAME",
        "HOST",
        "PORT",
        "USER",
        "NETWORK_INTERFACE",
        "AUTO_POSITION",
        "SSL_ALLOWED",
        "SSL_CA_FILE",
        "SSL_CA_PATH",
        "SSL_CERTIFICATE",
        "SSL_CIPHER",
        "SSL_KEY",
        "SSL_VERIFY_SERVER_CERTIFICATE",
        "SSL_CRL_FILE",
        "SSL_CRL_PATH",
        "CONNECTION_RETRY_INTERVAL",
        "CONNECTION_RETRY_COUNT",
        "HEARTBEAT_INTERVAL",
        "TLS_VERSION",
        "PUBLIC_KEY_PATH",
        "GET_PUBLIC_KEY",
        "NETWORK_NAMESPACE",
        "COMPRESSION_ALGORITHM",
        "ZSTD_COMPRESSION_LEVEL",
        "TLS_CIPHERSUITES",
        "SOURCE_CONNECTION_AUTO_FAILOVER",
        "GTID_ONLY"
    ),
    "replication_group_members": (
        "CHANNEL_NAME",
        "MEMBER_ID",
        "MEMBER_HOST",
        "MEMBER_PORT",
        "MEMBER_STATE",
        "MEMBER_ROLE",
        "MEMBER_VERSION",
        "MEMBER_COMMUNICATION_STACK"
    ),
    "replication_connection_status": (
        "CHANNEL_NAME",
        "GROUP_NAME",
        "SOURCE_UUID",
        "THREAD_ID",
        "SERVICE_STATE",
        "COUNT_RECEIVED_HEARTBEATS",
        "LAST_HEARTBEAT_TIMESTAMP",
        "RECEIVED_TRANSACTION_SET",
        "LAST_ERROR_NUMBER",
        "LAST_ERROR_MESSAGE",
        "LAST_ERROR_TIMESTAMP",
        "LAST_QUEUED_TRANSACTION",
        "LAST_QUEUED_TRANSACTION_ORIGINAL_COMMIT_TIMESTAMP",
        "LAST_QUEUED_TRANSACTION_IMMEDIATE_COMMIT_TIMESTAMP",
        "LAST_QUEUED_TRANSACTION_START_QUEUE_TIMESTAMP",
        "LAST_QUEUED_TRANSACTION_END_QUEUE_TIMESTAMP",
        "QUEUEING_TRANSACTION",
        "QUEUEING_TRANSACTION_ORIGINAL_COMMIT_TIMESTAMP",
        "QUEUEING_TRANSACTION_IMMEDIATE_COMMIT_TIMESTAMP",
        "QUEUEING_TRANSACTION_START_QUEUE_TIMESTAMP"
    ),
    "replication_applier_configuration": (
        "CHANNEL_NAME",
        "DESIRED_DELAY",
        "PRIVILEGE_CHECKS_USER",
        "REQUIRE_ROW_FORMAT",
        "REQUIRE_TABLE_PRIMARY_KEY_CHECK",
        "ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS_TYPE",
        "ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS_VALUE"
    ),
    "replication_applier_status": (
        "CHANNEL_NAME",
        "SERVICE_STATE",
        "REMAINING_DELAY",
        "COUNT_TRANSACTIONS_RETRIES"
    ),
    "replication_applier_status_by_coordinator": (
        "CHANNEL_NAME",
        "THREAD_ID",
        "SERVICE_STATE",
        "LAST_ERROR_NUMBER",
        "LAST_ERROR_MESSAGE",
        "LAST_ERROR_TIMESTAMP",
        "LAST_PROCESSED_TRANSACTION",
        "LAST_PROCESSED_TRANSACTION_ORIGINAL_COMMIT_TIMESTAMP",
        "LAST_PROCESSED_TRANSACTION_IMMEDIATE_COMMIT_TIMESTAMP",
        "LAST_PROCESSED_TRANSACTION_START_BUFFER_TIMESTAMP",
        "LAST_PROCESSED_TRANSACTION_END_BUFFER_TIMESTAMP",
        "PROCESSING_TRANSACTION",
        "PROCESSING_TRANSACTION_ORIGINAL_COMMIT_TIMESTAMP",
        "PROCESSING_TRANSACTION_IMMEDIATE_COMMIT_TIMESTAMP",
        "PROCESSING_TRANSACTION_START_BUFFER_TIMESTAMP"
    ),
    "replication_applier_status_by_worker": (
        "CHANNEL_NAME",
        "WORKER_ID",
        "THREAD_ID",
        "SERVICE_STATE",
        "LAST_ERROR_NUMBER",
        "LAST_ERROR_MESSAGE",
        "LAST_ERROR_TIMESTAMP",
        "LAST_APPLIED_TRANSACTION",
        "LAST_APPLIED_TRANSACTION_ORIGINAL_COMMIT_TIMESTAMP",
        "LAST_APPLIED_TRANSACTION_IMMEDIATE_COMMIT_TIMESTAMP",
        "LAST_APPLIED_TRANSACTION_START_APPLY_TIMESTAMP",
        "LAST_APPLIED_TRANSACTION_END_APPLY_TIMESTAMP",
        "APPLYING_TRANSACTION",
        "APPLYING_TRANSACTION_ORIGINAL_COMMIT_TIMESTAMP",
        "APPLYING_TRANSACTION_IMMEDIATE_COMMIT_TIMESTAMP",
        "APPLYING_TRANSACTION_START_APPLY_TIMESTAMP",
        "LAST_APPLIED_TRANSACTION_RETRIES_COUNT",
        "LAST_APPLIED_TRANSACTION_LAST_TRANSIENT_ERROR_NUMBER",
        "LAST_APPLIED_TRANSACTION_LAST_TRANSIENT_ERROR_MESSAGE",
        "LAST_APPLIED_TRANSACTION_LAST_TRANSIENT_ERROR_TIMESTAMP",
        "APPLYING_TRANSACTION_RETRIES_COUNT",
        "APPLYING_TRANSACTION_LAST_TRANSIENT_ERROR_NUMBER",
        "APPLYING_TRANSACTION_LAST_TRANSIENT_ERROR_MESSAGE",
        "APPLYING_TRANSACTION_LAST_TRANSIENT_ERROR_TIMESTAMP"
    ),
    "replication_group_member_stats": (
        "CHANNEL_NAME",
        "VIEW_ID",
        "MEMBER_ID",
        "COUNT_TRANSACTIONS_IN_QUEUE",
        "COUNT_TRANSACTIONS_CHECKED",
        "COUNT_CONFLICTS_DETECTED",
        "COUNT_TRANSACTIONS_ROWS_VALIDATING",
        "TRANSACTIONS_COMMITTED_ALL_MEMBERS",
        "LAST_CONFLICT_FREE_TRANSACTION",
        "COUNT_TRANSACTIONS_REMOTE_IN_APPLIER_QUEUE",
        "COUNT_TRANSACTIONS_REMOTE_APPLIED",
        "COUNT_TRANSACTIONS_LOCAL_PROPOSED",
        "COUNT_TRANSACTIONS_LOCAL_ROLLBACK"
    ),
    "replication_applier_filters": (
        "CHANNEL_NAME",
        "FILTER_NAME",
        "FILTER_RULE",
        "CONFIGURED_BY",
        "ACTIVE_SINCE",
        "COUNTER"
    ),
    "replication_applier_global_filters": (
        "FILTER_NAME",
        "FILTER_RULE",
        "CONFIGURED_BY",
        "ACTIVE_SINCE"
    ),
    "replication_asynchronous_connection_failover": (
        "CHANNEL_NAME",
        "HOST",
        "PORT",
        "NETWORK_NAMESPACE",
        "WEIGHT",
        "MANAGED_NAME",
        "Channel_name",
        "Host",
        "Port",
        "Network_namespace",
        "Weight",
        "Managed_name"
    ),
    "replication_asynchronous_connection_failover_managed": (
        "CHANNEL_NAME",
        "MANAGED_NAME",
        "MANAGED_TYPE",
        "CONFIGURATION",
        "Channel_name",
        "Managed_name",
        "Managed_type",
        "Configuration"
    ),
    "log_status": (
        "SERVER_UUID",
        "LOCAL",
        "REPLICATION",
        "STORAGE_ENGINES"
    ),
    "prepared_statements_instances": (
        "OBJECT_INSTANCE_BEGIN",
        "STATEMENT_ID",
        "STATEMENT_NAME",
        "SQL_TEXT",
        "OWNER_THREAD_ID",
        "OWNER_EVENT_ID",
        "OWNER_OBJECT_TYPE",
        "OWNER_OBJECT_SCHEMA",
        "OWNER_OBJECT_NAME",
        "EXECUTION_ENGINE",
        "TIMER_PREPARE",
        "COUNT_REPREPARE",
        "COUNT_EXECUTE",
        "SUM_TIMER_EXECUTE",
        "MIN_TIMER_EXECUTE",
        "AVG_TIMER_EXECUTE",
        "MAX_TIMER_EXECUTE",
        "SUM_LOCK_TIME",
        "SUM_ERRORS",
        "SUM_WARNINGS",
        "SUM_ROWS_AFFECTED",
        "SUM_ROWS_SENT",
        "SUM_ROWS_EXAMINED",
        "SUM_CREATED_TMP_DISK_TABLES",
        "SUM_CREATED_TMP_TABLES",
        "SUM_SELECT_FULL_JOIN",
        "SUM_SELECT_FULL_RANGE_JOIN",
        "SUM_SELECT_RANGE",
        "SUM_SELECT_RANGE_CHECK",
        "SUM_SELECT_SCAN",
        "SUM_SORT_MERGE_PASSES",
        "SUM_SORT_RANGE",
        "SUM_SORT_ROWS",
        "SUM_SORT_SCAN",
        "SUM_NO_INDEX_USED",
        "SUM_NO_GOOD_INDEX_USED",
        "SUM_CPU_TIME",
        "MAX_CONTROLLED_MEMORY",
        "MAX_TOTAL_MEMORY",
        "COUNT_SECONDARY"
    ),
    "user_variables_by_thread": (
        "THREAD_ID",
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "status_by_account": (
        "USER",
        "HOST",
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "status_by_host": (
        "HOST",
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "status_by_thread": (
        "THREAD_ID",
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "status_by_user": (
        "USER",
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "global_status": (
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "session_status": (
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "variables_by_thread": (
        "THREAD_ID",
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "global_variables": (
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "session_variables": (
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "variables_info": (
        "VARIABLE_NAME",
        "VARIABLE_SOURCE",
        "VARIABLE_PATH",
        "MIN_VALUE",
        "MAX_VALUE",
        "SET_TIME",
        "SET_USER",
        "SET_HOST"
    ),
    "persisted_variables": (
        "VARIABLE_NAME",
        "VARIABLE_VALUE"
    ),
    "user_defined_functions": (
        "UDF_NAME",
        "UDF_RETURN_TYPE",
        "UDF_TYPE",
        "UDF_LIBRARY",
        "UDF_USAGE_COUNT"
    ),
    "binary_log_transaction_compression_stats": (
        "LOG_TYPE",
        "COMPRESSION_TYPE",
        "TRANSACTION_COUNTER",
        "COMPRESSED_BYTES_COUNTER",
        "UNCOMPRESSED_BYTES_COUNTER",
        "COMPRESSION_PERCENTAGE",
        "FIRST_TRANSACTION_ID",
        "FIRST_TRANSACTION_COMPRESSED_BYTES",
        "FIRST_TRANSACTION_UNCOMPRESSED_BYTES",
        "FIRST_TRANSACTION_TIMESTAMP",
        "LAST_TRANSACTION_ID",
        "LAST_TRANSACTION_COMPRESSED_BYTES",
        "LAST_TRANSACTION_UNCOMPRESSED_BYTES",
        "LAST_TRANSACTION_TIMESTAMP"
    ),
    "tls_channel_status": (
        "CHANNEL",
        "PROPERTY",
        "VALUE"
    ),
    "rds_processlist": (
        "ID",
        "USER",
        "HOST",
        "DB",
        "COMMAND",
        "TIME",
        "STATE",
        "INFO",
        "QUERY_DIGEST_TEXT",
        "QUERY_DIGEST_HASH"
    ),
    "rds_events_threads_waits_current": (
        "THREAD_ID",
        "NAME",
        "TYPE",
        "PROCESSLIST_ID",
        "USER",
        "HOST",
        "DB",
        "COMMAND",
        "TIME",
        "STATE",
        "INFO",
        "QUERY_DIGEST_TEXT",
        "QUERY_DIGEST_HASH",
        "PARENT_THREAD_ID",
        "EVENT_NAME",
        "EVENT_TIMER_START",
        "EVENT_TIMER_END",
        "EVENT_TIMER_WAIT"
    ),
    "rds_events_threads_waits_lock_current": (
        "WAIT_THREAD_ID",
        "WAIT_USER",
        "WAIT_HOST",
        "WAIT_QUERY",
        "WAIT_TRANS_ID",
        "WAIT_LOCK_ID",
        "WAIT_TABLE_LOCK_ID",
        "WAIT_LOCK_MODE",
        "WAIT_LOCK_TYPE",
        "BLOCKER_THREAD_ID",
        "BLOCKER_TRANS_ID",
        "BLOCKER_STATE",
        "BLOCKER_USER",
        "BLOCKER_HOST",
        "BLOCKER_QUERY"
    ),
    "keyring_component_status": (
        "STATUS_KEY",
        "STATUS_VALUE"
    ),
    "malloc_stats_totals": (
        "ALLOCATED",
        "ACTIVE",
        "MAPPED",
        "RESIDENT",
        "RETAINED",
        "METADATA"
    ),
    "malloc_stats": (
        "TYPE",
        "ALLOCATED",
        "NMALLOC",
        "NDALLOC",
        "NREQUESTS"
    ),
    "component": (
        "component_id",
        "component_group_id",
        "component_urn"
    ),
    "default_roles": (
        "HOST",
        "USER",
        "DEFAULT_ROLE_HOST",
        "DEFAULT_ROLE_USER"
    ),
    "engine_cost": (
        "engine_name",
        "device_type",
        "cost_name",
        "cost_value",
        "last_update",
        "comment",
        "default_value"
    ),
    "global_grants": (
        "USER",
        "HOST",
        "PRIV",
        "WITH_GRANT_OPTION"
    ),
    "help_category": (
        "help_category_id",
        "name",
        "parent_category_id",
        "url"
    ),
    "help_keyword": (
        "help_keyword_id",
        "name"
    ),
    "help_relation": (
        "help_topic_id",
        "help_keyword_id"
    ),
    "help_topic": (
        "help_topic_id",
        "name",
        "help_category_id",
        "description",
        "example",
        "url"
    ),
    "plugin": (
        "name",
        "dl"
    ),
    "password_history": (
        "Host",
        "User",
        "Password_timestamp",
        "Password"
    ),
    "proxies_priv": (
        "Host",
        "User",
        "Proxied_host",
        "Proxied_user",
        "With_grant",
        "Grantor",
        "Timestamp"
    ),
    "role_edges": (
        "FROM_HOST",
        "FROM_USER",
        "TO_HOST",
        "TO_USER",
        "WITH_ADMIN_OPTION"
    ),
    "servers": (
        "Server_name",
        "Host",
        "Db",
        "Username",
        "Password",
        "Port",
        "Socket",
        "Wrapper",
        "Owner"
    ),
    "server_cost": (
        "cost_name",
        "cost_value",
        "last_update",
        "comment",
        "default_value"
    ),
    "replication_group_member_actions": (
        "name",
        "event",
        "enabled",
        "type",
        "priority",
        "error_handling"
    ),
    "time_zone_name": (
        "Name",
        "Time_zone_id"
    ),
    "time_zone_leap_second": (
        "Transition_time",
        "Correction"
    ),
    "time_zone_transition": (
        "Time_zone_id",
        "Transition_time",
        "Transition_type_id"
    ),
    "time_zone_transition_type": (
        "Time_zone_id",
        "Transition_type_id",
        "Offset",
        "Is_DST",
        "Abbreviation"
    ),
    "func": (
        "name",
        "ret",
        "dl",
        "type"
    ),
    "gtid_executed": (
        "source_uuid",
        "interval_start",
        "interval_end"
    ),
    "slave_master_info": (
        "Number_of_lines",
        "Master_log_name",
        "Master_log_pos",
        "Host",
        "User_name",
        "User_password",
        "Port",
        "Connect_retry",
        "Enabled_ssl",
        "Ssl_ca",
        "Ssl_capath",
        "Ssl_cert",
        "Ssl_cipher",
        "Ssl_key",
        "Ssl_verify_server_cert",
        "Heartbeat",
        "Bind",
        "Ignored_server_ids",
        "Uuid",
        "Retry_count",
        "Ssl_crl",
        "Ssl_crlpath",
        "Enabled_auto_position",
        "Channel_name",
        "Tls_version",
        "Public_key_path",
        "Get_public_key",
        "Network_namespace",
        "Master_compression_algorithm",
        "Master_zstd_compression_level",
        "Tls_ciphersuites",
        "Source_connection_auto_failover",
        "Gtid_only"
    ),
    "slave_worker_info": (
        "Id",
        "Relay_log_name",
        "Relay_log_pos",
        "Master_log_name",
        "Master_log_pos",
        "Checkpoint_relay_log_name",
        "Checkpoint_relay_log_pos",
        "Checkpoint_master_log_name",
        "Checkpoint_master_log_pos",
        "Checkpoint_seqno",
        "Checkpoint_group_size",
        "Checkpoint_group_bitmap",
        "Channel_name"
    ),
    "slave_relay_log_info": (
        "Number_of_lines",
        "Relay_log_name",
        "Relay_log_pos",
        "Master_log_name",
        "Master_log_pos",
        "Sql_delay",
        "Number_of_workers",
        "Id",
        "Channel_name",
        "Privilege_checks_username",
        "Privilege_checks_hostname",
        "Require_row_format",
        "Require_table_primary_key_check",
        "Assign_gtids_to_anonymous_transactions_type",
        "Assign_gtids_to_anonymous_transactions_value"
    ),
    "user": (
        "Host",
        "User",
        "Select_priv",
        "Insert_priv",
        "Update_priv",
        "Delete_priv",
        "Create_priv",
        "Drop_priv",
        "Reload_priv",
        "Shutdown_priv",
        "Process_priv",
        "File_priv",
        "Grant_priv",
        "References_priv",
        "Index_priv",
        "Alter_priv",
        "Show_db_priv",
        "Super_priv",
        "Create_tmp_table_priv",
        "Lock_tables_priv",
        "Execute_priv",
        "Repl_slave_priv",
        "Repl_client_priv",
        "Create_view_priv",
        "Show_view_priv",
        "Create_routine_priv",
        "Alter_routine_priv",
        "Create_user_priv",
        "Event_priv",
        "Trigger_priv",
        "Create_tablespace_priv",
        "ssl_type",
        "ssl_cipher",
        "x509_issuer",
        "x509_subject",
        "max_questions",
        "max_updates",
        "max_connections",
        "max_user_connections",
        "plugin",
        "authentication_string",
        "password_expired",
        "password_last_changed",
        "password_lifetime",
        "account_locked",
        "Create_role_priv",
        "Drop_role_priv",
        "Password_reuse_history",
        "Password_reuse_time",
        "Password_require_current",
        "User_attributes"
    ),
    "time_zone": (
        "Time_zone_id",
        "Use_leap_seconds"
    ),
    "db": (
        "Host",
        "Db",
        "User",
        "Select_priv",
        "Insert_priv",
        "Update_priv",
        "Delete_priv",
        "Create_priv",
        "Drop_priv",
        "Grant_priv",
        "References_priv",
        "Index_priv",
        "Alter_priv",
        "Create_tmp_table_priv",
        "Lock_tables_priv",
        "Create_view_priv",
        "Show_view_priv",
        "Create_routine_priv",
        "Alter_routine_priv",
        "Execute_priv",
        "Event_priv",
        "Trigger_priv"
    ),
    "tables_priv": (
        "Host",
        "Db",
        "User",
        "Table_name",
        "Grantor",
        "Timestamp",
        "Table_priv",
        "Column_priv"
    ),
    "columns_priv": (
        "Host",
        "Db",
        "User",
        "Table_name",
        "Column_name",
        "Timestamp",
        "Column_priv"
    ),
    "procs_priv": (
        "Host",
        "Db",
        "User",
        "Routine_name",
        "Routine_type",
        "Grantor",
        "Proc_priv",
        "Timestamp"
    ),
    "sys_config": (
        "variable",
        "value",
        "set_time",
        "set_by"
    ),
    "rds_history": (
        "action_timestamp",
        "called_by_user",
        "action",
        "mysql_version",
        "master_host",
        "master_port",
        "master_user",
        "master_log_file",
        "master_log_pos",
        "master_ssl",
        "auto_position",
        "master_gtid"
    ),
    "rds_replication_status": (
        "action_timestamp",
        "called_by_user",
        "action",
        "mysql_version",
        "master_host",
        "master_port",
        "replication_log_file",
        "replication_stop_point",
        "replication_gtid"
    ),
    "message_channel_view": (
        "message_channel_id",
        "version",
        "chanel_type_id",
        "name"
    ),
    "user_user_extenal_general_view": (
        "person_id",
        "person.is_approved",
        "person.main_email_address",
        "user.main_email_address",
        "username",
        "user_id",
        "user.is_approved",
        "user.is_test_data",
        "profile.name",
        "profile.preferred_lang_code",
        "profile.gender_id",
        "profile.main_email_address",
        "user.first_name",
        "user.last_name",
        "user.created_timestamp",
        "profile_id",
        "brand_id",
        "user.active_location_id",
        "user.active_location.country_ml.title",
        "subscription_id",
        "subscription_title",
        "user.stars",
        "profile.stars",
        "person.birthday_date",
        "profile.phone.full_number_normalized",
        "role_name",
        "email_address",
        "last_login_timestamp",
        "user_external.username"
    ),
    "api_type_user_external_table": (
        "api_type_user_external_id",
        "api_type_id",
        "environment_id",
        "user_external_id",
        "is_test_data"
    ),
    "campaign_table": (
        "campaign_id",
        "name",
        "criteria_id_old",
        "start_hour",
        "end_hour",
        "occurrence_id",
        "days_of_week",
        "max_audience",
        "max_exposure_per_day",
        "minimal_days_between_messages_to_the_same_recipient",
        "message_template_id_old",
        "dialog_workflow_script_id",
        "default_sender_profile_id",
        "is_dialog_workflow",
        "content_set_id",
        "marketplace_rfp_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "criteria_event_table": (
        "criteria_event_id",
        "criteria_set_id",
        "event_id"
    ),
    "campaign_event_table": (
        "campaign_event_id",
        "campaign_id",
        "event_id"
    ),
    "group_group_table": (
        "group_group_id",
        "group_id1",
        "group_id2",
        "relationship_type_id",
        "action_id",
        "is_move_everything_from_group1_to_group2",
        "is_main"
    ),
    "campaign_criteria_set_table": (
        "campaign_criteria_set_id",
        "name",
        "campaign_id",
        "criteria_id_old",
        "criteria_set_id",
        "max_recipients_per_campaign_criteria_set",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "number_of_channels_per_recipient"
    ),
    "api_price_view": (
        "api_price_id",
        "api_type_id",
        "user_external_id",
        "quantity_unit",
        "min_quantity",
        "max_quantity",
        "price_set_id",
        "is_test_data"
    ),
    "api_price_table": (
        "api_price_id",
        "api_type_id",
        "user_external_id",
        "quantity_unit",
        "min_quantity",
        "max_quantity",
        "price_set_id",
        "is_test_data"
    ),
    "profile_storage_table": (
        "profile_storage_id",
        "profile_id",
        "storage_id",
        "is_manual_approved",
        "is_ai_approved"
    ),
    "reaction_type_ml_table": (
        "reaction_type_ml_id",
        "reaction_type_id",
        "lang_code",
        "title",
        "description",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "action_file_star_subscription_view": (
        "action_id",
        "file_type_id",
        "COUNT(subscription_id)"
    ),
    "action_star_subscription_table": (
        "action_star_subscription_id",
        "number",
        "action_id",
        "file_type_id",
        "subscription_id",
        "action_stars",
        "is_conditional",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "message_general_view": (
        "message_id",
        "number",
        "identifier",
        "parent_message_id",
        "message_message_relationship_id",
        "from_profile_id",
        "from_profile.profile-name",
        "from_email",
        "to_profile_id",
        "to_profile.profile-name",
        "to_profile_list_id",
        "to_email",
        "cc_profile_id",
        "cc_profile_list_id",
        "cc_email",
        "bcc_profile_id",
        "bcc_profile_list_id",
        "bcc_email",
        "group_list_id",
        "occurrence_id",
        "location_id",
        "message_channel_id",
        "message_type_id",
        "is_push_notification",
        "group_id",
        "session_id",
        "visibility_id",
        "is_pin",
        "mailbox_id",
        "is_gen_ai",
        "machine_learning_model_id",
        "is_require_moderator",
        "moderator_profile_id",
        "moderator_feedback_type",
        "moderator_feedback_text",
        "is_moderator_approved",
        "queue_status_id",
        "message_status_id",
        "process_id",
        "stdout",
        "stderr",
        "return_code",
        "returned_value",
        "return_message",
        "profile_id",
        "server_ip_v4",
        "server_ip_v6",
        "thread_id",
        "user_jwt",
        "class_parameters_json",
        "function_parameters_json",
        "action_id",
        "campaign_id",
        "campaign_criteria_set_id",
        "requested_channel_id",
        "actual_channel_id",
        "from_provider_id",
        "to_provider_id",
        "email_message_id",
        "body",
        "subject",
        "compound_message",
        "compound_message_json_version",
        "compound_message_json",
        "session",
        "channel_id",
        "last_dialog_workflow_state_id",
        "next_dialog_workflow_state_id",
        "from_subsystem_id",
        "updated_effective_profile_id",
        "original_message_id",
        "conversation_id",
        "is_test_data",
        "request_to_send_timestamp",
        "scheduled_sent_timestamp",
        "actual_sent_timestamp",
        "message_template_id",
        "inforu_customer_id",
        "inforu_project_id",
        "inforu_channel",
        "inforu_type",
        "inforu_value",
        "inforu_keyword",
        "inforu_network",
        "inforu_short_code",
        "inforu_application_id",
        "inforu_customer_param",
        "inforu_mo_session_id",
        "inforu_incoming_json",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "component_id"
    ),
    "document_type_table": (
        "document_type_id",
        "name"
    ),
    "document_type_ml_table": (
        "document_type_ml_id",
        "document_type_id",
        "lang_code",
        "title"
    ),
    "brand_document_type_table": (
        "brand_document_type_table",
        "brand_id",
        "document_type_id",
        "is_enable",
        "next_document_number"
    ),
    "review_relationship_type_general_duplicate_description_view": (
        "relationship_type_id",
        "party1_profile_category_id",
        "party1_profile_category_title",
        "party1_gender_id",
        "gender1",
        "party2_profile_category_id",
        "party2_profile_category_title",
        "party2_gender_id",
        "gender2",
        "description",
        "Name_exp_11",
        "is_directional",
        "is_direct_connection",
        "relationship_category_id",
        "relationship_type_classification_title",
        "past_present_future",
        "profile1_older_than_profile2",
        "is_user_level",
        "relationship_type_classification_id",
        "party1_older_min_years",
        "party1_older_max_years",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "relationship_type_ml_table": (
        "relationship_type_ml_id",
        "relationship_type_id",
        "lang_code",
        "party1_for_party2_title",
        "is_party1_for_party2_title_approved",
        "party2_for_party1_title",
        "is_party2_for_party1_title_approved",
        "description",
        "is_description_approved",
        "is_person_name_in_the_end",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "message_inforu_table": (
        "message_id",
        "inforu_customer_id",
        "inforu_project_id",
        "inforu_channel",
        "inforu_type",
        "inforu_value",
        "inforu_keyword",
        "inforu_network",
        "inforu_short_code",
        "inforu_application_id",
        "inforu_customer_param",
        "inforu_mo_session_id",
        "inforu_incoming_json",
        "message_id",
        "inforu_customer_id",
        "inforu_project_id",
        "inforu_channel",
        "inforu_type",
        "inforu_value",
        "inforu_keyword",
        "inforu_network",
        "inforu_short_code",
        "inforu_application_id",
        "inforu_customer_param",
        "inforu_mo_session_id",
        "inforu_incoming_json"
    ),
    "brand_environment_variable_table": (
        "brand_environment_variable_id",
        "brand_id",
        "environment_variable_name",
        "environment_variable_value"
    ),
    "agreement_table": (
        "agreement_id",
        "seller_id",
        "buyer_id"
    ),
    "goods_offer_group_table": (
        "goods_offer_group_id",
        "goods_offer_id",
        "group_id",
        "platform_transaction_fee_from_seller",
        "platform_transaction_percentage_from_seller",
        "platform_transaction_fee_from_buyer",
        "platform_transaction_percentage_from_buyer"
    ),
    "goods_group_supplier_table": (
        "goods_group_supplier_id",
        "group_id",
        "supplier_id",
        "platform_transaction_fee_value_from_seller",
        "platform_transaction_percentage_from_seller",
        "platform_transaction_fee_value_from_buyer",
        "platform_transaction_percentage_from_buyer"
    ),
    "event_profile__label_table": (
        "event_profile__label_id",
        "event_profile_id",
        "label_id"
    ),
    "goods_offer_profile_table": (
        "goods_offer__profile_id",
        "goods_offer_id",
        "profile_id",
        "income_transaction_id",
        "start_timestamp",
        "end_timestamp",
        "price_id",
        "price_duration"
    ),
    "goods_offer_table": (
        "goods_offer_id",
        "goods_seller_id",
        "goods_provider_id",
        "goods_id",
        "experience",
        "reaction_id",
        "reaction_value",
        "main_price_id",
        "base_price",
        "main_currency_id",
        "event_id",
        "is_hot_deal",
        "advertisement_campaign_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "image_height",
        "image_width",
        "exposures",
        "period",
        "units",
        "units_of_what"
    ),
    "intent_table": (
        "intent_id",
        "text",
        "is_event_registration",
        "is_positive",
        "is_natural",
        "is_negative"
    ),
    "brand_profile_table": (
        "brand_profile_id",
        "brand_id",
        "profile_id",
        "is_partner"
    ),
    "brand_partner_profile_table": (
        "brand_profile_id",
        "brand_id",
        "profile_id",
        "percentage"
    ),
    "goods_offer__sku_table": (
        "goods_offer__sku_id",
        "goods_offer_id",
        "sku_id",
        "name",
        "description"
    ),
    "invoice__line_item_table": (
        "invoice__line_item_id",
        "invoice_id",
        "line_item_id",
        "name"
    ),
    "line_item__proforma_invoice_table": (
        "line_item__proforma_invoice_id"
    ),
    "line_item_ml_table": (
        "line_item_ml_id",
        "line_item_id",
        "lang_code",
        "title"
    ),
    "sku_table": (
        "sku_id",
        "name"
    ),
    "proforma_invoice_table": (
        "proforma_invoice_id",
        "name",
        "number",
        "from_profile_id",
        "to_profile_id"
    ),
    "service_table": (
        "service_id",
        "name",
        "service_type_id",
        "event_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "event__food_needed_table": (
        "event__food_needed_id",
        "event_id",
        "sku",
        "quantity_per_event",
        "quantity_per_participant",
        "unit"
    ),
    "event__bring_your_own_food_table": (
        "event__bring_your_own_food_id",
        "event_id",
        "your_own_food_id",
        "sku",
        "from_profile_id",
        "quantity",
        "unit"
    ),
    "people_criteria_ext_view": (
        "criteria_id",
        "name",
        "min_age",
        "max_age",
        "min_number_of_kids",
        "max_number_of_kids",
        "min_kids_age",
        "max_kids_age",
        "gender_list_id",
        "min_height",
        "max_height",
        "partner_experience_level",
        "number_of_partners",
        "job_group_list_id",
        "job_location_list_id",
        "vacancy_list_id",
        "workplace_profile_list_id",
        "start_date_type_id",
        "job_types_id",
        "user_external_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "internet_domain_id",
        "internet_domain_list_id",
        "organization_name",
        "group_id",
        "profile_list_id",
        "international_code"
    ),
    "message_template_category_table": (
        "message_template_category_id",
        "name",
        "facebook_conversation_category",
        "description"
    ),
    "message_template_text_block_ml_table": (
        "message_template_text_block_ml_id",
        "number",
        "identifier",
        "message_template_text_block_id",
        "gender_id",
        "lang_code",
        "default_subject_template",
        "default_body_template",
        "sms_body_template",
        "email_subject_template",
        "email_body_html_template",
        "whatsapp_body_template",
        "smartlink_type_id",
        "is_facebook_approved",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "message_template_category_id"
    ),
    "message_template_text_block_table": (
        "message_template_text_block_id",
        "name",
        "is_visible",
        "seq_old",
        "criteria_set_id",
        "criteria_id_old",
        "question_id",
        "message_template_text_block_type_id",
        "message_template_category_id",
        "version",
        "is_version_locked",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "logger_general_recent_whatsapp_inforu_view": (
        "logger_id",
        "server_ip_v4",
        "server_ip_v6",
        "component_id",
        "name",
        "programming_language_id",
        "programming_language"
    ),
    "purchase_order_table": (
        "purchase_order_id",
        "number",
        "name",
        "from_profile_id",
        "to_profile_id"
    ),
    "rfp_item_proposal_table": (
        "rfp_item_proposal_id",
        "rfp_item_id",
        "supplier_profile_id",
        "prospect_profile_id",
        "min_price_id",
        "max_price_id"
    ),
    "action_item_table": (
        "action_item_id",
        "number",
        "identifier",
        "activity_id",
        "ranking",
        "other_group_id",
        "other_person_id",
        "other_profile_id",
        "name",
        "action_id",
        "action_item_type_id",
        "active_main_profile_id",
        "passive_main_profile_id",
        "passive_main_contact_id",
        "is_recommendation",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "github_repo_url",
        "jira_issue_id",
        "jira_issue_url",
        "due_date_regular",
        "due_date_bonus1",
        "price_id_reguar",
        "price_id_bonus1",
        "financial_transaction_id"
    ),
    "line_item_table": (
        "line_item_id",
        "name",
        "from_time",
        "to_time",
        "hours",
        "description_temp",
        "project_id",
        "event_id",
        "action_item_id"
    ),
    "service_receiver_ml_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "service_provider_ml_view": (
        "entity_id",
        "name"
    ),
    "service_review_ml_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "service_ml_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "service_offer_ml_view": (
        "entity_id",
        "name"
    ),
    "shop_ml_view": (
        "entity_id",
        "name",
        "coordinate"
    ),
    "platform_invitation_table": (
        "platform_invitation_id",
        "number",
        "identifier",
        "from_profile_id",
        "to_profile_id",
        "to_contact_id",
        "to_email_address",
        "to_email_address_id",
        "to_phone_number",
        "to_phone_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "queue_status_id",
        "action_id",
        "process_id",
        "user_jwt",
        "cc_profile_id",
        "bcc_profile_id",
        "invitation_method_id",
        "token",
        "invitation_status_id"
    ),
    "repo_table": (
        "repo_id",
        "url",
        "is_separete_publish_gpr_job",
        "name",
        "type",
        "programming_language_name",
        "category",
        "programming_langage_id",
        "main_developer_profile_id",
        "serverless_domain_manager_status",
        "is_using_our_own_serverless_graphql_server",
        "is_package",
        "is_serverless_com",
        "number_of_modules"
    ),
    "message_template__system_table": (
        "message_template__system_id",
        "message_template_id",
        "system_id",
        "sub_system_id",
        "external_template_id"
    ),
    "api_incoming_request_table": (
        "api_incoming_request_id",
        "server",
        "endpoint",
        "headers",
        "body",
        "resource",
        "path",
        "httpMethod",
        "multiValueHeaders",
        "multiValueQueryStringParameters",
        "pathParameters",
        "stageVariables",
        "queryStringParameters",
        "requestContext",
        "full_json"
    ),
    "conversation_view": (
        "conversation_id",
        "name"
    ),
    "profile__phone_general_view": (
        "profile_id",
        "profile.name",
        "phone_profile_id",
        "phone.phone_id",
        "full_number_normalized"
    ),
    "api_limit_table": (
        "api_limit_id",
        "profile_id",
        "user_external_id",
        "api_type_id",
        "region",
        "soft_limit_value",
        "soft_limit_unit",
        "hard_limit_value",
        "hard_limit_unit",
        "url_to_see_the limit",
        "external_limit_name",
        "external_limit_code",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "is_test_data"
    ),
    "profile_list_table": (
        "profile_list_id",
        "name",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "conversation_table": (
        "conversation_id",
        "name",
        "conversation_id",
        "name",
        "profile_list_id"
    ),
    "conversation__profile_table": (
        "conversation__profile_id",
        "conversation_id",
        "profile_id",
        "message_channel_id",
        "last_dialog_workflow_state_id",
        "is_mute",
        "is_get_popup",
        "last_message_channel_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "campaign_message_profile_table": (
        "campaign_message_profile_id",
        "number",
        "identifier",
        "campaign_id",
        "message_id",
        "profile_id",
        "channel_id_old",
        "last_dialog_workflow_state_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "calendar_url_table": (
        "calendar_url_id",
        "name",
        "profile_id",
        "platform_id",
        "length_minutes",
        "schedule_url_temp",
        "schedule_url_id",
        "is_in_person",
        "profile_name_temp"
    ),
    "marketplace_rfp_table": (
        "marketplace_rfp_id",
        "number",
        "identifier",
        "name",
        "service_id",
        "goods_id",
        "is_to_supplier",
        "is_to_prospect",
        "url_temp",
        "url_id",
        "location_id",
        "location_list_id",
        "activity_id",
        "activity_list_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "file_type_table": (
        "file_type_id",
        "file_type",
        "add_action_id",
        "remove_action_id",
        "is_system",
        "visibility_id",
        "is_identity_document",
        "location_id",
        "location_list_id"
    ),
    "profile_list_member_table": (
        "profile_list_member_id",
        "profile_list_id",
        "profile_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "people_criteria_ext_table": (
        "criteria_id",
        "name",
        "min_age",
        "max_age",
        "min_number_of_kids",
        "max_number_of_kids",
        "min_kids_age",
        "max_kids_age",
        "gender_list_id",
        "min_height",
        "max_height",
        "partner_experience_level",
        "number_of_partners",
        "job_group_list_id",
        "job_location_list_id",
        "vacancy_list_id",
        "workplace_profile_list_id",
        "start_date_type_id",
        "job_types_id",
        "user_external_id",
        "internet_domain_id",
        "internet_domain_list_id",
        "organization_name",
        "group_id",
        "profile_list_id",
        "international_code",
        "profile_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "people_criteria_ext_general_view": (
        "criteria.criteria_id",
        "people_criteria.criteria_id",
        "location_criteria.criteria_id",
        "criteria.name",
        "entity_type_id",
        "group_list_id",
        "location_id",
        "location_list_id",
        "coordinate",
        "radius",
        "radius_measure",
        "radius_km",
        "job_group_list_id_old",
        "job_location_list_id_old",
        "vacancy_list_id_old",
        "workplace_profile_list_id_old",
        "start_date_type_id",
        "job_types_id_old",
        "user_external_id",
        "visibility_id",
        "where_sql",
        "template_condition_2delete",
        "internet_domain_id_old",
        "internet_domain_list_id_old",
        "organization_name_old",
        "group_id",
        "profile_list_id_old",
        "international_code_old",
        "country_id_old",
        "label_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "people_criteria.name",
        "min_age",
        "max_age",
        "min_number_of_kids",
        "max_number_of_kids",
        "min_kids_age",
        "max_kids_age",
        "gender_list_id",
        "min_height",
        "max_height",
        "partner_experience_level",
        "number_of_partners",
        "job_group_list_id",
        "job_location_list_id",
        "vacancy_list_id",
        "workplace_profile_list_id",
        "start_date_type_id_old",
        "job_types_id",
        "people_criteria.user_external_id",
        "internet_domain_id",
        "internet_domain_list_id",
        "organization_name",
        "group_id_old",
        "profile_list_id",
        "international_code",
        "people_criteria.is_test_data",
        "people_criteria.start_timestamp",
        "people_criteria.end_timestamp",
        "people_criteria.created_timestamp",
        "people_criteria.created_user_id",
        "people_criteria.updated_timestamp",
        "people_criteria.updated_user_id",
        "city_id"
    ),
    "people_criteria_ext_review_view": (
        "criteria_id",
        "criteria.name",
        "people_criteria.name",
        "min_age",
        "max_age"
    ),
    "relationship_type_table": (
        "relationship_type_id",
        "name",
        "is_people_group",
        "party1_profile_category_id",
        "party1_gender_id",
        "party2_profile_category_id",
        "party2_gender_id",
        "party2_goods_id",
        "party2_goods_offer_id",
        "pary2_sku_id",
        "is_directional",
        "is_direct_connection",
        "relationship_category_id",
        "past_present_future",
        "profile1_older_than_profile2",
        "is_user_level",
        "relationship_type_classification_id",
        "party1_older_min_years",
        "party1_older_max_years",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "techer_view": (
        "teacher_id",
        "full_name",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "rfp_table": (
        "rfp_id",
        "name",
        "from_profile_id"
    ),
    "rfp_item_table": (
        "rfp_item_id",
        "name",
        "acitivity_id",
        "sub_activity_id",
        "description",
        "mandatory_quantity",
        "optional_quantity",
        "min_price_id",
        "max_price_id",
        "price_per",
        "rfp_id"
    ),
    "price_set_currency_table": (
        "price_set_currency_id",
        "price_set_id",
        "country_id",
        "currency_id",
        "price",
        "start_timestamp",
        "end_timestamp",
        "is_vat_included"
    ),
    "student_table": (
        "student_id",
        "full_name",
        "profile_id",
        "mother_profile_id",
        "father_profile_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "teacher_table": (
        "teacher_id",
        "profile_id",
        "full_name",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "brand_table": (
        "brand_id",
        "name",
        "brand_profile_id",
        "root_group_id",
        "google_ads_account",
        "description",
        "brand_type_id",
        "competitors",
        "potential_partners"
    ),
    "event_general_view": (
        "event_id",
        "event.name",
        "event.description",
        "location_id",
        "organizers_profile_id",
        "website_url",
        "facebook_event_url",
        "meetup_event_url",
        "registration_url",
        "is_test_data",
        "new_event_id",
        "event.start_timestamp",
        "event.end_timestamp",
        "event_ml_id",
        "lang_code",
        "title",
        "is_main_title",
        "event_ml.is_test_data",
        "event_ml.end_timestamp",
        "event_category_title",
        "event_type_name",
        "is_location",
        "is_contact_classification",
        "event_id1 (parent)",
        "event_id2 (child)"
    ),
    "event_general_with_deleted_and_test_data_view": (
        "event_id",
        "event.name",
        "event.description",
        "location_id",
        "organizers_profile_id",
        "website_url",
        "facebook_event_url",
        "meetup_event_url",
        "registration_url",
        "is_test_data",
        "new_event_id",
        "event.start_timestamp",
        "event.end_timestamp",
        "event_ml_id",
        "lang_code",
        "title",
        "is_main_title",
        "event_ml.is_test_data",
        "event_ml.end_timestamp",
        "event_category_title",
        "event_type_name",
        "is_location",
        "is_contact_classification",
        "event_id1 (parent)",
        "event_id2 (child)",
        "location.name",
        "location_ml.lang_code",
        "location_ml.title"
    ),
    "profile_en_view_old": (
        "id_profile",
        "number",
        "profile.main_user_id",
        "main_person_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "is_rip",
        "last_dialog_workflow_state_id_old"
    ),
    "profile_ml_approved_en_view_old": (
        "profile_id",
        "number",
        "profile.main_user_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "is_rip",
        "last_dialog_workflow_state_id_old"
    ),
    "profile_ml_approved_view_old": (
        "profile_id",
        "number",
        "profile.main_user_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "is_rip",
        "last_dialog_workflow_state_id_old"
    ),
    "user_table": (
        "user_id",
        "number",
        "brand_id",
        "username",
        "is_approved",
        "user.main_email_address",
        "first_name",
        "last_name",
        "name_approved",
        "identity_id",
        "stars",
        "default_time_zone",
        "current_time_zone",
        "preferred_lang_code",
        "active_location_id",
        "gender_id",
        "interested_in_gender_id",
        "user_approval_to_get_emails_from_us",
        "password",
        "birthday_original_moved_to_person",
        "birthday_moved_to_person",
        "region",
        "main_profile_id",
        "presence",
        "is_system",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "user_pii_view": (
        "user_id",
        "number",
        "brand_id",
        "username",
        "is_approved",
        "user.main_email_address",
        "first_name",
        "last_name",
        "name_approved",
        "identity_id",
        "stars",
        "default_time_zone",
        "current_time_zone",
        "preferred_lang_code",
        "active_location_id",
        "gender_id",
        "interested_in_gender_id",
        "user_approval_to_get_emails_from_us",
        "password",
        "password_clear_text",
        "password_encrypted",
        "region",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "presence",
        "start_timestamp",
        "end_timestamp"
    ),
    "user_view": (
        "user_id",
        "number",
        "brand_id",
        "username",
        "is_approved",
        "user.main_email_address",
        "first_name",
        "last_name",
        "name_approved",
        "identity_id",
        "stars",
        "default_time_zone",
        "current_time_zone",
        "preferred_lang_code",
        "active_location_id",
        "gender_id",
        "interested_in_gender_id",
        "user_approval_to_get_emails_from_us",
        "password",
        "birthday_original_moved_to_person",
        "birthday_moved_to_person",
        "region",
        "main_profile_id",
        "presence",
        "is_system",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "conversation__profile_view": (
        "conversation__profile_id",
        "conversation_id",
        "profile_id",
        "is_mute",
        "is_get_popup",
        "last_message_channel_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "conversation__profile_general_view": (
        "conversation__profile_id",
        "conversation.conversation_id"
    ),
    "login_history_general_view": (
        "person_id",
        "person.is_approved",
        "user.main_email_address",
        "user_id",
        "profile.preferred_lang_code",
        "user.first_name",
        "user.last_name",
        "user.created_timestamp",
        "profile_id",
        "brand_id",
        "user.active_location.country_ml.title",
        "subscription_id",
        "subscription_title",
        "user.stars",
        "profile.stars",
        "login_history.created_timestamp"
    ),
    "login_history_general_recent_view": (
        "person_id",
        "person.is_approved",
        "user.main_email_address",
        "user_id",
        "profile.preferred_lang_code",
        "user.first_name",
        "user.last_name",
        "user.created_timestamp",
        "profile_id",
        "brand_id",
        "user.active_location.country_ml.title",
        "subscription_id",
        "subscription_title",
        "user.stars",
        "profile.stars",
        "login_history.created_timestamp"
    ),
    "login_login_history_group_by_user_view": (
        "person_id",
        "person.is_approved",
        "user.main_email_address",
        "user_id",
        "profile.preferred_lang_code",
        "user.first_name",
        "user.last_name",
        "user.created_timestamp",
        "profile_id",
        "brand_id",
        "user.active_location.country_ml.title",
        "subscription_id",
        "subscription_title",
        "user.stars",
        "profile.stars",
        "login_history.created_timestamp"
    ),
    "profile_profile_table": (
        "profile_profile_id",
        "number",
        "profile_id1",
        "profile_id2",
        "relationship_type_id",
        "is_potential",
        "profile_profile_role_id",
        "job_title",
        "job_title_id",
        "remark",
        "is_user_request",
        "is_system_recommendation",
        "user_external_id",
        "user_external_level",
        "is_profile1_knows_profile2",
        "is_profile1_requested_to_be_friend_with_profile2",
        "is_profile2_approved_profile1_request_to_be_friends",
        "is_test_data",
        "start_timestamp",
        "start_date_day",
        "start_date_month",
        "start_date_year",
        "start_circa",
        "end_timestamp",
        "end_date_day",
        "end_date_month",
        "end_date_year",
        "end_circa",
        "is_star",
        "system_id",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "reaction_type_general_view": (
        "reaction_id",
        "name",
        "number",
        "value",
        "text",
        "image",
        "reaction_type_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "reaction_type_ml.lang_code",
        "title",
        "reaction_type_ml.is_test_data",
        "reaction_type_ml.end_timestamp"
    ),
    "reaction_type_table": (
        "reaction_type_id",
        "name",
        "is_test_data",
        "end_timestamp"
    ),
    "label_storage_table": (
        "label_storage_id",
        "label_id",
        "label_ml_id",
        "storage_id",
        "storage_ml_id",
        "is_approved"
    ),
    "label_table": (
        "label_id",
        "number",
        "is_approved",
        "name",
        "name_approved",
        "parent_label_id",
        "location_id",
        "is_highlight",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "project_table": (
        "project_id",
        "name",
        "description_old",
        "phase"
    ),
    "profile__project_table": (
        "profile__project_id",
        "profile_id",
        "project_id"
    ),
    "calendar_item_table": (
        "calendar_item_id",
        "calendar_id",
        "name",
        "occurrence_id",
        "activity_id",
        "location",
        "location_id",
        "action_item_id",
        "event_id",
        "calendar_item_type",
        "is_billable",
        "billable_profile",
        "source_user_external_id",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "busy_with_activity_id",
        "busy_with_action_item_id",
        "available_for_activity_id",
        "created_effective_prodile_id",
        "created_effective_user_id"
    ),
    "campaign_user_request_table": (
        "campaign_user_request_id",
        "campaign_id",
        "user_request_id"
    ),
    "user_request_table": (
        "user_request_id",
        "request_en",
        "user_request_tablecol"
    ),
    "profile_table": (
        "profile_id",
        "number",
        "identifier",
        "profile.name",
        "profile.main_user_id",
        "main_person_id",
        "is_main",
        "visibility_id",
        "is_approved",
        "profile_type_id",
        "preferred_lang_code",
        "experience_years_min",
        "main_phone_id",
        "profile.main_email_address",
        "is_rip",
        "profile.gender_id",
        "stars",
        "last_dialog_workflow_state_id_old",
        "is_system",
        "internal_description",
        "is_business_profile",
        "main_location_id",
        "is_employed",
        "is_looking_for_job",
        "is_edu",
        "is_claimed",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "message_reaction_table": (
        "message_reaction_id",
        "message_id",
        "reaction_id",
        "created_user_id",
        "profile_id"
    ),
    "profile_reaction_table": (
        "profile_reaction_id",
        "number",
        "identifier",
        "from_profile_id",
        "reaction_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "to_profile_id"
    ),
    "test_person_table": (
        "person_id",
        "number",
        "identifier",
        "name",
        "is_approved",
        "is_identity_confirmed",
        "birthday_original",
        "birthday_timestamp",
        "birthday_date",
        "day",
        "month",
        "year",
        "year_cira",
        "gender_id",
        "first_name",
        "is_first_name_approved",
        "nickname",
        "is_nickname_approved",
        "father_name",
        "last_name",
        "last_name_original",
        "is_last_name_approved",
        "is_last_name_sure",
        "is_last_name_auto_generated",
        "person.main_email_address",
        "person.main_email_address_id",
        "main_full_number_normalized",
        "last_coordinate",
        "last_location_id",
        "location_id",
        "is_rip",
        "person.main_profile_id",
        "is_system_data",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "person.preferred_lang_code"
    ),
    "test_mysql_general_view": (
        "test_mysql_id",
        "number",
        "identifier",
        "name",
        "group",
        "unique_int_column",
        "point",
        "polygon",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "lang_code",
        "title"
    ),
    "test_mysql_table": (
        "test_mysql_id",
        "number",
        "identifier",
        "name",
        "group",
        "unique_int_column",
        "point",
        "polygon",
        "test_mysql.main_email_address",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "test_county_ml_table": (
        "test_county_ml_id",
        "number",
        "identifier",
        "test_county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "test_county_with_deleted_and_test_data_view": (
        "test_county_id",
        "number",
        "test_state_id",
        "test_country_id",
        "name",
        "coordinate",
        "new_test_county_id",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "test_county_location_mapping_with_deleted_and_test_data_view": (
        "test_county_location_mapping_id",
        "test_county_id",
        "test_location_id",
        "is_test_data"
    ),
    "test_county_location_mapping_table": (
        "test_county_location_mapping_id",
        "test_county_id",
        "test_location_id",
        "is_test_data"
    ),
    "test_county_table": (
        "test_county_id",
        "number",
        "test_state_id",
        "test_country_id",
        "name",
        "coordinate",
        "new_test_county_id",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "user_external_latest_token_general_view": (
        "user_external_id",
        "system_id",
        "subsystem_id",
        "username",
        "refresh_token",
        "is_refresh_token_valid",
        "user_external.is_test_data",
        "cloud_project__user_external.name",
        "cloud_project__user_external.description",
        "cloud_project_user_external__access_token.end_timestamp",
        "access_token",
        "base_credential_token",
        "oauth_state",
        "expiry",
        "updated_timestamp",
        "cloud_project_user_external__access_token.is_test_data",
        "profile_user_external_id",
        "profile_id",
        "profile_user_external.is_test_data",
        "end_timestamp"
    ),
    "profile_user_external_table": (
        "profile_user_external_id",
        "number",
        "identifier",
        "user_external_id",
        "profile_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_test_data"
    ),
    "person_table": (
        "person_id",
        "number",
        "identifier",
        "name",
        "is_approved",
        "is_identity_confirmed",
        "birthday_original",
        "birthday_timestamp",
        "birthday_date",
        "day",
        "month",
        "year",
        "year_cira",
        "gender_id",
        "first_name",
        "is_first_name_approved",
        "nickname",
        "is_nickname_approved",
        "father_name",
        "last_name",
        "last_name_original",
        "is_last_name_approved",
        "is_last_name_sure",
        "is_last_name_auto_generated",
        "person.main_email_address",
        "person.main_email_address_id",
        "main_full_number_normalized",
        "last_coordinate",
        "last_location_id",
        "location_id",
        "is_rip",
        "person.main_profile_id",
        "is_system_data",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "person.preferred_lang_code"
    ),
    "test_gender_view": (
        "test_gender_id",
        "name",
        "number",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "test_gender_table": (
        "test_gender_id",
        "name",
        "number",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "environment_table": (
        "environment_id",
        "name",
        "github_branch",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp"
    ),
    "user_external_pii_table": (
        "user_external_pii_id",
        "number",
        "identifier",
        "user_external_id",
        "password_clear_text",
        "password_encrypted",
        "access_token_old",
        "base_credentials_token",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "refresh_token"
    ),
    "campaign_general_with_deleted_and_test_data_view": (
        "campaign_id",
        "name",
        "criteria_id_old",
        "start_hour",
        "end_hour",
        "occurrence_id",
        "days_of_week",
        "max_audience",
        "max_exposure_per_day",
        "minimal_days_between_messages_to_the_same_recipient",
        "message_template_id_old",
        "dialog_workflow_script_id",
        "default_sender_profile_id",
        "is_dialog_workflow",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_state_id"
    ),
    "campaign_general_view": (
        "campaign_id",
        "name",
        "criteria_id_old",
        "start_hour",
        "end_hour",
        "occurrence_id",
        "days_of_week",
        "max_audience",
        "max_exposure_per_day",
        "minimal_days_between_messages_to_the_same_recipient",
        "message_template_id_old",
        "dialog_workflow_script_id",
        "default_sender_profile_id",
        "is_dialog_workflow",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_state_id"
    ),
    "campaign_criteria_set_criteria_general_view": (
        "campaign_criteria_set_id",
        "campaign_id",
        "criteria_id_old",
        "criteria_set_id",
        "is_test_data",
        "campaign.name",
        "criteria_set.name",
        "parent_criteria_set_id",
        "parent_name",
        "child_criteria_set_id",
        "child_name",
        "criteria_id",
        "name",
        "entity_type_id",
        "entity_type_name",
        "group_list_id",
        "location_id",
        "location_list_id",
        "coordinate",
        "radius",
        "radius_measure",
        "radius_km",
        "job_group_list_id",
        "job_location_list_id",
        "vacancy_list_id",
        "workplace_profile_list_id",
        "start_date_type_id",
        "job_types_id",
        "user_external_id",
        "visibility_id",
        "where_sql",
        "template_condition",
        "criteria.is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "internet_domain_id",
        "internet_domain_list_id",
        "organization_name",
        "group_id",
        "profile_list_id",
        "international_code"
    ),
    "criteria_set_profile_table": (
        "criteria_set_profile_id",
        "name",
        "number",
        "identifier",
        "batch_timestamp",
        "criteria_set_id",
        "profile_id",
        "visibility_id",
        "is_test_data",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "phone_profile_table": (
        "phone_profile_id",
        "profile_id",
        "phone_id",
        "name",
        "is_main",
        "is_verified",
        "label_phone_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "criteria_profile_table": (
        "criteria_profile_id",
        "name",
        "number",
        "identifier",
        "batch_timestamp",
        "criteria_id",
        "profile_id",
        "visibility_id",
        "is_approved",
        "description",
        "is_test_data",
        "created_timestamp",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "campaign_criteria_set_criteria_profile_general_view": (
        "campaign_id",
        "criteria_set_id",
        "criteria_set_profile.profile_id",
        "criteria_id",
        "criteria_profile.profile_id"
    ),
    "profile_list_member_view": (
        "profile_list_member_id",
        "profile_list_id",
        "profile_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "message_table": (
        "message_id",
        "number",
        "identifier",
        "parent_message_id",
        "message_message_relationship_id",
        "from_profile_id",
        "from_email",
        "from_phone_number",
        "from_provider_id",
        "from_user_external_id",
        "from_system_id",
        "conversation_id",
        "to_phone_number",
        "to_provider_id",
        "to_profile_id",
        "to_profile_list_id",
        "to_email",
        "cc_profile_id",
        "cc_profile_list_id",
        "cc_email",
        "bcc_profile_id",
        "bcc_profile_list_id",
        "bcc_email",
        "group_list_id",
        "occurrence_id",
        "location_id",
        "message_channel_id",
        "message_type_id",
        "is_push_notification",
        "group_id",
        "session_id",
        "visibility_id",
        "is_pin",
        "mailbox_id",
        "is_gen_ai",
        "is_dialog_workflow",
        "machine_learning_model_id",
        "is_require_moderator",
        "moderator_profile_id",
        "moderator_feedback_type",
        "moderator_feedback_text",
        "is_moderator_approved",
        "queue_status_id",
        "message_status_id",
        "process_id",
        "stdout",
        "stderr",
        "return_code",
        "returned_value",
        "return_message",
        "profile_id",
        "server_ip_v4",
        "server_ip_v6",
        "thread_id",
        "user_jwt",
        "component_id",
        "class_parameters_json",
        "function_parameters_json",
        "action_id",
        "campaign_id",
        "campaign_criteria_set_id",
        "requested_channel_id",
        "actual_channel_id",
        "email_message_id",
        "body",
        "subject",
        "compound_message",
        "compound_message_json_version",
        "compound_message_json",
        "session",
        "channel_id",
        "last_dialog_workflow_state_id",
        "next_dialog_workflow_state_id",
        "from_subsystem_id",
        "updated_effective_profile_id",
        "original_message_id",
        "is_test_data",
        "request_to_send_timestamp",
        "scheduled_sent_timestamp",
        "actual_sent_timestamp",
        "message_template_id",
        "from_api_type_id",
        "inforu_customer_id_old",
        "inforu_project_id_old",
        "inforu_channel_old",
        "inforu_type_old",
        "inforu_value_old",
        "inforu_keyword_old",
        "inforu_network_old",
        "inforu_short_code_old",
        "inforu_application_id_old",
        "inforu_customer_param_old",
        "inforu_mo_session_id_old",
        "inforu_incoming_json_old",
        "is_user_request",
        "user_request_price_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id"
    ),
    "field_alias_table": (
        "field_alias_id",
        "field_name",
        "system_id",
        "subsystem_id",
        "field_id",
        "visibility_id",
        "profile_id"
    ),
    "internet_domain_table": (
        "internet_domain_id",
        "number",
        "identifier",
        "domain",
        "top_level_domain",
        "is_commercial_webmail",
        "profile_id",
        "profile_list_id",
        "is_email_assign_profile_organization_to_people",
        "is_url_assign_profile_organization_to_people",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "organization_id"
    ),
    "component_table": (
        "component_id",
        "name",
        "repo_name",
        "programming_language",
        "programming_language_id",
        "github_repo",
        "parent_component_id",
        "component_type",
        "component_category",
        "testing_framework",
        "api_type",
        "developer_email",
        "developer_profile_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "data_source_type_table": (
        "data_source_type_id",
        "name",
        "system_id",
        "subsystem_id",
        "data_source_category_id",
        "is_test_data",
        "visibility_id",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "folder_table": (
        "folder_id",
        "name",
        "parent_folder_id",
        "google_drive_folder_id"
    ),
    "sql2code_file_table": (
        "sql2code_repo_id",
        "sql2code_id",
        "repo",
        "folder",
        "filename",
        "programming_language_id",
        "structure_name",
        "folder_id"
    ),
    "folder__storage_table": (
        "folder_id",
        "storage_id"
    ),
    "logger_table": (
        "logger_id",
        "number",
        "identifier",
        "client_ip_v4",
        "client_ip_v6",
        "server_ip_v4",
        "server_ip_v6",
        "location_id",
        "user_id",
        "profile_id",
        "activity",
        "activity_id",
        "action_id",
        "message",
        "record",
        "payload",
        "component_id",
        "component_name",
        "path",
        "filename",
        "class_name",
        "function_name",
        "line_number",
        "error_stack",
        "severity_id",
        "status_id",
        "group_id",
        "relationship_type_id",
        "timestamp",
        "state_id",
        "variable_id",
        "variable_value_old",
        "variable_value_new",
        "field_id",
        "field_value_old",
        "field_value_new",
        "session",
        "thread_id",
        "process_id",
        "api_type",
        "api_type_id",
        "group_id1",
        "group_id2",
        "component_category",
        "testing_framework",
        "component_type",
        "computer_language",
        "developer_email",
        "sql_statement",
        "sql_parameters",
        "sql_formatted",
        "smartlink_identifier",
        "stdout",
        "stderr",
        "return_code",
        "returned_value",
        "return_message",
        "recipient",
        "source_email",
        "destination_emails",
        "message_id",
        "message_template_id",
        "criteria_id",
        "form_id",
        "question_id",
        "message_template_text_block_id",
        "compound_message",
        "text_block_id",
        "reaction_id",
        "result",
        "real_name",
        "user_identifier",
        "locals_before_exception",
        "is_assertion_error",
        "smartlink_id",
        "json_version",
        "package_json",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "start_datetime",
        "end_datetime",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "environment_name",
        "developer_email_address"
    ),
    "logger_debuging_view": (
        "logger_id",
        "timestamp",
        "message",
        "record",
        "component_name",
        "function_name",
        "severity_id",
        "api_type",
        "component_category",
        "computer_language",
        "created_effective_user_id",
        "created_effective_profile_id",
        "created_real_user_id",
        "developer_email",
        "developer_email_address"
    ),
    "data_source_type__field_general_view": (
        "data_source_field_id",
        "data_source_type_id",
        "field_id",
        "name",
        "external_field_name",
        "position"
    ),
    "data_source_type__field_view": (
        "data_source_field_id",
        "data_source_type_id",
        "field_id",
        "external_field_name",
        "position"
    ),
    "test_county_play1_table": (
        "test_county_id",
        "number",
        "test_state_id",
        "test_country_id",
        "name",
        "coordinate",
        "new_test_county_id",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "test_county_play1_ml_table": (
        "test_county_ml_id",
        "number",
        "identifier",
        "test_county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "continent_table": (
        "continent_id",
        "identifier",
        "coordinate",
        "iso",
        "name",
        "nicename",
        "iso3",
        "numcode",
        "phonecode",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id"
    ),
    "continent_ml_table": (
        "continent_ml_id",
        "number",
        "identifier",
        "country_id",
        "country_id_old",
        "lang_code",
        "is_main",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "machine_learning_model_table": (
        "machine_learning_model_id",
        "name",
        "source_code_path_old",
        "network",
        "model_data",
        "model_path",
        "learning_rate",
        "epochs",
        "batch_size",
        "path_to_model",
        "input_shape",
        "test_data",
        "train_data",
        "loss",
        "accuracy",
        "enabler",
        "provider",
        "model_name",
        "version",
        "model_data_storage_id",
        "training_data_storage_id",
        "model_storage_id",
        "is_machine_learning",
        "source_code_id",
        "is_sql",
        "sql_statement"
    ),
    "prompt_execution__storage_table": (
        "prompt_execution__storage_id",
        "prompt_id",
        "storage_id"
    ),
    "prompt_execution_table": (
        "prompt_execution_id",
        "prompt_id",
        "conversation_id",
        "timestamp"
    ),
    "field_table": (
        "field_id",
        "number",
        "identifier",
        "name",
        "description",
        "variable_id",
        "is_ml_table",
        "table_id",
        "database_field_name",
        "database_sub_field_name",
        "database_sub_field_value",
        "processing_id",
        "processing_database_field_name",
        "internal_description",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "visibility_id",
        "enity_type_id"
    ),
    "email_address_table": (
        "email_address_id",
        "number",
        "identifier",
        "name",
        "email_address",
        "email_address_approved",
        "verification_pin",
        "verification_expiration",
        "is_verified",
        "text_block_id",
        "is_system_data",
        "is_shared_email_address",
        "profile_id_old",
        "internet_domain_id",
        "username",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "is_calendar",
        "data_source_instance_id"
    ),
    "event_table": (
        "event_id",
        "number",
        "identifier",
        "name",
        "location_id",
        "organizers_profile_id",
        "website_url",
        "facebook_event_url",
        "meetup_event_url",
        "registration_url",
        "is_event_approved",
        "access_start_timestamp",
        "timezone",
        "segement",
        "genre",
        "sub_genre",
        "type",
        "sub_type",
        "is_family",
        "parent_event_id",
        "is_require_end_user_registration",
        "is_require_organizer_registration_confirmation",
        "is_paid",
        "is_require_end_user_arrival_confirmation",
        "is_can_be_paid_at_the_entrance_in_cash",
        "is_event_has_promoters",
        "new_event_id",
        "is_beakfast",
        "is_lunch",
        "is_dinner",
        "is_waitinglist",
        "visibility_id",
        "is_test_data",
        "end_timestamp",
        "is_show_end_timestamp",
        "start_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "location_id_temp",
        "description",
        "data_source_instance_id"
    ),
    "phone_table": (
        "phone_id",
        "number",
        "number_original",
        "international_code",
        "area_code",
        "local_number_normalized",
        "extension",
        "full_number_normalized",
        "is_test_data",
        "is_valid",
        "is_verified_old",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "data_source_instance_id"
    ),
    "person_phone_table": (
        "person_phone_id",
        "number",
        "identifier",
        "person_id",
        "phone_id",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "data_source_instance_id"
    ),
    "data_source_type__unique_index_table": (
        "data_source_type_unique_index_id",
        "data_source_type_id",
        "unique_index_id",
        "field_id"
    ),
    "token__user_external_old_table": (
        "token__user_external_id",
        "user_external_id",
        "name",
        "description",
        "end_timestamp",
        "access_token",
        "base_credential_token",
        "oauth_state",
        "expiry",
        "refresh_token_old",
        "updated_timestamp",
        "is_test_data",
        "project",
        "scope_json"
    ),
    "token__user_external_old_view": (
        "token__user_external_id",
        "user_external_id",
        "name",
        "description",
        "end_timestamp",
        "access_token",
        "base_credential_token",
        "oauth_state",
        "expiry",
        "refresh_token_old",
        "updated_timestamp",
        "is_test_data",
        "project",
        "scope_json"
    ),
    "token__user_external_old_general_view": (
        "token__user_external_id",
        "user_external_id",
        "name",
        "description",
        "end_timestamp",
        "access_token",
        "base_credential_token",
        "oauth_state",
        "expiry",
        "refresh_token_old",
        "updated_timestamp",
        "is_test_data",
        "project",
        "scope_json"
    ),
    "user_external_table": (
        "user_external_id",
        "number",
        "identifier",
        "system_id",
        "subsystem_id",
        "username",
        "email_address_id",
        "handle",
        "access_token_old",
        "base_credentials_token_old",
        "token_2delete",
        "refresh_token_old",
        "is_refresh_token_valid",
        "expiry_old",
        "oauth_token",
        "oauth_token_secret",
        "oauth_callback_confirmed",
        "oauth_state",
        "environment_id_old",
        "main_profile_id",
        "url_id",
        "credential_storage_id",
        "additional_fields_json",
        "description",
        "customer_id",
        "project_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id",
        "person_url_id",
        "profile_url_id"
    ),
    "test_county_dvlp1_ml_table": (
        "test_county_ml_id",
        "number",
        "identifier",
        "test_county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "test_county_dvlp1_table": (
        "test_county_id",
        "number",
        "test_state_id",
        "test_country_id",
        "name",
        "coordinate",
        "new_test_county_id",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "test_county_play1_view": (
        "test_county_id",
        "number",
        "test_state_id",
        "test_country_id",
        "name",
        "coordinate",
        "new_test_county_id",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "test_county_play1_ml_view": (
        "test_county_ml_id",
        "number",
        "identifier",
        "test_county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "test_county_dvlp1_view": (
        "test_county_id",
        "number",
        "test_state_id",
        "test_country_id",
        "name",
        "coordinate",
        "new_test_county_id",
        "group_id",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "end_timestamp"
    ),
    "test_county_dvlp1_ml_view": (
        "test_county_ml_id",
        "number",
        "identifier",
        "test_county_id",
        "lang_code",
        "title",
        "is_title_approved",
        "visibility_id",
        "is_test_data",
        "start_timestamp",
        "end_timestamp",
        "created_timestamp",
        "created_user_id",
        "created_real_user_id",
        "created_effective_user_id",
        "created_effective_profile_id",
        "updated_timestamp",
        "updated_user_id",
        "updated_real_user_id",
        "updated_effective_user_id",
        "updated_effective_profile_id"
    ),
    "cloud_project_table": (
        "cloud_project_id",
        "name",
        "cloud_vendor_id",
        "cloud_vendor_name",
        "description"
    ),
    "cloud_project__user_external_table": (
        "cloud_project__user_external_id",
        "cloud_project",
        "scope_json",
        "refresh_token",
        "user_external_id",
        "is_refresh_token_valid",
        "name",
        "description",
        "end_timestamp"
    ),
    "cloud_project__user_external_view": (
        "cloud_project__user_external_id",
        "cloud_project",
        "scope_json",
        "refresh_token",
        "user_external_id",
        "is_refresh_token_valid"
    ),
    "cloud_project_user_external__access_token_view": (
        "cloud_project_user_external__access_token_id",
        "cloud_project__user_external_id",
        "access_token",
        "name",
        "description",
        "end_timestamp",
        "base_credential_token",
        "oauth_state",
        "expiry",
        "refresh_token_old",
        "updated_timestamp",
        "is_test_data",
        "cloud_project",
        "scope_json"
    ),
    "cloud_project_user_external__access_token_table": (
        "cloud_project_user_external__access_token_id",
        "cloud_project__user_external_id",
        "access_token",
        "name",
        "description",
        "end_timestamp",
        "base_credential_token",
        "oauth_state",
        "expiry",
        "refresh_token_old",
        "updated_timestamp",
        "is_test_data",
        "cloud_project",
        "scope_json"
    ),
    "user_external_latest_token_general_old_view": (
        "user_external_id",
        "system_id",
        "subsystem_id",
        "username",
        "refresh_token",
        "is_refresh_token_valid",
        "user_external.is_test_data",
        "name",
        "description",
        "token__user_external.end_timestamp",
        "access_token",
        "base_credential_token",
        "oauth_state",
        "expiry",
        "updated_timestamp",
        "token__user_external.is_test_data",
        "profile_user_external_id",
        "profile_id",
        "profile_user_external.is_test_data",
        "end_timestamp"
    ),
    "prompt_prompt_table": (
        "prompt_prompt_id",
        "prompt_id",
        "parent_prompt_id",
        "entity_attributes_json"
    ),
    "json_schema_table": (
        "json_schema_id",
        "json_schema"
    ),
    "storage_table": (
        "storage_id",
        "storage_type_id",
        "path",
        "filename",
        "file_extension_id",
        "file_type_id",
        "region",
        "url",
        "ratio_x",
        "ration_y",
        "width",
        "height",
        "html_map_tag",
        "user_external_id",
        "is_manual_approved",
        "is_ai_approved",
        "is_google_sheet",
        "entity_type_id",
        "activity_id",
        "activity_type_id",
        "is_inbound_sync",
        "is_outbound_sync",
        "is_blur_not_direct_connect",
        "is_test_data",
        "created_timestamp",
        "created_user_id",
        "updated_timestamp",
        "updated_user_id",
        "start_timestamp",
        "end_timestamp",
        "folder_id",
        "visibility_id",
        "document-type_id",
        "google_drive_document_id",
        "smart_datastore_json",
        "sector_id"
    ),
    "prompt_table": (
        "prompt_id",
        "prompt",
        "prompt_type",
        "prompt_llm",
        "machine_learning_model_id",
        "entity_attributes_json",
        "output_json_schema",
        "output_json_schema_id"
    )
}
