# Generated by Django 3.0.2 on 2020-01-07 08:18

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
import django.contrib.postgres.search
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import papermerge.core.mixins
import papermerge.core.models
import polymorphic_tree.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('current_storage_size', models.BigIntegerField(default=0)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='BaseTreeNode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200, verbose_name='Title')),
                ('lang', models.CharField(default='deu', max_length=8, verbose_name='Language')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('ancestors_deu', django.contrib.postgres.search.SearchVectorField(null=True)),
                ('ancestors_eng', django.contrib.postgres.search.SearchVectorField(null=True)),
                ('title_deu', django.contrib.postgres.search.SearchVectorField(null=True)),
                ('title_eng', django.contrib.postgres.search.SearchVectorField(null=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', polymorphic_tree.models.PolymorphicTreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='core.BaseTreeNode', verbose_name='parent')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_core.basetreenode_set+', to='contenttypes.ContentType')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Documents',
                'verbose_name_plural': 'Documents',
                'ordering': ('tree_id', 'lft'),
                'abstract': False,
                'base_manager_name': 'objects',
            },
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                ('basetreenode_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.BaseTreeNode')),
                ('file_orig', models.FileField(help_text='Reference to originaly imported file', max_length=512, upload_to='')),
                ('file_name', models.CharField(default='', max_length=1024)),
                ('notes', models.TextField(blank=True, null=True, verbose_name='Notes')),
                ('size', models.BigIntegerField(help_text='Size of file_orig attached. Size is in Bytes')),
                ('digest', models.CharField(blank=True, help_text='Digest of file_orig attached. Size is in Bytes.It is used to figure out if file was already processed.', max_length=512, null=True, unique=True)),
                ('page_count', models.IntegerField(default=1)),
                ('text', models.TextField()),
                ('celery_task_id', models.UUIDField(blank=True, default=None, null=True)),
                ('text_deu', django.contrib.postgres.search.SearchVectorField(null=True)),
                ('text_eng', django.contrib.postgres.search.SearchVectorField(null=True)),
            ],
            options={
                'verbose_name': 'Document',
                'verbose_name_plural': 'Documents',
            },
            bases=(papermerge.core.mixins.ExtractIds, 'core.basetreenode'),
        ),
        migrations.CreateModel(
            name='Folder',
            fields=[
                ('basetreenode_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.BaseTreeNode')),
            ],
            options={
                'verbose_name': 'Folder',
                'verbose_name_plural': 'Folders',
            },
            bases=(papermerge.core.mixins.ExtractIds, 'core.basetreenode'),
        ),
        migrations.CreateModel(
            name='Access',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('access_type', models.CharField(choices=[('allow', 'Allow'), ('deny', 'Deny')], default='allow', max_length=16)),
                ('access_inherited', models.BooleanField(default=False)),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.Group', verbose_name='group')),
                ('node', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.BaseTreeNode')),
                ('permissions', models.ManyToManyField(to='auth.Permission')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'permissions': [('read', 'Read Access'), ('write', 'Write Access'), ('delete', 'Delete Access'), ('change_perm', 'Change Permissions Access'), ('take_ownership', 'Take Ownership Access')],
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('number', models.IntegerField(default=1)),
                ('page_count', models.IntegerField(default=1)),
                ('text', models.TextField(default='')),
                ('lang', models.CharField(default='deu', max_length=8)),
                ('text_deu', django.contrib.postgres.search.SearchVectorField(null=True)),
                ('text_eng', django.contrib.postgres.search.SearchVectorField(null=True)),
                ('image', models.CharField(default='', max_length=1024)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Document')),
            ],
        ),
    ]
