# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UptimeCheckArgs', 'UptimeCheck']

@pulumi.input_type
class UptimeCheckArgs:
    def __init__(__self__, *,
                 check_interval: pulumi.Input[int],
                 monitored_resource: pulumi.Input['UptimeCheckMonitoredResourceArgs'],
                 confirmation: Optional[pulumi.Input[int]] = None,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_check: Optional[pulumi.Input['UptimeCheckDnsCheckArgs']] = None,
                 http_check: Optional[pulumi.Input['UptimeCheckHttpCheckArgs']] = None,
                 icmp_check: Optional[pulumi.Input['UptimeCheckIcmpCheckArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tcp_check: Optional[pulumi.Input['UptimeCheckTcpCheckArgs']] = None,
                 trigger_rate: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a UptimeCheck resource.
        :param pulumi.Input[int] check_interval: Number of seconds between checks
        :param pulumi.Input['UptimeCheckMonitoredResourceArgs'] monitored_resource: Monitored resource configuration block. The describes server under test
        :param pulumi.Input[int] confirmation: Number of confirmation servers to confirm downtime before an alert is triggered
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_groups: List of contact group IDs
        :param pulumi.Input['UptimeCheckDnsCheckArgs'] dns_check: DNS check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input['UptimeCheckHttpCheckArgs'] http_check: HTTP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input['UptimeCheckIcmpCheckArgs'] icmp_check: ICMP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[str] name: Name of the check
        :param pulumi.Input[bool] paused: Whether the check should be run
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: List of regions on which to run checks. The values required for this parameter can be retrieved from the `GET
               /v1/uptime-locations` endpoint
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags
        :param pulumi.Input['UptimeCheckTcpCheckArgs'] tcp_check: TCP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[int] trigger_rate: The number of minutes to wait before sending an alert
        """
        pulumi.set(__self__, "check_interval", check_interval)
        pulumi.set(__self__, "monitored_resource", monitored_resource)
        if confirmation is not None:
            pulumi.set(__self__, "confirmation", confirmation)
        if contact_groups is not None:
            pulumi.set(__self__, "contact_groups", contact_groups)
        if dns_check is not None:
            pulumi.set(__self__, "dns_check", dns_check)
        if http_check is not None:
            pulumi.set(__self__, "http_check", http_check)
        if icmp_check is not None:
            pulumi.set(__self__, "icmp_check", icmp_check)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tcp_check is not None:
            pulumi.set(__self__, "tcp_check", tcp_check)
        if trigger_rate is not None:
            pulumi.set(__self__, "trigger_rate", trigger_rate)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> pulumi.Input[int]:
        """
        Number of seconds between checks
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "check_interval", value)

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> pulumi.Input['UptimeCheckMonitoredResourceArgs']:
        """
        Monitored resource configuration block. The describes server under test
        """
        return pulumi.get(self, "monitored_resource")

    @monitored_resource.setter
    def monitored_resource(self, value: pulumi.Input['UptimeCheckMonitoredResourceArgs']):
        pulumi.set(self, "monitored_resource", value)

    @property
    @pulumi.getter
    def confirmation(self) -> Optional[pulumi.Input[int]]:
        """
        Number of confirmation servers to confirm downtime before an alert is triggered
        """
        return pulumi.get(self, "confirmation")

    @confirmation.setter
    def confirmation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "confirmation", value)

    @property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of contact group IDs
        """
        return pulumi.get(self, "contact_groups")

    @contact_groups.setter
    def contact_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contact_groups", value)

    @property
    @pulumi.getter(name="dnsCheck")
    def dns_check(self) -> Optional[pulumi.Input['UptimeCheckDnsCheckArgs']]:
        """
        DNS check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "dns_check")

    @dns_check.setter
    def dns_check(self, value: Optional[pulumi.Input['UptimeCheckDnsCheckArgs']]):
        pulumi.set(self, "dns_check", value)

    @property
    @pulumi.getter(name="httpCheck")
    def http_check(self) -> Optional[pulumi.Input['UptimeCheckHttpCheckArgs']]:
        """
        HTTP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "http_check")

    @http_check.setter
    def http_check(self, value: Optional[pulumi.Input['UptimeCheckHttpCheckArgs']]):
        pulumi.set(self, "http_check", value)

    @property
    @pulumi.getter(name="icmpCheck")
    def icmp_check(self) -> Optional[pulumi.Input['UptimeCheckIcmpCheckArgs']]:
        """
        ICMP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "icmp_check")

    @icmp_check.setter
    def icmp_check(self, value: Optional[pulumi.Input['UptimeCheckIcmpCheckArgs']]):
        pulumi.set(self, "icmp_check", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the check
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the check should be run
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of regions on which to run checks. The values required for this parameter can be retrieved from the `GET
        /v1/uptime-locations` endpoint
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tcpCheck")
    def tcp_check(self) -> Optional[pulumi.Input['UptimeCheckTcpCheckArgs']]:
        """
        TCP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "tcp_check")

    @tcp_check.setter
    def tcp_check(self, value: Optional[pulumi.Input['UptimeCheckTcpCheckArgs']]):
        pulumi.set(self, "tcp_check", value)

    @property
    @pulumi.getter(name="triggerRate")
    def trigger_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The number of minutes to wait before sending an alert
        """
        return pulumi.get(self, "trigger_rate")

    @trigger_rate.setter
    def trigger_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "trigger_rate", value)


@pulumi.input_type
class _UptimeCheckState:
    def __init__(__self__, *,
                 check_interval: Optional[pulumi.Input[int]] = None,
                 confirmation: Optional[pulumi.Input[int]] = None,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_check: Optional[pulumi.Input['UptimeCheckDnsCheckArgs']] = None,
                 http_check: Optional[pulumi.Input['UptimeCheckHttpCheckArgs']] = None,
                 icmp_check: Optional[pulumi.Input['UptimeCheckIcmpCheckArgs']] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['UptimeCheckLocationArgs']]]] = None,
                 monitored_resource: Optional[pulumi.Input['UptimeCheckMonitoredResourceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tcp_check: Optional[pulumi.Input['UptimeCheckTcpCheckArgs']] = None,
                 trigger_rate: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering UptimeCheck resources.
        :param pulumi.Input[int] check_interval: Number of seconds between checks
        :param pulumi.Input[int] confirmation: Number of confirmation servers to confirm downtime before an alert is triggered
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_groups: List of contact group IDs
        :param pulumi.Input['UptimeCheckDnsCheckArgs'] dns_check: DNS check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input['UptimeCheckHttpCheckArgs'] http_check: HTTP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input['UptimeCheckIcmpCheckArgs'] icmp_check: ICMP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[Sequence[pulumi.Input['UptimeCheckLocationArgs']]] locations: List of assigned monitoring locations on which to run checks
        :param pulumi.Input['UptimeCheckMonitoredResourceArgs'] monitored_resource: Monitored resource configuration block. The describes server under test
        :param pulumi.Input[str] name: Name of the check
        :param pulumi.Input[bool] paused: Whether the check should be run
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: List of regions on which to run checks. The values required for this parameter can be retrieved from the `GET
               /v1/uptime-locations` endpoint
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags
        :param pulumi.Input['UptimeCheckTcpCheckArgs'] tcp_check: TCP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[int] trigger_rate: The number of minutes to wait before sending an alert
        """
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if confirmation is not None:
            pulumi.set(__self__, "confirmation", confirmation)
        if contact_groups is not None:
            pulumi.set(__self__, "contact_groups", contact_groups)
        if dns_check is not None:
            pulumi.set(__self__, "dns_check", dns_check)
        if http_check is not None:
            pulumi.set(__self__, "http_check", http_check)
        if icmp_check is not None:
            pulumi.set(__self__, "icmp_check", icmp_check)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if monitored_resource is not None:
            pulumi.set(__self__, "monitored_resource", monitored_resource)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tcp_check is not None:
            pulumi.set(__self__, "tcp_check", tcp_check)
        if trigger_rate is not None:
            pulumi.set(__self__, "trigger_rate", trigger_rate)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds between checks
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "check_interval", value)

    @property
    @pulumi.getter
    def confirmation(self) -> Optional[pulumi.Input[int]]:
        """
        Number of confirmation servers to confirm downtime before an alert is triggered
        """
        return pulumi.get(self, "confirmation")

    @confirmation.setter
    def confirmation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "confirmation", value)

    @property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of contact group IDs
        """
        return pulumi.get(self, "contact_groups")

    @contact_groups.setter
    def contact_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contact_groups", value)

    @property
    @pulumi.getter(name="dnsCheck")
    def dns_check(self) -> Optional[pulumi.Input['UptimeCheckDnsCheckArgs']]:
        """
        DNS check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "dns_check")

    @dns_check.setter
    def dns_check(self, value: Optional[pulumi.Input['UptimeCheckDnsCheckArgs']]):
        pulumi.set(self, "dns_check", value)

    @property
    @pulumi.getter(name="httpCheck")
    def http_check(self) -> Optional[pulumi.Input['UptimeCheckHttpCheckArgs']]:
        """
        HTTP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "http_check")

    @http_check.setter
    def http_check(self, value: Optional[pulumi.Input['UptimeCheckHttpCheckArgs']]):
        pulumi.set(self, "http_check", value)

    @property
    @pulumi.getter(name="icmpCheck")
    def icmp_check(self) -> Optional[pulumi.Input['UptimeCheckIcmpCheckArgs']]:
        """
        ICMP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "icmp_check")

    @icmp_check.setter
    def icmp_check(self, value: Optional[pulumi.Input['UptimeCheckIcmpCheckArgs']]):
        pulumi.set(self, "icmp_check", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UptimeCheckLocationArgs']]]]:
        """
        List of assigned monitoring locations on which to run checks
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UptimeCheckLocationArgs']]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> Optional[pulumi.Input['UptimeCheckMonitoredResourceArgs']]:
        """
        Monitored resource configuration block. The describes server under test
        """
        return pulumi.get(self, "monitored_resource")

    @monitored_resource.setter
    def monitored_resource(self, value: Optional[pulumi.Input['UptimeCheckMonitoredResourceArgs']]):
        pulumi.set(self, "monitored_resource", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the check
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the check should be run
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of regions on which to run checks. The values required for this parameter can be retrieved from the `GET
        /v1/uptime-locations` endpoint
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tcpCheck")
    def tcp_check(self) -> Optional[pulumi.Input['UptimeCheckTcpCheckArgs']]:
        """
        TCP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "tcp_check")

    @tcp_check.setter
    def tcp_check(self, value: Optional[pulumi.Input['UptimeCheckTcpCheckArgs']]):
        pulumi.set(self, "tcp_check", value)

    @property
    @pulumi.getter(name="triggerRate")
    def trigger_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The number of minutes to wait before sending an alert
        """
        return pulumi.get(self, "trigger_rate")

    @trigger_rate.setter
    def trigger_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "trigger_rate", value)


class UptimeCheck(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 check_interval: Optional[pulumi.Input[int]] = None,
                 confirmation: Optional[pulumi.Input[int]] = None,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckDnsCheckArgs']]] = None,
                 http_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckHttpCheckArgs']]] = None,
                 icmp_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckIcmpCheckArgs']]] = None,
                 monitored_resource: Optional[pulumi.Input[pulumi.InputType['UptimeCheckMonitoredResourceArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tcp_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckTcpCheckArgs']]] = None,
                 trigger_rate: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a UptimeCheck resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] check_interval: Number of seconds between checks
        :param pulumi.Input[int] confirmation: Number of confirmation servers to confirm downtime before an alert is triggered
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_groups: List of contact group IDs
        :param pulumi.Input[pulumi.InputType['UptimeCheckDnsCheckArgs']] dns_check: DNS check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[pulumi.InputType['UptimeCheckHttpCheckArgs']] http_check: HTTP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[pulumi.InputType['UptimeCheckIcmpCheckArgs']] icmp_check: ICMP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[pulumi.InputType['UptimeCheckMonitoredResourceArgs']] monitored_resource: Monitored resource configuration block. The describes server under test
        :param pulumi.Input[str] name: Name of the check
        :param pulumi.Input[bool] paused: Whether the check should be run
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: List of regions on which to run checks. The values required for this parameter can be retrieved from the `GET
               /v1/uptime-locations` endpoint
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags
        :param pulumi.Input[pulumi.InputType['UptimeCheckTcpCheckArgs']] tcp_check: TCP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[int] trigger_rate: The number of minutes to wait before sending an alert
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UptimeCheckArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a UptimeCheck resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param UptimeCheckArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UptimeCheckArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 check_interval: Optional[pulumi.Input[int]] = None,
                 confirmation: Optional[pulumi.Input[int]] = None,
                 contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckDnsCheckArgs']]] = None,
                 http_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckHttpCheckArgs']]] = None,
                 icmp_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckIcmpCheckArgs']]] = None,
                 monitored_resource: Optional[pulumi.Input[pulumi.InputType['UptimeCheckMonitoredResourceArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tcp_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckTcpCheckArgs']]] = None,
                 trigger_rate: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UptimeCheckArgs.__new__(UptimeCheckArgs)

            if check_interval is None and not opts.urn:
                raise TypeError("Missing required property 'check_interval'")
            __props__.__dict__["check_interval"] = check_interval
            __props__.__dict__["confirmation"] = confirmation
            __props__.__dict__["contact_groups"] = contact_groups
            __props__.__dict__["dns_check"] = dns_check
            __props__.__dict__["http_check"] = http_check
            __props__.__dict__["icmp_check"] = icmp_check
            if monitored_resource is None and not opts.urn:
                raise TypeError("Missing required property 'monitored_resource'")
            __props__.__dict__["monitored_resource"] = monitored_resource
            __props__.__dict__["name"] = name
            __props__.__dict__["paused"] = paused
            __props__.__dict__["regions"] = regions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tcp_check"] = tcp_check
            __props__.__dict__["trigger_rate"] = trigger_rate
            __props__.__dict__["locations"] = None
        super(UptimeCheck, __self__).__init__(
            'statuscake:index/uptimeCheck:UptimeCheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            check_interval: Optional[pulumi.Input[int]] = None,
            confirmation: Optional[pulumi.Input[int]] = None,
            contact_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            dns_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckDnsCheckArgs']]] = None,
            http_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckHttpCheckArgs']]] = None,
            icmp_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckIcmpCheckArgs']]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UptimeCheckLocationArgs']]]]] = None,
            monitored_resource: Optional[pulumi.Input[pulumi.InputType['UptimeCheckMonitoredResourceArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            paused: Optional[pulumi.Input[bool]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tcp_check: Optional[pulumi.Input[pulumi.InputType['UptimeCheckTcpCheckArgs']]] = None,
            trigger_rate: Optional[pulumi.Input[int]] = None) -> 'UptimeCheck':
        """
        Get an existing UptimeCheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] check_interval: Number of seconds between checks
        :param pulumi.Input[int] confirmation: Number of confirmation servers to confirm downtime before an alert is triggered
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_groups: List of contact group IDs
        :param pulumi.Input[pulumi.InputType['UptimeCheckDnsCheckArgs']] dns_check: DNS check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[pulumi.InputType['UptimeCheckHttpCheckArgs']] http_check: HTTP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[pulumi.InputType['UptimeCheckIcmpCheckArgs']] icmp_check: ICMP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UptimeCheckLocationArgs']]]] locations: List of assigned monitoring locations on which to run checks
        :param pulumi.Input[pulumi.InputType['UptimeCheckMonitoredResourceArgs']] monitored_resource: Monitored resource configuration block. The describes server under test
        :param pulumi.Input[str] name: Name of the check
        :param pulumi.Input[bool] paused: Whether the check should be run
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: List of regions on which to run checks. The values required for this parameter can be retrieved from the `GET
               /v1/uptime-locations` endpoint
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags
        :param pulumi.Input[pulumi.InputType['UptimeCheckTcpCheckArgs']] tcp_check: TCP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        :param pulumi.Input[int] trigger_rate: The number of minutes to wait before sending an alert
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UptimeCheckState.__new__(_UptimeCheckState)

        __props__.__dict__["check_interval"] = check_interval
        __props__.__dict__["confirmation"] = confirmation
        __props__.__dict__["contact_groups"] = contact_groups
        __props__.__dict__["dns_check"] = dns_check
        __props__.__dict__["http_check"] = http_check
        __props__.__dict__["icmp_check"] = icmp_check
        __props__.__dict__["locations"] = locations
        __props__.__dict__["monitored_resource"] = monitored_resource
        __props__.__dict__["name"] = name
        __props__.__dict__["paused"] = paused
        __props__.__dict__["regions"] = regions
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tcp_check"] = tcp_check
        __props__.__dict__["trigger_rate"] = trigger_rate
        return UptimeCheck(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> pulumi.Output[int]:
        """
        Number of seconds between checks
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter
    def confirmation(self) -> pulumi.Output[Optional[int]]:
        """
        Number of confirmation servers to confirm downtime before an alert is triggered
        """
        return pulumi.get(self, "confirmation")

    @property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of contact group IDs
        """
        return pulumi.get(self, "contact_groups")

    @property
    @pulumi.getter(name="dnsCheck")
    def dns_check(self) -> pulumi.Output[Optional['outputs.UptimeCheckDnsCheck']]:
        """
        DNS check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "dns_check")

    @property
    @pulumi.getter(name="httpCheck")
    def http_check(self) -> pulumi.Output[Optional['outputs.UptimeCheckHttpCheck']]:
        """
        HTTP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "http_check")

    @property
    @pulumi.getter(name="icmpCheck")
    def icmp_check(self) -> pulumi.Output[Optional['outputs.UptimeCheckIcmpCheck']]:
        """
        ICMP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "icmp_check")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence['outputs.UptimeCheckLocation']]:
        """
        List of assigned monitoring locations on which to run checks
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> pulumi.Output['outputs.UptimeCheckMonitoredResource']:
        """
        Monitored resource configuration block. The describes server under test
        """
        return pulumi.get(self, "monitored_resource")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the check
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def paused(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the check should be run
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of regions on which to run checks. The values required for this parameter can be retrieved from the `GET
        /v1/uptime-locations` endpoint
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tcpCheck")
    def tcp_check(self) -> pulumi.Output[Optional['outputs.UptimeCheckTcpCheck']]:
        """
        TCP check configuration block. Only one of `dns_check`, `http_check`, `icmp_check`, and `tcp_check` may be specified
        """
        return pulumi.get(self, "tcp_check")

    @property
    @pulumi.getter(name="triggerRate")
    def trigger_rate(self) -> pulumi.Output[Optional[int]]:
        """
        The number of minutes to wait before sending an alert
        """
        return pulumi.get(self, "trigger_rate")

