# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['StatuscakeMaintenanceWindowArgs', 'StatuscakeMaintenanceWindow']

@pulumi.input_type
class StatuscakeMaintenanceWindowArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 start: pulumi.Input[str],
                 timezone: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 repeat_interval: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a StatuscakeMaintenanceWindow resource.
        :param pulumi.Input[str] end: End of the maintenance window (RFC3339 format)
        :param pulumi.Input[str] start: Start of the maintenance window (RFC3339 format)
        :param pulumi.Input[str] timezone: Standard timezone associated with this maintenance window
        :param pulumi.Input[str] name: Name of the maintenance window
        :param pulumi.Input[str] repeat_interval: How often the maintenance window should occur
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags used to include matching uptime checks in this maintenance window
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tests: List of uptime check IDs explicitly included in this maintenance window
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        pulumi.set(__self__, "timezone", timezone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tests is not None:
            pulumi.set(__self__, "tests", tests)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        """
        End of the maintenance window (RFC3339 format)
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        Start of the maintenance window (RFC3339 format)
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Input[str]:
        """
        Standard timezone associated with this maintenance window
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: pulumi.Input[str]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the maintenance window
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[str]]:
        """
        How often the maintenance window should occur
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_interval", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of tags used to include matching uptime checks in this maintenance window
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of uptime check IDs explicitly included in this maintenance window
        """
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tests", value)


@pulumi.input_type
class _StatuscakeMaintenanceWindowState:
    def __init__(__self__, *,
                 end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repeat_interval: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StatuscakeMaintenanceWindow resources.
        :param pulumi.Input[str] end: End of the maintenance window (RFC3339 format)
        :param pulumi.Input[str] name: Name of the maintenance window
        :param pulumi.Input[str] repeat_interval: How often the maintenance window should occur
        :param pulumi.Input[str] start: Start of the maintenance window (RFC3339 format)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags used to include matching uptime checks in this maintenance window
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tests: List of uptime check IDs explicitly included in this maintenance window
        :param pulumi.Input[str] timezone: Standard timezone associated with this maintenance window
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tests is not None:
            pulumi.set(__self__, "tests", tests)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        End of the maintenance window (RFC3339 format)
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the maintenance window
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[pulumi.Input[str]]:
        """
        How often the maintenance window should occur
        """
        return pulumi.get(self, "repeat_interval")

    @repeat_interval.setter
    def repeat_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_interval", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        Start of the maintenance window (RFC3339 format)
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of tags used to include matching uptime checks in this maintenance window
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of uptime check IDs explicitly included in this maintenance window
        """
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tests", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Standard timezone associated with this maintenance window
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


class StatuscakeMaintenanceWindow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repeat_interval: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a StatuscakeMaintenanceWindow resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] end: End of the maintenance window (RFC3339 format)
        :param pulumi.Input[str] name: Name of the maintenance window
        :param pulumi.Input[str] repeat_interval: How often the maintenance window should occur
        :param pulumi.Input[str] start: Start of the maintenance window (RFC3339 format)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags used to include matching uptime checks in this maintenance window
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tests: List of uptime check IDs explicitly included in this maintenance window
        :param pulumi.Input[str] timezone: Standard timezone associated with this maintenance window
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StatuscakeMaintenanceWindowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a StatuscakeMaintenanceWindow resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param StatuscakeMaintenanceWindowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StatuscakeMaintenanceWindowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 repeat_interval: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StatuscakeMaintenanceWindowArgs.__new__(StatuscakeMaintenanceWindowArgs)

            if end is None and not opts.urn:
                raise TypeError("Missing required property 'end'")
            __props__.__dict__["end"] = end
            __props__.__dict__["name"] = name
            __props__.__dict__["repeat_interval"] = repeat_interval
            if start is None and not opts.urn:
                raise TypeError("Missing required property 'start'")
            __props__.__dict__["start"] = start
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tests"] = tests
            if timezone is None and not opts.urn:
                raise TypeError("Missing required property 'timezone'")
            __props__.__dict__["timezone"] = timezone
        super(StatuscakeMaintenanceWindow, __self__).__init__(
            'statuscake:index/statuscakeMaintenanceWindow:StatuscakeMaintenanceWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            end: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            repeat_interval: Optional[pulumi.Input[str]] = None,
            start: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tests: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            timezone: Optional[pulumi.Input[str]] = None) -> 'StatuscakeMaintenanceWindow':
        """
        Get an existing StatuscakeMaintenanceWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] end: End of the maintenance window (RFC3339 format)
        :param pulumi.Input[str] name: Name of the maintenance window
        :param pulumi.Input[str] repeat_interval: How often the maintenance window should occur
        :param pulumi.Input[str] start: Start of the maintenance window (RFC3339 format)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: List of tags used to include matching uptime checks in this maintenance window
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tests: List of uptime check IDs explicitly included in this maintenance window
        :param pulumi.Input[str] timezone: Standard timezone associated with this maintenance window
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StatuscakeMaintenanceWindowState.__new__(_StatuscakeMaintenanceWindowState)

        __props__.__dict__["end"] = end
        __props__.__dict__["name"] = name
        __props__.__dict__["repeat_interval"] = repeat_interval
        __props__.__dict__["start"] = start
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tests"] = tests
        __props__.__dict__["timezone"] = timezone
        return StatuscakeMaintenanceWindow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Output[str]:
        """
        End of the maintenance window (RFC3339 format)
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the maintenance window
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> pulumi.Output[Optional[str]]:
        """
        How often the maintenance window should occur
        """
        return pulumi.get(self, "repeat_interval")

    @property
    @pulumi.getter
    def start(self) -> pulumi.Output[str]:
        """
        Start of the maintenance window (RFC3339 format)
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of tags used to include matching uptime checks in this maintenance window
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tests(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of uptime check IDs explicitly included in this maintenance window
        """
        return pulumi.get(self, "tests")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[str]:
        """
        Standard timezone associated with this maintenance window
        """
        return pulumi.get(self, "timezone")

