# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 api_token: Optional[pulumi.Input[str]] = None,
                 max_backoff: Optional[pulumi.Input[int]] = None,
                 min_backoff: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 rps: Optional[pulumi.Input[int]] = None,
                 statuscake_custom_endpoint: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] api_token: The API token for operations. This can also be provided as an environment variable `STATUSCAKE_API_TOKEN`
        :param pulumi.Input[int] max_backoff: Maximum backoff period in seconds after failed API calls. This can also be provided as an environment variable
               `STATUSCAKE_MAX_BACKOFF`
        :param pulumi.Input[int] min_backoff: Minimum backoff period in seconds after failed API calls. This can also be provided as an environment variable
               `STATUSCAKE_MIN_BACKOFF`
        :param pulumi.Input[int] retries: Maximum number of retries to perform when an API request fails. This can also be provided as an environment variable
               `STATUSCAKE_RETRIES`
        :param pulumi.Input[int] rps: RPS limit to apply when making calls to the API. This can also be provided as an environment variable `STATUSCAKE_RPS`
        :param pulumi.Input[str] statuscake_custom_endpoint: Custom endpoint to which request will be made. This can also be provided as an environment variable
               `STATUCAKE_CUSTOM_ENDPOINT`
        """
        if api_token is None:
            api_token = _utilities.get_env('STATUSCAKE_API_TOKEN')
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if max_backoff is not None:
            pulumi.set(__self__, "max_backoff", max_backoff)
        if min_backoff is not None:
            pulumi.set(__self__, "min_backoff", min_backoff)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if rps is not None:
            pulumi.set(__self__, "rps", rps)
        if statuscake_custom_endpoint is not None:
            pulumi.set(__self__, "statuscake_custom_endpoint", statuscake_custom_endpoint)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[str]]:
        """
        The API token for operations. This can also be provided as an environment variable `STATUSCAKE_API_TOKEN`
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_token", value)

    @property
    @pulumi.getter(name="maxBackoff")
    def max_backoff(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum backoff period in seconds after failed API calls. This can also be provided as an environment variable
        `STATUSCAKE_MAX_BACKOFF`
        """
        return pulumi.get(self, "max_backoff")

    @max_backoff.setter
    def max_backoff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_backoff", value)

    @property
    @pulumi.getter(name="minBackoff")
    def min_backoff(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum backoff period in seconds after failed API calls. This can also be provided as an environment variable
        `STATUSCAKE_MIN_BACKOFF`
        """
        return pulumi.get(self, "min_backoff")

    @min_backoff.setter
    def min_backoff(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_backoff", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of retries to perform when an API request fails. This can also be provided as an environment variable
        `STATUSCAKE_RETRIES`
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def rps(self) -> Optional[pulumi.Input[int]]:
        """
        RPS limit to apply when making calls to the API. This can also be provided as an environment variable `STATUSCAKE_RPS`
        """
        return pulumi.get(self, "rps")

    @rps.setter
    def rps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rps", value)

    @property
    @pulumi.getter(name="statuscakeCustomEndpoint")
    def statuscake_custom_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Custom endpoint to which request will be made. This can also be provided as an environment variable
        `STATUCAKE_CUSTOM_ENDPOINT`
        """
        return pulumi.get(self, "statuscake_custom_endpoint")

    @statuscake_custom_endpoint.setter
    def statuscake_custom_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statuscake_custom_endpoint", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 max_backoff: Optional[pulumi.Input[int]] = None,
                 min_backoff: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 rps: Optional[pulumi.Input[int]] = None,
                 statuscake_custom_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the statuscake package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_token: The API token for operations. This can also be provided as an environment variable `STATUSCAKE_API_TOKEN`
        :param pulumi.Input[int] max_backoff: Maximum backoff period in seconds after failed API calls. This can also be provided as an environment variable
               `STATUSCAKE_MAX_BACKOFF`
        :param pulumi.Input[int] min_backoff: Minimum backoff period in seconds after failed API calls. This can also be provided as an environment variable
               `STATUSCAKE_MIN_BACKOFF`
        :param pulumi.Input[int] retries: Maximum number of retries to perform when an API request fails. This can also be provided as an environment variable
               `STATUSCAKE_RETRIES`
        :param pulumi.Input[int] rps: RPS limit to apply when making calls to the API. This can also be provided as an environment variable `STATUSCAKE_RPS`
        :param pulumi.Input[str] statuscake_custom_endpoint: Custom endpoint to which request will be made. This can also be provided as an environment variable
               `STATUCAKE_CUSTOM_ENDPOINT`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the statuscake package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[str]] = None,
                 max_backoff: Optional[pulumi.Input[int]] = None,
                 min_backoff: Optional[pulumi.Input[int]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 rps: Optional[pulumi.Input[int]] = None,
                 statuscake_custom_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if api_token is None:
                api_token = _utilities.get_env('STATUSCAKE_API_TOKEN')
            __props__.__dict__["api_token"] = None if api_token is None else pulumi.Output.secret(api_token)
            __props__.__dict__["max_backoff"] = pulumi.Output.from_input(max_backoff).apply(pulumi.runtime.to_json) if max_backoff is not None else None
            __props__.__dict__["min_backoff"] = pulumi.Output.from_input(min_backoff).apply(pulumi.runtime.to_json) if min_backoff is not None else None
            __props__.__dict__["retries"] = pulumi.Output.from_input(retries).apply(pulumi.runtime.to_json) if retries is not None else None
            __props__.__dict__["rps"] = pulumi.Output.from_input(rps).apply(pulumi.runtime.to_json) if rps is not None else None
            __props__.__dict__["statuscake_custom_endpoint"] = statuscake_custom_endpoint
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'statuscake',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Output[Optional[str]]:
        """
        The API token for operations. This can also be provided as an environment variable `STATUSCAKE_API_TOKEN`
        """
        return pulumi.get(self, "api_token")

    @property
    @pulumi.getter(name="statuscakeCustomEndpoint")
    def statuscake_custom_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        Custom endpoint to which request will be made. This can also be provided as an environment variable
        `STATUCAKE_CUSTOM_ENDPOINT`
        """
        return pulumi.get(self, "statuscake_custom_endpoint")

