"""
    Cisco SD-WAN vManage API

    The vManage API exposes the functionality of operations maintaining devices and the overlay network  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: vmanage@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)


class ConfigurationFeatureProfileSDWANApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_aaa_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/aaa',
                'operation_id': 'create_aaa_profile_parcel_for_system',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'body',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_banner_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/banner',
                'operation_id': 'create_banner_profile_parcel_for_system',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'body',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_basic_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/basic',
                'operation_id': 'create_basic_profile_parcel_for_system',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'body',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_bfd_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/bfd',
                'operation_id': 'create_bfd_profile_parcel_for_system',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'body',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_cellular_controller_and_cellular_profile_parcel_association_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile',
                'operation_id': 'create_cellular_controller_and_cellular_profile_parcel_association_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_controller_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'cellular_controller_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_controller_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_controller_id': 'cellularControllerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_controller_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_cellular_controller_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller',
                'operation_id': 'create_cellular_controller_profile_parcel_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_cellular_profile_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-profile',
                'operation_id': 'create_cellular_profile_profile_parcel_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_global_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/global',
                'operation_id': 'create_global_profile_parcel_for_system',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'body',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_lan_vpn_and_routing_bgp_parcel_association_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp',
                'operation_id': 'create_lan_vpn_and_routing_bgp_parcel_association_for_service',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_lan_vpn_and_routing_ospf_parcel_association_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf',
                'operation_id': 'create_lan_vpn_and_routing_ospf_parcel_association_for_service',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnParcelId}/interface/ethernet/{ethernetId}/tracker',
                'operation_id': 'create_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_parcel_id',
                    'ethernet_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'vpn_parcel_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_parcel_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_parcel_id': 'vpnParcelId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_parcel_id': 'path',
                    'ethernet_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_lan_vpn_interface_ethernet_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet',
                'operation_id': 'create_lan_vpn_interface_ethernet_parcel_for_service',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_lan_vpn_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn',
                'operation_id': 'create_lan_vpn_profile_parcel_for_service',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'body',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_logging_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/logging',
                'operation_id': 'create_logging_profile_parcel_for_system',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'body',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_management_vpn_interface_ethernet_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet',
                'operation_id': 'create_management_vpn_interface_ethernet_parcel_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_management_vpn_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn',
                'operation_id': 'create_management_vpn_profile_parcel_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_ntp_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/ntp',
                'operation_id': 'create_ntp_profile_parcel_for_system',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'body',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_omp_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/omp',
                'operation_id': 'create_omp_profile_parcel_for_system',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'body',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_routing_bgp_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/bgp',
                'operation_id': 'create_routing_bgp_profile_parcel_for_service',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'body',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_routing_ospf_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/ospf',
                'operation_id': 'create_routing_ospf_profile_parcel_for_service',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'body',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_sdwan_config_profile_parcel_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli/{cliId}/config',
                'operation_id': 'create_sdwan_config_profile_parcel_for_cli',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                    'body',
                ],
                'required': [
                    'cli_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                },
                'location_map': {
                    'cli_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_sdwan_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli',
                'operation_id': 'create_sdwan_feature_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (str,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_sdwan_service_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service',
                'operation_id': 'create_sdwan_service_feature_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (str,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_sdwan_system_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system',
                'operation_id': 'create_sdwan_system_feature_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (str,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_sdwan_transport_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport',
                'operation_id': 'create_sdwan_transport_feature_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (str,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_tracker_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/tracker',
                'operation_id': 'create_tracker_profile_parcel_for_service',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'body',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_tracker_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/tracker',
                'operation_id': 'create_tracker_profile_parcel_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnParcelId}/interface/ethernet/{ethernetId}/tracker',
                'operation_id': 'create_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_parcel_id',
                    'ethernet_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'vpn_parcel_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_parcel_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_parcel_id': 'vpnParcelId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_parcel_id': 'path',
                    'ethernet_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_wan_vpn_interface_ethernet_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet',
                'operation_id': 'create_wan_vpn_interface_ethernet_parcel_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_wan_vpn_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn',
                'operation_id': 'create_wan_vpn_profile_parcel_for_transport',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_aaa_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/aaa/{aaaId}',
                'operation_id': 'delete_aaa_profile_parcel_for_system',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'aaa_id',
                ],
                'required': [
                    'system_id',
                    'aaa_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'aaa_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'aaa_id': 'aaaId',
                },
                'location_map': {
                    'system_id': 'path',
                    'aaa_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_banner_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/banner/{bannerId}',
                'operation_id': 'delete_banner_profile_parcel_for_system',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'banner_id',
                ],
                'required': [
                    'system_id',
                    'banner_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'banner_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'banner_id': 'bannerId',
                },
                'location_map': {
                    'system_id': 'path',
                    'banner_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_basic_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/basic/{basicId}',
                'operation_id': 'delete_basic_profile_parcel_for_system',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'basic_id',
                ],
                'required': [
                    'system_id',
                    'basic_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'basic_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'basic_id': 'basicId',
                },
                'location_map': {
                    'system_id': 'path',
                    'basic_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_bfd_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/bfd/{bfdId}',
                'operation_id': 'delete_bfd_profile_parcel_for_system',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'bfd_id',
                ],
                'required': [
                    'system_id',
                    'bfd_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'bfd_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'bfd_id': 'bfdId',
                },
                'location_map': {
                    'system_id': 'path',
                    'bfd_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_cellular_controller_and_cellular_profile_association_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile/{cellularProfileId}',
                'operation_id': 'delete_cellular_controller_and_cellular_profile_association_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_controller_id',
                    'cellular_profile_id',
                ],
                'required': [
                    'transport_id',
                    'cellular_controller_id',
                    'cellular_profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_controller_id':
                        (str,),
                    'cellular_profile_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_controller_id': 'cellularControllerId',
                    'cellular_profile_id': 'cellularProfileId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_controller_id': 'path',
                    'cellular_profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_cellular_controller_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}',
                'operation_id': 'delete_cellular_controller_profile_parcel_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_controller_id',
                ],
                'required': [
                    'transport_id',
                    'cellular_controller_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_controller_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_controller_id': 'cellularControllerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_controller_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_cellular_profile_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-profile/{cellularProfileId}',
                'operation_id': 'delete_cellular_profile_profile_parcel_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_profile_id',
                ],
                'required': [
                    'transport_id',
                    'cellular_profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_profile_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_profile_id': 'cellularProfileId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_config_profile_parcel_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli/{cliId}/config/{configId}',
                'operation_id': 'delete_config_profile_parcel_for_cli',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                    'config_id',
                ],
                'required': [
                    'cli_id',
                    'config_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                    'config_id':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                    'config_id': 'configId',
                },
                'location_map': {
                    'cli_id': 'path',
                    'config_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_global_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/global/{globalId}',
                'operation_id': 'delete_global_profile_parcel_for_system',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'global_id',
                ],
                'required': [
                    'system_id',
                    'global_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'global_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'global_id': 'globalId',
                },
                'location_map': {
                    'system_id': 'path',
                    'global_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_lan_vpn_and_routing_bgp_association_for_service_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp/{bgpId}',
                'operation_id': 'delete_lan_vpn_and_routing_bgp_association_for_service',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'bgp_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'bgp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'bgp_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'bgp_id': 'bgpId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'bgp_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_lan_vpn_and_routing_ospf_association_for_service_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf/{ospfId}',
                'operation_id': 'delete_lan_vpn_and_routing_ospf_association_for_service',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ospf_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ospf_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ospf_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ospf_id': 'ospfId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ospf_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_lan_vpn_interface_ethernet_and_tracker_association_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId}',
                'operation_id': 'delete_lan_vpn_interface_ethernet_and_tracker_association_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'tracker_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                    'tracker_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_lan_vpn_interface_ethernet_for_service_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}',
                'operation_id': 'delete_lan_vpn_interface_ethernet_for_service',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_lan_vpn_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}',
                'operation_id': 'delete_lan_vpn_profile_parcel_for_service',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_logging_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/logging/{loggingId}',
                'operation_id': 'delete_logging_profile_parcel_for_system',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'logging_id',
                ],
                'required': [
                    'system_id',
                    'logging_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'logging_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'logging_id': 'loggingId',
                },
                'location_map': {
                    'system_id': 'path',
                    'logging_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_management_vpn_interface_ethernet_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet/{ethernetId}',
                'operation_id': 'delete_management_vpn_interface_ethernet_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_management_vpn_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}',
                'operation_id': 'delete_management_vpn_profile_parcel_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_ntp_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/ntp/{ntpId}',
                'operation_id': 'delete_ntp_profile_parcel_for_system',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'ntp_id',
                ],
                'required': [
                    'system_id',
                    'ntp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'ntp_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'ntp_id': 'ntpId',
                },
                'location_map': {
                    'system_id': 'path',
                    'ntp_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_omp_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/omp/{ompId}',
                'operation_id': 'delete_omp_profile_parcel_for_system',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'omp_id',
                ],
                'required': [
                    'system_id',
                    'omp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'omp_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'omp_id': 'ompId',
                },
                'location_map': {
                    'system_id': 'path',
                    'omp_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_routing_bgp_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/bgp/{bgpId}',
                'operation_id': 'delete_routing_bgp_profile_parcel_for_service',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'bgp_id',
                ],
                'required': [
                    'service_id',
                    'bgp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'bgp_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'bgp_id': 'bgpId',
                },
                'location_map': {
                    'service_id': 'path',
                    'bgp_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_routing_ospf_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/ospf/{ospfId}',
                'operation_id': 'delete_routing_ospf_profile_parcel_for_service',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'ospf_id',
                ],
                'required': [
                    'service_id',
                    'ospf_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'ospf_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'ospf_id': 'ospfId',
                },
                'location_map': {
                    'service_id': 'path',
                    'ospf_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_sdwan_feature_profile_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli/{cliId}',
                'operation_id': 'delete_sdwan_feature_profile_for_cli',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                ],
                'required': [
                    'cli_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                },
                'location_map': {
                    'cli_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_sdwan_service_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}',
                'operation_id': 'delete_sdwan_service_feature_profile',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_sdwan_system_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}',
                'operation_id': 'delete_sdwan_system_feature_profile',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_sdwan_transport_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}',
                'operation_id': 'delete_sdwan_transport_feature_profile',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_tracker_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/tracker/{trackerId}',
                'operation_id': 'delete_tracker_profile_parcel_for_service',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'tracker_id',
                ],
                'required': [
                    'service_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'tracker_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'service_id': 'path',
                    'tracker_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_tracker_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/tracker/{trackerId}',
                'operation_id': 'delete_tracker_profile_parcel_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'tracker_id',
                ],
                'required': [
                    'transport_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'tracker_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'tracker_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_wan_vpn_interface_ethernet_and_tracker_association_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId}',
                'operation_id': 'delete_wan_vpn_interface_ethernet_and_tracker_association_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'tracker_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                    'tracker_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_wan_vpn_interface_ethernet_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}',
                'operation_id': 'delete_wan_vpn_interface_ethernet_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_wan_vpn_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}',
                'operation_id': 'delete_wan_vpn_profile_parcel_for_transport',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.edit_aaa_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/aaa/{aaaId}',
                'operation_id': 'edit_aaa_profile_parcel_for_system',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'aaa_id',
                    'body',
                ],
                'required': [
                    'system_id',
                    'aaa_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'aaa_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'aaa_id': 'aaaId',
                },
                'location_map': {
                    'system_id': 'path',
                    'aaa_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_banner_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/banner/{bannerId}',
                'operation_id': 'edit_banner_profile_parcel_for_system',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'banner_id',
                    'body',
                ],
                'required': [
                    'system_id',
                    'banner_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'banner_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'banner_id': 'bannerId',
                },
                'location_map': {
                    'system_id': 'path',
                    'banner_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_basic_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/basic/{basicId}',
                'operation_id': 'edit_basic_profile_parcel_for_system',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'basic_id',
                    'body',
                ],
                'required': [
                    'system_id',
                    'basic_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'basic_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'basic_id': 'basicId',
                },
                'location_map': {
                    'system_id': 'path',
                    'basic_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_bfd_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/bfd/{bfdId}',
                'operation_id': 'edit_bfd_profile_parcel_for_system',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'bfd_id',
                    'body',
                ],
                'required': [
                    'system_id',
                    'bfd_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'bfd_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'bfd_id': 'bfdId',
                },
                'location_map': {
                    'system_id': 'path',
                    'bfd_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_cellular_controller_and_cellular_profile_parcel_association_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile/{cellularProfileId}',
                'operation_id': 'edit_cellular_controller_and_cellular_profile_parcel_association_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_controller_id',
                    'cellular_profile_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'cellular_controller_id',
                    'cellular_profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_controller_id':
                        (str,),
                    'cellular_profile_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_controller_id': 'cellularControllerId',
                    'cellular_profile_id': 'cellularProfileId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_controller_id': 'path',
                    'cellular_profile_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_cellular_controller_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}',
                'operation_id': 'edit_cellular_controller_profile_parcel_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_controller_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'cellular_controller_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_controller_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_controller_id': 'cellularControllerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_controller_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_cellular_profile_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-profile/{cellularProfileId}',
                'operation_id': 'edit_cellular_profile_profile_parcel_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_profile_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'cellular_profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_profile_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_profile_id': 'cellularProfileId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_profile_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_config_profile_parcel_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli/{cliId}/config/{configId}',
                'operation_id': 'edit_config_profile_parcel_for_cli',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                    'config_id',
                    'body',
                ],
                'required': [
                    'cli_id',
                    'config_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                    'config_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                    'config_id': 'configId',
                },
                'location_map': {
                    'cli_id': 'path',
                    'config_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_global_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/global/{globalId}',
                'operation_id': 'edit_global_profile_parcel_for_system',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'global_id',
                    'body',
                ],
                'required': [
                    'system_id',
                    'global_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'global_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'global_id': 'globalId',
                },
                'location_map': {
                    'system_id': 'path',
                    'global_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_lan_vpn_and_routing_bgp_parcel_association_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp/{bgpId}',
                'operation_id': 'edit_lan_vpn_and_routing_bgp_parcel_association_for_service',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'bgp_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'bgp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'bgp_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'bgp_id': 'bgpId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'bgp_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_lan_vpn_and_routing_ospf_parcel_association_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf/{ospfId}',
                'operation_id': 'edit_lan_vpn_and_routing_ospf_parcel_association_for_service',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ospf_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ospf_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ospf_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ospf_id': 'ospfId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ospf_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId}',
                'operation_id': 'edit_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'tracker_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                    'tracker_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_lan_vpn_interface_ethernet_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}',
                'operation_id': 'edit_lan_vpn_interface_ethernet_parcel_for_service',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_lan_vpn_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}',
                'operation_id': 'edit_lan_vpn_profile_parcel_for_service',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_logging_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/logging/{loggingId}',
                'operation_id': 'edit_logging_profile_parcel_for_system',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'logging_id',
                    'body',
                ],
                'required': [
                    'system_id',
                    'logging_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'logging_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'logging_id': 'loggingId',
                },
                'location_map': {
                    'system_id': 'path',
                    'logging_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_management_vpn_interface_ethernet_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet/{ethernetId}',
                'operation_id': 'edit_management_vpn_interface_ethernet_parcel_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_management_vpn_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}',
                'operation_id': 'edit_management_vpn_profile_parcel_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_ntp_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/ntp/{ntpId}',
                'operation_id': 'edit_ntp_profile_parcel_for_system',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'ntp_id',
                    'body',
                ],
                'required': [
                    'system_id',
                    'ntp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'ntp_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'ntp_id': 'ntpId',
                },
                'location_map': {
                    'system_id': 'path',
                    'ntp_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_omp_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/omp/{ompId}',
                'operation_id': 'edit_omp_profile_parcel_for_system',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'omp_id',
                    'body',
                ],
                'required': [
                    'system_id',
                    'omp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'omp_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'omp_id': 'ompId',
                },
                'location_map': {
                    'system_id': 'path',
                    'omp_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_routing_bgp_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/bgp/{bgpId}',
                'operation_id': 'edit_routing_bgp_profile_parcel_for_service',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'bgp_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'bgp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'bgp_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'bgp_id': 'bgpId',
                },
                'location_map': {
                    'service_id': 'path',
                    'bgp_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_routing_ospf_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/ospf/{ospfId}',
                'operation_id': 'edit_routing_ospf_profile_parcel_for_service',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'ospf_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'ospf_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'ospf_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'ospf_id': 'ospfId',
                },
                'location_map': {
                    'service_id': 'path',
                    'ospf_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_sdwan_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli/{cliId}',
                'operation_id': 'edit_sdwan_feature_profile',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                    'body',
                ],
                'required': [
                    'cli_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                },
                'location_map': {
                    'cli_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_sdwan_service_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}',
                'operation_id': 'edit_sdwan_service_feature_profile',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'body',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_sdwan_system_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}',
                'operation_id': 'edit_sdwan_system_feature_profile',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'body',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_sdwan_transport_feature_profile_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}',
                'operation_id': 'edit_sdwan_transport_feature_profile',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_tracker_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/tracker/{trackerId}',
                'operation_id': 'edit_tracker_profile_parcel_for_service',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'tracker_id',
                    'body',
                ],
                'required': [
                    'service_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'tracker_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'service_id': 'path',
                    'tracker_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_tracker_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/tracker/{trackerId}',
                'operation_id': 'edit_tracker_profile_parcel_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'tracker_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'tracker_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'tracker_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId}',
                'operation_id': 'edit_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'tracker_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                    'tracker_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_wan_vpn_interface_ethernet_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}',
                'operation_id': 'edit_wan_vpn_interface_ethernet_parcel_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.edit_wan_vpn_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}',
                'operation_id': 'edit_wan_vpn_profile_parcel_for_transport',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'body',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_aaa_profile_parcel_by_parcel_id_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/aaa/{aaaId}',
                'operation_id': 'get_aaa_profile_parcel_by_parcel_id_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'aaa_id',
                ],
                'required': [
                    'system_id',
                    'aaa_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'aaa_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'aaa_id': 'aaaId',
                },
                'location_map': {
                    'system_id': 'path',
                    'aaa_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_aaa_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/aaa',
                'operation_id': 'get_aaa_profile_parcel_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_banner_profile_parcel_by_parcel_id_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/banner/{bannerId}',
                'operation_id': 'get_banner_profile_parcel_by_parcel_id_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'banner_id',
                ],
                'required': [
                    'system_id',
                    'banner_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'banner_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'banner_id': 'bannerId',
                },
                'location_map': {
                    'system_id': 'path',
                    'banner_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_banner_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/banner',
                'operation_id': 'get_banner_profile_parcel_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_basic_profile_parcel_by_parcel_id_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/basic/{basicId}',
                'operation_id': 'get_basic_profile_parcel_by_parcel_id_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'basic_id',
                ],
                'required': [
                    'system_id',
                    'basic_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'basic_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'basic_id': 'basicId',
                },
                'location_map': {
                    'system_id': 'path',
                    'basic_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_basic_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/basic',
                'operation_id': 'get_basic_profile_parcel_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_bfd_profile_parcel_by_parcel_id_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/bfd/{bfdId}',
                'operation_id': 'get_bfd_profile_parcel_by_parcel_id_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'bfd_id',
                ],
                'required': [
                    'system_id',
                    'bfd_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'bfd_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'bfd_id': 'bfdId',
                },
                'location_map': {
                    'system_id': 'path',
                    'bfd_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_bfd_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/bfd',
                'operation_id': 'get_bfd_profile_parcel_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cedge_system_global_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/global/schema',
                'operation_id': 'get_cedge_system_global_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cellular_controller_associated_cellular_profile_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile/{cellularProfileId}',
                'operation_id': 'get_cellular_controller_associated_cellular_profile_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_controller_id',
                    'cellular_profile_id',
                ],
                'required': [
                    'transport_id',
                    'cellular_controller_id',
                    'cellular_profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_controller_id':
                        (str,),
                    'cellular_profile_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_controller_id': 'cellularControllerId',
                    'cellular_profile_id': 'cellularProfileId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_controller_id': 'path',
                    'cellular_profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cellular_controller_associated_cellular_profile_parcels_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}/cellular-profile',
                'operation_id': 'get_cellular_controller_associated_cellular_profile_parcels_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_controller_id',
                ],
                'required': [
                    'transport_id',
                    'cellular_controller_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_controller_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_controller_id': 'cellularControllerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_controller_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cellular_controller_profile_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller/{cellularControllerId}',
                'operation_id': 'get_cellular_controller_profile_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_controller_id',
                ],
                'required': [
                    'transport_id',
                    'cellular_controller_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_controller_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_controller_id': 'cellularControllerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_controller_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cellular_controller_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-controller',
                'operation_id': 'get_cellular_controller_profile_parcel_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cellular_profile_profile_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-profile/{cellularProfileId}',
                'operation_id': 'get_cellular_profile_profile_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'cellular_profile_id',
                ],
                'required': [
                    'transport_id',
                    'cellular_profile_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'cellular_profile_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'cellular_profile_id': 'cellularProfileId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'cellular_profile_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_cellular_profile_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/cellular-profile',
                'operation_id': 'get_cellular_profile_profile_parcel_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_config_profile_parcel_by_parcel_id_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli/{cliId}/config/{configId}',
                'operation_id': 'get_config_profile_parcel_by_parcel_id_for_cli',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                    'config_id',
                ],
                'required': [
                    'cli_id',
                    'config_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                    'config_id':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                    'config_id': 'configId',
                },
                'location_map': {
                    'cli_id': 'path',
                    'config_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_config_profile_parcel_for_cli_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli/{cliId}/config',
                'operation_id': 'get_config_profile_parcel_for_cli',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                ],
                'required': [
                    'cli_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                },
                'location_map': {
                    'cli_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_global_profile_parcel_by_parcel_id_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/global/{globalId}',
                'operation_id': 'get_global_profile_parcel_by_parcel_id_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'global_id',
                ],
                'required': [
                    'system_id',
                    'global_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'global_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'global_id': 'globalId',
                },
                'location_map': {
                    'system_id': 'path',
                    'global_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_global_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/global',
                'operation_id': 'get_global_profile_parcel_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_interface_ethernet_parcels_for_service_lan_vpn_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet',
                'operation_id': 'get_interface_ethernet_parcels_for_service_lan_vpn',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_interface_ethernet_parcels_for_transport_management_vpn_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet',
                'operation_id': 'get_interface_ethernet_parcels_for_transport_management_vpn',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_interface_ethernet_parcels_for_transport_wan_vpn_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet',
                'operation_id': 'get_interface_ethernet_parcels_for_transport_wan_vpn',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lan_vpn_associated_routing_bgp_parcel_by_parcel_id_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp/{bgpId}',
                'operation_id': 'get_lan_vpn_associated_routing_bgp_parcel_by_parcel_id_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'bgp_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'bgp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'bgp_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'bgp_id': 'bgpId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'bgp_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lan_vpn_associated_routing_bgp_parcels_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/bgp',
                'operation_id': 'get_lan_vpn_associated_routing_bgp_parcels_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lan_vpn_associated_routing_ospf_parcel_by_parcel_id_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf/{ospfId}',
                'operation_id': 'get_lan_vpn_associated_routing_ospf_parcel_by_parcel_id_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ospf_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ospf_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ospf_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ospf_id': 'ospfId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ospf_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lan_vpn_associated_routing_ospf_parcels_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/routing/ospf',
                'operation_id': 'get_lan_vpn_associated_routing_ospf_parcels_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId}',
                'operation_id': 'get_lan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'tracker_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                    'tracker_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lan_vpn_interface_ethernet_associated_tracker_parcels_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker',
                'operation_id': 'get_lan_vpn_interface_ethernet_associated_tracker_parcels_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lan_vpn_interface_ethernet_parcel_by_parcel_id_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}/interface/ethernet/{ethernetId}',
                'operation_id': 'get_lan_vpn_interface_ethernet_parcel_by_parcel_id_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lan_vpn_profile_parcel_by_parcel_id_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn/{vpnId}',
                'operation_id': 'get_lan_vpn_profile_parcel_by_parcel_id_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'vpn_id',
                ],
                'required': [
                    'service_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'service_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lan_vpn_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/lan/vpn',
                'operation_id': 'get_lan_vpn_profile_parcel_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_logging_profile_parcel_by_parcel_id_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/logging/{loggingId}',
                'operation_id': 'get_logging_profile_parcel_by_parcel_id_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'logging_id',
                ],
                'required': [
                    'system_id',
                    'logging_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'logging_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'logging_id': 'loggingId',
                },
                'location_map': {
                    'system_id': 'path',
                    'logging_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_logging_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/logging',
                'operation_id': 'get_logging_profile_parcel_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_management_vpn_interface_ethernet_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}/interface/ethernet/{ethernetId}',
                'operation_id': 'get_management_vpn_interface_ethernet_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_management_vpn_profile_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn/{vpnId}',
                'operation_id': 'get_management_vpn_profile_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_management_vpn_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/management/vpn',
                'operation_id': 'get_management_vpn_profile_parcel_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_ntp_profile_parcel_by_parcel_id_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/ntp/{ntpId}',
                'operation_id': 'get_ntp_profile_parcel_by_parcel_id_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'ntp_id',
                ],
                'required': [
                    'system_id',
                    'ntp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'ntp_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'ntp_id': 'ntpId',
                },
                'location_map': {
                    'system_id': 'path',
                    'ntp_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_ntp_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/ntp',
                'operation_id': 'get_ntp_profile_parcel_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_omp_profile_parcel_by_parcel_id_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/omp/{ompId}',
                'operation_id': 'get_omp_profile_parcel_by_parcel_id_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                    'omp_id',
                ],
                'required': [
                    'system_id',
                    'omp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                    'omp_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                    'omp_id': 'ompId',
                },
                'location_map': {
                    'system_id': 'path',
                    'omp_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_omp_profile_parcel_for_system_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}/omp',
                'operation_id': 'get_omp_profile_parcel_for_system',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_routing_bgp_profile_parcel_by_parcel_id_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/bgp/{bgpId}',
                'operation_id': 'get_routing_bgp_profile_parcel_by_parcel_id_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'bgp_id',
                ],
                'required': [
                    'service_id',
                    'bgp_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'bgp_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'bgp_id': 'bgpId',
                },
                'location_map': {
                    'service_id': 'path',
                    'bgp_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_routing_bgp_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/bgp',
                'operation_id': 'get_routing_bgp_profile_parcel_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_routing_ospf_profile_parcel_by_parcel_id_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/ospf/{ospfId}',
                'operation_id': 'get_routing_ospf_profile_parcel_by_parcel_id_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'ospf_id',
                ],
                'required': [
                    'service_id',
                    'ospf_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'ospf_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'ospf_id': 'ospfId',
                },
                'location_map': {
                    'service_id': 'path',
                    'ospf_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_routing_ospf_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/routing/ospf',
                'operation_id': 'get_routing_ospf_profile_parcel_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_feature_profile_by_profile_id_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli/{cliId}',
                'operation_id': 'get_sdwan_feature_profile_by_profile_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'cli_id',
                ],
                'required': [
                    'cli_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'cli_id':
                        (str,),
                },
                'attribute_map': {
                    'cli_id': 'cliId',
                },
                'location_map': {
                    'cli_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_feature_profile_by_sdwan_family_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan',
                'operation_id': 'get_sdwan_feature_profile_by_sdwan_family',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'offset',
                    'limit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'offset': 'offset',
                    'limit': 'limit',
                },
                'location_map': {
                    'offset': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_feature_profiles_by_family_and_type_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/cli',
                'operation_id': 'get_sdwan_feature_profiles_by_family_and_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'offset',
                    'limit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'offset': 'offset',
                    'limit': 'limit',
                },
                'location_map': {
                    'offset': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_service_feature_profile_by_profile_id_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}',
                'operation_id': 'get_sdwan_service_feature_profile_by_profile_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_service_feature_profiles_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service',
                'operation_id': 'get_sdwan_service_feature_profiles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'offset',
                    'limit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'offset': 'offset',
                    'limit': 'limit',
                },
                'location_map': {
                    'offset': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_service_lan_vpn_interface_ethernet_parcel_schema_by_schema_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/lan/vpn/interface/ethernet/schema',
                'operation_id': 'get_sdwan_service_lan_vpn_interface_ethernet_parcel_schema_by_schema',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_service_lan_vpn_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/lan/vpn/schema',
                'operation_id': 'get_sdwan_service_lan_vpn_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_service_routing_bgp_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/routing/bgp/schema',
                'operation_id': 'get_sdwan_service_routing_bgp_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_service_routing_ospf_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/routing/ospf/schema',
                'operation_id': 'get_sdwan_service_routing_ospf_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_service_tracker_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/tracker/schema',
                'operation_id': 'get_sdwan_service_tracker_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_system_aaa_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/aaa/schema',
                'operation_id': 'get_sdwan_system_aaa_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_system_banner_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/banner/schema',
                'operation_id': 'get_sdwan_system_banner_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_system_basic_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/basic/schema',
                'operation_id': 'get_sdwan_system_basic_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_system_bfd_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/bfd/schema',
                'operation_id': 'get_sdwan_system_bfd_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_system_feature_profile_by_profile_id_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/{systemId}',
                'operation_id': 'get_sdwan_system_feature_profile_by_profile_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'system_id',
                ],
                'required': [
                    'system_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'system_id':
                        (str,),
                },
                'attribute_map': {
                    'system_id': 'systemId',
                },
                'location_map': {
                    'system_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_system_feature_profiles_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system',
                'operation_id': 'get_sdwan_system_feature_profiles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'offset',
                    'limit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'offset': 'offset',
                    'limit': 'limit',
                },
                'location_map': {
                    'offset': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_system_logging_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/logging/schema',
                'operation_id': 'get_sdwan_system_logging_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_system_ntp_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/ntp/schema',
                'operation_id': 'get_sdwan_system_ntp_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_system_omp_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/system/omp/schema',
                'operation_id': 'get_sdwan_system_omp_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_transport_cellular_controller_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/cellular-controller/schema',
                'operation_id': 'get_sdwan_transport_cellular_controller_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_transport_cellular_profile_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/cellular-profile/schema',
                'operation_id': 'get_sdwan_transport_cellular_profile_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_transport_feature_profile_by_profile_id_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}',
                'operation_id': 'get_sdwan_transport_feature_profile_by_profile_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_transport_feature_profiles_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport',
                'operation_id': 'get_sdwan_transport_feature_profiles',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'offset',
                    'limit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'offset': 'offset',
                    'limit': 'limit',
                },
                'location_map': {
                    'offset': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_transport_management_vpn_interface_ethernet_parcel_schema_by_schema_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/management/vpn/interface/ethernet/schema',
                'operation_id': 'get_sdwan_transport_management_vpn_interface_ethernet_parcel_schema_by_schema',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_transport_management_vpn_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/management/vpn/schema',
                'operation_id': 'get_sdwan_transport_management_vpn_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_transport_tracker_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/tracker/schema',
                'operation_id': 'get_sdwan_transport_tracker_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_transport_wan_vpn_interface_ethernet_parcel_schema_by_schema_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/wan/vpn/interface/ethernet/schema',
                'operation_id': 'get_sdwan_transport_wan_vpn_interface_ethernet_parcel_schema_by_schema',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sdwan_transport_wan_vpn_parcel_schema_by_schema_type_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/wan/vpn/schema',
                'operation_id': 'get_sdwan_transport_wan_vpn_parcel_schema_by_schema_type',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'schema_type',
                ],
                'required': [
                    'schema_type',
                ],
                'nullable': [
                ],
                'enum': [
                    'schema_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('schema_type',): {

                        "POST": "post",
                        "PUT": "put"
                    },
                },
                'openapi_types': {
                    'schema_type':
                        (str,),
                },
                'attribute_map': {
                    'schema_type': 'schemaType',
                },
                'location_map': {
                    'schema_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_tracker_profile_parcel_by_parcel_id_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/tracker/{trackerId}',
                'operation_id': 'get_tracker_profile_parcel_by_parcel_id_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                    'tracker_id',
                ],
                'required': [
                    'service_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                    'tracker_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'service_id': 'path',
                    'tracker_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_tracker_profile_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/tracker/{trackerId}',
                'operation_id': 'get_tracker_profile_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'tracker_id',
                ],
                'required': [
                    'transport_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'tracker_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'tracker_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_tracker_profile_parcel_for_service_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/service/{serviceId}/tracker',
                'operation_id': 'get_tracker_profile_parcel_for_service',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'service_id',
                ],
                'required': [
                    'service_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'service_id':
                        (str,),
                },
                'attribute_map': {
                    'service_id': 'serviceId',
                },
                'location_map': {
                    'service_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_tracker_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/tracker',
                'operation_id': 'get_tracker_profile_parcel_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_wan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker/{trackerId}',
                'operation_id': 'get_wan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                    'tracker_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                    'tracker_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                    'tracker_id': 'trackerId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                    'tracker_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_wan_vpn_interface_ethernet_associated_tracker_parcels_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}/tracker',
                'operation_id': 'get_wan_vpn_interface_ethernet_associated_tracker_parcels_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_wan_vpn_interface_ethernet_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}/interface/ethernet/{ethernetId}',
                'operation_id': 'get_wan_vpn_interface_ethernet_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                    'ethernet_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ethernet_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                    'ethernet_id': 'ethernetId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                    'ethernet_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_wan_vpn_profile_parcel_by_parcel_id_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn/{vpnId}',
                'operation_id': 'get_wan_vpn_profile_parcel_by_parcel_id_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                    'vpn_id',
                ],
                'required': [
                    'transport_id',
                    'vpn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                    'vpn_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                    'vpn_id': 'vpnId',
                },
                'location_map': {
                    'transport_id': 'path',
                    'vpn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_wan_vpn_profile_parcel_for_transport_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/feature-profile/sdwan/transport/{transportId}/wan/vpn',
                'operation_id': 'get_wan_vpn_profile_parcel_for_transport',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transport_id',
                ],
                'required': [
                    'transport_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transport_id':
                        (str,),
                },
                'attribute_map': {
                    'transport_id': 'transportId',
                },
                'location_map': {
                    'transport_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_aaa_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """create_aaa_profile_parcel_for_system  # noqa: E501

        Create a Aaa Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_aaa_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            body (str): Aaa Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.create_aaa_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def create_banner_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """create_banner_profile_parcel_for_system  # noqa: E501

        Create a Banner Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_banner_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            body (str): Banner Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.create_banner_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def create_basic_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """create_basic_profile_parcel_for_system  # noqa: E501

        Create a Basic Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_basic_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            body (str): Basic Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.create_basic_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def create_bfd_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """create_bfd_profile_parcel_for_system  # noqa: E501

        Create a Bfd Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_bfd_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            body (str): Bfd Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.create_bfd_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def create_cellular_controller_and_cellular_profile_parcel_association_for_transport(
        self,
        transport_id,
        cellular_controller_id,
        **kwargs
    ):
        """create_cellular_controller_and_cellular_profile_parcel_association_for_transport  # noqa: E501

        Associate a cellularcontroller parcel with a cellularprofile Parcel for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cellular_controller_and_cellular_profile_parcel_association_for_transport(transport_id, cellular_controller_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_controller_id (str): Cellular Controller Profile Parcel ID

        Keyword Args:
            body (str): Cellular Profile Profile Parcel Id. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_controller_id'] = \
            cellular_controller_id
        return self.create_cellular_controller_and_cellular_profile_parcel_association_for_transport_endpoint.call_with_http_info(**kwargs)

    def create_cellular_controller_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """create_cellular_controller_profile_parcel_for_transport  # noqa: E501

        Create a Cellular Controller Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cellular_controller_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            body (str): Cellular Controller Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.create_cellular_controller_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def create_cellular_profile_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """create_cellular_profile_profile_parcel_for_transport  # noqa: E501

        Create a Cellular Profile Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cellular_profile_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            body (str): Cellular Profile Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.create_cellular_profile_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def create_global_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """create_global_profile_parcel_for_system  # noqa: E501

        Create a Global Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_global_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            body (str): Global Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.create_global_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def create_lan_vpn_and_routing_bgp_parcel_association_for_service(
        self,
        service_id,
        vpn_id,
        **kwargs
    ):
        """create_lan_vpn_and_routing_bgp_parcel_association_for_service  # noqa: E501

        Associate a lanvpn parcel with a routingbgp Parcel for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_lan_vpn_and_routing_bgp_parcel_association_for_service(service_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Lan Vpn Profile Parcel ID

        Keyword Args:
            body (str): Routing Bgp Profile Parcel Id. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.create_lan_vpn_and_routing_bgp_parcel_association_for_service_endpoint.call_with_http_info(**kwargs)

    def create_lan_vpn_and_routing_ospf_parcel_association_for_service(
        self,
        service_id,
        vpn_id,
        **kwargs
    ):
        """create_lan_vpn_and_routing_ospf_parcel_association_for_service  # noqa: E501

        Associate a lanvpn parcel with a routingospf Parcel for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_lan_vpn_and_routing_ospf_parcel_association_for_service(service_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Lan Vpn Profile Parcel ID

        Keyword Args:
            body (str): Routing Ospf Profile Parcel Id. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.create_lan_vpn_and_routing_ospf_parcel_association_for_service_endpoint.call_with_http_info(**kwargs)

    def create_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport(
        self,
        service_id,
        vpn_parcel_id,
        ethernet_id,
        **kwargs
    ):
        """create_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport  # noqa: E501

        Associate a LanVpnInterfaceEthernet parcel with a Tracker Parcel for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport(service_id, vpn_parcel_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_parcel_id (str): VPN Profile Parcel ID
            ethernet_id (str): Interface Profile Parcel ID

        Keyword Args:
            body (str): Tracker Profile Parcel Id. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_parcel_id'] = \
            vpn_parcel_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.create_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport_endpoint.call_with_http_info(**kwargs)

    def create_lan_vpn_interface_ethernet_parcel_for_service(
        self,
        service_id,
        vpn_id,
        **kwargs
    ):
        """create_lan_vpn_interface_ethernet_parcel_for_service  # noqa: E501

        Create a LanVpn InterfaceEthernet parcel for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_lan_vpn_interface_ethernet_parcel_for_service(service_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Lan Vpn Interface Ethernet Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.create_lan_vpn_interface_ethernet_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def create_lan_vpn_profile_parcel_for_service(
        self,
        service_id,
        **kwargs
    ):
        """create_lan_vpn_profile_parcel_for_service  # noqa: E501

        Create a Lan Vpn Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_lan_vpn_profile_parcel_for_service(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID

        Keyword Args:
            body (str): Lan Vpn Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.create_lan_vpn_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def create_logging_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """create_logging_profile_parcel_for_system  # noqa: E501

        Create a Logging Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_logging_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            body (str): Logging Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.create_logging_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def create_management_vpn_interface_ethernet_parcel_for_transport(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """create_management_vpn_interface_ethernet_parcel_for_transport  # noqa: E501

        Create a ManagementVpn InterfaceEthernet parcel for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_management_vpn_interface_ethernet_parcel_for_transport(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Management Vpn Interface Ethernet Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.create_management_vpn_interface_ethernet_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def create_management_vpn_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """create_management_vpn_profile_parcel_for_transport  # noqa: E501

        Create a Management Vpn Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_management_vpn_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            body (str): Management Vpn Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.create_management_vpn_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def create_ntp_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """create_ntp_profile_parcel_for_system  # noqa: E501

        Create a Ntp Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ntp_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            body (str): Ntp Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.create_ntp_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def create_omp_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """create_omp_profile_parcel_for_system  # noqa: E501

        Create a Omp Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_omp_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            body (str): Omp Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.create_omp_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def create_routing_bgp_profile_parcel_for_service(
        self,
        service_id,
        **kwargs
    ):
        """create_routing_bgp_profile_parcel_for_service  # noqa: E501

        Create a Routing Bgp Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_routing_bgp_profile_parcel_for_service(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID

        Keyword Args:
            body (str): Routing Bgp Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.create_routing_bgp_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def create_routing_ospf_profile_parcel_for_service(
        self,
        service_id,
        **kwargs
    ):
        """create_routing_ospf_profile_parcel_for_service  # noqa: E501

        Create a Routing Ospf Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_routing_ospf_profile_parcel_for_service(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID

        Keyword Args:
            body (str): Routing Ospf Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.create_routing_ospf_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def create_sdwan_config_profile_parcel_for_cli(
        self,
        cli_id,
        **kwargs
    ):
        """create_sdwan_config_profile_parcel_for_cli  # noqa: E501

        Create a config Profile Parcel for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sdwan_config_profile_parcel_for_cli(cli_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID

        Keyword Args:
            body (str): cli config Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        return self.create_sdwan_config_profile_parcel_for_cli_endpoint.call_with_http_info(**kwargs)

    def create_sdwan_feature_profile(
        self,
        **kwargs
    ):
        """create_sdwan_feature_profile  # noqa: E501

        Create a SDWAN  Feature Profile with profile type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sdwan_feature_profile(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            body (str): SDWAN Feature profile. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_sdwan_feature_profile_endpoint.call_with_http_info(**kwargs)

    def create_sdwan_service_feature_profile(
        self,
        **kwargs
    ):
        """create_sdwan_service_feature_profile  # noqa: E501

        Create a SDWAN Service Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sdwan_service_feature_profile(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            body (str): SDWAN Feature profile. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_sdwan_service_feature_profile_endpoint.call_with_http_info(**kwargs)

    def create_sdwan_system_feature_profile(
        self,
        **kwargs
    ):
        """create_sdwan_system_feature_profile  # noqa: E501

        Create a SDWAN System Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sdwan_system_feature_profile(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            body (str): SDWAN Feature profile. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_sdwan_system_feature_profile_endpoint.call_with_http_info(**kwargs)

    def create_sdwan_transport_feature_profile(
        self,
        **kwargs
    ):
        """create_sdwan_transport_feature_profile  # noqa: E501

        Create a SDWAN Transport Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_sdwan_transport_feature_profile(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            body (str): SDWAN Feature profile. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.create_sdwan_transport_feature_profile_endpoint.call_with_http_info(**kwargs)

    def create_tracker_profile_parcel_for_service(
        self,
        service_id,
        **kwargs
    ):
        """create_tracker_profile_parcel_for_service  # noqa: E501

        Create a Tracker Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tracker_profile_parcel_for_service(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID

        Keyword Args:
            body (str): Tracker Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.create_tracker_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def create_tracker_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """create_tracker_profile_parcel_for_transport  # noqa: E501

        Create a Tracker Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tracker_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            body (str): Tracker Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.create_tracker_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def create_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport(
        self,
        transport_id,
        vpn_parcel_id,
        ethernet_id,
        **kwargs
    ):
        """create_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport  # noqa: E501

        Associate a WanVpnInterfaceEthernet parcel with a Tracker Parcel for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport(transport_id, vpn_parcel_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_parcel_id (str): VPN Profile Parcel ID
            ethernet_id (str): Interface Profile Parcel ID

        Keyword Args:
            body (str): Tracker Profile Parcel Id. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_parcel_id'] = \
            vpn_parcel_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.create_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport_endpoint.call_with_http_info(**kwargs)

    def create_wan_vpn_interface_ethernet_parcel_for_transport(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """create_wan_vpn_interface_ethernet_parcel_for_transport  # noqa: E501

        Create a WanVpn InterfaceEthernet parcel for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wan_vpn_interface_ethernet_parcel_for_transport(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Wan Vpn Interface Ethernet Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.create_wan_vpn_interface_ethernet_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def create_wan_vpn_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """create_wan_vpn_profile_parcel_for_transport  # noqa: E501

        Create a Wan Vpn Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wan_vpn_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            body (str): Wan Vpn Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.create_wan_vpn_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_aaa_profile_parcel_for_system(
        self,
        system_id,
        aaa_id,
        **kwargs
    ):
        """delete_aaa_profile_parcel_for_system  # noqa: E501

        Delete a Aaa Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_aaa_profile_parcel_for_system(system_id, aaa_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            aaa_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['aaa_id'] = \
            aaa_id
        return self.delete_aaa_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def delete_banner_profile_parcel_for_system(
        self,
        system_id,
        banner_id,
        **kwargs
    ):
        """delete_banner_profile_parcel_for_system  # noqa: E501

        Delete a Banner Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_banner_profile_parcel_for_system(system_id, banner_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            banner_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['banner_id'] = \
            banner_id
        return self.delete_banner_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def delete_basic_profile_parcel_for_system(
        self,
        system_id,
        basic_id,
        **kwargs
    ):
        """delete_basic_profile_parcel_for_system  # noqa: E501

        Delete a Basic Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_basic_profile_parcel_for_system(system_id, basic_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            basic_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['basic_id'] = \
            basic_id
        return self.delete_basic_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def delete_bfd_profile_parcel_for_system(
        self,
        system_id,
        bfd_id,
        **kwargs
    ):
        """delete_bfd_profile_parcel_for_system  # noqa: E501

        Delete a Bfd Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_bfd_profile_parcel_for_system(system_id, bfd_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            bfd_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['bfd_id'] = \
            bfd_id
        return self.delete_bfd_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def delete_cellular_controller_and_cellular_profile_association_for_transport(
        self,
        transport_id,
        cellular_controller_id,
        cellular_profile_id,
        **kwargs
    ):
        """delete_cellular_controller_and_cellular_profile_association_for_transport  # noqa: E501

        Delete a CellularController parcel and a CellularProfile Parcel association for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_cellular_controller_and_cellular_profile_association_for_transport(transport_id, cellular_controller_id, cellular_profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_controller_id (str): Profile Parcel ID
            cellular_profile_id (str): Cellular Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_controller_id'] = \
            cellular_controller_id
        kwargs['cellular_profile_id'] = \
            cellular_profile_id
        return self.delete_cellular_controller_and_cellular_profile_association_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_cellular_controller_profile_parcel_for_transport(
        self,
        transport_id,
        cellular_controller_id,
        **kwargs
    ):
        """delete_cellular_controller_profile_parcel_for_transport  # noqa: E501

        Delete a Cellular Controller Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_cellular_controller_profile_parcel_for_transport(transport_id, cellular_controller_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_controller_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_controller_id'] = \
            cellular_controller_id
        return self.delete_cellular_controller_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_cellular_profile_profile_parcel_for_transport(
        self,
        transport_id,
        cellular_profile_id,
        **kwargs
    ):
        """delete_cellular_profile_profile_parcel_for_transport  # noqa: E501

        Delete a Cellular Profile Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_cellular_profile_profile_parcel_for_transport(transport_id, cellular_profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_profile_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_profile_id'] = \
            cellular_profile_id
        return self.delete_cellular_profile_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_config_profile_parcel_for_cli(
        self,
        cli_id,
        config_id,
        **kwargs
    ):
        """delete_config_profile_parcel_for_cli  # noqa: E501

        Delete a config Profile Parcel for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_config_profile_parcel_for_cli(cli_id, config_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID
            config_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        kwargs['config_id'] = \
            config_id
        return self.delete_config_profile_parcel_for_cli_endpoint.call_with_http_info(**kwargs)

    def delete_global_profile_parcel_for_system(
        self,
        system_id,
        global_id,
        **kwargs
    ):
        """delete_global_profile_parcel_for_system  # noqa: E501

        Delete a Global Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_global_profile_parcel_for_system(system_id, global_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            global_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['global_id'] = \
            global_id
        return self.delete_global_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def delete_lan_vpn_and_routing_bgp_association_for_service(
        self,
        service_id,
        vpn_id,
        bgp_id,
        **kwargs
    ):
        """delete_lan_vpn_and_routing_bgp_association_for_service  # noqa: E501

        Delete a LanVpn parcel and a RoutingBgp Parcel association for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_lan_vpn_and_routing_bgp_association_for_service(service_id, vpn_id, bgp_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            bgp_id (str): Routing Bgp Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['bgp_id'] = \
            bgp_id
        return self.delete_lan_vpn_and_routing_bgp_association_for_service_endpoint.call_with_http_info(**kwargs)

    def delete_lan_vpn_and_routing_ospf_association_for_service(
        self,
        service_id,
        vpn_id,
        ospf_id,
        **kwargs
    ):
        """delete_lan_vpn_and_routing_ospf_association_for_service  # noqa: E501

        Delete a LanVpn parcel and a RoutingOspf Parcel association for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_lan_vpn_and_routing_ospf_association_for_service(service_id, vpn_id, ospf_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ospf_id (str): Routing Ospf Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ospf_id'] = \
            ospf_id
        return self.delete_lan_vpn_and_routing_ospf_association_for_service_endpoint.call_with_http_info(**kwargs)

    def delete_lan_vpn_interface_ethernet_and_tracker_association_for_transport(
        self,
        service_id,
        vpn_id,
        ethernet_id,
        tracker_id,
        **kwargs
    ):
        """delete_lan_vpn_interface_ethernet_and_tracker_association_for_transport  # noqa: E501

        Delete a LanVpnInterfaceEthernet and a Tracker Parcel association for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_lan_vpn_interface_ethernet_and_tracker_association_for_transport(service_id, vpn_id, ethernet_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Profile Parcel ID
            tracker_id (str): Tracker Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.delete_lan_vpn_interface_ethernet_and_tracker_association_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_lan_vpn_interface_ethernet_for_service(
        self,
        service_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """delete_lan_vpn_interface_ethernet_for_service  # noqa: E501

        Delete a  LanVpn InterfaceEthernet Parcel for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_lan_vpn_interface_ethernet_for_service(service_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.delete_lan_vpn_interface_ethernet_for_service_endpoint.call_with_http_info(**kwargs)

    def delete_lan_vpn_profile_parcel_for_service(
        self,
        service_id,
        vpn_id,
        **kwargs
    ):
        """delete_lan_vpn_profile_parcel_for_service  # noqa: E501

        Delete a Lan Vpn Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_lan_vpn_profile_parcel_for_service(service_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.delete_lan_vpn_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def delete_logging_profile_parcel_for_system(
        self,
        system_id,
        logging_id,
        **kwargs
    ):
        """delete_logging_profile_parcel_for_system  # noqa: E501

        Delete a Logging Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_logging_profile_parcel_for_system(system_id, logging_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            logging_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['logging_id'] = \
            logging_id
        return self.delete_logging_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def delete_management_vpn_interface_ethernet_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """delete_management_vpn_interface_ethernet_for_transport  # noqa: E501

        Delete a  ManagementVpn InterfaceEthernet Parcel for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_management_vpn_interface_ethernet_for_transport(transport_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.delete_management_vpn_interface_ethernet_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_management_vpn_profile_parcel_for_transport(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """delete_management_vpn_profile_parcel_for_transport  # noqa: E501

        Delete a Management Vpn Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_management_vpn_profile_parcel_for_transport(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.delete_management_vpn_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_ntp_profile_parcel_for_system(
        self,
        system_id,
        ntp_id,
        **kwargs
    ):
        """delete_ntp_profile_parcel_for_system  # noqa: E501

        Delete a Ntp Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ntp_profile_parcel_for_system(system_id, ntp_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            ntp_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['ntp_id'] = \
            ntp_id
        return self.delete_ntp_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def delete_omp_profile_parcel_for_system(
        self,
        system_id,
        omp_id,
        **kwargs
    ):
        """delete_omp_profile_parcel_for_system  # noqa: E501

        Delete a Omp Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_omp_profile_parcel_for_system(system_id, omp_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            omp_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['omp_id'] = \
            omp_id
        return self.delete_omp_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def delete_routing_bgp_profile_parcel_for_service(
        self,
        service_id,
        bgp_id,
        **kwargs
    ):
        """delete_routing_bgp_profile_parcel_for_service  # noqa: E501

        Delete a Routing Bgp Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_routing_bgp_profile_parcel_for_service(service_id, bgp_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            bgp_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['bgp_id'] = \
            bgp_id
        return self.delete_routing_bgp_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def delete_routing_ospf_profile_parcel_for_service(
        self,
        service_id,
        ospf_id,
        **kwargs
    ):
        """delete_routing_ospf_profile_parcel_for_service  # noqa: E501

        Delete a Routing Ospf Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_routing_ospf_profile_parcel_for_service(service_id, ospf_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            ospf_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['ospf_id'] = \
            ospf_id
        return self.delete_routing_ospf_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def delete_sdwan_feature_profile_for_cli(
        self,
        cli_id,
        **kwargs
    ):
        """delete_sdwan_feature_profile_for_cli  # noqa: E501

        Delete Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sdwan_feature_profile_for_cli(cli_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        return self.delete_sdwan_feature_profile_for_cli_endpoint.call_with_http_info(**kwargs)

    def delete_sdwan_service_feature_profile(
        self,
        service_id,
        **kwargs
    ):
        """delete_sdwan_service_feature_profile  # noqa: E501

        Delete Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sdwan_service_feature_profile(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.delete_sdwan_service_feature_profile_endpoint.call_with_http_info(**kwargs)

    def delete_sdwan_system_feature_profile(
        self,
        system_id,
        **kwargs
    ):
        """delete_sdwan_system_feature_profile  # noqa: E501

        Delete Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sdwan_system_feature_profile(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.delete_sdwan_system_feature_profile_endpoint.call_with_http_info(**kwargs)

    def delete_sdwan_transport_feature_profile(
        self,
        transport_id,
        **kwargs
    ):
        """delete_sdwan_transport_feature_profile  # noqa: E501

        Delete Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sdwan_transport_feature_profile(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.delete_sdwan_transport_feature_profile_endpoint.call_with_http_info(**kwargs)

    def delete_tracker_profile_parcel_for_service(
        self,
        service_id,
        tracker_id,
        **kwargs
    ):
        """delete_tracker_profile_parcel_for_service  # noqa: E501

        Delete a Tracker Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tracker_profile_parcel_for_service(service_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            tracker_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.delete_tracker_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def delete_tracker_profile_parcel_for_transport(
        self,
        transport_id,
        tracker_id,
        **kwargs
    ):
        """delete_tracker_profile_parcel_for_transport  # noqa: E501

        Delete a Tracker Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tracker_profile_parcel_for_transport(transport_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            tracker_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.delete_tracker_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_wan_vpn_interface_ethernet_and_tracker_association_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        tracker_id,
        **kwargs
    ):
        """delete_wan_vpn_interface_ethernet_and_tracker_association_for_transport  # noqa: E501

        Delete a WanVpnInterfaceEthernet and a Tracker Parcel association for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_wan_vpn_interface_ethernet_and_tracker_association_for_transport(transport_id, vpn_id, ethernet_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Profile Parcel ID
            tracker_id (str): Tracker Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.delete_wan_vpn_interface_ethernet_and_tracker_association_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_wan_vpn_interface_ethernet_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """delete_wan_vpn_interface_ethernet_for_transport  # noqa: E501

        Delete a  WanVpn InterfaceEthernet Parcel for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_wan_vpn_interface_ethernet_for_transport(transport_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.delete_wan_vpn_interface_ethernet_for_transport_endpoint.call_with_http_info(**kwargs)

    def delete_wan_vpn_profile_parcel_for_transport(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """delete_wan_vpn_profile_parcel_for_transport  # noqa: E501

        Delete a Wan Vpn Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_wan_vpn_profile_parcel_for_transport(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.delete_wan_vpn_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_aaa_profile_parcel_for_system(
        self,
        system_id,
        aaa_id,
        **kwargs
    ):
        """edit_aaa_profile_parcel_for_system  # noqa: E501

        Update a Aaa Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_aaa_profile_parcel_for_system(system_id, aaa_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            aaa_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Aaa Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['aaa_id'] = \
            aaa_id
        return self.edit_aaa_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def edit_banner_profile_parcel_for_system(
        self,
        system_id,
        banner_id,
        **kwargs
    ):
        """edit_banner_profile_parcel_for_system  # noqa: E501

        Update a Banner Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_banner_profile_parcel_for_system(system_id, banner_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            banner_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Banner Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['banner_id'] = \
            banner_id
        return self.edit_banner_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def edit_basic_profile_parcel_for_system(
        self,
        system_id,
        basic_id,
        **kwargs
    ):
        """edit_basic_profile_parcel_for_system  # noqa: E501

        Update a Basic Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_basic_profile_parcel_for_system(system_id, basic_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            basic_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Basic Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['basic_id'] = \
            basic_id
        return self.edit_basic_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def edit_bfd_profile_parcel_for_system(
        self,
        system_id,
        bfd_id,
        **kwargs
    ):
        """edit_bfd_profile_parcel_for_system  # noqa: E501

        Update a Bfd Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_bfd_profile_parcel_for_system(system_id, bfd_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            bfd_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Bfd Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['bfd_id'] = \
            bfd_id
        return self.edit_bfd_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def edit_cellular_controller_and_cellular_profile_parcel_association_for_transport(
        self,
        transport_id,
        cellular_controller_id,
        cellular_profile_id,
        **kwargs
    ):
        """edit_cellular_controller_and_cellular_profile_parcel_association_for_transport  # noqa: E501

        Update a CellularController parcel and a CellularProfile Parcel association for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_cellular_controller_and_cellular_profile_parcel_association_for_transport(transport_id, cellular_controller_id, cellular_profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_controller_id (str): Profile Parcel ID
            cellular_profile_id (str): Cellular Profile ID

        Keyword Args:
            body (str): Cellular Profile Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_controller_id'] = \
            cellular_controller_id
        kwargs['cellular_profile_id'] = \
            cellular_profile_id
        return self.edit_cellular_controller_and_cellular_profile_parcel_association_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_cellular_controller_profile_parcel_for_transport(
        self,
        transport_id,
        cellular_controller_id,
        **kwargs
    ):
        """edit_cellular_controller_profile_parcel_for_transport  # noqa: E501

        Update a Cellular Controller Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_cellular_controller_profile_parcel_for_transport(transport_id, cellular_controller_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_controller_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Cellular Controller Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_controller_id'] = \
            cellular_controller_id
        return self.edit_cellular_controller_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_cellular_profile_profile_parcel_for_transport(
        self,
        transport_id,
        cellular_profile_id,
        **kwargs
    ):
        """edit_cellular_profile_profile_parcel_for_transport  # noqa: E501

        Update a Cellular Profile Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_cellular_profile_profile_parcel_for_transport(transport_id, cellular_profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_profile_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Cellular Profile Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_profile_id'] = \
            cellular_profile_id
        return self.edit_cellular_profile_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_config_profile_parcel_for_cli(
        self,
        cli_id,
        config_id,
        **kwargs
    ):
        """edit_config_profile_parcel_for_cli  # noqa: E501

        Update a config Profile Parcel for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_config_profile_parcel_for_cli(cli_id, config_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID
            config_id (str): Profile Parcel ID

        Keyword Args:
            body (str): cli config Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        kwargs['config_id'] = \
            config_id
        return self.edit_config_profile_parcel_for_cli_endpoint.call_with_http_info(**kwargs)

    def edit_global_profile_parcel_for_system(
        self,
        system_id,
        global_id,
        **kwargs
    ):
        """edit_global_profile_parcel_for_system  # noqa: E501

        Update a Global Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_global_profile_parcel_for_system(system_id, global_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            global_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Global Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['global_id'] = \
            global_id
        return self.edit_global_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def edit_lan_vpn_and_routing_bgp_parcel_association_for_service(
        self,
        service_id,
        vpn_id,
        bgp_id,
        **kwargs
    ):
        """edit_lan_vpn_and_routing_bgp_parcel_association_for_service  # noqa: E501

        Update a LanVpn parcel and a RoutingBgp Parcel association for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_lan_vpn_and_routing_bgp_parcel_association_for_service(service_id, vpn_id, bgp_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            bgp_id (str): Routing Bgp ID

        Keyword Args:
            body (str): Routing Bgp Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['bgp_id'] = \
            bgp_id
        return self.edit_lan_vpn_and_routing_bgp_parcel_association_for_service_endpoint.call_with_http_info(**kwargs)

    def edit_lan_vpn_and_routing_ospf_parcel_association_for_service(
        self,
        service_id,
        vpn_id,
        ospf_id,
        **kwargs
    ):
        """edit_lan_vpn_and_routing_ospf_parcel_association_for_service  # noqa: E501

        Update a LanVpn parcel and a RoutingOspf Parcel association for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_lan_vpn_and_routing_ospf_parcel_association_for_service(service_id, vpn_id, ospf_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ospf_id (str): Routing Ospf ID

        Keyword Args:
            body (str): Routing Ospf Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ospf_id'] = \
            ospf_id
        return self.edit_lan_vpn_and_routing_ospf_parcel_association_for_service_endpoint.call_with_http_info(**kwargs)

    def edit_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport(
        self,
        service_id,
        vpn_id,
        ethernet_id,
        tracker_id,
        **kwargs
    ):
        """edit_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport  # noqa: E501

        Update a LanVpnInterfaceEthernet parcel and a Tracker Parcel association for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport(service_id, vpn_id, ethernet_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Profile Parcel ID
            tracker_id (str): Tracker ID

        Keyword Args:
            body (str): Tracker Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.edit_lan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_lan_vpn_interface_ethernet_parcel_for_service(
        self,
        service_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """edit_lan_vpn_interface_ethernet_parcel_for_service  # noqa: E501

        Update a LanVpn InterfaceEthernet Parcel for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_lan_vpn_interface_ethernet_parcel_for_service(service_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface ID

        Keyword Args:
            body (str): Lan Vpn Interface Ethernet Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.edit_lan_vpn_interface_ethernet_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def edit_lan_vpn_profile_parcel_for_service(
        self,
        service_id,
        vpn_id,
        **kwargs
    ):
        """edit_lan_vpn_profile_parcel_for_service  # noqa: E501

        Update a Lan Vpn Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_lan_vpn_profile_parcel_for_service(service_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Lan Vpn Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.edit_lan_vpn_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def edit_logging_profile_parcel_for_system(
        self,
        system_id,
        logging_id,
        **kwargs
    ):
        """edit_logging_profile_parcel_for_system  # noqa: E501

        Update a Logging Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_logging_profile_parcel_for_system(system_id, logging_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            logging_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Logging Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['logging_id'] = \
            logging_id
        return self.edit_logging_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def edit_management_vpn_interface_ethernet_parcel_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """edit_management_vpn_interface_ethernet_parcel_for_transport  # noqa: E501

        Update a ManagementVpn InterfaceEthernet Parcel for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_management_vpn_interface_ethernet_parcel_for_transport(transport_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface ID

        Keyword Args:
            body (str): Management Vpn Interface Ethernet Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.edit_management_vpn_interface_ethernet_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_management_vpn_profile_parcel_for_transport(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """edit_management_vpn_profile_parcel_for_transport  # noqa: E501

        Update a Management Vpn Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_management_vpn_profile_parcel_for_transport(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Management Vpn Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.edit_management_vpn_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_ntp_profile_parcel_for_system(
        self,
        system_id,
        ntp_id,
        **kwargs
    ):
        """edit_ntp_profile_parcel_for_system  # noqa: E501

        Update a Ntp Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_ntp_profile_parcel_for_system(system_id, ntp_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            ntp_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Ntp Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['ntp_id'] = \
            ntp_id
        return self.edit_ntp_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def edit_omp_profile_parcel_for_system(
        self,
        system_id,
        omp_id,
        **kwargs
    ):
        """edit_omp_profile_parcel_for_system  # noqa: E501

        Update a Omp Profile Parcel for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_omp_profile_parcel_for_system(system_id, omp_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            omp_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Omp Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['omp_id'] = \
            omp_id
        return self.edit_omp_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def edit_routing_bgp_profile_parcel_for_service(
        self,
        service_id,
        bgp_id,
        **kwargs
    ):
        """edit_routing_bgp_profile_parcel_for_service  # noqa: E501

        Update a Routing Bgp Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_routing_bgp_profile_parcel_for_service(service_id, bgp_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            bgp_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Routing Bgp Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['bgp_id'] = \
            bgp_id
        return self.edit_routing_bgp_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def edit_routing_ospf_profile_parcel_for_service(
        self,
        service_id,
        ospf_id,
        **kwargs
    ):
        """edit_routing_ospf_profile_parcel_for_service  # noqa: E501

        Update a Routing Ospf Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_routing_ospf_profile_parcel_for_service(service_id, ospf_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            ospf_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Routing Ospf Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['ospf_id'] = \
            ospf_id
        return self.edit_routing_ospf_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def edit_sdwan_feature_profile(
        self,
        cli_id,
        **kwargs
    ):
        """edit_sdwan_feature_profile  # noqa: E501

        Edit a SDWAN Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_sdwan_feature_profile(cli_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile Id

        Keyword Args:
            body (str): SDWAN Feature profile. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        return self.edit_sdwan_feature_profile_endpoint.call_with_http_info(**kwargs)

    def edit_sdwan_service_feature_profile(
        self,
        service_id,
        **kwargs
    ):
        """edit_sdwan_service_feature_profile  # noqa: E501

        Edit a SDWAN Service Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_sdwan_service_feature_profile(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile Id

        Keyword Args:
            body (str): SDWAN Feature profile. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.edit_sdwan_service_feature_profile_endpoint.call_with_http_info(**kwargs)

    def edit_sdwan_system_feature_profile(
        self,
        system_id,
        **kwargs
    ):
        """edit_sdwan_system_feature_profile  # noqa: E501

        Edit a SDWAN System Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_sdwan_system_feature_profile(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile Id

        Keyword Args:
            body (str): SDWAN Feature profile. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.edit_sdwan_system_feature_profile_endpoint.call_with_http_info(**kwargs)

    def edit_sdwan_transport_feature_profile(
        self,
        transport_id,
        **kwargs
    ):
        """edit_sdwan_transport_feature_profile  # noqa: E501

        Edit a SDWAN Transport Feature Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_sdwan_transport_feature_profile(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile Id

        Keyword Args:
            body (str): SDWAN Feature profile. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.edit_sdwan_transport_feature_profile_endpoint.call_with_http_info(**kwargs)

    def edit_tracker_profile_parcel_for_service(
        self,
        service_id,
        tracker_id,
        **kwargs
    ):
        """edit_tracker_profile_parcel_for_service  # noqa: E501

        Update a Tracker Profile Parcel for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_tracker_profile_parcel_for_service(service_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            tracker_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Tracker Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.edit_tracker_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def edit_tracker_profile_parcel_for_transport(
        self,
        transport_id,
        tracker_id,
        **kwargs
    ):
        """edit_tracker_profile_parcel_for_transport  # noqa: E501

        Update a Tracker Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_tracker_profile_parcel_for_transport(transport_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            tracker_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Tracker Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.edit_tracker_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        tracker_id,
        **kwargs
    ):
        """edit_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport  # noqa: E501

        Update a WanVpnInterfaceEthernet parcel and a Tracker Parcel association for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport(transport_id, vpn_id, ethernet_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Profile Parcel ID
            tracker_id (str): Tracker ID

        Keyword Args:
            body (str): Tracker Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.edit_wan_vpn_interface_ethernet_and_tracker_parcel_association_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_wan_vpn_interface_ethernet_parcel_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """edit_wan_vpn_interface_ethernet_parcel_for_transport  # noqa: E501

        Update a WanVpn InterfaceEthernet Parcel for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_wan_vpn_interface_ethernet_parcel_for_transport(transport_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface ID

        Keyword Args:
            body (str): Wan Vpn Interface Ethernet Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.edit_wan_vpn_interface_ethernet_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def edit_wan_vpn_profile_parcel_for_transport(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """edit_wan_vpn_profile_parcel_for_transport  # noqa: E501

        Update a Wan Vpn Profile Parcel for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_wan_vpn_profile_parcel_for_transport(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            body (str): Wan Vpn Profile Parcel. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.edit_wan_vpn_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_aaa_profile_parcel_by_parcel_id_for_system(
        self,
        system_id,
        aaa_id,
        **kwargs
    ):
        """get_aaa_profile_parcel_by_parcel_id_for_system  # noqa: E501

        Get Aaa Profile Parcel by parcelId for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_aaa_profile_parcel_by_parcel_id_for_system(system_id, aaa_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            aaa_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['aaa_id'] = \
            aaa_id
        return self.get_aaa_profile_parcel_by_parcel_id_for_system_endpoint.call_with_http_info(**kwargs)

    def get_aaa_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """get_aaa_profile_parcel_for_system  # noqa: E501

        Get Aaa Profile Parcels for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_aaa_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.get_aaa_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def get_banner_profile_parcel_by_parcel_id_for_system(
        self,
        system_id,
        banner_id,
        **kwargs
    ):
        """get_banner_profile_parcel_by_parcel_id_for_system  # noqa: E501

        Get Banner Profile Parcel by parcelId for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_banner_profile_parcel_by_parcel_id_for_system(system_id, banner_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            banner_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['banner_id'] = \
            banner_id
        return self.get_banner_profile_parcel_by_parcel_id_for_system_endpoint.call_with_http_info(**kwargs)

    def get_banner_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """get_banner_profile_parcel_for_system  # noqa: E501

        Get Banner Profile Parcels for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_banner_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.get_banner_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def get_basic_profile_parcel_by_parcel_id_for_system(
        self,
        system_id,
        basic_id,
        **kwargs
    ):
        """get_basic_profile_parcel_by_parcel_id_for_system  # noqa: E501

        Get Basic Profile Parcel by parcelId for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_basic_profile_parcel_by_parcel_id_for_system(system_id, basic_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            basic_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['basic_id'] = \
            basic_id
        return self.get_basic_profile_parcel_by_parcel_id_for_system_endpoint.call_with_http_info(**kwargs)

    def get_basic_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """get_basic_profile_parcel_for_system  # noqa: E501

        Get Basic Profile Parcels for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_basic_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.get_basic_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def get_bfd_profile_parcel_by_parcel_id_for_system(
        self,
        system_id,
        bfd_id,
        **kwargs
    ):
        """get_bfd_profile_parcel_by_parcel_id_for_system  # noqa: E501

        Get Bfd Profile Parcel by parcelId for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bfd_profile_parcel_by_parcel_id_for_system(system_id, bfd_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            bfd_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['bfd_id'] = \
            bfd_id
        return self.get_bfd_profile_parcel_by_parcel_id_for_system_endpoint.call_with_http_info(**kwargs)

    def get_bfd_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """get_bfd_profile_parcel_for_system  # noqa: E501

        Get Bfd Profile Parcels for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_bfd_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.get_bfd_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def get_cedge_system_global_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_cedge_system_global_parcel_schema_by_schema_type  # noqa: E501

        Get a Cedge System Global Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cedge_system_global_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_cedge_system_global_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_cellular_controller_associated_cellular_profile_parcel_by_parcel_id_for_transport(
        self,
        transport_id,
        cellular_controller_id,
        cellular_profile_id,
        **kwargs
    ):
        """get_cellular_controller_associated_cellular_profile_parcel_by_parcel_id_for_transport  # noqa: E501

        Get CellularController parcel associated CellularProfile Parcel by cellularProfileId for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cellular_controller_associated_cellular_profile_parcel_by_parcel_id_for_transport(transport_id, cellular_controller_id, cellular_profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_controller_id (str): Profile Parcel ID
            cellular_profile_id (str): Cellular Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_controller_id'] = \
            cellular_controller_id
        kwargs['cellular_profile_id'] = \
            cellular_profile_id
        return self.get_cellular_controller_associated_cellular_profile_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_cellular_controller_associated_cellular_profile_parcels_for_transport(
        self,
        transport_id,
        cellular_controller_id,
        **kwargs
    ):
        """get_cellular_controller_associated_cellular_profile_parcels_for_transport  # noqa: E501

        Get CellularController associated Cellular Profile Parcels for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cellular_controller_associated_cellular_profile_parcels_for_transport(transport_id, cellular_controller_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_controller_id (str): Feature Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_controller_id'] = \
            cellular_controller_id
        return self.get_cellular_controller_associated_cellular_profile_parcels_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_cellular_controller_profile_parcel_by_parcel_id_for_transport(
        self,
        transport_id,
        cellular_controller_id,
        **kwargs
    ):
        """get_cellular_controller_profile_parcel_by_parcel_id_for_transport  # noqa: E501

        Get Cellular Controller Profile Parcel by parcelId for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cellular_controller_profile_parcel_by_parcel_id_for_transport(transport_id, cellular_controller_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_controller_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_controller_id'] = \
            cellular_controller_id
        return self.get_cellular_controller_profile_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_cellular_controller_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """get_cellular_controller_profile_parcel_for_transport  # noqa: E501

        Get Cellular Controller Profile Parcels for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cellular_controller_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.get_cellular_controller_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_cellular_profile_profile_parcel_by_parcel_id_for_transport(
        self,
        transport_id,
        cellular_profile_id,
        **kwargs
    ):
        """get_cellular_profile_profile_parcel_by_parcel_id_for_transport  # noqa: E501

        Get Cellular Profile Profile Parcel by parcelId for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cellular_profile_profile_parcel_by_parcel_id_for_transport(transport_id, cellular_profile_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            cellular_profile_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['cellular_profile_id'] = \
            cellular_profile_id
        return self.get_cellular_profile_profile_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_cellular_profile_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """get_cellular_profile_profile_parcel_for_transport  # noqa: E501

        Get Cellular Profile Profile Parcels for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cellular_profile_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.get_cellular_profile_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_config_profile_parcel_by_parcel_id_for_cli(
        self,
        cli_id,
        config_id,
        **kwargs
    ):
        """get_config_profile_parcel_by_parcel_id_for_cli  # noqa: E501

        Get config Profile Parcel by configId for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_config_profile_parcel_by_parcel_id_for_cli(cli_id, config_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID
            config_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        kwargs['config_id'] = \
            config_id
        return self.get_config_profile_parcel_by_parcel_id_for_cli_endpoint.call_with_http_info(**kwargs)

    def get_config_profile_parcel_for_cli(
        self,
        cli_id,
        **kwargs
    ):
        """get_config_profile_parcel_for_cli  # noqa: E501

        Get config Profile Parcels for cli feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_config_profile_parcel_for_cli(cli_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        return self.get_config_profile_parcel_for_cli_endpoint.call_with_http_info(**kwargs)

    def get_global_profile_parcel_by_parcel_id_for_system(
        self,
        system_id,
        global_id,
        **kwargs
    ):
        """get_global_profile_parcel_by_parcel_id_for_system  # noqa: E501

        Get Global Profile Parcel by parcelId for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_global_profile_parcel_by_parcel_id_for_system(system_id, global_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            global_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['global_id'] = \
            global_id
        return self.get_global_profile_parcel_by_parcel_id_for_system_endpoint.call_with_http_info(**kwargs)

    def get_global_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """get_global_profile_parcel_for_system  # noqa: E501

        Get Global Profile Parcels for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_global_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.get_global_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def get_interface_ethernet_parcels_for_service_lan_vpn(
        self,
        service_id,
        vpn_id,
        **kwargs
    ):
        """get_interface_ethernet_parcels_for_service_lan_vpn  # noqa: E501

        Get InterfaceEthernet Parcels for service LanVpn Parcel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_interface_ethernet_parcels_for_service_lan_vpn(service_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Feature Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.get_interface_ethernet_parcels_for_service_lan_vpn_endpoint.call_with_http_info(**kwargs)

    def get_interface_ethernet_parcels_for_transport_management_vpn(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """get_interface_ethernet_parcels_for_transport_management_vpn  # noqa: E501

        Get InterfaceEthernet Parcels for transport ManagementVpn Parcel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_interface_ethernet_parcels_for_transport_management_vpn(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Feature Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.get_interface_ethernet_parcels_for_transport_management_vpn_endpoint.call_with_http_info(**kwargs)

    def get_interface_ethernet_parcels_for_transport_wan_vpn(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """get_interface_ethernet_parcels_for_transport_wan_vpn  # noqa: E501

        Get InterfaceEthernet Parcels for transport WanVpn Parcel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_interface_ethernet_parcels_for_transport_wan_vpn(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Feature Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.get_interface_ethernet_parcels_for_transport_wan_vpn_endpoint.call_with_http_info(**kwargs)

    def get_lan_vpn_associated_routing_bgp_parcel_by_parcel_id_for_service(
        self,
        service_id,
        vpn_id,
        bgp_id,
        **kwargs
    ):
        """get_lan_vpn_associated_routing_bgp_parcel_by_parcel_id_for_service  # noqa: E501

        Get LanVpn parcel associated RoutingBgp Parcel by bgpId for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lan_vpn_associated_routing_bgp_parcel_by_parcel_id_for_service(service_id, vpn_id, bgp_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            bgp_id (str): Routing Bgp Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['bgp_id'] = \
            bgp_id
        return self.get_lan_vpn_associated_routing_bgp_parcel_by_parcel_id_for_service_endpoint.call_with_http_info(**kwargs)

    def get_lan_vpn_associated_routing_bgp_parcels_for_service(
        self,
        service_id,
        vpn_id,
        **kwargs
    ):
        """get_lan_vpn_associated_routing_bgp_parcels_for_service  # noqa: E501

        Get LanVpn associated Routing Bgp Parcels for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lan_vpn_associated_routing_bgp_parcels_for_service(service_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Feature Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.get_lan_vpn_associated_routing_bgp_parcels_for_service_endpoint.call_with_http_info(**kwargs)

    def get_lan_vpn_associated_routing_ospf_parcel_by_parcel_id_for_service(
        self,
        service_id,
        vpn_id,
        ospf_id,
        **kwargs
    ):
        """get_lan_vpn_associated_routing_ospf_parcel_by_parcel_id_for_service  # noqa: E501

        Get LanVpn parcel associated RoutingOspf Parcel by ospfId for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lan_vpn_associated_routing_ospf_parcel_by_parcel_id_for_service(service_id, vpn_id, ospf_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ospf_id (str): Routing Ospf Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ospf_id'] = \
            ospf_id
        return self.get_lan_vpn_associated_routing_ospf_parcel_by_parcel_id_for_service_endpoint.call_with_http_info(**kwargs)

    def get_lan_vpn_associated_routing_ospf_parcels_for_service(
        self,
        service_id,
        vpn_id,
        **kwargs
    ):
        """get_lan_vpn_associated_routing_ospf_parcels_for_service  # noqa: E501

        Get LanVpn associated Routing Ospf Parcels for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lan_vpn_associated_routing_ospf_parcels_for_service(service_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Feature Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.get_lan_vpn_associated_routing_ospf_parcels_for_service_endpoint.call_with_http_info(**kwargs)

    def get_lan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport(
        self,
        service_id,
        vpn_id,
        ethernet_id,
        tracker_id,
        **kwargs
    ):
        """get_lan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport  # noqa: E501

        Get LanVpnInterfaceEthernet associated Tracker Parcel by trackerId for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport(service_id, vpn_id, ethernet_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Profile Parcel ID
            tracker_id (str): Tracker Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.get_lan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_lan_vpn_interface_ethernet_associated_tracker_parcels_for_transport(
        self,
        service_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """get_lan_vpn_interface_ethernet_associated_tracker_parcels_for_transport  # noqa: E501

        Get LanVpnInterfaceEthernet associated Tracker Parcels for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lan_vpn_interface_ethernet_associated_tracker_parcels_for_transport(service_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Feature Parcel ID
            ethernet_id (str): Interface Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.get_lan_vpn_interface_ethernet_associated_tracker_parcels_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_lan_vpn_interface_ethernet_parcel_by_parcel_id_for_service(
        self,
        service_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """get_lan_vpn_interface_ethernet_parcel_by_parcel_id_for_service  # noqa: E501

        Get LanVpn InterfaceEthernet Parcel by ethernetId for service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lan_vpn_interface_ethernet_parcel_by_parcel_id_for_service(service_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.get_lan_vpn_interface_ethernet_parcel_by_parcel_id_for_service_endpoint.call_with_http_info(**kwargs)

    def get_lan_vpn_profile_parcel_by_parcel_id_for_service(
        self,
        service_id,
        vpn_id,
        **kwargs
    ):
        """get_lan_vpn_profile_parcel_by_parcel_id_for_service  # noqa: E501

        Get Lan Vpn Profile Parcel by parcelId for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lan_vpn_profile_parcel_by_parcel_id_for_service(service_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.get_lan_vpn_profile_parcel_by_parcel_id_for_service_endpoint.call_with_http_info(**kwargs)

    def get_lan_vpn_profile_parcel_for_service(
        self,
        service_id,
        **kwargs
    ):
        """get_lan_vpn_profile_parcel_for_service  # noqa: E501

        Get Lan Vpn Profile Parcels for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lan_vpn_profile_parcel_for_service(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.get_lan_vpn_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def get_logging_profile_parcel_by_parcel_id_for_system(
        self,
        system_id,
        logging_id,
        **kwargs
    ):
        """get_logging_profile_parcel_by_parcel_id_for_system  # noqa: E501

        Get Logging Profile Parcel by parcelId for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_logging_profile_parcel_by_parcel_id_for_system(system_id, logging_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            logging_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['logging_id'] = \
            logging_id
        return self.get_logging_profile_parcel_by_parcel_id_for_system_endpoint.call_with_http_info(**kwargs)

    def get_logging_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """get_logging_profile_parcel_for_system  # noqa: E501

        Get Logging Profile Parcels for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_logging_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.get_logging_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def get_management_vpn_interface_ethernet_parcel_by_parcel_id_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """get_management_vpn_interface_ethernet_parcel_by_parcel_id_for_transport  # noqa: E501

        Get ManagementVpn InterfaceEthernet Parcel by ethernetId for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_management_vpn_interface_ethernet_parcel_by_parcel_id_for_transport(transport_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.get_management_vpn_interface_ethernet_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_management_vpn_profile_parcel_by_parcel_id_for_transport(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """get_management_vpn_profile_parcel_by_parcel_id_for_transport  # noqa: E501

        Get Management Vpn Profile Parcel by parcelId for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_management_vpn_profile_parcel_by_parcel_id_for_transport(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.get_management_vpn_profile_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_management_vpn_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """get_management_vpn_profile_parcel_for_transport  # noqa: E501

        Get Management Vpn Profile Parcels for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_management_vpn_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.get_management_vpn_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_ntp_profile_parcel_by_parcel_id_for_system(
        self,
        system_id,
        ntp_id,
        **kwargs
    ):
        """get_ntp_profile_parcel_by_parcel_id_for_system  # noqa: E501

        Get Ntp Profile Parcel by parcelId for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ntp_profile_parcel_by_parcel_id_for_system(system_id, ntp_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            ntp_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['ntp_id'] = \
            ntp_id
        return self.get_ntp_profile_parcel_by_parcel_id_for_system_endpoint.call_with_http_info(**kwargs)

    def get_ntp_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """get_ntp_profile_parcel_for_system  # noqa: E501

        Get Ntp Profile Parcels for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ntp_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.get_ntp_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def get_omp_profile_parcel_by_parcel_id_for_system(
        self,
        system_id,
        omp_id,
        **kwargs
    ):
        """get_omp_profile_parcel_by_parcel_id_for_system  # noqa: E501

        Get Omp Profile Parcel by parcelId for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_omp_profile_parcel_by_parcel_id_for_system(system_id, omp_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID
            omp_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        kwargs['omp_id'] = \
            omp_id
        return self.get_omp_profile_parcel_by_parcel_id_for_system_endpoint.call_with_http_info(**kwargs)

    def get_omp_profile_parcel_for_system(
        self,
        system_id,
        **kwargs
    ):
        """get_omp_profile_parcel_for_system  # noqa: E501

        Get Omp Profile Parcels for System feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_omp_profile_parcel_for_system(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.get_omp_profile_parcel_for_system_endpoint.call_with_http_info(**kwargs)

    def get_routing_bgp_profile_parcel_by_parcel_id_for_service(
        self,
        service_id,
        bgp_id,
        **kwargs
    ):
        """get_routing_bgp_profile_parcel_by_parcel_id_for_service  # noqa: E501

        Get Routing Bgp Profile Parcel by parcelId for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_routing_bgp_profile_parcel_by_parcel_id_for_service(service_id, bgp_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            bgp_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['bgp_id'] = \
            bgp_id
        return self.get_routing_bgp_profile_parcel_by_parcel_id_for_service_endpoint.call_with_http_info(**kwargs)

    def get_routing_bgp_profile_parcel_for_service(
        self,
        service_id,
        **kwargs
    ):
        """get_routing_bgp_profile_parcel_for_service  # noqa: E501

        Get Routing Bgp Profile Parcels for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_routing_bgp_profile_parcel_for_service(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.get_routing_bgp_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def get_routing_ospf_profile_parcel_by_parcel_id_for_service(
        self,
        service_id,
        ospf_id,
        **kwargs
    ):
        """get_routing_ospf_profile_parcel_by_parcel_id_for_service  # noqa: E501

        Get Routing Ospf Profile Parcel by parcelId for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_routing_ospf_profile_parcel_by_parcel_id_for_service(service_id, ospf_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            ospf_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['ospf_id'] = \
            ospf_id
        return self.get_routing_ospf_profile_parcel_by_parcel_id_for_service_endpoint.call_with_http_info(**kwargs)

    def get_routing_ospf_profile_parcel_for_service(
        self,
        service_id,
        **kwargs
    ):
        """get_routing_ospf_profile_parcel_for_service  # noqa: E501

        Get Routing Ospf Profile Parcels for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_routing_ospf_profile_parcel_for_service(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.get_routing_ospf_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_feature_profile_by_profile_id(
        self,
        cli_id,
        **kwargs
    ):
        """get_sdwan_feature_profile_by_profile_id  # noqa: E501

        Get a SDWAN Feature Profile with Cli profile type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_feature_profile_by_profile_id(cli_id, async_req=True)
        >>> result = thread.get()

        Args:
            cli_id (str): Feature Profile Id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['cli_id'] = \
            cli_id
        return self.get_sdwan_feature_profile_by_profile_id_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_feature_profile_by_sdwan_family(
        self,
        **kwargs
    ):
        """get_sdwan_feature_profile_by_sdwan_family  # noqa: E501

        Get all SDWAN Feature Profiles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_feature_profile_by_sdwan_family(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            offset (int): Pagination offset. [optional]
            limit (int): Pagination limit. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_sdwan_feature_profile_by_sdwan_family_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_feature_profiles_by_family_and_type(
        self,
        **kwargs
    ):
        """get_sdwan_feature_profiles_by_family_and_type  # noqa: E501

        Get all SDWAN Feature Profiles with giving Family and profile type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_feature_profiles_by_family_and_type(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            offset (int): Pagination offset. [optional]
            limit (int): Pagination limit. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_sdwan_feature_profiles_by_family_and_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_service_feature_profile_by_profile_id(
        self,
        service_id,
        **kwargs
    ):
        """get_sdwan_service_feature_profile_by_profile_id  # noqa: E501

        Get a SDWAN Service Feature Profile with serviceId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_service_feature_profile_by_profile_id(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile Id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.get_sdwan_service_feature_profile_by_profile_id_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_service_feature_profiles(
        self,
        **kwargs
    ):
        """get_sdwan_service_feature_profiles  # noqa: E501

        Get all SDWAN Feature Profiles with giving Family and profile type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_service_feature_profiles(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            offset (int): Pagination offset. [optional]
            limit (int): Pagination limit. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_sdwan_service_feature_profiles_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_service_lan_vpn_interface_ethernet_parcel_schema_by_schema(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_service_lan_vpn_interface_ethernet_parcel_schema_by_schema  # noqa: E501

        Get a SDWAN Service LanVpn InterfaceEthernet Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_service_lan_vpn_interface_ethernet_parcel_schema_by_schema(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_service_lan_vpn_interface_ethernet_parcel_schema_by_schema_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_service_lan_vpn_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_service_lan_vpn_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN Service LanVpn Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_service_lan_vpn_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_service_lan_vpn_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_service_routing_bgp_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_service_routing_bgp_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN Service RoutingBgp Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_service_routing_bgp_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_service_routing_bgp_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_service_routing_ospf_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_service_routing_ospf_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN Service RoutingOspf Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_service_routing_ospf_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_service_routing_ospf_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_service_tracker_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_service_tracker_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN Service Tracker Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_service_tracker_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_service_tracker_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_system_aaa_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_system_aaa_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN System Aaa Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_system_aaa_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_system_aaa_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_system_banner_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_system_banner_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN System Banner Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_system_banner_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_system_banner_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_system_basic_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_system_basic_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN System Basic Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_system_basic_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_system_basic_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_system_bfd_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_system_bfd_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN System Bfd Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_system_bfd_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_system_bfd_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_system_feature_profile_by_profile_id(
        self,
        system_id,
        **kwargs
    ):
        """get_sdwan_system_feature_profile_by_profile_id  # noqa: E501

        Get a SDWAN System Feature Profile with systemId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_system_feature_profile_by_profile_id(system_id, async_req=True)
        >>> result = thread.get()

        Args:
            system_id (str): Feature Profile Id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['system_id'] = \
            system_id
        return self.get_sdwan_system_feature_profile_by_profile_id_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_system_feature_profiles(
        self,
        **kwargs
    ):
        """get_sdwan_system_feature_profiles  # noqa: E501

        Get all SDWAN Feature Profiles with giving Family and profile type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_system_feature_profiles(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            offset (int): Pagination offset. [optional]
            limit (int): Pagination limit. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_sdwan_system_feature_profiles_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_system_logging_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_system_logging_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN System Logging Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_system_logging_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_system_logging_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_system_ntp_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_system_ntp_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN System Ntp Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_system_ntp_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_system_ntp_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_system_omp_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_system_omp_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN System Omp Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_system_omp_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_system_omp_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_transport_cellular_controller_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_transport_cellular_controller_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN Transport CellularController Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_transport_cellular_controller_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_transport_cellular_controller_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_transport_cellular_profile_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_transport_cellular_profile_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN Transport CellularProfile Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_transport_cellular_profile_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_transport_cellular_profile_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_transport_feature_profile_by_profile_id(
        self,
        transport_id,
        **kwargs
    ):
        """get_sdwan_transport_feature_profile_by_profile_id  # noqa: E501

        Get a SDWAN Transport Feature Profile with transportId  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_transport_feature_profile_by_profile_id(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile Id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.get_sdwan_transport_feature_profile_by_profile_id_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_transport_feature_profiles(
        self,
        **kwargs
    ):
        """get_sdwan_transport_feature_profiles  # noqa: E501

        Get all SDWAN Feature Profiles with giving Family and profile type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_transport_feature_profiles(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            offset (int): Pagination offset. [optional]
            limit (int): Pagination limit. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_sdwan_transport_feature_profiles_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_transport_management_vpn_interface_ethernet_parcel_schema_by_schema(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_transport_management_vpn_interface_ethernet_parcel_schema_by_schema  # noqa: E501

        Get a SDWAN Transport ManagementVpn InterfaceEthernet Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_transport_management_vpn_interface_ethernet_parcel_schema_by_schema(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_transport_management_vpn_interface_ethernet_parcel_schema_by_schema_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_transport_management_vpn_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_transport_management_vpn_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN Transport ManagementVpn Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_transport_management_vpn_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_transport_management_vpn_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_transport_tracker_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_transport_tracker_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN Transport Tracker Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_transport_tracker_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_transport_tracker_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_transport_wan_vpn_interface_ethernet_parcel_schema_by_schema(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_transport_wan_vpn_interface_ethernet_parcel_schema_by_schema  # noqa: E501

        Get a SDWAN Transport WanVpn InterfaceEthernet Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_transport_wan_vpn_interface_ethernet_parcel_schema_by_schema(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_transport_wan_vpn_interface_ethernet_parcel_schema_by_schema_endpoint.call_with_http_info(**kwargs)

    def get_sdwan_transport_wan_vpn_parcel_schema_by_schema_type(
        self,
        schema_type,
        **kwargs
    ):
        """get_sdwan_transport_wan_vpn_parcel_schema_by_schema_type  # noqa: E501

        Get a SDWAN Transport WanVpn Parcel Schema by Schema Type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sdwan_transport_wan_vpn_parcel_schema_by_schema_type(schema_type, async_req=True)
        >>> result = thread.get()

        Args:
            schema_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['schema_type'] = \
            schema_type
        return self.get_sdwan_transport_wan_vpn_parcel_schema_by_schema_type_endpoint.call_with_http_info(**kwargs)

    def get_tracker_profile_parcel_by_parcel_id_for_service(
        self,
        service_id,
        tracker_id,
        **kwargs
    ):
        """get_tracker_profile_parcel_by_parcel_id_for_service  # noqa: E501

        Get Tracker Profile Parcel by parcelId for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tracker_profile_parcel_by_parcel_id_for_service(service_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID
            tracker_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.get_tracker_profile_parcel_by_parcel_id_for_service_endpoint.call_with_http_info(**kwargs)

    def get_tracker_profile_parcel_by_parcel_id_for_transport(
        self,
        transport_id,
        tracker_id,
        **kwargs
    ):
        """get_tracker_profile_parcel_by_parcel_id_for_transport  # noqa: E501

        Get Tracker Profile Parcel by parcelId for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tracker_profile_parcel_by_parcel_id_for_transport(transport_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            tracker_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.get_tracker_profile_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_tracker_profile_parcel_for_service(
        self,
        service_id,
        **kwargs
    ):
        """get_tracker_profile_parcel_for_service  # noqa: E501

        Get Tracker Profile Parcels for Service feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tracker_profile_parcel_for_service(service_id, async_req=True)
        >>> result = thread.get()

        Args:
            service_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['service_id'] = \
            service_id
        return self.get_tracker_profile_parcel_for_service_endpoint.call_with_http_info(**kwargs)

    def get_tracker_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """get_tracker_profile_parcel_for_transport  # noqa: E501

        Get Tracker Profile Parcels for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_tracker_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.get_tracker_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_wan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        tracker_id,
        **kwargs
    ):
        """get_wan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport  # noqa: E501

        Get WanVpnInterfaceEthernet associated Tracker Parcel by trackerId for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport(transport_id, vpn_id, ethernet_id, tracker_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Profile Parcel ID
            tracker_id (str): Tracker Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        kwargs['tracker_id'] = \
            tracker_id
        return self.get_wan_vpn_interface_ethernet_associated_tracker_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_wan_vpn_interface_ethernet_associated_tracker_parcels_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """get_wan_vpn_interface_ethernet_associated_tracker_parcels_for_transport  # noqa: E501

        Get WanVpnInterfaceEthernet associated Tracker Parcels for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wan_vpn_interface_ethernet_associated_tracker_parcels_for_transport(transport_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Feature Parcel ID
            ethernet_id (str): Interface Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.get_wan_vpn_interface_ethernet_associated_tracker_parcels_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_wan_vpn_interface_ethernet_parcel_by_parcel_id_for_transport(
        self,
        transport_id,
        vpn_id,
        ethernet_id,
        **kwargs
    ):
        """get_wan_vpn_interface_ethernet_parcel_by_parcel_id_for_transport  # noqa: E501

        Get WanVpn InterfaceEthernet Parcel by ethernetId for transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wan_vpn_interface_ethernet_parcel_by_parcel_id_for_transport(transport_id, vpn_id, ethernet_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID
            ethernet_id (str): Interface Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        kwargs['ethernet_id'] = \
            ethernet_id
        return self.get_wan_vpn_interface_ethernet_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_wan_vpn_profile_parcel_by_parcel_id_for_transport(
        self,
        transport_id,
        vpn_id,
        **kwargs
    ):
        """get_wan_vpn_profile_parcel_by_parcel_id_for_transport  # noqa: E501

        Get Wan Vpn Profile Parcel by parcelId for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wan_vpn_profile_parcel_by_parcel_id_for_transport(transport_id, vpn_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID
            vpn_id (str): Profile Parcel ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        kwargs['vpn_id'] = \
            vpn_id
        return self.get_wan_vpn_profile_parcel_by_parcel_id_for_transport_endpoint.call_with_http_info(**kwargs)

    def get_wan_vpn_profile_parcel_for_transport(
        self,
        transport_id,
        **kwargs
    ):
        """get_wan_vpn_profile_parcel_for_transport  # noqa: E501

        Get Wan Vpn Profile Parcels for Transport feature profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wan_vpn_profile_parcel_for_transport(transport_id, async_req=True)
        >>> result = thread.get()

        Args:
            transport_id (str): Feature Profile ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['transport_id'] = \
            transport_id
        return self.get_wan_vpn_profile_parcel_for_transport_endpoint.call_with_http_info(**kwargs)

