# openapi_client.RealTimeMonitoringSDWANStatisticsApi

All URIs are relative to *https://1.1.1.1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_sd_wan_global_drop_statistics**](RealTimeMonitoringSDWANStatisticsApi.md#get_sd_wan_global_drop_statistics) | **GET** /device/sdwan-global-drop-statistics | 
[**get_sd_wan_stats**](RealTimeMonitoringSDWANStatisticsApi.md#get_sd_wan_stats) | **GET** /device/sdwan-stats | 


# **get_sd_wan_global_drop_statistics**
> {str: (bool, date, datetime, dict, float, int, list, str, none_type)} get_sd_wan_global_drop_statistics(device_id)



Get SD-WAN global drop statistics detail from device (Real Time)

### Example


```python
import time
import openapi_client
from openapi_client.api import real_time_monitoring_sdwan_statistics_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = real_time_monitoring_sdwan_statistics_api.RealTimeMonitoringSDWANStatisticsApi(api_client)
    device_id = "deviceId_example" # str | Device IP

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_sd_wan_global_drop_statistics(device_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling RealTimeMonitoringSDWANStatisticsApi->get_sd_wan_global_drop_statistics: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **str**| Device IP |

### Return type

**{str: (bool, date, datetime, dict, float, int, list, str, none_type)}**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_sd_wan_stats**
> {str: (bool, date, datetime, dict, float, int, list, str, none_type)} get_sd_wan_stats(device_id)



Get SD-WAN statistics detail from device (Real Time)

### Example


```python
import time
import openapi_client
from openapi_client.api import real_time_monitoring_sdwan_statistics_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = real_time_monitoring_sdwan_statistics_api.RealTimeMonitoringSDWANStatisticsApi(api_client)
    device_id = "deviceId_example" # str | Device IP

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_sd_wan_stats(device_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling RealTimeMonitoringSDWANStatisticsApi->get_sd_wan_stats: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **device_id** | **str**| Device IP |

### Return type

**{str: (bool, date, datetime, dict, float, int, list, str, none_type)}**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

