# openapi_client.ConfigurationSegmentsApi

All URIs are relative to *https://1.1.1.1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_segment**](ConfigurationSegmentsApi.md#create_segment) | **POST** /segment | 
[**delete_segment**](ConfigurationSegmentsApi.md#delete_segment) | **DELETE** /segment/{id} | 
[**edit_segment**](ConfigurationSegmentsApi.md#edit_segment) | **PUT** /segment/{id} | 
[**get_segment**](ConfigurationSegmentsApi.md#get_segment) | **GET** /segment/{id} | 
[**get_segments**](ConfigurationSegmentsApi.md#get_segments) | **GET** /segment | 


# **create_segment**
> {str: (bool, date, datetime, dict, float, int, list, str, none_type)} create_segment()



Create network segment

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_segments_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_segments_api.ConfigurationSegmentsApi(api_client)
    body = {} # {str: (bool, date, datetime, dict, float, int, list, str, none_type)} | Network segment (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.create_segment(body=body)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationSegmentsApi->create_segment: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | **{str: (bool, date, datetime, dict, float, int, list, str, none_type)}**| Network segment | [optional]

### Return type

**{str: (bool, date, datetime, dict, float, int, list, str, none_type)}**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_segment**
> delete_segment(id)



Delete network segment

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_segments_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_segments_api.ConfigurationSegmentsApi(api_client)
    id = "id_example" # str | Segment Id

    # example passing only required values which don't have defaults set
    try:
        api_instance.delete_segment(id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationSegmentsApi->delete_segment: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**| Segment Id |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_segment**
> edit_segment(id)



Edit network segment

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_segments_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_segments_api.ConfigurationSegmentsApi(api_client)
    id = "id_example" # str | Segment Id
    body = {} # {str: (bool, date, datetime, dict, float, int, list, str, none_type)} | Network segment (optional)

    # example passing only required values which don't have defaults set
    try:
        api_instance.edit_segment(id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationSegmentsApi->edit_segment: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_instance.edit_segment(id, body=body)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationSegmentsApi->edit_segment: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**| Segment Id |
 **body** | **{str: (bool, date, datetime, dict, float, int, list, str, none_type)}**| Network segment | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_segment**
> [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}] get_segment(id)



Get network segment

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_segments_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_segments_api.ConfigurationSegmentsApi(api_client)
    id = "id_example" # str | Segment Id

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_segment(id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationSegmentsApi->get_segment: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**| Segment Id |

### Return type

**[{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_segments**
> [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}] get_segments()



Get network segments

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_segments_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_segments_api.ConfigurationSegmentsApi(api_client)

    # example, this endpoint has no required or optional parameters
    try:
        api_response = api_instance.get_segments()
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationSegmentsApi->get_segments: %s\n" % e)
```


### Parameters
This endpoint does not need any parameter.

### Return type

**[{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

