/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import cats.kernel.Comparison;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.math.Algebraic;
import spire.math.AlgebraicAlgebra;
import spire.math.AlgebraicInstances;
import spire.math.Bounded;
import spire.math.Interval;
import spire.math.NumberTag;
import spire.math.Point;
import spire.math.Polynomial;
import spire.math.Rational;
import spire.math.package$;
import spire.math.poly.RootIsolator$;
import spire.math.poly.Roots$;

public final class Algebraic$
implements AlgebraicInstances,
scala.Serializable {
    public static Algebraic$ MODULE$;
    private final Algebraic Zero;
    private final Algebraic One;
    private final double bits2dec;
    private final Order<java.math.BigDecimal> JBigDecimalOrder;
    private final BigInteger spire$math$Algebraic$$MaxIntValue;
    private final BigInteger spire$math$Algebraic$$MinIntValue;
    private final BigInteger spire$math$Algebraic$$MaxLongValue;
    private final BigInteger spire$math$Algebraic$$MinLongValue;
    private final AlgebraicAlgebra AlgebraicAlgebra;
    private final NumberTag.LargeTag<Algebraic> AlgebraicTag;

    static {
        new Algebraic$();
    }

    @Override
    public final AlgebraicAlgebra AlgebraicAlgebra() {
        return this.AlgebraicAlgebra;
    }

    @Override
    public final NumberTag.LargeTag<Algebraic> AlgebraicTag() {
        return this.AlgebraicTag;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicAlgebra_$eq(AlgebraicAlgebra x$1) {
        this.AlgebraicAlgebra = x$1;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicTag_$eq(NumberTag.LargeTag<Algebraic> x$1) {
        this.AlgebraicTag = x$1;
    }

    public Algebraic Zero() {
        return this.Zero;
    }

    public Algebraic One() {
        return this.One;
    }

    public Algebraic apply(int n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(long n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(float n) {
        return this.apply((double)n);
    }

    public Algebraic apply(double n) {
        if (Double.isInfinite(n)) {
            throw new IllegalArgumentException("cannot construct inifinite Algebraic");
        }
        if (Double.isNaN(n)) {
            throw new IllegalArgumentException("cannot construct Algebraic from NaN");
        }
        return new Algebraic(new Algebraic.Expr.ConstantDouble(n));
    }

    public Algebraic apply(BigInt n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(scala.package$.MODULE$.BigDecimal().apply(n)));
    }

    public Algebraic apply(BigDecimal n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(n));
    }

    public Algebraic apply(Rational n) {
        return new Algebraic(new Algebraic.Expr.ConstantRational(n));
    }

    public Algebraic root(Polynomial<Rational> poly, int i) {
        Algebraic algebraic;
        if (i < 0) {
            throw new ArithmeticException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid real root index: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(i)})));
        }
        Polynomial<BigInt> zpoly = Roots$.MODULE$.removeFractions(poly);
        Vector<Interval<Rational>> intervals = Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator());
        if (i >= intervals.size()) {
            throw new ArithmeticException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot extract root ", ", there are only ", " roots"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(i), BoxesRunTime.boxToInteger(intervals.size())})));
        }
        Interval<Rational> interval = intervals.apply(i);
        if (interval instanceof Point) {
            Point point = (Point)interval;
            Rational value = (Rational)point.value();
            algebraic = new Algebraic(new Algebraic.Expr.ConstantRational(value));
        } else if (interval instanceof Bounded) {
            Bounded bounded = (Bounded)interval;
            Rational lb = (Rational)bounded.lower();
            Rational ub = (Rational)bounded.upper();
            algebraic = new Algebraic(new Algebraic.Expr.ConstantRoot(zpoly, i, lb, ub));
        } else {
            throw new RuntimeException("invalid isolated root interval");
        }
        return algebraic;
    }

    public Vector<Algebraic> roots(Polynomial<Rational> poly) {
        Polynomial<BigInt> zpoly = Roots$.MODULE$.removeFractions(poly);
        Vector<Interval<Rational>> intervals = Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator());
        return ((TraversableLike)intervals.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Algebraic> & Serializable & scala.Serializable)x0$1 -> {
            Interval interval;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (interval = (Interval)tuple2._1()) instanceof Point) {
                Point point = (Point)interval;
                Rational value = (Rational)point.value();
                return new Algebraic(new Algebraic.Expr.ConstantRational(value));
            }
            if (tuple2 == null) throw new RuntimeException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid isolated root interval: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tuple2})));
            Interval interval2 = (Interval)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (!(interval2 instanceof Bounded)) throw new RuntimeException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid isolated root interval: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tuple2})));
            Bounded bounded = (Bounded)interval2;
            Rational lb = (Rational)bounded.lower();
            Rational ub = (Rational)bounded.upper();
            return new Algebraic(new Algebraic.Expr.ConstantRoot(zpoly, i, lb, ub));
        }, Vector$.MODULE$.canBuildFrom());
    }

    public Algebraic unsafeRoot(Polynomial<BigInt> poly, int i, Rational lb, Rational ub) {
        return new Algebraic(new Algebraic.Expr.ConstantRoot(poly, i, lb, ub));
    }

    public Algebraic apply(String n) {
        return this.apply(scala.package$.MODULE$.BigDecimal().apply(new java.math.BigDecimal(n)));
    }

    public final java.math.BigDecimal nrootApprox(java.math.BigDecimal x, int n) {
        int k = package$.MODULE$.min(n, 306);
        int width = (int)(package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * package$.MODULE$.log(2.0) / package$.MODULE$.log(10.0)) - 1.0);
        int safeWidth = width + (x.scale() - width) % k;
        double approx = new java.math.BigDecimal(x.unscaledValue().abs(), safeWidth).doubleValue();
        return new java.math.BigDecimal((double)x.signum() * package$.MODULE$.pow(approx, 1.0 / (double)k)).scaleByPowerOfTen(-(x.scale() - safeWidth) / k).round(MathContext.DECIMAL64);
    }

    private final java.math.BigDecimal nroot(java.math.BigDecimal signedValue, int k, Function1<java.math.BigDecimal, Object> getEps) {
        if (signedValue.compareTo(java.math.BigDecimal.ZERO) == 0) {
            return java.math.BigDecimal.ZERO;
        }
        java.math.BigDecimal value = signedValue.abs();
        java.math.BigDecimal n = new java.math.BigDecimal(k);
        java.math.BigDecimal init = this.nrootApprox(value, k);
        java.math.BigDecimal unsignedResult = this.loop$2(init, Integer.MIN_VALUE, java.math.BigDecimal.ZERO, k, getEps, value, n);
        return signedValue.signum() < 0 ? unsignedResult.negate() : unsignedResult;
    }

    private double bits2dec() {
        return this.bits2dec;
    }

    public final java.math.BigDecimal nroot(java.math.BigDecimal value, int n, MathContext mc) {
        java.math.BigDecimal result2 = this.nroot(value, n, (Function1<java.math.BigDecimal, Object> & Serializable & scala.Serializable)(java.math.BigDecimal x) -> BoxesRunTime.boxToInteger(Algebraic$.$anonfun$nroot$1(this, mc, x)));
        return result2.round(mc);
    }

    public final java.math.BigDecimal nroot(java.math.BigDecimal value, int n, int scale, RoundingMode roundingMode) {
        return this.nroot(value, n, (Function1<java.math.BigDecimal, Object> & Serializable & scala.Serializable)(java.math.BigDecimal x$4) -> BoxesRunTime.boxToInteger(Algebraic$.$anonfun$nroot$2(scale, x$4))).setScale(scale, roundingMode);
    }

    private Order<java.math.BigDecimal> JBigDecimalOrder() {
        return this.JBigDecimalOrder;
    }

    public java.math.BigDecimal spire$math$Algebraic$$roundExact(Algebraic exact, java.math.BigDecimal approx, int scale, RoundingMode mode) {
        java.math.BigDecimal bigDecimal;
        if (approx.signum() == 0) {
            java.math.BigDecimal bigDecimal2;
            RoundingMode roundingMode = mode;
            boolean bl = ((Object)((Object)RoundingMode.UP)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.CEILING)).equals((Object)roundingMode);
            if (bl && exact.signum() > 0) {
                bigDecimal2 = new java.math.BigDecimal(BigInteger.ONE, scale);
            } else {
                boolean bl2 = ((Object)((Object)RoundingMode.UP)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.FLOOR)).equals((Object)roundingMode);
                bigDecimal2 = bl2 && exact.signum() < 0 ? new java.math.BigDecimal(BigInteger.ONE.negate(), scale) : approx.setScale(scale, RoundingMode.DOWN);
            }
            bigDecimal = bigDecimal2;
        } else if (approx.signum() > 0) {
            bigDecimal = this.roundPositive(exact, approx, scale, mode);
        } else {
            RoundingMode roundingMode = mode;
            RoundingMode roundingMode2 = ((Object)((Object)RoundingMode.CEILING)).equals((Object)roundingMode) ? RoundingMode.FLOOR : (((Object)((Object)RoundingMode.FLOOR)).equals((Object)roundingMode) ? RoundingMode.CEILING : mode);
            RoundingMode adjustedMode = roundingMode2;
            bigDecimal = this.roundPositive(exact.unary_$minus(), approx.abs(), scale, adjustedMode).negate();
        }
        return bigDecimal;
    }

    private java.math.BigDecimal roundPositive(Algebraic exact, java.math.BigDecimal approx, int scale, RoundingMode mode) {
        java.math.BigDecimal bigDecimal;
        block24: {
            java.math.BigDecimal rounded;
            java.math.BigDecimal bigDecimal2;
            int cutoff;
            while (true) {
                if ((cutoff = approx.scale() - scale) == 0) {
                    bigDecimal = approx;
                    break block24;
                }
                if (cutoff < 0) {
                    bigDecimal = approx.setScale(scale, RoundingMode.DOWN);
                    break block24;
                }
                if (cutoff <= 18) break;
                java.math.BigDecimal bigDecimal3 = approx.setScale(scale + 18, RoundingMode.DOWN);
                approx = bigDecimal3;
            }
            long unscale = package$.MODULE$.pow(10L, cutoff);
            BigInteger[] bigIntegerArray = approx.unscaledValue().divideAndRemainder(BigInteger.valueOf(unscale));
            Option option = Array$.MODULE$.unapplySeq(bigIntegerArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                throw new MatchError(bigIntegerArray);
            }
            BigInteger truncatedUnscaledValue = (BigInteger)((SeqLike)option.get()).apply(0);
            BigInteger bigRemainder = (BigInteger)((SeqLike)option.get()).apply(1);
            Tuple2<BigInteger, BigInteger> tuple2 = new Tuple2<BigInteger, BigInteger>(truncatedUnscaledValue, bigRemainder);
            Tuple2<BigInteger, BigInteger> tuple22 = tuple2;
            BigInteger truncatedUnscaledValue2 = tuple22._1();
            BigInteger bigRemainder2 = tuple22._2();
            java.math.BigDecimal truncated = new java.math.BigDecimal(truncatedUnscaledValue2, scale);
            long remainder = bigRemainder2.longValue();
            RoundingMode roundingMode = mode;
            if (((Object)((Object)RoundingMode.UNNECESSARY)).equals((Object)roundingMode)) {
                bigDecimal2 = truncated;
            } else {
                boolean bl = ((Object)((Object)RoundingMode.HALF_DOWN)).equals((Object)roundingMode) ? true : (((Object)((Object)RoundingMode.HALF_UP)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.HALF_EVEN)).equals((Object)roundingMode));
                if (bl) {
                    java.math.BigDecimal bigDecimal4;
                    long dangerZoneStart = unscale / 2L - 1L;
                    long dangerZoneStop = dangerZoneStart + 2L;
                    if (remainder >= dangerZoneStart && remainder <= dangerZoneStop) {
                        boolean bl2;
                        BigDecimal splitter = scala.package$.MODULE$.BigDecimal().apply(new java.math.BigDecimal(truncatedUnscaledValue2.multiply(BigInteger.TEN).add(BigInteger.valueOf(5L)), scale + 1));
                        int cmp = exact.compare(this.apply(splitter));
                        RoundingMode roundingMode2 = mode;
                        if (((Object)((Object)RoundingMode.HALF_DOWN)).equals((Object)roundingMode2)) {
                            bl2 = cmp > 0;
                        } else if (((Object)((Object)RoundingMode.HALF_UP)).equals((Object)roundingMode2)) {
                            bl2 = cmp >= 0;
                        } else if (((Object)((Object)RoundingMode.HALF_EVEN)).equals((Object)roundingMode2)) {
                            bl2 = cmp > 0 || cmp == 0 && truncatedUnscaledValue2.testBit(0);
                        } else {
                            throw new MatchError((Object)roundingMode2);
                        }
                        boolean roundUp = bl2;
                        bigDecimal4 = roundUp ? truncated.add(Algebraic$.epsilon$1(scale)) : truncated;
                    } else {
                        bigDecimal4 = remainder < dangerZoneStart ? truncated : truncated.add(Algebraic$.epsilon$1(scale));
                    }
                    bigDecimal2 = bigDecimal4;
                } else {
                    boolean bl3 = ((Object)((Object)RoundingMode.CEILING)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.UP)).equals((Object)roundingMode);
                    if (bl3) {
                        bigDecimal2 = remainder <= 1L && exact.$less$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated : truncated.add(Algebraic$.epsilon$1(scale));
                    } else {
                        boolean bl4 = ((Object)((Object)RoundingMode.FLOOR)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.DOWN)).equals((Object)roundingMode);
                        if (bl4) {
                            java.math.BigDecimal bigDecimal5;
                            if (remainder <= 0L) {
                                bigDecimal5 = exact.$less(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated.subtract(Algebraic$.epsilon$1(scale)) : truncated;
                            } else if (remainder >= unscale - 1L) {
                                java.math.BigDecimal roundedUp = truncated.add(Algebraic$.epsilon$1(scale));
                                bigDecimal5 = exact.$greater$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(roundedUp))) ? roundedUp : truncated;
                            } else {
                                bigDecimal5 = truncated;
                            }
                            bigDecimal2 = bigDecimal5;
                        } else {
                            throw new MatchError((Object)roundingMode);
                        }
                    }
                }
            }
            bigDecimal = rounded = bigDecimal2;
        }
        return bigDecimal;
    }

    public BigInteger spire$math$Algebraic$$MaxIntValue() {
        return this.spire$math$Algebraic$$MaxIntValue;
    }

    public BigInteger spire$math$Algebraic$$MinIntValue() {
        return this.spire$math$Algebraic$$MinIntValue;
    }

    public BigInteger spire$math$Algebraic$$MaxLongValue() {
        return this.spire$math$Algebraic$$MaxLongValue;
    }

    public BigInteger spire$math$Algebraic$$MinLongValue() {
        return this.spire$math$Algebraic$$MinLongValue;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final java.math.BigDecimal loop$2(java.math.BigDecimal prev, int prevDigits, java.math.BigDecimal prevEps, int k$1, Function1 getEps$1, java.math.BigDecimal value$1, java.math.BigDecimal n$1) {
        while (true) {
            int digits;
            java.math.BigDecimal eps = (digits = BoxesRunTime.unboxToInt(getEps$1.apply(prev))) == prevDigits ? prevEps : java.math.BigDecimal.ONE.movePointLeft(digits);
            java.math.BigDecimal prevExp = prev.pow(k$1 - 1);
            java.math.BigDecimal delta = value$1.divide(prevExp, digits, RoundingMode.HALF_UP).subtract(prev).divide(n$1, digits, RoundingMode.HALF_UP);
            if (delta.abs().compareTo(eps) <= 0) break;
            prevEps = eps;
            prevDigits = digits;
            prev = prev.add(delta);
        }
        return prev;
    }

    public static final /* synthetic */ int $anonfun$nroot$1(Algebraic$ $this, MathContext mc$1, java.math.BigDecimal x) {
        return x.scale() - (int)package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * $this.bits2dec()) + mc$1.getPrecision() + 1;
    }

    public static final /* synthetic */ int $anonfun$nroot$2(int scale$1, java.math.BigDecimal x$4) {
        return scale$1 + 1;
    }

    private static final java.math.BigDecimal epsilon$1(int scale$2) {
        return new java.math.BigDecimal(BigInteger.ONE, scale$2);
    }

    private Algebraic$() {
        MODULE$ = this;
        AlgebraicInstances.$init$(this);
        this.Zero = new Algebraic(new Algebraic.Expr.ConstantLong(0L));
        this.One = new Algebraic(new Algebraic.Expr.ConstantLong(1L));
        this.bits2dec = package$.MODULE$.log(2.0, 10);
        this.JBigDecimalOrder = new Order<java.math.BigDecimal>(){

            public int compare$mcZ$sp(boolean x, boolean y) {
                return Order.compare$mcZ$sp$(this, x, y);
            }

            public int compare$mcB$sp(byte x, byte y) {
                return Order.compare$mcB$sp$(this, x, y);
            }

            public int compare$mcC$sp(char x, char y) {
                return Order.compare$mcC$sp$(this, x, y);
            }

            public int compare$mcD$sp(double x, double y) {
                return Order.compare$mcD$sp$(this, x, y);
            }

            public int compare$mcF$sp(float x, float y) {
                return Order.compare$mcF$sp$(this, x, y);
            }

            public int compare$mcI$sp(int x, int y) {
                return Order.compare$mcI$sp$(this, x, y);
            }

            public int compare$mcJ$sp(long x, long y) {
                return Order.compare$mcJ$sp$(this, x, y);
            }

            public int compare$mcS$sp(short x, short y) {
                return Order.compare$mcS$sp$(this, x, y);
            }

            public int compare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.compare$mcV$sp$(this, x, y);
            }

            public Comparison comparison(Object x, Object y) {
                return Order.comparison$(this, x, y);
            }

            public Comparison comparison$mcZ$sp(boolean x, boolean y) {
                return Order.comparison$mcZ$sp$(this, x, y);
            }

            public Comparison comparison$mcB$sp(byte x, byte y) {
                return Order.comparison$mcB$sp$(this, x, y);
            }

            public Comparison comparison$mcC$sp(char x, char y) {
                return Order.comparison$mcC$sp$(this, x, y);
            }

            public Comparison comparison$mcD$sp(double x, double y) {
                return Order.comparison$mcD$sp$(this, x, y);
            }

            public Comparison comparison$mcF$sp(float x, float y) {
                return Order.comparison$mcF$sp$(this, x, y);
            }

            public Comparison comparison$mcI$sp(int x, int y) {
                return Order.comparison$mcI$sp$(this, x, y);
            }

            public Comparison comparison$mcJ$sp(long x, long y) {
                return Order.comparison$mcJ$sp$(this, x, y);
            }

            public Comparison comparison$mcS$sp(short x, short y) {
                return Order.comparison$mcS$sp$(this, x, y);
            }

            public Comparison comparison$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.comparison$mcV$sp$(this, x, y);
            }

            public double partialCompare(Object x, Object y) {
                return Order.partialCompare$(this, x, y);
            }

            public double partialCompare$mcZ$sp(boolean x, boolean y) {
                return Order.partialCompare$mcZ$sp$(this, x, y);
            }

            public double partialCompare$mcB$sp(byte x, byte y) {
                return Order.partialCompare$mcB$sp$(this, x, y);
            }

            public double partialCompare$mcC$sp(char x, char y) {
                return Order.partialCompare$mcC$sp$(this, x, y);
            }

            public double partialCompare$mcD$sp(double x, double y) {
                return Order.partialCompare$mcD$sp$(this, x, y);
            }

            public double partialCompare$mcF$sp(float x, float y) {
                return Order.partialCompare$mcF$sp$(this, x, y);
            }

            public double partialCompare$mcI$sp(int x, int y) {
                return Order.partialCompare$mcI$sp$(this, x, y);
            }

            public double partialCompare$mcJ$sp(long x, long y) {
                return Order.partialCompare$mcJ$sp$(this, x, y);
            }

            public double partialCompare$mcS$sp(short x, short y) {
                return Order.partialCompare$mcS$sp$(this, x, y);
            }

            public double partialCompare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.partialCompare$mcV$sp$(this, x, y);
            }

            public Object min(Object x, Object y) {
                return Order.min$(this, x, y);
            }

            public boolean min$mcZ$sp(boolean x, boolean y) {
                return Order.min$mcZ$sp$(this, x, y);
            }

            public byte min$mcB$sp(byte x, byte y) {
                return Order.min$mcB$sp$(this, x, y);
            }

            public char min$mcC$sp(char x, char y) {
                return Order.min$mcC$sp$(this, x, y);
            }

            public double min$mcD$sp(double x, double y) {
                return Order.min$mcD$sp$(this, x, y);
            }

            public float min$mcF$sp(float x, float y) {
                return Order.min$mcF$sp$(this, x, y);
            }

            public int min$mcI$sp(int x, int y) {
                return Order.min$mcI$sp$(this, x, y);
            }

            public long min$mcJ$sp(long x, long y) {
                return Order.min$mcJ$sp$(this, x, y);
            }

            public short min$mcS$sp(short x, short y) {
                return Order.min$mcS$sp$(this, x, y);
            }

            public void min$mcV$sp(BoxedUnit x, BoxedUnit y) {
                Order.min$mcV$sp$(this, x, y);
            }

            public Object max(Object x, Object y) {
                return Order.max$(this, x, y);
            }

            public boolean max$mcZ$sp(boolean x, boolean y) {
                return Order.max$mcZ$sp$(this, x, y);
            }

            public byte max$mcB$sp(byte x, byte y) {
                return Order.max$mcB$sp$(this, x, y);
            }

            public char max$mcC$sp(char x, char y) {
                return Order.max$mcC$sp$(this, x, y);
            }

            public double max$mcD$sp(double x, double y) {
                return Order.max$mcD$sp$(this, x, y);
            }

            public float max$mcF$sp(float x, float y) {
                return Order.max$mcF$sp$(this, x, y);
            }

            public int max$mcI$sp(int x, int y) {
                return Order.max$mcI$sp$(this, x, y);
            }

            public long max$mcJ$sp(long x, long y) {
                return Order.max$mcJ$sp$(this, x, y);
            }

            public short max$mcS$sp(short x, short y) {
                return Order.max$mcS$sp$(this, x, y);
            }

            public void max$mcV$sp(BoxedUnit x, BoxedUnit y) {
                Order.max$mcV$sp$(this, x, y);
            }

            public <B> Order<B> on(Function1<B, java.math.BigDecimal> f) {
                return Order.on$((Order)this, f);
            }

            public <B> Order<B> on$mcZ$sp(Function1<B, Object> f) {
                return Order.on$mcZ$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcB$sp(Function1<B, Object> f) {
                return Order.on$mcB$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcC$sp(Function1<B, Object> f) {
                return Order.on$mcC$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcD$sp(Function1<B, Object> f) {
                return Order.on$mcD$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcF$sp(Function1<B, Object> f) {
                return Order.on$mcF$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcI$sp(Function1<B, Object> f) {
                return Order.on$mcI$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcJ$sp(Function1<B, Object> f) {
                return Order.on$mcJ$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcS$sp(Function1<B, Object> f) {
                return Order.on$mcS$sp$((Order)this, f);
            }

            public <B> Order<B> on$mcV$sp(Function1<B, BoxedUnit> f) {
                return Order.on$mcV$sp$((Order)this, f);
            }

            public Order<Object> on$mZc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mZc$sp$((Order)this, f);
            }

            public Order<Object> on$mZcZ$sp(Function1<Object, Object> f) {
                return Order.on$mZcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mZcB$sp(Function1<Object, Object> f) {
                return Order.on$mZcB$sp$((Order)this, f);
            }

            public Order<Object> on$mZcC$sp(Function1<Object, Object> f) {
                return Order.on$mZcC$sp$((Order)this, f);
            }

            public Order<Object> on$mZcD$sp(Function1<Object, Object> f) {
                return Order.on$mZcD$sp$((Order)this, f);
            }

            public Order<Object> on$mZcF$sp(Function1<Object, Object> f) {
                return Order.on$mZcF$sp$((Order)this, f);
            }

            public Order<Object> on$mZcI$sp(Function1<Object, Object> f) {
                return Order.on$mZcI$sp$((Order)this, f);
            }

            public Order<Object> on$mZcJ$sp(Function1<Object, Object> f) {
                return Order.on$mZcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mZcS$sp(Function1<Object, Object> f) {
                return Order.on$mZcS$sp$((Order)this, f);
            }

            public Order<Object> on$mZcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mZcV$sp$((Order)this, f);
            }

            public Order<Object> on$mBc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mBc$sp$((Order)this, f);
            }

            public Order<Object> on$mBcZ$sp(Function1<Object, Object> f) {
                return Order.on$mBcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mBcB$sp(Function1<Object, Object> f) {
                return Order.on$mBcB$sp$((Order)this, f);
            }

            public Order<Object> on$mBcC$sp(Function1<Object, Object> f) {
                return Order.on$mBcC$sp$((Order)this, f);
            }

            public Order<Object> on$mBcD$sp(Function1<Object, Object> f) {
                return Order.on$mBcD$sp$((Order)this, f);
            }

            public Order<Object> on$mBcF$sp(Function1<Object, Object> f) {
                return Order.on$mBcF$sp$((Order)this, f);
            }

            public Order<Object> on$mBcI$sp(Function1<Object, Object> f) {
                return Order.on$mBcI$sp$((Order)this, f);
            }

            public Order<Object> on$mBcJ$sp(Function1<Object, Object> f) {
                return Order.on$mBcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mBcS$sp(Function1<Object, Object> f) {
                return Order.on$mBcS$sp$((Order)this, f);
            }

            public Order<Object> on$mBcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mBcV$sp$((Order)this, f);
            }

            public Order<Object> on$mCc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mCc$sp$((Order)this, f);
            }

            public Order<Object> on$mCcZ$sp(Function1<Object, Object> f) {
                return Order.on$mCcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mCcB$sp(Function1<Object, Object> f) {
                return Order.on$mCcB$sp$((Order)this, f);
            }

            public Order<Object> on$mCcC$sp(Function1<Object, Object> f) {
                return Order.on$mCcC$sp$((Order)this, f);
            }

            public Order<Object> on$mCcD$sp(Function1<Object, Object> f) {
                return Order.on$mCcD$sp$((Order)this, f);
            }

            public Order<Object> on$mCcF$sp(Function1<Object, Object> f) {
                return Order.on$mCcF$sp$((Order)this, f);
            }

            public Order<Object> on$mCcI$sp(Function1<Object, Object> f) {
                return Order.on$mCcI$sp$((Order)this, f);
            }

            public Order<Object> on$mCcJ$sp(Function1<Object, Object> f) {
                return Order.on$mCcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mCcS$sp(Function1<Object, Object> f) {
                return Order.on$mCcS$sp$((Order)this, f);
            }

            public Order<Object> on$mCcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mCcV$sp$((Order)this, f);
            }

            public Order<Object> on$mDc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mDc$sp$((Order)this, f);
            }

            public Order<Object> on$mDcZ$sp(Function1<Object, Object> f) {
                return Order.on$mDcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mDcB$sp(Function1<Object, Object> f) {
                return Order.on$mDcB$sp$((Order)this, f);
            }

            public Order<Object> on$mDcC$sp(Function1<Object, Object> f) {
                return Order.on$mDcC$sp$((Order)this, f);
            }

            public Order<Object> on$mDcD$sp(Function1<Object, Object> f) {
                return Order.on$mDcD$sp$((Order)this, f);
            }

            public Order<Object> on$mDcF$sp(Function1<Object, Object> f) {
                return Order.on$mDcF$sp$((Order)this, f);
            }

            public Order<Object> on$mDcI$sp(Function1<Object, Object> f) {
                return Order.on$mDcI$sp$((Order)this, f);
            }

            public Order<Object> on$mDcJ$sp(Function1<Object, Object> f) {
                return Order.on$mDcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mDcS$sp(Function1<Object, Object> f) {
                return Order.on$mDcS$sp$((Order)this, f);
            }

            public Order<Object> on$mDcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mDcV$sp$((Order)this, f);
            }

            public Order<Object> on$mFc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mFc$sp$((Order)this, f);
            }

            public Order<Object> on$mFcZ$sp(Function1<Object, Object> f) {
                return Order.on$mFcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mFcB$sp(Function1<Object, Object> f) {
                return Order.on$mFcB$sp$((Order)this, f);
            }

            public Order<Object> on$mFcC$sp(Function1<Object, Object> f) {
                return Order.on$mFcC$sp$((Order)this, f);
            }

            public Order<Object> on$mFcD$sp(Function1<Object, Object> f) {
                return Order.on$mFcD$sp$((Order)this, f);
            }

            public Order<Object> on$mFcF$sp(Function1<Object, Object> f) {
                return Order.on$mFcF$sp$((Order)this, f);
            }

            public Order<Object> on$mFcI$sp(Function1<Object, Object> f) {
                return Order.on$mFcI$sp$((Order)this, f);
            }

            public Order<Object> on$mFcJ$sp(Function1<Object, Object> f) {
                return Order.on$mFcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mFcS$sp(Function1<Object, Object> f) {
                return Order.on$mFcS$sp$((Order)this, f);
            }

            public Order<Object> on$mFcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mFcV$sp$((Order)this, f);
            }

            public Order<Object> on$mIc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mIc$sp$((Order)this, f);
            }

            public Order<Object> on$mIcZ$sp(Function1<Object, Object> f) {
                return Order.on$mIcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mIcB$sp(Function1<Object, Object> f) {
                return Order.on$mIcB$sp$((Order)this, f);
            }

            public Order<Object> on$mIcC$sp(Function1<Object, Object> f) {
                return Order.on$mIcC$sp$((Order)this, f);
            }

            public Order<Object> on$mIcD$sp(Function1<Object, Object> f) {
                return Order.on$mIcD$sp$((Order)this, f);
            }

            public Order<Object> on$mIcF$sp(Function1<Object, Object> f) {
                return Order.on$mIcF$sp$((Order)this, f);
            }

            public Order<Object> on$mIcI$sp(Function1<Object, Object> f) {
                return Order.on$mIcI$sp$((Order)this, f);
            }

            public Order<Object> on$mIcJ$sp(Function1<Object, Object> f) {
                return Order.on$mIcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mIcS$sp(Function1<Object, Object> f) {
                return Order.on$mIcS$sp$((Order)this, f);
            }

            public Order<Object> on$mIcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mIcV$sp$((Order)this, f);
            }

            public Order<Object> on$mJc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mJc$sp$((Order)this, f);
            }

            public Order<Object> on$mJcZ$sp(Function1<Object, Object> f) {
                return Order.on$mJcZ$sp$((Order)this, f);
            }

            public Order<Object> on$mJcB$sp(Function1<Object, Object> f) {
                return Order.on$mJcB$sp$((Order)this, f);
            }

            public Order<Object> on$mJcC$sp(Function1<Object, Object> f) {
                return Order.on$mJcC$sp$((Order)this, f);
            }

            public Order<Object> on$mJcD$sp(Function1<Object, Object> f) {
                return Order.on$mJcD$sp$((Order)this, f);
            }

            public Order<Object> on$mJcF$sp(Function1<Object, Object> f) {
                return Order.on$mJcF$sp$((Order)this, f);
            }

            public Order<Object> on$mJcI$sp(Function1<Object, Object> f) {
                return Order.on$mJcI$sp$((Order)this, f);
            }

            public Order<Object> on$mJcJ$sp(Function1<Object, Object> f) {
                return Order.on$mJcJ$sp$((Order)this, f);
            }

            public Order<Object> on$mJcS$sp(Function1<Object, Object> f) {
                return Order.on$mJcS$sp$((Order)this, f);
            }

            public Order<Object> on$mJcV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mJcV$sp$((Order)this, f);
            }

            public Order<Object> on$mSc$sp(Function1<Object, java.math.BigDecimal> f) {
                return Order.on$mSc$sp$((Order)this, f);
            }

            public Order<Object> on$mScZ$sp(Function1<Object, Object> f) {
                return Order.on$mScZ$sp$((Order)this, f);
            }

            public Order<Object> on$mScB$sp(Function1<Object, Object> f) {
                return Order.on$mScB$sp$((Order)this, f);
            }

            public Order<Object> on$mScC$sp(Function1<Object, Object> f) {
                return Order.on$mScC$sp$((Order)this, f);
            }

            public Order<Object> on$mScD$sp(Function1<Object, Object> f) {
                return Order.on$mScD$sp$((Order)this, f);
            }

            public Order<Object> on$mScF$sp(Function1<Object, Object> f) {
                return Order.on$mScF$sp$((Order)this, f);
            }

            public Order<Object> on$mScI$sp(Function1<Object, Object> f) {
                return Order.on$mScI$sp$((Order)this, f);
            }

            public Order<Object> on$mScJ$sp(Function1<Object, Object> f) {
                return Order.on$mScJ$sp$((Order)this, f);
            }

            public Order<Object> on$mScS$sp(Function1<Object, Object> f) {
                return Order.on$mScS$sp$((Order)this, f);
            }

            public Order<Object> on$mScV$sp(Function1<Object, BoxedUnit> f) {
                return Order.on$mScV$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVc$sp(Function1<BoxedUnit, java.math.BigDecimal> f) {
                return Order.on$mVc$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcZ$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcZ$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcB$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcB$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcC$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcC$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcD$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcD$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcF$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcF$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcI$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcI$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcJ$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcJ$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcS$sp(Function1<BoxedUnit, Object> f) {
                return Order.on$mVcS$sp$((Order)this, f);
            }

            public Order<BoxedUnit> on$mVcV$sp(Function1<BoxedUnit, BoxedUnit> f) {
                return Order.on$mVcV$sp$((Order)this, f);
            }

            public Order<java.math.BigDecimal> reverse() {
                return Order.reverse$((Order)this);
            }

            public Order<Object> reverse$mcZ$sp() {
                return Order.reverse$mcZ$sp$((Order)this);
            }

            public Order<Object> reverse$mcB$sp() {
                return Order.reverse$mcB$sp$((Order)this);
            }

            public Order<Object> reverse$mcC$sp() {
                return Order.reverse$mcC$sp$((Order)this);
            }

            public Order<Object> reverse$mcD$sp() {
                return Order.reverse$mcD$sp$((Order)this);
            }

            public Order<Object> reverse$mcF$sp() {
                return Order.reverse$mcF$sp$((Order)this);
            }

            public Order<Object> reverse$mcI$sp() {
                return Order.reverse$mcI$sp$((Order)this);
            }

            public Order<Object> reverse$mcJ$sp() {
                return Order.reverse$mcJ$sp$((Order)this);
            }

            public Order<Object> reverse$mcS$sp() {
                return Order.reverse$mcS$sp$((Order)this);
            }

            public Order<BoxedUnit> reverse$mcV$sp() {
                return Order.reverse$mcV$sp$((Order)this);
            }

            public boolean eqv(Object x, Object y) {
                return Order.eqv$(this, x, y);
            }

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return Order.eqv$mcZ$sp$(this, x, y);
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return Order.eqv$mcB$sp$(this, x, y);
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return Order.eqv$mcC$sp$(this, x, y);
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return Order.eqv$mcD$sp$(this, x, y);
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return Order.eqv$mcF$sp$(this, x, y);
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return Order.eqv$mcI$sp$(this, x, y);
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return Order.eqv$mcJ$sp$(this, x, y);
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return Order.eqv$mcS$sp$(this, x, y);
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.eqv$mcV$sp$(this, x, y);
            }

            public boolean neqv(Object x, Object y) {
                return Order.neqv$(this, x, y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return Order.neqv$mcZ$sp$(this, x, y);
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return Order.neqv$mcB$sp$(this, x, y);
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return Order.neqv$mcC$sp$(this, x, y);
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return Order.neqv$mcD$sp$(this, x, y);
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return Order.neqv$mcF$sp$(this, x, y);
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return Order.neqv$mcI$sp$(this, x, y);
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return Order.neqv$mcJ$sp$(this, x, y);
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return Order.neqv$mcS$sp$(this, x, y);
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.neqv$mcV$sp$(this, x, y);
            }

            public boolean lteqv(Object x, Object y) {
                return Order.lteqv$(this, x, y);
            }

            public boolean lteqv$mcZ$sp(boolean x, boolean y) {
                return Order.lteqv$mcZ$sp$(this, x, y);
            }

            public boolean lteqv$mcB$sp(byte x, byte y) {
                return Order.lteqv$mcB$sp$(this, x, y);
            }

            public boolean lteqv$mcC$sp(char x, char y) {
                return Order.lteqv$mcC$sp$(this, x, y);
            }

            public boolean lteqv$mcD$sp(double x, double y) {
                return Order.lteqv$mcD$sp$(this, x, y);
            }

            public boolean lteqv$mcF$sp(float x, float y) {
                return Order.lteqv$mcF$sp$(this, x, y);
            }

            public boolean lteqv$mcI$sp(int x, int y) {
                return Order.lteqv$mcI$sp$(this, x, y);
            }

            public boolean lteqv$mcJ$sp(long x, long y) {
                return Order.lteqv$mcJ$sp$(this, x, y);
            }

            public boolean lteqv$mcS$sp(short x, short y) {
                return Order.lteqv$mcS$sp$(this, x, y);
            }

            public boolean lteqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.lteqv$mcV$sp$(this, x, y);
            }

            public boolean lt(Object x, Object y) {
                return Order.lt$(this, x, y);
            }

            public boolean lt$mcZ$sp(boolean x, boolean y) {
                return Order.lt$mcZ$sp$(this, x, y);
            }

            public boolean lt$mcB$sp(byte x, byte y) {
                return Order.lt$mcB$sp$(this, x, y);
            }

            public boolean lt$mcC$sp(char x, char y) {
                return Order.lt$mcC$sp$(this, x, y);
            }

            public boolean lt$mcD$sp(double x, double y) {
                return Order.lt$mcD$sp$(this, x, y);
            }

            public boolean lt$mcF$sp(float x, float y) {
                return Order.lt$mcF$sp$(this, x, y);
            }

            public boolean lt$mcI$sp(int x, int y) {
                return Order.lt$mcI$sp$(this, x, y);
            }

            public boolean lt$mcJ$sp(long x, long y) {
                return Order.lt$mcJ$sp$(this, x, y);
            }

            public boolean lt$mcS$sp(short x, short y) {
                return Order.lt$mcS$sp$(this, x, y);
            }

            public boolean lt$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.lt$mcV$sp$(this, x, y);
            }

            public boolean gteqv(Object x, Object y) {
                return Order.gteqv$(this, x, y);
            }

            public boolean gteqv$mcZ$sp(boolean x, boolean y) {
                return Order.gteqv$mcZ$sp$(this, x, y);
            }

            public boolean gteqv$mcB$sp(byte x, byte y) {
                return Order.gteqv$mcB$sp$(this, x, y);
            }

            public boolean gteqv$mcC$sp(char x, char y) {
                return Order.gteqv$mcC$sp$(this, x, y);
            }

            public boolean gteqv$mcD$sp(double x, double y) {
                return Order.gteqv$mcD$sp$(this, x, y);
            }

            public boolean gteqv$mcF$sp(float x, float y) {
                return Order.gteqv$mcF$sp$(this, x, y);
            }

            public boolean gteqv$mcI$sp(int x, int y) {
                return Order.gteqv$mcI$sp$(this, x, y);
            }

            public boolean gteqv$mcJ$sp(long x, long y) {
                return Order.gteqv$mcJ$sp$(this, x, y);
            }

            public boolean gteqv$mcS$sp(short x, short y) {
                return Order.gteqv$mcS$sp$(this, x, y);
            }

            public boolean gteqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.gteqv$mcV$sp$(this, x, y);
            }

            public boolean gt(Object x, Object y) {
                return Order.gt$(this, x, y);
            }

            public boolean gt$mcZ$sp(boolean x, boolean y) {
                return Order.gt$mcZ$sp$(this, x, y);
            }

            public boolean gt$mcB$sp(byte x, byte y) {
                return Order.gt$mcB$sp$(this, x, y);
            }

            public boolean gt$mcC$sp(char x, char y) {
                return Order.gt$mcC$sp$(this, x, y);
            }

            public boolean gt$mcD$sp(double x, double y) {
                return Order.gt$mcD$sp$(this, x, y);
            }

            public boolean gt$mcF$sp(float x, float y) {
                return Order.gt$mcF$sp$(this, x, y);
            }

            public boolean gt$mcI$sp(int x, int y) {
                return Order.gt$mcI$sp$(this, x, y);
            }

            public boolean gt$mcJ$sp(long x, long y) {
                return Order.gt$mcJ$sp$(this, x, y);
            }

            public boolean gt$mcS$sp(short x, short y) {
                return Order.gt$mcS$sp$(this, x, y);
            }

            public boolean gt$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Order.gt$mcV$sp$(this, x, y);
            }

            public Order<java.math.BigDecimal> whenEqual(Order<java.math.BigDecimal> o) {
                return Order.whenEqual$((Order)this, o);
            }

            public Order<Object> whenEqual$mcZ$sp(Order<Object> o) {
                return Order.whenEqual$mcZ$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcB$sp(Order<Object> o) {
                return Order.whenEqual$mcB$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcC$sp(Order<Object> o) {
                return Order.whenEqual$mcC$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcD$sp(Order<Object> o) {
                return Order.whenEqual$mcD$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcF$sp(Order<Object> o) {
                return Order.whenEqual$mcF$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcI$sp(Order<Object> o) {
                return Order.whenEqual$mcI$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcJ$sp(Order<Object> o) {
                return Order.whenEqual$mcJ$sp$((Order)this, o);
            }

            public Order<Object> whenEqual$mcS$sp(Order<Object> o) {
                return Order.whenEqual$mcS$sp$((Order)this, o);
            }

            public Order<BoxedUnit> whenEqual$mcV$sp(Order<BoxedUnit> o) {
                return Order.whenEqual$mcV$sp$((Order)this, o);
            }

            public Ordering<java.math.BigDecimal> toOrdering() {
                return Order.toOrdering$(this);
            }

            public Option partialComparison(Object x, Object y) {
                return PartialOrder.partialComparison$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcZ$sp(boolean x, boolean y) {
                return PartialOrder.partialComparison$mcZ$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcB$sp(byte x, byte y) {
                return PartialOrder.partialComparison$mcB$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcC$sp(char x, char y) {
                return PartialOrder.partialComparison$mcC$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcD$sp(double x, double y) {
                return PartialOrder.partialComparison$mcD$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcF$sp(float x, float y) {
                return PartialOrder.partialComparison$mcF$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcI$sp(int x, int y) {
                return PartialOrder.partialComparison$mcI$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcJ$sp(long x, long y) {
                return PartialOrder.partialComparison$mcJ$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcS$sp(short x, short y) {
                return PartialOrder.partialComparison$mcS$sp$(this, x, y);
            }

            public Option<Comparison> partialComparison$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder.partialComparison$mcV$sp$(this, x, y);
            }

            public Option tryCompare(Object x, Object y) {
                return PartialOrder.tryCompare$(this, x, y);
            }

            public Option<Object> tryCompare$mcZ$sp(boolean x, boolean y) {
                return PartialOrder.tryCompare$mcZ$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcB$sp(byte x, byte y) {
                return PartialOrder.tryCompare$mcB$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcC$sp(char x, char y) {
                return PartialOrder.tryCompare$mcC$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcD$sp(double x, double y) {
                return PartialOrder.tryCompare$mcD$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcF$sp(float x, float y) {
                return PartialOrder.tryCompare$mcF$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcI$sp(int x, int y) {
                return PartialOrder.tryCompare$mcI$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcJ$sp(long x, long y) {
                return PartialOrder.tryCompare$mcJ$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcS$sp(short x, short y) {
                return PartialOrder.tryCompare$mcS$sp$(this, x, y);
            }

            public Option<Object> tryCompare$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder.tryCompare$mcV$sp$(this, x, y);
            }

            public Option pmin(Object x, Object y) {
                return PartialOrder.pmin$(this, x, y);
            }

            public Option<Object> pmin$mcZ$sp(boolean x, boolean y) {
                return PartialOrder.pmin$mcZ$sp$(this, x, y);
            }

            public Option<Object> pmin$mcB$sp(byte x, byte y) {
                return PartialOrder.pmin$mcB$sp$(this, x, y);
            }

            public Option<Object> pmin$mcC$sp(char x, char y) {
                return PartialOrder.pmin$mcC$sp$(this, x, y);
            }

            public Option<Object> pmin$mcD$sp(double x, double y) {
                return PartialOrder.pmin$mcD$sp$(this, x, y);
            }

            public Option<Object> pmin$mcF$sp(float x, float y) {
                return PartialOrder.pmin$mcF$sp$(this, x, y);
            }

            public Option<Object> pmin$mcI$sp(int x, int y) {
                return PartialOrder.pmin$mcI$sp$(this, x, y);
            }

            public Option<Object> pmin$mcJ$sp(long x, long y) {
                return PartialOrder.pmin$mcJ$sp$(this, x, y);
            }

            public Option<Object> pmin$mcS$sp(short x, short y) {
                return PartialOrder.pmin$mcS$sp$(this, x, y);
            }

            public Option<BoxedUnit> pmin$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder.pmin$mcV$sp$(this, x, y);
            }

            public Option pmax(Object x, Object y) {
                return PartialOrder.pmax$(this, x, y);
            }

            public Option<Object> pmax$mcZ$sp(boolean x, boolean y) {
                return PartialOrder.pmax$mcZ$sp$(this, x, y);
            }

            public Option<Object> pmax$mcB$sp(byte x, byte y) {
                return PartialOrder.pmax$mcB$sp$(this, x, y);
            }

            public Option<Object> pmax$mcC$sp(char x, char y) {
                return PartialOrder.pmax$mcC$sp$(this, x, y);
            }

            public Option<Object> pmax$mcD$sp(double x, double y) {
                return PartialOrder.pmax$mcD$sp$(this, x, y);
            }

            public Option<Object> pmax$mcF$sp(float x, float y) {
                return PartialOrder.pmax$mcF$sp$(this, x, y);
            }

            public Option<Object> pmax$mcI$sp(int x, int y) {
                return PartialOrder.pmax$mcI$sp$(this, x, y);
            }

            public Option<Object> pmax$mcJ$sp(long x, long y) {
                return PartialOrder.pmax$mcJ$sp$(this, x, y);
            }

            public Option<Object> pmax$mcS$sp(short x, short y) {
                return PartialOrder.pmax$mcS$sp$(this, x, y);
            }

            public Option<BoxedUnit> pmax$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return PartialOrder.pmax$mcV$sp$(this, x, y);
            }

            public Eq<java.math.BigDecimal> and(Eq<java.math.BigDecimal> that) {
                return Eq.and$((Eq)this, that);
            }

            public Eq<Object> and$mcZ$sp(Eq<Object> that) {
                return Eq.and$mcZ$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcB$sp(Eq<Object> that) {
                return Eq.and$mcB$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcC$sp(Eq<Object> that) {
                return Eq.and$mcC$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcD$sp(Eq<Object> that) {
                return Eq.and$mcD$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcF$sp(Eq<Object> that) {
                return Eq.and$mcF$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcI$sp(Eq<Object> that) {
                return Eq.and$mcI$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcJ$sp(Eq<Object> that) {
                return Eq.and$mcJ$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcS$sp(Eq<Object> that) {
                return Eq.and$mcS$sp$((Eq)this, that);
            }

            public Eq<BoxedUnit> and$mcV$sp(Eq<BoxedUnit> that) {
                return Eq.and$mcV$sp$((Eq)this, that);
            }

            public Eq<java.math.BigDecimal> or(Eq<java.math.BigDecimal> that) {
                return Eq.or$((Eq)this, that);
            }

            public Eq<Object> or$mcZ$sp(Eq<Object> that) {
                return Eq.or$mcZ$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcB$sp(Eq<Object> that) {
                return Eq.or$mcB$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcC$sp(Eq<Object> that) {
                return Eq.or$mcC$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcD$sp(Eq<Object> that) {
                return Eq.or$mcD$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcF$sp(Eq<Object> that) {
                return Eq.or$mcF$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcI$sp(Eq<Object> that) {
                return Eq.or$mcI$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcJ$sp(Eq<Object> that) {
                return Eq.or$mcJ$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcS$sp(Eq<Object> that) {
                return Eq.or$mcS$sp$((Eq)this, that);
            }

            public Eq<BoxedUnit> or$mcV$sp(Eq<BoxedUnit> that) {
                return Eq.or$mcV$sp$((Eq)this, that);
            }

            public int compare(java.math.BigDecimal x, java.math.BigDecimal y) {
                return x.compareTo(y);
            }
            {
                Eq.$init$(this);
                PartialOrder.$init$(this);
                Order.$init$(this);
            }
        };
        this.spire$math$Algebraic$$MaxIntValue = BigInteger.valueOf(Integer.MAX_VALUE);
        this.spire$math$Algebraic$$MinIntValue = BigInteger.valueOf(Integer.MIN_VALUE);
        this.spire$math$Algebraic$$MaxLongValue = BigInteger.valueOf(Long.MAX_VALUE);
        this.spire$math$Algebraic$$MinLongValue = BigInteger.valueOf(Long.MIN_VALUE);
    }
}

