/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.OkHttpCall;
import retrofit2.Utils;

public final class Response<T> {
    private final okhttp3.Response rawResponse;
    @Nullable
    private final T body;
    @Nullable
    private final ResponseBody errorBody;

    public static <T> Response<T> success(@Nullable T body2) {
        return Response.success(body2, new Response.Builder().code(200).message("OK").protocol(Protocol.HTTP_1_1).request(new Request.Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> success(int code, @Nullable T body2) {
        if (code < 200 || code >= 300) {
            throw new IllegalArgumentException("code < 200 or >= 300: " + code);
        }
        return Response.success(body2, new Response.Builder().code(code).message("Response.success()").protocol(Protocol.HTTP_1_1).request(new Request.Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> success(@Nullable T body2, Headers headers) {
        Utils.checkNotNull(headers, "headers == null");
        return Response.success(body2, new Response.Builder().code(200).message("OK").protocol(Protocol.HTTP_1_1).headers(headers).request(new Request.Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> success(@Nullable T body2, okhttp3.Response rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse == null");
        if (!rawResponse.isSuccessful()) {
            throw new IllegalArgumentException("rawResponse must be successful response");
        }
        return new Response<T>(rawResponse, body2, null);
    }

    public static <T> Response<T> error(int code, ResponseBody body2) {
        Utils.checkNotNull(body2, "body == null");
        if (code < 400) {
            throw new IllegalArgumentException("code < 400: " + code);
        }
        return Response.error(body2, new Response.Builder().body(new OkHttpCall.NoContentResponseBody(body2.contentType(), body2.contentLength())).code(code).message("Response.error()").protocol(Protocol.HTTP_1_1).request(new Request.Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> error(ResponseBody body2, okhttp3.Response rawResponse) {
        Utils.checkNotNull(body2, "body == null");
        Utils.checkNotNull(rawResponse, "rawResponse == null");
        if (rawResponse.isSuccessful()) {
            throw new IllegalArgumentException("rawResponse should not be successful response");
        }
        return new Response<Object>(rawResponse, null, body2);
    }

    private Response(okhttp3.Response rawResponse, @Nullable T body2, @Nullable ResponseBody errorBody) {
        this.rawResponse = rawResponse;
        this.body = body2;
        this.errorBody = errorBody;
    }

    public okhttp3.Response raw() {
        return this.rawResponse;
    }

    public int code() {
        return this.rawResponse.code();
    }

    public String message() {
        return this.rawResponse.message();
    }

    public Headers headers() {
        return this.rawResponse.headers();
    }

    public boolean isSuccessful() {
        return this.rawResponse.isSuccessful();
    }

    @Nullable
    public T body() {
        return this.body;
    }

    @Nullable
    public ResponseBody errorBody() {
        return this.errorBody;
    }

    public String toString() {
        return this.rawResponse.toString();
    }
}

