/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519;

import org.whispersystems.curve25519.Curve25519Provider;
import org.whispersystems.curve25519.JCESecureRandomProvider;
import org.whispersystems.curve25519.NoSuchProviderException;
import org.whispersystems.curve25519.SecureRandomProvider;
import org.whispersystems.curve25519.VrfSignatureVerificationFailedException;

class NativeCurve25519Provider
implements Curve25519Provider {
    private static boolean libraryPresent = false;
    private static Throwable libraryFailedException = null;
    private SecureRandomProvider secureRandomProvider = new JCESecureRandomProvider();

    NativeCurve25519Provider() throws NoSuchProviderException {
        if (!libraryPresent) {
            throw new NoSuchProviderException(libraryFailedException);
        }
        try {
            this.smokeCheck(31337);
        }
        catch (UnsatisfiedLinkError ule) {
            throw new NoSuchProviderException(ule);
        }
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public byte[] generatePrivateKey() {
        byte[] random = this.getRandom(32);
        return this.generatePrivateKey(random);
    }

    @Override
    public byte[] getRandom(int length) {
        byte[] result2 = new byte[length];
        this.secureRandomProvider.nextBytes(result2);
        return result2;
    }

    @Override
    public void setRandomProvider(SecureRandomProvider provider) {
        this.secureRandomProvider = provider;
    }

    @Override
    public native byte[] calculateAgreement(byte[] var1, byte[] var2);

    @Override
    public native byte[] generatePublicKey(byte[] var1);

    @Override
    public native byte[] generatePrivateKey(byte[] var1);

    @Override
    public native byte[] calculateSignature(byte[] var1, byte[] var2, byte[] var3);

    @Override
    public native boolean verifySignature(byte[] var1, byte[] var2, byte[] var3);

    @Override
    public native byte[] calculateVrfSignature(byte[] var1, byte[] var2, byte[] var3);

    @Override
    public native byte[] verifyVrfSignature(byte[] var1, byte[] var2, byte[] var3) throws VrfSignatureVerificationFailedException;

    private native boolean smokeCheck(int var1);

    static {
        try {
            System.loadLibrary("curve25519");
            libraryPresent = true;
        }
        catch (SecurityException | UnsatisfiedLinkError e) {
            libraryPresent = false;
            libraryFailedException = e;
        }
    }
}

