/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.AvlTreeData;
import org.ergoplatform.restapi.client.ErgoLikeTransaction;
import org.ergoplatform.restapi.client.ErgoTransactionOutput;
import org.ergoplatform.restapi.client.PreHeader;
import org.ergoplatform.restapi.client.SigmaHeader;

public class ErgoLikeContext {
    @SerializedName(value="lastBlockUtxoRoot")
    private AvlTreeData lastBlockUtxoRoot = null;
    @SerializedName(value="headers")
    private List<SigmaHeader> headers = new ArrayList<SigmaHeader>();
    @SerializedName(value="preHeader")
    private PreHeader preHeader = null;
    @SerializedName(value="dataBoxes")
    private List<ErgoTransactionOutput> dataBoxes = new ArrayList<ErgoTransactionOutput>();
    @SerializedName(value="boxesToSpend")
    private List<ErgoTransactionOutput> boxesToSpend = new ArrayList<ErgoTransactionOutput>();
    @SerializedName(value="spendingTransaction")
    private ErgoLikeTransaction spendingTransaction = null;
    @SerializedName(value="selfIndex")
    private Long selfIndex = null;
    @SerializedName(value="extension")
    private Object extension = null;
    @SerializedName(value="validationSettings")
    private String validationSettings = null;
    @SerializedName(value="costLimit")
    private Long costLimit = null;
    @SerializedName(value="initCost")
    private Long initCost = null;

    public ErgoLikeContext lastBlockUtxoRoot(AvlTreeData avlTreeData) {
        this.lastBlockUtxoRoot = avlTreeData;
        return this;
    }

    @Schema(required=true, description="")
    public AvlTreeData getLastBlockUtxoRoot() {
        return this.lastBlockUtxoRoot;
    }

    public void setLastBlockUtxoRoot(AvlTreeData avlTreeData) {
        this.lastBlockUtxoRoot = avlTreeData;
    }

    public ErgoLikeContext headers(List<SigmaHeader> list) {
        this.headers = list;
        return this;
    }

    public ErgoLikeContext addHeadersItem(SigmaHeader sigmaHeader) {
        this.headers.add(sigmaHeader);
        return this;
    }

    @Schema(required=true, description="fixed number of last block headers in descending order (first header is the newest one)")
    public List<SigmaHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<SigmaHeader> list) {
        this.headers = list;
    }

    public ErgoLikeContext preHeader(PreHeader preHeader) {
        this.preHeader = preHeader;
        return this;
    }

    @Schema(required=true, description="")
    public PreHeader getPreHeader() {
        return this.preHeader;
    }

    public void setPreHeader(PreHeader preHeader) {
        this.preHeader = preHeader;
    }

    public ErgoLikeContext dataBoxes(List<ErgoTransactionOutput> list) {
        this.dataBoxes = list;
        return this;
    }

    public ErgoLikeContext addDataBoxesItem(ErgoTransactionOutput ergoTransactionOutput) {
        this.dataBoxes.add(ergoTransactionOutput);
        return this;
    }

    @Schema(required=true, description="boxes, that corresponds to id's of `spendingTransaction.dataInputs`")
    public List<ErgoTransactionOutput> getDataBoxes() {
        return this.dataBoxes;
    }

    public void setDataBoxes(List<ErgoTransactionOutput> list) {
        this.dataBoxes = list;
    }

    public ErgoLikeContext boxesToSpend(List<ErgoTransactionOutput> list) {
        this.boxesToSpend = list;
        return this;
    }

    public ErgoLikeContext addBoxesToSpendItem(ErgoTransactionOutput ergoTransactionOutput) {
        this.boxesToSpend.add(ergoTransactionOutput);
        return this;
    }

    @Schema(required=true, description="boxes, that corresponds to id's of `spendingTransaction.inputs`")
    public List<ErgoTransactionOutput> getBoxesToSpend() {
        return this.boxesToSpend;
    }

    public void setBoxesToSpend(List<ErgoTransactionOutput> list) {
        this.boxesToSpend = list;
    }

    public ErgoLikeContext spendingTransaction(ErgoLikeTransaction ergoLikeTransaction) {
        this.spendingTransaction = ergoLikeTransaction;
        return this;
    }

    @Schema(required=true, description="")
    public ErgoLikeTransaction getSpendingTransaction() {
        return this.spendingTransaction;
    }

    public void setSpendingTransaction(ErgoLikeTransaction ergoLikeTransaction) {
        this.spendingTransaction = ergoLikeTransaction;
    }

    public ErgoLikeContext selfIndex(Long l) {
        this.selfIndex = l;
        return this;
    }

    @Schema(required=true, description="index of the box in `boxesToSpend` that contains the script we're evaluating")
    public Long getSelfIndex() {
        return this.selfIndex;
    }

    public void setSelfIndex(Long l) {
        this.selfIndex = l;
    }

    public ErgoLikeContext extension(Object object) {
        this.extension = object;
        return this;
    }

    @Schema(required=true, description="prover-defined key-value pairs, that may be used inside a script")
    public Object getExtension() {
        return this.extension;
    }

    public void setExtension(Object object) {
        this.extension = object;
    }

    public ErgoLikeContext validationSettings(String string) {
        this.validationSettings = string;
        return this;
    }

    @Schema(example="10e8070001e9070001ea070001eb070001ec070001ed070001ee070001ef070001f0070001f1070001f2070001f3070001f4070001f5070001f6070001f7070001", required=true, description="validation parameters passed to Interpreter.verify to detect soft-fork conditions")
    public String getValidationSettings() {
        return this.validationSettings;
    }

    public void setValidationSettings(String string) {
        this.validationSettings = string;
    }

    public ErgoLikeContext costLimit(Long l) {
        this.costLimit = l;
        return this;
    }

    @Schema(required=true, description="hard limit on accumulated execution cost, if exceeded lead to CostLimitException to be thrown")
    public Long getCostLimit() {
        return this.costLimit;
    }

    public void setCostLimit(Long l) {
        this.costLimit = l;
    }

    public ErgoLikeContext initCost(Long l) {
        this.initCost = l;
        return this;
    }

    @Schema(required=true, description="initial value of execution cost already accumulated before Interpreter.verify is called")
    public Long getInitCost() {
        return this.initCost;
    }

    public void setInitCost(Long l) {
        this.initCost = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ErgoLikeContext ergoLikeContext = (ErgoLikeContext)object;
        return Objects.equals(this.lastBlockUtxoRoot, ergoLikeContext.lastBlockUtxoRoot) && Objects.equals(this.headers, ergoLikeContext.headers) && Objects.equals(this.preHeader, ergoLikeContext.preHeader) && Objects.equals(this.dataBoxes, ergoLikeContext.dataBoxes) && Objects.equals(this.boxesToSpend, ergoLikeContext.boxesToSpend) && Objects.equals(this.spendingTransaction, ergoLikeContext.spendingTransaction) && Objects.equals(this.selfIndex, ergoLikeContext.selfIndex) && Objects.equals(this.extension, ergoLikeContext.extension) && Objects.equals(this.validationSettings, ergoLikeContext.validationSettings) && Objects.equals(this.costLimit, ergoLikeContext.costLimit) && Objects.equals(this.initCost, ergoLikeContext.initCost);
    }

    public int hashCode() {
        return Objects.hash(this.lastBlockUtxoRoot, this.headers, this.preHeader, this.dataBoxes, this.boxesToSpend, this.spendingTransaction, this.selfIndex, this.extension, this.validationSettings, this.costLimit, this.initCost);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class ErgoLikeContext {\n");
        stringBuilder.append("    lastBlockUtxoRoot: ").append(this.toIndentedString(this.lastBlockUtxoRoot)).append("\n");
        stringBuilder.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        stringBuilder.append("    preHeader: ").append(this.toIndentedString(this.preHeader)).append("\n");
        stringBuilder.append("    dataBoxes: ").append(this.toIndentedString(this.dataBoxes)).append("\n");
        stringBuilder.append("    boxesToSpend: ").append(this.toIndentedString(this.boxesToSpend)).append("\n");
        stringBuilder.append("    spendingTransaction: ").append(this.toIndentedString(this.spendingTransaction)).append("\n");
        stringBuilder.append("    selfIndex: ").append(this.toIndentedString(this.selfIndex)).append("\n");
        stringBuilder.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        stringBuilder.append("    validationSettings: ").append(this.toIndentedString(this.validationSettings)).append("\n");
        stringBuilder.append("    costLimit: ").append(this.toIndentedString(this.costLimit)).append("\n");
        stringBuilder.append("    initCost: ").append(this.toIndentedString(this.initCost)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

