/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.AdditionalRegisters;
import org.ergoplatform.explorer.client.model.AssetInstanceInfo;

public class OutputInfo {
    @SerializedName(value="boxId")
    private String boxId = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="blockId")
    private String blockId = null;
    @SerializedName(value="value")
    private Long value = null;
    @SerializedName(value="index")
    private Integer index = null;
    @SerializedName(value="creationHeight")
    private Integer creationHeight = null;
    @SerializedName(value="settlementHeight")
    private Integer settlementHeight = null;
    @SerializedName(value="ergoTree")
    private String ergoTree = null;
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="assets")
    private List<AssetInstanceInfo> assets = null;
    @SerializedName(value="additionalRegisters")
    private AdditionalRegisters additionalRegisters = null;
    @SerializedName(value="spentTransactionId")
    private String spentTransactionId = null;
    @SerializedName(value="mainChain")
    private Boolean mainChain = null;

    public OutputInfo boxId(String string) {
        this.boxId = string;
        return this;
    }

    @Schema(required=true, description="Id of the box")
    public String getBoxId() {
        return this.boxId;
    }

    public void setBoxId(String string) {
        this.boxId = string;
    }

    public OutputInfo transactionId(String string) {
        this.transactionId = string;
        return this;
    }

    @Schema(required=true, description="Id of the transaction that created the box")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String string) {
        this.transactionId = string;
    }

    public OutputInfo blockId(String string) {
        this.blockId = string;
        return this;
    }

    @Schema(required=true, description="Id of the block a box included in")
    public String getBlockId() {
        return this.blockId;
    }

    public void setBlockId(String string) {
        this.blockId = string;
    }

    public OutputInfo value(Long l) {
        this.value = l;
        return this;
    }

    @Schema(required=true, description="Value of the box in nanoERG")
    public Long getValue() {
        return this.value;
    }

    public void setValue(Long l) {
        this.value = l;
    }

    public OutputInfo index(Integer n) {
        this.index = n;
        return this;
    }

    @Schema(required=true, description="Index of the output in a transaction")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer n) {
        this.index = n;
    }

    public OutputInfo creationHeight(Integer n) {
        this.creationHeight = n;
        return this;
    }

    @Schema(required=true, description="Height at which the box was created")
    public Integer getCreationHeight() {
        return this.creationHeight;
    }

    public void setCreationHeight(Integer n) {
        this.creationHeight = n;
    }

    public OutputInfo settlementHeight(Integer n) {
        this.settlementHeight = n;
        return this;
    }

    @Schema(required=true, description="Height at which the box got fixed in blockchain")
    public Integer getSettlementHeight() {
        return this.settlementHeight;
    }

    public void setSettlementHeight(Integer n) {
        this.settlementHeight = n;
    }

    public OutputInfo ergoTree(String string) {
        this.ergoTree = string;
        return this;
    }

    @Schema(required=true, description="Serialized ergo tree")
    public String getErgoTree() {
        return this.ergoTree;
    }

    public void setErgoTree(String string) {
        this.ergoTree = string;
    }

    public OutputInfo address(String string) {
        this.address = string;
        return this;
    }

    @Schema(required=true, description="An address derived from ergo tree")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public OutputInfo assets(List<AssetInstanceInfo> list) {
        this.assets = list;
        return this;
    }

    public OutputInfo addAssetsItem(AssetInstanceInfo assetInstanceInfo) {
        if (this.assets == null) {
            this.assets = new ArrayList<AssetInstanceInfo>();
        }
        this.assets.add(assetInstanceInfo);
        return this;
    }

    @Schema(description="")
    public List<AssetInstanceInfo> getAssets() {
        return this.assets;
    }

    public void setAssets(List<AssetInstanceInfo> list) {
        this.assets = list;
    }

    public OutputInfo additionalRegisters(AdditionalRegisters additionalRegisters) {
        this.additionalRegisters = additionalRegisters;
        return this;
    }

    @Schema(required=true, description="")
    public AdditionalRegisters getAdditionalRegisters() {
        return this.additionalRegisters;
    }

    public void setAdditionalRegisters(AdditionalRegisters additionalRegisters) {
        this.additionalRegisters = additionalRegisters;
    }

    public OutputInfo spentTransactionId(String string) {
        this.spentTransactionId = string;
        return this;
    }

    @Schema(description="Id of the transaction this output was spent by")
    public String getSpentTransactionId() {
        return this.spentTransactionId;
    }

    public void setSpentTransactionId(String string) {
        this.spentTransactionId = string;
    }

    public OutputInfo mainChain(Boolean bl) {
        this.mainChain = bl;
        return this;
    }

    @Schema(required=true, description="")
    public Boolean isMainChain() {
        return this.mainChain;
    }

    public void setMainChain(Boolean bl) {
        this.mainChain = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OutputInfo outputInfo = (OutputInfo)object;
        return Objects.equals(this.boxId, outputInfo.boxId) && Objects.equals(this.transactionId, outputInfo.transactionId) && Objects.equals(this.blockId, outputInfo.blockId) && Objects.equals(this.value, outputInfo.value) && Objects.equals(this.index, outputInfo.index) && Objects.equals(this.creationHeight, outputInfo.creationHeight) && Objects.equals(this.settlementHeight, outputInfo.settlementHeight) && Objects.equals(this.ergoTree, outputInfo.ergoTree) && Objects.equals(this.address, outputInfo.address) && Objects.equals(this.assets, outputInfo.assets) && Objects.equals(this.spentTransactionId, outputInfo.spentTransactionId) && Objects.equals(this.mainChain, outputInfo.mainChain);
    }

    public int hashCode() {
        return Objects.hash(this.boxId, this.transactionId, this.blockId, this.value, this.index, this.creationHeight, this.settlementHeight, this.ergoTree, this.address, this.assets, this.spentTransactionId, this.mainChain);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class OutputInfo {\n");
        stringBuilder.append("    boxId: ").append(this.toIndentedString(this.boxId)).append("\n");
        stringBuilder.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        stringBuilder.append("    blockId: ").append(this.toIndentedString(this.blockId)).append("\n");
        stringBuilder.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        stringBuilder.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        stringBuilder.append("    creationHeight: ").append(this.toIndentedString(this.creationHeight)).append("\n");
        stringBuilder.append("    settlementHeight: ").append(this.toIndentedString(this.settlementHeight)).append("\n");
        stringBuilder.append("    ergoTree: ").append(this.toIndentedString(this.ergoTree)).append("\n");
        stringBuilder.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        stringBuilder.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        stringBuilder.append("    spentTransactionId: ").append(this.toIndentedString(this.spentTransactionId)).append("\n");
        stringBuilder.append("    mainChain: ").append(this.toIndentedString(this.mainChain)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

