/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.cli;

import java.io.Serializable;
import org.ergoplatform.appkit.ErgoClient;
import org.ergoplatform.appkit.cli.AppContext;
import org.ergoplatform.appkit.cli.AppContext$;
import org.ergoplatform.appkit.cli.CmdLineParser$;
import org.ergoplatform.appkit.cli.CmdOption;
import org.ergoplatform.appkit.cli.CmdOption$;
import org.ergoplatform.appkit.cli.ConfigOption$;
import org.ergoplatform.appkit.cli.Console;
import org.ergoplatform.appkit.commands.Cmd;
import org.ergoplatform.appkit.commands.CmdDescriptor;
import org.ergoplatform.appkit.commands.CmdException;
import org.ergoplatform.appkit.commands.UsageException;
import org.ergoplatform.appkit.commands.package$;
import org.ergoplatform.appkit.config.ErgoToolConfig;
import org.ergoplatform.appkit.ergotool.HelpCmd$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$String$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001A4Q\u0001C\u0005\u0002\u0002IAQ!\u0007\u0001\u0005\u0002iAQ!\b\u0001\u0005\u0002yA\u0001\u0002\r\u0001\t\u0006\u0004%\t!\r\u0005\u0006{\u0001!\tA\u0010\u0005\u0006-\u0002!\ta\u0016\u0005\u0006C\u0002!\tA\u0019\u0005\u0006Q\u0002!\t!\u001b\u0002\u000f\u00072L\u0017\t\u001d9mS\u000e\fG/[8o\u0015\tQ1\"A\u0002dY&T!\u0001D\u0007\u0002\r\u0005\u0004\bo[5u\u0015\tqq\"\u0001\u0007fe\u001e|\u0007\u000f\\1uM>\u0014XNC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003%\t\u0001bY8n[\u0006tGm]\u000b\u0002?A\u0019\u0001\u0005K\u0016\u000f\u0005\u00052cB\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0012\u0003\u0019a$o\\8u}%\ta#\u0003\u0002(+\u00059\u0001/Y2lC\u001e,\u0017BA\u0015+\u0005\r\u0019V-\u001d\u0006\u0003OU\u0001\"\u0001\f\u0018\u000e\u00035R!!H\u0006\n\u0005=j#!D\"nI\u0012+7o\u0019:jaR|'/A\u0006d_6l\u0017M\u001c3t\u001b\u0006\u0004X#\u0001\u001a\u0011\tM:$h\u000b\b\u0003iU\u0002\"AI\u000b\n\u0005Y*\u0012A\u0002)sK\u0012,g-\u0003\u00029s\t\u0019Q*\u00199\u000b\u0005Y*\u0002CA\u001a<\u0013\ta\u0014H\u0001\u0004TiJLgnZ\u0001\u0004eVtG\u0003B C\u000b*\u0003\"\u0001\u0006!\n\u0005\u0005+\"\u0001B+oSRDQa\u0011\u0003A\u0002\u0011\u000bA!\u0019:hgB\u0019\u0001\u0005\u000b\u001e\t\u000b\u0019#\u0001\u0019A$\u0002\u000f\r|gn]8mKB\u0011A\u0004S\u0005\u0003\u0013&\u0011qaQ8og>dW\rC\u0003L\t\u0001\u0007A*A\u0007dY&,g\u000e\u001e$bGR|'/\u001f\t\u0005)5{%+\u0003\u0002O+\tIa)\u001e8di&|g.\r\t\u00039AK!!U\u0005\u0003\u0015\u0005\u0003\boQ8oi\u0016DH\u000f\u0005\u0002T)6\t1\"\u0003\u0002V\u0017\tQQI]4p\u00072LWM\u001c;\u0002\u00151|\u0017\rZ\"p]\u001aLw\r\u0006\u0002Y=B\u0011\u0011\fX\u0007\u00025*\u00111lC\u0001\u0007G>tg-[4\n\u0005uS&AD#sO>$vn\u001c7D_:4\u0017n\u001a\u0005\u0006?\u0016\u0001\r\u0001Y\u0001\u000bG6$w\n\u001d;j_:\u001c\b\u0003B\u001a8ui\n\u0001\u0002]1sg\u0016\u001cU\u000e\u001a\u000b\u0003G\u001a\u0004\"\u0001\f3\n\u0005\u0015l#aA\"nI\")qM\u0002a\u0001\u001f\u0006\u00191\r\u001e=\u0002\u0015A\u0014\u0018N\u001c;Vg\u0006<W\rF\u0002@U.DQAR\u0004A\u0002\u001dCQ\u0001\\\u0004A\u00025\f!bY7e\t\u0016\u001c8m\u00149u!\r!bnK\u0005\u0003_V\u0011aa\u00149uS>t\u0007")
public abstract class CliApplication {
    private Map<String, CmdDescriptor> commandsMap;
    private volatile boolean bitmap$0;

    public Seq<CmdDescriptor> commands() {
        return Predef$.MODULE$.wrapRefArray((Object[])new HelpCmd$[]{HelpCmd$.MODULE$});
    }

    private Map<String, CmdDescriptor> commandsMap$lzycompute() {
        CliApplication cliApplication = this;
        synchronized (cliApplication) {
            if (!this.bitmap$0) {
                this.commandsMap = ((TraversableOnce)this.commands().map((Function1<CmdDescriptor, Tuple2> & Serializable & scala.Serializable)c -> new Tuple2<String, CmdDescriptor>(c.name(), (CmdDescriptor)c), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = true;
            }
        }
        return this.commandsMap;
    }

    public Map<String, CmdDescriptor> commandsMap() {
        return !this.bitmap$0 ? this.commandsMap$lzycompute() : this.commandsMap;
    }

    public void run(Seq<String> args, Console console, Function1<AppContext, ErgoClient> clientFactory) {
        try {
            Tuple2<Map<String, String>, Seq<String>> tuple2 = CmdLineParser$.MODULE$.parseOptions(args);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Map<String, String> cmdOptions = tuple2._1();
            Seq<String> cmdArgs = tuple2._2();
            Tuple2<Map<String, String>, Seq<String>> tuple22 = new Tuple2<Map<String, String>, Seq<String>>(cmdOptions, cmdArgs);
            Tuple2<Map<String, String>, Seq<String>> tuple23 = tuple22;
            Map<String, String> cmdOptions2 = tuple23._1();
            Seq<String> cmdArgs2 = tuple23._2();
            if (cmdArgs2.isEmpty()) {
                throw package$.MODULE$.usageError("Please specify command name and parameters.", None$.MODULE$);
            }
            ErgoToolConfig toolConf = this.loadConfig(cmdOptions2);
            AppContext ctx = new AppContext(this, args, console, cmdOptions2, (String)cmdArgs2.apply(false), (Seq)cmdArgs2.drop(1), toolConf, clientFactory, AppContext$.MODULE$.apply$default$9());
            Cmd cmd = this.parseCmd(ctx);
            try {
                cmd.run(ctx);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CmdException) {
                    CmdException cmdException = (CmdException)throwable2;
                    throw cmdException;
                }
                if (throwable2 instanceof UsageException) {
                    UsageException usageException = (UsageException)throwable2;
                    throw usageException;
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = option.get();
                    t.printStackTrace();
                    throw new CmdException(new StringBuilder(27).append("Error executing command ").append(cmd).append(":\n ").append(t).toString(), cmd, t);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (throwable3 instanceof UsageException) {
                UsageException usageException = (UsageException)throwable3;
                console.println(usageException.getMessage());
                this.printUsage(console, usageException.cmdDescOpt());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable t = option.get();
                console.println(t.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ErgoToolConfig loadConfig(Map<String, String> cmdOptions) {
        void var3_3;
        String configFile = (String)cmdOptions.getOrElse(ConfigOption$.MODULE$.name(), (Function0<String> & Serializable & scala.Serializable)() -> "ergo_tool_config.json");
        ErgoToolConfig toolConf = ErgoToolConfig.load(configFile);
        return var3_3;
    }

    public Cmd parseCmd(AppContext ctx) {
        Option option = this.commandsMap().get(ctx.cmdName());
        if (!(option instanceof Some)) {
            throw package$.MODULE$.usageError(new StringBuilder(17).append("Unknown command: ").append(ctx.cmdName()).toString(), None$.MODULE$);
        }
        Some some = (Some)option;
        CmdDescriptor c = (CmdDescriptor)some.value();
        Seq<String> args = ctx.cmdArgs();
        Seq<Object> params = c.parseArgs(ctx, args);
        Cmd cmd = c.createCmd(ctx.withCmdParameters(params));
        return cmd;
    }

    public void printUsage(Console console, Option<CmdDescriptor> cmdDescOpt) {
        Option<CmdDescriptor> option = cmdDescOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            CmdDescriptor desc = (CmdDescriptor)some.value();
            desc.printUsage(console);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String actions = ((TraversableOnce)((TraversableLike)this.commandsMap().toSeq().sortBy((Function1<Tuple2, String> & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), Ordering$String$.MODULE$)).map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String name = (String)tuple2._1();
                CmdDescriptor c = (CmdDescriptor)tuple2._2();
                String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(5).append("  ").append(name).append(" ").append(c.cmdParamSyntax()).append("\n\t").append(c.description()).toString())).stripMargin();
                return string;
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
            String options = ((TraversableOnce)((TraversableLike)CmdOption$.MODULE$.options().sortBy((Function1<CmdOption, String> & Serializable & scala.Serializable)x$3 -> x$3.name(), Ordering$String$.MODULE$)).map((Function1<CmdOption, String> & Serializable & scala.Serializable)x$4 -> x$4.helpString(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
            String msg = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(200).append("\n            |Usage:\n            |ergotool [options] action [action parameters]\n            |\n            |Available actions:\n            |").append(actions).append("\n            |\n            |Options:\n            |").append(options).append("\n          ").toString())).stripMargin();
            console.println(msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }
}

