from boa_test.tests.boa_test import BoaFixtureTest
from neo.Settings import settings
from neo.Core.State.ContractState import ContractState
from neo.SmartContract.StorageContext import StorageContext
from boa.compiler import Compiler
from neo.Prompt.Commands.BuildNRun import TestBuild
import os
import shutil
from logzero import logger

settings.USE_DEBUG_STORAGE = True
settings.DEBUG_STORAGE_PATH = './fixtures/debugstorage'


class TestContract(BoaFixtureTest):

    @classmethod
    def tearDownClass(cls):
        super(BoaFixtureTest, cls).tearDownClass()
        try:
            if os.path.exists(settings.debug_storage_leveldb_path):

                shutil.rmtree(settings.debug_storage_leveldb_path)
            else:
                logger.error("debug storage path doesn't exist")
        except Exception as e:
            logger.error("couldn't remove debug storage %s " % e)

    def test_Contract(self):
        output = Compiler.instance().load('%s/boa_test/example/blockchain/ContractTest.py' % TestContract.dirname).default
        out = output.write()

        contract_hash = bytearray(b'\xd3\xd8`(\x14\xa4)\xa9\x1a\xfd\xba\xa3\x91H\x84\xa1\xc9\x0cs1')
        contract_script = '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'

        tx, results, total_ops, engine = TestBuild(out, ['get_contract', contract_hash], self.GetWallet1(), '070505', '05')
        self.assertEqual(len(results), 1)
        self.assertIsInstance(results[0].GetInterface(), ContractState)

        tx, results, total_ops, engine = TestBuild(out, ['get_script', contract_hash], self.GetWallet1(), '070505', '05')
        self.assertEqual(len(results), 1)
        self.assertEqual(results[0].GetByteArray().hex(), contract_script)

        tx, results, total_ops, engine = TestBuild(out, ['get_storage_context', contract_hash], self.GetWallet1(), '070505', '05')
        self.assertEqual(len(results), 0)

        tx, results, total_ops, engine = TestBuild(out, ['destroy', contract_hash], self.GetWallet1(), '070505', '05')
        self.assertEqual(len(results), 1)
        self.assertEqual(results[0].GetBigInteger(), 1)
