import { CloudFrontWebDistribution, Behavior, SSLMethod, SecurityPolicyProtocol } from 'aws-cdk-lib/aws-cloudfront';
import { Role } from 'aws-cdk-lib/aws-iam';
import s3 = require('aws-cdk-lib/aws-s3');
import { Construct } from 'constructs';
export interface SPADeployConfig {
    readonly indexDoc: string;
    readonly errorDoc?: string;
    readonly websiteFolder: string;
    readonly certificateARN?: string;
    readonly cfBehaviors?: Behavior[];
    readonly cfAliases?: string[];
    readonly exportWebsiteUrlOutput?: boolean;
    readonly exportWebsiteUrlName?: string;
    readonly blockPublicAccess?: s3.BlockPublicAccess;
    readonly sslMethod?: SSLMethod;
    readonly securityPolicy?: SecurityPolicyProtocol;
    readonly role?: Role;
}
export interface HostedZoneConfig {
    readonly indexDoc: string;
    readonly errorDoc?: string;
    readonly cfBehaviors?: Behavior[];
    readonly websiteFolder: string;
    readonly zoneName: string;
    readonly subdomain?: string;
    readonly role?: Role;
}
export interface SPAGlobalConfig {
    readonly encryptBucket?: boolean;
    readonly ipFilter?: boolean;
    readonly ipList?: string[];
    readonly role?: Role;
}
export interface SPADeployment {
    readonly websiteBucket: s3.Bucket;
}
export interface SPADeploymentWithCloudFront extends SPADeployment {
    readonly distribution: CloudFrontWebDistribution;
}
export declare class SPADeploy extends Construct {
    globalConfig: SPAGlobalConfig;
    constructor(scope: Construct, id: string, config?: SPAGlobalConfig);
    /**
     * Helper method to provide a configured s3 bucket
     */
    private getS3Bucket;
    /**
     * Helper method to provide configuration for cloudfront
     */
    private getCFConfig;
    /**
     * Basic setup needed for a non-ssl, non vanity url, non cached s3 website.
     */
    createBasicSite(config: SPADeployConfig): SPADeployment;
    /**
     * This will create an s3 deployment fronted by a cloudfront distribution
     It will also setup error forwarding and unauth forwarding back to indexDoc.
     */
    createSiteWithCloudfront(config: SPADeployConfig): SPADeploymentWithCloudFront;
    /**
     * S3 Deployment, cloudfront distribution, ssl cert and error forwarding auto
     configured by using the details in the hosted zone provided.
     */
    createSiteFromHostedZone(config: HostedZoneConfig): SPADeploymentWithCloudFront;
}
