MockREEsSubmercado = [
    "   Relatorio dos dados da configuracao dos Reservatorios Equivalentes (REEs) e Subsistemas\n",
    "   X--------------------X-----------------------X\n",
    "     Reserv. Eq.(REE)        Subsistema\n",
    "    Num       Nome       Num   Nome  Nome NEWAVE\n",
    "   X----X---------------X----X------X-----------X\n",
    "      1       SUDESTE      1    SE    SUDESTE   \n",
    "      6       MADEIRA      1    SE    SUDESTE   \n",
    "      7       TPIRES       1    SE    SUDESTE   \n",
    "      5       ITAIPU       1    SE    SUDESTE   \n",
    "     10       PARANA       1    SE    SUDESTE   \n",
    "     12       PRNPANEMA    1    SE    SUDESTE   \n",
    "      2       SUL          2    S     SUL       \n",
    "     11       IGUACU       2    S     SUL       \n",
    "      3       NORDESTE     3    NE    NORDESTE  \n",
    "      4       NORTE        4    N     NORTE     \n",
    "      8       BMONTE       4    N     NORTE     \n",
    "      9       MAN-AP       4    N     NORTE     \n",
    "   X----X---------------X----X------X-----------X\n",
    "\n",
]

MockUHEsREEsSubmercado = [
    "   Relatorio dos dados de Configuracao das Usinas Hidroeletricas, Reservatorios Equivalentes (REEs) e Subsistemas\n",
    "   X--------------------X--------------------X----------------------------X\n",
    "       Usina                Reserv. Eq.(REE)          Subsistema\n",
    "    Num   Nome           Num   Nome           Num   Nome       Nome NEWAVE\n",
    "   X----X---------------X----X---------------X----X-----------X-----------X\n",
    "    108  TRAICAO          1    SUDESTE         1      SE          SUDESTE   \n",
    "    109  PEDREIRA         1    SUDESTE         1      SE          SUDESTE   \n",
    "    117  GUARAPIRANGA     1    SUDESTE         1      SE          SUDESTE   \n",
    "    118  BILLINGS         1    SUDESTE         1      SE          SUDESTE   \n",
    "    119  HENRY BORDEN     1    SUDESTE         1      SE          SUDESTE   \n",
    "    120  JAGUARI          1    SUDESTE         1      SE          SUDESTE   \n",
    "    121  PARAIBUNA        1    SUDESTE         1      SE          SUDESTE   \n",
    "    122  SANTA BRANCA     1    SUDESTE         1      SE          SUDESTE   \n",
    "    123  FUNIL            1    SUDESTE         1      SE          SUDESTE   \n",
    "    124  LAJES            1    SUDESTE         1      SE          SUDESTE   \n",
    "    125  STA CECILIA      1    SUDESTE         1      SE          SUDESTE   \n",
    "    126  PICADA           1    SUDESTE         1      SE          SUDESTE   \n",
    "    127  SOBRAGI          1    SUDESTE         1      SE          SUDESTE   \n",
    "    129  SIMPLICIO        1    SUDESTE         1      SE          SUDESTE   \n",
    "    130  ILHA POMBOS      1    SUDESTE         1      SE          SUDESTE   \n",
    "    131  NILO PECANHA     1    SUDESTE         1      SE          SUDESTE   \n",
    "    133  P. PASSOS        1    SUDESTE         1      SE          SUDESTE   \n",
    "    134  SALTO GRANDE     1    SUDESTE         1      SE          SUDESTE   \n",
    "    135  P. ESTRELA       1    SUDESTE         1      SE          SUDESTE   \n",
    "    139  CANDONGA         1    SUDESTE         1      SE          SUDESTE   \n",
    "    141  BAGUARI          1    SUDESTE         1      SE          SUDESTE   \n",
    "    143  AIMORES          1    SUDESTE         1      SE          SUDESTE   \n",
    "    144  MASCARENHAS      1    SUDESTE         1      SE          SUDESTE   \n",
    "    148  IRAPE            1    SUDESTE         1      SE          SUDESTE   \n",
    "    155  RETIRO BAIXO     1    SUDESTE         1      SE          SUDESTE   \n",
    "    156  TRES MARIAS      1    SUDESTE         1      SE          SUDESTE   \n",
    "    162  QUEIMADO         1    SUDESTE         1      SE          SUDESTE   \n",
    "    180  TOCOS            1    SUDESTE         1      SE          SUDESTE   \n",
    "    181  SANTANA          1    SUDESTE         1      SE          SUDESTE   \n",
    "    182  VIGARIO          1    SUDESTE         1      SE          SUDESTE   \n",
    "    183  FONTES A         1    SUDESTE         1      SE          SUDESTE   \n",
    "    184  FONTES BC        1    SUDESTE         1      SE          SUDESTE   \n",
    "    192  GUILMAN-AMOR     1    SUDESTE         1      SE          SUDESTE   \n",
    "    193  SA CARVALHO      1    SUDESTE         1      SE          SUDESTE   \n",
    "    195  JAURU            1    SUDESTE         1      SE          SUDESTE   \n",
    "    217  ROSAL            1    SUDESTE         1      SE          SUDESTE   \n",
    "    251  SERRA MESA       1    SUDESTE         1      SE          SUDESTE   \n",
    "    252  CANA BRAVA       1    SUDESTE         1      SE          SUDESTE   \n",
    "    253  SAO SALVADOR     1    SUDESTE         1      SE          SUDESTE   \n",
    "    257  PEIXE ANGIC      1    SUDESTE         1      SE          SUDESTE   \n",
    "    261  LAJEADO          1    SUDESTE         1      SE          SUDESTE   \n",
    "    278  MANSO            1    SUDESTE         1      SE          SUDESTE   \n",
    "    281  PONTE PEDRA      1    SUDESTE         1      SE          SUDESTE   \n",
    "    283  STA CLARA MG     1    SUDESTE         1      SE          SUDESTE   \n",
    "    304  ITIQUIRA I       1    SUDESTE         1      SE          SUDESTE   \n",
    "    305  ITIQUIRA II      1    SUDESTE         1      SE          SUDESTE   \n",
    "    196  GUAPORE          6    MADEIRA         1      SE          SUDESTE   \n",
    "    276  RONDON II        6    MADEIRA         1      SE          SUDESTE   \n",
    "    279  SAMUEL           6    MADEIRA         1      SE          SUDESTE   \n",
    "    285  JIRAU            6    MADEIRA         1      SE          SUDESTE   \n",
    "    287  STO ANTONIO      6    MADEIRA         1      SE          SUDESTE   \n",
    "    310  DARDANELOS       6    MADEIRA         1      SE          SUDESTE   \n",
    "    227  SINOP            7    TPIRES          1      SE          SUDESTE   \n",
    "    228  COLIDER          7    TPIRES          1      SE          SUDESTE   \n",
    "    229  TELES PIRES      7    TPIRES          1      SE          SUDESTE   \n",
    "    230  SAO MANOEL       7    TPIRES          1      SE          SUDESTE   \n",
    "     66  ITAIPU           5    ITAIPU          1      SE          SUDESTE   \n",
    "      1  CAMARGOS        10    PARANA          1      SE          SUDESTE   \n",
    "      2  ITUTINGA        10    PARANA          1      SE          SUDESTE   \n",
    "      4  FUNIL-GRANDE    10    PARANA          1      SE          SUDESTE   \n",
    "      6  FURNAS          10    PARANA          1      SE          SUDESTE   \n",
    "      7  M. DE MORAES    10    PARANA          1      SE          SUDESTE   \n",
    "      8  ESTREITO        10    PARANA          1      SE          SUDESTE   \n",
    "      9  JAGUARA         10    PARANA          1      SE          SUDESTE   \n",
    "     10  IGARAPAVA       10    PARANA          1      SE          SUDESTE   \n",
    "     11  VOLTA GRANDE    10    PARANA          1      SE          SUDESTE   \n",
    "     12  P. COLOMBIA     10    PARANA          1      SE          SUDESTE   \n",
    "     14  CACONDE         10    PARANA          1      SE          SUDESTE   \n",
    "     15  E. DA CUNHA     10    PARANA          1      SE          SUDESTE   \n",
    "     16  A.S.OLIVEIRA    10    PARANA          1      SE          SUDESTE   \n",
    "     17  MARIMBONDO      10    PARANA          1      SE          SUDESTE   \n",
    "     18  A. VERMELHA     10    PARANA          1      SE          SUDESTE   \n",
    "     20  BATALHA         10    PARANA          1      SE          SUDESTE   \n",
    "     21  SERRA FACAO     10    PARANA          1      SE          SUDESTE   \n",
    "     24  EMBORCACAO      10    PARANA          1      SE          SUDESTE   \n",
    "     25  NOVA PONTE      10    PARANA          1      SE          SUDESTE   \n",
    "     26  MIRANDA         10    PARANA          1      SE          SUDESTE   \n",
    "     27  CAPIM BRANC1    10    PARANA          1      SE          SUDESTE   \n",
    "     28  CAPIM BRANC2    10    PARANA          1      SE          SUDESTE   \n",
    "     29  CORUMBA IV      10    PARANA          1      SE          SUDESTE   \n",
    "     30  CORUMBA I       10    PARANA          1      SE          SUDESTE   \n",
    "     31  ITUMBIARA       10    PARANA          1      SE          SUDESTE   \n",
    "     32  CACH.DOURADA    10    PARANA          1      SE          SUDESTE   \n",
    "     33  SAO SIMAO       10    PARANA          1      SE          SUDESTE   \n",
    "     34  I. SOLTEIRA     10    PARANA          1      SE          SUDESTE   \n",
    "     37  BARRA BONITA    10    PARANA          1      SE          SUDESTE   \n",
    "     38  A.S. LIMA       10    PARANA          1      SE          SUDESTE   \n",
    "     39  IBITINGA        10    PARANA          1      SE          SUDESTE   \n",
    "     40  PROMISSAO       10    PARANA          1      SE          SUDESTE   \n",
    "     42  NAVANHANDAVA    10    PARANA          1      SE          SUDESTE   \n",
    "     43  TRES IRMAOS     10    PARANA          1      SE          SUDESTE   \n",
    "     45  JUPIA           10    PARANA          1      SE          SUDESTE   \n",
    "     46  P. PRIMAVERA    10    PARANA          1      SE          SUDESTE   \n",
    "    107  EDGARD SOUZA    10    PARANA          1      SE          SUDESTE   \n",
    "    153  SAO DOMINGOS    10    PARANA          1      SE          SUDESTE   \n",
    "    203  CORUMBA III     10    PARANA          1      SE          SUDESTE   \n",
    "    241  SLT VERDINHO    10    PARANA          1      SE          SUDESTE   \n",
    "    262  SALTO           10    PARANA          1      SE          SUDESTE   \n",
    "    290  ESPORA          10    PARANA          1      SE          SUDESTE   \n",
    "    311  CACU            10    PARANA          1      SE          SUDESTE   \n",
    "    312  B. COQUEIROS    10    PARANA          1      SE          SUDESTE   \n",
    "    315  FOZ R. CLARO    10    PARANA          1      SE          SUDESTE   \n",
    "     47  A.A. LAYDNER    12    PRNPANEMA       1      SE          SUDESTE   \n",
    "     48  PIRAJU          12    PRNPANEMA       1      SE          SUDESTE   \n",
    "     49  CHAVANTES       12    PRNPANEMA       1      SE          SUDESTE   \n",
    "     50  L.N. GARCEZ     12    PRNPANEMA       1      SE          SUDESTE   \n",
    "     51  CANOAS II       12    PRNPANEMA       1      SE          SUDESTE   \n",
    "     52  CANOAS I        12    PRNPANEMA       1      SE          SUDESTE   \n",
    "     61  CAPIVARA        12    PRNPANEMA       1      SE          SUDESTE   \n",
    "     62  TAQUARUCU       12    PRNPANEMA       1      SE          SUDESTE   \n",
    "     63  ROSANA          12    PRNPANEMA       1      SE          SUDESTE   \n",
    "    249  OURINHOS        12    PRNPANEMA       1      SE          SUDESTE   \n",
    "     86  BARRA GRANDE     2    SUL             2      S           SUL       \n",
    "     89  GARIBALDI        2    SUL             2      S           SUL       \n",
    "     90  CAMPOS NOVOS     2    SUL             2      S           SUL       \n",
    "     91  MACHADINHO       2    SUL             2      S           SUL       \n",
    "     92  ITA              2    SUL             2      S           SUL       \n",
    "     93  PASSO FUNDO      2    SUL             2      S           SUL       \n",
    "     94  MONJOLINHO       2    SUL             2      S           SUL       \n",
    "     95  QUEBRA QUEIX     2    SUL             2      S           SUL       \n",
    "     97  CASTRO ALVES     2    SUL             2      S           SUL       \n",
    "     98  MONTE CLARO      2    SUL             2      S           SUL       \n",
    "     99  14 DE JULHO      2    SUL             2      S           SUL       \n",
    "    101  SAO JOSE         2    SUL             2      S           SUL       \n",
    "    102  PASSO S JOAO     2    SUL             2      S           SUL       \n",
    "    103  FOZ CHAPECO      2    SUL             2      S           SUL       \n",
    "    110  ERNESTINA        2    SUL             2      S           SUL       \n",
    "    111  PASSO REAL       2    SUL             2      S           SUL       \n",
    "    112  JACUI            2    SUL             2      S           SUL       \n",
    "    113  ITAUBA           2    SUL             2      S           SUL       \n",
    "    114  D. FRANCISCA     2    SUL             2      S           SUL       \n",
    "    115  G.P. SOUZA       2    SUL             2      S           SUL       \n",
    "    215  SALTO PILAO      2    SUL             2      S           SUL       \n",
    "     57  MAUA            11    IGUACU          2      S           SUL       \n",
    "     71  STA CLARA PR    11    IGUACU          2      S           SUL       \n",
    "     72  FUNDAO          11    IGUACU          2      S           SUL       \n",
    "     73  JORDAO          11    IGUACU          2      S           SUL       \n",
    "     74  G.B. MUNHOZ     11    IGUACU          2      S           SUL       \n",
    "     76  SEGREDO         11    IGUACU          2      S           SUL       \n",
    "     77  SLT.SANTIAGO    11    IGUACU          2      S           SUL       \n",
    "     78  SALTO OSORIO    11    IGUACU          2      S           SUL       \n",
    "     82  SALTO CAXIAS    11    IGUACU          2      S           SUL       \n",
    "     83  BAIXO IGUACU    11    IGUACU          2      S           SUL       \n",
    "    154  ITAPEBI          3    NORDESTE        3      NE          NORDESTE  \n",
    "    169  SOBRADINHO       3    NORDESTE        3      NE          NORDESTE  \n",
    "    172  ITAPARICA        3    NORDESTE        3      NE          NORDESTE  \n",
    "    173  MOXOTO           3    NORDESTE        3      NE          NORDESTE  \n",
    "    174  P.AFONSO 123     3    NORDESTE        3      NE          NORDESTE  \n",
    "    175  P.AFONSO 4       3    NORDESTE        3      NE          NORDESTE  \n",
    "    178  XINGO            3    NORDESTE        3      NE          NORDESTE  \n",
    "    189  P. CAVALO        3    NORDESTE        3      NE          NORDESTE  \n",
    "    190  B. ESPERANCA     3    NORDESTE        3      NE          NORDESTE  \n",
    "    176  COMP PAF-MOX     3    NORDESTE        3      NE          NORDESTE  \n",
    "    267  ESTREITO TOC     4    NORTE           4      N           NORTE     \n",
    "    275  TUCURUI          4    NORTE           4      N           NORTE     \n",
    "    272  CURUA-UNA        8    BMONTE          4      N           NORTE     \n",
    "    288  BELO MONTE       8    BMONTE          4      N           NORTE     \n",
    "    314  PIMENTAL         8    BMONTE          4      N           NORTE     \n",
    "    204  CACH.CALDEIR     9    MAN-AP          4      N           NORTE     \n",
    "    277  BALBINA          9    MAN-AP          4      N           NORTE     \n",
    "    280  COARACY NUNE     9    MAN-AP          4      N           NORTE     \n",
    "    284  FERREIRA GOM     9    MAN-AP          4      N           NORTE     \n",
    "    286  STO ANT JARI     9    MAN-AP          4      N           NORTE     \n",
    "   X----X---------------X----X---------------X----X-----------X-----------X\n",
    "\n",
]

MockConvergencia = [
    "   RELATORIO DE CONVERGENCIA DO PROCESSO ITERATIVO\n",
    "\n",
    "   X----X------------X------------X----------------X--------|----------------------------------------------------------------------X\n",
    "                                                            |             Primeiro mes - iteracoes forward\n",
    "                                                            |----------------------------------------------------------------------X\n",
    "                                                            |       Tot Def         |\n",
    "     It      Zinf         Zsup            GAP        TEMPO  |-----------------------|----------------------------------------------X\n",
    "          (1.0E+03 $)  (1.0E+03 $)        (%)               |  Demanda    Niv Seg   |  Num.   Tot. Inviab  Tot. Inviab  Tot. Inviab\n",
    "                                                            |  (MWmed)    (MWmes)   | Inviab    (MWmed)      (m3/s)       (Hm3)\n",
    "   X----X------------X------------X----------------X--------|----------X------------X-------X------------X------------X------------X\n",
    "      1      450767.9 1828276433.0  405491.5174150  00:00:23|        0.      -          4           0.          14.           0.                       \n",
    "      2      450767.9 1828276433.0  405491.5174150  00:00:45|        0.      -         44         135.         481.           0.                       \n",
    "      3      450767.9 1828276433.0  405491.5174150  00:01:00|        0.      -         33         113.         188.           0.                       \n",
    "      4    41454619.2  197389439.7     376.1578887  00:01:10|        0.      -          0           0.           0.           0.                       \n",
    "      5    85359403.8   85396719.4       0.0437159  00:01:24|        0.      -          0           0.           0.           0.                       \n",
    "      6    85359508.8   85396719.4       0.0435928  00:01:53|        0.      -          1           0.          10.           0.                       \n",
    "      7    85360125.8   85396719.4       0.0428697  00:02:02|        0.      -          0           0.           0.           0.                       \n",
    "      8    85361257.2   85396719.4       0.0415438  00:02:17|        0.      -          0           0.           0.           0.                       \n",
    "      9    85366484.0   85396719.4       0.0354184  00:02:36|        0.      -          1           0.           0.           0.                       \n",
    "     10    85366570.3   85396719.4       0.0353172  00:02:50|        0.      -          0           0.           0.           0.                       \n",
    "     11    85366634.8   85396719.4       0.0352417  00:03:01|        0.      -          0           0.           0.           0.                       \n",
    "     12    85366777.3   85396719.4       0.0350747  00:03:12|        0.      -          0           0.           0.           0.                       \n",
    "     13    85367492.4   85396719.4       0.0342367  00:03:21|        0.      -          1           0.           0.           0.                       \n",
    "     14    85367493.7   85396719.4       0.0342352  00:03:33|        0.      -          0           0.           0.           0.                       \n",
    "     15    85368158.6   85396719.4       0.0334560  00:03:43|        0.      -          0           0.           0.           0.                       \n",
    "     16    85368180.1   85396719.4       0.0334308  00:03:57|        0.      -          0           0.           0.           0.                       \n",
    "     17    85368746.1   85396719.4       0.0327677  00:04:05|        0.      -          0           0.           0.           0.                       \n",
    "     18    85368957.6   85396719.4       0.0325198  00:04:15|        0.      -          0           0.           0.           0.                       \n",
    "     19    85370431.3   85396719.4       0.0307930  00:04:23|        0.      -          0           0.           0.           0.                       \n",
    "     20    85370505.7   85396719.4       0.0307059  00:04:38|        0.      -          1           0.           0.           0.                       \n",
    "     21    85370934.6   85396719.4       0.0302032  00:04:50|        0.      -          0           0.           0.           0.                       \n",
    "     22    85370986.3   85396719.4       0.0301427  00:05:04|        0.      -          1           0.           0.           0.                       \n",
    "     23    85370997.0   85396719.4       0.0301302  00:05:13|        0.      -          0           0.           0.           0.                       \n",
    "     24    85371004.4   85396719.4       0.0301215  00:05:23|        0.      -          0           0.           0.           0.                       \n",
    "     25    85371018.4   85396719.4       0.0301050  00:05:34|        0.      -          1           0.           0.           0.                       \n",
    "     26    85371052.5   85396719.4       0.0300651  00:05:42|        0.      -          0           0.           0.           0.                       \n",
    "     27    85371110.1   85396719.4       0.0299977  00:05:51|        0.      -          1           0.           0.           0.                       \n",
    "     28    85371136.7   85396719.4       0.0299665  00:06:01|        0.      -          0           0.           0.           0.                       \n",
    "     29    85371209.7   85396719.4       0.0298810  00:06:12|        0.      -          1           0.           0.           0.                       \n",
    "     30    85371245.3   85377508.9       0.0073370  00:06:23|        0.      -          0           0.           0.           0.                       \n",
    "     31    85371313.9   85377508.9       0.0072566  00:06:36|        0.      -          0           0.           0.           0.                       \n",
    "     32    85371326.7   85377508.9       0.0072416  00:06:51|        0.      -          1           0.           0.           0.                       \n",
    "     33    85371328.3   85377508.9       0.0072398  00:07:01|        0.      -          0           0.           0.           0.                       \n",
    "     34    85371329.1   85377508.9       0.0072388  00:07:14|        0.      -          0           0.           0.           0.                       \n",
    "     35    85371329.9   85376869.8       0.0064891  00:07:25|        0.      -          0           0.           0.           0.                       \n",
    "     36    85371330.0   85376869.8       0.0064890  00:07:35|        0.      -          0           0.           0.           0.                       \n",
    "     37    85371330.1   85376869.8       0.0064889  00:07:46|        0.      -          1           0.           0.           0.                       \n",
    "     38    85373007.7   85376746.6       0.0043796  00:07:58|        0.      -          0           0.           0.           0.                       \n",
    "     39    85373098.4   85376746.6       0.0042733  00:08:10|        0.      -          0           0.           0.           0.                       \n",
    "     40    85373401.3   85376447.1       0.0035676  00:08:22|        0.      -          0           0.           0.           0.                       \n",
    "     41    85373626.3   85375795.9       0.0025413  00:08:37|        0.      -          0           0.           0.           0.                       \n",
    "     42    85373700.4   85375795.9       0.0024545  00:08:49|        0.      -          0           0.           0.           0.                       \n",
    "     43    85374198.3   85375421.7       0.0014330  00:09:03|        0.      -          0           0.           0.           0.                       \n",
    "     44    85374273.6   85375421.7       0.0013448  00:09:17|        0.      -          0           0.           0.           0.                       \n",
    "     45    85374341.8   85375245.1       0.0010581  00:09:29|        0.      -          0           0.           0.           0.                       \n",
    "     46    85374463.4   85375155.7       0.0008109  00:09:43|        0.      -          0           0.           0.           0.                       \n",
    "   X----X------------X------------X----------------X--------|----------X------------X-------X------------X------------X------------X\n",
    "     47    85374511.5   85375047.8       0.0006282  00:09:54|        0.      -          0           0.           0.           0.                       \n",
    "     48    85374570.4   85375047.8       0.0005591  00:10:08|        0.      -          0           0.           0.           0.                       \n",
    "   X----X------------X------------X----------------X--------|----------X------------X-------X------------X------------X------------X\n",
    "\n",
    "   TEMPO DE CPU PARA POLITICA 00:10:14\n",
]

MockRelatorioOperacaoCustos = [
    "   RELATORIO  DA  OPERACAO                                                                                                                                                                              \n",
    "                                                                                                                                                                                                        \n",
    "   MARCO     / SEMANA 1 - ESTAGIO  1 /  CENARIO   1 - PROB ACUMUL: 1.000000 PROB SUBPROB: 1.000000                                                                                                      \n",
    "                                                                                                                                                                                                        \n",
    "                                                                                                                                                                                                        \n",
    "   Valor  esperado  do  custo  futuro:                  408096349.11 (1000 $)                                                                                                                           \n",
    "                                                                                                                                                                                                        \n",
    "   Custo total de operacao no estagio:                     126483.42 (1000 $)                                                                                                                           \n",
    "   Custo total de operacao no estagio:                     126483.42 (1000 $) (Atualizado para valor presente)                                                                                          \n",
    "                                                                                                                                                                                                        \n",
    "   Parcela referente a geracao termica        minima:       62421.07 (1000 $)                                                                                                                           \n",
    "                                              total :      126469.80 (1000 $)                                                                                                                           \n",
    "   Parcela referente a contrato de importacao minimo:           0.00 (1000 $)                                                                                                                           \n",
    "                                              total :           0.00 (1000 $)                                                                                                                           \n",
    "   Parcela referente a contrato de exportacao minimo:           0.00 (1000 $)                                                                                                                           \n",
    "                                              total :           0.00 (1000 $)                                                                                                                           \n",
    "   Parcela referente a nao atendimento do desvio:               0.00 (1000 $)                                                                                                                           \n",
    "   Parcela referente a vertimento em reservatorio:              0.13 (1000 $)                                                                                                                           \n",
    "   Parcela referente a vertimento em usinas fio dagua           1.95 (1000 $)                                                                                                                           \n",
    "   Parcela referente a turbinamento em reservatorio:            3.34 (1000 $)                                                                                                                           \n",
    "   Parcela referente a turbinamento em usinas fio dag           7.90 (1000 $)                                                                                                                           \n",
    "   Parcela referente a intercambio entre subsistemas:       0.29E+00 (1000 $)                                                                                                                           \n",
    "                                                                                                                                                                                                        \n",
    "   Custo marginal de operacao do subsistema SE:                 0.00 ($/MWh)                                                                                                                            \n",
    "   Custo marginal de operacao do subsistema S :               355.15 ($/MWh)                                                                                                                            \n",
    "   Custo marginal de operacao do subsistema NE:                 0.00 ($/MWh)                                                                                                                            \n",
    "   Custo marginal de operacao do subsistema N :                 0.00 ($/MWh)                                                                                                                            \n",
    "   Custo marginal de operacao do subsistema FC:                 0.00 ($/MWh)                                                                                                                            \n",
    "                                                                                                                                                                                                        \n",
]

MockRelatorioOperacaoUHE = [
    "   RELATORIO  DA  OPERACAO                                                                                                                                                                              \n",
    "\n",
    "   MARCO     / SEMANA 1 - ESTAGIO  1 /  CENARIO   1 - PROB ACUMUL: 1.000000 PROB SUBPROB: 1.000000                                                                                                      \n",
    "\n",
    "      # Aproveitamento(s) com evaporacao                                                                                                                                                                \n",
    "      * Aproveitamento(s) com tempo de viagem da afluencia                                                                                                                                              \n",
    "      @ Aproveitamento(s) com cota abaixo da crista do vert.                                                                                                                                            \n",
    "      $ Aproveitamento(s) de cabeceira : def.minima = zero                                                                                                                                              \n",
    "   X----X-----------------X-----------------X----------------------------------X---------------------------------------------------------------X                                                        \n",
    "    No.       Usina       Volume (% V.U.)         Vazoes   (M3/S)                Energia (MWmed) - CGC Pdisp                                                                                            \n",
    "                           Ini.  Fin.  Esp.   Qnat   (  %MLT)   Qafl     Qdef    GER_1   GER_2   GER_3    Media   VT(*)   VNT    Ponta   FPCGC                                                          \n",
    "   X----X-----------------X-----X-----X-----X----------------X--------X--------X-------X-------X-------X-------X-------X-------X-------X-------X                                                        \n",
    "      1  CAMARGOS     #     25.3  24.9  55.1    98.0 (  39.8)     98.0    102.3    17.8    17.8    17.8    17.8     0.0     0.0    31.5     0.0                                                         \n",
    "      2  ITUTINGA     #                         98.0 (  39.8)    102.3    102.3    38.7    26.1    19.3    24.6     0.0     0.0    52.0     0.0                                                         \n",
    "      4  FUNIL-GRANDE #                        221.0 (  38.3)    225.3    224.6    90.5    90.5    70.8    79.4     0.2     0.0   180.0     0.0                                                         \n",
    "      6  FURNAS       #     13.2  12.6   7.2   617.0 (  35.7)    620.6    791.0   745.1   736.8   467.8   586.3     0.0     0.0  1108.0     0.0                                                         \n",
    "      7  M. DE MORAES #     36.2  40.8  20.0   698.0 (  36.2)    872.0    681.7   241.0   241.0   241.0   241.0     0.0     0.0   361.3     0.0                                                         \n",
    "      8  ESTREITO     #                        717.0 (  36.4)    700.7    700.4   549.2   549.2   259.6   385.5     0.1     0.0  1069.5     0.0                                                         \n",
    "      9  JAGUARA      #                        725.0 (  36.5)    708.4    708.3   419.3   317.4   216.8   279.9     0.0     0.0   424.0     0.0                                                         \n",
    "     10  IGARAPAVA    #                        747.0 (  36.7)    730.3    730.0   144.4   105.1   105.1   112.6     0.0     0.0   210.0     0.0                                                         \n",
    "     11  VOLTA GRANDE #                        797.0 (  37.1)    780.0    779.1   282.3   282.3   122.5   191.9     0.1     0.0   380.0     0.0                                                         \n",
    "     12  P. COLOMBIA  #                        897.0 (  37.0)    879.1    877.2   233.6   170.5   170.5   182.5     0.0     0.0   328.0     0.0                                                         \n",
    "     14  CACONDE      #@    38.0  38.2   9.9    34.0 (  35.4)     34.0     32.0    25.5    25.5    25.5    25.5     0.0     0.0    64.5     0.0                                                         \n",
    "     15  E. DA CUNHA  #                         56.0 (  35.9)     54.0     53.7    54.3    54.3    30.3    40.7     0.0     0.0   103.9     0.0                                                         \n",
    "     16  A.S.OLIVEIRA #                         57.0 (  35.8)     54.7     54.7    16.0    16.0     9.9    12.6     0.0     0.0    32.0     0.0                                                         \n",
    "     17  MARIMBONDO   #     23.1  28.2  38.2  1212.0 (  37.4)   1189.8    742.1   356.0   356.0   356.0   356.0     0.0     0.0  1040.9     0.0                                                         \n",
    "     18  A. VERMELHA  #     23.7  20.9  37.9  1571.0 (  43.4)   1101.1   1331.0   583.9   583.9   583.9   583.9     0.0     0.0  1207.1     0.0                                                         \n",
    "     20  BATALHA      #     20.1  20.2   0.0    51.0 (  27.3)     51.0     49.0    23.5    17.8    12.0    15.6     0.0     0.0    42.9     0.0                                                         \n",
    "     21  SERRA FACAO  #@    17.5  17.3   0.0    83.0 (  26.7)     81.0     93.3    60.6    60.6    50.0    54.6     0.0     0.0   164.0     0.0                                                         \n",
    "     24  EMBORCACAO   #@    12.8  13.3   4.6   221.0 (  25.3)    231.3    114.5   118.0   118.0   118.0   118.0     0.0     0.0   808.8     0.0                                                         \n",
    "     25  NOVA PONTE   #@    16.8  16.3   3.7   161.0 (  31.2)    161.0    246.6   211.1   211.1   211.1   211.1     0.0     0.0   437.9     0.0                                                         \n",
    "     26  MIRANDA      #     96.3 100.0   0.0   168.0 (  28.4)    253.6    244.4   292.8   203.5    85.4   153.7     0.0     0.0   408.0     0.0                                                         \n",
    "     27  CAPIM BRANC1 #     82.7 100.0   0.0   169.0 (  28.1)    245.4    241.7   167.3   167.3    85.7   121.2     0.1     0.0   240.0     0.0                                                         \n",
    "     28  CAPIM BRANC2 #                        171.0 (  27.4)    243.7    243.7   174.0   158.1    53.6   102.0     0.0     0.0   210.0     0.0                                                         \n",
    "     29  CORUMBA IV   #     23.0  15.6   0.0    63.0 (  29.7)     63.0    156.2   101.1   101.1    83.9    91.4     0.0     0.0   120.4     0.0                                                         \n",
    "    203  CORUMBA III  #     22.5  43.0   0.0    77.0 (  29.1)    170.2     80.8    41.4    41.4    18.2    28.3     0.0     0.0    91.7     0.0                                                         \n",
    "     30  CORUMBA I    #     30.5  34.6   0.0   205.0 (  27.9)    208.8    138.2    86.8    86.8    80.0    83.0     0.0     0.0   294.5     0.0                                                         \n",
    "     31  ITUMBIARA    #@    16.3  16.0  12.8   758.0 (  28.5)    657.4    709.9   551.2   551.2   373.2   450.5     0.0     0.0  1466.9     0.0                                                         \n",
    "     32  CACH.DOURADA #                        818.0 (  29.3)    769.9    769.3   341.9   212.4   177.3   217.2     0.2     0.0   588.3     0.0                                                         \n",
    "     33  SAO SIMAO    #     33.4  35.3  41.5  1599.0 (  39.9)   1550.3   1367.2   848.8   848.8   848.8   848.8     0.0     0.0  1568.9     0.0                                                         \n",
    "    262  SALTO        #  $                     201.0 (  83.4)    201.0    200.4   115.0   115.0    69.5    89.3     0.0     0.0   116.0     0.0                                                         \n",
    "    241  SLT VERDINHO #  $                     219.0 (  83.6)    218.4    218.2    92.5    92.5    72.9    81.4     0.0     0.0    93.0     0.0                                                         \n",
    "    290  ESPORA       #     25.0  28.9   0.0    79.0 (  98.8)     79.0     69.8    26.6    26.6    26.6    26.6     0.0     0.1    27.3     0.0                                                         \n",
    "    311  CACU         #     70.0  26.2   0.0   208.0 (  73.0)    208.0    230.5    64.9    64.9    48.9    55.9     0.0     0.0    62.9-    0.0                                                         \n",
    "    312  B. COQUEIROS #                        217.0 (  73.3)    239.5    239.3    87.7    87.7    67.1    76.1     0.0     0.0    89.1     0.0                                                         \n",
    "    315  FOZ R. CLARO #                        232.0 (  73.2)    254.3    254.4    68.3    68.3    54.7    60.6     0.0     0.0    68.4     0.0                                                         \n",
    "     34  I. SOLTEIRA  #     68.1  70.3  25.0  4557.0 (  51.8)   4097.7   3888.9  1830.7  1830.7  1299.3  1530.2     0.0     0.0  3444.0     0.0                                                         \n",
    "    118  BILLINGS     #     72.0  71.8   0.0    10.0 (  33.3)     10.0      0.0     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    119  HENRY BORDEN #                          0.0 (------)      6.0      6.0    33.9    33.9    33.9    33.9     0.0     0.0   868.9     0.0                                                         \n",
    "    109  PEDREIRA     #                         10.0 (  38.5)      0.0      0.0     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    117  GUARAPIRANGA #     70.4  69.7   0.0     8.0 (  40.0)      8.0      0.0     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    108  TRAICAO      #                         18.0 (  39.1)      0.0      0.0     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    107  EDGARD SOUZA #                         65.0 (  36.7)     47.0     71.6     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "     37  BARRA BONITA #     53.7  50.1  15.8   252.0 (  33.6)    258.6    359.0    75.2    63.5    60.1    63.8     0.0     0.0   114.0     0.0                                                         \n",
    "     38  A.S. LIMA    #                        293.0 (  35.2)    400.0    395.4    83.3    72.3    72.3    74.4     0.0     0.0   142.1     0.0                                                         \n",
    "     39  IBITINGA     #                        372.0 (  38.0)    474.4    470.3    87.6    87.6    87.6    87.6S    0.0     0.0   131.4     0.0                                                         \n",
    "     40  PROMISSAO    #     42.9  36.1  29.3   454.0 (  38.7)    552.3    785.7   200.2   200.2   129.1   160.0     0.0     0.0   256.2     0.0                                                         \n",
    "     42  NAVANHANDAVA #                        486.0 (  38.7)    817.7    814.6   345.2   260.7   174.6   228.1     0.0     0.0   347.4     0.0                                                         \n",
    "     43  TRES IRMAOS  #     65.8  70.3  25.0   540.0 (  41.1)    868.6    606.9   346.4   346.4   169.9   246.6     0.0     0.0   807.5     0.0                                                         \n",
    "     45  JUPIA        #                       5682.0 (  54.0)   5080.8   5077.1  1082.4  1082.4   764.6   902.7     0.5     0.0  1435.2     0.0                                                         \n",
    "    153  SAO DOMINGOS #  $                     246.0 ( 162.9)    246.0    245.6    25.6    25.6    25.6    25.6     0.0    46.4    45.5     0.0                                                         \n",
    "     46  P. PRIMAVERA #                       7298.0 (  63.9)   6692.7   6678.6  1165.3  1165.3  1165.3  1165.3     0.0     0.0  1431.4     0.0                                                         \n",
    "     47  A.A. LAYDNER #     28.8  25.5  13.7   150.0 (  45.0)    150.0    319.0    90.1    90.1    73.8    80.9     0.0     0.2    90.2     0.0                                                         \n",
    "     48  PIRAJU       #                        153.0 (  44.9)    322.0    321.7    78.2    78.2    68.6    72.8     0.0     0.0    80.0     0.0                                                         \n",
    "     49  CHAVANTES    #     22.4  22.2  19.3   214.0 (  41.2)    382.7    390.0   259.4   259.4   204.1   228.1     0.0     0.0   358.9     0.0                                                         \n",
    "    249  OURINHOS     #                        216.0 (  41.1)    392.0    391.9    43.6    39.4    33.9    37.1     0.0     0.0    44.1     0.0                                                         \n",
    "     50  L.N. GARCEZ  #                        266.0 (  39.5)    441.9    440.0    65.9    65.9    65.9    65.9     0.2     0.0    73.8     0.0                                                         \n",
    "     51  CANOAS II    #                        270.0 (  39.5)    444.0    443.5    71.9    71.9    47.1    57.9     0.0     0.0    69.1-    0.0                                                         \n",
    "     52  CANOAS I     #                        278.0 (  39.3)    451.5    450.8    82.4    82.4    56.9    68.0     0.0     0.0    82.5     0.0                                                         \n",
    "     57  MAUA         #     51.9  51.0   0.0   200.0 (  63.7)    200.0    209.5   346.5   318.7   129.9   217.2     0.1     0.0   349.9     0.0                                                         \n",
    "     61  CAPIVARA     #     35.5  35.6  16.1   652.0 (  42.1)    834.3    700.0   251.6   251.6   251.6   251.6     0.0     0.0   493.2     0.0                                                         \n",
    "     62  TAQUARUCU    #                        690.0 (  42.6)    738.0    854.7   259.3   259.3   138.2   190.8     0.1     0.0   525.0     0.0                                                         \n",
    "     63  ROSANA       #                        780.0 (  43.6)    944.7    941.8   182.9   182.9   176.9   179.5     0.1     0.0   354.0     0.0                                                         \n",
    "     66  ITAIPU       #      0.0 100.0   0.0 10604.0 (  71.1)  10146.4   7301.9 10330.7  7164.4  7164.4  7767.5     0.0     6.4 12962.7     0.0                                                         \n",
    "    120  JAGUARI      #     49.1  50.3   0.0    24.0 (  53.3)     24.0      4.0     2.1     2.1     2.1     2.1     0.0     0.0    27.6     0.0                                                         \n",
    "    121  PARAIBUNA    #@    31.3  32.0   0.0    75.0 (  70.8)     75.0     44.9    42.1    42.1    21.3    30.3     0.0     0.0    79.2     0.0                                                         \n",
    "    122  SANTA BRANCA #     43.3  48.7   7.9    87.0 (  72.5)     56.9     30.0    10.7    10.7    10.7    10.7     0.0     0.0    42.1     0.0                                                         \n",
    "    123  FUNIL        #     41.5  55.2  42.9   317.0 (  84.3)    240.0     96.6    80.2    66.4    39.2    53.7     0.0     0.0   172.6     0.0                                                         \n",
    "    125  STA CECILIA  #                        416.0 (  84.4)    195.6     71.0     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    126  PICADA       #  $                      53.0 (  84.1)     53.0     52.9    49.9    49.9    49.9    49.9     0.0    11.3    49.2-    0.0                                                         \n",
    "    127  SOBRAGI      #  $                     115.0 (  91.3)    114.9    114.2    59.7    59.7    59.7    59.7     0.0    21.7    60.0     0.0                                                         \n",
    "    180  TOCOS        #  $                      12.0 (  50.0)     12.0      0.0     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    181  SANTANA      #                         18.0 (  45.0)    130.0     10.0     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    129  SIMPLICIO    #                        864.0 (  90.7)    510.2    419.5   272.2   272.2   272.2   272.2     0.0   113.9   275.6     0.0                                                         \n",
    "    130  ILHA POMBOS  #                        929.0 (  87.3)    484.5    574.3   178.1   178.1   143.0   158.3     0.0     0.0   187.2     0.0                                                         \n",
    "    182  VIGARIO      #                          0.0 (------)    120.0    120.0     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    131  NILO PECANHA #                          0.0 (------)    120.0    120.0   378.7   378.7   267.7   315.9     0.0     0.0   378.7     0.0                                                         \n",
    "    124  LAJES        #     83.8  85.4   0.0     5.0 (  50.0)     17.0      5.5     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    183  FONTES A     #                          5.0 (------)      5.5      5.5    12.3    12.3    12.3    12.3     0.0     1.6    44.0     0.0                                                         \n",
    "    184  FONTES BC    #                          0.0 (------)      0.0      0.0     0.0     0.0     0.0     0.0     0.0     0.0    88.0     0.0                                                         \n",
    "    133  P. PASSOS    #                          5.0 (------)    125.5    120.0    38.3    38.3    38.3    38.3     0.1     0.0    95.8     0.0                                                         \n",
    "    134  SALTO GRANDE #  $                     104.0 (  36.1)    104.0    103.9   101.3   101.3    63.6    80.0     0.0     0.0   101.5     0.0                                                         \n",
    "    135  P. ESTRELA   #     37.6 100.0   0.0   109.0 (  36.3)    108.9     74.9    62.1    57.7     7.7    30.3     0.7     0.0    99.1     0.0                                                         \n",
    "    139  CANDONGA     #  $                     119.0 (  45.1)    119.0    118.3     0.0     0.0     0.0     0.0     0.0    49.4   124.1     0.0                                                         \n",
    "    192  GUILMAN-AMOR #  $                      69.0 (  46.6)     69.0     68.4   138.8   138.8    17.2    70.1     0.0     0.0   138.6-    0.0                                                         \n",
    "    193  SA CARVALHO  #  $                      76.0 (  46.9)     75.4     75.4    76.3    76.3    64.8    69.8     0.0     0.0    77.8     0.0                                                         \n",
    "    141  BAGUARI      #                        318.0 (  31.3)    282.7    280.8    70.5    57.0    36.0    47.7     0.0     0.0   140.0     0.0                                                         \n",
    "    143  AIMORES      #                        492.0 (  31.6)    454.8    438.0   160.5   137.9    81.8   110.5     0.1     0.0   322.7     0.0                                                         \n",
    "    144  MASCARENHAS  #                        573.0 (  31.6)    519.0    534.3   127.6   100.4   100.4   105.5     0.1     0.0   198.0     0.0                                                         \n",
    "    195  JAURU        #  $                      85.0 (  87.6)     85.0     84.9   117.5   117.5    49.1    78.8     0.0     0.0   118.0     0.0                                                         \n",
    "    217  ROSAL        #  $                      50.0 (  82.0)     50.0     49.9    54.5    54.5    54.5    54.5     0.0    29.6    55.0     0.0                                                         \n",
    "    278  MANSO        #     52.6  51.9   0.0   159.0 (  52.5)    159.0    186.7   121.5   121.5    73.5    94.4     0.0     0.0   196.5     0.0                                                         \n",
    "    281  PONTE PEDRA  #  $                      87.0 ( 101.2)     87.0     86.8   170.7   170.7   170.7   170.7     0.0    20.4   176.0     0.0                                                         \n",
    "    283  STA CLARA MG #  $                      19.0 (  11.2)     19.0     18.5    14.6    11.1     5.0     8.3     0.0     0.0    59.1     0.0                                                         \n",
    "    304  ITIQUIRA I   #  $                      80.0 (  79.2)     80.0     79.8    60.8    60.8    60.8    60.8S    0.0     0.6    60.8     0.0                                                         \n",
    "    305  ITIQUIRA II  #  $                      80.0 (------)     79.8     79.8    95.8    95.8    95.8    95.8     0.0     1.9    96.6     0.0                                                         \n",
    "    196  GUAPORE      #  $                      39.0 ( 108.3)     39.0     39.0   119.3   119.3    14.2    59.9     0.0     0.0   120.0     0.0                                                         \n",
    "    285  JIRAU        #  $                   22917.0 (  97.1)  22917.0  22867.8  3750.0  3750.0  3295.4  3492.9    12.1     0.0  3750.0-    0.0                                                         \n",
    "    287  STO ANTONIO  #  $                   23267.0 (  97.2)  23217.8  23226.7  3184.2  3184.2  3097.3  3135.1    11.3     5.9  3458.4     0.0                                                         \n",
    "    276  RONDON II    #@    30.1  25.1   0.0   102.0 (  87.2)    102.0    125.3    70.1    70.1    60.8    64.8     0.0     0.0    69.8-    0.0                                                         \n",
    "    279  SAMUEL       #     18.9  26.7   0.0   605.0 ( 125.5)    605.0    274.2    80.8    80.8    61.2    69.8     0.0     0.0   163.2     0.0                                                         \n",
    "    310  DARDANELOS   #  $                     468.0 (  94.5)    468.0    467.8   259.5   259.5   259.5   259.5     0.0   146.5   261.0     0.0                                                         \n",
    "    227  SINOP        #     50.0  29.8   0.0  1073.0 (  74.9)   1073.0   1752.4   353.0   353.0   353.0   353.0     0.0    42.6   297.4-    0.0                                                         \n",
    "    228  COLIDER      #                       1166.0 (  74.5)   1845.4   1834.6   257.1   257.1   257.1   257.1S    0.0   610.3   263.8     0.0                                                         \n",
    "    229  TELES PIRES  #                       2524.0 (  68.9)   3192.6   3189.5  1809.1  1809.1  1402.9  1579.4     0.2     0.0  1820.0     0.0                                                         \n",
    "    230  SAO MANOEL   #                       2547.0 (  68.9)   3212.5   3212.3   690.0   690.0   690.0   690.0     0.0     0.0   700.0     0.0                                                         \n",
    "     71  STA CLARA PR #     51.3  47.4   0.0    42.0 (  44.7)     42.0     51.8    42.2    42.2    42.2    42.2     0.0     0.0   120.2     0.0                                                         \n",
    "     72  FUNDAO       #                         45.0 (  45.5)     54.8     54.3   118.7    63.9    11.6    44.7     0.0     0.0   120.2     0.0                                                         \n",
    "     73  JORDAO       #@   100.0 100.0   0.0    56.0 (  47.9)     65.3     10.0     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "     74  G.B. MUNHOZ  #@    20.8  17.2   0.0   253.0 (  40.5)    253.0    470.6   547.1   547.1   413.4   471.5     0.0     0.0  1117.6     0.0                                                         \n",
    "     76  SEGREDO      #     35.4  77.6   0.0   308.0 (  43.0)    587.8    316.5   320.2   320.2   320.2   320.2     0.1     0.0  1260.0     0.0                                                         \n",
    "     77  SLT.SANTIAGO #     19.0  18.0   0.0   393.0 (  42.3)    355.5    419.5   492.9   412.1   276.0   350.5     0.0     0.0  1125.4     0.0                                                         \n",
    "     78  SALTO OSORIO #                        404.0 (  41.7)    430.5    430.3   279.8   279.8   265.2   271.6     0.1     0.0  1078.0     0.0                                                         \n",
    "     82  SALTO CAXIAS #                        476.0 (  39.6)    502.3    501.0   882.6   209.0   113.0   283.0     0.0     0.0  1212.4     0.0                                                         \n",
    "     83  BAIXO IGUACU #                        570.0 (  43.8)    595.0    594.6   350.2   350.2   350.2   350.2S    0.0     0.0   350.2-    0.0                                                         \n",
    "     86  BARRA GRANDE #@    19.3  16.1   0.0    45.0 (  24.1)     45.0    161.4   299.4   299.4   150.5   215.2     0.0     0.0   628.1     0.0                                                         \n",
    "     89  GARIBALDI    #     53.3  24.9   0.0    65.0 (  29.7)     65.0     94.0    36.4    36.4    36.4    36.4     0.1     0.0   185.6     0.0                                                         \n",
    "     90  CAMPOS NOVOS #     50.9  69.2   0.0    71.0 (  30.0)    100.0     53.2   164.0   164.0    27.8    87.0     0.0     0.0   880.0     0.0                                                         \n",
    "     91  MACHADINHO   #     17.8  17.1   0.0   174.0 (  33.7)    272.6    284.0   239.5   239.5   239.5   239.5     0.0     0.0  1046.2     0.0                                                         \n",
    "     92  ITA          #                        245.0 (  34.9)    355.0    356.2   622.0   363.5   210.9   326.5     0.1     0.0  1446.7     0.0                                                         \n",
    "     93  PASSO FUNDO  #@    29.6  30.1   0.0    11.0 (  30.6)     11.0      1.0I    2.2     2.2     2.2     2.2     0.0     0.0   225.2     0.0                                                         \n",
    "     94  MONJOLINHO   #                         19.0 (  30.6)      9.0      8.9    21.5     1.1     1.1     5.0     0.0     0.0    74.0     0.0                                                         \n",
    "     95  QUEBRA QUEIX #     65.7 100.0   0.0    34.0 (  58.6)     34.0     19.2    54.6    37.2     0.5    19.8     0.0     0.0   120.0     0.0                                                         \n",
    "     97  CASTRO ALVES #  $                      48.0 (  50.0)     48.0     47.3   118.8    54.4     0.0    35.9     0.0     0.0   118.2-    0.0                                                         \n",
    "     98  MONTE CLARO  #  $                      91.0 (  55.5)     90.3     89.0    31.7    31.7    29.9    30.7     0.0     0.0   125.0     0.0                                                         \n",
    "     99  14 DE JULHO  #  $                      94.0 (  55.6)     92.0     91.5    38.6    25.9    25.9    28.4     0.0     0.0   100.0     0.0                                                         \n",
    "    101  SAO JOSE     #  $                     105.0 (  62.9)    105.0    103.2    32.9    25.6    13.0    19.9     0.0     0.0    51.0     0.0                                                         \n",
    "    102  PASSO S JOAO #  $                     109.0 (  62.6)    107.2    107.1    39.8    39.2    19.8    28.3     0.0     0.0    77.0     0.0                                                         \n",
    "    103  FOZ CHAPECO  #                        330.0 (  38.7)    431.2    357.5   229.2   217.6   119.2   164.2     0.4     0.0   855.0     0.0                                                         \n",
    "    110  ERNESTINA    #@    99.6   0.0   0.0    16.0 (  72.7)     16.0    408.1     0.0     0.0     0.0     0.0S    0.0     0.0     0.0     0.0                                                         \n",
    "    111  PASSO REAL   #     74.5  80.8  11.0   112.0 (  80.0)    504.1    161.3    84.9    84.9    54.6    67.7     0.0     0.0   158.0     0.0                                                         \n",
    "    112  JACUI        #                        113.0 (  79.6)    162.3    162.3   180.0   180.0    90.9   129.6     0.0     0.0   180.0     0.0                                                         \n",
    "    113  ITAUBA       #                        140.0 (  80.0)    189.3    189.3   477.8    75.0    75.0   151.7     0.0     0.0   483.5     0.0                                                         \n",
    "    114  D. FRANCISCA #                        169.0 (  79.3)    218.3    218.2    93.4    93.4    57.8    73.2     0.0     0.0   123.8     0.0                                                         \n",
    "    115  G.P. SOUZA   #     23.8  26.9   0.0    15.0 (  57.7)     15.0      7.0I   44.4    44.4    44.4    44.4     0.0     0.0   260.0     0.0                                                         \n",
    "    148  IRAPE        #     22.9  22.9  11.9    46.0 (  13.8)     46.0     50.9   129.0    86.5    43.7    70.4     0.0     0.0   335.3     0.0                                                         \n",
    "    154  ITAPEBI      #                        108.0 (  13.6)    112.9    112.4   192.9   115.8    27.3    80.4     0.2     0.0   462.0     0.0                                                         \n",
    "    155  RETIRO BAIXO #     52.4 100.0   0.0    64.0 (  20.1)     64.0     30.7    14.2     9.0     9.0    10.0     0.1     0.0    80.2     0.0                                                         \n",
    "    156  TRES MARIAS  #     57.0  57.5  23.6   468.0 (  33.0)    434.7    300.0   135.7   135.7   135.7   135.7     0.0     0.0   377.3     0.0                                                         \n",
    "    162  QUEIMADO     #@    27.8  26.4  28.2    13.0 (  16.2)     13.0     22.6    50.6    50.6    25.5    36.4     0.0     0.0   105.0     0.0                                                         \n",
    "    169  SOBRADINHO  *#     28.8  27.8  22.2  1204.0 (  38.0)   1033.4   1313.2   325.9   325.9   260.7   289.0     0.0     0.0   775.7     0.0                                                         \n",
    "    172  ITAPARICA    #     37.5  43.7  38.5  1204.0 (  26.3)   1313.2    818.4   808.6   412.4   180.0   356.5     0.0     0.0  1402.9     0.0                                                         \n",
    "    173  MOXOTO       #                       1204.0 (  26.3)    818.4      0.4     0.4     0.0     0.0     0.1     0.1     0.0   400.0     0.0                                                         \n",
    "    174  P.AFONSO 123 #                       1204.0 (  26.3)      0.4      0.0     0.0     0.0     0.0     0.0     0.0     0.0  1417.2     0.0                                                         \n",
    "    175  P.AFONSO 4   #                          0.0 (------)    810.3    804.1  1335.2  1215.9   480.0   822.5     0.2     0.0  2462.4     0.0                                                         \n",
    "    178  XINGO        #                       1204.0 (  26.3)    804.1    800.0   880.7   880.7   880.7   880.7     0.8     0.0  3162.0     0.0                                                         \n",
    "    189  P. CAVALO    #     78.1  69.1   0.0     8.0 (   5.1)      8.0    142.4   146.0   146.0   121.9   132.4     0.3     0.0   160.0     0.0                                                         \n",
    "    190  B. ESPERANCA #     18.4  17.9  34.5   232.0 (  36.2)    232.0    240.0    85.4    85.4    85.4    85.4     0.0     0.0   204.7     0.0                                                         \n",
    "    204  CACH.CALDEIR #  $                     763.0 ( 144.5)    763.0    762.1   164.9   164.9    64.1   107.9     0.0     0.0   219.0     0.0                                                         \n",
    "    215  SALTO PILAO  #  $                      80.0 (  69.0)     80.0     79.8   191.9   191.9   104.4   142.4     0.0     0.0   191.9-    0.0                                                         \n",
    "    251  SERRA MESA   #      9.4   8.8   0.0   203.0 (  14.6)    203.0    661.3   665.7   665.7   443.4   540.0     0.0     0.0   834.7     0.0                                                         \n",
    "    252  CANA BRAVA   #                        236.0 (  15.2)    694.3    692.6   325.8   325.8   219.7   265.8     0.0     0.0   441.4     0.0                                                         \n",
    "    253  SAO SALVADOR #                        277.0 (  16.2)    733.6    732.2   186.1   186.1   139.4   159.7     0.1     0.0   243.2     0.0                                                         \n",
    "    257  PEIXE ANGIC  #     18.2   5.0   0.0   507.0 (  16.7)    962.2   1073.4   268.8   256.7   235.2   246.8     0.0     0.0   458.3     0.0                                                         \n",
    "    261  LAJEADO      #                        904.0 (  20.9)   1470.4   1465.5   460.0   460.0   460.0   460.0     0.0     0.0   902.5     0.0                                                         \n",
    "    267  ESTREITO TOC #                       1427.0 (  21.2)   1988.5   1984.6   555.8   555.8   315.3   419.8     0.6     0.0  1052.9     0.0                                                         \n",
    "    272  CURUA-UNA    #     22.3  30.2   0.0   129.0 (  90.2)    129.0     67.1    13.2    13.2     8.9    10.8     0.0     0.0    25.6     0.0                                                         \n",
    "    275  TUCURUI      #     17.3  19.8   0.0  4245.0 (  28.6)   4802.6   3112.1  1583.6  1583.6  1583.6  1583.6     0.0     0.0  2892.3     0.0                                                         \n",
    "    277  BALBINA      #     24.6  27.1   0.0  1005.0 ( 258.4)   1005.0    551.2   123.8   123.8    94.2   107.1     0.0     0.0   219.3     0.0                                                         \n",
    "    280  COARACY NUNE #  $                     763.0 ( 144.2)    762.1    761.5    69.1    69.1    69.1    69.1     0.0    67.0    69.6     0.0                                                         \n",
    "    284  FERREIRA GOM #  $                     770.0 ( 144.5)    768.5    768.2   134.6   120.5   120.5   123.2     0.0     0.0   252.0     0.0                                                         \n",
    "    286  STO ANT JARI #  $                     602.0 (  89.1)    602.0    600.6   186.8   186.8   106.4   141.3     0.2     0.0   389.6     0.0                                                         \n",
    "    288  BELO MONTE   #  $                       0.0 (------)   2767.3   2757.6  5619.6  4892.3     0.0  2264.4     1.0     0.0 11000.0     0.0                                                         \n",
    "    314  PIMENTAL     #  $                    3753.0 (  46.8)   3753.0    985.7   125.1   124.2   122.4   123.3     0.0     0.0   233.1     0.0                                                         \n",
    "      1  STA CECILIA                                                      124.0     0.0   -27.5   -32.0   -24.8                                                                                         \n",
    "      2  VIGARIO                                                          120.0     0.0   -22.6   -83.6   -52.8                                                                                         \n",
    "      3  TRAICAO                                                            0.0     0.0     0.0     0.0     0.0                                                                                         \n",
    "      4  PEDREIRA                                                           0.0     0.0     0.0     0.0     0.0                                                                                         \n",
    "   X----X-----------------X-----X-----X-----X----------------X--------X--------X-------X-------X-------X-------X-------X-------X-------X-------X                                                        \n",
    "    Total no subsistema SE                                                     39569.2 35680.8 30497.5 33490.4    26.7  1108.9 55793.9                                                                  \n",
    "    Total no subsistema S                                                       6383.1  4750.7  3225.6  4199.2     1.0     0.0 14063.1                                                                  \n",
    "    Total no subsistema NE                                                      3775.1  3182.2  2036.0  2647.0     1.6     0.0 10446.9                                                                  \n",
    "    Total no subsistema N                                                       8576.5  7834.2  2484.5  4950.4     1.9    67.0 16353.4                                                                  \n",
    "    Total no subsistema FC                                                         0.0     0.0     0.0     0.0     0.0     0.0     0.0                                                                  \n",
]

MockRelatorioOperacaoUTE = [
    "   RELATORIO  DA  OPERACAO  TERMICA E CONTRATOS                                                                                                                                                         \n",
    "                                                                                                                                                                                                        \n",
    "   MARCO     / SEMANA 1 - ESTAGIO  1 /  CENARIO   1 - PROB ACUMUL: 1.000000 PROB SUBPROB: 1.000000                                                                                                      \n",
    "                                                                                                                                                                                                        \n",
    "   X-----------------------------------------------------------------------X                                                                                                                            \n",
    "     Sis    Usina /   Fpcgc   Ene_pat_1   Ene_pat_2   Ene_pat_3     Custo                                                                                                                               \n",
    "           Contrato    (%)     (MWmed)     (MWmed)     (MWmed)     (1000 $)                                                                                                                             \n",
    "   X---X-----------X-------X-----------X-----------X-----------X-----------X                                                                                                                            \n",
    "    SE  SANTA CRUZ              350.00*     350.00*     350.00*     6099.91                                                                                                                             \n",
    "    SE  LUIZORMELO              196.00*     196.00*     196.00*     4985.96                                                                                                                             \n",
    "    SE  ANGRA 2                1350.00I    1350.00I    1350.00I     4563.22                                                                                                                             \n",
    "    SE  TERMORIO                115.00I     115.00I     115.00I     5148.97                                                                                                                             \n",
    "    SE  ATLAN_CSA               141.30I     141.30I     141.30I        0.00                                                                                                                             \n",
    "    SE  CUBATAO                  45.00I      45.00I      45.00I     2474.77                                                                                                                             \n",
    "    SE  NORTEFLU 1              400.00I     400.00I     400.00I     4527.94                                                                                                                             \n",
    "    SE  NORTEFLU 2              100.00I     100.00I     100.00I     1317.79                                                                                                                             \n",
    "    SE  NORTEFLU 3              200.00I     200.00I     200.00I     5022.19                                                                                                                             \n",
    "    SE  ATLANTICO               218.70I     218.70I     218.70I     6930.20                                                                                                                             \n",
    "   X---X-----------X-------X-----------X-----------X-----------X-----------X                                                                                                                            \n",
    "         T o t a l  Termica     3116.00     3116.00     3116.00    41070.95                                                                                                                             \n",
    "                    Deficit        0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Compra         0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Venda          0.00        0.00        0.00        0.00                                                                                                                             \n",
    "   X-----------------------------------------------------------------------X                                                                                                                            \n",
    "     Sis    Usina /   Fpcgc   Ene_pat_1   Ene_pat_2   Ene_pat_3     Custo                                                                                                                               \n",
    "           Contrato    (%)     (MWmed)     (MWmed)     (MWmed)     (1000 $)                                                                                                                             \n",
    "   X---X-----------X-------X-----------X-----------X-----------X-----------X                                                                                                                            \n",
    "    S   J.LACER. C              363.00S     363.00S     180.00      8902.26                                                                                                                             \n",
    "    S   J.LACER. B              262.00S     262.00S     160.00      8132.93                                                                                                                             \n",
    "    S   J.LAC. A1               100.00S     100.00S       0.00      2192.74                                                                                                                             \n",
    "    S   J.LAC. A2               132.00S     132.00S      33.00      3308.55                                                                                                                             \n",
    "    S   ARAUCARIA               480.00S     480.00S       0.00     28144.29                                                                                                                             \n",
    "    S   CANOAS                   80.79        0.00        0.00      2255.99                                                                                                                             \n",
    "    S   CANDIOTA_3              310.00I     310.00I     310.00I     4417.43                                                                                                                             \n",
    "    S   MADEIRA                   3.00S       3.00S       2.00I      128.02                                                                                                                             \n",
    "   X---X-----------X-------X-----------X-----------X-----------X-----------X                                                                                                                            \n",
    "         T o t a l  Termica     1730.79     1650.00      685.00    57482.21                                                                                                                             \n",
    "                    Deficit        0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Compra         0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Venda          0.00        0.00        0.00        0.00                                                                                                                             \n",
    "   X-----------------------------------------------------------------------X                                                                                                                            \n",
    "     Sis    Usina /   Fpcgc   Ene_pat_1   Ene_pat_2   Ene_pat_3     Custo                                                                                                                               \n",
    "           Contrato    (%)     (MWmed)     (MWmed)     (MWmed)     (1000 $)                                                                                                                             \n",
    "   X---X-----------X-------X-----------X-----------X-----------X-----------X                                                                                                                            \n",
    "    NE  T.BAHIA                 110.00I     110.00I     110.00I     4658.62                                                                                                                             \n",
    "    NE  VALE ACU                155.00I     155.00I     155.00I     6609.21                                                                                                                             \n",
    "    NE  TERMOPE                 532.70I     532.70I     532.70I    12427.08                                                                                                                             \n",
    "    NE  SYKUE I                  10.00I      10.00I      10.00I      857.00                                                                                                                             \n",
    "   X---X-----------X-------X-----------X-----------X-----------X-----------X                                                                                                                            \n",
    "         T o t a l  Termica      807.70      807.70      807.70    24551.92                                                                                                                             \n",
    "                    Deficit        0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Compra         0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Venda          0.00        0.00        0.00        0.00                                                                                                                             \n",
    "   X-----------------------------------------------------------------------X                                                                                                                            \n",
    "     Sis    Usina /   Fpcgc   Ene_pat_1   Ene_pat_2   Ene_pat_3     Custo                                                                                                                               \n",
    "           Contrato    (%)     (MWmed)     (MWmed)     (MWmed)     (1000 $)                                                                                                                             \n",
    "   X---X-----------X-------X-----------X-----------X-----------X-----------X                                                                                                                            \n",
    "    N   UTE MAUA 3              264.00I     264.00I     264.00I     2620.32                                                                                                                             \n",
    "    N   APARECIDA                75.00I      75.00I      75.00I      744.41                                                                                                                             \n",
    "    N   C. ROCHA                 65.00I      65.00I      65.00I        0.00                                                                                                                             \n",
    "    N   JARAQUI                  63.00I      63.00I      63.00I        0.00                                                                                                                             \n",
    "    N   MANAUARA                 64.50I      64.50I      64.50I        0.00                                                                                                                             \n",
    "    N   PONTA NEGR               64.00I      64.00I      64.00I        0.00                                                                                                                             \n",
    "    N   TAMBAQUI                 63.00I      63.00I      63.00I        0.00                                                                                                                             \n",
    "   X---X-----------X-------X-----------X-----------X-----------X-----------X                                                                                                                            \n",
    "         T o t a l  Termica      658.50      658.50      658.50     3364.72                                                                                                                             \n",
    "                    Deficit        0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Compra         0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Venda          0.00        0.00        0.00        0.00                                                                                                                             \n",
    "   X-----------------------------------------------------------------------X                                                                                                                            \n",
    "     Sis    Usina /   Fpcgc   Ene_pat_1   Ene_pat_2   Ene_pat_3     Custo                                                                                                                               \n",
    "           Contrato    (%)     (MWmed)     (MWmed)     (MWmed)     (1000 $)                                                                                                                             \n",
    "   X---X-----------X-------X-----------X-----------X-----------X-----------X                                                                                                                            \n",
    "         T o t a l  Termica        0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Deficit        0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Compra         0.00        0.00        0.00        0.00                                                                                                                             \n",
    "                    Venda          0.00        0.00        0.00        0.00                                                                                                                             \n",
    "* - Usina termica GNL com despacho definido anteriormente.                                                                                                                                              \n",
    "                                                                                                                                                                                                        \n",
    "   RELATORIO  DO  BALANCO  ENERGETICO                                                                                                                                                                   \n",
]

MockBalancoEnergetico = [
    "   RELATORIO  DO  BALANCO  ENERGETICO                                                                                                                                                                   \n",
    "                                                                                                                                                                                                        \n",
    "   JANEIRO   / SEMANA 1 - ESTAGIO  1 /  CENARIO   1 - PROB ACUMUL: 1.000000 PROB SUBPROB: 1.000000                                                                                                      \n",
    "                                                                                                                                                                                                        \n",
    "                                                                                                                                                                                                        \n",
    "     Subsistema SE                                                                                                                                                                                      \n",
    "     EAR_ini:  41766. (Mwmes)   ENA:  36314. (MWmed)   EAR_fim:  42365. (MWmes)                                                                                                                         \n",
    "                 20.4 (%EARM)           17.8 (%EARM)               20.7 (%EARM)                                                                                                                         \n",
    "   X--------------------------------------------------------------------------------------------------------------X                                                                                     \n",
    "          Mercado  Bacia  Cbomba   Ghid    Gter   GterAT  Deficit  Compra  Venda   Interligacao Itaipu50 Itaipu60                                                                                       \n",
    "          (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed)    (MWmed)    (MWmed)# (MWmed)                                                                                                \n",
    "   X--------------------------------------------------------------------------------------------------------------X                                                                                     \n",
    "    Pat_1 45078.0  3374.0     0.0 34768.3  4576.3   554.0     0.0     0.0     0.0  SE:  4984.4    5529.8  4800.9                                                                                        \n",
    "                                                                                   NE:     0.0                                                                                                          \n",
    "                                                                                   N : -4984.4                                                                                                          \n",
    "                                                                                   FC:     0.0                                                                                                          \n",
    "                                                                                   IV:     0.0                                                                                                          \n",
    "    Pat_2 41680.0  3374.0    50.1 32934.4  4580.6   554.0     0.0     0.0     0.0  SE:  2805.1    4418.0  2746.4                                                                                        \n",
    "                                                                                   NE:     0.0                                                                                                          \n",
    "                                                                                   N : -4569.9                                                                                                          \n",
    "                                                                                   FC:     0.0                                                                                                          \n",
    "                                                                                   IV:  1764.9                                                                                                          \n",
    "    Pat_3 33894.0  3374.0   115.6 27227.1  4492.3   554.0     0.0     0.0     0.0  SE:   -63.8    3894.0  3270.4                                                                                        \n",
    "                                                                                   NE:    63.8                                                                                                          \n",
    "                                                                                   N :     0.0                                                                                                          \n",
    "                                                                                   FC:     0.0                                                                                                          \n",
    "                                                                                   IV:     0.0                                                                                                          \n",
    "   X--------------------------------------------------------------------------------------------------------------X                                                                                     \n",
    "    Medio 37924.4  3374.0    77.6 30056.3  4529.8   554.0     0.0     0.0     0.0  SE:  1597.9*   4333.5  3434.1                                                                                        \n",
    "                                                                                   NE:    36.1                                                                                                          \n",
    "                                                                                   N : -2064.7                                                                                                          \n",
    "                                                                                   FC:     0.0                                                                                                          \n",
    "                                                                                   IV:   430.7                                                                                                          \n",
    "                                                                                                                                                                                                        \n",
    "   (*) total da energia importada(+)/exportada(-) no susbsitema: SE                                                                                                                                     \n",
    "                                                                                                                                                                                                        \n",
    "   (#) Total da energia Itaipu50 ( G50 -> SE + carga da Ande no centro de gravidade)                                                                                                                    \n",
    "                                                                                                                                                                                                        \n",
    "     Subsistema S                                                                                                                                                                                       \n",
    "     EAR_ini:   6088. (Mwmes)   ENA:   3111. (MWmed)   EAR_fim:   5949. (MWmes)                                                                                                                         \n",
    "                 30.6 (%EARM)           15.6 (%EARM)               29.9 (%EARM)                                                                                                                         \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "          Mercado  Bacia  Cbomba   Ghid    Gter   GterAT  Deficit  Compra  Venda   Interligacao                                                                                                         \n",
    "          (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed)    (MWmed)                                                                                                            \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "    Pat_1 14425.0  2065.0     0.0  6383.1  1176.0     0.0     0.0     0.0     0.0  S :  4800.9                                                                                                          \n",
    "                                                                                   IV: -4800.9                                                                                                          \n",
    "    Pat_2 12503.0  2065.0     0.0  4750.7  1176.0     0.0     0.0     0.0     0.0  S :  4511.3                                                                                                          \n",
    "                                                                                   IV: -4511.3                                                                                                          \n",
    "    Pat_3  9737.0  2065.0     0.0  3225.6  1176.0     0.0     0.0     0.0     0.0  S :  3270.4                                                                                                          \n",
    "                                                                                   IV: -3270.4                                                                                                          \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "    Medio 11305.0  2065.0     0.0  4199.2  1176.0     0.0     0.0     0.0     0.0  S :  3864.8*                                                                                                         \n",
    "                                                                                   IV: -3864.8                                                                                                          \n",
    "                                                                                                                                                                                                        \n",
    "   (*) total da energia importada(+)/exportada(-) no susbsitema: S                                                                                                                                      \n",
    "                                                                                                                                                                                                        \n",
    "     Subsistema NE                                                                                                                                                                                      \n",
    "     EAR_ini:  19405. (Mwmes)   ENA:   3421. (MWmed)   EAR_fim:  19392. (MWmes)                                                                                                                         \n",
    "                 37.6 (%EARM)            6.6 (%EARM)               37.6 (%EARM)                                                                                                                         \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "          Mercado  Bacia  Cbomba   Ghid    Gter   GterAT  Deficit  Compra  Venda   Interligacao                                                                                                         \n",
    "          (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed)    (MWmed)                                                                                                            \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "    Pat_1 12439.0  5662.0     0.0  3775.1  1938.1     0.0     0.0     0.0     0.0  NE:  1063.8                                                                                                          \n",
    "                                                                                   SE:     0.0                                                                                                          \n",
    "                                                                                   FC: -1063.8                                                                                                          \n",
    "    Pat_2 11677.0  5662.0     0.0  3182.2  1938.1     0.0     0.0     0.0     0.0  NE:   894.7                                                                                                          \n",
    "                                                                                   SE:     0.0                                                                                                          \n",
    "                                                                                   FC:  -894.7                                                                                                          \n",
    "    Pat_3 10230.0  5662.0     0.0  2036.0  1938.1     0.0     0.0     0.0     0.0  NE:   593.9                                                                                                          \n",
    "                                                                                   SE:   -63.8                                                                                                          \n",
    "                                                                                   FC:  -530.2                                                                                                          \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "    Medio 11003.9  5662.0     0.0  2647.0  1938.1     0.0     0.0     0.0     0.0  NE:   756.8*                                                                                                         \n",
    "                                                                                   SE:   -36.1                                                                                                          \n",
    "                                                                                   FC:  -720.8                                                                                                          \n",
    "                                                                                                                                                                                                        \n",
    "   (*) total da energia importada(+)/exportada(-) no susbsitema: NE                                                                                                                                     \n",
    "                                                                                                                                                                                                        \n",
    "     Subsistema N                                                                                                                                                                                       \n",
    "     EAR_ini:   2313. (Mwmes)   ENA:   3319. (MWmed)   EAR_fim:   2434. (MWmes)                                                                                                                         \n",
    "                 15.0 (%EARM)           21.6 (%EARM)               15.8 (%EARM)                                                                                                                         \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "          Mercado  Bacia  Cbomba   Ghid    Gter   GterAT  Deficit  Compra  Venda   Interligacao                                                                                                         \n",
    "          (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed)    (MWmed)                                                                                                            \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "    Pat_1  5847.0   567.0     0.0  8576.5  2751.7     0.0     0.0     0.0     0.0  N : -6048.2                                                                                                          \n",
    "                                                                                   SE:  4984.4                                                                                                          \n",
    "                                                                                   FC:  1063.8                                                                                                          \n",
    "    Pat_2  5740.0   567.0     0.0  7834.2  2803.5     0.0     0.0     0.0     0.0  N : -5464.7                                                                                                          \n",
    "                                                                                   SE:  4569.9                                                                                                          \n",
    "                                                                                   FC:   894.7                                                                                                          \n",
    "    Pat_3  5319.0   567.0     0.0  2484.5  2797.7     0.0     0.0     0.0     0.0  N :  -530.2                                                                                                          \n",
    "                                                                                   SE:     0.0                                                                                                          \n",
    "                                                                                   FC:   530.2                                                                                                          \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "    Medio  5522.3   567.0     0.0  4950.4  2790.4     0.0     0.0     0.0     0.0  N : -2785.5*                                                                                                         \n",
    "                                                                                   SE:  2064.7                                                                                                          \n",
    "                                                                                   FC:   720.8                                                                                                          \n",
    "                                                                                                                                                                                                        \n",
    "   (*) total da energia importada(+)/exportada(-) no susbsitema: N                                                                                                                                      \n",
    "                                                                                                                                                                                                        \n",
    "     Subsistema FC                                                                                                                                                                                      \n",
    "     EAR_ini:                                                                                                                                                                                           \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "          Mercado  Bacia  Cbomba   Ghid    Gter   GterAT  Deficit  Compra  Venda   Interligacao                                                                                                         \n",
    "          (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed) (MWmed)    (MWmed)                                                                                                            \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "    Pat_1     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0  FC:     0.0                                                                                                          \n",
    "                                                                                   SE:     0.0                                                                                                          \n",
    "                                                                                   NE:  1063.8                                                                                                          \n",
    "                                                                                   N : -1063.8                                                                                                          \n",
    "    Pat_2     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0  FC:     0.0                                                                                                          \n",
    "                                                                                   SE:     0.0                                                                                                          \n",
    "                                                                                   NE:   894.7                                                                                                          \n",
    "                                                                                   N :  -894.7                                                                                                          \n",
    "    Pat_3     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0  FC:     0.0                                                                                                          \n",
    "                                                                                   SE:     0.0                                                                                                          \n",
    "                                                                                   NE:   530.2                                                                                                          \n",
    "                                                                                   N :  -530.2                                                                                                          \n",
    "   X--------------------------------------------------------------------------------------------X                                                                                                       \n",
    "    Medio     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0     0.0  FC:     0.0*                                                                                                         \n",
    "                                                                                   SE:     0.0                                                                                                          \n",
    "                                                                                   NE:   720.8                                                                                                          \n",
    "                                                                                   N :  -720.8                                                                                                          \n",
    "                                                                                                                                                                                                        \n",
    "   (*) total da energia importada(+)/exportada(-) no susbsitema: FC                                                                                                                                     \n",
    "                                                                                                                                                                                                        \n",
    "   RELATORIO  DA  OPERACAO                                                                                                                                                                              \n",
]

MockCMO = [
    "   CUSTO MARGINAL DE OPERACAO  ($/MWh)                                                                                                                                                                  \n",
    "   X------X----------X----------X----------X----------X----------X                                                                                                                                      \n",
    "     Ssis  Sem_01     Sem_02     Sem_03     Sem_04     Sem_05                                                                                                                                           \n",
    "   X------X----------X----------X----------X----------X----------X                                                                                                                                      \n",
    "    Pat_1    287.91     291.06     291.99     289.35     287.67                                                                                                                                         \n",
    "    Pat_2    287.27     289.42     290.16     287.72     283.62                                                                                                                                         \n",
    "    Pat_3    281.48     283.41     283.32     280.07     278.99                                                                                                                                         \n",
    "    Med_SE   284.12     286.88     287.26     284.37     282.32                                                                                                                                         \n",
    "    Pat_1    287.91     291.06     291.99     289.35     287.67                                                                                                                                         \n",
    "    Pat_2    287.27     289.42     290.16     287.72     283.62                                                                                                                                         \n",
    "    Pat_3    281.48     283.41     283.32     280.07     278.99                                                                                                                                         \n",
    "    Med_S    284.12     286.88     287.26     284.37     282.32                                                                                                                                         \n",
    "    Pat_1    287.91     291.06     291.99     289.35     287.67                                                                                                                                         \n",
    "    Pat_2    287.27     289.42     290.16     287.72     283.62                                                                                                                                         \n",
    "    Pat_3    281.48     283.41     283.32     280.07     278.99                                                                                                                                         \n",
    "    Med_NE   284.12     286.88     287.26     284.37     282.32                                                                                                                                         \n",
    "    Pat_1    287.91     291.06     291.99     289.35     287.67                                                                                                                                         \n",
    "    Pat_2    287.27     289.42     290.16     287.72     283.62                                                                                                                                         \n",
    "    Pat_3    281.48     283.41     283.32     280.07     278.99                                                                                                                                         \n",
    "    Med_N    284.12     286.88     287.26     284.37     282.32                                                                                                                                         \n",
    "    Pat_1    287.91     291.06     291.99     289.35     287.67                                                                                                                                         \n",
    "    Pat_2    287.27     289.42     290.16     287.72     283.62                                                                                                                                         \n",
    "    Pat_3    281.48     283.41     283.32     280.07     278.99                                                                                                                                         \n",
    "    Med_FC   284.12     286.88     287.26     284.37     282.32                                                                                                                                         \n",
    "   X------X----------X----------X----------X----------X----------X                                                                                                                                      \n",
]

MockGeracaoTermicaSubsistema = [
    "   GERACAO TERMICA NOS SUSBSISTEMAS (MWmed) p/ CGC                                                                                                                                                      \n",
    "   X------X----------X----------X----------X----------X----------X                                                                                                                                      \n",
    "     Ssis  Sem_01     Sem_02     Sem_03     Sem_04     Sem_05                                                                                                                                           \n",
    "   X------X----------X----------X----------X----------X----------X                                                                                                                                      \n",
    "     SE        5083.8     4804.5     4315.4     4632.2     4705.9                                                                                                                                       \n",
    "     S         1176.0     1521.0     1522.0     1522.0     1522.0                                                                                                                                       \n",
    "     NE        1938.1     1668.1     1622.6     1634.7     1634.7                                                                                                                                       \n",
    "     N         2790.4     2692.6     2817.3     2834.3     2683.0                                                                                                                                       \n",
    "     FC           0.0        0.0        0.0        0.0        0.0                                                                                                                                       \n",
    "   X------X----------X----------X----------X----------X----------X                                                                                                                                      \n",
]

MockCustoOperacaoValorEsperado = [
    "    CUSTO DE OPERACAO E VALOR ESPERADO DO C.FUTURO ( 1.000 $ )                                                                                                                                       \n",
    "   X------X------------X------------X------------X------------X------------X                                                                                                                            \n",
    "              Sem_01       Sem_02       Sem_03       Sem_04       Sem_05                                                                                                                                \n",
    "   X------X------------X------------X------------X------------X------------X                                                                                                                            \n",
    "    *COP        90662.8      79546.7      81339.2      89975.9      85036.6                                                                                                                             \n",
    "    E(CF)   194072319.4  194414075.1  194755137.6  195088616.8  195427943.0                                                                                                                             \n"
    "   X------X------------X------------X------------X------------X------------X  \n",
]

MockVolumeUtilReservatorio = [
    "   VOLUME UTIL DOS RESERVATORIOS                                                                                                                                                                        \n",
    "   X----X------------X-------X------X------X------X------X------X                                                                                                                                       \n",
    "     No.  Usina        %V.U.          % V.U.  Final                                                                                                                                                     \n",
    "                       Inic.  Sem_01 Sem_02 Sem_03 Sem_04 Sem_05                                                                                                                                        \n",
    "   X----X------------X-------X------X------X------X------X------X                                                                                                                                       \n",
    "      1  CAMARGOS       25.3   24.9   27.5   30.4   35.1   39.2                                                                                                                                         \n",
    "      6  FURNAS         13.2   12.6   12.9   14.2   15.6   17.4                                                                                                                                         \n",
    "      7  M. DE MORAES   36.2   40.8   43.0   42.2   44.0   50.9                                                                                                                                         \n",
    "     14  CACONDE        38.0   38.2   40.4   42.5   45.8   47.9                                                                                                                                         \n",
    "     17  MARIMBONDO     23.1   28.2   32.6   41.6   51.9   58.0                                                                                                                                         \n",
    "     18  A. VERMELHA    23.7   20.9   21.0   18.6   20.4   28.9                                                                                                                                         \n",
    "     20  BATALHA        20.1   20.2   20.0   20.4   22.0   24.5                                                                                                                                         \n",
    "     21  SERRA FACAO    17.5   17.3   17.3   17.5   18.1   18.4                                                                                                                                         \n",
    "     24  EMBORCACAO     12.8   13.3   14.1   14.9   16.2   17.4                                                                                                                                         \n",
    "     25  NOVA PONTE     16.8   16.3   16.2   16.6   17.0   18.0                                                                                                                                         \n",
    "     26  MIRANDA        96.3  100.0  100.0   97.0  100.0  100.0                                                                                                                                         \n",
    "     27  CAPIM BRANC1   82.7  100.0  100.0  100.0  100.0  100.0                                                                                                                                         \n",
    "     29  CORUMBA IV     23.0   15.6   10.4    8.0    7.1    9.3                                                                                                                                         \n",
    "    203  CORUMBA III    22.5   43.0   44.4   34.6   31.2   17.2                                                                                                                                         \n",
    "     30  CORUMBA I      30.5   34.6   43.1   49.1   59.3   72.1                                                                                                                                         \n",
    "     31  ITUMBIARA      16.3   16.0   15.9   17.3   18.6   20.9                                                                                                                                         \n",
    "     33  SAO SIMAO      33.4   35.3   38.5   41.2   45.9   51.5                                                                                                                                         \n",
    "    290  ESPORA         25.0   28.9   34.6   41.6   49.0   56.5                                                                                                                                         \n",
    "    311  CACU           70.0   26.2    9.8   31.5   18.7   53.7                                                                                                                                         \n",
    "     34  I. SOLTEIRA    68.1   70.3   74.4   73.6   74.1   70.4                                                                                                                                         \n",
    "    118  BILLINGS       72.0   71.8   71.6   71.6   71.9   72.0                                                                                                                                         \n",
    "    117  GUARAPIRANGA   70.4   69.7   68.9   68.8   71.5   73.9                                                                                                                                         \n",
    "     37  BARRA BONITA   53.7   50.1   48.6   51.2   50.9   50.1                                                                                                                                         \n",
    "     40  PROMISSAO      42.9   36.1   31.0   29.0   32.0   42.4                                                                                                                                         \n",
    "     43  TRES IRMAOS    65.8   70.3   74.4   73.6   74.1   70.4                                                                                                                                         \n",
    "     47  A.A. LAYDNER   28.8   25.5   22.9   20.8   20.4   20.3                                                                                                                                         \n",
    "     49  CHAVANTES      22.4   22.2   23.2   24.4   25.5   25.2                                                                                                                                         \n",
    "     57  MAUA           51.9   51.0   46.1   40.7   38.0   34.3                                                                                                                                         \n",
    "     61  CAPIVARA       35.5   35.6   36.3   38.1   42.0   47.6                                                                                                                                         \n",
    "     66  ITAIPU          0.0  100.0  100.0  100.0  100.0  100.0                                                                                                                                         \n",
    "    120  JAGUARI        49.1   50.3   51.8   53.8   55.8   58.1                                                                                                                                         \n",
    "    121  PARAIBUNA      31.3   32.0   32.7   33.4   34.4   36.1                                                                                                                                         \n",
    "    122  SANTA BRANCA   43.4   48.7   56.9   65.7   73.5   77.6                                                                                                                                         \n",
    "    123  FUNIL          41.5   55.2   55.8   57.1   62.0   62.0                                                                                                                                         \n",
    "    124  LAJES          83.8   85.4   85.6   85.7   86.7   89.1                                                                                                                                         \n",
    "    135  P. ESTRELA     37.6  100.0   33.3   49.7  100.0  100.0                                                                                                                                         \n",
    "    278  MANSO          52.6   51.9   51.6   52.4   53.2   55.0                                                                                                                                         \n",
    "    276  RONDON II      30.1   25.1   20.5   17.7   13.5   11.3                                                                                                                                         \n",
    "    279  SAMUEL         18.9   26.7   32.0   38.1   44.3   50.4                                                                                                                                         \n",
    "    227  SINOP          50.0   29.8   17.3    8.7    7.3   11.3                                                                                                                                         \n",
    "     71  STA CLARA PR   51.3   47.4   40.1   33.0   23.8    8.2                                                                                                                                         \n",
    "     73  JORDAO        100.0  100.0  100.0  100.0  100.0  100.0                                                                                                                                         \n",
    "     74  G.B. MUNHOZ    20.8   17.2   15.0   13.8   15.5   17.4                                                                                                                                         \n",
    "     76  SEGREDO        35.4   77.6  100.0   92.3   83.7  100.0                                                                                                                                         \n",
    "     77  SLT.SANTIAGO   19.0   18.0   16.8   19.2   21.5   24.1                                                                                                                                         \n",
    "     86  BARRA GRANDE   19.3   16.1   12.7   11.6   12.3   15.3                                                                                                                                         \n",
    "     89  GARIBALDI      53.3   24.9   19.1   41.8   40.2   85.3                                                                                                                                         \n",
    "     90  CAMPOS NOVOS   50.9   69.2   67.5   47.3   40.4   31.2                                                                                                                                         \n",
    "     91  MACHADINHO     17.8   17.1   22.3   26.5   31.2   36.4                                                                                                                                         \n",
    "     93  PASSO FUNDO    29.6   30.1   30.2   30.4   31.3   32.5                                                                                                                                         \n",
    "     95  QUEBRA QUEIX   65.7  100.0  100.0   81.7   89.2   82.3                                                                                                                                         \n",
    "    110  ERNESTINA      99.6    0.0    0.0    0.0    0.0    0.0                                                                                                                                         \n",
    "    111  PASSO REAL     74.5   80.8   79.3   78.2   77.6   77.7                                                                                                                                         \n",
    "    115  G.P. SOUZA     23.8   26.9   30.6   33.6   38.2   44.7                                                                                                                                         \n",
    "    148  IRAPE          22.9   22.9   23.1   24.6   28.9   34.5                                                                                                                                         \n",
    "    155  RETIRO BAIXO   52.4  100.0  100.0  100.0   77.7  100.0                                                                                                                                         \n",
    "    156  TRES MARIAS    57.0   57.5   59.2   61.2   63.5   67.0                                                                                                                                         \n",
    "    162  QUEIMADO       27.8   26.4   24.0   20.4   17.8   17.2                                                                                                                                         \n",
    "    169  SOBRADINHO     28.8   27.8   26.6   26.1   25.9   26.1                                                                                                                                         \n",
    "    172  ITAPARICA      37.5   43.7   44.5   42.1   39.6   37.2                                                                                                                                         \n",
    "    189  P. CAVALO      78.1   69.1   59.1   48.6   39.6   31.3                                                                                                                                         \n",
    "    190  B. ESPERANCA   18.4   17.9   19.6   22.5   27.8   35.5                                                                                                                                         \n",
    "    251  SERRA MESA      9.4    8.8    8.3    8.3    8.7    9.4                                                                                                                                         \n",
    "    257  PEIXE ANGIC    18.2    5.0   10.5    0.0    0.0    0.0                                                                                                                                         \n",
    "    272  CURUA-UNA      22.3   30.2   34.0   36.7   37.3   38.3                                                                                                                                         \n",
    "    275  TUCURUI        17.3   19.8   22.1   24.6   26.3   30.0                                                                                                                                         \n",
    "    277  BALBINA        24.6   27.1   28.2   28.9   30.3   31.8                                                                                                                                         \n",
    "   X----X------------X-------X------X------X------X------X------X                                                                                                                                       \n",
]

MockDadosTermicas = [
    "   Relatorio  dos  Dados  de  Usinas  Termicas \n",
    "   X---X----------X------X-------X-------X-------X-------X-------X-------X-------X-------X-------X-------X                                                                             \n",
    "    Num   Usina    Subsis Estagio GTmin_1 GTmax_1 Custo_1 GTmin_2 GTmax_2 Custo_2 GTmin_3 GTmax_3 Custo_3                                                                              \n",
    "                                  (MWmed) (MWmed) ($/MWh) (MWmed) (MWmed) ($/MWh) (MWmed) (MWmed) ($/MWh)                                                                              \n",
    "   X---X----------X------X-------X-------X-------X-------X-------X-------X-------X-------X-------X-------X                                                                             \n",
    "     65 ATLAN_CSA     SE     1     122.60  122.60    0.00  122.60  122.60    0.00  122.60  122.60    0.00\n",
    "                             2      95.20   95.20    0.00   95.20   95.20    0.00   95.20   95.20    0.00\n",
    "                             3      80.80   80.80    0.00   80.80   80.80    0.00   80.80   80.80    0.00\n",
    "                             4      19.60   19.60    0.00   19.60   19.60    0.00   19.60   19.60    0.00\n",
    "                             5     116.30  116.30    0.00  116.30  116.30    0.00  116.30  116.30    0.00\n",
    "                             6     106.20  106.20    0.00  106.20  106.20    0.00  106.20  106.20    0.00\n",
    "     13 ANGRA 2       SE     1    1350.00 1350.00   20.12 1350.00 1350.00   20.12 1350.00 1350.00   20.12\n",
    "                             2    1350.00 1350.00   20.12 1350.00 1350.00   20.12 1350.00 1350.00   20.12\n",
    "                             3    1350.00 1350.00   20.12 1350.00 1350.00   20.12 1350.00 1350.00   20.12\n",
    "                             4    1350.00 1350.00   20.12 1350.00 1350.00   20.12 1350.00 1350.00   20.12\n",
    "                             5    1350.00 1350.00   20.12 1350.00 1350.00   20.12 1350.00 1350.00   20.12\n",
    "                             6    1350.00 1350.00   20.12 1350.00 1350.00   20.12 1350.00 1350.00   20.12\n",
    "      1 ANGRA 1       SE     1     520.00  640.00   31.17  520.00  640.00   31.17  520.00  640.00   31.17\n",
    "                             2     520.00  638.00   31.17  489.00  593.00   31.17  520.00  640.00   31.17\n",
    "                             3       0.00    0.00   31.17    0.00    0.00   31.17    0.00    0.00   31.17\n",
    "                             4       0.00    0.00   31.17    0.00    0.00   31.17    0.00    0.00   31.17\n",
    "                             5       0.00    0.00   31.17    0.00    0.00   31.17    0.00    0.00   31.17\n",
    "                             6     219.00  269.00   31.17  220.00  271.00   31.17  198.00  242.00   31.17\n",
    "    171 NORTEFLU 1    SE     1     400.00  400.00   66.85  400.00  400.00   66.85  400.00  400.00   66.85\n",
    "                             2     400.00  400.00   66.85  400.00  400.00   66.85  400.00  400.00   66.85\n",
    "                             3     400.00  400.00   66.85  400.00  400.00   66.85  400.00  400.00   66.85\n",
    "                             4     400.00  400.00   66.85  400.00  400.00   66.85  400.00  400.00   66.85\n",
    "                             5     400.00  400.00   66.85  400.00  400.00   66.85  400.00  400.00   66.85\n",
    "                             6     400.00  400.00   66.85  400.00  400.00   66.85  400.00  400.00   66.85\n",
    "    172 NORTEFLU 2    SE     1     100.00  100.00   77.48  100.00  100.00   77.48  100.00  100.00   77.48\n",
    "                             2     100.00  100.00   77.48  100.00  100.00   77.48  100.00  100.00   77.48\n",
    "                             3     100.00  100.00   77.48  100.00  100.00   77.48  100.00  100.00   77.48\n",
    "                             4     100.00  100.00   77.48  100.00  100.00   77.48  100.00  100.00   77.48\n",
    "                             5     100.00  100.00   77.48  100.00  100.00   77.48  100.00  100.00   77.48\n",
    "                             6     100.00  100.00   77.48  100.00  100.00   77.48  100.00  100.00   77.48\n",
    "    211 BAIXADA FL    SE     1       0.00   98.30  117.82    0.00   98.30  117.82    0.00   98.30  117.82\n",
    "                             2       0.00    0.00  117.82    0.00    0.00  117.82    0.00    0.00  117.82\n",
    "                             3       0.00  152.00  117.82    0.00  152.00  117.82    0.00  152.00  117.82\n",
    "                             4       0.00  530.00  117.82    0.00  530.00  117.82    0.00  530.00  117.82\n",
    "                             5       0.00  530.00  117.82    0.00  530.00  117.82    0.00  530.00  117.82\n",
    "                             6       0.00  530.00  117.82    0.00  530.00  117.82    0.00  530.00  117.82\n",
    "    173 NORTEFLU 3    SE     1     200.00  200.00  147.95  200.00  200.00  147.95  200.00  200.00  147.95\n",
    "                             2     200.00  200.00  147.95  200.00  200.00  147.95  200.00  200.00  147.95\n",
    "                             3     200.00  200.00  147.95  200.00  200.00  147.95  200.00  200.00  147.95\n",
    "                             4     200.00  200.00  147.95  200.00  200.00  147.95  200.00  200.00  147.95\n",
    "                             5     200.00  200.00  147.95  200.00  200.00  147.95  200.00  200.00  147.95\n",
    "                             6     200.00  200.00  147.95  200.00  200.00  147.95  200.00  200.00  147.95\n",
    "    183 ATLANTICO     SE     1     218.70  218.70  188.16  218.70  218.70  188.16  218.70  218.70  188.16\n",
    "                             2     218.70  218.70  188.16  218.70  218.70  188.16  218.70  218.70  188.16\n",
    "                             3     218.70  218.70  188.16  218.70  218.70  188.16  218.70  218.70  188.16\n",
    "                             4     218.70  218.70  188.16  218.70  218.70  188.16  218.70  218.70  188.16\n",
    "                             5     218.70  218.70  188.16  218.70  218.70  188.16  218.70  218.70  188.16\n",
    "                             6     218.70  218.70  188.16  218.70  218.70  188.16  218.70  218.70  188.16\n",
    "     68 TRES LAGOA    SE     1       0.00  189.60  216.44    0.00  189.60  216.44    0.00  189.60  216.44\n",
    "                             2       0.00  263.50  216.44    0.00  263.50  216.44    0.00  263.50  216.44\n",
    "                             3       0.00  263.50  216.44    0.00  263.50  216.44    0.00  263.50  216.44\n",
    "                             4       0.00  263.50  216.44    0.00  263.50  216.44    0.00  263.50  216.44\n",
    "                             5       0.00  263.50  216.44    0.00  263.50  216.44    0.00  263.50  216.44\n",
    "                             6       0.00  263.50  216.44    0.00  263.50  216.44    0.00  263.50  216.44\n",
    "     47 TERMORIO      SE     1     270.00  838.10  256.97  270.00  838.10  256.97  270.00  838.10  256.97\n",
    "                             2       0.00  928.40  256.97    0.00  928.40  256.97    0.00  928.40  256.97\n",
    "                             3       0.00  928.40  256.97    0.00  928.40  256.97    0.00  928.40  256.97\n",
    "                             4       0.00  928.40  256.97    0.00  928.40  256.97    0.00  928.40  256.97\n",
    "                             5       0.00  928.40  256.97    0.00  928.40  256.97    0.00  928.40  256.97\n",
    "                             6       0.00  894.60  256.97    0.00  894.60  256.97    0.00  894.60  256.97\n",
    "     54 JUIZ DE FO    SE     1       0.00   84.00  283.74    0.00   84.00  283.74    0.00   84.00  283.74\n",
    "                             2       0.00   84.00  283.74    0.00   84.00  283.74    0.00   84.00  283.74\n",
    "                             3       0.00   84.00  283.74    0.00   84.00  283.74    0.00   84.00  283.74\n",
    "                             4       0.00   84.00  283.74    0.00   84.00  283.74    0.00   84.00  283.74\n",
    "                             5       0.00   84.00  283.74    0.00   84.00  283.74    0.00   84.00  283.74\n",
    "                             6       0.00   84.00  283.74    0.00   84.00  283.74    0.00   84.00  283.74\n",
    "      4 ST.CRUZ 34    SE     1       0.00    0.00  310.41    0.00    0.00  310.41    0.00    0.00  310.41\n",
    "                             2       0.00    0.00  310.41    0.00    0.00  310.41    0.00    0.00  310.41\n",
    "                             3       0.00    0.00  310.41    0.00    0.00  310.41    0.00    0.00  310.41\n",
    "                             4       0.00    0.00  310.41    0.00    0.00  310.41    0.00    0.00  310.41\n",
    "                             5       0.00    0.00  310.41    0.00    0.00  310.41    0.00    0.00  310.41\n",
    "                             6       0.00    0.00  310.41    0.00    0.00  310.41    0.00    0.00  310.41\n",
    "     97 CUBATAO       SE     1     110.00  179.40  326.80  110.00  179.40  326.80  110.00  179.40  326.80\n",
    "                             2       0.00  209.00  326.80    0.00  209.00  326.80    0.00  209.00  326.80\n",
    "                             3       0.00  209.00  326.80    0.00  209.00  326.80    0.00  209.00  326.80\n",
    "                             4       0.00   48.20  326.80    0.00   48.20  326.80    0.00   48.20  326.80\n",
    "                             5       0.00  209.00  326.80    0.00  209.00  326.80    0.00  209.00  326.80\n",
    "                             6       0.00  209.00  326.80    0.00  209.00  326.80    0.00  209.00  326.80\n",
    "     63 IBIRITE       SE     1       0.00  222.00  346.37    0.00  222.00  346.37    0.00  222.00  346.37\n",
    "                             2       0.00  222.00  346.37    0.00  222.00  346.37    0.00  222.00  346.37\n",
    "                             3       0.00  222.00  346.37    0.00  222.00  346.37    0.00  222.00  346.37\n",
    "                             4       0.00  222.00  346.37    0.00  222.00  346.37    0.00  222.00  346.37\n",
    "                             5       0.00  222.00  346.37    0.00  222.00  346.37    0.00  222.00  346.37\n",
    "                             6       0.00  222.00  346.37    0.00  222.00  346.37    0.00  222.00  346.37\n",
    "    220 CUBAT_L13     SE     1       0.00   29.60  373.11    0.00   29.60  373.11    0.00   29.60  373.11\n",
    "                             2       0.00    0.00  373.11    0.00    0.00  373.11    0.00    0.00  373.11\n",
    "                             3       0.00    0.00  373.11    0.00    0.00  373.11    0.00    0.00  373.11\n",
    "                             4       0.00    0.00  373.11    0.00    0.00  373.11    0.00    0.00  373.11\n",
    "                             5       0.00    0.00  373.11    0.00    0.00  373.11    0.00    0.00  373.11\n",
    "                             6       0.00    0.00  373.11    0.00    0.00  373.11    0.00    0.00  373.11\n",
    "    218 T.LAG_L13     SE     1       0.00   73.80  373.75    0.00   73.80  373.75    0.00   73.80  373.75\n",
    "                             2       0.00    0.00  373.75    0.00    0.00  373.75    0.00    0.00  373.75\n",
    "                             3       0.00    0.00  373.75    0.00    0.00  373.75    0.00    0.00  373.75\n",
    "                             4       0.00    0.00  373.75    0.00    0.00  373.75    0.00    0.00  373.75\n",
    "                             5       0.00    0.00  373.75    0.00    0.00  373.75    0.00    0.00  373.75\n",
    "                             6       0.00    0.00  373.75    0.00    0.00  373.75    0.00    0.00  373.75\n",
    "    216 T.RIO_L13     SE     1       0.00   90.30  375.00    0.00   90.30  375.00    0.00   90.30  375.00\n",
    "                             2       0.00    0.00  375.00    0.00    0.00  375.00    0.00    0.00  375.00\n",
    "                             3       0.00    0.00  375.00    0.00    0.00  375.00    0.00    0.00  375.00\n",
    "                             4       0.00    0.00  375.00    0.00    0.00  375.00    0.00    0.00  375.00\n",
    "                             5       0.00    0.00  375.00    0.00    0.00  375.00    0.00    0.00  375.00\n",
    "                             6       0.00    0.00  375.00    0.00    0.00  375.00    0.00    0.00  375.00\n",
    "    214 SEROP_L13     SE     1       0.00    0.00  375.64    0.00    0.00  375.64    0.00    0.00  375.64\n",
    "                             2       0.00    0.00  375.64    0.00    0.00  375.64    0.00    0.00  375.64\n",
    "                             3       0.00    0.00  375.64    0.00    0.00  375.64    0.00    0.00  375.64\n",
    "                             4       0.00    0.00  375.64    0.00    0.00  375.64    0.00    0.00  375.64\n",
    "                             5       0.00    0.00  375.64    0.00    0.00  375.64    0.00    0.00  375.64\n",
    "                             6       0.00    0.00  375.64    0.00    0.00  375.64    0.00    0.00  375.64\n",
    "     62 SEROPEDICA    SE     1       0.00  320.00  354.24    0.00  320.00  354.24    0.00  320.00  354.24\n",
    "                             2       0.00  320.00  354.24    0.00  320.00  354.24    0.00  320.00  354.24\n",
    "                             3       0.00  320.00  354.24    0.00  320.00  354.24    0.00  320.00  354.24\n",
    "                             4       0.00  320.00  354.24    0.00  320.00  354.24    0.00  320.00  354.24\n",
    "                             5       0.00  320.00  354.24    0.00  320.00  354.24    0.00  320.00  354.24\n",
    "                             6       0.00  320.00  354.24    0.00  320.00  354.24    0.00  320.00  354.24\n",
    "    174 NORTEFLU 4    SE     1      25.00  126.00  434.07   25.00  126.00  434.07   25.00  126.00  434.07\n",
    "                             2      25.00  126.00  434.07   25.00  126.00  434.07   25.00  126.00  434.07\n",
    "                             3      25.00  126.00  434.07   25.00  126.00  434.07   25.00  126.00  434.07\n",
    "                             4      25.00  126.00  434.07   25.00  126.00  434.07   25.00  126.00  434.07\n",
    "                             5      25.00  126.00  434.07   25.00  126.00  434.07   25.00  126.00  434.07\n",
    "                             6      25.00  126.00  434.07   25.00  126.00  434.07   25.00  126.00  434.07\n",
    "     50 PIRAT.12 O    SE     1       0.00    0.00  470.34    0.00    0.00  470.34    0.00    0.00  470.34\n",
    "                             2       0.00    0.00  470.34    0.00    0.00  470.34    0.00    0.00  470.34\n",
    "                             3       0.00    0.00  470.34    0.00    0.00  470.34    0.00    0.00  470.34\n",
    "                             4       0.00    0.00  470.34    0.00    0.00  470.34    0.00    0.00  470.34\n",
    "                             5       0.00    0.00  470.34    0.00    0.00  470.34    0.00    0.00  470.34\n",
    "                             6       0.00    0.00  470.34    0.00    0.00  470.34    0.00    0.00  470.34\n",
    "     12 CUIABA CC     SE     1       0.00    0.00  511.77    0.00    0.00  511.77    0.00    0.00  511.77\n",
    "                             2       0.00    0.00  511.77    0.00    0.00  511.77    0.00    0.00  511.77\n",
    "                             3       0.00    0.00  511.77    0.00    0.00  511.77    0.00    0.00  511.77\n",
    "                             4       0.00    0.00  511.77    0.00    0.00  511.77    0.00    0.00  511.77\n",
    "                             5       0.00    0.00  511.77    0.00    0.00  511.77    0.00    0.00  511.77\n",
    "                             6       0.00    0.00  511.77    0.00    0.00  511.77    0.00    0.00  511.77\n",
    "    110 NPIRATINGA    SE     1       0.00  380.60  548.04    0.00  380.60  548.04    0.00  380.60  548.04\n",
    "                             2       0.00  380.60  548.04    0.00  380.60  548.04    0.00  380.60  548.04\n",
    "                             3       0.00  380.60  548.04    0.00  380.60  548.04    0.00  380.60  548.04\n",
    "                             4       0.00  380.60  548.04    0.00  380.60  548.04    0.00  380.60  548.04\n",
    "                             5       0.00  381.20  548.04    0.00  381.20  548.04    0.00  381.20  548.04\n",
    "                             6       0.00  563.60  548.04    0.00  563.60  548.04    0.00  563.60  548.04\n",
    "     90 T.MACAE       SE     1       0.00  881.00  591.17    0.00  881.00  591.17    0.00  881.00  591.17\n",
    "                             2       0.00  853.20  591.17    0.00  853.20  591.17    0.00  853.20  591.17\n",
    "                             3       0.00  852.60  591.17    0.00  852.60  591.17    0.00  852.60  591.17\n",
    "                             4       0.00  881.00  591.17    0.00  881.00  591.17    0.00  881.00  591.17\n",
    "                             5       0.00  881.00  591.17    0.00  881.00  591.17    0.00  881.00  591.17\n",
    "                             6       0.00  881.00  591.17    0.00  881.00  591.17    0.00  881.00  591.17\n",
    "     49 VIANA         SE     1       0.00  175.00  720.76    0.00  175.00  720.76    0.00  175.00  720.76\n",
    "                             2       0.00  175.00  720.76    0.00  175.00  720.76    0.00  175.00  720.76\n",
    "                             3       0.00  175.00  720.76    0.00  175.00  720.76    0.00  175.00  720.76\n",
    "                             4       0.00  175.00  720.76    0.00  175.00  720.76    0.00  175.00  720.76\n",
    "                             5       0.00  175.00  720.76    0.00  175.00  720.76    0.00  175.00  720.76\n",
    "                             6       0.00  175.00  720.76    0.00  175.00  720.76    0.00  175.00  720.76\n",
    "    194 TNORTE 2      SE     1       0.00    0.00  910.86    0.00    0.00  910.86    0.00    0.00  910.86\n",
    "                             2       0.00    0.00  910.86    0.00    0.00  910.86    0.00    0.00  910.86\n",
    "                             3       0.00    0.00  910.86    0.00    0.00  910.86    0.00    0.00  910.86\n",
    "                             4       0.00    0.00  910.86    0.00    0.00  910.86    0.00    0.00  910.86\n",
    "                             5       0.00    0.00  910.86    0.00    0.00  910.86    0.00    0.00  910.86\n",
    "                             6       0.00    0.00  910.86    0.00    0.00  910.86    0.00    0.00  910.86\n",
    "    182 PALMEIR_GO    SE     1       0.00  121.50  923.83    0.00  121.50  923.83    0.00  121.50  923.83\n",
    "                             2       0.00  121.50  923.83    0.00  121.50  923.83    0.00  121.50  923.83\n",
    "                             3       0.00  121.50  923.83    0.00  121.50  923.83    0.00  121.50  923.83\n",
    "                             4       0.00  121.50  923.83    0.00  121.50  923.83    0.00  121.50  923.83\n",
    "                             5       0.00  121.50  923.83    0.00  121.50  923.83    0.00  121.50  923.83\n",
    "                             6       0.00  121.50  923.83    0.00  121.50  923.83    0.00  121.50  923.83\n",
    "      2 IGARAPE       SE     1       0.00    0.00  939.55    0.00    0.00  939.55    0.00    0.00  939.55\n",
    "                             2       0.00    0.00  939.55    0.00    0.00  939.55    0.00    0.00  939.55\n",
    "                             3       0.00    0.00  939.55    0.00    0.00  939.55    0.00    0.00  939.55\n",
    "                             4       0.00    0.00  939.55    0.00    0.00  939.55    0.00    0.00  939.55\n",
    "                             5       0.00    0.00  939.55    0.00    0.00  939.55    0.00    0.00  939.55\n",
    "                             6       0.00    0.00  939.55    0.00    0.00  939.55    0.00    0.00  939.55\n",
    "      9 CAMPOS        SE     1       0.00    0.00  978.10    0.00    0.00  978.10    0.00    0.00  978.10\n",
    "                             2       0.00    0.00  978.10    0.00    0.00  978.10    0.00    0.00  978.10\n",
    "                             3       0.00    0.00  978.10    0.00    0.00  978.10    0.00    0.00  978.10\n",
    "                             4       0.00    0.00  978.10    0.00    0.00  978.10    0.00    0.00  978.10\n",
    "                             5       0.00    0.00  978.10    0.00    0.00  978.10    0.00    0.00  978.10\n",
    "                             6       0.00    0.00  978.10    0.00    0.00  978.10    0.00    0.00  978.10\n",
    "    153 DAIA          SE     1       0.00    0.00 1162.38    0.00    0.00 1162.38    0.00    0.00 1162.38\n",
    "                             2       0.00    0.00 1162.38    0.00    0.00 1162.38    0.00    0.00 1162.38\n",
    "                             3       0.00    0.00 1162.38    0.00    0.00 1162.38    0.00    0.00 1162.38\n",
    "                             4       0.00    0.00 1162.38    0.00    0.00 1162.38    0.00    0.00 1162.38\n",
    "                             5       0.00    0.00 1162.38    0.00    0.00 1162.38    0.00    0.00 1162.38\n",
    "                             6       0.00    0.00 1162.38    0.00    0.00 1162.38    0.00    0.00 1162.38\n",
    "    155 GOIANIA 2     SE     1       0.00  140.00 1218.35    0.00  140.00 1218.35    0.00  140.00 1218.35\n",
    "                             2       0.00  140.00 1218.35    0.00  140.00 1218.35    0.00  140.00 1218.35\n",
    "                             3       0.00  140.00 1218.35    0.00  140.00 1218.35    0.00  140.00 1218.35\n",
    "                             4       0.00  140.00 1218.35    0.00  140.00 1218.35    0.00  140.00 1218.35\n",
    "                             5       0.00  140.00 1218.35    0.00  140.00 1218.35    0.00  140.00 1218.35\n",
    "                             6       0.00  140.00 1218.35    0.00  140.00 1218.35    0.00  140.00 1218.35\n",
    "    108 XAVANTES      SE     1       0.00   53.50 1671.57    0.00   53.50 1671.57    0.00   53.50 1671.57\n",
    "                             2       0.00   53.50 1671.57    0.00   53.50 1671.57    0.00   53.50 1671.57\n",
    "                             3       0.00   53.50 1671.57    0.00   53.50 1671.57    0.00   53.50 1671.57\n",
    "                             4       0.00   53.50 1671.57    0.00   53.50 1671.57    0.00   53.50 1671.57\n",
    "                             5       0.00   53.50 1671.57    0.00   53.50 1671.57    0.00   53.50 1671.57\n",
    "                             6       0.00   53.50 1671.57    0.00   53.50 1671.57    0.00   53.50 1671.57\n",
    "     48 ARAUCARIA     S      1       0.00    0.00  678.18    0.00    0.00  678.18    0.00    0.00  678.18\n",
    "                             2       0.00    0.00  678.18    0.00    0.00  678.18    0.00    0.00  678.18\n",
    "                             3       0.00    0.00  678.18    0.00    0.00  678.18    0.00    0.00  678.18\n",
    "                             4       0.00    0.00  678.18    0.00    0.00  678.18    0.00    0.00  678.18\n",
    "                             5       0.00    0.00  678.18    0.00    0.00  678.18    0.00    0.00  678.18\n",
    "                             6       0.00    0.00  678.18    0.00    0.00  678.18    0.00    0.00  678.18\n",
    "    107 PAMPA SUL     S      1       0.00  345.00   67.12    0.00  345.00   67.12    0.00  345.00   67.12\n",
    "                             2     170.00  345.00   67.12  170.00  345.00   67.12  170.00  345.00   67.12\n",
    "                             3     170.00  345.00   67.12  170.00  345.00   67.12  170.00  345.00   67.12\n",
    "                             4     170.00  345.00   67.12  170.00  345.00   67.12  170.00  345.00   67.12\n",
    "                             5     170.00  345.00   67.12  170.00  345.00   67.12  170.00  345.00   67.12\n",
    "                             6     170.00  345.00   67.12  170.00  345.00   67.12  170.00  345.00   67.12\n",
    "    149 SAO SEPE      S      1       0.00    7.00   84.44    0.00    7.00   84.44    0.00    7.00   84.44\n",
    "                             2       0.00    7.00   84.44    0.00    7.00   84.44    0.00    7.00   84.44\n",
    "                             3       0.00    8.00   84.44    0.00    8.00   84.44    0.00    8.00   84.44\n",
    "                             4       0.00    8.00   84.44    0.00    8.00   84.44    0.00    8.00   84.44\n",
    "                             5       0.00    8.00   84.44    0.00    8.00   84.44    0.00    8.00   84.44\n",
    "                             6       0.00    8.00   84.44    0.00    8.00   84.44    0.00    8.00   84.44\n",
    "    156 CANDIOTA_3    S      1     310.00  310.00   84.68  310.00  310.00   84.68  310.00  310.00   84.68\n",
    "                             2     310.00  310.00   84.68  310.00  310.00   84.68  310.00  310.00   84.68\n",
    "                             3     310.00  310.00   84.68  310.00  310.00   84.68  310.00  310.00   84.68\n",
    "                             4     310.00  310.00   84.68  310.00  310.00   84.68  310.00  310.00   84.68\n",
    "                             5     310.00  310.00   84.68  310.00  310.00   84.68  310.00  310.00   84.68\n",
    "                             6     310.00  310.00   84.68  310.00  310.00   84.68  310.00  310.00   84.68\n",
    "     24 J.LACER. C    S      1       0.00  363.00  193.62    0.00  363.00  193.62    0.00  363.00  193.62\n",
    "                             2       0.00  363.00  193.62    0.00  363.00  193.62    0.00  363.00  193.62\n",
    "                             3       0.00  363.00  193.62    0.00  363.00  193.62    0.00  363.00  193.62\n",
    "                             4       0.00  363.00  193.62    0.00  363.00  193.62    0.00  363.00  193.62\n",
    "                             5       0.00  363.00  193.62    0.00  363.00  193.62    0.00  363.00  193.62\n",
    "                             6       0.00  363.00  193.62    0.00  363.00  193.62    0.00  363.00  193.62\n",
    "     25 J.LACER. B    S      1       0.00  262.00  228.12    0.00  262.00  228.12    0.00  262.00  228.12\n",
    "                             2       0.00  262.00  228.12    0.00  262.00  228.12    0.00  262.00  228.12\n",
    "                             3       0.00  262.00  228.12    0.00  262.00  228.12    0.00  262.00  228.12\n",
    "                             4       0.00  262.00  228.12    0.00  262.00  228.12    0.00  262.00  228.12\n",
    "                             5       0.00  262.00  228.12    0.00  262.00  228.12    0.00  262.00  228.12\n",
    "                             6       0.00  262.00  228.12    0.00  262.00  228.12    0.00  262.00  228.12\n",
    "     27 J.LAC. A2     S      1       0.00  132.00  235.35    0.00  132.00  235.35    0.00  132.00  235.35\n",
    "                             2       0.00  132.00  235.35    0.00  132.00  235.35    0.00  132.00  235.35\n",
    "                             3       0.00  132.00  235.35    0.00  132.00  235.35    0.00  132.00  235.35\n",
    "                             4       0.00  132.00  235.35    0.00  132.00  235.35    0.00  132.00  235.35\n",
    "                             5       0.00  132.00  235.35    0.00  132.00  235.35    0.00  132.00  235.35\n",
    "                             6       0.00  132.00  235.35    0.00  132.00  235.35    0.00  132.00  235.35\n",
    "     26 J.LAC. A1     S      1       0.00  100.00  254.97    0.00  100.00  254.97    0.00  100.00  254.97\n",
    "                             2       0.00  100.00  254.97    0.00  100.00  254.97    0.00  100.00  254.97\n",
    "                             3       0.00  100.00  254.97    0.00  100.00  254.97    0.00  100.00  254.97\n",
    "                             4       0.00  100.00  254.97    0.00  100.00  254.97    0.00  100.00  254.97\n",
    "                             5       0.00  100.00  254.97    0.00  100.00  254.97    0.00  100.00  254.97\n",
    "                             6       0.00  100.00  254.97    0.00  100.00  254.97    0.00  100.00  254.97\n",
    "    169 MADEIRA       S      1       2.00    3.00  303.11    2.00    3.00  303.11    2.00    3.00  303.11\n",
    "                             2       2.00    3.00  303.11    2.00    3.00  303.11    2.00    3.00  303.11\n",
    "                             3       2.00    3.00  303.11    2.00    3.00  303.11    2.00    3.00  303.11\n",
    "                             4       2.00    3.00  303.11    2.00    3.00  303.11    2.00    3.00  303.11\n",
    "                             5       2.00    3.00  303.11    2.00    3.00  303.11    2.00    3.00  303.11\n",
    "                             6       2.00    3.00  303.11    2.00    3.00  303.11    2.00    3.00  303.11\n",
    "     28 FIGUEIRA      S      1       0.00    0.00  475.68    0.00    0.00  475.68    0.00    0.00  475.68\n",
    "                             2       0.00    0.00  475.68    0.00    0.00  475.68    0.00    0.00  475.68\n",
    "                             3       0.00    0.00  475.68    0.00    0.00  475.68    0.00    0.00  475.68\n",
    "                             4       0.00    0.00  475.68    0.00    0.00  475.68    0.00    0.00  475.68\n",
    "                             5       0.00    0.00  475.68    0.00    0.00  475.68    0.00    0.00  475.68\n",
    "                             6       0.00    0.00  475.68    0.00    0.00  475.68    0.00    0.00  475.68\n",
    "     35 URUGUAIANA    S      1       0.00    0.00  486.20    0.00    0.00  486.20    0.00    0.00  486.20\n",
    "                             2       0.00    0.00  486.20    0.00    0.00  486.20    0.00    0.00  486.20\n",
    "                             3       0.00    0.00  486.20    0.00    0.00  486.20    0.00    0.00  486.20\n",
    "                             4       0.00    0.00  486.20    0.00    0.00  486.20    0.00    0.00  486.20\n",
    "                             5       0.00    0.00  486.20    0.00    0.00  486.20    0.00    0.00  486.20\n",
    "                             6       0.00    0.00  486.20    0.00    0.00  486.20    0.00    0.00  486.20\n",
    "     64 CANOAS        S      1       0.00  243.10  698.14    0.00  243.10  698.14    0.00  243.10  698.14\n",
    "                             2       0.00  243.10  698.14    0.00  243.10  698.14    0.00  243.10  698.14\n",
    "                             3       0.00  243.10  698.14    0.00  243.10  698.14    0.00  243.10  698.14\n",
    "                             4       0.00  243.10  698.14    0.00  243.10  698.14    0.00  243.10  698.14\n",
    "                             5       0.00  243.10  698.14    0.00  243.10  698.14    0.00  243.10  698.14\n",
    "                             6       0.00  243.10  698.14    0.00  243.10  698.14    0.00  243.10  698.14\n",
    "    167 P.PECEM1      NE     1       0.00  720.00  136.37    0.00  720.00  136.37    0.00  720.00  136.37\n",
    "                             2       0.00  720.00  136.37    0.00  720.00  136.37    0.00  720.00  136.37\n",
    "                             3       0.00  565.70  136.37    0.00  565.70  136.37    0.00  565.70  136.37\n",
    "                             4       0.00  360.00  136.37    0.00  360.00  136.37    0.00  360.00  136.37\n",
    "                             5       0.00  360.00  136.37    0.00  360.00  136.37    0.00  360.00  136.37\n",
    "                             6       0.00  545.10  136.37    0.00  545.10  136.37    0.00  545.10  136.37\n",
    "     96 TERMOPE       NE     1     532.70  532.70  138.51  532.70  532.70  138.51  532.70  532.70  138.51\n",
    "                             2     348.80  532.70  138.51  348.80  532.70  138.51  348.80  532.70  138.51\n",
    "                             3     348.80  532.70  138.51  348.80  532.70  138.51  348.80  532.70  138.51\n",
    "                             4     348.80  532.70  138.51  348.80  532.70  138.51  348.80  532.70  138.51\n",
    "                             5     348.80  532.70  138.51  348.80  532.70  138.51  348.80  532.70  138.51\n",
    "                             6     348.80  532.70  138.51  348.80  532.70  138.51  348.80  532.70  138.51\n",
    "    163 P.PECEM2      NE     1       0.00  365.00  148.41    0.00  365.00  148.41    0.00  365.00  148.41\n",
    "                             2       0.00  365.00  148.41    0.00  365.00  148.41    0.00  365.00  148.41\n",
    "                             3       0.00  365.00  148.41    0.00  365.00  148.41    0.00  365.00  148.41\n",
    "                             4       0.00  365.00  148.41    0.00  365.00  148.41    0.00  365.00  148.41\n",
    "                             5       0.00  365.00  148.41    0.00  365.00  148.41    0.00  365.00  148.41\n",
    "                             6       0.00  365.00  148.41    0.00  365.00  148.41    0.00  365.00  148.41\n",
    "    147 PROSPERIDA    NE     1       0.00   28.00  159.37    0.00   28.00  159.37    0.00   28.00  159.37\n",
    "                             2       0.00   28.00  159.37    0.00   28.00  159.37    0.00   28.00  159.37\n",
    "                             3       0.00   28.00  159.37    0.00   28.00  159.37    0.00   28.00  159.37\n",
    "                             4       0.00   28.00  159.37    0.00   28.00  159.37    0.00   28.00  159.37\n",
    "                             5       0.00   28.00  159.37    0.00   28.00  159.37    0.00   28.00  159.37\n",
    "                             6       0.00   28.00  159.37    0.00   28.00  159.37    0.00   28.00  159.37\n",
    "     42 FORTALEZA     NE     1       0.00    0.00  180.57    0.00    0.00  180.57    0.00    0.00  180.57\n",
    "                             2       0.00    0.00  180.57    0.00    0.00  180.57    0.00    0.00  180.57\n",
    "                             3       0.00  152.20  180.57    0.00  132.40  180.57    0.00   74.30  180.57\n",
    "                             4       0.00  326.60  180.57    0.00  326.60  180.57    0.00  326.60  180.57\n",
    "                             5       0.00  326.60  180.57    0.00  326.60  180.57    0.00  326.60  180.57\n",
    "                             6       0.00  326.60  180.57    0.00  326.60  180.57    0.00  326.60  180.57\n",
    "    831 VALE ACU      NE     1      75.00   78.05  300.78   69.51   72.34  300.78   58.42   60.80  300.78\n",
    "                             2       0.00  156.10  300.78    0.00  156.10  300.78    0.00  156.10  300.78\n",
    "                             3       0.00  222.10  300.78    0.00  222.10  300.78    0.00  222.10  300.78\n",
    "                             4       0.00  310.10  300.78    0.00  310.10  300.78    0.00  310.10  300.78\n",
    "                             5       0.00  310.10  300.78    0.00  310.10  300.78    0.00  310.10  300.78\n",
    "                             6       0.00  156.10  300.78    0.00  156.10  300.78    0.00  156.10  300.78\n",
    "    431 T.BAHIA       NE     1      60.00   79.45  301.30   55.61   73.64  301.30   46.74   61.89  301.30\n",
    "                             2       0.00  158.90  301.30    0.00  158.90  301.30    0.00  158.90  301.30\n",
    "                             3       0.00  158.90  301.30    0.00  158.90  301.30    0.00  158.90  301.30\n",
    "                             4       0.00  158.90  301.30    0.00  158.90  301.30    0.00  158.90  301.30\n",
    "                             5       0.00   98.00  301.30    0.00   98.00  301.30    0.00   98.00  301.30\n",
    "                             6       0.00   79.90  301.30    0.00   79.90  301.30    0.00   79.90  301.30\n",
    "     74 T.CAMACARI    NE     1       0.00   20.00  345.02    0.00   20.00  345.02    0.00   20.00  345.02\n",
    "                             2       0.00   20.00  345.02    0.00   20.00  345.02    0.00   20.00  345.02\n",
    "                             3       0.00   20.00  345.02    0.00   20.00  345.02    0.00   20.00  345.02\n",
    "                             4       0.00   20.00  345.02    0.00   20.00  345.02    0.00   20.00  345.02\n",
    "                             5       0.00   20.00  345.02    0.00   20.00  345.02    0.00   20.00  345.02\n",
    "                             6       0.00   20.00  345.02    0.00   20.00  345.02    0.00   20.00  345.02\n",
    "     58 TERMOCEARA    NE     1       0.00    0.00  368.23    0.00    0.00  368.23    0.00    0.00  368.23\n",
    "                             2       0.00    0.00  368.23    0.00    0.00  368.23    0.00    0.00  368.23\n",
    "                             3       0.00   73.50  368.23    0.00   73.50  368.23    0.00   73.50  368.23\n",
    "                             4       0.00  171.60  368.23    0.00  171.60  368.23    0.00  171.60  368.23\n",
    "                             5       0.00  171.60  368.23    0.00  171.60  368.23    0.00  171.60  368.23\n",
    "                             6       0.00  171.60  368.23    0.00  171.60  368.23    0.00  171.60  368.23\n",
    "     43 T.BAHIA       NE     1      60.00   79.45  374.87   64.39   85.26  374.87   73.26   97.01  374.87\n",
    "                             2       0.00    0.00  374.87    0.00    0.00  374.87    0.00    0.00  374.87\n",
    "                             3       0.00    0.00  374.87    0.00    0.00  374.87    0.00    0.00  374.87\n",
    "                             4       0.00    0.00  374.87    0.00    0.00  374.87    0.00    0.00  374.87\n",
    "                             5       0.00    0.00  374.87    0.00    0.00  374.87    0.00    0.00  374.87\n",
    "                             6       0.00    0.00  374.87    0.00    0.00  374.87    0.00    0.00  374.87\n",
    "     83 VALE ACU      NE     1      75.00   78.05  450.86   80.49   83.76  450.86   91.58   95.30  450.86\n",
    "                             2       0.00    0.00  450.86    0.00    0.00  450.86    0.00    0.00  450.86\n",
    "                             3       0.00    0.00  450.86    0.00    0.00  450.86    0.00    0.00  450.86\n",
    "                             4       0.00    0.00  450.86    0.00    0.00  450.86    0.00    0.00  450.86\n",
    "                             5       0.00    0.00  450.86    0.00    0.00  450.86    0.00    0.00  450.86\n",
    "                             6       0.00    0.00  450.86    0.00    0.00  450.86    0.00    0.00  450.86\n",
    "    221 SYKUE I       NE     1      22.40   22.40  510.12   22.40   22.40  510.12   22.40   22.40  510.12\n",
    "                             2      22.40   22.40  510.12   22.40   22.40  510.12   22.40   22.40  510.12\n",
    "                             3      22.40   22.40  510.12   22.40   22.40  510.12   22.40   22.40  510.12\n",
    "                             4      22.40   22.40  510.12   22.40   22.40  510.12   22.40   22.40  510.12\n",
    "                             5      22.40   22.40  510.12   22.40   22.40  510.12   22.40   22.40  510.12\n",
    "                             6      22.40   22.40  510.12   22.40   22.40  510.12   22.40   22.40  510.12\n",
    "     98 PERNAMBU_3    NE     1       0.00  174.00  616.83    0.00  174.00  616.83    0.00  174.00  616.83\n",
    "                             2       0.00  174.00  616.83    0.00  174.00  616.83    0.00  174.00  616.83\n",
    "                             3       0.00  174.00  616.83    0.00  174.00  616.83    0.00  174.00  616.83\n",
    "                             4       0.00  174.00  616.83    0.00  174.00  616.83    0.00  174.00  616.83\n",
    "                             5       0.00  174.00  616.83    0.00  174.00  616.83    0.00  174.00  616.83\n",
    "                             6       0.00  174.00  616.83    0.00  174.00  616.83    0.00  174.00  616.83\n",
    "     57 MARACANAU     NE     1       0.00  142.50  698.24    0.00  142.50  698.24    0.00  142.50  698.24\n",
    "                             2       0.00  142.50  698.24    0.00  142.50  698.24    0.00  142.50  698.24\n",
    "                             3       0.00  142.50  698.24    0.00  142.50  698.24    0.00  142.50  698.24\n",
    "                             4       0.00  142.50  698.24    0.00  142.50  698.24    0.00  142.50  698.24\n",
    "                             5       0.00  142.50  698.24    0.00  142.50  698.24    0.00  142.50  698.24\n",
    "                             6       0.00  142.50  698.24    0.00  142.50  698.24    0.00  142.50  698.24\n",
    "    152 TERMOCABO     NE     1       0.00   49.70  712.04    0.00   49.70  712.04    0.00   49.70  712.04\n",
    "                             2       0.00   49.70  712.04    0.00   49.70  712.04    0.00   49.70  712.04\n",
    "                             3       0.00   49.70  712.04    0.00   49.70  712.04    0.00   49.70  712.04\n",
    "                             4       0.00   49.70  712.04    0.00   49.70  712.04    0.00   49.70  712.04\n",
    "                             5       0.00   49.70  712.04    0.00   49.70  712.04    0.00   49.70  712.04\n",
    "                             6       0.00   49.70  712.04    0.00   49.70  712.04    0.00   49.70  712.04\n",
    "     67 TERMONE       NE     1       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             2       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             3       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             4       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             5       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             6       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "     69 TERMOPB       NE     1       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             2       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             3       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             4       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             5       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "                             6       0.00  152.70  716.62    0.00  152.70  716.62    0.00  152.70  716.62\n",
    "     52 CAMPINA_GR    NE     1       0.00  169.00  720.77    0.00  169.00  720.77    0.00  169.00  720.77\n",
    "                             2       0.00  169.00  720.77    0.00  169.00  720.77    0.00  169.00  720.77\n",
    "                             3       0.00  169.00  720.77    0.00  169.00  720.77    0.00  169.00  720.77\n",
    "                             4       0.00  169.00  720.77    0.00  169.00  720.77    0.00  169.00  720.77\n",
    "                             5       0.00  169.00  720.77    0.00  169.00  720.77    0.00  169.00  720.77\n",
    "                             6       0.00  169.00  720.77    0.00  169.00  720.77    0.00  169.00  720.77\n",
    "    112 BAHIA_1       NE     1       0.00   28.00  729.37    0.00   28.00  729.37    0.00   28.00  729.37\n",
    "                             2       0.00   28.00  729.37    0.00   28.00  729.37    0.00   28.00  729.37\n",
    "                             3       0.00   28.00  729.37    0.00   28.00  729.37    0.00   28.00  729.37\n",
    "                             4       0.00   28.00  729.37    0.00   28.00  729.37    0.00   28.00  729.37\n",
    "                             5       0.00   28.00  729.37    0.00   28.00  729.37    0.00   28.00  729.37\n",
    "                             6       0.00   28.00  729.37    0.00   28.00  729.37    0.00   28.00  729.37\n",
    "    170 SUAPE II      NE     1       0.00  348.80  730.11    0.00  348.80  730.11    0.00  348.80  730.11\n",
    "                             2       0.00  358.40  730.11    0.00  358.40  730.11    0.00  358.40  730.11\n",
    "                             3       0.00  380.80  730.11    0.00  380.80  730.11    0.00  380.80  730.11\n",
    "                             4       0.00  380.80  730.11    0.00  380.80  730.11    0.00  380.80  730.11\n",
    "                             5       0.00  380.80  730.11    0.00  380.80  730.11    0.00  380.80  730.11\n",
    "                             6       0.00  380.80  730.11    0.00  380.80  730.11    0.00  380.80  730.11\n",
    "     53 GLOBAL I      NE     1       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             2       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             3       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             4       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             5       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             6       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "     55 GLOBAL II     NE     1       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             2       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             3       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             4       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             5       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "                             6       0.00  130.00  817.35    0.00  130.00  817.35    0.00  130.00  817.35\n",
    "    109 ALTOS         NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    111 ARACATI       NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    113 BATURITE      NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    117 C.MAIOR       NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    119 CAUCAIA       NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    121 CRATO         NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    125 PECEM         NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    127 IGUATU        NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    133 JUAZEIRO N    NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    135 MARAMBAIA     NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    138 NAZARIA       NE     1       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             2       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             3       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             4       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             5       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "                             6       0.00    0.00 1009.78    0.00    0.00 1009.78    0.00    0.00 1009.78\n",
    "    164 MURICY        NE     1       0.00  136.00 1165.80    0.00  136.00 1165.80    0.00  136.00 1165.80\n",
    "                             2       0.00  136.00 1165.80    0.00  136.00 1165.80    0.00  136.00 1165.80\n",
    "                             3       0.00  136.00 1165.80    0.00  136.00 1165.80    0.00  136.00 1165.80\n",
    "                             4       0.00  136.00 1165.80    0.00  136.00 1165.80    0.00  136.00 1165.80\n",
    "                             5       0.00  136.00 1165.80    0.00  136.00 1165.80    0.00  136.00 1165.80\n",
    "                             6       0.00  136.00 1165.80    0.00  136.00 1165.80    0.00  136.00 1165.80\n",
    "    166 AREMBEPE      NE     1       0.00  112.00 1165.80    0.00  112.00 1165.80    0.00  112.00 1165.80\n",
    "                             2       0.00  112.00 1165.80    0.00  112.00 1165.80    0.00  112.00 1165.80\n",
    "                             3       0.00  112.00 1165.80    0.00  112.00 1165.80    0.00  112.00 1165.80\n",
    "                             4       0.00  112.00 1165.80    0.00  112.00 1165.80    0.00  112.00 1165.80\n",
    "                             5       0.00  112.00 1165.80    0.00  112.00 1165.80    0.00  112.00 1165.80\n",
    "                             6       0.00  112.00 1165.80    0.00  112.00 1165.80    0.00  112.00 1165.80\n",
    "    161 POTIGUAR_3    NE     1       0.00   54.80 1221.87    0.00   54.80 1221.87    0.00   54.80 1221.87\n",
    "                             2       0.00   54.80 1221.87    0.00   54.80 1221.87    0.00   54.80 1221.87\n",
    "                             3       0.00   54.80 1221.87    0.00   54.80 1221.87    0.00   54.80 1221.87\n",
    "                             4       0.00   54.80 1221.87    0.00   54.80 1221.87    0.00   54.80 1221.87\n",
    "                             5       0.00   54.80 1221.87    0.00   54.80 1221.87    0.00   54.80 1221.87\n",
    "                             6       0.00   54.80 1221.87    0.00   54.80 1221.87    0.00   54.80 1221.87\n",
    "    151 POTIGUAR      NE     1       0.00   53.10 1221.88    0.00   53.10 1221.88    0.00   53.10 1221.88\n",
    "                             2       0.00   53.10 1221.88    0.00   53.10 1221.88    0.00   53.10 1221.88\n",
    "                             3       0.00   53.10 1221.88    0.00   53.10 1221.88    0.00   53.10 1221.88\n",
    "                             4       0.00   53.10 1221.88    0.00   53.10 1221.88    0.00   53.10 1221.88\n",
    "                             5       0.00   53.10 1221.88    0.00   53.10 1221.88    0.00   53.10 1221.88\n",
    "                             6       0.00   53.10 1221.88    0.00   53.10 1221.88    0.00   53.10 1221.88\n",
    "    144 PETROLINA     NE     1       0.00  132.00 1279.05    0.00  132.00 1279.05    0.00  132.00 1279.05\n",
    "                             2       0.00  132.00 1279.05    0.00  132.00 1279.05    0.00  132.00 1279.05\n",
    "                             3       0.00  132.00 1279.05    0.00  132.00 1279.05    0.00  132.00 1279.05\n",
    "                             4       0.00  132.00 1279.05    0.00  132.00 1279.05    0.00  132.00 1279.05\n",
    "                             5       0.00  132.00 1279.05    0.00  132.00 1279.05    0.00  132.00 1279.05\n",
    "                             6       0.00  132.00 1279.05    0.00  132.00 1279.05    0.00  132.00 1279.05\n",
    "    159 TERMOMANAU    NE     1       0.00  143.00 1378.14    0.00  143.00 1378.14    0.00  143.00 1378.14\n",
    "                             2       0.00  143.00 1378.14    0.00  143.00 1378.14    0.00  143.00 1378.14\n",
    "                             3       0.00  143.00 1378.14    0.00  143.00 1378.14    0.00  143.00 1378.14\n",
    "                             4       0.00  143.00 1378.14    0.00  143.00 1378.14    0.00  143.00 1378.14\n",
    "                             5       0.00  143.00 1378.14    0.00  143.00 1378.14    0.00  143.00 1378.14\n",
    "                             6       0.00  143.00 1378.14    0.00  143.00 1378.14    0.00  143.00 1378.14\n",
    "    160 PAU FERRO     NE     1       0.00   94.00 1378.14    0.00   94.00 1378.14    0.00   94.00 1378.14\n",
    "                             2       0.00   94.00 1378.14    0.00   94.00 1378.14    0.00   94.00 1378.14\n",
    "                             3       0.00   94.00 1378.14    0.00   94.00 1378.14    0.00   94.00 1378.14\n",
    "                             4       0.00   94.00 1378.14    0.00   94.00 1378.14    0.00   94.00 1378.14\n",
    "                             5       0.00   94.00 1378.14    0.00   94.00 1378.14    0.00   94.00 1378.14\n",
    "                             6       0.00   94.00 1378.14    0.00   94.00 1378.14    0.00   94.00 1378.14\n",
    "    203 C. ROCHA      N      1      65.00   65.00    0.00   65.00   65.00    0.00   65.00   65.00    0.00\n",
    "                             2      65.00   65.00    0.00   65.00   65.00    0.00   65.00   65.00    0.00\n",
    "                             3      65.00   65.00    0.00   65.00   65.00    0.00   65.00   65.00    0.00\n",
    "                             4      65.00   65.00    0.00   65.00   65.00    0.00   65.00   65.00    0.00\n",
    "                             5      65.00   65.00    0.00   65.00   65.00    0.00   65.00   65.00    0.00\n",
    "                             6      65.00   65.00    0.00   65.00   65.00    0.00   65.00   65.00    0.00\n",
    "    204 JARAQUI       N      1      55.00   55.00    0.00   55.00   55.00    0.00   55.00   55.00    0.00\n",
    "                             2      55.00   55.00    0.00   55.00   55.00    0.00   55.00   55.00    0.00\n",
    "                             3      55.00   55.00    0.00   55.00   55.00    0.00   55.00   55.00    0.00\n",
    "                             4      55.00   55.00    0.00   55.00   55.00    0.00   55.00   55.00    0.00\n",
    "                             5      55.00   55.00    0.00   55.00   55.00    0.00   55.00   55.00    0.00\n",
    "                             6      55.00   55.00    0.00   55.00   55.00    0.00   55.00   55.00    0.00\n",
    "    205 MANAUARA      N      1      64.50   64.50    0.00   64.50   64.50    0.00   64.50   64.50    0.00\n",
    "                             2      64.50   64.50    0.00   64.50   64.50    0.00   64.50   64.50    0.00\n",
    "                             3      64.50   64.50    0.00   64.50   64.50    0.00   64.50   64.50    0.00\n",
    "                             4      64.50   64.50    0.00   64.50   64.50    0.00   64.50   64.50    0.00\n",
    "                             5      64.50   64.50    0.00   64.50   64.50    0.00   64.50   64.50    0.00\n",
    "                             6      64.50   64.50    0.00   64.50   64.50    0.00   64.50   64.50    0.00\n",
    "    207 PONTA NEGR    N      1      64.00   64.00    0.00   64.00   64.00    0.00   64.00   64.00    0.00\n",
    "                             2      64.00   64.00    0.00   64.00   64.00    0.00   64.00   64.00    0.00\n",
    "                             3      64.00   64.00    0.00   64.00   64.00    0.00   64.00   64.00    0.00\n",
    "                             4      64.00   64.00    0.00   64.00   64.00    0.00   64.00   64.00    0.00\n",
    "                             5      64.00   64.00    0.00   64.00   64.00    0.00   64.00   64.00    0.00\n",
    "                             6      64.00   64.00    0.00   64.00   64.00    0.00   64.00   64.00    0.00\n",
    "    209 TAMBAQUI      N      1      63.00   63.00    0.00   63.00   63.00    0.00   63.00   63.00    0.00\n",
    "                             2      63.00   63.00    0.00   63.00   63.00    0.00   63.00   63.00    0.00\n",
    "                             3      63.00   63.00    0.00   63.00   63.00    0.00   63.00   63.00    0.00\n",
    "                             4      63.00   63.00    0.00   63.00   63.00    0.00   63.00   63.00    0.00\n",
    "                             5      63.00   63.00    0.00   63.00   63.00    0.00   63.00   63.00    0.00\n",
    "                             6      63.00   63.00    0.00   63.00   63.00    0.00   63.00   63.00    0.00\n",
    "    140 UTE MAUA 3    N      1     264.00  590.80   70.25  264.00  590.80   70.25  264.00  590.80   70.25\n",
    "                             2     264.00  465.00   70.25  264.00  481.40   70.25  264.00  529.40   70.25\n",
    "                             3     264.00  590.80   70.25  264.00  590.80   70.25  264.00  590.80   70.25\n",
    "                             4     264.00  590.80   70.25  264.00  590.80   70.25  264.00  590.80   70.25\n",
    "                             5     264.00  457.20   70.25  264.00  467.80   70.25  264.00  502.60   70.25\n",
    "                             6     264.00  590.80   70.25  264.00  590.80   70.25  264.00  590.80   70.25\n",
    "    201 APARECIDA     N      1      75.00  123.00   70.25   75.00  123.00   70.25   75.00  123.00   70.25\n",
    "                             2      75.00   98.40   70.25   75.00  112.30   70.25   75.00  123.00   70.25\n",
    "                             3      75.00  148.80   70.25   75.00  148.20   70.25   75.00  149.70   70.25\n",
    "                             4      75.00  166.00   70.25   75.00  166.00   70.25   75.00  166.00   70.25\n",
    "                             5      75.00  123.00   70.25   75.00  123.00   70.25   75.00  123.50   70.25\n",
    "                             6      75.00  146.50   70.25   75.00  143.30   70.25   75.00  134.30   70.25\n",
    "    212 MARANHAO3     N      1       0.00  490.00   82.48    0.00  514.00   82.48    0.00  511.30   82.48\n",
    "                             2       0.00  490.00   82.48    0.00  515.80   82.48    0.00  513.00   82.48\n",
    "                             3       0.00  490.00   82.48    0.00  515.80   82.48    0.00  513.00   82.48\n",
    "                             4       0.00  490.00   82.48    0.00  515.80   82.48    0.00  513.00   82.48\n",
    "                             5       0.00  490.00   82.48    0.00  515.80   82.48    0.00  513.00   82.48\n",
    "                             6       0.00  506.70   82.48    0.00  506.70   82.48    0.00  506.70   82.48\n",
    "     21 MARANHAO V    N      1       0.00  325.00  124.19    0.00  335.50  124.19    0.00  334.30  124.19\n",
    "                             2       0.00  325.00  124.19    0.00  336.30  124.19    0.00  335.10  124.19\n",
    "                             3       0.00  325.00  124.19    0.00  336.30  124.19    0.00  335.10  124.19\n",
    "                             4       0.00  325.00  124.19    0.00  336.30  124.19    0.00  335.10  124.19\n",
    "                             5       0.00  325.00  124.19    0.00  336.30  124.19    0.00  335.10  124.19\n",
    "                             6       0.00  332.40  124.19    0.00  332.40  124.19    0.00  332.40  124.19\n",
    "     36 MARANHAOIV    N      1       0.00  325.00  124.19    0.00  335.50  124.19    0.00  334.30  124.19\n",
    "                             2       0.00  325.00  124.19    0.00  336.30  124.19    0.00  335.10  124.19\n",
    "                             3       0.00  325.00  124.19    0.00  336.30  124.19    0.00  335.10  124.19\n",
    "                             4       0.00  325.00  124.19    0.00  336.30  124.19    0.00  335.10  124.19\n",
    "                             5       0.00  325.00  124.19    0.00  336.30  124.19    0.00  335.10  124.19\n",
    "                             6       0.00  332.40  124.19    0.00  332.40  124.19    0.00  332.40  124.19\n",
    "    176 P. ITAQUI     N      1       0.00  360.10  143.03    0.00  360.10  143.03    0.00  360.10  143.03\n",
    "                             2       0.00  360.10  143.03    0.00  360.10  143.03    0.00  360.10  143.03\n",
    "                             3       0.00  360.10  143.03    0.00  360.10  143.03    0.00  360.10  143.03\n",
    "                             4       0.00  360.10  143.03    0.00  360.10  143.03    0.00  360.10  143.03\n",
    "                             5       0.00  360.10  143.03    0.00  360.10  143.03    0.00  360.10  143.03\n",
    "                             6       0.00  360.10  143.03    0.00  360.10  143.03    0.00  360.10  143.03\n",
    "    116 PARNAIB_IV    N      1       0.00   56.30  151.69    0.00   56.30  151.69    0.00   56.30  151.69\n",
    "                             2       0.00   56.30  151.69    0.00   56.30  151.69    0.00   56.30  151.69\n",
    "                             3       0.00   56.30  151.69    0.00   56.30  151.69    0.00   56.30  151.69\n",
    "                             4       0.00   56.30  151.69    0.00   56.30  151.69    0.00   56.30  151.69\n",
    "                             5       0.00   56.30  151.69    0.00   56.30  151.69    0.00   56.30  151.69\n",
    "                             6       0.00   56.30  151.69    0.00   56.30  151.69    0.00   56.30  151.69\n",
    "     46 N.VENECIA2    N      1       0.00  170.00  223.51    0.00  176.80  223.51    0.00  176.10  223.51\n",
    "                             2       0.00  170.00  223.51    0.00  177.30  223.51    0.00  176.60  223.51\n",
    "                             3       0.00  170.00  223.51    0.00  177.30  223.51    0.00  176.60  223.51\n",
    "                             4       0.00  170.00  223.51    0.00  177.30  223.51    0.00  176.60  223.51\n",
    "                             5       0.00  170.00  223.51    0.00  177.30  223.51    0.00  176.60  223.51\n",
    "                             6       0.00  174.80  223.51    0.00  174.80  223.51    0.00  174.80  223.51\n",
    "    206 MAUA B3       N      1       0.00    0.00  411.92    0.00    0.00  411.92    0.00    0.00  411.92\n",
    "                             2       0.00    0.00  411.92    0.00    0.00  411.92    0.00    0.00  411.92\n",
    "                             3       0.00    0.00  411.92    0.00    0.00  411.92    0.00    0.00  411.92\n",
    "                             4       0.00    0.00  411.92    0.00    0.00  411.92    0.00    0.00  411.92\n",
    "                             5       0.00    0.00  411.92    0.00    0.00  411.92    0.00    0.00  411.92\n",
    "                             6       0.00    0.00  411.92    0.00    0.00  411.92    0.00    0.00  411.92\n",
    "    141 MAUA B4       N      1       0.00    0.00  575.00    0.00    0.00  575.00    0.00    0.00  575.00\n",
    "                             2       0.00    0.00  575.00    0.00    0.00  575.00    0.00    0.00  575.00\n",
    "                             3       0.00    0.00  575.00    0.00    0.00  575.00    0.00    0.00  575.00\n",
    "                             4       0.00    0.00  575.00    0.00    0.00  575.00    0.00    0.00  575.00\n",
    "                             5       0.00    0.00  575.00    0.00    0.00  575.00    0.00    0.00  575.00\n",
    "                             6       0.00    0.00  575.00    0.00    0.00  575.00    0.00    0.00  575.00\n",
    "    300 MAUA B1       N      1       0.00    0.00  711.77    0.00    0.00  711.77    0.00    0.00  711.77\n",
    "                             2       0.00    0.00  711.77    0.00    0.00  711.77    0.00    0.00  711.77\n",
    "                             3       0.00    0.00  711.77    0.00    0.00  711.77    0.00    0.00  711.77\n",
    "                             4       0.00    0.00  711.77    0.00    0.00  711.77    0.00    0.00  711.77\n",
    "                             5       0.00    0.00  711.77    0.00    0.00  711.77    0.00    0.00  711.77\n",
    "                             6       0.00    0.00  711.77    0.00    0.00  711.77    0.00    0.00  711.77\n",
    "     70 GERAMAR2      N      1       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             2       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             3       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             4       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             5       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             6       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "     73 GERAMAR1      N      1       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             2       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             3       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             4       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             5       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "                             6       0.00  159.20  720.74    0.00  159.20  720.74    0.00  159.20  720.74\n",
    "    310 SAO JOSE      N      1       0.00    0.00  833.53    0.00    0.00  833.53    0.00    0.00  833.53\n",
    "                             2       0.00    0.00  833.53    0.00    0.00  833.53    0.00    0.00  833.53\n",
    "                             3       0.00    0.00  833.53    0.00    0.00  833.53    0.00    0.00  833.53\n",
    "                             4       0.00    0.00  833.53    0.00    0.00  833.53    0.00    0.00  833.53\n",
    "                             5       0.00    0.00  833.53    0.00    0.00  833.53    0.00    0.00  833.53\n",
    "                             6       0.00    0.00  833.53    0.00    0.00  833.53    0.00    0.00  833.53\n",
    "    303 ELECTRON      N      1       0.00    0.00  872.84    0.00    0.00  872.84    0.00    0.00  872.84\n",
    "                             2       0.00    0.00  872.84    0.00    0.00  872.84    0.00    0.00  872.84\n",
    "                             3       0.00    0.00  872.84    0.00    0.00  872.84    0.00    0.00  872.84\n",
    "                             4       0.00    0.00  872.84    0.00    0.00  872.84    0.00    0.00  872.84\n",
    "                             5       0.00    0.00  872.84    0.00    0.00  872.84    0.00    0.00  872.84\n",
    "                             6       0.00    0.00  872.84    0.00    0.00  872.84    0.00    0.00  872.84\n",
    "    302 APARECD OC    N      1       0.00    0.00  905.99    0.00    0.00  905.99    0.00    0.00  905.99\n",
    "                             2       0.00    0.00  905.99    0.00    0.00  905.99    0.00    0.00  905.99\n",
    "                             3       0.00    0.00  905.99    0.00    0.00  905.99    0.00    0.00  905.99\n",
    "                             4       0.00    0.00  905.99    0.00    0.00  905.99    0.00    0.00  905.99\n",
    "                             5       0.00    0.00  905.99    0.00    0.00  905.99    0.00    0.00  905.99\n",
    "                             6       0.00    0.00  905.99    0.00    0.00  905.99    0.00    0.00  905.99\n",
    "    317 IRANDUBA      N      1       0.00    0.00  955.63    0.00    0.00  955.63    0.00    0.00  955.63\n",
    "                             2       0.00    0.00  955.63    0.00    0.00  955.63    0.00    0.00  955.63\n",
    "                             3       0.00    0.00  955.63    0.00    0.00  955.63    0.00    0.00  955.63\n",
    "                             4       0.00    0.00  955.63    0.00    0.00  955.63    0.00    0.00  955.63\n",
    "                             5       0.00    0.00  955.63    0.00    0.00  955.63    0.00    0.00  955.63\n",
    "                             6       0.00    0.00  955.63    0.00    0.00  955.63    0.00    0.00  955.63\n",
    "    318 FLORES LT1    N      1       0.00    0.00  969.35    0.00    0.00  969.35    0.00    0.00  969.35\n",
    "                             2       0.00    0.00  969.35    0.00    0.00  969.35    0.00    0.00  969.35\n",
    "                             3       0.00    0.00  969.35    0.00    0.00  969.35    0.00    0.00  969.35\n",
    "                             4       0.00    0.00  969.35    0.00    0.00  969.35    0.00    0.00  969.35\n",
    "                             5       0.00    0.00  969.35    0.00    0.00  969.35    0.00    0.00  969.35\n",
    "                             6       0.00    0.00  969.35    0.00    0.00  969.35    0.00    0.00  969.35\n",
    "    319 FLORES LT2    N      1       0.00    0.00  984.90    0.00    0.00  984.90    0.00    0.00  984.90\n",
    "                             2       0.00    0.00  984.90    0.00    0.00  984.90    0.00    0.00  984.90\n",
    "                             3       0.00    0.00  984.90    0.00    0.00  984.90    0.00    0.00  984.90\n",
    "                             4       0.00    0.00  984.90    0.00    0.00  984.90    0.00    0.00  984.90\n",
    "                             5       0.00    0.00  984.90    0.00    0.00  984.90    0.00    0.00  984.90\n",
    "                             6       0.00    0.00  984.90    0.00    0.00  984.90    0.00    0.00  984.90\n",
    "   X---X----------X------X-------X-------X-------X-------X-------X-------X-------X-------X-------X-------X                                                                             \n",
    "\n",
]

MockDisponibilidadesTermicas = [
    "   Disponibilidade das Usinas Termicas (%)\n",
    "   X---X------------X------X------X------X------X------X------X                                                                                                                                                              \n",
    "    Num    Usina     Sem_01 Sem_02 Sem_03 Sem_04 Sem_05 Mes_02                                                                                                                                                              \n",
    "   X---X------------X------X------X------X------X------X------X                                                                                                                                                              \n",
    "     86  SANTA CRUZ   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     15  LUIZORMELO   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    224  PSERGIPE I   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     65  ATLAN_CSA    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     13  ANGRA 2      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "      1  ANGRA 1      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    171  NORTEFLU 1   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    172  NORTEFLU 2   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    211  BAIXADA FL   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    173  NORTEFLU 3   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    183  ATLANTICO    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     68  TRES LAGOA   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     47  TERMORIO     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     54  JUIZ DE FO   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "      4  ST.CRUZ 34   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     97  CUBATAO      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     63  IBIRITE      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    220  CUBAT_L13    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    218  T.LAG_L13    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    216  T.RIO_L13    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    214  SEROP_L13    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     62  SEROPEDICA   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    174  NORTEFLU 4   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     50  PIRAT.12 O   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     12  CUIABA CC    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    110  NPIRATINGA   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     90  T.MACAE      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     49  VIANA        100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    194  TNORTE 2     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    182  PALMEIR_GO   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "      2  IGARAPE      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "      9  CAMPOS       100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    153  DAIA         100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    155  GOIANIA 2    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    108  XAVANTES     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     48  ARAUCARIA    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    107  PAMPA SUL    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    149  SAO SEPE     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    156  CANDIOTA_3   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     24  J.LACER. C   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     25  J.LACER. B   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     27  J.LAC. A2    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     26  J.LAC. A1    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    169  MADEIRA      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     28  FIGUEIRA     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     35  URUGUAIANA   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     64  CANOAS       100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    167  P.PECEM1     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     96  TERMOPE      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    163  P.PECEM2     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    147  PROSPERIDA   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     42  FORTALEZA    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    831  VALE ACU     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    431  T.BAHIA      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     74  T.CAMACARI   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     58  TERMOCEARA   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     43  T.BAHIA      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     83  VALE ACU     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    221  SYKUE I      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     98  PERNAMBU_3   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     57  MARACANAU    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    152  TERMOCABO    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     67  TERMONE      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     69  TERMOPB      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     52  CAMPINA_GR   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    112  BAHIA_1      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    170  SUAPE II     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     53  GLOBAL I     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     55  GLOBAL II    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    109  ALTOS        100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    111  ARACATI      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    113  BATURITE     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    117  C.MAIOR      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    119  CAUCAIA      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    121  CRATO        100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    125  PECEM        100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    127  IGUATU       100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    133  JUAZEIRO N   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    135  MARAMBAIA    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    138  NAZARIA      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    164  MURICY       100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    166  AREMBEPE     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    161  POTIGUAR_3   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    151  POTIGUAR     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    144  PETROLINA    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    159  TERMOMANAU   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    160  PAU FERRO    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    203  C. ROCHA     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    204  JARAQUI      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    205  MANAUARA     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    207  PONTA NEGR   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    209  TAMBAQUI     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    140  UTE MAUA 3   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    201  APARECIDA    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    212  MARANHAO3    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     21  MARANHAO V   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     36  MARANHAOIV   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    176  P. ITAQUI    100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    116  PARNAIB_IV   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     46  N.VENECIA2   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    206  MAUA B3      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    141  MAUA B4      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    300  MAUA B1      100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     70  GERAMAR2     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "     73  GERAMAR1     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    310  SAO JOSE     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    303  ELECTRON     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    302  APARECD OC   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    317  IRANDUBA     100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    318  FLORES LT1   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "    319  FLORES LT2   100.0  100.0  100.0  100.0  100.0  100.0\n",
    "   X---X------------X------X------X------X------X------X------X                                                                                                                                                              \n",
    "\n",
]

MockDadosMercado = [
    "   Relatorio  dos  Dados  de  Mercado:\n",
    "   X---------X------X---------X---------X---------X---------X---------X---------X\n",
    "    Estagio  Subsis  Patamar 1  Mercado  Patamar 2  Mercado  Patamar 3  Mercado \n",
    "                      (horas)     (MW)    (horas)     (MW)    (horas)     (MW)\n",
    "   X---------X------X---------X---------X---------X---------X---------X---------X\n",
    "         1      SE       32.0    45078.0     41.0    41680.0     95.0    33894.0\n",
    "               ANDE      32.0     3179.0     41.0     2518.0     95.0     1574.0\n",
    "                S        32.0    14425.0     41.0    12503.0     95.0     9737.0\n",
    "                NE       32.0    12439.0     41.0    11677.0     95.0    10230.0\n",
    "                N        32.0     5847.0     41.0     5740.0     95.0     5319.0\n",
    "                FC       32.0        0.0     41.0        0.0     95.0        0.0\n",
    "         2      SE       40.0    47209.0     46.0    43871.0     82.0    36894.0\n",
    "               ANDE      40.0     3179.0     46.0     2518.0     82.0     1574.0\n",
    "                S        40.0    14818.0     46.0    12959.0     82.0    10530.0\n",
    "                NE       40.0    12848.0     46.0    12047.0     82.0    10773.0\n",
    "                N        40.0     5950.0     46.0     5825.0     82.0     5497.0\n",
    "                FC       40.0        0.0     46.0        0.0     82.0        0.0\n",
    "         3      SE       40.0    48669.0     46.0    45227.0     82.0    38035.0\n",
    "               ANDE      40.0     3179.0     46.0     2518.0     82.0     1574.0\n",
    "                S        40.0    15947.0     46.0    13946.0     82.0    11333.0\n",
    "                NE       40.0    12950.0     46.0    12142.0     82.0    10858.0\n",
    "                N        40.0     5970.0     46.0     5845.0     82.0     5516.0\n",
    "                FC       40.0        0.0     46.0        0.0     82.0        0.0\n",
    "         4      SE       40.0    49164.0     46.0    45688.0     82.0    38422.0\n",
    "               ANDE      40.0     3179.0     46.0     2518.0     82.0     1574.0\n",
    "                S        40.0    16254.0     46.0    14215.0     82.0    11551.0\n",
    "                NE       40.0    13074.0     46.0    12259.0     82.0    10962.0\n",
    "                N        40.0     5984.0     46.0     5858.0     82.0     5528.0\n",
    "                FC       40.0        0.0     46.0        0.0     82.0        0.0\n",
    "         5      SE       40.0    49568.0     46.0    46063.0     82.0    38738.0\n",
    "               ANDE      40.0     3179.0     46.0     2518.0     82.0     1574.0\n",
    "                S        40.0    16396.0     46.0    14339.0     82.0    11652.0\n",
    "                NE       40.0    13081.0     46.0    12265.0     82.0    10967.0\n",
    "                N        40.0     6030.0     46.0     5903.0     82.0     5571.0\n",
    "                FC       40.0        0.0     46.0        0.0     82.0        0.0\n",
    "         6      SE      152.0    49356.0    182.0    45816.0    362.0    38351.0\n",
    "               ANDE     152.0     2949.0    182.0     2337.0    362.0     1460.0\n",
    "                S       152.0    15552.0    182.0    13575.0    362.0    11070.0\n",
    "                NE      152.0    13028.0    182.0    12347.0    362.0    10894.0\n",
    "                N       152.0     6328.0    182.0     6237.0    362.0     5780.0\n",
    "                FC      152.0        0.0    182.0        0.0    362.0        0.0\n",
    "   X---------X------X---------X---------X---------X---------X---------X---------X\n",
    "\n",
]

MockENAAcoplamentoREE = [
    "   Relatorio dos Dados de Energia Natural Afluente para Acoplamento c/ Longo Prazo por REE (MWmed)\n",
    "\n",
    "   REE:    1 - SUDESTE   / SUBSISTEMA:    1 - SE\n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   3909.5   4757.4   5605.3   6609.8   7946.4   7640.1                                                                                                                                                                                                                                                  \n",
    "      2   3909.5   4757.4   5605.3   6609.8   7946.4  10340.6                                                                                                                                                                                                                                                  \n",
    "      3   3909.5   4757.4   5605.3   6609.8   7946.4   4880.7                                                                                                                                                                                                                                                  \n",
    "      4   3909.5   4757.4   5605.3   6609.8   7946.4   4132.8                                                                                                                                                                                                                                                  \n",
    "      5   3909.5   4757.4   5605.3   6609.8   7946.4   9662.6                                                                                                                                                                                                                                                  \n",
    "      6   3909.5   4757.4   5605.3   6609.8   7946.4   4802.1                                                                                                                                                                                                                                                  \n",
    "      7   3909.5   4757.4   5605.3   6609.8   7946.4  10243.9                                                                                                                                                                                                                                                  \n",
    "      8   3909.5   4757.4   5605.3   6609.8   7946.4   6756.4                                                                                                                                                                                                                                                  \n",
    "      9   3909.5   4757.4   5605.3   6609.8   7946.4   4693.1                                                                                                                                                                                                                                                  \n",
    "     10   3909.5   4757.4   5605.3   6609.8   7946.4   6944.7                                                                                                                                                                                                                                                  \n",
    "     11   3909.5   4757.4   5605.3   6609.8   7946.4  13384.8                                                                                                                                                                                                                                                  \n",
    "     12   3909.5   4757.4   5605.3   6609.8   7946.4   4948.7                                                                                                                                                                                                                                                  \n",
    "     13   3909.5   4757.4   5605.3   6609.8   7946.4  10910.9                                                                                                                                                                                                                                                  \n",
    "     14   3909.5   4757.4   5605.3   6609.8   7946.4   4095.1                                                                                                                                                                                                                                                  \n",
    "     15   3909.5   4757.4   5605.3   6609.8   7946.4   7689.8                                                                                                                                                                                                                                                  \n",
    "     16   3909.5   4757.4   5605.3   6609.8   7946.4   9574.3                                                                                                                                                                                                                                                  \n",
    "     17   3909.5   4757.4   5605.3   6609.8   7946.4  11249.5                                                                                                                                                                                                                                                  \n",
    "     18   3909.5   4757.4   5605.3   6609.8   7946.4   5609.3                                                                                                                                                                                                                                                  \n",
    "     19   3909.5   4757.4   5605.3   6609.8   7946.4   5097.7                                                                                                                                                                                                                                                  \n",
    "     20   3909.5   4757.4   5605.3   6609.8   7946.4   7083.3                                                                                                                                                                                                                                                  \n",
    "     21   3909.5   4757.4   5605.3   6609.8   7946.4   8539.1                                                                                                                                                                                                                                                  \n",
    "     22   3909.5   4757.4   5605.3   6609.8   7946.4   9786.0                                                                                                                                                                                                                                                  \n",
    "     23   3909.5   4757.4   5605.3   6609.8   7946.4  11125.4                                                                                                                                                                                                                                                  \n",
    "     24   3909.5   4757.4   5605.3   6609.8   7946.4   6918.9                                                                                                                                                                                                                                                  \n",
    "     25   3909.5   4757.4   5605.3   6609.8   7946.4  20313.0                                                                                                                                                                                                                                                  \n",
    "     26   3909.5   4757.4   5605.3   6609.8   7946.4   3632.1                                                                                                                                                                                                                                                  \n",
    "     27   3909.5   4757.4   5605.3   6609.8   7946.4  13129.4                                                                                                                                                                                                                                                  \n",
    "     28   3909.5   4757.4   5605.3   6609.8   7946.4   4776.6                                                                                                                                                                                                                                                  \n",
    "     29   3909.5   4757.4   5605.3   6609.8   7946.4   4775.6                                                                                                                                                                                                                                                  \n",
    "     30   3909.5   4757.4   5605.3   6609.8   7946.4   5547.5                                                                                                                                                                                                                                                  \n",
    "     31   3909.5   4757.4   5605.3   6609.8   7946.4  10690.1                                                                                                                                                                                                                                                  \n",
    "     32   3909.5   4757.4   5605.3   6609.8   7946.4   5778.0                                                                                                                                                                                                                                                  \n",
    "     33   3909.5   4757.4   5605.3   6609.8   7946.4   4988.8                                                                                                                                                                                                                                                  \n",
    "     34   3909.5   4757.4   5605.3   6609.8   7946.4   4217.7                                                                                                                                                                                                                                                  \n",
    "     35   3909.5   4757.4   5605.3   6609.8   7946.4   6463.5                                                                                                                                                                                                                                                  \n",
    "     36   3909.5   4757.4   5605.3   6609.8   7946.4  10080.3                                                                                                                                                                                                                                                  \n",
    "     37   3909.5   4757.4   5605.3   6609.8   7946.4   8791.2                                                                                                                                                                                                                                                  \n",
    "     38   3909.5   4757.4   5605.3   6609.8   7946.4   7287.0                                                                                                                                                                                                                                                  \n",
    "     39   3909.5   4757.4   5605.3   6609.8   7946.4  16240.9                                                                                                                                                                                                                                                  \n",
    "     40   3909.5   4757.4   5605.3   6609.8   7946.4   4997.6                                                                                                                                                                                                                                                  \n",
    "     41   3909.5   4757.4   5605.3   6609.8   7946.4   7053.7                                                                                                                                                                                                                                                  \n",
    "     42   3909.5   4757.4   5605.3   6609.8   7946.4   4931.7                                                                                                                                                                                                                                                  \n",
    "     43   3909.5   4757.4   5605.3   6609.8   7946.4   3561.0                                                                                                                                                                                                                                                  \n",
    "     44   3909.5   4757.4   5605.3   6609.8   7946.4   5431.3                                                                                                                                                                                                                                                  \n",
    "     45   3909.5   4757.4   5605.3   6609.8   7946.4   8939.8                                                                                                                                                                                                                                                  \n",
    "     46   3909.5   4757.4   5605.3   6609.8   7946.4   9856.6                                                                                                                                                                                                                                                  \n",
    "     47   3909.5   4757.4   5605.3   6609.8   7946.4   4627.7                                                                                                                                                                                                                                                  \n",
    "     48   3909.5   4757.4   5605.3   6609.8   7946.4   7028.6                                                                                                                                                                                                                                                  \n",
    "     49   3909.5   4757.4   5605.3   6609.8   7946.4   4823.5                                                                                                                                                                                                                                                  \n",
    "     50   3909.5   4757.4   5605.3   6609.8   7946.4  12796.5                                                                                                                                                                                                                                                  \n",
    "     51   3909.5   4757.4   5605.3   6609.8   7946.4   8900.2                                                                                                                                                                                                                                                  \n",
    "     52   3909.5   4757.4   5605.3   6609.8   7946.4  12702.7                                                                                                                                                                                                                                                  \n",
    "     53   3909.5   4757.4   5605.3   6609.8   7946.4   6006.7                                                                                                                                                                                                                                                  \n",
    "     54   3909.5   4757.4   5605.3   6609.8   7946.4  12523.7                                                                                                                                                                                                                                                  \n",
    "     55   3909.5   4757.4   5605.3   6609.8   7946.4   9617.3                                                                                                                                                                                                                                                  \n",
    "     56   3909.5   4757.4   5605.3   6609.8   7946.4   7407.6                                                                                                                                                                                                                                                  \n",
    "     57   3909.5   4757.4   5605.3   6609.8   7946.4   6388.6                                                                                                                                                                                                                                                  \n",
    "     58   3909.5   4757.4   5605.3   6609.8   7946.4   8063.3                                                                                                                                                                                                                                                  \n",
    "     59   3909.5   4757.4   5605.3   6609.8   7946.4   5810.1                                                                                                                                                                                                                                                  \n",
    "     60   3909.5   4757.4   5605.3   6609.8   7946.4   9219.0                                                                                                                                                                                                                                                  \n",
    "     61   3909.5   4757.4   5605.3   6609.8   7946.4   6516.5                                                                                                                                                                                                                                                  \n",
    "     62   3909.5   4757.4   5605.3   6609.8   7946.4   7487.2                                                                                                                                                                                                                                                  \n",
    "     63   3909.5   4757.4   5605.3   6609.8   7946.4   8105.1                                                                                                                                                                                                                                                  \n",
    "     64   3909.5   4757.4   5605.3   6609.8   7946.4   6241.1                                                                                                                                                                                                                                                  \n",
    "     65   3909.5   4757.4   5605.3   6609.8   7946.4   4550.1                                                                                                                                                                                                                                                  \n",
    "     66   3909.5   4757.4   5605.3   6609.8   7946.4  11378.1                                                                                                                                                                                                                                                  \n",
    "     67   3909.5   4757.4   5605.3   6609.8   7946.4   5728.3                                                                                                                                                                                                                                                  \n",
    "     68   3909.5   4757.4   5605.3   6609.8   7946.4   6472.9                                                                                                                                                                                                                                                  \n",
    "     69   3909.5   4757.4   5605.3   6609.8   7946.4   4424.0                                                                                                                                                                                                                                                  \n",
    "     70   3909.5   4757.4   5605.3   6609.8   7946.4   6355.6                                                                                                                                                                                                                                                  \n",
    "     71   3909.5   4757.4   5605.3   6609.8   7946.4   6757.7                                                                                                                                                                                                                                                  \n",
    "     72   3909.5   4757.4   5605.3   6609.8   7946.4   7278.8                                                                                                                                                                                                                                                  \n",
    "     73   3909.5   4757.4   5605.3   6609.8   7946.4   6119.3                                                                                                                                                                                                                                                  \n",
    "     74   3909.5   4757.4   5605.3   6609.8   7946.4   7220.5                                                                                                                                                                                                                                                  \n",
    "     75   3909.5   4757.4   5605.3   6609.8   7946.4   5377.1                                                                                                                                                                                                                                                  \n",
    "     76   3909.5   4757.4   5605.3   6609.8   7946.4   5081.0                                                                                                                                                                                                                                                  \n",
    "     77   3909.5   4757.4   5605.3   6609.8   7946.4   4386.8                                                                                                                                                                                                                                                  \n",
    "     78   3909.5   4757.4   5605.3   6609.8   7946.4   5741.9                                                                                                                                                                                                                                                  \n",
    "     79   3909.5   4757.4   5605.3   6609.8   7946.4  11414.5                                                                                                                                                                                                                                                  \n",
    "     80   3909.5   4757.4   5605.3   6609.8   7946.4   8734.1                                                                                                                                                                                                                                                  \n",
    "     81   3909.5   4757.4   5605.3   6609.8   7946.4   8098.7                                                                                                                                                                                                                                                  \n",
    "     82   3909.5   4757.4   5605.3   6609.8   7946.4   5123.4                                                                                                                                                                                                                                                  \n",
    "     83   3909.5   4757.4   5605.3   6609.8   7946.4  17435.6                                                                                                                                                                                                                                                  \n",
    "     84   3909.5   4757.4   5605.3   6609.8   7946.4  12702.8                                                                                                                                                                                                                                                  \n",
    "     85   3909.5   4757.4   5605.3   6609.8   7946.4   5395.5                                                                                                                                                                                                                                                  \n",
    "     86   3909.5   4757.4   5605.3   6609.8   7946.4   6443.3                                                                                                                                                                                                                                                  \n",
    "     87   3909.5   4757.4   5605.3   6609.8   7946.4   8762.2                                                                                                                                                                                                                                                  \n",
    "     88   3909.5   4757.4   5605.3   6609.8   7946.4   6049.4                                                                                                                                                                                                                                                  \n",
    "     89   3909.5   4757.4   5605.3   6609.8   7946.4   7207.2                                                                                                                                                                                                                                                  \n",
    "     90   3909.5   4757.4   5605.3   6609.8   7946.4   9196.3                                                                                                                                                                                                                                                  \n",
    "     91   3909.5   4757.4   5605.3   6609.8   7946.4   4838.4                                                                                                                                                                                                                                                  \n",
    "     92   3909.5   4757.4   5605.3   6609.8   7946.4   8336.5                                                                                                                                                                                                                                                  \n",
    "     93   3909.5   4757.4   5605.3   6609.8   7946.4   4751.5                                                                                                                                                                                                                                                  \n",
    "     94   3909.5   4757.4   5605.3   6609.8   7946.4   6451.4                                                                                                                                                                                                                                                  \n",
    "     95   3909.5   4757.4   5605.3   6609.8   7946.4   4200.5                                                                                                                                                                                                                                                  \n",
    "     96   3909.5   4757.4   5605.3   6609.8   7946.4   5896.5                                                                                                                                                                                                                                                  \n",
    "     97   3909.5   4757.4   5605.3   6609.8   7946.4  19066.1                                                                                                                                                                                                                                                  \n",
    "     98   3909.5   4757.4   5605.3   6609.8   7946.4   4909.5                                                                                                                                                                                                                                                  \n",
    "     99   3909.5   4757.4   5605.3   6609.8   7946.4   3504.5                                                                                                                                                                                                                                                  \n",
    "    100   3909.5   4757.4   5605.3   6609.8   7946.4   6173.2                                                                                                                                                                                                                                                  \n",
    "    101   3909.5   4757.4   5605.3   6609.8   7946.4   9537.1                                                                                                                                                                                                                                                  \n",
    "    102   3909.5   4757.4   5605.3   6609.8   7946.4   8480.2                                                                                                                                                                                                                                                  \n",
    "    103   3909.5   4757.4   5605.3   6609.8   7946.4   9014.1                                                                                                                                                                                                                                                  \n",
    "    104   3909.5   4757.4   5605.3   6609.8   7946.4   9459.2                                                                                                                                                                                                                                                  \n",
    "    105   3909.5   4757.4   5605.3   6609.8   7946.4   4878.9                                                                                                                                                                                                                                                  \n",
    "    106   3909.5   4757.4   5605.3   6609.8   7946.4   5054.0                                                                                                                                                                                                                                                  \n",
    "    107   3909.5   4757.4   5605.3   6609.8   7946.4   4518.7                                                                                                                                                                                                                                                  \n",
    "    108   3909.5   4757.4   5605.3   6609.8   7946.4   5462.5                                                                                                                                                                                                                                                  \n",
    "    109   3909.5   4757.4   5605.3   6609.8   7946.4   6216.2                                                                                                                                                                                                                                                  \n",
    "    110   3909.5   4757.4   5605.3   6609.8   7946.4   9345.5                                                                                                                                                                                                                                                  \n",
    "    111   3909.5   4757.4   5605.3   6609.8   7946.4  17501.3                                                                                                                                                                                                                                                  \n",
    "    112   3909.5   4757.4   5605.3   6609.8   7946.4   4365.4                                                                                                                                                                                                                                                  \n",
    "    113   3909.5   4757.4   5605.3   6609.8   7946.4   8638.5                                                                                                                                                                                                                                                  \n",
    "    114   3909.5   4757.4   5605.3   6609.8   7946.4  12296.4                                                                                                                                                                                                                                                  \n",
    "    115   3909.5   4757.4   5605.3   6609.8   7946.4   7449.1                                                                                                                                                                                                                                                  \n",
    "    116   3909.5   4757.4   5605.3   6609.8   7946.4   5014.6                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:    6 - MADEIRA   / SUBSISTEMA:    1 - SE\n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   7397.5   7923.9   8402.3   9014.4   9480.6  11116.6                                                                                                                                                                                                                                                  \n",
    "      2   7397.5   7923.9   8402.3   9014.4   9480.6   9920.7                                                                                                                                                                                                                                                  \n",
    "      3   7397.5   7923.9   8402.3   9014.4   9480.6   9523.9                                                                                                                                                                                                                                                  \n",
    "      4   7397.5   7923.9   8402.3   9014.4   9480.6  10592.5                                                                                                                                                                                                                                                  \n",
    "      5   7397.5   7923.9   8402.3   9014.4   9480.6  10099.7                                                                                                                                                                                                                                                  \n",
    "      6   7397.5   7923.9   8402.3   9014.4   9480.6  10771.6                                                                                                                                                                                                                                                  \n",
    "      7   7397.5   7923.9   8402.3   9014.4   9480.6  11019.9                                                                                                                                                                                                                                                  \n",
    "      8   7397.5   7923.9   8402.3   9014.4   9480.6  10145.2                                                                                                                                                                                                                                                  \n",
    "      9   7397.5   7923.9   8402.3   9014.4   9480.6  11695.7                                                                                                                                                                                                                                                  \n",
    "     10   7397.5   7923.9   8402.3   9014.4   9480.6   8693.8                                                                                                                                                                                                                                                  \n",
    "     11   7397.5   7923.9   8402.3   9014.4   9480.6  10080.8                                                                                                                                                                                                                                                  \n",
    "     12   7397.5   7923.9   8402.3   9014.4   9480.6   9524.4                                                                                                                                                                                                                                                  \n",
    "     13   7397.5   7923.9   8402.3   9014.4   9480.6  10611.9                                                                                                                                                                                                                                                  \n",
    "     14   7397.5   7923.9   8402.3   9014.4   9480.6   9389.1                                                                                                                                                                                                                                                  \n",
    "     15   7397.5   7923.9   8402.3   9014.4   9480.6   9606.7                                                                                                                                                                                                                                                  \n",
    "     16   7397.5   7923.9   8402.3   9014.4   9480.6  10518.3                                                                                                                                                                                                                                                  \n",
    "     17   7397.5   7923.9   8402.3   9014.4   9480.6  10139.1                                                                                                                                                                                                                                                  \n",
    "     18   7397.5   7923.9   8402.3   9014.4   9480.6  10483.4                                                                                                                                                                                                                                                  \n",
    "     19   7397.5   7923.9   8402.3   9014.4   9480.6  10675.2                                                                                                                                                                                                                                                  \n",
    "     20   7397.5   7923.9   8402.3   9014.4   9480.6   9278.0                                                                                                                                                                                                                                                  \n",
    "     21   7397.5   7923.9   8402.3   9014.4   9480.6  10676.4                                                                                                                                                                                                                                                  \n",
    "     22   7397.5   7923.9   8402.3   9014.4   9480.6  10315.5                                                                                                                                                                                                                                                  \n",
    "     23   7397.5   7923.9   8402.3   9014.4   9480.6  10935.7                                                                                                                                                                                                                                                  \n",
    "     24   7397.5   7923.9   8402.3   9014.4   9480.6   9980.8                                                                                                                                                                                                                                                  \n",
    "     25   7397.5   7923.9   8402.3   9014.4   9480.6   8839.6                                                                                                                                                                                                                                                  \n",
    "     26   7397.5   7923.9   8402.3   9014.4   9480.6   9810.5                                                                                                                                                                                                                                                  \n",
    "     27   7397.5   7923.9   8402.3   9014.4   9480.6  11239.6                                                                                                                                                                                                                                                  \n",
    "     28   7397.5   7923.9   8402.3   9014.4   9480.6   9912.4                                                                                                                                                                                                                                                  \n",
    "     29   7397.5   7923.9   8402.3   9014.4   9480.6  10469.0                                                                                                                                                                                                                                                  \n",
    "     30   7397.5   7923.9   8402.3   9014.4   9480.6   9173.5                                                                                                                                                                                                                                                  \n",
    "     31   7397.5   7923.9   8402.3   9014.4   9480.6  10394.1                                                                                                                                                                                                                                                  \n",
    "     32   7397.5   7923.9   8402.3   9014.4   9480.6  10392.8                                                                                                                                                                                                                                                  \n",
    "     33   7397.5   7923.9   8402.3   9014.4   9480.6   9145.5                                                                                                                                                                                                                                                  \n",
    "     34   7397.5   7923.9   8402.3   9014.4   9480.6   9767.6                                                                                                                                                                                                                                                  \n",
    "     35   7397.5   7923.9   8402.3   9014.4   9480.6  11914.7                                                                                                                                                                                                                                                  \n",
    "     36   7397.5   7923.9   8402.3   9014.4   9480.6   9474.3                                                                                                                                                                                                                                                  \n",
    "     37   7397.5   7923.9   8402.3   9014.4   9480.6   9850.7                                                                                                                                                                                                                                                  \n",
    "     38   7397.5   7923.9   8402.3   9014.4   9480.6  10259.1                                                                                                                                                                                                                                                  \n",
    "     39   7397.5   7923.9   8402.3   9014.4   9480.6   9297.8                                                                                                                                                                                                                                                  \n",
    "     40   7397.5   7923.9   8402.3   9014.4   9480.6   9274.6                                                                                                                                                                                                                                                  \n",
    "     41   7397.5   7923.9   8402.3   9014.4   9480.6  10156.6                                                                                                                                                                                                                                                  \n",
    "     42   7397.5   7923.9   8402.3   9014.4   9480.6  10139.7                                                                                                                                                                                                                                                  \n",
    "     43   7397.5   7923.9   8402.3   9014.4   9480.6  10964.8                                                                                                                                                                                                                                                  \n",
    "     44   7397.5   7923.9   8402.3   9014.4   9480.6   9599.1                                                                                                                                                                                                                                                  \n",
    "     45   7397.5   7923.9   8402.3   9014.4   9480.6   8595.3                                                                                                                                                                                                                                                  \n",
    "     46   7397.5   7923.9   8402.3   9014.4   9480.6   9797.4                                                                                                                                                                                                                                                  \n",
    "     47   7397.5   7923.9   8402.3   9014.4   9480.6   9094.5                                                                                                                                                                                                                                                  \n",
    "     48   7397.5   7923.9   8402.3   9014.4   9480.6   9734.4                                                                                                                                                                                                                                                  \n",
    "     49   7397.5   7923.9   8402.3   9014.4   9480.6  10995.6                                                                                                                                                                                                                                                  \n",
    "     50   7397.5   7923.9   8402.3   9014.4   9480.6  10319.5                                                                                                                                                                                                                                                  \n",
    "     51   7397.5   7923.9   8402.3   9014.4   9480.6   9900.7                                                                                                                                                                                                                                                  \n",
    "     52   7397.5   7923.9   8402.3   9014.4   9480.6  10813.6                                                                                                                                                                                                                                                  \n",
    "     53   7397.5   7923.9   8402.3   9014.4   9480.6   9373.7                                                                                                                                                                                                                                                  \n",
    "     54   7397.5   7923.9   8402.3   9014.4   9480.6   9620.2                                                                                                                                                                                                                                                  \n",
    "     55   7397.5   7923.9   8402.3   9014.4   9480.6   8630.5                                                                                                                                                                                                                                                  \n",
    "     56   7397.5   7923.9   8402.3   9014.4   9480.6  10309.4                                                                                                                                                                                                                                                  \n",
    "     57   7397.5   7923.9   8402.3   9014.4   9480.6  10517.9                                                                                                                                                                                                                                                  \n",
    "     58   7397.5   7923.9   8402.3   9014.4   9480.6  10588.7                                                                                                                                                                                                                                                  \n",
    "     59   7397.5   7923.9   8402.3   9014.4   9480.6  10231.8                                                                                                                                                                                                                                                  \n",
    "     60   7397.5   7923.9   8402.3   9014.4   9480.6   9995.2                                                                                                                                                                                                                                                  \n",
    "     61   7397.5   7923.9   8402.3   9014.4   9480.6  10828.7                                                                                                                                                                                                                                                  \n",
    "     62   7397.5   7923.9   8402.3   9014.4   9480.6   9705.7                                                                                                                                                                                                                                                  \n",
    "     63   7397.5   7923.9   8402.3   9014.4   9480.6   9122.6                                                                                                                                                                                                                                                  \n",
    "     64   7397.5   7923.9   8402.3   9014.4   9480.6  10877.2                                                                                                                                                                                                                                                  \n",
    "     65   7397.5   7923.9   8402.3   9014.4   9480.6  10466.6                                                                                                                                                                                                                                                  \n",
    "     66   7397.5   7923.9   8402.3   9014.4   9480.6   9688.3                                                                                                                                                                                                                                                  \n",
    "     67   7397.5   7923.9   8402.3   9014.4   9480.6  10580.7                                                                                                                                                                                                                                                  \n",
    "     68   7397.5   7923.9   8402.3   9014.4   9480.6   9733.4                                                                                                                                                                                                                                                  \n",
    "     69   7397.5   7923.9   8402.3   9014.4   9480.6  11178.8                                                                                                                                                                                                                                                  \n",
    "     70   7397.5   7923.9   8402.3   9014.4   9480.6   9065.1                                                                                                                                                                                                                                                  \n",
    "     71   7397.5   7923.9   8402.3   9014.4   9480.6  10600.1                                                                                                                                                                                                                                                  \n",
    "     72   7397.5   7923.9   8402.3   9014.4   9480.6   9507.2                                                                                                                                                                                                                                                  \n",
    "     73   7397.5   7923.9   8402.3   9014.4   9480.6  10232.0                                                                                                                                                                                                                                                  \n",
    "     74   7397.5   7923.9   8402.3   9014.4   9480.6   9695.9                                                                                                                                                                                                                                                  \n",
    "     75   7397.5   7923.9   8402.3   9014.4   9480.6   9727.6                                                                                                                                                                                                                                                  \n",
    "     76   7397.5   7923.9   8402.3   9014.4   9480.6  10589.2                                                                                                                                                                                                                                                  \n",
    "     77   7397.5   7923.9   8402.3   9014.4   9480.6  10050.3                                                                                                                                                                                                                                                  \n",
    "     78   7397.5   7923.9   8402.3   9014.4   9480.6  11188.2                                                                                                                                                                                                                                                  \n",
    "     79   7397.5   7923.9   8402.3   9014.4   9480.6  10234.1                                                                                                                                                                                                                                                  \n",
    "     80   7397.5   7923.9   8402.3   9014.4   9480.6  10832.7                                                                                                                                                                                                                                                  \n",
    "     81   7397.5   7923.9   8402.3   9014.4   9480.6   9310.0                                                                                                                                                                                                                                                  \n",
    "     82   7397.5   7923.9   8402.3   9014.4   9480.6   9614.2                                                                                                                                                                                                                                                  \n",
    "     83   7397.5   7923.9   8402.3   9014.4   9480.6  11282.7                                                                                                                                                                                                                                                  \n",
    "     84   7397.5   7923.9   8402.3   9014.4   9480.6   8846.9                                                                                                                                                                                                                                                  \n",
    "     85   7397.5   7923.9   8402.3   9014.4   9480.6   9874.3                                                                                                                                                                                                                                                  \n",
    "     86   7397.5   7923.9   8402.3   9014.4   9480.6  10784.2                                                                                                                                                                                                                                                  \n",
    "     87   7397.5   7923.9   8402.3   9014.4   9480.6  10188.6                                                                                                                                                                                                                                                  \n",
    "     88   7397.5   7923.9   8402.3   9014.4   9480.6   8558.4                                                                                                                                                                                                                                                  \n",
    "     89   7397.5   7923.9   8402.3   9014.4   9480.6   9500.0                                                                                                                                                                                                                                                  \n",
    "     90   7397.5   7923.9   8402.3   9014.4   9480.6   8433.5                                                                                                                                                                                                                                                  \n",
    "     91   7397.5   7923.9   8402.3   9014.4   9480.6  10007.1                                                                                                                                                                                                                                                  \n",
    "     92   7397.5   7923.9   8402.3   9014.4   9480.6  11633.0                                                                                                                                                                                                                                                  \n",
    "     93   7397.5   7923.9   8402.3   9014.4   9480.6  11194.0                                                                                                                                                                                                                                                  \n",
    "     94   7397.5   7923.9   8402.3   9014.4   9480.6  10787.6                                                                                                                                                                                                                                                  \n",
    "     95   7397.5   7923.9   8402.3   9014.4   9480.6   9634.5                                                                                                                                                                                                                                                  \n",
    "     96   7397.5   7923.9   8402.3   9014.4   9480.6   9522.7                                                                                                                                                                                                                                                  \n",
    "     97   7397.5   7923.9   8402.3   9014.4   9480.6   9599.5                                                                                                                                                                                                                                                  \n",
    "     98   7397.5   7923.9   8402.3   9014.4   9480.6   9145.3                                                                                                                                                                                                                                                  \n",
    "     99   7397.5   7923.9   8402.3   9014.4   9480.6  10446.7                                                                                                                                                                                                                                                  \n",
    "    100   7397.5   7923.9   8402.3   9014.4   9480.6   9859.5                                                                                                                                                                                                                                                  \n",
    "    101   7397.5   7923.9   8402.3   9014.4   9480.6  10016.3                                                                                                                                                                                                                                                  \n",
    "    102   7397.5   7923.9   8402.3   9014.4   9480.6   8339.2                                                                                                                                                                                                                                                  \n",
    "    103   7397.5   7923.9   8402.3   9014.4   9480.6   9770.6                                                                                                                                                                                                                                                  \n",
    "    104   7397.5   7923.9   8402.3   9014.4   9480.6  10972.3                                                                                                                                                                                                                                                  \n",
    "    105   7397.5   7923.9   8402.3   9014.4   9480.6   9818.6                                                                                                                                                                                                                                                  \n",
    "    106   7397.5   7923.9   8402.3   9014.4   9480.6   8345.6                                                                                                                                                                                                                                                  \n",
    "    107   7397.5   7923.9   8402.3   9014.4   9480.6   9694.0                                                                                                                                                                                                                                                  \n",
    "    108   7397.5   7923.9   8402.3   9014.4   9480.6   9696.2                                                                                                                                                                                                                                                  \n",
    "    109   7397.5   7923.9   8402.3   9014.4   9480.6   8700.7                                                                                                                                                                                                                                                  \n",
    "    110   7397.5   7923.9   8402.3   9014.4   9480.6  10114.6                                                                                                                                                                                                                                                  \n",
    "    111   7397.5   7923.9   8402.3   9014.4   9480.6   9698.7                                                                                                                                                                                                                                                  \n",
    "    112   7397.5   7923.9   8402.3   9014.4   9480.6  10468.4                                                                                                                                                                                                                                                  \n",
    "    113   7397.5   7923.9   8402.3   9014.4   9480.6   9943.0                                                                                                                                                                                                                                                  \n",
    "    114   7397.5   7923.9   8402.3   9014.4   9480.6   8951.5                                                                                                                                                                                                                                                  \n",
    "    115   7397.5   7923.9   8402.3   9014.4   9480.6   9553.7                                                                                                                                                                                                                                                  \n",
    "    116   7397.5   7923.9   8402.3   9014.4   9480.6  10399.7                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:    7 - TPIRES    / SUBSISTEMA:    1 - SE\n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   2292.1   2634.9   2940.0   3268.8   3434.9   3161.3                                                                                                                                                                                                                                                  \n",
    "      2   2292.1   2634.9   2940.0   3268.8   3434.9   3585.9                                                                                                                                                                                                                                                  \n",
    "      3   2292.1   2634.9   2940.0   3268.8   3434.9   3227.7                                                                                                                                                                                                                                                  \n",
    "      4   2292.1   2634.9   2940.0   3268.8   3434.9   2703.5                                                                                                                                                                                                                                                  \n",
    "      5   2292.1   2634.9   2940.0   3268.8   3434.9   3140.9                                                                                                                                                                                                                                                  \n",
    "      6   2292.1   2634.9   2940.0   3268.8   3434.9   3885.8                                                                                                                                                                                                                                                  \n",
    "      7   2292.1   2634.9   2940.0   3268.8   3434.9   3476.6                                                                                                                                                                                                                                                  \n",
    "      8   2292.1   2634.9   2940.0   3268.8   3434.9   2701.0                                                                                                                                                                                                                                                  \n",
    "      9   2292.1   2634.9   2940.0   3268.8   3434.9   3590.9                                                                                                                                                                                                                                                  \n",
    "     10   2292.1   2634.9   2940.0   3268.8   3434.9   2711.0                                                                                                                                                                                                                                                  \n",
    "     11   2292.1   2634.9   2940.0   3268.8   3434.9   4549.9                                                                                                                                                                                                                                                  \n",
    "     12   2292.1   2634.9   2940.0   3268.8   3434.9   3506.3                                                                                                                                                                                                                                                  \n",
    "     13   2292.1   2634.9   2940.0   3268.8   3434.9   3699.2                                                                                                                                                                                                                                                  \n",
    "     14   2292.1   2634.9   2940.0   3268.8   3434.9   3072.6                                                                                                                                                                                                                                                  \n",
    "     15   2292.1   2634.9   2940.0   3268.8   3434.9   2767.7                                                                                                                                                                                                                                                  \n",
    "     16   2292.1   2634.9   2940.0   3268.8   3434.9   3606.3                                                                                                                                                                                                                                                  \n",
    "     17   2292.1   2634.9   2940.0   3268.8   3434.9   3483.5                                                                                                                                                                                                                                                  \n",
    "     18   2292.1   2634.9   2940.0   3268.8   3434.9   2602.5                                                                                                                                                                                                                                                  \n",
    "     19   2292.1   2634.9   2940.0   3268.8   3434.9   3465.3                                                                                                                                                                                                                                                  \n",
    "     20   2292.1   2634.9   2940.0   3268.8   3434.9   4131.7                                                                                                                                                                                                                                                  \n",
    "     21   2292.1   2634.9   2940.0   3268.8   3434.9   4015.1                                                                                                                                                                                                                                                  \n",
    "     22   2292.1   2634.9   2940.0   3268.8   3434.9   4350.0                                                                                                                                                                                                                                                  \n",
    "     23   2292.1   2634.9   2940.0   3268.8   3434.9   3995.3                                                                                                                                                                                                                                                  \n",
    "     24   2292.1   2634.9   2940.0   3268.8   3434.9   3913.1                                                                                                                                                                                                                                                  \n",
    "     25   2292.1   2634.9   2940.0   3268.8   3434.9   3397.1                                                                                                                                                                                                                                                  \n",
    "     26   2292.1   2634.9   2940.0   3268.8   3434.9   3349.7                                                                                                                                                                                                                                                  \n",
    "     27   2292.1   2634.9   2940.0   3268.8   3434.9   3592.3                                                                                                                                                                                                                                                  \n",
    "     28   2292.1   2634.9   2940.0   3268.8   3434.9   4425.9                                                                                                                                                                                                                                                  \n",
    "     29   2292.1   2634.9   2940.0   3268.8   3434.9   4608.4                                                                                                                                                                                                                                                  \n",
    "     30   2292.1   2634.9   2940.0   3268.8   3434.9   3856.7                                                                                                                                                                                                                                                  \n",
    "     31   2292.1   2634.9   2940.0   3268.8   3434.9   4326.0                                                                                                                                                                                                                                                  \n",
    "     32   2292.1   2634.9   2940.0   3268.8   3434.9   3530.5                                                                                                                                                                                                                                                  \n",
    "     33   2292.1   2634.9   2940.0   3268.8   3434.9   3170.2                                                                                                                                                                                                                                                  \n",
    "     34   2292.1   2634.9   2940.0   3268.8   3434.9   2290.6                                                                                                                                                                                                                                                  \n",
    "     35   2292.1   2634.9   2940.0   3268.8   3434.9   3415.6                                                                                                                                                                                                                                                  \n",
    "     36   2292.1   2634.9   2940.0   3268.8   3434.9   3810.0                                                                                                                                                                                                                                                  \n",
    "     37   2292.1   2634.9   2940.0   3268.8   3434.9   3296.8                                                                                                                                                                                                                                                  \n",
    "     38   2292.1   2634.9   2940.0   3268.8   3434.9   3301.9                                                                                                                                                                                                                                                  \n",
    "     39   2292.1   2634.9   2940.0   3268.8   3434.9   4055.1                                                                                                                                                                                                                                                  \n",
    "     40   2292.1   2634.9   2940.0   3268.8   3434.9   2762.2                                                                                                                                                                                                                                                  \n",
    "     41   2292.1   2634.9   2940.0   3268.8   3434.9   3798.5                                                                                                                                                                                                                                                  \n",
    "     42   2292.1   2634.9   2940.0   3268.8   3434.9   2664.5                                                                                                                                                                                                                                                  \n",
    "     43   2292.1   2634.9   2940.0   3268.8   3434.9   2677.8                                                                                                                                                                                                                                                  \n",
    "     44   2292.1   2634.9   2940.0   3268.8   3434.9   2738.7                                                                                                                                                                                                                                                  \n",
    "     45   2292.1   2634.9   2940.0   3268.8   3434.9   2948.1                                                                                                                                                                                                                                                  \n",
    "     46   2292.1   2634.9   2940.0   3268.8   3434.9   4140.4                                                                                                                                                                                                                                                  \n",
    "     47   2292.1   2634.9   2940.0   3268.8   3434.9   3446.7                                                                                                                                                                                                                                                  \n",
    "     48   2292.1   2634.9   2940.0   3268.8   3434.9   3429.6                                                                                                                                                                                                                                                  \n",
    "     49   2292.1   2634.9   2940.0   3268.8   3434.9   3367.2                                                                                                                                                                                                                                                  \n",
    "     50   2292.1   2634.9   2940.0   3268.8   3434.9   4058.2                                                                                                                                                                                                                                                  \n",
    "     51   2292.1   2634.9   2940.0   3268.8   3434.9   3311.5                                                                                                                                                                                                                                                  \n",
    "     52   2292.1   2634.9   2940.0   3268.8   3434.9   4349.9                                                                                                                                                                                                                                                  \n",
    "     53   2292.1   2634.9   2940.0   3268.8   3434.9   3506.5                                                                                                                                                                                                                                                  \n",
    "     54   2292.1   2634.9   2940.0   3268.8   3434.9   3941.1                                                                                                                                                                                                                                                  \n",
    "     55   2292.1   2634.9   2940.0   3268.8   3434.9   2925.5                                                                                                                                                                                                                                                  \n",
    "     56   2292.1   2634.9   2940.0   3268.8   3434.9   3452.4                                                                                                                                                                                                                                                  \n",
    "     57   2292.1   2634.9   2940.0   3268.8   3434.9   3291.6                                                                                                                                                                                                                                                  \n",
    "     58   2292.1   2634.9   2940.0   3268.8   3434.9   3642.0                                                                                                                                                                                                                                                  \n",
    "     59   2292.1   2634.9   2940.0   3268.8   3434.9   3854.2                                                                                                                                                                                                                                                  \n",
    "     60   2292.1   2634.9   2940.0   3268.8   3434.9   4063.9                                                                                                                                                                                                                                                  \n",
    "     61   2292.1   2634.9   2940.0   3268.8   3434.9   3689.0                                                                                                                                                                                                                                                  \n",
    "     62   2292.1   2634.9   2940.0   3268.8   3434.9   3199.1                                                                                                                                                                                                                                                  \n",
    "     63   2292.1   2634.9   2940.0   3268.8   3434.9   3109.0                                                                                                                                                                                                                                                  \n",
    "     64   2292.1   2634.9   2940.0   3268.8   3434.9   3924.9                                                                                                                                                                                                                                                  \n",
    "     65   2292.1   2634.9   2940.0   3268.8   3434.9   3127.7                                                                                                                                                                                                                                                  \n",
    "     66   2292.1   2634.9   2940.0   3268.8   3434.9   3742.0                                                                                                                                                                                                                                                  \n",
    "     67   2292.1   2634.9   2940.0   3268.8   3434.9   3541.0                                                                                                                                                                                                                                                  \n",
    "     68   2292.1   2634.9   2940.0   3268.8   3434.9   2744.4                                                                                                                                                                                                                                                  \n",
    "     69   2292.1   2634.9   2940.0   3268.8   3434.9   3154.0                                                                                                                                                                                                                                                  \n",
    "     70   2292.1   2634.9   2940.0   3268.8   3434.9   3318.7                                                                                                                                                                                                                                                  \n",
    "     71   2292.1   2634.9   2940.0   3268.8   3434.9   3996.8                                                                                                                                                                                                                                                  \n",
    "     72   2292.1   2634.9   2940.0   3268.8   3434.9   4308.2                                                                                                                                                                                                                                                  \n",
    "     73   2292.1   2634.9   2940.0   3268.8   3434.9   2631.3                                                                                                                                                                                                                                                  \n",
    "     74   2292.1   2634.9   2940.0   3268.8   3434.9   3680.9                                                                                                                                                                                                                                                  \n",
    "     75   2292.1   2634.9   2940.0   3268.8   3434.9   2650.6                                                                                                                                                                                                                                                  \n",
    "     76   2292.1   2634.9   2940.0   3268.8   3434.9   3967.1                                                                                                                                                                                                                                                  \n",
    "     77   2292.1   2634.9   2940.0   3268.8   3434.9   3679.8                                                                                                                                                                                                                                                  \n",
    "     78   2292.1   2634.9   2940.0   3268.8   3434.9   3377.2                                                                                                                                                                                                                                                  \n",
    "     79   2292.1   2634.9   2940.0   3268.8   3434.9   4615.2                                                                                                                                                                                                                                                  \n",
    "     80   2292.1   2634.9   2940.0   3268.8   3434.9   2868.1                                                                                                                                                                                                                                                  \n",
    "     81   2292.1   2634.9   2940.0   3268.8   3434.9   2967.3                                                                                                                                                                                                                                                  \n",
    "     82   2292.1   2634.9   2940.0   3268.8   3434.9   3190.1                                                                                                                                                                                                                                                  \n",
    "     83   2292.1   2634.9   2940.0   3268.8   3434.9   4905.4                                                                                                                                                                                                                                                  \n",
    "     84   2292.1   2634.9   2940.0   3268.8   3434.9   2729.6                                                                                                                                                                                                                                                  \n",
    "     85   2292.1   2634.9   2940.0   3268.8   3434.9   3397.3                                                                                                                                                                                                                                                  \n",
    "     86   2292.1   2634.9   2940.0   3268.8   3434.9   3830.7                                                                                                                                                                                                                                                  \n",
    "     87   2292.1   2634.9   2940.0   3268.8   3434.9   4249.4                                                                                                                                                                                                                                                  \n",
    "     88   2292.1   2634.9   2940.0   3268.8   3434.9   3028.7                                                                                                                                                                                                                                                  \n",
    "     89   2292.1   2634.9   2940.0   3268.8   3434.9   3287.6                                                                                                                                                                                                                                                  \n",
    "     90   2292.1   2634.9   2940.0   3268.8   3434.9   3735.2                                                                                                                                                                                                                                                  \n",
    "     91   2292.1   2634.9   2940.0   3268.8   3434.9   2752.6                                                                                                                                                                                                                                                  \n",
    "     92   2292.1   2634.9   2940.0   3268.8   3434.9   4390.1                                                                                                                                                                                                                                                  \n",
    "     93   2292.1   2634.9   2940.0   3268.8   3434.9   3862.2                                                                                                                                                                                                                                                  \n",
    "     94   2292.1   2634.9   2940.0   3268.8   3434.9   3728.8                                                                                                                                                                                                                                                  \n",
    "     95   2292.1   2634.9   2940.0   3268.8   3434.9   2793.9                                                                                                                                                                                                                                                  \n",
    "     96   2292.1   2634.9   2940.0   3268.8   3434.9   2949.8                                                                                                                                                                                                                                                  \n",
    "     97   2292.1   2634.9   2940.0   3268.8   3434.9   3676.7                                                                                                                                                                                                                                                  \n",
    "     98   2292.1   2634.9   2940.0   3268.8   3434.9   4146.8                                                                                                                                                                                                                                                  \n",
    "     99   2292.1   2634.9   2940.0   3268.8   3434.9   2423.9                                                                                                                                                                                                                                                  \n",
    "    100   2292.1   2634.9   2940.0   3268.8   3434.9   4121.8                                                                                                                                                                                                                                                  \n",
    "    101   2292.1   2634.9   2940.0   3268.8   3434.9   3611.0                                                                                                                                                                                                                                                  \n",
    "    102   2292.1   2634.9   2940.0   3268.8   3434.9   2568.0                                                                                                                                                                                                                                                  \n",
    "    103   2292.1   2634.9   2940.0   3268.8   3434.9   2803.5                                                                                                                                                                                                                                                  \n",
    "    104   2292.1   2634.9   2940.0   3268.8   3434.9   3675.1                                                                                                                                                                                                                                                  \n",
    "    105   2292.1   2634.9   2940.0   3268.8   3434.9   3244.8                                                                                                                                                                                                                                                  \n",
    "    106   2292.1   2634.9   2940.0   3268.8   3434.9   2547.2                                                                                                                                                                                                                                                  \n",
    "    107   2292.1   2634.9   2940.0   3268.8   3434.9   4293.1                                                                                                                                                                                                                                                  \n",
    "    108   2292.1   2634.9   2940.0   3268.8   3434.9   3811.4                                                                                                                                                                                                                                                  \n",
    "    109   2292.1   2634.9   2940.0   3268.8   3434.9   2134.3                                                                                                                                                                                                                                                  \n",
    "    110   2292.1   2634.9   2940.0   3268.8   3434.9   2971.5                                                                                                                                                                                                                                                  \n",
    "    111   2292.1   2634.9   2940.0   3268.8   3434.9   4705.7                                                                                                                                                                                                                                                  \n",
    "    112   2292.1   2634.9   2940.0   3268.8   3434.9   3394.9                                                                                                                                                                                                                                                  \n",
    "    113   2292.1   2634.9   2940.0   3268.8   3434.9   3642.1                                                                                                                                                                                                                                                  \n",
    "    114   2292.1   2634.9   2940.0   3268.8   3434.9   2883.1                                                                                                                                                                                                                                                  \n",
    "    115   2292.1   2634.9   2940.0   3268.8   3434.9   2926.4                                                                                                                                                                                                                                                  \n",
    "    116   2292.1   2634.9   2940.0   3268.8   3434.9   4333.2                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:    5 - ITAIPU    / SUBSISTEMA:    1 - SE\n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   4990.5   4886.7   4205.2   4457.0   4459.1   5083.0                                                                                                                                                                                                                                                  \n",
    "      2   4990.5   4886.7   4205.2   4457.0   4459.1   6902.4                                                                                                                                                                                                                                                  \n",
    "      3   4990.5   4886.7   4205.2   4457.0   4459.1   6242.5                                                                                                                                                                                                                                                  \n",
    "      4   4990.5   4886.7   4205.2   4457.0   4459.1   5420.2                                                                                                                                                                                                                                                  \n",
    "      5   4990.5   4886.7   4205.2   4457.0   4459.1   2924.4                                                                                                                                                                                                                                                  \n",
    "      6   4990.5   4886.7   4205.2   4457.0   4459.1   5061.4                                                                                                                                                                                                                                                  \n",
    "      7   4990.5   4886.7   4205.2   4457.0   4459.1   7370.1                                                                                                                                                                                                                                                  \n",
    "      8   4990.5   4886.7   4205.2   4457.0   4459.1   5119.0                                                                                                                                                                                                                                                  \n",
    "      9   4990.5   4886.7   4205.2   4457.0   4459.1   7910.8                                                                                                                                                                                                                                                  \n",
    "     10   4990.5   4886.7   4205.2   4457.0   4459.1   5171.4                                                                                                                                                                                                                                                  \n",
    "     11   4990.5   4886.7   4205.2   4457.0   4459.1   2469.0                                                                                                                                                                                                                                                  \n",
    "     12   4990.5   4886.7   4205.2   4457.0   4459.1   3666.6                                                                                                                                                                                                                                                  \n",
    "     13   4990.5   4886.7   4205.2   4457.0   4459.1   3406.5                                                                                                                                                                                                                                                  \n",
    "     14   4990.5   4886.7   4205.2   4457.0   4459.1   8145.2                                                                                                                                                                                                                                                  \n",
    "     15   4990.5   4886.7   4205.2   4457.0   4459.1   4378.9                                                                                                                                                                                                                                                  \n",
    "     16   4990.5   4886.7   4205.2   4457.0   4459.1   3483.6                                                                                                                                                                                                                                                  \n",
    "     17   4990.5   4886.7   4205.2   4457.0   4459.1   5827.2                                                                                                                                                                                                                                                  \n",
    "     18   4990.5   4886.7   4205.2   4457.0   4459.1   3131.0                                                                                                                                                                                                                                                  \n",
    "     19   4990.5   4886.7   4205.2   4457.0   4459.1   3066.3                                                                                                                                                                                                                                                  \n",
    "     20   4990.5   4886.7   4205.2   4457.0   4459.1   5504.5                                                                                                                                                                                                                                                  \n",
    "     21   4990.5   4886.7   4205.2   4457.0   4459.1   5174.5                                                                                                                                                                                                                                                  \n",
    "     22   4990.5   4886.7   4205.2   4457.0   4459.1   2866.8                                                                                                                                                                                                                                                  \n",
    "     23   4990.5   4886.7   4205.2   4457.0   4459.1   6563.2                                                                                                                                                                                                                                                  \n",
    "     24   4990.5   4886.7   4205.2   4457.0   4459.1   3501.1                                                                                                                                                                                                                                                  \n",
    "     25   4990.5   4886.7   4205.2   4457.0   4459.1   6472.7                                                                                                                                                                                                                                                  \n",
    "     26   4990.5   4886.7   4205.2   4457.0   4459.1   5521.9                                                                                                                                                                                                                                                  \n",
    "     27   4990.5   4886.7   4205.2   4457.0   4459.1   3150.5                                                                                                                                                                                                                                                  \n",
    "     28   4990.5   4886.7   4205.2   4457.0   4459.1   8936.6                                                                                                                                                                                                                                                  \n",
    "     29   4990.5   4886.7   4205.2   4457.0   4459.1   7932.4                                                                                                                                                                                                                                                  \n",
    "     30   4990.5   4886.7   4205.2   4457.0   4459.1   7097.7                                                                                                                                                                                                                                                  \n",
    "     31   4990.5   4886.7   4205.2   4457.0   4459.1   4142.5                                                                                                                                                                                                                                                  \n",
    "     32   4990.5   4886.7   4205.2   4457.0   4459.1   7580.8                                                                                                                                                                                                                                                  \n",
    "     33   4990.5   4886.7   4205.2   4457.0   4459.1   5311.2                                                                                                                                                                                                                                                  \n",
    "     34   4990.5   4886.7   4205.2   4457.0   4459.1   4244.2                                                                                                                                                                                                                                                  \n",
    "     35   4990.5   4886.7   4205.2   4457.0   4459.1   4665.7                                                                                                                                                                                                                                                  \n",
    "     36   4990.5   4886.7   4205.2   4457.0   4459.1   5308.1                                                                                                                                                                                                                                                  \n",
    "     37   4990.5   4886.7   4205.2   4457.0   4459.1   5541.5                                                                                                                                                                                                                                                  \n",
    "     38   4990.5   4886.7   4205.2   4457.0   4459.1   6614.6                                                                                                                                                                                                                                                  \n",
    "     39   4990.5   4886.7   4205.2   4457.0   4459.1   3558.6                                                                                                                                                                                                                                                  \n",
    "     40   4990.5   4886.7   4205.2   4457.0   4459.1   6372.0                                                                                                                                                                                                                                                  \n",
    "     41   4990.5   4886.7   4205.2   4457.0   4459.1   5655.6                                                                                                                                                                                                                                                  \n",
    "     42   4990.5   4886.7   4205.2   4457.0   4459.1   3412.7                                                                                                                                                                                                                                                  \n",
    "     43   4990.5   4886.7   4205.2   4457.0   4459.1   3550.4                                                                                                                                                                                                                                                  \n",
    "     44   4990.5   4886.7   4205.2   4457.0   4459.1   3313.0                                                                                                                                                                                                                                                  \n",
    "     45   4990.5   4886.7   4205.2   4457.0   4459.1   5625.7                                                                                                                                                                                                                                                  \n",
    "     46   4990.5   4886.7   4205.2   4457.0   4459.1   3506.2                                                                                                                                                                                                                                                  \n",
    "     47   4990.5   4886.7   4205.2   4457.0   4459.1  10440.5                                                                                                                                                                                                                                                  \n",
    "     48   4990.5   4886.7   4205.2   4457.0   4459.1  14222.1                                                                                                                                                                                                                                                  \n",
    "     49   4990.5   4886.7   4205.2   4457.0   4459.1   2732.2                                                                                                                                                                                                                                                  \n",
    "     50   4990.5   4886.7   4205.2   4457.0   4459.1   5259.8                                                                                                                                                                                                                                                  \n",
    "     51   4990.5   4886.7   4205.2   4457.0   4459.1   3546.3                                                                                                                                                                                                                                                  \n",
    "     52   4990.5   4886.7   4205.2   4457.0   4459.1   3661.4                                                                                                                                                                                                                                                  \n",
    "     53   4990.5   4886.7   4205.2   4457.0   4459.1   4438.5                                                                                                                                                                                                                                                  \n",
    "     54   4990.5   4886.7   4205.2   4457.0   4459.1   3461.0                                                                                                                                                                                                                                                  \n",
    "     55   4990.5   4886.7   4205.2   4457.0   4459.1   4886.7                                                                                                                                                                                                                                                  \n",
    "     56   4990.5   4886.7   4205.2   4457.0   4459.1   5158.0                                                                                                                                                                                                                                                  \n",
    "     57   4990.5   4886.7   4205.2   4457.0   4459.1   6818.1                                                                                                                                                                                                                                                  \n",
    "     58   4990.5   4886.7   4205.2   4457.0   4459.1   3345.8                                                                                                                                                                                                                                                  \n",
    "     59   4990.5   4886.7   4205.2   4457.0   4459.1   2509.1                                                                                                                                                                                                                                                  \n",
    "     60   4990.5   4886.7   4205.2   4457.0   4459.1   2968.6                                                                                                                                                                                                                                                  \n",
    "     61   4990.5   4886.7   4205.2   4457.0   4459.1   4893.9                                                                                                                                                                                                                                                  \n",
    "     62   4990.5   4886.7   4205.2   4457.0   4459.1   5607.2                                                                                                                                                                                                                                                  \n",
    "     63   4990.5   4886.7   4205.2   4457.0   4459.1   4039.7                                                                                                                                                                                                                                                  \n",
    "     64   4990.5   4886.7   4205.2   4457.0   4459.1   4642.0                                                                                                                                                                                                                                                  \n",
    "     65   4990.5   4886.7   4205.2   4457.0   4459.1   5447.9                                                                                                                                                                                                                                                  \n",
    "     66   4990.5   4886.7   4205.2   4457.0   4459.1   4670.8                                                                                                                                                                                                                                                  \n",
    "     67   4990.5   4886.7   4205.2   4457.0   4459.1   5957.8                                                                                                                                                                                                                                                  \n",
    "     68   4990.5   4886.7   4205.2   4457.0   4459.1   5839.6                                                                                                                                                                                                                                                  \n",
    "     69   4990.5   4886.7   4205.2   4457.0   4459.1   2614.0                                                                                                                                                                                                                                                  \n",
    "     70   4990.5   4886.7   4205.2   4457.0   4459.1   5358.5                                                                                                                                                                                                                                                  \n",
    "     71   4990.5   4886.7   4205.2   4457.0   4459.1   4853.8                                                                                                                                                                                                                                                  \n",
    "     72   4990.5   4886.7   4205.2   4457.0   4459.1   5771.7                                                                                                                                                                                                                                                  \n",
    "     73   4990.5   4886.7   4205.2   4457.0   4459.1   3725.1                                                                                                                                                                                                                                                  \n",
    "     74   4990.5   4886.7   4205.2   4457.0   4459.1   2597.5                                                                                                                                                                                                                                                  \n",
    "     75   4990.5   4886.7   4205.2   4457.0   4459.1   3568.9                                                                                                                                                                                                                                                  \n",
    "     76   4990.5   4886.7   4205.2   4457.0   4459.1   7424.6                                                                                                                                                                                                                                                  \n",
    "     77   4990.5   4886.7   4205.2   4457.0   4459.1   6478.9                                                                                                                                                                                                                                                  \n",
    "     78   4990.5   4886.7   4205.2   4457.0   4459.1   7294.0                                                                                                                                                                                                                                                  \n",
    "     79   4990.5   4886.7   4205.2   4457.0   4459.1   5051.1                                                                                                                                                                                                                                                  \n",
    "     80   4990.5   4886.7   4205.2   4457.0   4459.1   5794.3                                                                                                                                                                                                                                                  \n",
    "     81   4990.5   4886.7   4205.2   4457.0   4459.1   3306.8                                                                                                                                                                                                                                                  \n",
    "     82   4990.5   4886.7   4205.2   4457.0   4459.1   3763.2                                                                                                                                                                                                                                                  \n",
    "     83   4990.5   4886.7   4205.2   4457.0   4459.1   6064.7                                                                                                                                                                                                                                                  \n",
    "     84   4990.5   4886.7   4205.2   4457.0   4459.1   3351.0                                                                                                                                                                                                                                                  \n",
    "     85   4990.5   4886.7   4205.2   4457.0   4459.1   3857.7                                                                                                                                                                                                                                                  \n",
    "     86   4990.5   4886.7   4205.2   4457.0   4459.1   3785.8                                                                                                                                                                                                                                                  \n",
    "     87   4990.5   4886.7   4205.2   4457.0   4459.1   4404.6                                                                                                                                                                                                                                                  \n",
    "     88   4990.5   4886.7   4205.2   4457.0   4459.1   3742.6                                                                                                                                                                                                                                                  \n",
    "     89   4990.5   4886.7   4205.2   4457.0   4459.1   4682.1                                                                                                                                                                                                                                                  \n",
    "     90   4990.5   4886.7   4205.2   4457.0   4459.1   5470.5                                                                                                                                                                                                                                                  \n",
    "     91   4990.5   4886.7   4205.2   4457.0   4459.1   5644.2                                                                                                                                                                                                                                                  \n",
    "     92   4990.5   4886.7   4205.2   4457.0   4459.1   3377.7                                                                                                                                                                                                                                                  \n",
    "     93   4990.5   4886.7   4205.2   4457.0   4459.1   4744.8                                                                                                                                                                                                                                                  \n",
    "     94   4990.5   4886.7   4205.2   4457.0   4459.1   4959.7                                                                                                                                                                                                                                                  \n",
    "     95   4990.5   4886.7   4205.2   4457.0   4459.1   4577.3                                                                                                                                                                                                                                                  \n",
    "     96   4990.5   4886.7   4205.2   4457.0   4459.1   3872.1                                                                                                                                                                                                                                                  \n",
    "     97   4990.5   4886.7   4205.2   4457.0   4459.1   2988.1                                                                                                                                                                                                                                                  \n",
    "     98   4990.5   4886.7   4205.2   4457.0   4459.1   9734.3                                                                                                                                                                                                                                                  \n",
    "     99   4990.5   4886.7   4205.2   4457.0   4459.1   6757.5                                                                                                                                                                                                                                                  \n",
    "    100   4990.5   4886.7   4205.2   4457.0   4459.1   2656.1                                                                                                                                                                                                                                                  \n",
    "    101   4990.5   4886.7   4205.2   4457.0   4459.1   6165.4                                                                                                                                                                                                                                                  \n",
    "    102   4990.5   4886.7   4205.2   4457.0   4459.1   4309.0                                                                                                                                                                                                                                                  \n",
    "    103   4990.5   4886.7   4205.2   4457.0   4459.1   5306.1                                                                                                                                                                                                                                                  \n",
    "    104   4990.5   4886.7   4205.2   4457.0   4459.1   3690.2                                                                                                                                                                                                                                                  \n",
    "    105   4990.5   4886.7   4205.2   4457.0   4459.1   6364.8                                                                                                                                                                                                                                                  \n",
    "    106   4990.5   4886.7   4205.2   4457.0   4459.1   4746.9                                                                                                                                                                                                                                                  \n",
    "    107   4990.5   4886.7   4205.2   4457.0   4459.1   3805.3                                                                                                                                                                                                                                                  \n",
    "    108   4990.5   4886.7   4205.2   4457.0   4459.1   5178.6                                                                                                                                                                                                                                                  \n",
    "    109   4990.5   4886.7   4205.2   4457.0   4459.1   4874.3                                                                                                                                                                                                                                                  \n",
    "    110   4990.5   4886.7   4205.2   4457.0   4459.1   4890.8                                                                                                                                                                                                                                                  \n",
    "    111   4990.5   4886.7   4205.2   4457.0   4459.1   3523.7                                                                                                                                                                                                                                                  \n",
    "    112   4990.5   4886.7   4205.2   4457.0   4459.1   3838.2                                                                                                                                                                                                                                                  \n",
    "    113   4990.5   4886.7   4205.2   4457.0   4459.1   4525.9                                                                                                                                                                                                                                                  \n",
    "    114   4990.5   4886.7   4205.2   4457.0   4459.1   5972.2                                                                                                                                                                                                                                                  \n",
    "    115   4990.5   4886.7   4205.2   4457.0   4459.1   2452.6                                                                                                                                                                                                                                                  \n",
    "    116   4990.5   4886.7   4205.2   4457.0   4459.1   3797.1                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:   10 - PARANA    / SUBSISTEMA:    1 - SE\n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1  16419.2  20536.4  24486.0  27369.5  29416.8  28423.3                                                                                                                                                                                                                                                  \n",
    "      2  16419.2  20536.4  24486.0  27369.5  29416.8  37344.4                                                                                                                                                                                                                                                  \n",
    "      3  16419.2  20536.4  24486.0  27369.5  29416.8  31797.7                                                                                                                                                                                                                                                  \n",
    "      4  16419.2  20536.4  24486.0  27369.5  29416.8  20128.7                                                                                                                                                                                                                                                  \n",
    "      5  16419.2  20536.4  24486.0  27369.5  29416.8  36503.2                                                                                                                                                                                                                                                  \n",
    "      6  16419.2  20536.4  24486.0  27369.5  29416.8  23804.1                                                                                                                                                                                                                                                  \n",
    "      7  16419.2  20536.4  24486.0  27369.5  29416.8  58016.8                                                                                                                                                                                                                                                  \n",
    "      8  16419.2  20536.4  24486.0  27369.5  29416.8  31100.1                                                                                                                                                                                                                                                  \n",
    "      9  16419.2  20536.4  24486.0  27369.5  29416.8  19949.4                                                                                                                                                                                                                                                  \n",
    "     10  16419.2  20536.4  24486.0  27369.5  29416.8  42307.3                                                                                                                                                                                                                                                  \n",
    "     11  16419.2  20536.4  24486.0  27369.5  29416.8  56336.0                                                                                                                                                                                                                                                  \n",
    "     12  16419.2  20536.4  24486.0  27369.5  29416.8  26651.1                                                                                                                                                                                                                                                  \n",
    "     13  16419.2  20536.4  24486.0  27369.5  29416.8  38068.7                                                                                                                                                                                                                                                  \n",
    "     14  16419.2  20536.4  24486.0  27369.5  29416.8  23993.5                                                                                                                                                                                                                                                  \n",
    "     15  16419.2  20536.4  24486.0  27369.5  29416.8  35509.2                                                                                                                                                                                                                                                  \n",
    "     16  16419.2  20536.4  24486.0  27369.5  29416.8  41706.2                                                                                                                                                                                                                                                  \n",
    "     17  16419.2  20536.4  24486.0  27369.5  29416.8  43530.1                                                                                                                                                                                                                                                  \n",
    "     18  16419.2  20536.4  24486.0  27369.5  29416.8  19154.1                                                                                                                                                                                                                                                  \n",
    "     19  16419.2  20536.4  24486.0  27369.5  29416.8  24822.1                                                                                                                                                                                                                                                  \n",
    "     20  16419.2  20536.4  24486.0  27369.5  29416.8  28777.6                                                                                                                                                                                                                                                  \n",
    "     21  16419.2  20536.4  24486.0  27369.5  29416.8  27018.5                                                                                                                                                                                                                                                  \n",
    "     22  16419.2  20536.4  24486.0  27369.5  29416.8  21850.1                                                                                                                                                                                                                                                  \n",
    "     23  16419.2  20536.4  24486.0  27369.5  29416.8  28219.4                                                                                                                                                                                                                                                  \n",
    "     24  16419.2  20536.4  24486.0  27369.5  29416.8  21063.2                                                                                                                                                                                                                                                  \n",
    "     25  16419.2  20536.4  24486.0  27369.5  29416.8  51140.2                                                                                                                                                                                                                                                  \n",
    "     26  16419.2  20536.4  24486.0  27369.5  29416.8  19702.2                                                                                                                                                                                                                                                  \n",
    "     27  16419.2  20536.4  24486.0  27369.5  29416.8  35460.9                                                                                                                                                                                                                                                  \n",
    "     28  16419.2  20536.4  24486.0  27369.5  29416.8  29477.7                                                                                                                                                                                                                                                  \n",
    "     29  16419.2  20536.4  24486.0  27369.5  29416.8  29318.1                                                                                                                                                                                                                                                  \n",
    "     30  16419.2  20536.4  24486.0  27369.5  29416.8  28994.8                                                                                                                                                                                                                                                  \n",
    "     31  16419.2  20536.4  24486.0  27369.5  29416.8  46142.7                                                                                                                                                                                                                                                  \n",
    "     32  16419.2  20536.4  24486.0  27369.5  29416.8  37524.6                                                                                                                                                                                                                                                  \n",
    "     33  16419.2  20536.4  24486.0  27369.5  29416.8  20097.3                                                                                                                                                                                                                                                  \n",
    "     34  16419.2  20536.4  24486.0  27369.5  29416.8  16089.6                                                                                                                                                                                                                                                  \n",
    "     35  16419.2  20536.4  24486.0  27369.5  29416.8  19879.6                                                                                                                                                                                                                                                  \n",
    "     36  16419.2  20536.4  24486.0  27369.5  29416.8  42916.8                                                                                                                                                                                                                                                  \n",
    "     37  16419.2  20536.4  24486.0  27369.5  29416.8  25205.5                                                                                                                                                                                                                                                  \n",
    "     38  16419.2  20536.4  24486.0  27369.5  29416.8  25978.9                                                                                                                                                                                                                                                  \n",
    "     39  16419.2  20536.4  24486.0  27369.5  29416.8  34411.6                                                                                                                                                                                                                                                  \n",
    "     40  16419.2  20536.4  24486.0  27369.5  29416.8  25790.8                                                                                                                                                                                                                                                  \n",
    "     41  16419.2  20536.4  24486.0  27369.5  29416.8  27477.1                                                                                                                                                                                                                                                  \n",
    "     42  16419.2  20536.4  24486.0  27369.5  29416.8  22866.2                                                                                                                                                                                                                                                  \n",
    "     43  16419.2  20536.4  24486.0  27369.5  29416.8  13522.7                                                                                                                                                                                                                                                  \n",
    "     44  16419.2  20536.4  24486.0  27369.5  29416.8  26986.5                                                                                                                                                                                                                                                  \n",
    "     45  16419.2  20536.4  24486.0  27369.5  29416.8  38639.3                                                                                                                                                                                                                                                  \n",
    "     46  16419.2  20536.4  24486.0  27369.5  29416.8  23508.7                                                                                                                                                                                                                                                  \n",
    "     47  16419.2  20536.4  24486.0  27369.5  29416.8  24596.9                                                                                                                                                                                                                                                  \n",
    "     48  16419.2  20536.4  24486.0  27369.5  29416.8  32063.7                                                                                                                                                                                                                                                  \n",
    "     49  16419.2  20536.4  24486.0  27369.5  29416.8  22122.1                                                                                                                                                                                                                                                  \n",
    "     50  16419.2  20536.4  24486.0  27369.5  29416.8  45675.2                                                                                                                                                                                                                                                  \n",
    "     51  16419.2  20536.4  24486.0  27369.5  29416.8  22949.6                                                                                                                                                                                                                                                  \n",
    "     52  16419.2  20536.4  24486.0  27369.5  29416.8  34487.1                                                                                                                                                                                                                                                  \n",
    "     53  16419.2  20536.4  24486.0  27369.5  29416.8  19868.0                                                                                                                                                                                                                                                  \n",
    "     54  16419.2  20536.4  24486.0  27369.5  29416.8  21394.7                                                                                                                                                                                                                                                  \n",
    "     55  16419.2  20536.4  24486.0  27369.5  29416.8  28530.6                                                                                                                                                                                                                                                  \n",
    "     56  16419.2  20536.4  24486.0  27369.5  29416.8  47503.0                                                                                                                                                                                                                                                  \n",
    "     57  16419.2  20536.4  24486.0  27369.5  29416.8  21689.0                                                                                                                                                                                                                                                  \n",
    "     58  16419.2  20536.4  24486.0  27369.5  29416.8  37395.2                                                                                                                                                                                                                                                  \n",
    "     59  16419.2  20536.4  24486.0  27369.5  29416.8  24547.4                                                                                                                                                                                                                                                  \n",
    "     60  16419.2  20536.4  24486.0  27369.5  29416.8  33787.8                                                                                                                                                                                                                                                  \n",
    "     61  16419.2  20536.4  24486.0  27369.5  29416.8  22887.8                                                                                                                                                                                                                                                  \n",
    "     62  16419.2  20536.4  24486.0  27369.5  29416.8  33877.3                                                                                                                                                                                                                                                  \n",
    "     63  16419.2  20536.4  24486.0  27369.5  29416.8  29104.4                                                                                                                                                                                                                                                  \n",
    "     64  16419.2  20536.4  24486.0  27369.5  29416.8  33841.3                                                                                                                                                                                                                                                  \n",
    "     65  16419.2  20536.4  24486.0  27369.5  29416.8  21539.6                                                                                                                                                                                                                                                  \n",
    "     66  16419.2  20536.4  24486.0  27369.5  29416.8  46922.8                                                                                                                                                                                                                                                  \n",
    "     67  16419.2  20536.4  24486.0  27369.5  29416.8  26250.8                                                                                                                                                                                                                                                  \n",
    "     68  16419.2  20536.4  24486.0  27369.5  29416.8  22177.2                                                                                                                                                                                                                                                  \n",
    "     69  16419.2  20536.4  24486.0  27369.5  29416.8  22902.1                                                                                                                                                                                                                                                  \n",
    "     70  16419.2  20536.4  24486.0  27369.5  29416.8  31259.2                                                                                                                                                                                                                                                  \n",
    "     71  16419.2  20536.4  24486.0  27369.5  29416.8  29845.3                                                                                                                                                                                                                                                  \n",
    "     72  16419.2  20536.4  24486.0  27369.5  29416.8  28156.8                                                                                                                                                                                                                                                  \n",
    "     73  16419.2  20536.4  24486.0  27369.5  29416.8  35054.7                                                                                                                                                                                                                                                  \n",
    "     74  16419.2  20536.4  24486.0  27369.5  29416.8  32384.2                                                                                                                                                                                                                                                  \n",
    "     75  16419.2  20536.4  24486.0  27369.5  29416.8  24139.9                                                                                                                                                                                                                                                  \n",
    "     76  16419.2  20536.4  24486.0  27369.5  29416.8  31922.4                                                                                                                                                                                                                                                  \n",
    "     77  16419.2  20536.4  24486.0  27369.5  29416.8  24330.2                                                                                                                                                                                                                                                  \n",
    "     78  16419.2  20536.4  24486.0  27369.5  29416.8  49217.2                                                                                                                                                                                                                                                  \n",
    "     79  16419.2  20536.4  24486.0  27369.5  29416.8  32618.4                                                                                                                                                                                                                                                  \n",
    "     80  16419.2  20536.4  24486.0  27369.5  29416.8  23081.5                                                                                                                                                                                                                                                  \n",
    "     81  16419.2  20536.4  24486.0  27369.5  29416.8  25232.1                                                                                                                                                                                                                                                  \n",
    "     82  16419.2  20536.4  24486.0  27369.5  29416.8  23299.6                                                                                                                                                                                                                                                  \n",
    "     83  16419.2  20536.4  24486.0  27369.5  29416.8  44032.5                                                                                                                                                                                                                                                  \n",
    "     84  16419.2  20536.4  24486.0  27369.5  29416.8  44039.8                                                                                                                                                                                                                                                  \n",
    "     85  16419.2  20536.4  24486.0  27369.5  29416.8  23393.0                                                                                                                                                                                                                                                  \n",
    "     86  16419.2  20536.4  24486.0  27369.5  29416.8  35271.9                                                                                                                                                                                                                                                  \n",
    "     87  16419.2  20536.4  24486.0  27369.5  29416.8  23553.3                                                                                                                                                                                                                                                  \n",
    "     88  16419.2  20536.4  24486.0  27369.5  29416.8  29354.3                                                                                                                                                                                                                                                  \n",
    "     89  16419.2  20536.4  24486.0  27369.5  29416.8  26406.5                                                                                                                                                                                                                                                  \n",
    "     90  16419.2  20536.4  24486.0  27369.5  29416.8  25789.4                                                                                                                                                                                                                                                  \n",
    "     91  16419.2  20536.4  24486.0  27369.5  29416.8  21287.2                                                                                                                                                                                                                                                  \n",
    "     92  16419.2  20536.4  24486.0  27369.5  29416.8  27411.9                                                                                                                                                                                                                                                  \n",
    "     93  16419.2  20536.4  24486.0  27369.5  29416.8  23665.5                                                                                                                                                                                                                                                  \n",
    "     94  16419.2  20536.4  24486.0  27369.5  29416.8  32766.1                                                                                                                                                                                                                                                  \n",
    "     95  16419.2  20536.4  24486.0  27369.5  29416.8  21826.2                                                                                                                                                                                                                                                  \n",
    "     96  16419.2  20536.4  24486.0  27369.5  29416.8  19238.1                                                                                                                                                                                                                                                  \n",
    "     97  16419.2  20536.4  24486.0  27369.5  29416.8  46177.4                                                                                                                                                                                                                                                  \n",
    "     98  16419.2  20536.4  24486.0  27369.5  29416.8  34395.1                                                                                                                                                                                                                                                  \n",
    "     99  16419.2  20536.4  24486.0  27369.5  29416.8  17186.1                                                                                                                                                                                                                                                  \n",
    "    100  16419.2  20536.4  24486.0  27369.5  29416.8  24455.0                                                                                                                                                                                                                                                  \n",
    "    101  16419.2  20536.4  24486.0  27369.5  29416.8  34869.6                                                                                                                                                                                                                                                  \n",
    "    102  16419.2  20536.4  24486.0  27369.5  29416.8  42454.2                                                                                                                                                                                                                                                  \n",
    "    103  16419.2  20536.4  24486.0  27369.5  29416.8  37798.5                                                                                                                                                                                                                                                  \n",
    "    104  16419.2  20536.4  24486.0  27369.5  29416.8  35490.3                                                                                                                                                                                                                                                  \n",
    "    105  16419.2  20536.4  24486.0  27369.5  29416.8  21690.1                                                                                                                                                                                                                                                  \n",
    "    106  16419.2  20536.4  24486.0  27369.5  29416.8  30206.0                                                                                                                                                                                                                                                  \n",
    "    107  16419.2  20536.4  24486.0  27369.5  29416.8  16666.2                                                                                                                                                                                                                                                  \n",
    "    108  16419.2  20536.4  24486.0  27369.5  29416.8  20931.1                                                                                                                                                                                                                                                  \n",
    "    109  16419.2  20536.4  24486.0  27369.5  29416.8  16201.5                                                                                                                                                                                                                                                  \n",
    "    110  16419.2  20536.4  24486.0  27369.5  29416.8  27440.7                                                                                                                                                                                                                                                  \n",
    "    111  16419.2  20536.4  24486.0  27369.5  29416.8  42426.9                                                                                                                                                                                                                                                  \n",
    "    112  16419.2  20536.4  24486.0  27369.5  29416.8  15672.2                                                                                                                                                                                                                                                  \n",
    "    113  16419.2  20536.4  24486.0  27369.5  29416.8  37125.1                                                                                                                                                                                                                                                  \n",
    "    114  16419.2  20536.4  24486.0  27369.5  29416.8  47053.3                                                                                                                                                                                                                                                  \n",
    "    115  16419.2  20536.4  24486.0  27369.5  29416.8  30551.8                                                                                                                                                                                                                                                  \n",
    "    116  16419.2  20536.4  24486.0  27369.5  29416.8  18550.3                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:   12 - PRNPANEMA / SUBSISTEMA:    1 - SE\n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   1556.7   1758.0   2117.0   2546.0   2485.3   2544.4                                                                                                                                                                                                                                                  \n",
    "      2   1556.7   1758.0   2117.0   2546.0   2485.3   7390.8                                                                                                                                                                                                                                                  \n",
    "      3   1556.7   1758.0   2117.0   2546.0   2485.3   5598.4                                                                                                                                                                                                                                                  \n",
    "      4   1556.7   1758.0   2117.0   2546.0   2485.3   4201.4                                                                                                                                                                                                                                                  \n",
    "      5   1556.7   1758.0   2117.0   2546.0   2485.3   3062.8                                                                                                                                                                                                                                                  \n",
    "      6   1556.7   1758.0   2117.0   2546.0   2485.3   1905.6                                                                                                                                                                                                                                                  \n",
    "      7   1556.7   1758.0   2117.0   2546.0   2485.3   5730.2                                                                                                                                                                                                                                                  \n",
    "      8   1556.7   1758.0   2117.0   2546.0   2485.3   4440.3                                                                                                                                                                                                                                                  \n",
    "      9   1556.7   1758.0   2117.0   2546.0   2485.3   2974.7                                                                                                                                                                                                                                                  \n",
    "     10   1556.7   1758.0   2117.0   2546.0   2485.3   4996.3                                                                                                                                                                                                                                                  \n",
    "     11   1556.7   1758.0   2117.0   2546.0   2485.3   1907.9                                                                                                                                                                                                                                                  \n",
    "     12   1556.7   1758.0   2117.0   2546.0   2485.3   2571.0                                                                                                                                                                                                                                                  \n",
    "     13   1556.7   1758.0   2117.0   2546.0   2485.3   1850.2                                                                                                                                                                                                                                                  \n",
    "     14   1556.7   1758.0   2117.0   2546.0   2485.3   3253.0                                                                                                                                                                                                                                                  \n",
    "     15   1556.7   1758.0   2117.0   2546.0   2485.3   1669.2                                                                                                                                                                                                                                                  \n",
    "     16   1556.7   1758.0   2117.0   2546.0   2485.3   1655.2                                                                                                                                                                                                                                                  \n",
    "     17   1556.7   1758.0   2117.0   2546.0   2485.3   3091.4                                                                                                                                                                                                                                                  \n",
    "     18   1556.7   1758.0   2117.0   2546.0   2485.3   1724.0                                                                                                                                                                                                                                                  \n",
    "     19   1556.7   1758.0   2117.0   2546.0   2485.3   3688.0                                                                                                                                                                                                                                                  \n",
    "     20   1556.7   1758.0   2117.0   2546.0   2485.3   4144.5                                                                                                                                                                                                                                                  \n",
    "     21   1556.7   1758.0   2117.0   2546.0   2485.3   4330.1                                                                                                                                                                                                                                                  \n",
    "     22   1556.7   1758.0   2117.0   2546.0   2485.3   1548.5                                                                                                                                                                                                                                                  \n",
    "     23   1556.7   1758.0   2117.0   2546.0   2485.3   2925.4                                                                                                                                                                                                                                                  \n",
    "     24   1556.7   1758.0   2117.0   2546.0   2485.3   2276.5                                                                                                                                                                                                                                                  \n",
    "     25   1556.7   1758.0   2117.0   2546.0   2485.3   8357.5                                                                                                                                                                                                                                                  \n",
    "     26   1556.7   1758.0   2117.0   2546.0   2485.3   2663.8                                                                                                                                                                                                                                                  \n",
    "     27   1556.7   1758.0   2117.0   2546.0   2485.3   1002.7                                                                                                                                                                                                                                                  \n",
    "     28   1556.7   1758.0   2117.0   2546.0   2485.3   8766.3                                                                                                                                                                                                                                                  \n",
    "     29   1556.7   1758.0   2117.0   2546.0   2485.3   4247.6                                                                                                                                                                                                                                                  \n",
    "     30   1556.7   1758.0   2117.0   2546.0   2485.3   3512.8                                                                                                                                                                                                                                                  \n",
    "     31   1556.7   1758.0   2117.0   2546.0   2485.3   2361.2                                                                                                                                                                                                                                                  \n",
    "     32   1556.7   1758.0   2117.0   2546.0   2485.3   4982.5                                                                                                                                                                                                                                                  \n",
    "     33   1556.7   1758.0   2117.0   2546.0   2485.3   3502.4                                                                                                                                                                                                                                                  \n",
    "     34   1556.7   1758.0   2117.0   2546.0   2485.3   1564.2                                                                                                                                                                                                                                                  \n",
    "     35   1556.7   1758.0   2117.0   2546.0   2485.3   1895.2                                                                                                                                                                                                                                                  \n",
    "     36   1556.7   1758.0   2117.0   2546.0   2485.3   5461.1                                                                                                                                                                                                                                                  \n",
    "     37   1556.7   1758.0   2117.0   2546.0   2485.3   2716.4                                                                                                                                                                                                                                                  \n",
    "     38   1556.7   1758.0   2117.0   2546.0   2485.3   3503.3                                                                                                                                                                                                                                                  \n",
    "     39   1556.7   1758.0   2117.0   2546.0   2485.3   1954.4                                                                                                                                                                                                                                                  \n",
    "     40   1556.7   1758.0   2117.0   2546.0   2485.3   5109.6                                                                                                                                                                                                                                                  \n",
    "     41   1556.7   1758.0   2117.0   2546.0   2485.3   2753.1                                                                                                                                                                                                                                                  \n",
    "     42   1556.7   1758.0   2117.0   2546.0   2485.3   1445.1                                                                                                                                                                                                                                                  \n",
    "     43   1556.7   1758.0   2117.0   2546.0   2485.3   1746.9                                                                                                                                                                                                                                                  \n",
    "     44   1556.7   1758.0   2117.0   2546.0   2485.3   2325.0                                                                                                                                                                                                                                                  \n",
    "     45   1556.7   1758.0   2117.0   2546.0   2485.3   2915.3                                                                                                                                                                                                                                                  \n",
    "     46   1556.7   1758.0   2117.0   2546.0   2485.3   1342.4                                                                                                                                                                                                                                                  \n",
    "     47   1556.7   1758.0   2117.0   2546.0   2485.3   5672.7                                                                                                                                                                                                                                                  \n",
    "     48   1556.7   1758.0   2117.0   2546.0   2485.3   6075.6                                                                                                                                                                                                                                                  \n",
    "     49   1556.7   1758.0   2117.0   2546.0   2485.3   1355.3                                                                                                                                                                                                                                                  \n",
    "     50   1556.7   1758.0   2117.0   2546.0   2485.3   5718.1                                                                                                                                                                                                                                                  \n",
    "     51   1556.7   1758.0   2117.0   2546.0   2485.3   2357.7                                                                                                                                                                                                                                                  \n",
    "     52   1556.7   1758.0   2117.0   2546.0   2485.3   1730.6                                                                                                                                                                                                                                                  \n",
    "     53   1556.7   1758.0   2117.0   2546.0   2485.3   2334.1                                                                                                                                                                                                                                                  \n",
    "     54   1556.7   1758.0   2117.0   2546.0   2485.3   2061.7                                                                                                                                                                                                                                                  \n",
    "     55   1556.7   1758.0   2117.0   2546.0   2485.3   2309.7                                                                                                                                                                                                                                                  \n",
    "     56   1556.7   1758.0   2117.0   2546.0   2485.3   3924.8                                                                                                                                                                                                                                                  \n",
    "     57   1556.7   1758.0   2117.0   2546.0   2485.3   2312.8                                                                                                                                                                                                                                                  \n",
    "     58   1556.7   1758.0   2117.0   2546.0   2485.3   1825.7                                                                                                                                                                                                                                                  \n",
    "     59   1556.7   1758.0   2117.0   2546.0   2485.3   1761.7                                                                                                                                                                                                                                                  \n",
    "     60   1556.7   1758.0   2117.0   2546.0   2485.3   4225.0                                                                                                                                                                                                                                                  \n",
    "     61   1556.7   1758.0   2117.0   2546.0   2485.3   2689.6                                                                                                                                                                                                                                                  \n",
    "     62   1556.7   1758.0   2117.0   2546.0   2485.3   2245.2                                                                                                                                                                                                                                                  \n",
    "     63   1556.7   1758.0   2117.0   2546.0   2485.3   1901.8                                                                                                                                                                                                                                                  \n",
    "     64   1556.7   1758.0   2117.0   2546.0   2485.3   3200.0                                                                                                                                                                                                                                                  \n",
    "     65   1556.7   1758.0   2117.0   2546.0   2485.3   2110.8                                                                                                                                                                                                                                                  \n",
    "     66   1556.7   1758.0   2117.0   2546.0   2485.3   2494.5                                                                                                                                                                                                                                                  \n",
    "     67   1556.7   1758.0   2117.0   2546.0   2485.3   5627.7                                                                                                                                                                                                                                                  \n",
    "     68   1556.7   1758.0   2117.0   2546.0   2485.3   4215.7                                                                                                                                                                                                                                                  \n",
    "     69   1556.7   1758.0   2117.0   2546.0   2485.3   3383.8                                                                                                                                                                                                                                                  \n",
    "     70   1556.7   1758.0   2117.0   2546.0   2485.3   3393.1                                                                                                                                                                                                                                                  \n",
    "     71   1556.7   1758.0   2117.0   2546.0   2485.3   2137.4                                                                                                                                                                                                                                                  \n",
    "     72   1556.7   1758.0   2117.0   2546.0   2485.3   2933.1                                                                                                                                                                                                                                                  \n",
    "     73   1556.7   1758.0   2117.0   2546.0   2485.3   3247.1                                                                                                                                                                                                                                                  \n",
    "     74   1556.7   1758.0   2117.0   2546.0   2485.3   1840.5                                                                                                                                                                                                                                                  \n",
    "     75   1556.7   1758.0   2117.0   2546.0   2485.3   3416.0                                                                                                                                                                                                                                                  \n",
    "     76   1556.7   1758.0   2117.0   2546.0   2485.3   3355.7                                                                                                                                                                                                                                                  \n",
    "     77   1556.7   1758.0   2117.0   2546.0   2485.3   5938.3                                                                                                                                                                                                                                                  \n",
    "     78   1556.7   1758.0   2117.0   2546.0   2485.3   7321.0                                                                                                                                                                                                                                                  \n",
    "     79   1556.7   1758.0   2117.0   2546.0   2485.3   3262.4                                                                                                                                                                                                                                                  \n",
    "     80   1556.7   1758.0   2117.0   2546.0   2485.3   2835.3                                                                                                                                                                                                                                                  \n",
    "     81   1556.7   1758.0   2117.0   2546.0   2485.3   2257.3                                                                                                                                                                                                                                                  \n",
    "     82   1556.7   1758.0   2117.0   2546.0   2485.3   2113.8                                                                                                                                                                                                                                                  \n",
    "     83   1556.7   1758.0   2117.0   2546.0   2485.3   4146.5                                                                                                                                                                                                                                                  \n",
    "     84   1556.7   1758.0   2117.0   2546.0   2485.3   2432.8                                                                                                                                                                                                                                                  \n",
    "     85   1556.7   1758.0   2117.0   2546.0   2485.3   1848.0                                                                                                                                                                                                                                                  \n",
    "     86   1556.7   1758.0   2117.0   2546.0   2485.3   2821.8                                                                                                                                                                                                                                                  \n",
    "     87   1556.7   1758.0   2117.0   2546.0   2485.3   1439.4                                                                                                                                                                                                                                                  \n",
    "     88   1556.7   1758.0   2117.0   2546.0   2485.3   1540.6                                                                                                                                                                                                                                                  \n",
    "     89   1556.7   1758.0   2117.0   2546.0   2485.3   4474.8                                                                                                                                                                                                                                                  \n",
    "     90   1556.7   1758.0   2117.0   2546.0   2485.3   2664.6                                                                                                                                                                                                                                                  \n",
    "     91   1556.7   1758.0   2117.0   2546.0   2485.3   2699.4                                                                                                                                                                                                                                                  \n",
    "     92   1556.7   1758.0   2117.0   2546.0   2485.3   1796.0                                                                                                                                                                                                                                                  \n",
    "     93   1556.7   1758.0   2117.0   2546.0   2485.3   3581.2                                                                                                                                                                                                                                                  \n",
    "     94   1556.7   1758.0   2117.0   2546.0   2485.3   5430.6                                                                                                                                                                                                                                                  \n",
    "     95   1556.7   1758.0   2117.0   2546.0   2485.3   2966.5                                                                                                                                                                                                                                                  \n",
    "     96   1556.7   1758.0   2117.0   2546.0   2485.3   2077.4                                                                                                                                                                                                                                                  \n",
    "     97   1556.7   1758.0   2117.0   2546.0   2485.3   1697.0                                                                                                                                                                                                                                                  \n",
    "     98   1556.7   1758.0   2117.0   2546.0   2485.3   7764.4                                                                                                                                                                                                                                                  \n",
    "     99   1556.7   1758.0   2117.0   2546.0   2485.3   5036.0                                                                                                                                                                                                                                                  \n",
    "    100   1556.7   1758.0   2117.0   2546.0   2485.3   2335.7                                                                                                                                                                                                                                                  \n",
    "    101   1556.7   1758.0   2117.0   2546.0   2485.3   5650.8                                                                                                                                                                                                                                                  \n",
    "    102   1556.7   1758.0   2117.0   2546.0   2485.3   3833.5                                                                                                                                                                                                                                                  \n",
    "    103   1556.7   1758.0   2117.0   2546.0   2485.3   3271.8                                                                                                                                                                                                                                                  \n",
    "    104   1556.7   1758.0   2117.0   2546.0   2485.3   3931.8                                                                                                                                                                                                                                                  \n",
    "    105   1556.7   1758.0   2117.0   2546.0   2485.3   4897.4                                                                                                                                                                                                                                                  \n",
    "    106   1556.7   1758.0   2117.0   2546.0   2485.3   1623.0                                                                                                                                                                                                                                                  \n",
    "    107   1556.7   1758.0   2117.0   2546.0   2485.3   1776.7                                                                                                                                                                                                                                                  \n",
    "    108   1556.7   1758.0   2117.0   2546.0   2485.3   3042.6                                                                                                                                                                                                                                                  \n",
    "    109   1556.7   1758.0   2117.0   2546.0   2485.3   3580.5                                                                                                                                                                                                                                                  \n",
    "    110   1556.7   1758.0   2117.0   2546.0   2485.3   1407.6                                                                                                                                                                                                                                                  \n",
    "    111   1556.7   1758.0   2117.0   2546.0   2485.3   2096.9                                                                                                                                                                                                                                                  \n",
    "    112   1556.7   1758.0   2117.0   2546.0   2485.3   2034.1                                                                                                                                                                                                                                                  \n",
    "    113   1556.7   1758.0   2117.0   2546.0   2485.3   3587.4                                                                                                                                                                                                                                                  \n",
    "    114   1556.7   1758.0   2117.0   2546.0   2485.3   4443.6                                                                                                                                                                                                                                                  \n",
    "    115   1556.7   1758.0   2117.0   2546.0   2485.3   1937.8                                                                                                                                                                                                                                                  \n",
    "    116   1556.7   1758.0   2117.0   2546.0   2485.3   1778.1                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:    2 - SUL       / SUBSISTEMA:    2 - S \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   1482.5   1803.8   2197.6   2355.1   2980.1   1826.7                                                                                                                                                                                                                                                  \n",
    "      2   1482.5   1803.8   2197.6   2355.1   2980.1  10774.1                                                                                                                                                                                                                                                  \n",
    "      3   1482.5   1803.8   2197.6   2355.1   2980.1   4950.9                                                                                                                                                                                                                                                  \n",
    "      4   1482.5   1803.8   2197.6   2355.1   2980.1   5246.0                                                                                                                                                                                                                                                  \n",
    "      5   1482.5   1803.8   2197.6   2355.1   2980.1   5372.2                                                                                                                                                                                                                                                  \n",
    "      6   1482.5   1803.8   2197.6   2355.1   2980.1   1633.7                                                                                                                                                                                                                                                  \n",
    "      7   1482.5   1803.8   2197.6   2355.1   2980.1   3365.3                                                                                                                                                                                                                                                  \n",
    "      8   1482.5   1803.8   2197.6   2355.1   2980.1   3232.4                                                                                                                                                                                                                                                  \n",
    "      9   1482.5   1803.8   2197.6   2355.1   2980.1   7091.9                                                                                                                                                                                                                                                  \n",
    "     10   1482.5   1803.8   2197.6   2355.1   2980.1   2703.3                                                                                                                                                                                                                                                  \n",
    "     11   1482.5   1803.8   2197.6   2355.1   2980.1   2584.1                                                                                                                                                                                                                                                  \n",
    "     12   1482.5   1803.8   2197.6   2355.1   2980.1   1737.2                                                                                                                                                                                                                                                  \n",
    "     13   1482.5   1803.8   2197.6   2355.1   2980.1    688.9                                                                                                                                                                                                                                                  \n",
    "     14   1482.5   1803.8   2197.6   2355.1   2980.1   5661.9                                                                                                                                                                                                                                                  \n",
    "     15   1482.5   1803.8   2197.6   2355.1   2980.1   4675.7                                                                                                                                                                                                                                                  \n",
    "     16   1482.5   1803.8   2197.6   2355.1   2980.1   2674.5                                                                                                                                                                                                                                                  \n",
    "     17   1482.5   1803.8   2197.6   2355.1   2980.1   1980.6                                                                                                                                                                                                                                                  \n",
    "     18   1482.5   1803.8   2197.6   2355.1   2980.1   1885.9                                                                                                                                                                                                                                                  \n",
    "     19   1482.5   1803.8   2197.6   2355.1   2980.1   1049.8                                                                                                                                                                                                                                                  \n",
    "     20   1482.5   1803.8   2197.6   2355.1   2980.1   1829.5                                                                                                                                                                                                                                                  \n",
    "     21   1482.5   1803.8   2197.6   2355.1   2980.1   1890.0                                                                                                                                                                                                                                                  \n",
    "     22   1482.5   1803.8   2197.6   2355.1   2980.1   2360.6                                                                                                                                                                                                                                                  \n",
    "     23   1482.5   1803.8   2197.6   2355.1   2980.1   3437.5                                                                                                                                                                                                                                                  \n",
    "     24   1482.5   1803.8   2197.6   2355.1   2980.1   3200.5                                                                                                                                                                                                                                                  \n",
    "     25   1482.5   1803.8   2197.6   2355.1   2980.1   4277.9                                                                                                                                                                                                                                                  \n",
    "     26   1482.5   1803.8   2197.6   2355.1   2980.1   4988.8                                                                                                                                                                                                                                                  \n",
    "     27   1482.5   1803.8   2197.6   2355.1   2980.1   2382.4                                                                                                                                                                                                                                                  \n",
    "     28   1482.5   1803.8   2197.6   2355.1   2980.1   6169.1                                                                                                                                                                                                                                                  \n",
    "     29   1482.5   1803.8   2197.6   2355.1   2980.1   3019.7                                                                                                                                                                                                                                                  \n",
    "     30   1482.5   1803.8   2197.6   2355.1   2980.1   2064.7                                                                                                                                                                                                                                                  \n",
    "     31   1482.5   1803.8   2197.6   2355.1   2980.1   1598.4                                                                                                                                                                                                                                                  \n",
    "     32   1482.5   1803.8   2197.6   2355.1   2980.1   5686.1                                                                                                                                                                                                                                                  \n",
    "     33   1482.5   1803.8   2197.6   2355.1   2980.1   2992.9                                                                                                                                                                                                                                                  \n",
    "     34   1482.5   1803.8   2197.6   2355.1   2980.1   5001.1                                                                                                                                                                                                                                                  \n",
    "     35   1482.5   1803.8   2197.6   2355.1   2980.1   1985.7                                                                                                                                                                                                                                                  \n",
    "     36   1482.5   1803.8   2197.6   2355.1   2980.1   4714.1                                                                                                                                                                                                                                                  \n",
    "     37   1482.5   1803.8   2197.6   2355.1   2980.1   2358.8                                                                                                                                                                                                                                                  \n",
    "     38   1482.5   1803.8   2197.6   2355.1   2980.1   6353.8                                                                                                                                                                                                                                                  \n",
    "     39   1482.5   1803.8   2197.6   2355.1   2980.1    824.9                                                                                                                                                                                                                                                  \n",
    "     40   1482.5   1803.8   2197.6   2355.1   2980.1   3725.9                                                                                                                                                                                                                                                  \n",
    "     41   1482.5   1803.8   2197.6   2355.1   2980.1   6396.0                                                                                                                                                                                                                                                  \n",
    "     42   1482.5   1803.8   2197.6   2355.1   2980.1   1772.1                                                                                                                                                                                                                                                  \n",
    "     43   1482.5   1803.8   2197.6   2355.1   2980.1   1826.4                                                                                                                                                                                                                                                  \n",
    "     44   1482.5   1803.8   2197.6   2355.1   2980.1   2494.6                                                                                                                                                                                                                                                  \n",
    "     45   1482.5   1803.8   2197.6   2355.1   2980.1   2224.7                                                                                                                                                                                                                                                  \n",
    "     46   1482.5   1803.8   2197.6   2355.1   2980.1   1414.4                                                                                                                                                                                                                                                  \n",
    "     47   1482.5   1803.8   2197.6   2355.1   2980.1   5023.8                                                                                                                                                                                                                                                  \n",
    "     48   1482.5   1803.8   2197.6   2355.1   2980.1   3256.3                                                                                                                                                                                                                                                  \n",
    "     49   1482.5   1803.8   2197.6   2355.1   2980.1    792.5                                                                                                                                                                                                                                                  \n",
    "     50   1482.5   1803.8   2197.6   2355.1   2980.1   2815.6                                                                                                                                                                                                                                                  \n",
    "     51   1482.5   1803.8   2197.6   2355.1   2980.1   2989.5                                                                                                                                                                                                                                                  \n",
    "     52   1482.5   1803.8   2197.6   2355.1   2980.1    555.5                                                                                                                                                                                                                                                  \n",
    "     53   1482.5   1803.8   2197.6   2355.1   2980.1   2303.2                                                                                                                                                                                                                                                  \n",
    "     54   1482.5   1803.8   2197.6   2355.1   2980.1    984.1                                                                                                                                                                                                                                                  \n",
    "     55   1482.5   1803.8   2197.6   2355.1   2980.1   5974.3                                                                                                                                                                                                                                                  \n",
    "     56   1482.5   1803.8   2197.6   2355.1   2980.1   3279.4                                                                                                                                                                                                                                                  \n",
    "     57   1482.5   1803.8   2197.6   2355.1   2980.1   2435.4                                                                                                                                                                                                                                                  \n",
    "     58   1482.5   1803.8   2197.6   2355.1   2980.1   1275.7                                                                                                                                                                                                                                                  \n",
    "     59   1482.5   1803.8   2197.6   2355.1   2980.1   1568.4                                                                                                                                                                                                                                                  \n",
    "     60   1482.5   1803.8   2197.6   2355.1   2980.1   2566.7                                                                                                                                                                                                                                                  \n",
    "     61   1482.5   1803.8   2197.6   2355.1   2980.1   5198.7                                                                                                                                                                                                                                                  \n",
    "     62   1482.5   1803.8   2197.6   2355.1   2980.1   1590.8                                                                                                                                                                                                                                                  \n",
    "     63   1482.5   1803.8   2197.6   2355.1   2980.1   1702.8                                                                                                                                                                                                                                                  \n",
    "     64   1482.5   1803.8   2197.6   2355.1   2980.1   2300.7                                                                                                                                                                                                                                                  \n",
    "     65   1482.5   1803.8   2197.6   2355.1   2980.1   3533.4                                                                                                                                                                                                                                                  \n",
    "     66   1482.5   1803.8   2197.6   2355.1   2980.1   3249.2                                                                                                                                                                                                                                                  \n",
    "     67   1482.5   1803.8   2197.6   2355.1   2980.1   3952.9                                                                                                                                                                                                                                                  \n",
    "     68   1482.5   1803.8   2197.6   2355.1   2980.1   2564.5                                                                                                                                                                                                                                                  \n",
    "     69   1482.5   1803.8   2197.6   2355.1   2980.1   1335.1                                                                                                                                                                                                                                                  \n",
    "     70   1482.5   1803.8   2197.6   2355.1   2980.1   1693.9                                                                                                                                                                                                                                                  \n",
    "     71   1482.5   1803.8   2197.6   2355.1   2980.1   1449.5                                                                                                                                                                                                                                                  \n",
    "     72   1482.5   1803.8   2197.6   2355.1   2980.1   2320.5                                                                                                                                                                                                                                                  \n",
    "     73   1482.5   1803.8   2197.6   2355.1   2980.1   1504.8                                                                                                                                                                                                                                                  \n",
    "     74   1482.5   1803.8   2197.6   2355.1   2980.1   1330.7                                                                                                                                                                                                                                                  \n",
    "     75   1482.5   1803.8   2197.6   2355.1   2980.1   3080.0                                                                                                                                                                                                                                                  \n",
    "     76   1482.5   1803.8   2197.6   2355.1   2980.1   2422.9                                                                                                                                                                                                                                                  \n",
    "     77   1482.5   1803.8   2197.6   2355.1   2980.1   6231.3                                                                                                                                                                                                                                                  \n",
    "     78   1482.5   1803.8   2197.6   2355.1   2980.1   6303.6                                                                                                                                                                                                                                                  \n",
    "     79   1482.5   1803.8   2197.6   2355.1   2980.1   2645.7                                                                                                                                                                                                                                                  \n",
    "     80   1482.5   1803.8   2197.6   2355.1   2980.1   2152.1                                                                                                                                                                                                                                                  \n",
    "     81   1482.5   1803.8   2197.6   2355.1   2980.1   1912.6                                                                                                                                                                                                                                                  \n",
    "     82   1482.5   1803.8   2197.6   2355.1   2980.1   3193.2                                                                                                                                                                                                                                                  \n",
    "     83   1482.5   1803.8   2197.6   2355.1   2980.1   1775.5                                                                                                                                                                                                                                                  \n",
    "     84   1482.5   1803.8   2197.6   2355.1   2980.1   4261.6                                                                                                                                                                                                                                                  \n",
    "     85   1482.5   1803.8   2197.6   2355.1   2980.1   3719.3                                                                                                                                                                                                                                                  \n",
    "     86   1482.5   1803.8   2197.6   2355.1   2980.1   2955.5                                                                                                                                                                                                                                                  \n",
    "     87   1482.5   1803.8   2197.6   2355.1   2980.1   1631.5                                                                                                                                                                                                                                                  \n",
    "     88   1482.5   1803.8   2197.6   2355.1   2980.1   2863.1                                                                                                                                                                                                                                                  \n",
    "     89   1482.5   1803.8   2197.6   2355.1   2980.1   3495.5                                                                                                                                                                                                                                                  \n",
    "     90   1482.5   1803.8   2197.6   2355.1   2980.1   3582.7                                                                                                                                                                                                                                                  \n",
    "     91   1482.5   1803.8   2197.6   2355.1   2980.1   3533.4                                                                                                                                                                                                                                                  \n",
    "     92   1482.5   1803.8   2197.6   2355.1   2980.1   1340.7                                                                                                                                                                                                                                                  \n",
    "     93   1482.5   1803.8   2197.6   2355.1   2980.1   3296.3                                                                                                                                                                                                                                                  \n",
    "     94   1482.5   1803.8   2197.6   2355.1   2980.1   6836.3                                                                                                                                                                                                                                                  \n",
    "     95   1482.5   1803.8   2197.6   2355.1   2980.1   2216.3                                                                                                                                                                                                                                                  \n",
    "     96   1482.5   1803.8   2197.6   2355.1   2980.1   1259.5                                                                                                                                                                                                                                                  \n",
    "     97   1482.5   1803.8   2197.6   2355.1   2980.1   2383.3                                                                                                                                                                                                                                                  \n",
    "     98   1482.5   1803.8   2197.6   2355.1   2980.1   3071.4                                                                                                                                                                                                                                                  \n",
    "     99   1482.5   1803.8   2197.6   2355.1   2980.1   2809.1                                                                                                                                                                                                                                                  \n",
    "    100   1482.5   1803.8   2197.6   2355.1   2980.1    908.1                                                                                                                                                                                                                                                  \n",
    "    101   1482.5   1803.8   2197.6   2355.1   2980.1   2106.9                                                                                                                                                                                                                                                  \n",
    "    102   1482.5   1803.8   2197.6   2355.1   2980.1   1996.6                                                                                                                                                                                                                                                  \n",
    "    103   1482.5   1803.8   2197.6   2355.1   2980.1   4389.7                                                                                                                                                                                                                                                  \n",
    "    104   1482.5   1803.8   2197.6   2355.1   2980.1   1166.1                                                                                                                                                                                                                                                  \n",
    "    105   1482.5   1803.8   2197.6   2355.1   2980.1   6324.2                                                                                                                                                                                                                                                  \n",
    "    106   1482.5   1803.8   2197.6   2355.1   2980.1   1692.0                                                                                                                                                                                                                                                  \n",
    "    107   1482.5   1803.8   2197.6   2355.1   2980.1    758.3                                                                                                                                                                                                                                                  \n",
    "    108   1482.5   1803.8   2197.6   2355.1   2980.1   6081.2                                                                                                                                                                                                                                                  \n",
    "    109   1482.5   1803.8   2197.6   2355.1   2980.1   3485.5                                                                                                                                                                                                                                                  \n",
    "    110   1482.5   1803.8   2197.6   2355.1   2980.1   3471.0                                                                                                                                                                                                                                                  \n",
    "    111   1482.5   1803.8   2197.6   2355.1   2980.1   1033.5                                                                                                                                                                                                                                                  \n",
    "    112   1482.5   1803.8   2197.6   2355.1   2980.1   1152.0                                                                                                                                                                                                                                                  \n",
    "    113   1482.5   1803.8   2197.6   2355.1   2980.1   1596.9                                                                                                                                                                                                                                                  \n",
    "    114   1482.5   1803.8   2197.6   2355.1   2980.1   2398.5                                                                                                                                                                                                                                                  \n",
    "    115   1482.5   1803.8   2197.6   2355.1   2980.1   1597.4                                                                                                                                                                                                                                                  \n",
    "    116   1482.5   1803.8   2197.6   2355.1   2980.1    934.9                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:   11 - IGUACU    / SUBSISTEMA:    2 - S \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   1825.1   2112.9   2273.6   2988.4   3321.2   2131.5                                                                                                                                                                                                                                                  \n",
    "      2   1825.1   2112.9   2273.6   2988.4   3321.2   8351.5                                                                                                                                                                                                                                                  \n",
    "      3   1825.1   2112.9   2273.6   2988.4   3321.2   7829.7                                                                                                                                                                                                                                                  \n",
    "      4   1825.1   2112.9   2273.6   2988.4   3321.2   5758.6                                                                                                                                                                                                                                                  \n",
    "      5   1825.1   2112.9   2273.6   2988.4   3321.2   3354.5                                                                                                                                                                                                                                                  \n",
    "      6   1825.1   2112.9   2273.6   2988.4   3321.2   2006.2                                                                                                                                                                                                                                                  \n",
    "      7   1825.1   2112.9   2273.6   2988.4   3321.2   5434.8                                                                                                                                                                                                                                                  \n",
    "      8   1825.1   2112.9   2273.6   2988.4   3321.2   6227.5                                                                                                                                                                                                                                                  \n",
    "      9   1825.1   2112.9   2273.6   2988.4   3321.2   6287.1                                                                                                                                                                                                                                                  \n",
    "     10   1825.1   2112.9   2273.6   2988.4   3321.2   4905.7                                                                                                                                                                                                                                                  \n",
    "     11   1825.1   2112.9   2273.6   2988.4   3321.2   2963.5                                                                                                                                                                                                                                                  \n",
    "     12   1825.1   2112.9   2273.6   2988.4   3321.2   3195.3                                                                                                                                                                                                                                                  \n",
    "     13   1825.1   2112.9   2273.6   2988.4   3321.2    983.5                                                                                                                                                                                                                                                  \n",
    "     14   1825.1   2112.9   2273.6   2988.4   3321.2   4809.9                                                                                                                                                                                                                                                  \n",
    "     15   1825.1   2112.9   2273.6   2988.4   3321.2   2822.0                                                                                                                                                                                                                                                  \n",
    "     16   1825.1   2112.9   2273.6   2988.4   3321.2   2423.8                                                                                                                                                                                                                                                  \n",
    "     17   1825.1   2112.9   2273.6   2988.4   3321.2   1388.6                                                                                                                                                                                                                                                  \n",
    "     18   1825.1   2112.9   2273.6   2988.4   3321.2   1558.9                                                                                                                                                                                                                                                  \n",
    "     19   1825.1   2112.9   2273.6   2988.4   3321.2   1367.8                                                                                                                                                                                                                                                  \n",
    "     20   1825.1   2112.9   2273.6   2988.4   3321.2   5595.4                                                                                                                                                                                                                                                  \n",
    "     21   1825.1   2112.9   2273.6   2988.4   3321.2   4029.4                                                                                                                                                                                                                                                  \n",
    "     22   1825.1   2112.9   2273.6   2988.4   3321.2   1941.7                                                                                                                                                                                                                                                  \n",
    "     23   1825.1   2112.9   2273.6   2988.4   3321.2   3550.1                                                                                                                                                                                                                                                  \n",
    "     24   1825.1   2112.9   2273.6   2988.4   3321.2   4451.6                                                                                                                                                                                                                                                  \n",
    "     25   1825.1   2112.9   2273.6   2988.4   3321.2   6107.7                                                                                                                                                                                                                                                  \n",
    "     26   1825.1   2112.9   2273.6   2988.4   3321.2   3769.2                                                                                                                                                                                                                                                  \n",
    "     27   1825.1   2112.9   2273.6   2988.4   3321.2   2303.2                                                                                                                                                                                                                                                  \n",
    "     28   1825.1   2112.9   2273.6   2988.4   3321.2   5734.2                                                                                                                                                                                                                                                  \n",
    "     29   1825.1   2112.9   2273.6   2988.4   3321.2   3702.1                                                                                                                                                                                                                                                  \n",
    "     30   1825.1   2112.9   2273.6   2988.4   3321.2   3270.7                                                                                                                                                                                                                                                  \n",
    "     31   1825.1   2112.9   2273.6   2988.4   3321.2   1931.8                                                                                                                                                                                                                                                  \n",
    "     32   1825.1   2112.9   2273.6   2988.4   3321.2   5958.7                                                                                                                                                                                                                                                  \n",
    "     33   1825.1   2112.9   2273.6   2988.4   3321.2   4810.5                                                                                                                                                                                                                                                  \n",
    "     34   1825.1   2112.9   2273.6   2988.4   3321.2   2240.2                                                                                                                                                                                                                                                  \n",
    "     35   1825.1   2112.9   2273.6   2988.4   3321.2   1910.2                                                                                                                                                                                                                                                  \n",
    "     36   1825.1   2112.9   2273.6   2988.4   3321.2   4936.5                                                                                                                                                                                                                                                  \n",
    "     37   1825.1   2112.9   2273.6   2988.4   3321.2   2219.2                                                                                                                                                                                                                                                  \n",
    "     38   1825.1   2112.9   2273.6   2988.4   3321.2  11018.2                                                                                                                                                                                                                                                  \n",
    "     39   1825.1   2112.9   2273.6   2988.4   3321.2   1261.3                                                                                                                                                                                                                                                  \n",
    "     40   1825.1   2112.9   2273.6   2988.4   3321.2   6442.5                                                                                                                                                                                                                                                  \n",
    "     41   1825.1   2112.9   2273.6   2988.4   3321.2   3831.3                                                                                                                                                                                                                                                  \n",
    "     42   1825.1   2112.9   2273.6   2988.4   3321.2   1641.8                                                                                                                                                                                                                                                  \n",
    "     43   1825.1   2112.9   2273.6   2988.4   3321.2   1669.3                                                                                                                                                                                                                                                  \n",
    "     44   1825.1   2112.9   2273.6   2988.4   3321.2   1949.8                                                                                                                                                                                                                                                  \n",
    "     45   1825.1   2112.9   2273.6   2988.4   3321.2   2947.7                                                                                                                                                                                                                                                  \n",
    "     46   1825.1   2112.9   2273.6   2988.4   3321.2   1703.9                                                                                                                                                                                                                                                  \n",
    "     47   1825.1   2112.9   2273.6   2988.4   3321.2   8913.8                                                                                                                                                                                                                                                  \n",
    "     48   1825.1   2112.9   2273.6   2988.4   3321.2   3642.0                                                                                                                                                                                                                                                  \n",
    "     49   1825.1   2112.9   2273.6   2988.4   3321.2    984.2                                                                                                                                                                                                                                                  \n",
    "     50   1825.1   2112.9   2273.6   2988.4   3321.2   5904.2                                                                                                                                                                                                                                                  \n",
    "     51   1825.1   2112.9   2273.6   2988.4   3321.2   3417.7                                                                                                                                                                                                                                                  \n",
    "     52   1825.1   2112.9   2273.6   2988.4   3321.2   1252.3                                                                                                                                                                                                                                                  \n",
    "     53   1825.1   2112.9   2273.6   2988.4   3321.2   3187.2                                                                                                                                                                                                                                                  \n",
    "     54   1825.1   2112.9   2273.6   2988.4   3321.2   1471.2                                                                                                                                                                                                                                                  \n",
    "     55   1825.1   2112.9   2273.6   2988.4   3321.2   3091.6                                                                                                                                                                                                                                                  \n",
    "     56   1825.1   2112.9   2273.6   2988.4   3321.2   4160.1                                                                                                                                                                                                                                                  \n",
    "     57   1825.1   2112.9   2273.6   2988.4   3321.2   1925.0                                                                                                                                                                                                                                                  \n",
    "     58   1825.1   2112.9   2273.6   2988.4   3321.2   2610.6                                                                                                                                                                                                                                                  \n",
    "     59   1825.1   2112.9   2273.6   2988.4   3321.2   1945.4                                                                                                                                                                                                                                                  \n",
    "     60   1825.1   2112.9   2273.6   2988.4   3321.2   4970.0                                                                                                                                                                                                                                                  \n",
    "     61   1825.1   2112.9   2273.6   2988.4   3321.2   6157.4                                                                                                                                                                                                                                                  \n",
    "     62   1825.1   2112.9   2273.6   2988.4   3321.2   2653.0                                                                                                                                                                                                                                                  \n",
    "     63   1825.1   2112.9   2273.6   2988.4   3321.2   2560.5                                                                                                                                                                                                                                                  \n",
    "     64   1825.1   2112.9   2273.6   2988.4   3321.2   2597.4                                                                                                                                                                                                                                                  \n",
    "     65   1825.1   2112.9   2273.6   2988.4   3321.2   4335.2                                                                                                                                                                                                                                                  \n",
    "     66   1825.1   2112.9   2273.6   2988.4   3321.2   2438.1                                                                                                                                                                                                                                                  \n",
    "     67   1825.1   2112.9   2273.6   2988.4   3321.2   7601.8                                                                                                                                                                                                                                                  \n",
    "     68   1825.1   2112.9   2273.6   2988.4   3321.2   5042.6                                                                                                                                                                                                                                                  \n",
    "     69   1825.1   2112.9   2273.6   2988.4   3321.2   2287.6                                                                                                                                                                                                                                                  \n",
    "     70   1825.1   2112.9   2273.6   2988.4   3321.2   2941.5                                                                                                                                                                                                                                                  \n",
    "     71   1825.1   2112.9   2273.6   2988.4   3321.2   2443.2                                                                                                                                                                                                                                                  \n",
    "     72   1825.1   2112.9   2273.6   2988.4   3321.2   2509.8                                                                                                                                                                                                                                                  \n",
    "     73   1825.1   2112.9   2273.6   2988.4   3321.2   2980.6                                                                                                                                                                                                                                                  \n",
    "     74   1825.1   2112.9   2273.6   2988.4   3321.2   2201.2                                                                                                                                                                                                                                                  \n",
    "     75   1825.1   2112.9   2273.6   2988.4   3321.2   2583.5                                                                                                                                                                                                                                                  \n",
    "     76   1825.1   2112.9   2273.6   2988.4   3321.2   5683.4                                                                                                                                                                                                                                                  \n",
    "     77   1825.1   2112.9   2273.6   2988.4   3321.2   7005.8                                                                                                                                                                                                                                                  \n",
    "     78   1825.1   2112.9   2273.6   2988.4   3321.2   8235.0                                                                                                                                                                                                                                                  \n",
    "     79   1825.1   2112.9   2273.6   2988.4   3321.2   4720.7                                                                                                                                                                                                                                                  \n",
    "     80   1825.1   2112.9   2273.6   2988.4   3321.2   2649.6                                                                                                                                                                                                                                                  \n",
    "     81   1825.1   2112.9   2273.6   2988.4   3321.2   2579.5                                                                                                                                                                                                                                                  \n",
    "     82   1825.1   2112.9   2273.6   2988.4   3321.2   2504.0                                                                                                                                                                                                                                                  \n",
    "     83   1825.1   2112.9   2273.6   2988.4   3321.2   4035.9                                                                                                                                                                                                                                                  \n",
    "     84   1825.1   2112.9   2273.6   2988.4   3321.2   2947.8                                                                                                                                                                                                                                                  \n",
    "     85   1825.1   2112.9   2273.6   2988.4   3321.2   5674.4                                                                                                                                                                                                                                                  \n",
    "     86   1825.1   2112.9   2273.6   2988.4   3321.2   3353.3                                                                                                                                                                                                                                                  \n",
    "     87   1825.1   2112.9   2273.6   2988.4   3321.2   1543.6                                                                                                                                                                                                                                                  \n",
    "     88   1825.1   2112.9   2273.6   2988.4   3321.2   2700.1                                                                                                                                                                                                                                                  \n",
    "     89   1825.1   2112.9   2273.6   2988.4   3321.2   6229.9                                                                                                                                                                                                                                                  \n",
    "     90   1825.1   2112.9   2273.6   2988.4   3321.2   3913.1                                                                                                                                                                                                                                                  \n",
    "     91   1825.1   2112.9   2273.6   2988.4   3321.2   3394.0                                                                                                                                                                                                                                                  \n",
    "     92   1825.1   2112.9   2273.6   2988.4   3321.2   1958.9                                                                                                                                                                                                                                                  \n",
    "     93   1825.1   2112.9   2273.6   2988.4   3321.2   4593.8                                                                                                                                                                                                                                                  \n",
    "     94   1825.1   2112.9   2273.6   2988.4   3321.2   7970.1                                                                                                                                                                                                                                                  \n",
    "     95   1825.1   2112.9   2273.6   2988.4   3321.2   3140.8                                                                                                                                                                                                                                                  \n",
    "     96   1825.1   2112.9   2273.6   2988.4   3321.2   1969.8                                                                                                                                                                                                                                                  \n",
    "     97   1825.1   2112.9   2273.6   2988.4   3321.2   3462.5                                                                                                                                                                                                                                                  \n",
    "     98   1825.1   2112.9   2273.6   2988.4   3321.2   5399.4                                                                                                                                                                                                                                                  \n",
    "     99   1825.1   2112.9   2273.6   2988.4   3321.2   6133.1                                                                                                                                                                                                                                                  \n",
    "    100   1825.1   2112.9   2273.6   2988.4   3321.2   1507.8                                                                                                                                                                                                                                                  \n",
    "    101   1825.1   2112.9   2273.6   2988.4   3321.2   3272.2                                                                                                                                                                                                                                                  \n",
    "    102   1825.1   2112.9   2273.6   2988.4   3321.2   2712.0                                                                                                                                                                                                                                                  \n",
    "    103   1825.1   2112.9   2273.6   2988.4   3321.2   3784.0                                                                                                                                                                                                                                                  \n",
    "    104   1825.1   2112.9   2273.6   2988.4   3321.2   2095.6                                                                                                                                                                                                                                                  \n",
    "    105   1825.1   2112.9   2273.6   2988.4   3321.2   5002.3                                                                                                                                                                                                                                                  \n",
    "    106   1825.1   2112.9   2273.6   2988.4   3321.2   1721.9                                                                                                                                                                                                                                                  \n",
    "    107   1825.1   2112.9   2273.6   2988.4   3321.2   1613.9                                                                                                                                                                                                                                                  \n",
    "    108   1825.1   2112.9   2273.6   2988.4   3321.2   7717.4                                                                                                                                                                                                                                                  \n",
    "    109   1825.1   2112.9   2273.6   2988.4   3321.2   3767.0                                                                                                                                                                                                                                                  \n",
    "    110   1825.1   2112.9   2273.6   2988.4   3321.2   1356.8                                                                                                                                                                                                                                                  \n",
    "    111   1825.1   2112.9   2273.6   2988.4   3321.2   1713.3                                                                                                                                                                                                                                                  \n",
    "    112   1825.1   2112.9   2273.6   2988.4   3321.2   1227.5                                                                                                                                                                                                                                                  \n",
    "    113   1825.1   2112.9   2273.6   2988.4   3321.2   3177.1                                                                                                                                                                                                                                                  \n",
    "    114   1825.1   2112.9   2273.6   2988.4   3321.2   3736.7                                                                                                                                                                                                                                                  \n",
    "    115   1825.1   2112.9   2273.6   2988.4   3321.2   1910.0                                                                                                                                                                                                                                                  \n",
    "    116   1825.1   2112.9   2273.6   2988.4   3321.2   2569.8                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:    3 - NORDESTE  / SUBSISTEMA:    3 - NE\n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   4713.2   3509.6   2906.4   4092.6   5238.6   6180.1                                                                                                                                                                                                                                                  \n",
    "      2   4713.2   3509.6   2906.4   4092.6   5238.6   7255.4                                                                                                                                                                                                                                                  \n",
    "      3   4713.2   3509.6   2906.4   4092.6   5238.6   5992.3                                                                                                                                                                                                                                                  \n",
    "      4   4713.2   3509.6   2906.4   4092.6   5238.6   3170.5                                                                                                                                                                                                                                                  \n",
    "      5   4713.2   3509.6   2906.4   4092.6   5238.6   7934.8                                                                                                                                                                                                                                                  \n",
    "      6   4713.2   3509.6   2906.4   4092.6   5238.6   6856.9                                                                                                                                                                                                                                                  \n",
    "      7   4713.2   3509.6   2906.4   4092.6   5238.6   6543.7                                                                                                                                                                                                                                                  \n",
    "      8   4713.2   3509.6   2906.4   4092.6   5238.6  10017.9                                                                                                                                                                                                                                                  \n",
    "      9   4713.2   3509.6   2906.4   4092.6   5238.6   4007.4                                                                                                                                                                                                                                                  \n",
    "     10   4713.2   3509.6   2906.4   4092.6   5238.6   4766.4                                                                                                                                                                                                                                                  \n",
    "     11   4713.2   3509.6   2906.4   4092.6   5238.6  14065.0                                                                                                                                                                                                                                                  \n",
    "     12   4713.2   3509.6   2906.4   4092.6   5238.6   5379.3                                                                                                                                                                                                                                                  \n",
    "     13   4713.2   3509.6   2906.4   4092.6   5238.6   9360.1                                                                                                                                                                                                                                                  \n",
    "     14   4713.2   3509.6   2906.4   4092.6   5238.6   7387.0                                                                                                                                                                                                                                                  \n",
    "     15   4713.2   3509.6   2906.4   4092.6   5238.6  10026.8                                                                                                                                                                                                                                                  \n",
    "     16   4713.2   3509.6   2906.4   4092.6   5238.6   6720.2                                                                                                                                                                                                                                                  \n",
    "     17   4713.2   3509.6   2906.4   4092.6   5238.6  13191.9                                                                                                                                                                                                                                                  \n",
    "     18   4713.2   3509.6   2906.4   4092.6   5238.6   4685.5                                                                                                                                                                                                                                                  \n",
    "     19   4713.2   3509.6   2906.4   4092.6   5238.6   4157.3                                                                                                                                                                                                                                                  \n",
    "     20   4713.2   3509.6   2906.4   4092.6   5238.6   8983.6                                                                                                                                                                                                                                                  \n",
    "     21   4713.2   3509.6   2906.4   4092.6   5238.6  17204.7                                                                                                                                                                                                                                                  \n",
    "     22   4713.2   3509.6   2906.4   4092.6   5238.6   7374.8                                                                                                                                                                                                                                                  \n",
    "     23   4713.2   3509.6   2906.4   4092.6   5238.6  10488.9                                                                                                                                                                                                                                                  \n",
    "     24   4713.2   3509.6   2906.4   4092.6   5238.6  18610.3                                                                                                                                                                                                                                                  \n",
    "     25   4713.2   3509.6   2906.4   4092.6   5238.6  13028.2                                                                                                                                                                                                                                                  \n",
    "     26   4713.2   3509.6   2906.4   4092.6   5238.6   3375.3                                                                                                                                                                                                                                                  \n",
    "     27   4713.2   3509.6   2906.4   4092.6   5238.6   9842.1                                                                                                                                                                                                                                                  \n",
    "     28   4713.2   3509.6   2906.4   4092.6   5238.6   4518.0                                                                                                                                                                                                                                                  \n",
    "     29   4713.2   3509.6   2906.4   4092.6   5238.6   3519.1                                                                                                                                                                                                                                                  \n",
    "     30   4713.2   3509.6   2906.4   4092.6   5238.6   6972.3                                                                                                                                                                                                                                                  \n",
    "     31   4713.2   3509.6   2906.4   4092.6   5238.6  16316.8                                                                                                                                                                                                                                                  \n",
    "     32   4713.2   3509.6   2906.4   4092.6   5238.6   3987.1                                                                                                                                                                                                                                                  \n",
    "     33   4713.2   3509.6   2906.4   4092.6   5238.6   7759.9                                                                                                                                                                                                                                                  \n",
    "     34   4713.2   3509.6   2906.4   4092.6   5238.6   4079.1                                                                                                                                                                                                                                                  \n",
    "     35   4713.2   3509.6   2906.4   4092.6   5238.6   3636.4                                                                                                                                                                                                                                                  \n",
    "     36   4713.2   3509.6   2906.4   4092.6   5238.6  15658.0                                                                                                                                                                                                                                                  \n",
    "     37   4713.2   3509.6   2906.4   4092.6   5238.6  11017.1                                                                                                                                                                                                                                                  \n",
    "     38   4713.2   3509.6   2906.4   4092.6   5238.6   6239.7                                                                                                                                                                                                                                                  \n",
    "     39   4713.2   3509.6   2906.4   4092.6   5238.6  20562.0                                                                                                                                                                                                                                                  \n",
    "     40   4713.2   3509.6   2906.4   4092.6   5238.6   7167.2                                                                                                                                                                                                                                                  \n",
    "     41   4713.2   3509.6   2906.4   4092.6   5238.6   7611.5                                                                                                                                                                                                                                                  \n",
    "     42   4713.2   3509.6   2906.4   4092.6   5238.6   5067.2                                                                                                                                                                                                                                                  \n",
    "     43   4713.2   3509.6   2906.4   4092.6   5238.6   3019.4                                                                                                                                                                                                                                                  \n",
    "     44   4713.2   3509.6   2906.4   4092.6   5238.6   5251.2                                                                                                                                                                                                                                                  \n",
    "     45   4713.2   3509.6   2906.4   4092.6   5238.6   9640.8                                                                                                                                                                                                                                                  \n",
    "     46   4713.2   3509.6   2906.4   4092.6   5238.6  11962.9                                                                                                                                                                                                                                                  \n",
    "     47   4713.2   3509.6   2906.4   4092.6   5238.6  12904.9                                                                                                                                                                                                                                                  \n",
    "     48   4713.2   3509.6   2906.4   4092.6   5238.6   8928.1                                                                                                                                                                                                                                                  \n",
    "     49   4713.2   3509.6   2906.4   4092.6   5238.6   4648.3                                                                                                                                                                                                                                                  \n",
    "     50   4713.2   3509.6   2906.4   4092.6   5238.6   8019.6                                                                                                                                                                                                                                                  \n",
    "     51   4713.2   3509.6   2906.4   4092.6   5238.6  14178.0                                                                                                                                                                                                                                                  \n",
    "     52   4713.2   3509.6   2906.4   4092.6   5238.6  18011.6                                                                                                                                                                                                                                                  \n",
    "     53   4713.2   3509.6   2906.4   4092.6   5238.6   4873.8                                                                                                                                                                                                                                                  \n",
    "     54   4713.2   3509.6   2906.4   4092.6   5238.6   7602.2                                                                                                                                                                                                                                                  \n",
    "     55   4713.2   3509.6   2906.4   4092.6   5238.6   9541.8                                                                                                                                                                                                                                                  \n",
    "     56   4713.2   3509.6   2906.4   4092.6   5238.6   5825.5                                                                                                                                                                                                                                                  \n",
    "     57   4713.2   3509.6   2906.4   4092.6   5238.6   6286.2                                                                                                                                                                                                                                                  \n",
    "     58   4713.2   3509.6   2906.4   4092.6   5238.6  13621.5                                                                                                                                                                                                                                                  \n",
    "     59   4713.2   3509.6   2906.4   4092.6   5238.6   5145.2                                                                                                                                                                                                                                                  \n",
    "     60   4713.2   3509.6   2906.4   4092.6   5238.6   9494.4                                                                                                                                                                                                                                                  \n",
    "     61   4713.2   3509.6   2906.4   4092.6   5238.6   5718.5                                                                                                                                                                                                                                                  \n",
    "     62   4713.2   3509.6   2906.4   4092.6   5238.6   8246.3                                                                                                                                                                                                                                                  \n",
    "     63   4713.2   3509.6   2906.4   4092.6   5238.6   6725.8                                                                                                                                                                                                                                                  \n",
    "     64   4713.2   3509.6   2906.4   4092.6   5238.6   7108.1                                                                                                                                                                                                                                                  \n",
    "     65   4713.2   3509.6   2906.4   4092.6   5238.6   7652.3                                                                                                                                                                                                                                                  \n",
    "     66   4713.2   3509.6   2906.4   4092.6   5238.6  17764.2                                                                                                                                                                                                                                                  \n",
    "     67   4713.2   3509.6   2906.4   4092.6   5238.6   4702.6                                                                                                                                                                                                                                                  \n",
    "     68   4713.2   3509.6   2906.4   4092.6   5238.6   5091.0                                                                                                                                                                                                                                                  \n",
    "     69   4713.2   3509.6   2906.4   4092.6   5238.6   4890.1                                                                                                                                                                                                                                                  \n",
    "     70   4713.2   3509.6   2906.4   4092.6   5238.6   6794.4                                                                                                                                                                                                                                                  \n",
    "     71   4713.2   3509.6   2906.4   4092.6   5238.6   8260.2                                                                                                                                                                                                                                                  \n",
    "     72   4713.2   3509.6   2906.4   4092.6   5238.6  10074.7                                                                                                                                                                                                                                                  \n",
    "     73   4713.2   3509.6   2906.4   4092.6   5238.6   5707.9                                                                                                                                                                                                                                                  \n",
    "     74   4713.2   3509.6   2906.4   4092.6   5238.6   7657.3                                                                                                                                                                                                                                                  \n",
    "     75   4713.2   3509.6   2906.4   4092.6   5238.6   4107.8                                                                                                                                                                                                                                                  \n",
    "     76   4713.2   3509.6   2906.4   4092.6   5238.6   8165.4                                                                                                                                                                                                                                                  \n",
    "     77   4713.2   3509.6   2906.4   4092.6   5238.6   7301.8                                                                                                                                                                                                                                                  \n",
    "     78   4713.2   3509.6   2906.4   4092.6   5238.6   4530.3                                                                                                                                                                                                                                                  \n",
    "     79   4713.2   3509.6   2906.4   4092.6   5238.6  14928.6                                                                                                                                                                                                                                                  \n",
    "     80   4713.2   3509.6   2906.4   4092.6   5238.6   8121.5                                                                                                                                                                                                                                                  \n",
    "     81   4713.2   3509.6   2906.4   4092.6   5238.6  14533.1                                                                                                                                                                                                                                                  \n",
    "     82   4713.2   3509.6   2906.4   4092.6   5238.6   4776.6                                                                                                                                                                                                                                                  \n",
    "     83   4713.2   3509.6   2906.4   4092.6   5238.6  12055.4                                                                                                                                                                                                                                                  \n",
    "     84   4713.2   3509.6   2906.4   4092.6   5238.6  12431.9                                                                                                                                                                                                                                                  \n",
    "     85   4713.2   3509.6   2906.4   4092.6   5238.6   6764.2                                                                                                                                                                                                                                                  \n",
    "     86   4713.2   3509.6   2906.4   4092.6   5238.6   6418.0                                                                                                                                                                                                                                                  \n",
    "     87   4713.2   3509.6   2906.4   4092.6   5238.6   7867.7                                                                                                                                                                                                                                                  \n",
    "     88   4713.2   3509.6   2906.4   4092.6   5238.6   4335.7                                                                                                                                                                                                                                                  \n",
    "     89   4713.2   3509.6   2906.4   4092.6   5238.6   4784.1                                                                                                                                                                                                                                                  \n",
    "     90   4713.2   3509.6   2906.4   4092.6   5238.6   9795.1                                                                                                                                                                                                                                                  \n",
    "     91   4713.2   3509.6   2906.4   4092.6   5238.6   4894.5                                                                                                                                                                                                                                                  \n",
    "     92   4713.2   3509.6   2906.4   4092.6   5238.6  14203.8                                                                                                                                                                                                                                                  \n",
    "     93   4713.2   3509.6   2906.4   4092.6   5238.6   3717.3                                                                                                                                                                                                                                                  \n",
    "     94   4713.2   3509.6   2906.4   4092.6   5238.6   6692.2                                                                                                                                                                                                                                                  \n",
    "     95   4713.2   3509.6   2906.4   4092.6   5238.6   4629.4                                                                                                                                                                                                                                                  \n",
    "     96   4713.2   3509.6   2906.4   4092.6   5238.6   7314.8                                                                                                                                                                                                                                                  \n",
    "     97   4713.2   3509.6   2906.4   4092.6   5238.6  19533.5                                                                                                                                                                                                                                                  \n",
    "     98   4713.2   3509.6   2906.4   4092.6   5238.6   4232.5                                                                                                                                                                                                                                                  \n",
    "     99   4713.2   3509.6   2906.4   4092.6   5238.6   2796.1                                                                                                                                                                                                                                                  \n",
    "    100   4713.2   3509.6   2906.4   4092.6   5238.6   6969.5                                                                                                                                                                                                                                                  \n",
    "    101   4713.2   3509.6   2906.4   4092.6   5238.6   7201.6                                                                                                                                                                                                                                                  \n",
    "    102   4713.2   3509.6   2906.4   4092.6   5238.6  10710.1                                                                                                                                                                                                                                                  \n",
    "    103   4713.2   3509.6   2906.4   4092.6   5238.6   7544.7                                                                                                                                                                                                                                                  \n",
    "    104   4713.2   3509.6   2906.4   4092.6   5238.6   8222.1                                                                                                                                                                                                                                                  \n",
    "    105   4713.2   3509.6   2906.4   4092.6   5238.6   3842.0                                                                                                                                                                                                                                                  \n",
    "    106   4713.2   3509.6   2906.4   4092.6   5238.6   4625.3                                                                                                                                                                                                                                                  \n",
    "    107   4713.2   3509.6   2906.4   4092.6   5238.6   6672.0                                                                                                                                                                                                                                                  \n",
    "    108   4713.2   3509.6   2906.4   4092.6   5238.6   6635.6                                                                                                                                                                                                                                                  \n",
    "    109   4713.2   3509.6   2906.4   4092.6   5238.6   6930.5                                                                                                                                                                                                                                                  \n",
    "    110   4713.2   3509.6   2906.4   4092.6   5238.6   7876.8                                                                                                                                                                                                                                                  \n",
    "    111   4713.2   3509.6   2906.4   4092.6   5238.6  14904.5                                                                                                                                                                                                                                                  \n",
    "    112   4713.2   3509.6   2906.4   4092.6   5238.6   4984.6                                                                                                                                                                                                                                                  \n",
    "    113   4713.2   3509.6   2906.4   4092.6   5238.6   7453.6                                                                                                                                                                                                                                                  \n",
    "    114   4713.2   3509.6   2906.4   4092.6   5238.6   9881.6                                                                                                                                                                                                                                                  \n",
    "    115   4713.2   3509.6   2906.4   4092.6   5238.6   6086.6                                                                                                                                                                                                                                                  \n",
    "    116   4713.2   3509.6   2906.4   4092.6   5238.6   4972.8                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:    4 - NORTE     / SUBSISTEMA:    4 - N \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   2672.4   3044.8   3911.9   4835.0   6038.1  12030.1                                                                                                                                                                                                                                                  \n",
    "      2   2672.4   3044.8   3911.9   4835.0   6038.1   7860.6                                                                                                                                                                                                                                                  \n",
    "      3   2672.4   3044.8   3911.9   4835.0   6038.1   5848.2                                                                                                                                                                                                                                                  \n",
    "      4   2672.4   3044.8   3911.9   4835.0   6038.1   5574.2                                                                                                                                                                                                                                                  \n",
    "      5   2672.4   3044.8   3911.9   4835.0   6038.1   7981.8                                                                                                                                                                                                                                                  \n",
    "      6   2672.4   3044.8   3911.9   4835.0   6038.1   7099.0                                                                                                                                                                                                                                                  \n",
    "      7   2672.4   3044.8   3911.9   4835.0   6038.1  11478.6                                                                                                                                                                                                                                                  \n",
    "      8   2672.4   3044.8   3911.9   4835.0   6038.1   9784.7                                                                                                                                                                                                                                                  \n",
    "      9   2672.4   3044.8   3911.9   4835.0   6038.1   8141.6                                                                                                                                                                                                                                                  \n",
    "     10   2672.4   3044.8   3911.9   4835.0   6038.1   6414.9                                                                                                                                                                                                                                                  \n",
    "     11   2672.4   3044.8   3911.9   4835.0   6038.1  11897.4                                                                                                                                                                                                                                                  \n",
    "     12   2672.4   3044.8   3911.9   4835.0   6038.1   5984.4                                                                                                                                                                                                                                                  \n",
    "     13   2672.4   3044.8   3911.9   4835.0   6038.1   8652.1                                                                                                                                                                                                                                                  \n",
    "     14   2672.4   3044.8   3911.9   4835.0   6038.1   4344.1                                                                                                                                                                                                                                                  \n",
    "     15   2672.4   3044.8   3911.9   4835.0   6038.1  11610.8                                                                                                                                                                                                                                                  \n",
    "     16   2672.4   3044.8   3911.9   4835.0   6038.1   7975.1                                                                                                                                                                                                                                                  \n",
    "     17   2672.4   3044.8   3911.9   4835.0   6038.1  10607.7                                                                                                                                                                                                                                                  \n",
    "     18   2672.4   3044.8   3911.9   4835.0   6038.1   4509.1                                                                                                                                                                                                                                                  \n",
    "     19   2672.4   3044.8   3911.9   4835.0   6038.1   7005.0                                                                                                                                                                                                                                                  \n",
    "     20   2672.4   3044.8   3911.9   4835.0   6038.1  13834.8                                                                                                                                                                                                                                                  \n",
    "     21   2672.4   3044.8   3911.9   4835.0   6038.1  13906.9                                                                                                                                                                                                                                                  \n",
    "     22   2672.4   3044.8   3911.9   4835.0   6038.1  10193.6                                                                                                                                                                                                                                                  \n",
    "     23   2672.4   3044.8   3911.9   4835.0   6038.1  17062.2                                                                                                                                                                                                                                                  \n",
    "     24   2672.4   3044.8   3911.9   4835.0   6038.1  11050.8                                                                                                                                                                                                                                                  \n",
    "     25   2672.4   3044.8   3911.9   4835.0   6038.1  17769.3                                                                                                                                                                                                                                                  \n",
    "     26   2672.4   3044.8   3911.9   4835.0   6038.1   7804.1                                                                                                                                                                                                                                                  \n",
    "     27   2672.4   3044.8   3911.9   4835.0   6038.1   9412.2                                                                                                                                                                                                                                                  \n",
    "     28   2672.4   3044.8   3911.9   4835.0   6038.1   7928.1                                                                                                                                                                                                                                                  \n",
    "     29   2672.4   3044.8   3911.9   4835.0   6038.1   7815.2                                                                                                                                                                                                                                                  \n",
    "     30   2672.4   3044.8   3911.9   4835.0   6038.1   7112.5                                                                                                                                                                                                                                                  \n",
    "     31   2672.4   3044.8   3911.9   4835.0   6038.1  16193.5                                                                                                                                                                                                                                                  \n",
    "     32   2672.4   3044.8   3911.9   4835.0   6038.1   5571.6                                                                                                                                                                                                                                                  \n",
    "     33   2672.4   3044.8   3911.9   4835.0   6038.1   7715.4                                                                                                                                                                                                                                                  \n",
    "     34   2672.4   3044.8   3911.9   4835.0   6038.1   5298.1                                                                                                                                                                                                                                                  \n",
    "     35   2672.4   3044.8   3911.9   4835.0   6038.1   7993.3                                                                                                                                                                                                                                                  \n",
    "     36   2672.4   3044.8   3911.9   4835.0   6038.1  15327.0                                                                                                                                                                                                                                                  \n",
    "     37   2672.4   3044.8   3911.9   4835.0   6038.1  12439.1                                                                                                                                                                                                                                                  \n",
    "     38   2672.4   3044.8   3911.9   4835.0   6038.1  11301.2                                                                                                                                                                                                                                                  \n",
    "     39   2672.4   3044.8   3911.9   4835.0   6038.1  14503.3                                                                                                                                                                                                                                                  \n",
    "     40   2672.4   3044.8   3911.9   4835.0   6038.1   4996.6                                                                                                                                                                                                                                                  \n",
    "     41   2672.4   3044.8   3911.9   4835.0   6038.1   9260.4                                                                                                                                                                                                                                                  \n",
    "     42   2672.4   3044.8   3911.9   4835.0   6038.1   5158.8                                                                                                                                                                                                                                                  \n",
    "     43   2672.4   3044.8   3911.9   4835.0   6038.1   4065.0                                                                                                                                                                                                                                                  \n",
    "     44   2672.4   3044.8   3911.9   4835.0   6038.1   6717.7                                                                                                                                                                                                                                                  \n",
    "     45   2672.4   3044.8   3911.9   4835.0   6038.1   6871.3                                                                                                                                                                                                                                                  \n",
    "     46   2672.4   3044.8   3911.9   4835.0   6038.1  17306.3                                                                                                                                                                                                                                                  \n",
    "     47   2672.4   3044.8   3911.9   4835.0   6038.1  11548.1                                                                                                                                                                                                                                                  \n",
    "     48   2672.4   3044.8   3911.9   4835.0   6038.1  13237.5                                                                                                                                                                                                                                                  \n",
    "     49   2672.4   3044.8   3911.9   4835.0   6038.1   8456.6                                                                                                                                                                                                                                                  \n",
    "     50   2672.4   3044.8   3911.9   4835.0   6038.1  11531.3                                                                                                                                                                                                                                                  \n",
    "     51   2672.4   3044.8   3911.9   4835.0   6038.1  11220.7                                                                                                                                                                                                                                                  \n",
    "     52   2672.4   3044.8   3911.9   4835.0   6038.1  18595.2                                                                                                                                                                                                                                                  \n",
    "     53   2672.4   3044.8   3911.9   4835.0   6038.1  10971.2                                                                                                                                                                                                                                                  \n",
    "     54   2672.4   3044.8   3911.9   4835.0   6038.1  13759.6                                                                                                                                                                                                                                                  \n",
    "     55   2672.4   3044.8   3911.9   4835.0   6038.1  12432.5                                                                                                                                                                                                                                                  \n",
    "     56   2672.4   3044.8   3911.9   4835.0   6038.1   5571.0                                                                                                                                                                                                                                                  \n",
    "     57   2672.4   3044.8   3911.9   4835.0   6038.1   9283.7                                                                                                                                                                                                                                                  \n",
    "     58   2672.4   3044.8   3911.9   4835.0   6038.1   8119.1                                                                                                                                                                                                                                                  \n",
    "     59   2672.4   3044.8   3911.9   4835.0   6038.1   5721.0                                                                                                                                                                                                                                                  \n",
    "     60   2672.4   3044.8   3911.9   4835.0   6038.1  14416.9                                                                                                                                                                                                                                                  \n",
    "     61   2672.4   3044.8   3911.9   4835.0   6038.1  10877.7                                                                                                                                                                                                                                                  \n",
    "     62   2672.4   3044.8   3911.9   4835.0   6038.1   8189.6                                                                                                                                                                                                                                                  \n",
    "     63   2672.4   3044.8   3911.9   4835.0   6038.1  14702.4                                                                                                                                                                                                                                                  \n",
    "     64   2672.4   3044.8   3911.9   4835.0   6038.1   6072.2                                                                                                                                                                                                                                                  \n",
    "     65   2672.4   3044.8   3911.9   4835.0   6038.1   5941.7                                                                                                                                                                                                                                                  \n",
    "     66   2672.4   3044.8   3911.9   4835.0   6038.1  11729.1                                                                                                                                                                                                                                                  \n",
    "     67   2672.4   3044.8   3911.9   4835.0   6038.1   7012.0                                                                                                                                                                                                                                                  \n",
    "     68   2672.4   3044.8   3911.9   4835.0   6038.1   8076.8                                                                                                                                                                                                                                                  \n",
    "     69   2672.4   3044.8   3911.9   4835.0   6038.1   5662.0                                                                                                                                                                                                                                                  \n",
    "     70   2672.4   3044.8   3911.9   4835.0   6038.1   9962.1                                                                                                                                                                                                                                                  \n",
    "     71   2672.4   3044.8   3911.9   4835.0   6038.1  11307.4                                                                                                                                                                                                                                                  \n",
    "     72   2672.4   3044.8   3911.9   4835.0   6038.1  10834.4                                                                                                                                                                                                                                                  \n",
    "     73   2672.4   3044.8   3911.9   4835.0   6038.1   4419.0                                                                                                                                                                                                                                                  \n",
    "     74   2672.4   3044.8   3911.9   4835.0   6038.1  11873.3                                                                                                                                                                                                                                                  \n",
    "     75   2672.4   3044.8   3911.9   4835.0   6038.1   6434.9                                                                                                                                                                                                                                                  \n",
    "     76   2672.4   3044.8   3911.9   4835.0   6038.1   8421.6                                                                                                                                                                                                                                                  \n",
    "     77   2672.4   3044.8   3911.9   4835.0   6038.1  10883.2                                                                                                                                                                                                                                                  \n",
    "     78   2672.4   3044.8   3911.9   4835.0   6038.1   6480.0                                                                                                                                                                                                                                                  \n",
    "     79   2672.4   3044.8   3911.9   4835.0   6038.1  13209.9                                                                                                                                                                                                                                                  \n",
    "     80   2672.4   3044.8   3911.9   4835.0   6038.1  17034.6                                                                                                                                                                                                                                                  \n",
    "     81   2672.4   3044.8   3911.9   4835.0   6038.1  10240.4                                                                                                                                                                                                                                                  \n",
    "     82   2672.4   3044.8   3911.9   4835.0   6038.1   7803.4                                                                                                                                                                                                                                                  \n",
    "     83   2672.4   3044.8   3911.9   4835.0   6038.1  20786.0                                                                                                                                                                                                                                                  \n",
    "     84   2672.4   3044.8   3911.9   4835.0   6038.1  11054.2                                                                                                                                                                                                                                                  \n",
    "     85   2672.4   3044.8   3911.9   4835.0   6038.1   8240.9                                                                                                                                                                                                                                                  \n",
    "     86   2672.4   3044.8   3911.9   4835.0   6038.1   7928.2                                                                                                                                                                                                                                                  \n",
    "     87   2672.4   3044.8   3911.9   4835.0   6038.1  12872.0                                                                                                                                                                                                                                                  \n",
    "     88   2672.4   3044.8   3911.9   4835.0   6038.1   5248.8                                                                                                                                                                                                                                                  \n",
    "     89   2672.4   3044.8   3911.9   4835.0   6038.1   6984.6                                                                                                                                                                                                                                                  \n",
    "     90   2672.4   3044.8   3911.9   4835.0   6038.1   9678.1                                                                                                                                                                                                                                                  \n",
    "     91   2672.4   3044.8   3911.9   4835.0   6038.1   5684.3                                                                                                                                                                                                                                                  \n",
    "     92   2672.4   3044.8   3911.9   4835.0   6038.1  14104.9                                                                                                                                                                                                                                                  \n",
    "     93   2672.4   3044.8   3911.9   4835.0   6038.1   5262.3                                                                                                                                                                                                                                                  \n",
    "     94   2672.4   3044.8   3911.9   4835.0   6038.1   8926.1                                                                                                                                                                                                                                                  \n",
    "     95   2672.4   3044.8   3911.9   4835.0   6038.1   3995.3                                                                                                                                                                                                                                                  \n",
    "     96   2672.4   3044.8   3911.9   4835.0   6038.1   8097.2                                                                                                                                                                                                                                                  \n",
    "     97   2672.4   3044.8   3911.9   4835.0   6038.1  16077.2                                                                                                                                                                                                                                                  \n",
    "     98   2672.4   3044.8   3911.9   4835.0   6038.1   6260.2                                                                                                                                                                                                                                                  \n",
    "     99   2672.4   3044.8   3911.9   4835.0   6038.1   3588.3                                                                                                                                                                                                                                                  \n",
    "    100   2672.4   3044.8   3911.9   4835.0   6038.1  10186.4                                                                                                                                                                                                                                                  \n",
    "    101   2672.4   3044.8   3911.9   4835.0   6038.1  12061.5                                                                                                                                                                                                                                                  \n",
    "    102   2672.4   3044.8   3911.9   4835.0   6038.1  11182.6                                                                                                                                                                                                                                                  \n",
    "    103   2672.4   3044.8   3911.9   4835.0   6038.1  15022.2                                                                                                                                                                                                                                                  \n",
    "    104   2672.4   3044.8   3911.9   4835.0   6038.1  10050.1                                                                                                                                                                                                                                                  \n",
    "    105   2672.4   3044.8   3911.9   4835.0   6038.1   6247.1                                                                                                                                                                                                                                                  \n",
    "    106   2672.4   3044.8   3911.9   4835.0   6038.1   4023.6                                                                                                                                                                                                                                                  \n",
    "    107   2672.4   3044.8   3911.9   4835.0   6038.1   8109.9                                                                                                                                                                                                                                                  \n",
    "    108   2672.4   3044.8   3911.9   4835.0   6038.1   6620.9                                                                                                                                                                                                                                                  \n",
    "    109   2672.4   3044.8   3911.9   4835.0   6038.1   5572.7                                                                                                                                                                                                                                                  \n",
    "    110   2672.4   3044.8   3911.9   4835.0   6038.1   9567.8                                                                                                                                                                                                                                                  \n",
    "    111   2672.4   3044.8   3911.9   4835.0   6038.1  16999.3                                                                                                                                                                                                                                                  \n",
    "    112   2672.4   3044.8   3911.9   4835.0   6038.1   6771.3                                                                                                                                                                                                                                                  \n",
    "    113   2672.4   3044.8   3911.9   4835.0   6038.1  10885.5                                                                                                                                                                                                                                                  \n",
    "    114   2672.4   3044.8   3911.9   4835.0   6038.1  14661.9                                                                                                                                                                                                                                                  \n",
    "    115   2672.4   3044.8   3911.9   4835.0   6038.1   6636.2                                                                                                                                                                                                                                                  \n",
    "    116   2672.4   3044.8   3911.9   4835.0   6038.1   6013.0                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:    8 - BMONTE    / SUBSISTEMA:    4 - N \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1   2279.9   2609.1   3628.0   4745.3   5798.7   8394.4                                                                                                                                                                                                                                                  \n",
    "      2   2279.9   2609.1   3628.0   4745.3   5798.7   4097.9                                                                                                                                                                                                                                                  \n",
    "      3   2279.9   2609.1   3628.0   4745.3   5798.7   7097.4                                                                                                                                                                                                                                                  \n",
    "      4   2279.9   2609.1   3628.0   4745.3   5798.7   6784.1                                                                                                                                                                                                                                                  \n",
    "      5   2279.9   2609.1   3628.0   4745.3   5798.7   6696.4                                                                                                                                                                                                                                                  \n",
    "      6   2279.9   2609.1   3628.0   4745.3   5798.7   8720.6                                                                                                                                                                                                                                                  \n",
    "      7   2279.9   2609.1   3628.0   4745.3   5798.7   6968.9                                                                                                                                                                                                                                                  \n",
    "      8   2279.9   2609.1   3628.0   4745.3   5798.7   7379.2                                                                                                                                                                                                                                                  \n",
    "      9   2279.9   2609.1   3628.0   4745.3   5798.7   7906.7                                                                                                                                                                                                                                                  \n",
    "     10   2279.9   2609.1   3628.0   4745.3   5798.7   5017.3                                                                                                                                                                                                                                                  \n",
    "     11   2279.9   2609.1   3628.0   4745.3   5798.7  11614.1                                                                                                                                                                                                                                                  \n",
    "     12   2279.9   2609.1   3628.0   4745.3   5798.7   9346.4                                                                                                                                                                                                                                                  \n",
    "     13   2279.9   2609.1   3628.0   4745.3   5798.7  11000.0                                                                                                                                                                                                                                                  \n",
    "     14   2279.9   2609.1   3628.0   4745.3   5798.7   7166.2                                                                                                                                                                                                                                                  \n",
    "     15   2279.9   2609.1   3628.0   4745.3   5798.7  12328.3                                                                                                                                                                                                                                                  \n",
    "     16   2279.9   2609.1   3628.0   4745.3   5798.7   6729.8                                                                                                                                                                                                                                                  \n",
    "     17   2279.9   2609.1   3628.0   4745.3   5798.7   6071.3                                                                                                                                                                                                                                                  \n",
    "     18   2279.9   2609.1   3628.0   4745.3   5798.7   5683.6                                                                                                                                                                                                                                                  \n",
    "     19   2279.9   2609.1   3628.0   4745.3   5798.7   6714.6                                                                                                                                                                                                                                                  \n",
    "     20   2279.9   2609.1   3628.0   4745.3   5798.7  11634.5                                                                                                                                                                                                                                                  \n",
    "     21   2279.9   2609.1   3628.0   4745.3   5798.7   7821.6                                                                                                                                                                                                                                                  \n",
    "     22   2279.9   2609.1   3628.0   4745.3   5798.7  10752.5                                                                                                                                                                                                                                                  \n",
    "     23   2279.9   2609.1   3628.0   4745.3   5798.7   9982.9                                                                                                                                                                                                                                                  \n",
    "     24   2279.9   2609.1   3628.0   4745.3   5798.7  10544.4                                                                                                                                                                                                                                                  \n",
    "     25   2279.9   2609.1   3628.0   4745.3   5798.7   7638.4                                                                                                                                                                                                                                                  \n",
    "     26   2279.9   2609.1   3628.0   4745.3   5798.7  10781.0                                                                                                                                                                                                                                                  \n",
    "     27   2279.9   2609.1   3628.0   4745.3   5798.7   4841.4                                                                                                                                                                                                                                                  \n",
    "     28   2279.9   2609.1   3628.0   4745.3   5798.7   7633.9                                                                                                                                                                                                                                                  \n",
    "     29   2279.9   2609.1   3628.0   4745.3   5798.7   9402.1                                                                                                                                                                                                                                                  \n",
    "     30   2279.9   2609.1   3628.0   4745.3   5798.7   5533.9                                                                                                                                                                                                                                                  \n",
    "     31   2279.9   2609.1   3628.0   4745.3   5798.7  11832.8                                                                                                                                                                                                                                                  \n",
    "     32   2279.9   2609.1   3628.0   4745.3   5798.7   5625.0                                                                                                                                                                                                                                                  \n",
    "     33   2279.9   2609.1   3628.0   4745.3   5798.7   9518.8                                                                                                                                                                                                                                                  \n",
    "     34   2279.9   2609.1   3628.0   4745.3   5798.7   5682.3                                                                                                                                                                                                                                                  \n",
    "     35   2279.9   2609.1   3628.0   4745.3   5798.7   5845.4                                                                                                                                                                                                                                                  \n",
    "     36   2279.9   2609.1   3628.0   4745.3   5798.7   7103.5                                                                                                                                                                                                                                                  \n",
    "     37   2279.9   2609.1   3628.0   4745.3   5798.7   9979.4                                                                                                                                                                                                                                                  \n",
    "     38   2279.9   2609.1   3628.0   4745.3   5798.7   9739.3                                                                                                                                                                                                                                                  \n",
    "     39   2279.9   2609.1   3628.0   4745.3   5798.7  10723.1                                                                                                                                                                                                                                                  \n",
    "     40   2279.9   2609.1   3628.0   4745.3   5798.7   3930.8                                                                                                                                                                                                                                                  \n",
    "     41   2279.9   2609.1   3628.0   4745.3   5798.7   6725.3                                                                                                                                                                                                                                                  \n",
    "     42   2279.9   2609.1   3628.0   4745.3   5798.7   5867.3                                                                                                                                                                                                                                                  \n",
    "     43   2279.9   2609.1   3628.0   4745.3   5798.7   3844.9                                                                                                                                                                                                                                                  \n",
    "     44   2279.9   2609.1   3628.0   4745.3   5798.7   4835.0                                                                                                                                                                                                                                                  \n",
    "     45   2279.9   2609.1   3628.0   4745.3   5798.7   6806.6                                                                                                                                                                                                                                                  \n",
    "     46   2279.9   2609.1   3628.0   4745.3   5798.7  12013.0                                                                                                                                                                                                                                                  \n",
    "     47   2279.9   2609.1   3628.0   4745.3   5798.7   7943.5                                                                                                                                                                                                                                                  \n",
    "     48   2279.9   2609.1   3628.0   4745.3   5798.7   7955.8                                                                                                                                                                                                                                                  \n",
    "     49   2279.9   2609.1   3628.0   4745.3   5798.7   9558.5                                                                                                                                                                                                                                                  \n",
    "     50   2279.9   2609.1   3628.0   4745.3   5798.7   5504.3                                                                                                                                                                                                                                                  \n",
    "     51   2279.9   2609.1   3628.0   4745.3   5798.7   7215.6                                                                                                                                                                                                                                                  \n",
    "     52   2279.9   2609.1   3628.0   4745.3   5798.7  11499.6                                                                                                                                                                                                                                                  \n",
    "     53   2279.9   2609.1   3628.0   4745.3   5798.7  10433.4                                                                                                                                                                                                                                                  \n",
    "     54   2279.9   2609.1   3628.0   4745.3   5798.7  11577.1                                                                                                                                                                                                                                                  \n",
    "     55   2279.9   2609.1   3628.0   4745.3   5798.7  11554.7                                                                                                                                                                                                                                                  \n",
    "     56   2279.9   2609.1   3628.0   4745.3   5798.7   8463.8                                                                                                                                                                                                                                                  \n",
    "     57   2279.9   2609.1   3628.0   4745.3   5798.7   7585.8                                                                                                                                                                                                                                                  \n",
    "     58   2279.9   2609.1   3628.0   4745.3   5798.7   7120.0                                                                                                                                                                                                                                                  \n",
    "     59   2279.9   2609.1   3628.0   4745.3   5798.7   7677.8                                                                                                                                                                                                                                                  \n",
    "     60   2279.9   2609.1   3628.0   4745.3   5798.7   8785.1                                                                                                                                                                                                                                                  \n",
    "     61   2279.9   2609.1   3628.0   4745.3   5798.7  10165.6                                                                                                                                                                                                                                                  \n",
    "     62   2279.9   2609.1   3628.0   4745.3   5798.7   7270.0                                                                                                                                                                                                                                                  \n",
    "     63   2279.9   2609.1   3628.0   4745.3   5798.7   9770.6                                                                                                                                                                                                                                                  \n",
    "     64   2279.9   2609.1   3628.0   4745.3   5798.7   4851.0                                                                                                                                                                                                                                                  \n",
    "     65   2279.9   2609.1   3628.0   4745.3   5798.7   5937.7                                                                                                                                                                                                                                                  \n",
    "     66   2279.9   2609.1   3628.0   4745.3   5798.7   7108.5                                                                                                                                                                                                                                                  \n",
    "     67   2279.9   2609.1   3628.0   4745.3   5798.7   5492.5                                                                                                                                                                                                                                                  \n",
    "     68   2279.9   2609.1   3628.0   4745.3   5798.7   7668.6                                                                                                                                                                                                                                                  \n",
    "     69   2279.9   2609.1   3628.0   4745.3   5798.7   5047.0                                                                                                                                                                                                                                                  \n",
    "     70   2279.9   2609.1   3628.0   4745.3   5798.7  10113.5                                                                                                                                                                                                                                                  \n",
    "     71   2279.9   2609.1   3628.0   4745.3   5798.7  11777.6                                                                                                                                                                                                                                                  \n",
    "     72   2279.9   2609.1   3628.0   4745.3   5798.7   8477.2                                                                                                                                                                                                                                                  \n",
    "     73   2279.9   2609.1   3628.0   4745.3   5798.7   6109.7                                                                                                                                                                                                                                                  \n",
    "     74   2279.9   2609.1   3628.0   4745.3   5798.7  11799.2                                                                                                                                                                                                                                                  \n",
    "     75   2279.9   2609.1   3628.0   4745.3   5798.7   5385.8                                                                                                                                                                                                                                                  \n",
    "     76   2279.9   2609.1   3628.0   4745.3   5798.7   9697.9                                                                                                                                                                                                                                                  \n",
    "     77   2279.9   2609.1   3628.0   4745.3   5798.7  10963.1                                                                                                                                                                                                                                                  \n",
    "     78   2279.9   2609.1   3628.0   4745.3   5798.7   7975.6                                                                                                                                                                                                                                                  \n",
    "     79   2279.9   2609.1   3628.0   4745.3   5798.7   7356.1                                                                                                                                                                                                                                                  \n",
    "     80   2279.9   2609.1   3628.0   4745.3   5798.7   9187.9                                                                                                                                                                                                                                                  \n",
    "     81   2279.9   2609.1   3628.0   4745.3   5798.7   7690.9                                                                                                                                                                                                                                                  \n",
    "     82   2279.9   2609.1   3628.0   4745.3   5798.7   8132.4                                                                                                                                                                                                                                                  \n",
    "     83   2279.9   2609.1   3628.0   4745.3   5798.7  11481.5                                                                                                                                                                                                                                                  \n",
    "     84   2279.9   2609.1   3628.0   4745.3   5798.7   4605.0                                                                                                                                                                                                                                                  \n",
    "     85   2279.9   2609.1   3628.0   4745.3   5798.7   9629.4                                                                                                                                                                                                                                                  \n",
    "     86   2279.9   2609.1   3628.0   4745.3   5798.7   9933.7                                                                                                                                                                                                                                                  \n",
    "     87   2279.9   2609.1   3628.0   4745.3   5798.7   9436.1                                                                                                                                                                                                                                                  \n",
    "     88   2279.9   2609.1   3628.0   4745.3   5798.7   7325.1                                                                                                                                                                                                                                                  \n",
    "     89   2279.9   2609.1   3628.0   4745.3   5798.7   4365.1                                                                                                                                                                                                                                                  \n",
    "     90   2279.9   2609.1   3628.0   4745.3   5798.7   6883.0                                                                                                                                                                                                                                                  \n",
    "     91   2279.9   2609.1   3628.0   4745.3   5798.7   7455.7                                                                                                                                                                                                                                                  \n",
    "     92   2279.9   2609.1   3628.0   4745.3   5798.7   8941.2                                                                                                                                                                                                                                                  \n",
    "     93   2279.9   2609.1   3628.0   4745.3   5798.7   8316.3                                                                                                                                                                                                                                                  \n",
    "     94   2279.9   2609.1   3628.0   4745.3   5798.7   5306.8                                                                                                                                                                                                                                                  \n",
    "     95   2279.9   2609.1   3628.0   4745.3   5798.7   7273.9                                                                                                                                                                                                                                                  \n",
    "     96   2279.9   2609.1   3628.0   4745.3   5798.7   5118.4                                                                                                                                                                                                                                                  \n",
    "     97   2279.9   2609.1   3628.0   4745.3   5798.7   7957.1                                                                                                                                                                                                                                                  \n",
    "     98   2279.9   2609.1   3628.0   4745.3   5798.7   7066.9                                                                                                                                                                                                                                                  \n",
    "     99   2279.9   2609.1   3628.0   4745.3   5798.7   9309.1                                                                                                                                                                                                                                                  \n",
    "    100   2279.9   2609.1   3628.0   4745.3   5798.7   8412.4                                                                                                                                                                                                                                                  \n",
    "    101   2279.9   2609.1   3628.0   4745.3   5798.7   9039.7                                                                                                                                                                                                                                                  \n",
    "    102   2279.9   2609.1   3628.0   4745.3   5798.7   8912.7                                                                                                                                                                                                                                                  \n",
    "    103   2279.9   2609.1   3628.0   4745.3   5798.7  10688.6                                                                                                                                                                                                                                                  \n",
    "    104   2279.9   2609.1   3628.0   4745.3   5798.7   4699.6                                                                                                                                                                                                                                                  \n",
    "    105   2279.9   2609.1   3628.0   4745.3   5798.7   4864.5                                                                                                                                                                                                                                                  \n",
    "    106   2279.9   2609.1   3628.0   4745.3   5798.7   6534.1                                                                                                                                                                                                                                                  \n",
    "    107   2279.9   2609.1   3628.0   4745.3   5798.7   8028.8                                                                                                                                                                                                                                                  \n",
    "    108   2279.9   2609.1   3628.0   4745.3   5798.7   6139.1                                                                                                                                                                                                                                                  \n",
    "    109   2279.9   2609.1   3628.0   4745.3   5798.7   8236.3                                                                                                                                                                                                                                                  \n",
    "    110   2279.9   2609.1   3628.0   4745.3   5798.7   7659.1                                                                                                                                                                                                                                                  \n",
    "    111   2279.9   2609.1   3628.0   4745.3   5798.7   8715.2                                                                                                                                                                                                                                                  \n",
    "    112   2279.9   2609.1   3628.0   4745.3   5798.7   7680.9                                                                                                                                                                                                                                                  \n",
    "    113   2279.9   2609.1   3628.0   4745.3   5798.7   7836.7                                                                                                                                                                                                                                                  \n",
    "    114   2279.9   2609.1   3628.0   4745.3   5798.7   8777.8                                                                                                                                                                                                                                                  \n",
    "    115   2279.9   2609.1   3628.0   4745.3   5798.7   6853.4                                                                                                                                                                                                                                                  \n",
    "    116   2279.9   2609.1   3628.0   4745.3   5798.7   8556.9                                                                                                                                                                                                                                                  \n",
    "\n",
    "   REE:    9 - MAN-AP    / SUBSISTEMA:    4 - N \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "    Cen  Sem_01   Sem_02   Sem_03   Sem_04   Sem_05   Mes_02                                                                                                                                                                                                                                                       \n",
    "   X---X--------X--------X--------X--------X--------X--------X                                                                                                                                                                                                                                                      \n",
    "      1    725.2    699.4    852.0    879.3   1021.5    988.8                                                                                                                                                                                                                                                  \n",
    "      2    725.2    699.4    852.0    879.3   1021.5   1031.4                                                                                                                                                                                                                                                  \n",
    "      3    725.2    699.4    852.0    879.3   1021.5   1346.6                                                                                                                                                                                                                                                  \n",
    "      4    725.2    699.4    852.0    879.3   1021.5   1600.0                                                                                                                                                                                                                                                  \n",
    "      5    725.2    699.4    852.0    879.3   1021.5   1370.0                                                                                                                                                                                                                                                  \n",
    "      6    725.2    699.4    852.0    879.3   1021.5   1264.6                                                                                                                                                                                                                                                  \n",
    "      7    725.2    699.4    852.0    879.3   1021.5   1063.5                                                                                                                                                                                                                                                  \n",
    "      8    725.2    699.4    852.0    879.3   1021.5   1416.5                                                                                                                                                                                                                                                  \n",
    "      9    725.2    699.4    852.0    879.3   1021.5   1245.5                                                                                                                                                                                                                                                  \n",
    "     10    725.2    699.4    852.0    879.3   1021.5    848.9                                                                                                                                                                                                                                                  \n",
    "     11    725.2    699.4    852.0    879.3   1021.5   1740.9                                                                                                                                                                                                                                                  \n",
    "     12    725.2    699.4    852.0    879.3   1021.5   1414.9                                                                                                                                                                                                                                                  \n",
    "     13    725.2    699.4    852.0    879.3   1021.5   1219.4                                                                                                                                                                                                                                                  \n",
    "     14    725.2    699.4    852.0    879.3   1021.5   1290.2                                                                                                                                                                                                                                                  \n",
    "     15    725.2    699.4    852.0    879.3   1021.5   1252.2                                                                                                                                                                                                                                                  \n",
    "     16    725.2    699.4    852.0    879.3   1021.5    902.6                                                                                                                                                                                                                                                  \n",
    "     17    725.2    699.4    852.0    879.3   1021.5    892.8                                                                                                                                                                                                                                                  \n",
    "     18    725.2    699.4    852.0    879.3   1021.5   1217.0                                                                                                                                                                                                                                                  \n",
    "     19    725.2    699.4    852.0    879.3   1021.5   1269.8                                                                                                                                                                                                                                                  \n",
    "     20    725.2    699.4    852.0    879.3   1021.5   1308.8                                                                                                                                                                                                                                                  \n",
    "     21    725.2    699.4    852.0    879.3   1021.5   1384.3                                                                                                                                                                                                                                                  \n",
    "     22    725.2    699.4    852.0    879.3   1021.5   1248.8                                                                                                                                                                                                                                                  \n",
    "     23    725.2    699.4    852.0    879.3   1021.5   1037.2                                                                                                                                                                                                                                                  \n",
    "     24    725.2    699.4    852.0    879.3   1021.5   1002.7                                                                                                                                                                                                                                                  \n",
    "     25    725.2    699.4    852.0    879.3   1021.5    998.2                                                                                                                                                                                                                                                  \n",
    "     26    725.2    699.4    852.0    879.3   1021.5   1494.5                                                                                                                                                                                                                                                  \n",
    "     27    725.2    699.4    852.0    879.3   1021.5    872.7                                                                                                                                                                                                                                                  \n",
    "     28    725.2    699.4    852.0    879.3   1021.5   1104.8                                                                                                                                                                                                                                                  \n",
    "     29    725.2    699.4    852.0    879.3   1021.5   1290.5                                                                                                                                                                                                                                                  \n",
    "     30    725.2    699.4    852.0    879.3   1021.5    818.6                                                                                                                                                                                                                                                  \n",
    "     31    725.2    699.4    852.0    879.3   1021.5    963.6                                                                                                                                                                                                                                                  \n",
    "     32    725.2    699.4    852.0    879.3   1021.5   1271.5                                                                                                                                                                                                                                                  \n",
    "     33    725.2    699.4    852.0    879.3   1021.5   1826.1                                                                                                                                                                                                                                                  \n",
    "     34    725.2    699.4    852.0    879.3   1021.5   1255.5                                                                                                                                                                                                                                                  \n",
    "     35    725.2    699.4    852.0    879.3   1021.5   1085.7                                                                                                                                                                                                                                                  \n",
    "     36    725.2    699.4    852.0    879.3   1021.5   1002.7                                                                                                                                                                                                                                                  \n",
    "     37    725.2    699.4    852.0    879.3   1021.5   1098.6                                                                                                                                                                                                                                                  \n",
    "     38    725.2    699.4    852.0    879.3   1021.5   1328.1                                                                                                                                                                                                                                                  \n",
    "     39    725.2    699.4    852.0    879.3   1021.5   1143.7                                                                                                                                                                                                                                                  \n",
    "     40    725.2    699.4    852.0    879.3   1021.5   1065.3                                                                                                                                                                                                                                                  \n",
    "     41    725.2    699.4    852.0    879.3   1021.5   1076.2                                                                                                                                                                                                                                                  \n",
    "     42    725.2    699.4    852.0    879.3   1021.5    899.9                                                                                                                                                                                                                                                  \n",
    "     43    725.2    699.4    852.0    879.3   1021.5   1052.8                                                                                                                                                                                                                                                  \n",
    "     44    725.2    699.4    852.0    879.3   1021.5    958.4                                                                                                                                                                                                                                                  \n",
    "     45    725.2    699.4    852.0    879.3   1021.5   1109.1                                                                                                                                                                                                                                                  \n",
    "     46    725.2    699.4    852.0    879.3   1021.5   1732.9                                                                                                                                                                                                                                                  \n",
    "     47    725.2    699.4    852.0    879.3   1021.5   1401.1                                                                                                                                                                                                                                                  \n",
    "     48    725.2    699.4    852.0    879.3   1021.5    939.3                                                                                                                                                                                                                                                  \n",
    "     49    725.2    699.4    852.0    879.3   1021.5   1440.1                                                                                                                                                                                                                                                  \n",
    "     50    725.2    699.4    852.0    879.3   1021.5    932.5                                                                                                                                                                                                                                                  \n",
    "     51    725.2    699.4    852.0    879.3   1021.5   1000.3                                                                                                                                                                                                                                                  \n",
    "     52    725.2    699.4    852.0    879.3   1021.5   1286.3                                                                                                                                                                                                                                                  \n",
    "     53    725.2    699.4    852.0    879.3   1021.5   1422.5                                                                                                                                                                                                                                                  \n",
    "     54    725.2    699.4    852.0    879.3   1021.5   1196.1                                                                                                                                                                                                                                                  \n",
    "     55    725.2    699.4    852.0    879.3   1021.5   1116.6                                                                                                                                                                                                                                                  \n",
    "     56    725.2    699.4    852.0    879.3   1021.5   1405.5                                                                                                                                                                                                                                                  \n",
    "     57    725.2    699.4    852.0    879.3   1021.5   1011.8                                                                                                                                                                                                                                                  \n",
    "     58    725.2    699.4    852.0    879.3   1021.5    912.5                                                                                                                                                                                                                                                  \n",
    "     59    725.2    699.4    852.0    879.3   1021.5   1713.7                                                                                                                                                                                                                                                  \n",
    "     60    725.2    699.4    852.0    879.3   1021.5   1217.4                                                                                                                                                                                                                                                  \n",
    "     61    725.2    699.4    852.0    879.3   1021.5   1351.0                                                                                                                                                                                                                                                  \n",
    "     62    725.2    699.4    852.0    879.3   1021.5   1174.4                                                                                                                                                                                                                                                  \n",
    "     63    725.2    699.4    852.0    879.3   1021.5   1131.5                                                                                                                                                                                                                                                  \n",
    "     64    725.2    699.4    852.0    879.3   1021.5   1102.1                                                                                                                                                                                                                                                  \n",
    "     65    725.2    699.4    852.0    879.3   1021.5   1419.4                                                                                                                                                                                                                                                  \n",
    "     66    725.2    699.4    852.0    879.3   1021.5   1077.0                                                                                                                                                                                                                                                  \n",
    "     67    725.2    699.4    852.0    879.3   1021.5   1292.9                                                                                                                                                                                                                                                  \n",
    "     68    725.2    699.4    852.0    879.3   1021.5   1308.8                                                                                                                                                                                                                                                  \n",
    "     69    725.2    699.4    852.0    879.3   1021.5    958.7                                                                                                                                                                                                                                                  \n",
    "     70    725.2    699.4    852.0    879.3   1021.5   1146.4                                                                                                                                                                                                                                                  \n",
    "     71    725.2    699.4    852.0    879.3   1021.5   1343.8                                                                                                                                                                                                                                                  \n",
    "     72    725.2    699.4    852.0    879.3   1021.5   1194.6                                                                                                                                                                                                                                                  \n",
    "     73    725.2    699.4    852.0    879.3   1021.5   1685.0                                                                                                                                                                                                                                                  \n",
    "     74    725.2    699.4    852.0    879.3   1021.5   1253.9                                                                                                                                                                                                                                                  \n",
    "     75    725.2    699.4    852.0    879.3   1021.5    960.1                                                                                                                                                                                                                                                  \n",
    "     76    725.2    699.4    852.0    879.3   1021.5   1529.4                                                                                                                                                                                                                                                  \n",
    "     77    725.2    699.4    852.0    879.3   1021.5   1182.1                                                                                                                                                                                                                                                  \n",
    "     78    725.2    699.4    852.0    879.3   1021.5   1127.9                                                                                                                                                                                                                                                  \n",
    "     79    725.2    699.4    852.0    879.3   1021.5    820.3                                                                                                                                                                                                                                                  \n",
    "     80    725.2    699.4    852.0    879.3   1021.5    986.9                                                                                                                                                                                                                                                  \n",
    "     81    725.2    699.4    852.0    879.3   1021.5   1154.4                                                                                                                                                                                                                                                  \n",
    "     82    725.2    699.4    852.0    879.3   1021.5    928.1                                                                                                                                                                                                                                                  \n",
    "     83    725.2    699.4    852.0    879.3   1021.5   1048.7                                                                                                                                                                                                                                                  \n",
    "     84    725.2    699.4    852.0    879.3   1021.5    803.0                                                                                                                                                                                                                                                  \n",
    "     85    725.2    699.4    852.0    879.3   1021.5   1469.4                                                                                                                                                                                                                                                  \n",
    "     86    725.2    699.4    852.0    879.3   1021.5   1219.1                                                                                                                                                                                                                                                  \n",
    "     87    725.2    699.4    852.0    879.3   1021.5   1671.7                                                                                                                                                                                                                                                  \n",
    "     88    725.2    699.4    852.0    879.3   1021.5   1147.1                                                                                                                                                                                                                                                  \n",
    "     89    725.2    699.4    852.0    879.3   1021.5    863.2                                                                                                                                                                                                                                                  \n",
    "     90    725.2    699.4    852.0    879.3   1021.5   1317.1                                                                                                                                                                                                                                                  \n",
    "     91    725.2    699.4    852.0    879.3   1021.5   1267.8                                                                                                                                                                                                                                                  \n",
    "     92    725.2    699.4    852.0    879.3   1021.5   1307.1                                                                                                                                                                                                                                                  \n",
    "     93    725.2    699.4    852.0    879.3   1021.5   1347.1                                                                                                                                                                                                                                                  \n",
    "     94    725.2    699.4    852.0    879.3   1021.5    873.8                                                                                                                                                                                                                                                  \n",
    "     95    725.2    699.4    852.0    879.3   1021.5   1407.3                                                                                                                                                                                                                                                  \n",
    "     96    725.2    699.4    852.0    879.3   1021.5   1336.0                                                                                                                                                                                                                                                  \n",
    "     97    725.2    699.4    852.0    879.3   1021.5   1181.2                                                                                                                                                                                                                                                  \n",
    "     98    725.2    699.4    852.0    879.3   1021.5   1288.2                                                                                                                                                                                                                                                  \n",
    "     99    725.2    699.4    852.0    879.3   1021.5   1721.3                                                                                                                                                                                                                                                  \n",
    "    100    725.2    699.4    852.0    879.3   1021.5    986.3                                                                                                                                                                                                                                                  \n",
    "    101    725.2    699.4    852.0    879.3   1021.5    939.3                                                                                                                                                                                                                                                  \n",
    "    102    725.2    699.4    852.0    879.3   1021.5    944.6                                                                                                                                                                                                                                                  \n",
    "    103    725.2    699.4    852.0    879.3   1021.5    941.6                                                                                                                                                                                                                                                  \n",
    "    104    725.2    699.4    852.0    879.3   1021.5   1131.6                                                                                                                                                                                                                                                  \n",
    "    105    725.2    699.4    852.0    879.3   1021.5   1131.1                                                                                                                                                                                                                                                  \n",
    "    106    725.2    699.4    852.0    879.3   1021.5   1350.1                                                                                                                                                                                                                                                  \n",
    "    107    725.2    699.4    852.0    879.3   1021.5   1371.6                                                                                                                                                                                                                                                  \n",
    "    108    725.2    699.4    852.0    879.3   1021.5   1211.1                                                                                                                                                                                                                                                  \n",
    "    109    725.2    699.4    852.0    879.3   1021.5   1371.7                                                                                                                                                                                                                                                  \n",
    "    110    725.2    699.4    852.0    879.3   1021.5   1287.6                                                                                                                                                                                                                                                  \n",
    "    111    725.2    699.4    852.0    879.3   1021.5   1248.7                                                                                                                                                                                                                                                  \n",
    "    112    725.2    699.4    852.0    879.3   1021.5   1383.0                                                                                                                                                                                                                                                  \n",
    "    113    725.2    699.4    852.0    879.3   1021.5   1060.6                                                                                                                                                                                                                                                  \n",
    "    114    725.2    699.4    852.0    879.3   1021.5   1153.1                                                                                                                                                                                                                                                  \n",
    "    115    725.2    699.4    852.0    879.3   1021.5   1006.9                                                                                                                                                                                                                                                  \n",
    "    116    725.2    699.4    852.0    879.3   1021.5   1349.0                                                                                                                                                                                                                                                  \n",
    "\n",
    "   Relatorio dos Dados de Energia Natural Afluente para Acoplamento c/ Longo Prazo por Subsistema (MWmed)\n",
]

MockEnergiaArmazenadaREE = [
    "   ENERGIA ARMAZENADA NOS REEs (% EARM_MAXIMA)                                                                                                                                                          \n",
    "   X------------X----X----X-------X------X------X------X------X------X                                                                                                                                  \n",
    "       REE        No  Sis   Inic.  Sem_01 Sem_02 Sem_03 Sem_04 Sem_05                                                                                                                                   \n",
    "   X------------X----X----X-------X------X------X------X------X------X                                                                                                                                  \n",
    "     SUDESTE       1    1    19.5   19.4   19.4   19.7   20.6   21.8                                                                                                                                    \n",
    "     MADEIRA       6    1    19.1   24.2   27.6   32.0   36.3   40.9                                                                                                                                    \n",
    "     TPIRES        7    1    49.0   28.9   16.6    8.4    7.0   10.9                                                                                                                                    \n",
    "     ITAIPU        5    1     0.0  100.0  100.0  100.0  100.0  100.0                                                                                                                                    \n",
    "     PARANA       10    1    20.0   20.1   20.8   21.9   23.5   25.7                                                                                                                                    \n",
    "     PRNPANEMA    12    1    29.3   28.2   27.6   27.7   29.0   30.6                                                                                                                                    \n",
    "     SUL           2    2    40.5   39.6   38.7   38.3   39.0   41.1                                                                                                                                    \n",
    "     IGUACU       11    2    21.7   21.1   20.1   19.5   20.4   22.3                                                                                                                                    \n",
    "     NORDESTE      3    3    37.6   37.6   37.4   37.5   37.9   39.0                                                                                                                                    \n",
    "     NORTE         4    4    14.6   15.3   16.2   17.3   18.5   20.9                                                                                                                                    \n",
    "     BMONTE        8    4    18.6   25.9   29.5   32.1   32.6   33.6                                                                                                                                    \n",
    "     MAN-AP        9    4    22.4   24.8   25.8   26.5   27.9   29.3                                                                                                                                    \n",
    "   X------------X----X----X-------X------X------X------X------X------X                                                                                                                                  \n",
]

MockEnergiaArmazenadaSubsistema = [
    "   ENERGIA ARMAZENADA NOS SUBSISTEMAS (% EARM_MAXIMA)                                                                                                                                                   \n",
    "   X------------X----X-------X------X------X------X------X------X                                                                                                                                       \n",
    "     SUBSISTEMA   No   Inic.  Sem_01 Sem_02 Sem_03 Sem_04 Sem_05                                                                                                                                        \n",
    "   X------------X----X-------X------X------X------X------X------X                                                                                                                                       \n",
    "         SE        1    20.4   20.7   21.1   21.9   23.3   25.2                                                                                                                                         \n",
    "         S         2    30.6   29.9   28.9   28.4   29.2   31.2                                                                                                                                         \n",
    "         NE        3    37.6   37.6   37.4   37.5   37.9   39.0                                                                                                                                         \n",
    "         N         4    15.0   15.8   16.7   17.8   19.0   21.4                                                                                                                                         \n",
    "   X------------X----X-------X------X------X------X------X------X                                                                                                                                       \n",
]

MockENAPreEstudoMensalREE = [
    "   RELATORIO DOS DADOS DE ENERGIA NATURAL AFLUENTE POR REE (MESES PRE-ESTUDO)\n",
    "   X--------------X----X----X--------X--------------------------------------------------------------------------------------------------X\n",
    "   REE             Num  Num   Earmax*                                   Ena pre-estudo \n",
    "                   REE  Sis   (MWmes)                                      (MWmes)\n",
    "   X--------------X----X----X--------X--------------------------------------------------------------------------------------------------X\n",
    "    SUDESTE          1    1   50314.5   4371.6   2503.3   1617.3   1596.9   1706.7   2179.8   2541.1   3796.6   5973.3   7093.4   5209.3\n",
    "    MADEIRA          6    1     316.6   5999.1   2716.6   1795.4   1237.0   1978.1   3498.5   6585.5   9184.4  11572.4  13481.5  12450.7\n",
    "    TPIRES           7    1     889.0   1938.3   1086.0    760.2    518.1    643.8    837.6   1217.0   2154.2   4002.9   4189.0   2906.5\n",
    "    ITAIPU           5    1     669.2   4477.6   2211.0   2157.6   2424.8   2597.5   3303.7   4902.1   4660.5   4364.5   5837.5   2965.5\n",
    "    PARANA          10    1  140289.7  19876.2   9469.3   6526.2   6652.0   8229.6  10168.1  12065.6  16732.2  24586.9  32405.8  20975.6\n",
    "    PRNPANEMA       12    1   11842.8   2342.9   1402.9    863.5   1289.6   1173.7   1786.5   3418.2   1706.5   1788.7   2995.7   1624.9\n",
    "    SUL              2    2    9447.4   1882.3   7074.2   3687.1   1581.4   1619.8   4419.8   5981.4   8515.0   2941.3   4529.9   3424.2\n",
    "    IGUACU          11    2   10449.8   2661.6   2190.4   1673.3   1728.9   1260.9   2603.7  10359.9   5493.1   3710.6   4941.7   3311.7\n",
    "    NORDESTE         3    3   51605.5   4155.4   1138.5    969.4   1243.6   1563.2   1805.3   2611.0   3913.3   6504.2   6196.1   3458.2\n",
    "    NORTE            4    4   14409.2   2248.1   1479.7   1174.0    884.3   1164.6   1802.6   3212.8   7549.5  14601.8  11860.4   6910.9\n",
    "    BMONTE           8    4      27.3   1732.8    808.1    279.2    217.8    562.9   1618.9   4515.2   9048.2  11268.0  10359.7   6890.0\n",
    "    MAN-AP           9    4     776.5    571.7    327.9    335.4    457.4    790.8   1097.0   1625.1   2353.7   1382.4    917.6   1198.9\n",
    "   X--------------X----X----X--------X--------------------------------------------------------------------------------------------------X\n",
    "\n",
]

MockENAPreEstudoMensalSubsistema = [
    "   RELATORIO DOS DADOS DE ENERGIA NATURAL AFLUENTE POR SUBSISTEMA (MESES PRE-ESTUDO)\n",
    "   X--------------X----X--------X--------------------------------------------------------------------------------------------------X\n",
    "   Subsistema      Num   Earmax*                                   Ena pre-estudo \n",
    "                         (MWmes)                                      (MWmes)\n",
    "   X--------------X----X--------X--------------------------------------------------------------------------------------------------X\n",
    "            SE       1  204321.7  39005.7  19389.1  13720.1  13718.4  16329.3  21774.2  30729.5  38234.5  52288.9  66003.0  46132.5\n",
    "            S        2   19897.2   4543.9   9264.7   5360.4   3310.3   2880.7   7023.5  16341.3  14008.1   6651.9   9471.7   6735.9\n",
    "            NE       3   51605.5   4155.4   1138.5    969.4   1243.6   1563.2   1805.3   2611.0   3913.3   6504.2   6196.1   3458.2\n",
    "            N        4   15212.9   4552.6   2615.7   1788.5   1559.5   2518.2   4518.5   9353.1  18951.3  27252.2  23137.7  14999.8\n",
    "   X--------------X----X--------X--------------------------------------------------------------------------------------------------X\n",
    "\n",
]

MockENAPreEstudoSemanalREE = [
    "   RELATORIO DOS DADOS DE ENERGIA NATURAL AFLUENTE POR REE (SEMANAS PRE-ESTUDO)\n",
    "   X--------------X----X----X--------X--------------------------------------------X\n",
    "   REE             Num  Num   Earmax*      Ena pre-estudo semanal\n",
    "                   REE  Sis   (MWmes)            (MWmed)\n",
    "   X--------------X----X----X--------X--------------------------------------------X\n",
    "    SUDESTE          1    1   50314.5     10.0      5.0      3.0   2000.0  10000.0\n",
    "    MADEIRA          6    1     316.6      0.0      0.0      0.0      0.0      0.0\n",
    "    TPIRES           7    1     889.0      0.0      0.0      0.0      0.0      0.0\n",
    "    ITAIPU           5    1     669.2      0.0      0.0      0.0      0.0      0.0\n",
    "    PARANA          10    1  140289.7      0.0      0.0      0.0      0.0      0.0\n",
    "    PRNPANEMA       12    1   11842.8      0.0      0.0      0.0      0.0      0.0\n",
    "    SUL              2    2    9447.4      0.0      0.0      0.0      0.0      0.0\n",
    "    IGUACU          11    2   10449.8      0.0      0.0      0.0      0.0      0.0\n",
    "    NORDESTE         3    3   51605.5      0.0      0.0      0.0      0.0      0.0\n",
    "    NORTE            4    4   14409.2      0.0      0.0      0.0      0.0      0.0\n",
    "    BMONTE           8    4      27.3      0.0      0.0      0.0      0.0      0.0\n",
    "    MAN-AP           9    4     776.5      0.0      0.0      0.0      0.0      0.0\n",
    "   X--------------X----X----X--------X--------------------------------------------X\n",
    "\n",
]

MockENAPreEstudoSemanalSubsistema = [
    "   RELATORIO DOS DADOS DE ENERGIA NATURAL AFLUENTE POR SUBSISTEMA(SEMANAS PRE-ESTUDO)\n",
    "   X--------------X----X--------X--------------------------------------------X\n",
    "   Subsistema      Num   Earmax*      Ena pre-estudo semanal\n",
    "                         (MWmes)            (MWmed)\n",
    "   X--------------X----X--------X--------------------------------------------X\n",
    "            SE       1  204321.7      4.0    599.0      1.0      0.1  10000.0\n",
    "            S        2   19897.2      0.0      0.0      0.0      0.0      0.0\n",
    "            NE       3   51605.5      0.0      0.0      0.0      0.0      0.0\n",
    "            N        4   15212.9      0.0      0.0      0.0      0.0      0.0\n",
    "   X--------------X----X--------X--------------------------------------------X\n",
    "\n",
]

MockBlocoDiasExcluidosSemanas = [
    "    Mes inicial do periodo de estudos             : JANEIRO    /Ano:2020\n",
    "    Numero de dias excluidos da semana inicial    :   4\n",
    "    Numero de dias excluidos da semana final      :   0\n",
    "\n",
]

MockRelato = (
    MockREEsSubmercado
    + MockUHEsREEsSubmercado
    + MockConvergencia
    + MockRelatorioOperacaoUTE[:-1]
    + MockBalancoEnergetico[:-1]
    + MockRelatorioOperacaoUHE
    + MockRelatorioOperacaoCustos
    + MockCMO
    + MockGeracaoTermicaSubsistema
    + MockCustoOperacaoValorEsperado
    + MockVolumeUtilReservatorio
    + MockDadosTermicas
    + MockDisponibilidadesTermicas
    + MockDadosMercado
    + MockENAAcoplamentoREE
    + MockEnergiaArmazenadaREE
    + MockEnergiaArmazenadaSubsistema
    + MockENAPreEstudoMensalREE
    + MockENAPreEstudoSemanalREE
    + MockENAPreEstudoMensalSubsistema
    + MockENAPreEstudoSemanalSubsistema
    + MockBlocoDiasExcluidosSemanas
)
