# coding: utf-8
u"""Конструктор отчетов.

Поддерживает конструирование пользователем простых отчетов в формате Excel.
"""
from __future__ import absolute_import

from pkg_resources import get_distribution
import django


# -----------------------------------------------------------------------------


default_app_config = __name__ + '.apps.AppConfig'
# -----------------------------------------------------------------------------
# Проверка соответствия версии зависимого пакета m3-ui


dist = get_distribution('m3-ui').version
version = tuple(int(x) for x in dist.split('.'))

assert (
    (2, 0, 9) <= version < (2, 1) or
    (2, 1, 9) <= version < (2, 2) or
    (2, 2, 11) <= version < (2, 3)
), 'Конструктор отчетов не поддерживает версию {} пакета m3-ui'.format(dist)
# -----------------------------------------------------------------------------
# Проверка версии Django


assert django.VERSION >= (1, 8), (
    'Конструктор отчетов работает только в системах на базе Django 1.8+'
)
# -----------------------------------------------------------------------------
