#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.x',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20201227',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'X(), for low level debugging.',
  long_description =
    ('X(), for low level debugging.\n'    
 '\n'    
 '*Latest release 20201227*:\n'    
 'New Y() which calls X(...,colour=yellow) - I now often go `from cs.x import '    
 'Y as X`.\n'    
 '\n'    
 'X() is my function for low level ad hoc debug messages.\n'    
 'It takes a message and optional format arguments for use with `%`.\n'    
 'It is presented here in its own module for reuse:\n'    
 '\n'    
 '    from cs.x import X\n'    
 '    ...\n'    
 '    X("foo: x=%s, a=%r", x, a)\n'    
 '\n'    
 'It normally writes directly to `sys.stderr` but accepts an optional\n'    
 'keyword argument `file` to specify a different filelike object.\n'    
 '\n'    
 'The following globals are further tune its behaviour,\n'    
 'absent the `file=` parameter:\n'    
 '* `X_logger`: if not `None` then log a warning to that logger\n'    
 '* `X_via_tty`: if true then open `/dev/tty` and write the message to it\n'    
 '* `X_discard`: if true then discard the message\n'    
 'Otherwise write the message to `sys.stderr`.\n'    
 '\n'    
 '`X_via_tty` defaults to true if the environment variable `$CS_X_VIA_TTY`\n'    
 'has a nonempty value, false otherwise.\n'    
 'This is handy for getting debugging out of test suites,\n'    
 'which often divert `sys.stderr`.\n'    
 '\n'    
 "`X_discard`'s default value is `not sys.stderr.isatty()`.\n"    
 '\n'    
 '## Function `X(msg, *args, **kw)`\n'    
 '\n'    
 'Unconditionally write the message `msg`.\n'    
 '\n'    
 'If there are positional arguments after `msg`,\n'    
 'format `msg` using %-expansion with those arguments.\n'    
 '\n'    
 'Keyword arguments:\n'    
 '* `file`: optional keyword argument specifying the output file.\n'    
 '* `colour`: optional text colour.\n'    
 '  If specified, surround the message with ANSI escape sequences\n'    
 '  to render the text in that colour.\n'    
 '\n'    
 'If `file` is not `None`, write to it unconditionally.\n'    
 'Otherwise, the following globals are consulted in order:\n'    
 '* `X_logger`: if not `None` then log a warning to that logger\n'    
 '* `X_via_tty`: if true then open `/dev/tty` and write the message to it\n'    
 '* `X_discard`: if true then discard the message\n'    
 'Otherwise write the message to `sys.stderr`.\n'    
 '\n'    
 '`X_logger` is `None` by default.\n'    
 '`X_via_tty` is true if the environment variable `$CS_X_VIA_TTY` is not '    
 'empty,\n'    
 'false otherwise.\n'    
 '`X_discard` is true unless `sys.stderr.isatty()` is true.\n'    
 '\n'    
 '## Function `Xtty(msg, *args, **kw)`\n'    
 '\n'    
 'Call `X()` with `X_via_tty` set to `True`.\n'    
 '\n'    
 '*Note*:\n'    
 'this is now obsoleted by the `$CS_X_VIA_TTY` environment variable.\n'    
 '\n'    
 'This supports using:\n'    
 '\n'    
 '    from cs.x import Xtty as X\n'    
 '\n'    
 'when hacking on tests without the tedious shuffle:\n'    
 '\n'    
 '    from cs.x import X\n'    
 '    import cs.x; cs.x.X_via_tty = True\n'    
 '\n'    
 'which I did _a lot_ to get timely debugging when fixing test failures.\n'    
 '\n'    
 '## Function `Y(msg, *a, **kw)`\n'    
 '\n'    
 'Wrapper for `X()` rendering in yellow.\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20201227*:\n'    
 'New Y() which calls X(...,colour=yellow) - I now often go `from cs.x import '    
 'Y as X`.\n'    
 '\n'    
 '*Release 20201102*:\n'    
 '* Set X_via_tty if $CS_X_VIA_TTY.\n'    
 '* Put X() into builtins if $CS_X_BUILTIN.\n'    
 '\n'    
 '*Release 20181231*:\n'    
 '* X: trivial ANSI colour support via new `colour` keyword argument.\n'    
 '* New global X_discard, False unless sys.stderr.isatty.\n'    
 '\n'    
 '*Release 20180726*:\n'    
 'doco improvements\n'    
 '\n'    
 '*Release 20170902*:\n'    
 'Move X() into its own module, used for ad hoc debugging everywhere.\n'    
 '\n'    
 '*Release 20170707.3*:\n'    
 'tweak DISTINFO\n'    
 '\n'    
 '*Release 20170707.2*:\n'    
 'Doc tweak.\n'    
 '\n'    
 '*Release 20170707.1*:\n'    
 'Added README.\n'    
 '\n'    
 '*Release 20170707*:\n'    
 'Separate X() out into new module cs.x for cheap import.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  install_requires = ['cs.ansi_colour'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.x'],
)
