# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nautobot_chatops_ipfabric',
 'nautobot_chatops_ipfabric.api',
 'nautobot_chatops_ipfabric.migrations',
 'nautobot_chatops_ipfabric.tests']

package_data = \
{'': ['*'], 'nautobot_chatops_ipfabric': ['static/ipfabric/*']}

install_requires = \
['ipfabric-diagrams>=6.0.2,<6.1.0',
 'ipfabric>=6.0.9,<6.1.0',
 'nautobot-chatops>=1.1.0,<2.0.0',
 'netutils>=1.0.0,<2.0.0']

entry_points = \
{'nautobot.workers': ['ipfabric = nautobot_chatops_ipfabric.worker:ipfabric']}

setup_kwargs = {
    'name': 'nautobot-chatops-ipfabric',
    'version': '3.0.1',
    'description': 'Nautobot Plugin Chatops IPFabric',
    'long_description': '# IP Fabric ChatOps\n\nAn IP Fabric ChatOps plugin for [Nautobot](https://github.com/nautobot/nautobot).\n\nThis plugin uses the [Nautobot ChatOps](https://github.com/nautobot/nautobot-plugin-chatops/) base framework. It provides the ability to query data from IP Fabric using a supported chat platform (currently Slack, Webex Teams, MS Teams, and Mattermost).\n\n## Version Matrix\n\nHere is a compatibility matrix and the minimum versions required to run this plugin:\n\n| IP Fabric | Python | Nautobot | chatops | chatops-ipfabric | [python-ipfabric](https://github.com/community-fabric/python-ipfabric) | [python-ipfabric-diagrams](https://github.com/community-fabric/python-ipfabric-diagrams) |\n|-----------|--------|----------|---------|------------------|------------------------------------------------------------------------|------------------------------------------------------------------------------------------|\n| 4.4       | 3.7.1  | 1.1.0    | 1.1.0   | 1.2.0            | 0.11.0                                                                 | 1.2.7                                                                                    |\n| 5.0.1     | 3.7.1  | 1.1.0    | 1.1.0   | 1.3.0            | 5.0.4                                                                  | 5.0.2                                                                                    |\n| 6.0     | 3.7.1  | 1.4.0    | 1.1.0   | 3.0.0            | 6.0.9                                                                  | 6.0.2\n## Screenshots\n\n![image](https://user-images.githubusercontent.com/29293048/138304572-46d2fa11-8dd2-4722-9ab0-450e20a657a5.png)\n\n![ipfabric-2](https://user-images.githubusercontent.com/29293048/131741040-58e9d6a1-e61d-4c60-a427-9f001934915f.png)\n\n![ipfabric-3](https://user-images.githubusercontent.com/29293048/131741046-4e01fbbb-4a82-4233-a8a1-9da4f31e2d93.png)\n\n![ipfabric-4](https://user-images.githubusercontent.com/29293048/131741054-9ae97b71-70f7-48ff-b7b9-15b70f95b7a8.png)\n\n![ipfabric-5](https://user-images.githubusercontent.com/29293048/131741063-a601fb0a-570c-466a-a078-15b2b6037ab8.png)\n\n![ipfabric-6](https://user-images.githubusercontent.com/29293048/131741068-5e5f1c63-65c7-4c3a-9763-dff06f81666f.png)\n\n![ipfabric-7](https://user-images.githubusercontent.com/29293048/131741075-6a52fef9-c9be-4686-950b-994566c6aec4.png)\n\n## Usage\n\nAdd a slash command to your chat platform called `/ipfabric`.\nSee the [nautobot-chatops installation guide](https://github.com/nautobot/nautobot-plugin-chatops/blob/develop/docs/chat_setup/chat_setup.md) for instructions on adding a slash command to your chat channel.\n\nThe following commands are available:\n\n- `/ipfabric set-snapshot [snapshot]`: Set snapshot as reference for commands.\n- `/ipfabric get-snapshot`: Get snapshot as reference for commands.\n- `/ipfabric device-list`: Get the device list.\n- `/ipfabric interfaces [device] [metric]`: Get interface metrics for a device.\n- `/ipfabric pathlookup [src-ip] [dst-ip] [src-port] [dst-port] [protocol]`: Path simulation diagram lookup between source and target IP address.\n- `/ipfabric pathlookup-icmp [src-ip] [dst-ip] [icmp-type]`: ICMP path simulation diagram lookup between source and target IP address.\n- `/ipfabric routing [device] [protocol] [filter-opt]`: Get routing information for a device.\n- `/ipfabric wireless [option] [ssid]`: Get wireless information by client or ssid.\n- `/ipfabric find-host [filter-key] [filter-value]`: Get host information using the inventory host table.\n- `/ipfabric table-diff [category] [table] [snapshot] [view]`: Get the diff of the category/table between the current snapshot and snapshot. Output view can be either a summary with counters or detailed with tables.\n\nIP Fabric uses a concept of snapshots which can include different devices and data. The plugin supports querying specific snapshots via the `/ipfabric set-snapshot` command. The snapshot is set per user and cached for all future commands. If a snapshot is not set, the commands will default to `$last` unless a specific snapshot id is required.\n\n## Installation\n\nThe extension is available as a Python package in PyPI and can be installed with pip\n\n```shell\npip install nautobot-chatops-ipfabric\n```\n\n> The plugin is compatible with Nautobot 1.0.0 and higher\n\nTo ensure the IP Fabric ChatOps plugin is automatically re-installed during future upgrades, create a file named `local_requirements.txt` (if not already existing) in the Nautobot root directory (alongside `requirements.txt`) and list the `nautobot-chatops-ipfabric` package:\n\n```no-highlight\n# echo nautobot-chatops-ipfabric >> local_requirements.txt\n```\n\nOnce installed, the plugin needs to be enabled in your `nautobot_configuration.py`\n\n```python\n# In your nautobot_configuration.py\nPLUGINS = ["nautobot_chatops", "nautobot_chatops_ipfabric"]\n\nPLUGINS_CONFIG = {\n  "nautobot_chatops": {\n    # ADD SLACK/MS-TEAMS/WEBEX-TEAMS/MATTERMOST SETTINGS HERE\n  }\n  "nautobot_chatops_ipfabric": {\n      "IPFABRIC_API_TOKEN": os.environ.get("IPFABRIC_API_TOKEN"),\n      "IPFABRIC_HOST": os.environ.get("IPFABRIC_HOST"),\n      "IPFABRIC_VERIFY": os.environ.get("IPFABRIC_VERIFY", True),\n  },\n}\n```\n\nThe plugin behavior can be controlled with the following list of settings\n\n- `IPFABRIC_API_TOKEN`: Token for accessing IP Fabric API\n- `IPFABRIC_HOST`: URL of IP Fabric instance\n- `IPFABRIC_VERIFY`: Default: True; False to ignore self-signed certificates\n\n## Development\n\nThe development environment supports a self-contained environment for developing nautobot chatops commands.\n\nBuild of the environment requires `python3-invoke`.  For development purposes, install `poetry` and use it to manage the required packages.\n\n```shell\npoetry install        # first time use\npoetry shell\n```\n\nYou can start the deveopment containers locally with an `invoke build` and `invoke start` after copying `creds.env` locally.\n\n```shell\ncp development/creds.env.example development/creds.env\ninvoke build\ninvoke start\n```\n\nYou should be able to access nautobot at http://0.0.0.0:8080\n\n## Contributing\n\nPull requests are welcomed and automatically built and tested against multiple version of Python and multiple version of Nautobot through TravisCI.\n\nThe project is packaged with a light development environment based on `docker-compose` to help with the local development of the project and to run the tests within TravisCI.\n\nThe project is following Network to Code software development guideline and is leveraging:\n\n- Black, Pylint, Bandit and pydocstyle for Python linting and formatting.\n- Django unit test to ensure the plugin is working properly.\n\n### Development Environment\n\nThe development environment can be used in 2 ways. First, with a local poetry environment if you wish to develop outside of Docker. Second, inside of a docker container.\n\n#### Invoke tasks\n\nThe [PyInvoke](http://www.pyinvoke.org/) library is used to provide some helper commands based on the environment.  There are a few configuration parameters which can be passed to PyInvoke to override the default configuration:\n\n- `nautobot_ver`: the version of Nautobot to use as a base for any built docker containers (default: develop-latest)\n- `project_name`: the default docker compose project name (default: ipfabric)\n- `python_ver`: the version of Python to use as a base for any built docker containers (default: 3.6)\n- `local`: a boolean flag indicating if invoke tasks should be run on the host or inside the docker containers (default: False, commands will be run in docker containers)\n- `compose_dir`: the full path to a directory containing the project compose files\n- `compose_files`: a list of compose files applied in order (see [Multiple Compose files](https://docs.docker.com/compose/extends/#multiple-compose-files) for more information)\n\nUsing PyInvoke these configuration options can be overridden using [several methods](http://docs.pyinvoke.org/en/stable/concepts/configuration.html).  Perhaps the simplest is simply setting an environment variable `INVOKE_IPFABRIC_VARIABLE_NAME` where `VARIABLE_NAME` is the variable you are trying to override.  The only exception is `compose_files`, because it is a list it must be overridden in a yaml file.  There is an example `invoke.yml` in this directory which can be used as a starting point.\n\n#### Local Poetry Development Environment\n\n1. Copy `development/creds.example.env` to `development/creds.env` (This file will be ignored by git and docker)\n2. Uncomment the `POSTGRES_HOST`, `REDIS_HOST`, and `NAUTOBOT_ROOT` variables in `development/creds.env`\n3. Create an invoke.yml with the following contents at the root of the repo:\n\n```shell\n---\nipfabric:\n  local: true\n  compose_files:\n    - "docker-compose.requirements.yml"\n```\n\n4. Run the following commands:\n\n```shell\npoetry shell\npoetry install\nexport $(cat development/dev.env | xargs)\nexport $(cat development/creds.env | xargs)\n```\n\n5. You can now run nautobot-server commands as you would from the [Nautobot documentation](https://nautobot.readthedocs.io/en/latest/) for example to start the development server:\n\n```shell\nnautobot-server runserver 0.0.0.0:8080 --insecure\n```\n\nNautobot server can now be accessed at [http://localhost:8080](http://localhost:8080).\n\n#### Docker Development Environment\n\nThis project is managed by [Python Poetry](https://python-poetry.org/) and has a few requirements to setup your development environment:\n\n1. Install Poetry, see the [Poetry Documentation](https://python-poetry.org/docs/#installation) for your operating system.\n2. Install Docker, see the [Docker documentation](https://docs.docker.com/get-docker/) for your operating system.\n\nOnce you have Poetry and Docker installed you can run the following commands to install all other development dependencies in an isolated python virtual environment:\n\n```shell\npoetry shell\npoetry install\ninvoke start\n```\n\nNautobot server can now be accessed at [http://localhost:8080](http://localhost:8080).\n\n### CLI Helper Commands\n\nThe project is coming with a CLI helper based on [invoke](http://www.pyinvoke.org/) to help setup the development environment. The commands are listed below in 3 categories `dev environment`, `utility` and `testing`.\n\nEach command can be executed with `invoke <command>`. Environment variables `INVOKE_IPFABRIC_PYTHON_VER` and `INVOKE_IPFABRIC_NAUTOBOT_VER` may be specified to override the default versions. Each command also has its own help `invoke <command> --help`\n\n#### Docker dev environment\n\n```no-highlight\n  build            Build all docker images.\n  debug            Start Nautobot and its dependencies in debug mode.\n  destroy          Destroy all containers and volumes.\n  restart          Restart Nautobot and its dependencies.\n  start            Start Nautobot and its dependencies in detached mode.\n  stop             Stop Nautobot and its dependencies.\n```\n\n#### Utility\n\n```no-highlight\n  cli              Launch a bash shell inside the running Nautobot container.\n  create-user      Create a new user in django (default: admin), will prompt for password.\n  makemigrations   Run Make Migration in Django.\n  nbshell          Launch a nbshell session.\n```\n\n#### Testing\n\n```no-highlight\n  bandit           Run bandit to validate basic static code security analysis.\n  black            Run black to check that Python files adhere to its style standards.\n  flake8           This will run flake8 for the specified name and Python version.\n  pydocstyle       Run pydocstyle to validate docstring formatting adheres to NTC defined standards.\n  pylint           Run pylint code analysis.\n  tests            Run all tests for this plugin.\n  unittest         Run Django unit tests for the plugin.\n```\n\n## Questions\n\nFor any questions or comments, please check the [FAQ](FAQ.md) first and feel free to swing by the [Network to Code slack channel](https://networktocode.slack.com/) (channel #networktocode).\nSign up [here](http://slack.networktocode.com/)\n',
    'author': 'Network to Code, LLC',
    'author_email': 'info@networktocode.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/networktocode-llc/nautobot-chatops-extension-ipfabric',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
