#
# Copyright (C) 2021 Satoru SATOH <satoru.satoh@gmail.com>
# SPDX-License-Identifier: MIT
#
r"""Utility functions to list and find appropriate parser class objects and
instances.

.. versionchanged:: 0.10.2

   - Split and re-organize the module and export only some functions.

.. versionadded:: 0.9.5

   - Add to abstract processors such like Parsers (loaders and dumpers).
"""
from .utils import (
    load_plugins, list_types, list_by_cid, list_by_type, list_by_extension,
    findall, find, MaybeParserT
)

__all__ = [
    'load_plugins', 'list_types', 'list_by_cid', 'list_by_type',
    'list_by_extension', 'findall', 'find', 'MaybeParserT'
]

# vim:sw=4:ts=4:et:
