# -*- coding: utf-8 -*-
# Copyright (c) 2016 Sqreen. All Rights Reserved.
# Please refer to our terms for more information: https://www.sqreen.io/terms.html
""" Base class for matcher based rules
"""
from logging import getLogger
from collections import Mapping

from ..rules import RuleCallback
from ..matcher import Matcher
from ..exceptions import InvalidArgument

LOGGER = getLogger(__name__)


class MatcherRule(RuleCallback):

    def __init__(self, *args, **kwargs):
        super(MatcherRule, self).__init__(*args, **kwargs)

        if not isinstance(self.data, Mapping):
            msg = "Invalid data type received: {}"
            raise InvalidArgument(msg.format(type(self.data)))

        try:
            raw_patterns = self.data['values']
        except KeyError:
            msg = "No key 'values' in data (had {})"
            raise InvalidArgument(msg.format(self.data.keys()))

        self.matcher = Matcher(raw_patterns)

    def match(self, string):
        """ Check if string match one of rule pattern
        """
        return self.matcher.match(string)
