/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

class BasicYearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = -98628754872287L;
    protected final BasicChronology iChronology;

    BasicYearDateTimeField(BasicChronology basicChronology) {
        super(DateTimeFieldType.year(), basicChronology.getAverageMillisPerYear());
        this.iChronology = basicChronology;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long l2) {
        return this.iChronology.getYear(l2);
    }

    public long add(long l2, int n2) {
        if (n2 == 0) {
            return l2;
        }
        int n3 = this.get(l2);
        int n4 = FieldUtils.safeAdd(n3, n2);
        return this.set(l2, n4);
    }

    public long add(long l2, long l3) {
        return this.add(l2, FieldUtils.safeToInt(l3));
    }

    public long addWrapField(long l2, int n2) {
        if (n2 == 0) {
            return l2;
        }
        int n3 = this.iChronology.getYear(l2);
        int n4 = FieldUtils.getWrappedValue(n3, n2, this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        return this.set(l2, n4);
    }

    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        return this.iChronology.setYear(l2, n2);
    }

    public long setExtended(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.iChronology.getMinYear() - 1, this.iChronology.getMaxYear() + 1);
        return this.iChronology.setYear(l2, n2);
    }

    public long getDifferenceAsLong(long l2, long l3) {
        if (l2 < l3) {
            return -this.iChronology.getYearDifference(l3, l2);
        }
        return this.iChronology.getYearDifference(l2, l3);
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public boolean isLeap(long l2) {
        return this.iChronology.isLeapYear(this.get(l2));
    }

    public int getLeapAmount(long l2) {
        if (this.iChronology.isLeapYear(this.get(l2))) {
            return 1;
        }
        return 0;
    }

    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    public int getMinimumValue() {
        return this.iChronology.getMinYear();
    }

    public int getMaximumValue() {
        return this.iChronology.getMaxYear();
    }

    public long roundFloor(long l2) {
        return this.iChronology.getYearMillis(this.get(l2));
    }

    public long roundCeiling(long l2) {
        int n2 = this.get(l2);
        long l3 = this.iChronology.getYearMillis(n2);
        if (l2 != l3) {
            l2 = this.iChronology.getYearMillis(n2 + 1);
        }
        return l2;
    }

    public long remainder(long l2) {
        return l2 - this.roundFloor(l2);
    }

    private Object readResolve() {
        return this.iChronology.year();
    }
}

