#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
递归：
    优点：
        表达力极强（极短的代码解决非常抽象的问题）
    缺点：
        重复计算（类似缓存机制进行存储）、难理解、容易造成堆栈溢出（加递归深度）

递归思想完成：
    1、分成子问题，写出递推公式。
    2、明确退出条件，否者堆栈溢出。


怎样防止递归程序出现堆栈溢出？
    1、人为控制递归深度。
    2、自动检测递归中是否出现循环（环状递归）。
    3、减少重复计算次数，为递归程序添加缓存机制。

环状递归检查：
    利用set存储每次调用的唯一标识，当已存在再一次加入的时候，表明出现环状。

数学归纳法：
    1、找出边界值进行验证。
    2、然后找f(n)与f(n-1)之间的关系，写出递推公式。
'''

# 斐波那契问题
def fib(n):
    '''
    1、递推公式：f(n) = f(n-1) + f(n-2)
    2、边界条件：f(1) = 0, f(2) = 1
    '''
    if n == 1:
        return 0
    if n == 2:
        return 1
    return fib(n-1) + fib(n-2)


# 跳台阶问题
def jump(n):
    '''
    1、递推公式：f(n) = f(n-1) + f(n-2)
    2、边界条件：f(1) = 1, f(2) = 2
    '''
    if n == 1:
        return 1
    if n == 2:
        return 2
    return jump(n-1) + jump(n-2)


if __name__ == '__main__':
    print(fib(6))
    print(jump(5))







