import requests, typing
from dataclasses import dataclass
from tempfile import NamedTemporaryFile


class FileResponse:
    """A file response from the user

    Attributes:
        file (file): The file object
        url (str): The url of the file
        content (bytes): The content of the file
    """

    __res = None
    __file = None

    def __init__(self, url):
        self.url = url
        self.name = url.split("/")[-1]

    @property
    def content(self):
        if not self.__res:
            self.__res = requests.get(self.url)
        return self.__res.content

    @property
    def file(self) -> typing.BinaryIO:
        if not self.__file:
            self.__file = NamedTemporaryFile()
            self.__file.write(self.content)
            self.__file.seek(0)
        return self.__file


@dataclass
class PhoneResponse:
    """A phone response from the user

    Attributes:
        masked (str): The masked phone number, eg: +55 (21) 99999-9999
        raw (str): The raw phone number, eg: 5521999999999
        country_code (str): The phone number country code, eg: 55
        national_number (str): The phone number national number, eg: 21999999999
    """

    masked: str
    raw: str
    country_code: str
    national_number: str
