"""aequitas

Revision ID: b4d7569d31cb
Revises: 609c7cc51794
Create Date: 2019-05-07 11:56:03.814097

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'b4d7569d31cb'
down_revision = '609c7cc51794'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('aequitas',
    sa.Column('model_id', sa.Integer(), nullable=False),
    sa.Column('subset_hash', sa.String(), nullable=False),
    sa.Column('tie_breaker', sa.String(), nullable=False),
    sa.Column('evaluation_start_time', sa.DateTime(), nullable=False),
    sa.Column('evaluation_end_time', sa.DateTime(), nullable=False),
    sa.Column('matrix_uuid', sa.Text(), nullable=True),
    sa.Column('parameter', sa.String(), nullable=False),
    sa.Column('attribute_name', sa.String(), nullable=False),
    sa.Column('attribute_value', sa.String(), nullable=False),
    sa.Column('total_entities', sa.Integer(), nullable=True),
    sa.Column('group_label_pos', sa.Integer(), nullable=True),
    sa.Column('group_label_neg', sa.Integer(), nullable=True),
    sa.Column('group_size', sa.Integer(), nullable=True),
    sa.Column('group_size_pct', sa.Numeric(), nullable=True),
    sa.Column('prev', sa.Numeric(), nullable=True),
    sa.Column('pp', sa.Integer(), nullable=True),
    sa.Column('pn', sa.Integer(), nullable=True),
    sa.Column('fp', sa.Integer(), nullable=True),
    sa.Column('fn', sa.Integer(), nullable=True),
    sa.Column('tn', sa.Integer(), nullable=True),
    sa.Column('tp', sa.Integer(), nullable=True),
    sa.Column('ppr', sa.Numeric(), nullable=True),
    sa.Column('pprev', sa.Numeric(), nullable=True),
    sa.Column('tpr', sa.Numeric(), nullable=True),
    sa.Column('tnr', sa.Numeric(), nullable=True),
    sa.Column('for', sa.Numeric(), nullable=True),
    sa.Column('fdr', sa.Numeric(), nullable=True),
    sa.Column('fpr', sa.Numeric(), nullable=True),
    sa.Column('fnr', sa.Numeric(), nullable=True),
    sa.Column('npv', sa.Numeric(), nullable=True),
    sa.Column('precision', sa.Numeric(), nullable=True),
    sa.Column('ppr_disparity', sa.Numeric(), nullable=True),
    sa.Column('ppr_ref_group_value', sa.String(), nullable=True),
    sa.Column('pprev_disparity', sa.Numeric(), nullable=True),
    sa.Column('pprev_ref_group_value', sa.String(), nullable=True),
    sa.Column('precision_disparity', sa.Numeric(), nullable=True),
    sa.Column('precision_ref_group_value', sa.String(), nullable=True),
    sa.Column('fdr_disparity', sa.Numeric(), nullable=True),
    sa.Column('fdr_ref_group_value', sa.String(), nullable=True),
    sa.Column('for_disparity', sa.Numeric(), nullable=True),
    sa.Column('for_ref_group_value', sa.String(), nullable=True),
    sa.Column('fpr_disparity', sa.Numeric(), nullable=True),
    sa.Column('fpr_ref_group_value', sa.String(), nullable=True),
    sa.Column('fnr_disparity', sa.Numeric(), nullable=True),
    sa.Column('fnr_ref_group_value', sa.String(), nullable=True),
    sa.Column('tpr_disparity', sa.Numeric(), nullable=True),
    sa.Column('tpr_ref_group_value', sa.String(), nullable=True),
    sa.Column('tnr_disparity', sa.Numeric(), nullable=True),
    sa.Column('tnr_ref_group_value', sa.String(), nullable=True),
    sa.Column('npv_disparity', sa.Numeric(), nullable=True),
    sa.Column('npv_ref_group_value', sa.String(), nullable=True),
    sa.Column('Statistical_Parity', sa.Boolean(), nullable=True),
    sa.Column('Impact_Parity', sa.Boolean(), nullable=True),
    sa.Column('FDR_Parity', sa.Boolean(), nullable=True),
    sa.Column('FPR_Parity', sa.Boolean(), nullable=True),
    sa.Column('FOR_Parity', sa.Boolean(), nullable=True),
    sa.Column('FNR_Parity', sa.Boolean(), nullable=True),
    sa.Column('TypeI_Parity', sa.Boolean(), nullable=True),
    sa.Column('TypeII_Parity', sa.Boolean(), nullable=True),
    sa.Column('Equalized_Odds', sa.Boolean(), nullable=True),
    sa.Column('Unsupervised_Fairness', sa.Boolean(), nullable=True),
    sa.Column('Supervised_Fairness', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['matrix_uuid'], ['model_metadata.matrices.matrix_uuid'], ),
    sa.ForeignKeyConstraint(['model_id'], ['model_metadata.models.model_id'], ),
    sa.PrimaryKeyConstraint('model_id', 'subset_hash', 'tie_breaker', 'evaluation_start_time', 'evaluation_end_time', 'parameter', 'attribute_name', 'attribute_value'),
    schema='test_results'
    )
    op.create_index(op.f('ix_test_results_aequitas_attribute_name'), 'aequitas', ['attribute_name'], unique=False, schema='test_results')
    op.create_index(op.f('ix_test_results_aequitas_attribute_value'), 'aequitas', ['attribute_value'], unique=False, schema='test_results')
    op.create_index(op.f('ix_test_results_aequitas_evaluation_end_time'), 'aequitas', ['evaluation_end_time'], unique=False, schema='test_results')
    op.create_index(op.f('ix_test_results_aequitas_evaluation_start_time'), 'aequitas', ['evaluation_start_time'], unique=False, schema='test_results')
    op.create_index(op.f('ix_test_results_aequitas_model_id'), 'aequitas', ['model_id'], unique=False, schema='test_results')
    op.create_index(op.f('ix_test_results_aequitas_parameter'), 'aequitas', ['parameter'], unique=False, schema='test_results')
    op.create_table('aequitas',
    sa.Column('model_id', sa.Integer(), nullable=False),
    sa.Column('subset_hash', sa.String(), nullable=False),
    sa.Column('tie_breaker', sa.String(), nullable=False),
    sa.Column('evaluation_start_time', sa.DateTime(), nullable=False),
    sa.Column('evaluation_end_time', sa.DateTime(), nullable=False),
    sa.Column('matrix_uuid', sa.Text(), nullable=True),
    sa.Column('parameter', sa.String(), nullable=False),
    sa.Column('attribute_name', sa.String(), nullable=False),
    sa.Column('attribute_value', sa.String(), nullable=False),
    sa.Column('total_entities', sa.Integer(), nullable=True),
    sa.Column('group_label_pos', sa.Integer(), nullable=True),
    sa.Column('group_label_neg', sa.Integer(), nullable=True),
    sa.Column('group_size', sa.Integer(), nullable=True),
    sa.Column('group_size_pct', sa.Numeric(), nullable=True),
    sa.Column('prev', sa.Numeric(), nullable=True),
    sa.Column('pp', sa.Integer(), nullable=True),
    sa.Column('pn', sa.Integer(), nullable=True),
    sa.Column('fp', sa.Integer(), nullable=True),
    sa.Column('fn', sa.Integer(), nullable=True),
    sa.Column('tn', sa.Integer(), nullable=True),
    sa.Column('tp', sa.Integer(), nullable=True),
    sa.Column('ppr', sa.Numeric(), nullable=True),
    sa.Column('pprev', sa.Numeric(), nullable=True),
    sa.Column('tpr', sa.Numeric(), nullable=True),
    sa.Column('tnr', sa.Numeric(), nullable=True),
    sa.Column('for', sa.Numeric(), nullable=True),
    sa.Column('fdr', sa.Numeric(), nullable=True),
    sa.Column('fpr', sa.Numeric(), nullable=True),
    sa.Column('fnr', sa.Numeric(), nullable=True),
    sa.Column('npv', sa.Numeric(), nullable=True),
    sa.Column('precision', sa.Numeric(), nullable=True),
    sa.Column('ppr_disparity', sa.Numeric(), nullable=True),
    sa.Column('ppr_ref_group_value', sa.String(), nullable=True),
    sa.Column('pprev_disparity', sa.Numeric(), nullable=True),
    sa.Column('pprev_ref_group_value', sa.String(), nullable=True),
    sa.Column('precision_disparity', sa.Numeric(), nullable=True),
    sa.Column('precision_ref_group_value', sa.String(), nullable=True),
    sa.Column('fdr_disparity', sa.Numeric(), nullable=True),
    sa.Column('fdr_ref_group_value', sa.String(), nullable=True),
    sa.Column('for_disparity', sa.Numeric(), nullable=True),
    sa.Column('for_ref_group_value', sa.String(), nullable=True),
    sa.Column('fpr_disparity', sa.Numeric(), nullable=True),
    sa.Column('fpr_ref_group_value', sa.String(), nullable=True),
    sa.Column('fnr_disparity', sa.Numeric(), nullable=True),
    sa.Column('fnr_ref_group_value', sa.String(), nullable=True),
    sa.Column('tpr_disparity', sa.Numeric(), nullable=True),
    sa.Column('tpr_ref_group_value', sa.String(), nullable=True),
    sa.Column('tnr_disparity', sa.Numeric(), nullable=True),
    sa.Column('tnr_ref_group_value', sa.String(), nullable=True),
    sa.Column('npv_disparity', sa.Numeric(), nullable=True),
    sa.Column('npv_ref_group_value', sa.String(), nullable=True),
    sa.Column('Statistical_Parity', sa.Boolean(), nullable=True),
    sa.Column('Impact_Parity', sa.Boolean(), nullable=True),
    sa.Column('FDR_Parity', sa.Boolean(), nullable=True),
    sa.Column('FPR_Parity', sa.Boolean(), nullable=True),
    sa.Column('FOR_Parity', sa.Boolean(), nullable=True),
    sa.Column('FNR_Parity', sa.Boolean(), nullable=True),
    sa.Column('TypeI_Parity', sa.Boolean(), nullable=True),
    sa.Column('TypeII_Parity', sa.Boolean(), nullable=True),
    sa.Column('Equalized_Odds', sa.Boolean(), nullable=True),
    sa.Column('Unsupervised_Fairness', sa.Boolean(), nullable=True),
    sa.Column('Supervised_Fairness', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['matrix_uuid'], ['model_metadata.matrices.matrix_uuid'], ),
    sa.ForeignKeyConstraint(['model_id'], ['model_metadata.models.model_id'], ),
    sa.PrimaryKeyConstraint('model_id', 'subset_hash', 'tie_breaker', 'evaluation_start_time', 'evaluation_end_time', 'parameter', 'attribute_name', 'attribute_value'),
    schema='train_results'
    )
    op.create_index(op.f('ix_train_results_aequitas_attribute_name'), 'aequitas', ['attribute_name'], unique=False, schema='train_results')
    op.create_index(op.f('ix_train_results_aequitas_attribute_value'), 'aequitas', ['attribute_value'], unique=False, schema='train_results')
    op.create_index(op.f('ix_train_results_aequitas_evaluation_end_time'), 'aequitas', ['evaluation_end_time'], unique=False, schema='train_results')
    op.create_index(op.f('ix_train_results_aequitas_evaluation_start_time'), 'aequitas', ['evaluation_start_time'], unique=False, schema='train_results')
    op.create_index(op.f('ix_train_results_aequitas_model_id'), 'aequitas', ['model_id'], unique=False, schema='train_results')
    op.create_index(op.f('ix_train_results_aequitas_parameter'), 'aequitas', ['parameter'], unique=False, schema='train_results')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_train_results_aequitas_parameter'), table_name='aequitas', schema='train_results')
    op.drop_index(op.f('ix_train_results_aequitas_model_id'), table_name='aequitas', schema='train_results')
    op.drop_index(op.f('ix_train_results_aequitas_evaluation_start_time'), table_name='aequitas', schema='train_results')
    op.drop_index(op.f('ix_train_results_aequitas_evaluation_end_time'), table_name='aequitas', schema='train_results')
    op.drop_index(op.f('ix_train_results_aequitas_attribute_value'), table_name='aequitas', schema='train_results')
    op.drop_index(op.f('ix_train_results_aequitas_attribute_name'), table_name='aequitas', schema='train_results')
    op.drop_table('aequitas', schema='train_results')
    op.drop_index(op.f('ix_test_results_aequitas_parameter'), table_name='aequitas', schema='test_results')
    op.drop_index(op.f('ix_test_results_aequitas_model_id'), table_name='aequitas', schema='test_results')
    op.drop_index(op.f('ix_test_results_aequitas_evaluation_start_time'), table_name='aequitas', schema='test_results')
    op.drop_index(op.f('ix_test_results_aequitas_evaluation_end_time'), table_name='aequitas', schema='test_results')
    op.drop_index(op.f('ix_test_results_aequitas_attribute_value'), table_name='aequitas', schema='test_results')
    op.drop_index(op.f('ix_test_results_aequitas_attribute_name'), table_name='aequitas', schema='test_results')
    op.drop_table('aequitas', schema='test_results')
    # ### end Alembic commands ###
