"""Associate experiments with models and matrices

Revision ID: 38f37d013686
Revises: d0ac573eaf1a
Create Date: 2018-10-18 16:31:43.181779

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '38f37d013686'
down_revision = 'd0ac573eaf1a'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('experiment_matrices',
    sa.Column('experiment_hash', sa.String(), nullable=False),
    sa.Column('matrix_uuid', sa.String(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_hash'], ['model_metadata.experiments.experiment_hash'], ),
    sa.PrimaryKeyConstraint('experiment_hash', 'matrix_uuid'),
    schema='model_metadata'
    )
    op.create_table('experiment_models',
    sa.Column('experiment_hash', sa.String(), nullable=False),
    sa.Column('model_hash', sa.String(), nullable=False),
    sa.ForeignKeyConstraint(['experiment_hash'], ['model_metadata.experiments.experiment_hash'], ),
    sa.PrimaryKeyConstraint('experiment_hash', 'model_hash'),
    schema='model_metadata'
    )
    op.add_column('matrices', sa.Column('built_by_experiment', sa.String(), nullable=True), schema='model_metadata')
    op.create_foreign_key(None, 'matrices', 'experiments', ['built_by_experiment'], ['experiment_hash'], source_schema='model_metadata', referent_schema='model_metadata')

    op.alter_column('models', 'experiment_hash', new_column_name='built_by_experiment', schema='model_metadata')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('models', 'built_by_experiment', new_column_name='experiment_hash', schema='model_metadata')
    op.drop_constraint(None, 'matrices', schema='model_metadata', type_='foreignkey')
    op.drop_column('matrices', 'built_by_experiment', schema='model_metadata')
    op.drop_table('experiment_models', schema='model_metadata')
    op.drop_table('experiment_matrices', schema='model_metadata')
    # ### end Alembic commands ###
