# flake8-pydantic-fields

A flake8 plugin that checks that Pydantic models have default values which are Fields, and that those fields have descriptions. This encourages data documentation.

This package adds the following warnings:

- `PYD001`: A Pydantic field which has no default.
- `PYD002`: A Pydantic field with a default that is not a Field.
- `PYD002`: A Pydantic field which has a Field default with no description.

There are no configuration options at this time.

This package uses heuristics to determine whether a class is a Pydantic model. While this could be accomplished by running the code, that is not in the spirit of static analyzers, and it would be considerably slower.

The heuristics are:

It is not a Pydantic model if:
- The class has no base classes.
- The class is annotated with `@dataclass`.

It is a Pydantic model if:
- The name of the base class is `BaseModel` or `GenericModel`.
- The class contains only annotated assignments.
- The class has at least one method decorated with `@validator` or `@root_validator`.
- The class contains an inner `Config` class.
