#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 939
#define LARGE_STATE_COUNT 646
#define SYMBOL_COUNT 72
#define ALIAS_COUNT 0
#define TOKEN_COUNT 51
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum {
  sym_semicolon = 1,
  anon_sym_LBRACK = 2,
  anon_sym_RBRACK = 3,
  sym_symbol = 4,
  sym_string = 5,
  sym_any = 6,
  sym_zero = 7,
  sym_boundary = 8,
  sym_symbol_group = 9,
  anon_sym_LPAREN = 10,
  anon_sym_RPAREN = 11,
  anon_sym_BQUOTE = 12,
  anon_sym_COMMA = 13,
  sym_colon = 14,
  sym_complement = 15,
  sym_term_complement = 16,
  sym_contains = 17,
  sym_plus = 18,
  sym_star = 19,
  sym_repeat = 20,
  sym_upper = 21,
  sym_lower = 22,
  sym_reverse = 23,
  sym_inverse = 24,
  sym_ignore = 25,
  sym_ignore_inside = 26,
  sym_union = 27,
  sym_intersect = 28,
  sym_subtract = 29,
  anon_sym__ = 30,
  anon_sym_EQ_GT = 31,
  anon_sym_DASH_GT = 32,
  anon_sym_LT_DASH = 33,
  anon_sym_LPAREN_DASH_GT_RPAREN = 34,
  anon_sym_LPAREN_LT_DASH_RPAREN = 35,
  anon_sym_AT_DASH_GT = 36,
  anon_sym_DASH_GT_AT = 37,
  anon_sym_AT_GT = 38,
  anon_sym_GT_AT = 39,
  anon_sym_LBRACK_DOT = 40,
  anon_sym_DOT_RBRACK = 41,
  anon_sym_DOT_DOT_DOT = 42,
  anon_sym_PIPE_PIPE = 43,
  anon_sym_SLASH_SLASH = 44,
  anon_sym_BSLASH_BSLASH = 45,
  anon_sym_BSLASH_SLASH = 46,
  anon_sym_COMMA_COMMA = 47,
  sym_crossproduct = 48,
  sym_compose = 49,
  sym_comment = 50,
  sym_source_file = 51,
  sym_expression = 52,
  sym_optional = 53,
  sym_substitute = 54,
  sym_context = 55,
  sym_context_list = 56,
  sym_restrict = 57,
  sym_arrow = 58,
  sym_simple_replace = 59,
  sym_single_replace = 60,
  sym_mark = 61,
  sym_parallel_replace = 62,
  sym_condition_operators = 63,
  sym_conditional_replace = 64,
  sym_parallel_conditional_replace = 65,
  aux_sym_source_file_repeat1 = 66,
  aux_sym_optional_repeat1 = 67,
  aux_sym_substitute_repeat1 = 68,
  aux_sym_context_list_repeat1 = 69,
  aux_sym_parallel_replace_repeat1 = 70,
  aux_sym_parallel_conditional_replace_repeat1 = 71,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_semicolon] = "semicolon",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_symbol] = "symbol",
  [sym_string] = "string",
  [sym_any] = "any",
  [sym_zero] = "zero",
  [sym_boundary] = "boundary",
  [sym_symbol_group] = "symbol_group",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_COMMA] = ",",
  [sym_colon] = "colon",
  [sym_complement] = "complement",
  [sym_term_complement] = "term_complement",
  [sym_contains] = "contains",
  [sym_plus] = "plus",
  [sym_star] = "star",
  [sym_repeat] = "repeat",
  [sym_upper] = "upper",
  [sym_lower] = "lower",
  [sym_reverse] = "reverse",
  [sym_inverse] = "inverse",
  [sym_ignore] = "ignore",
  [sym_ignore_inside] = "ignore_inside",
  [sym_union] = "union",
  [sym_intersect] = "intersect",
  [sym_subtract] = "subtract",
  [anon_sym__] = "_",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_LPAREN_DASH_GT_RPAREN] = "(->)",
  [anon_sym_LPAREN_LT_DASH_RPAREN] = "(<-)",
  [anon_sym_AT_DASH_GT] = "@->",
  [anon_sym_DASH_GT_AT] = "->@",
  [anon_sym_AT_GT] = "@>",
  [anon_sym_GT_AT] = ">@",
  [anon_sym_LBRACK_DOT] = "[.",
  [anon_sym_DOT_RBRACK] = ".]",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [anon_sym_BSLASH_SLASH] = "\\/",
  [anon_sym_COMMA_COMMA] = ",,",
  [sym_crossproduct] = "crossproduct",
  [sym_compose] = "compose",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym_expression] = "expression",
  [sym_optional] = "optional",
  [sym_substitute] = "substitute",
  [sym_context] = "context",
  [sym_context_list] = "context_list",
  [sym_restrict] = "restrict",
  [sym_arrow] = "arrow",
  [sym_simple_replace] = "simple_replace",
  [sym_single_replace] = "single_replace",
  [sym_mark] = "mark",
  [sym_parallel_replace] = "parallel_replace",
  [sym_condition_operators] = "condition_operators",
  [sym_conditional_replace] = "conditional_replace",
  [sym_parallel_conditional_replace] = "parallel_conditional_replace",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_optional_repeat1] = "optional_repeat1",
  [aux_sym_substitute_repeat1] = "substitute_repeat1",
  [aux_sym_context_list_repeat1] = "context_list_repeat1",
  [aux_sym_parallel_replace_repeat1] = "parallel_replace_repeat1",
  [aux_sym_parallel_conditional_replace_repeat1] = "parallel_conditional_replace_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_semicolon] = sym_semicolon,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_symbol] = sym_symbol,
  [sym_string] = sym_string,
  [sym_any] = sym_any,
  [sym_zero] = sym_zero,
  [sym_boundary] = sym_boundary,
  [sym_symbol_group] = sym_symbol_group,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym_colon] = sym_colon,
  [sym_complement] = sym_complement,
  [sym_term_complement] = sym_term_complement,
  [sym_contains] = sym_contains,
  [sym_plus] = sym_plus,
  [sym_star] = sym_star,
  [sym_repeat] = sym_repeat,
  [sym_upper] = sym_upper,
  [sym_lower] = sym_lower,
  [sym_reverse] = sym_reverse,
  [sym_inverse] = sym_inverse,
  [sym_ignore] = sym_ignore,
  [sym_ignore_inside] = sym_ignore_inside,
  [sym_union] = sym_union,
  [sym_intersect] = sym_intersect,
  [sym_subtract] = sym_subtract,
  [anon_sym__] = anon_sym__,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_LPAREN_DASH_GT_RPAREN] = anon_sym_LPAREN_DASH_GT_RPAREN,
  [anon_sym_LPAREN_LT_DASH_RPAREN] = anon_sym_LPAREN_LT_DASH_RPAREN,
  [anon_sym_AT_DASH_GT] = anon_sym_AT_DASH_GT,
  [anon_sym_DASH_GT_AT] = anon_sym_DASH_GT_AT,
  [anon_sym_AT_GT] = anon_sym_AT_GT,
  [anon_sym_GT_AT] = anon_sym_GT_AT,
  [anon_sym_LBRACK_DOT] = anon_sym_LBRACK_DOT,
  [anon_sym_DOT_RBRACK] = anon_sym_DOT_RBRACK,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [anon_sym_BSLASH_SLASH] = anon_sym_BSLASH_SLASH,
  [anon_sym_COMMA_COMMA] = anon_sym_COMMA_COMMA,
  [sym_crossproduct] = sym_crossproduct,
  [sym_compose] = sym_compose,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym_expression] = sym_expression,
  [sym_optional] = sym_optional,
  [sym_substitute] = sym_substitute,
  [sym_context] = sym_context,
  [sym_context_list] = sym_context_list,
  [sym_restrict] = sym_restrict,
  [sym_arrow] = sym_arrow,
  [sym_simple_replace] = sym_simple_replace,
  [sym_single_replace] = sym_single_replace,
  [sym_mark] = sym_mark,
  [sym_parallel_replace] = sym_parallel_replace,
  [sym_condition_operators] = sym_condition_operators,
  [sym_conditional_replace] = sym_conditional_replace,
  [sym_parallel_conditional_replace] = sym_parallel_conditional_replace,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_optional_repeat1] = aux_sym_optional_repeat1,
  [aux_sym_substitute_repeat1] = aux_sym_substitute_repeat1,
  [aux_sym_context_list_repeat1] = aux_sym_context_list_repeat1,
  [aux_sym_parallel_replace_repeat1] = aux_sym_parallel_replace_repeat1,
  [aux_sym_parallel_conditional_replace_repeat1] = aux_sym_parallel_conditional_replace_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_semicolon] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_any] = {
    .visible = true,
    .named = true,
  },
  [sym_zero] = {
    .visible = true,
    .named = true,
  },
  [sym_boundary] = {
    .visible = true,
    .named = true,
  },
  [sym_symbol_group] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_complement] = {
    .visible = true,
    .named = true,
  },
  [sym_term_complement] = {
    .visible = true,
    .named = true,
  },
  [sym_contains] = {
    .visible = true,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat] = {
    .visible = true,
    .named = true,
  },
  [sym_upper] = {
    .visible = true,
    .named = true,
  },
  [sym_lower] = {
    .visible = true,
    .named = true,
  },
  [sym_reverse] = {
    .visible = true,
    .named = true,
  },
  [sym_inverse] = {
    .visible = true,
    .named = true,
  },
  [sym_ignore] = {
    .visible = true,
    .named = true,
  },
  [sym_ignore_inside] = {
    .visible = true,
    .named = true,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_intersect] = {
    .visible = true,
    .named = true,
  },
  [sym_subtract] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DASH_GT_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LT_DASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_crossproduct] = {
    .visible = true,
    .named = true,
  },
  [sym_compose] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_optional] = {
    .visible = true,
    .named = true,
  },
  [sym_substitute] = {
    .visible = true,
    .named = true,
  },
  [sym_context] = {
    .visible = true,
    .named = true,
  },
  [sym_context_list] = {
    .visible = true,
    .named = true,
  },
  [sym_restrict] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_single_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_mark] = {
    .visible = true,
    .named = true,
  },
  [sym_parallel_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_operators] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_replace] = {
    .visible = true,
    .named = true,
  },
  [sym_parallel_conditional_replace] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_optional_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_substitute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_context_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parallel_replace_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parallel_conditional_replace_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 4,
  [10] = 10,
  [11] = 11,
  [12] = 4,
  [13] = 13,
  [14] = 4,
  [15] = 15,
  [16] = 16,
  [17] = 15,
  [18] = 18,
  [19] = 10,
  [20] = 4,
  [21] = 7,
  [22] = 6,
  [23] = 5,
  [24] = 2,
  [25] = 6,
  [26] = 13,
  [27] = 8,
  [28] = 16,
  [29] = 3,
  [30] = 11,
  [31] = 5,
  [32] = 4,
  [33] = 4,
  [34] = 3,
  [35] = 4,
  [36] = 36,
  [37] = 16,
  [38] = 11,
  [39] = 8,
  [40] = 13,
  [41] = 41,
  [42] = 2,
  [43] = 10,
  [44] = 4,
  [45] = 7,
  [46] = 2,
  [47] = 5,
  [48] = 6,
  [49] = 7,
  [50] = 10,
  [51] = 11,
  [52] = 13,
  [53] = 15,
  [54] = 8,
  [55] = 16,
  [56] = 3,
  [57] = 4,
  [58] = 15,
  [59] = 4,
  [60] = 4,
  [61] = 6,
  [62] = 4,
  [63] = 2,
  [64] = 5,
  [65] = 41,
  [66] = 7,
  [67] = 10,
  [68] = 11,
  [69] = 13,
  [70] = 8,
  [71] = 16,
  [72] = 3,
  [73] = 73,
  [74] = 18,
  [75] = 41,
  [76] = 18,
  [77] = 36,
  [78] = 36,
  [79] = 4,
  [80] = 2,
  [81] = 5,
  [82] = 6,
  [83] = 7,
  [84] = 2,
  [85] = 5,
  [86] = 6,
  [87] = 7,
  [88] = 10,
  [89] = 11,
  [90] = 13,
  [91] = 8,
  [92] = 16,
  [93] = 3,
  [94] = 4,
  [95] = 10,
  [96] = 11,
  [97] = 13,
  [98] = 8,
  [99] = 16,
  [100] = 3,
  [101] = 36,
  [102] = 18,
  [103] = 41,
  [104] = 4,
  [105] = 15,
  [106] = 15,
  [107] = 4,
  [108] = 4,
  [109] = 4,
  [110] = 15,
  [111] = 7,
  [112] = 4,
  [113] = 16,
  [114] = 10,
  [115] = 3,
  [116] = 11,
  [117] = 15,
  [118] = 13,
  [119] = 4,
  [120] = 2,
  [121] = 5,
  [122] = 6,
  [123] = 8,
  [124] = 15,
  [125] = 13,
  [126] = 16,
  [127] = 15,
  [128] = 8,
  [129] = 73,
  [130] = 41,
  [131] = 13,
  [132] = 11,
  [133] = 10,
  [134] = 18,
  [135] = 4,
  [136] = 7,
  [137] = 36,
  [138] = 6,
  [139] = 5,
  [140] = 2,
  [141] = 4,
  [142] = 41,
  [143] = 2,
  [144] = 41,
  [145] = 18,
  [146] = 36,
  [147] = 3,
  [148] = 16,
  [149] = 8,
  [150] = 4,
  [151] = 13,
  [152] = 11,
  [153] = 10,
  [154] = 7,
  [155] = 6,
  [156] = 5,
  [157] = 2,
  [158] = 3,
  [159] = 5,
  [160] = 15,
  [161] = 18,
  [162] = 6,
  [163] = 36,
  [164] = 7,
  [165] = 10,
  [166] = 4,
  [167] = 11,
  [168] = 36,
  [169] = 3,
  [170] = 18,
  [171] = 16,
  [172] = 41,
  [173] = 73,
  [174] = 8,
  [175] = 4,
  [176] = 16,
  [177] = 2,
  [178] = 41,
  [179] = 18,
  [180] = 36,
  [181] = 5,
  [182] = 6,
  [183] = 7,
  [184] = 73,
  [185] = 41,
  [186] = 18,
  [187] = 36,
  [188] = 10,
  [189] = 11,
  [190] = 15,
  [191] = 36,
  [192] = 18,
  [193] = 41,
  [194] = 73,
  [195] = 13,
  [196] = 8,
  [197] = 3,
  [198] = 13,
  [199] = 10,
  [200] = 36,
  [201] = 6,
  [202] = 5,
  [203] = 7,
  [204] = 73,
  [205] = 2,
  [206] = 11,
  [207] = 41,
  [208] = 18,
  [209] = 8,
  [210] = 16,
  [211] = 3,
  [212] = 5,
  [213] = 5,
  [214] = 6,
  [215] = 2,
  [216] = 10,
  [217] = 10,
  [218] = 11,
  [219] = 73,
  [220] = 13,
  [221] = 7,
  [222] = 7,
  [223] = 36,
  [224] = 18,
  [225] = 3,
  [226] = 3,
  [227] = 16,
  [228] = 41,
  [229] = 11,
  [230] = 6,
  [231] = 8,
  [232] = 2,
  [233] = 8,
  [234] = 13,
  [235] = 16,
  [236] = 18,
  [237] = 73,
  [238] = 73,
  [239] = 13,
  [240] = 7,
  [241] = 11,
  [242] = 18,
  [243] = 36,
  [244] = 5,
  [245] = 2,
  [246] = 6,
  [247] = 3,
  [248] = 16,
  [249] = 41,
  [250] = 8,
  [251] = 10,
  [252] = 36,
  [253] = 5,
  [254] = 11,
  [255] = 13,
  [256] = 8,
  [257] = 16,
  [258] = 3,
  [259] = 7,
  [260] = 6,
  [261] = 2,
  [262] = 10,
  [263] = 11,
  [264] = 13,
  [265] = 8,
  [266] = 16,
  [267] = 3,
  [268] = 41,
  [269] = 10,
  [270] = 6,
  [271] = 2,
  [272] = 7,
  [273] = 6,
  [274] = 3,
  [275] = 10,
  [276] = 13,
  [277] = 8,
  [278] = 36,
  [279] = 11,
  [280] = 13,
  [281] = 8,
  [282] = 16,
  [283] = 11,
  [284] = 73,
  [285] = 18,
  [286] = 16,
  [287] = 73,
  [288] = 36,
  [289] = 10,
  [290] = 18,
  [291] = 41,
  [292] = 6,
  [293] = 3,
  [294] = 2,
  [295] = 5,
  [296] = 73,
  [297] = 18,
  [298] = 2,
  [299] = 41,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 8,
  [307] = 13,
  [308] = 11,
  [309] = 304,
  [310] = 36,
  [311] = 305,
  [312] = 305,
  [313] = 73,
  [314] = 305,
  [315] = 303,
  [316] = 305,
  [317] = 18,
  [318] = 16,
  [319] = 10,
  [320] = 305,
  [321] = 305,
  [322] = 303,
  [323] = 305,
  [324] = 305,
  [325] = 305,
  [326] = 302,
  [327] = 304,
  [328] = 304,
  [329] = 305,
  [330] = 304,
  [331] = 331,
  [332] = 41,
  [333] = 6,
  [334] = 303,
  [335] = 2,
  [336] = 302,
  [337] = 302,
  [338] = 302,
  [339] = 302,
  [340] = 340,
  [341] = 302,
  [342] = 305,
  [343] = 73,
  [344] = 303,
  [345] = 302,
  [346] = 305,
  [347] = 302,
  [348] = 305,
  [349] = 18,
  [350] = 3,
  [351] = 302,
  [352] = 305,
  [353] = 305,
  [354] = 302,
  [355] = 302,
  [356] = 303,
  [357] = 304,
  [358] = 305,
  [359] = 305,
  [360] = 360,
  [361] = 73,
  [362] = 362,
  [363] = 363,
  [364] = 360,
  [365] = 365,
  [366] = 366,
  [367] = 360,
  [368] = 368,
  [369] = 369,
  [370] = 360,
  [371] = 360,
  [372] = 360,
  [373] = 360,
  [374] = 360,
  [375] = 360,
  [376] = 360,
  [377] = 301,
  [378] = 360,
  [379] = 363,
  [380] = 331,
  [381] = 331,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 331,
  [386] = 331,
  [387] = 18,
  [388] = 388,
  [389] = 360,
  [390] = 369,
  [391] = 383,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 384,
  [396] = 388,
  [397] = 369,
  [398] = 398,
  [399] = 366,
  [400] = 400,
  [401] = 401,
  [402] = 365,
  [403] = 382,
  [404] = 331,
  [405] = 388,
  [406] = 331,
  [407] = 407,
  [408] = 408,
  [409] = 384,
  [410] = 410,
  [411] = 384,
  [412] = 365,
  [413] = 383,
  [414] = 368,
  [415] = 331,
  [416] = 363,
  [417] = 366,
  [418] = 365,
  [419] = 383,
  [420] = 420,
  [421] = 382,
  [422] = 301,
  [423] = 331,
  [424] = 362,
  [425] = 363,
  [426] = 369,
  [427] = 382,
  [428] = 388,
  [429] = 331,
  [430] = 331,
  [431] = 431,
  [432] = 368,
  [433] = 369,
  [434] = 363,
  [435] = 363,
  [436] = 369,
  [437] = 331,
  [438] = 366,
  [439] = 369,
  [440] = 331,
  [441] = 401,
  [442] = 388,
  [443] = 383,
  [444] = 384,
  [445] = 331,
  [446] = 382,
  [447] = 331,
  [448] = 382,
  [449] = 369,
  [450] = 363,
  [451] = 388,
  [452] = 388,
  [453] = 383,
  [454] = 331,
  [455] = 366,
  [456] = 363,
  [457] = 363,
  [458] = 384,
  [459] = 392,
  [460] = 366,
  [461] = 368,
  [462] = 382,
  [463] = 331,
  [464] = 369,
  [465] = 383,
  [466] = 382,
  [467] = 431,
  [468] = 408,
  [469] = 363,
  [470] = 400,
  [471] = 383,
  [472] = 383,
  [473] = 369,
  [474] = 365,
  [475] = 393,
  [476] = 384,
  [477] = 398,
  [478] = 331,
  [479] = 366,
  [480] = 365,
  [481] = 420,
  [482] = 365,
  [483] = 368,
  [484] = 362,
  [485] = 394,
  [486] = 388,
  [487] = 384,
  [488] = 410,
  [489] = 407,
  [490] = 366,
  [491] = 431,
  [492] = 331,
  [493] = 383,
  [494] = 366,
  [495] = 388,
  [496] = 392,
  [497] = 384,
  [498] = 369,
  [499] = 382,
  [500] = 384,
  [501] = 383,
  [502] = 365,
  [503] = 368,
  [504] = 384,
  [505] = 420,
  [506] = 369,
  [507] = 331,
  [508] = 331,
  [509] = 363,
  [510] = 366,
  [511] = 400,
  [512] = 408,
  [513] = 365,
  [514] = 410,
  [515] = 398,
  [516] = 407,
  [517] = 365,
  [518] = 366,
  [519] = 382,
  [520] = 388,
  [521] = 393,
  [522] = 394,
  [523] = 388,
  [524] = 401,
  [525] = 383,
  [526] = 363,
  [527] = 383,
  [528] = 382,
  [529] = 331,
  [530] = 331,
  [531] = 388,
  [532] = 383,
  [533] = 331,
  [534] = 331,
  [535] = 383,
  [536] = 331,
  [537] = 331,
  [538] = 384,
  [539] = 331,
  [540] = 382,
  [541] = 366,
  [542] = 331,
  [543] = 331,
  [544] = 331,
  [545] = 365,
  [546] = 331,
  [547] = 369,
  [548] = 368,
  [549] = 363,
  [550] = 384,
  [551] = 384,
  [552] = 362,
  [553] = 388,
  [554] = 363,
  [555] = 382,
  [556] = 369,
  [557] = 365,
  [558] = 382,
  [559] = 363,
  [560] = 365,
  [561] = 363,
  [562] = 420,
  [563] = 369,
  [564] = 384,
  [565] = 410,
  [566] = 407,
  [567] = 401,
  [568] = 368,
  [569] = 382,
  [570] = 365,
  [571] = 431,
  [572] = 392,
  [573] = 363,
  [574] = 369,
  [575] = 394,
  [576] = 388,
  [577] = 365,
  [578] = 369,
  [579] = 398,
  [580] = 382,
  [581] = 393,
  [582] = 388,
  [583] = 365,
  [584] = 365,
  [585] = 362,
  [586] = 382,
  [587] = 384,
  [588] = 408,
  [589] = 384,
  [590] = 368,
  [591] = 384,
  [592] = 382,
  [593] = 365,
  [594] = 365,
  [595] = 365,
  [596] = 400,
  [597] = 388,
  [598] = 382,
  [599] = 382,
  [600] = 384,
  [601] = 363,
  [602] = 401,
  [603] = 384,
  [604] = 384,
  [605] = 407,
  [606] = 400,
  [607] = 362,
  [608] = 369,
  [609] = 382,
  [610] = 369,
  [611] = 363,
  [612] = 368,
  [613] = 392,
  [614] = 368,
  [615] = 431,
  [616] = 408,
  [617] = 388,
  [618] = 410,
  [619] = 398,
  [620] = 369,
  [621] = 384,
  [622] = 393,
  [623] = 394,
  [624] = 363,
  [625] = 420,
  [626] = 382,
  [627] = 410,
  [628] = 368,
  [629] = 384,
  [630] = 394,
  [631] = 363,
  [632] = 382,
  [633] = 382,
  [634] = 384,
  [635] = 400,
  [636] = 398,
  [637] = 401,
  [638] = 388,
  [639] = 408,
  [640] = 420,
  [641] = 407,
  [642] = 393,
  [643] = 431,
  [644] = 392,
  [645] = 369,
  [646] = 646,
  [647] = 647,
  [648] = 647,
  [649] = 647,
  [650] = 647,
  [651] = 646,
  [652] = 647,
  [653] = 646,
  [654] = 647,
  [655] = 647,
  [656] = 646,
  [657] = 646,
  [658] = 647,
  [659] = 647,
  [660] = 646,
  [661] = 647,
  [662] = 647,
  [663] = 647,
  [664] = 646,
  [665] = 647,
  [666] = 647,
  [667] = 647,
  [668] = 647,
  [669] = 646,
  [670] = 647,
  [671] = 646,
  [672] = 647,
  [673] = 647,
  [674] = 646,
  [675] = 646,
  [676] = 647,
  [677] = 647,
  [678] = 646,
  [679] = 679,
  [680] = 679,
  [681] = 679,
  [682] = 682,
  [683] = 683,
  [684] = 679,
  [685] = 679,
  [686] = 679,
  [687] = 682,
  [688] = 682,
  [689] = 679,
  [690] = 682,
  [691] = 679,
  [692] = 683,
  [693] = 683,
  [694] = 683,
  [695] = 679,
  [696] = 679,
  [697] = 697,
  [698] = 683,
  [699] = 682,
  [700] = 679,
  [701] = 679,
  [702] = 702,
  [703] = 679,
  [704] = 679,
  [705] = 679,
  [706] = 706,
  [707] = 679,
  [708] = 679,
  [709] = 683,
  [710] = 682,
  [711] = 679,
  [712] = 712,
  [713] = 712,
  [714] = 712,
  [715] = 712,
  [716] = 712,
  [717] = 712,
  [718] = 712,
  [719] = 712,
  [720] = 712,
  [721] = 712,
  [722] = 722,
  [723] = 712,
  [724] = 712,
  [725] = 712,
  [726] = 712,
  [727] = 712,
  [728] = 712,
  [729] = 712,
  [730] = 712,
  [731] = 712,
  [732] = 722,
  [733] = 712,
  [734] = 712,
  [735] = 712,
  [736] = 712,
  [737] = 712,
  [738] = 712,
  [739] = 712,
  [740] = 712,
  [741] = 712,
  [742] = 722,
  [743] = 712,
  [744] = 722,
  [745] = 722,
  [746] = 722,
  [747] = 712,
  [748] = 712,
  [749] = 712,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 751,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 750,
  [761] = 759,
  [762] = 753,
  [763] = 758,
  [764] = 757,
  [765] = 758,
  [766] = 759,
  [767] = 750,
  [768] = 754,
  [769] = 755,
  [770] = 750,
  [771] = 759,
  [772] = 758,
  [773] = 755,
  [774] = 758,
  [775] = 757,
  [776] = 758,
  [777] = 759,
  [778] = 750,
  [779] = 755,
  [780] = 757,
  [781] = 751,
  [782] = 759,
  [783] = 758,
  [784] = 759,
  [785] = 750,
  [786] = 755,
  [787] = 750,
  [788] = 788,
  [789] = 758,
  [790] = 759,
  [791] = 750,
  [792] = 752,
  [793] = 758,
  [794] = 759,
  [795] = 752,
  [796] = 754,
  [797] = 758,
  [798] = 759,
  [799] = 750,
  [800] = 757,
  [801] = 750,
  [802] = 753,
  [803] = 757,
  [804] = 751,
  [805] = 757,
  [806] = 750,
  [807] = 759,
  [808] = 751,
  [809] = 754,
  [810] = 753,
  [811] = 754,
  [812] = 758,
  [813] = 753,
  [814] = 757,
  [815] = 759,
  [816] = 758,
  [817] = 750,
  [818] = 788,
  [819] = 757,
  [820] = 757,
  [821] = 757,
  [822] = 757,
  [823] = 750,
  [824] = 753,
  [825] = 753,
  [826] = 759,
  [827] = 754,
  [828] = 753,
  [829] = 753,
  [830] = 757,
  [831] = 750,
  [832] = 759,
  [833] = 758,
  [834] = 757,
  [835] = 758,
  [836] = 754,
  [837] = 758,
  [838] = 757,
  [839] = 750,
  [840] = 759,
  [841] = 757,
  [842] = 759,
  [843] = 755,
  [844] = 757,
  [845] = 753,
  [846] = 752,
  [847] = 750,
  [848] = 752,
  [849] = 751,
  [850] = 751,
  [851] = 758,
  [852] = 759,
  [853] = 751,
  [854] = 750,
  [855] = 752,
  [856] = 751,
  [857] = 751,
  [858] = 759,
  [859] = 752,
  [860] = 758,
  [861] = 752,
  [862] = 750,
  [863] = 758,
  [864] = 752,
  [865] = 752,
  [866] = 750,
  [867] = 759,
  [868] = 759,
  [869] = 758,
  [870] = 753,
  [871] = 750,
  [872] = 754,
  [873] = 757,
  [874] = 758,
  [875] = 788,
  [876] = 751,
  [877] = 752,
  [878] = 788,
  [879] = 750,
  [880] = 759,
  [881] = 758,
  [882] = 754,
  [883] = 754,
  [884] = 754,
  [885] = 751,
  [886] = 752,
  [887] = 754,
  [888] = 753,
  [889] = 757,
  [890] = 757,
  [891] = 757,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 895,
  [897] = 895,
  [898] = 895,
  [899] = 895,
  [900] = 895,
  [901] = 895,
  [902] = 895,
  [903] = 895,
  [904] = 895,
  [905] = 895,
  [906] = 895,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 908,
  [911] = 907,
  [912] = 907,
  [913] = 908,
  [914] = 907,
  [915] = 908,
  [916] = 907,
  [917] = 908,
  [918] = 908,
  [919] = 907,
  [920] = 920,
  [921] = 921,
  [922] = 920,
  [923] = 921,
  [924] = 924,
  [925] = 921,
  [926] = 926,
  [927] = 921,
  [928] = 920,
  [929] = 921,
  [930] = 920,
  [931] = 920,
  [932] = 921,
  [933] = 924,
  [934] = 920,
  [935] = 924,
  [936] = 924,
  [937] = 924,
  [938] = 924,
};

static inline bool sym_symbol_character_set_1(int32_t c) {
  return (c < ':'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < ')'
        ? (c >= ' ' && c <= '&')
        : c <= '/')))
    : (c <= ':' || (c < '['
      ? (c < '>'
        ? c == '<'
        : c <= '?')
      : (c <= '`' || (c >= '{' && c <= '~')))));
}

static inline bool sym_symbol_character_set_2(int32_t c) {
  return (c < ':'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '*'
        ? (c >= ' ' && c <= '&')
        : c <= '/')))
    : (c <= ':' || (c < '['
      ? (c < '>'
        ? c == '<'
        : c <= '?')
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))));
}

static inline bool sym_symbol_character_set_3(int32_t c) {
  return (c < ':'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= ' ' || (c < '('
        ? (c >= '"' && c <= '&')
        : c <= '0')))
    : (c <= ':' || (c < '['
      ? (c < '>'
        ? c == '<'
        : c <= '?')
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))));
}

static inline bool sym_comment_character_set_1(int32_t c) {
  return (c < ':'
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < '('
        ? (c >= '"' && c <= '&')
        : c <= '0')))
    : (c <= ':' || (c < '['
      ? (c < '>'
        ? c == '<'
        : c <= '?')
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(42);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '&') ADVANCE(81);
      if (lookahead == '(') ADVANCE(57);
      if (lookahead == ')') ADVANCE(58);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(67);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '.') ADVANCE(9);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '0') ADVANCE(53);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == ';') ADVANCE(43);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(49);
      if (lookahead == '>') ADVANCE(28);
      if (lookahead == '?') ADVANCE(52);
      if (lookahead == '@') ADVANCE(47);
      if (lookahead == '[') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(65);
      if (lookahead == ']') ADVANCE(46);
      if (lookahead == '^') ADVANCE(29);
      if (lookahead == '_') ADVANCE(83);
      if (lookahead == '`') ADVANCE(59);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(48);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '&') ADVANCE(81);
      if (lookahead == '(') ADVANCE(57);
      if (lookahead == ')') ADVANCE(58);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(67);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '.') ADVANCE(9);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '0') ADVANCE(53);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(49);
      if (lookahead == '>') ADVANCE(28);
      if (lookahead == '?') ADVANCE(52);
      if (lookahead == '@') ADVANCE(47);
      if (lookahead == '[') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(65);
      if (lookahead == ']') ADVANCE(46);
      if (lookahead == '^') ADVANCE(29);
      if (lookahead == '`') ADVANCE(59);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(48);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '&') ADVANCE(81);
      if (lookahead == '(') ADVANCE(57);
      if (lookahead == ')') ADVANCE(58);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(67);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == '0') ADVANCE(53);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(49);
      if (lookahead == '>') ADVANCE(28);
      if (lookahead == '?') ADVANCE(52);
      if (lookahead == '@') ADVANCE(47);
      if (lookahead == '[') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(64);
      if (lookahead == ']') ADVANCE(46);
      if (lookahead == '^') ADVANCE(29);
      if (lookahead == '`') ADVANCE(59);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == '|') ADVANCE(79);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(48);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '&') ADVANCE(81);
      if (lookahead == '(') ADVANCE(57);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(67);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '.') ADVANCE(10);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '0') ADVANCE(53);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(49);
      if (lookahead == '>') ADVANCE(28);
      if (lookahead == '?') ADVANCE(52);
      if (lookahead == '@') ADVANCE(47);
      if (lookahead == '[') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(65);
      if (lookahead == '^') ADVANCE(29);
      if (lookahead == '_') ADVANCE(83);
      if (lookahead == '`') ADVANCE(59);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(48);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '&') ADVANCE(81);
      if (lookahead == '(') ADVANCE(57);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(67);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '.') ADVANCE(12);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == '0') ADVANCE(53);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(49);
      if (lookahead == '>') ADVANCE(28);
      if (lookahead == '?') ADVANCE(52);
      if (lookahead == '@') ADVANCE(47);
      if (lookahead == '[') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(64);
      if (lookahead == '^') ADVANCE(29);
      if (lookahead == '_') ADVANCE(83);
      if (lookahead == '`') ADVANCE(59);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == '|') ADVANCE(79);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(48);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == '.') ADVANCE(7);
      if (lookahead == '0') ADVANCE(53);
      if (!sym_symbol_character_set_1(lookahead)) ADVANCE(48);
      if (lookahead == '?') ADVANCE(52);
      if (lookahead == '[') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(64);
      if (lookahead == '_') ADVANCE(83);
      if (lookahead == '`') ADVANCE(59);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(51);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(20);
      END_STATE();
    case 8:
      if (lookahead == '#') ADVANCE(20);
      if (lookahead == '.') ADVANCE(21);
      END_STATE();
    case 9:
      if (lookahead == '#') ADVANCE(20);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == ']') ADVANCE(94);
      if (lookahead == 'i') ADVANCE(75);
      if (lookahead == 'l') ADVANCE(73);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'r') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(24);
      END_STATE();
    case 10:
      if (lookahead == '#') ADVANCE(20);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == 'i') ADVANCE(75);
      if (lookahead == 'l') ADVANCE(73);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'r') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == '#') ADVANCE(20);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == ']') ADVANCE(94);
      if (lookahead == 'i') ADVANCE(75);
      if (lookahead == 'l') ADVANCE(73);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'r') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(24);
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(20);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == 'i') ADVANCE(75);
      if (lookahead == 'l') ADVANCE(73);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'r') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(24);
      END_STATE();
    case 13:
      if (lookahead == ')') ADVANCE(87);
      END_STATE();
    case 14:
      if (lookahead == ')') ADVANCE(88);
      END_STATE();
    case 15:
      if (lookahead == ',') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '<') ADVANCE(19);
      END_STATE();
    case 17:
      if (lookahead == '-') ADVANCE(86);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '>') ADVANCE(91);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(14);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(54);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(95);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(78);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(102);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(101);
      END_STATE();
    case 25:
      if (lookahead == '>') ADVANCE(85);
      END_STATE();
    case 26:
      if (lookahead == '>') ADVANCE(13);
      END_STATE();
    case 27:
      if (lookahead == '>') ADVANCE(89);
      END_STATE();
    case 28:
      if (lookahead == '@') ADVANCE(92);
      END_STATE();
    case 29:
      if (lookahead == '{') ADVANCE(32);
      if (lookahead == '<' ||
          lookahead == '>') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == '}') ADVANCE(55);
      if (lookahead != 0) ADVANCE(30);
      END_STATE();
    case 31:
      if (lookahead == '}') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(31);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(15);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(31);
      END_STATE();
    case 35:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(48);
      END_STATE();
    case 36:
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(6);
      END_STATE();
    case 37:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(30);
      END_STATE();
    case 38:
      if (eof) ADVANCE(42);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '&') ADVANCE(81);
      if (lookahead == '(') ADVANCE(57);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(67);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '.') ADVANCE(10);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '0') ADVANCE(53);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == ';') ADVANCE(43);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(49);
      if (lookahead == '>') ADVANCE(28);
      if (lookahead == '?') ADVANCE(52);
      if (lookahead == '@') ADVANCE(47);
      if (lookahead == '[') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(65);
      if (lookahead == '^') ADVANCE(29);
      if (lookahead == '`') ADVANCE(59);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == '|') ADVANCE(80);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(38)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(48);
      END_STATE();
    case 39:
      if (eof) ADVANCE(42);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '&') ADVANCE(81);
      if (lookahead == '(') ADVANCE(57);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(67);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '.') ADVANCE(12);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == '0') ADVANCE(53);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == ';') ADVANCE(43);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(49);
      if (lookahead == '>') ADVANCE(28);
      if (lookahead == '?') ADVANCE(52);
      if (lookahead == '@') ADVANCE(47);
      if (lookahead == '[') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(64);
      if (lookahead == '^') ADVANCE(29);
      if (lookahead == '`') ADVANCE(59);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == '|') ADVANCE(79);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(48);
      END_STATE();
    case 40:
      if (eof) ADVANCE(42);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '#') ADVANCE(104);
      if (lookahead == '$') ADVANCE(66);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '(') ADVANCE(56);
      if (lookahead == ')') ADVANCE(58);
      if (lookahead == '.') ADVANCE(8);
      if (lookahead == '0') ADVANCE(53);
      if (!sym_symbol_character_set_2(lookahead)) ADVANCE(48);
      if (lookahead == '?') ADVANCE(52);
      if (lookahead == '[') ADVANCE(45);
      if (lookahead == '\\') ADVANCE(64);
      if (lookahead == ']') ADVANCE(46);
      if (lookahead == '`') ADVANCE(59);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == '~') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      END_STATE();
    case 41:
      if (eof) ADVANCE(42);
      if (lookahead == '(') ADVANCE(16);
      if (lookahead == ',') ADVANCE(60);
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '>') ADVANCE(28);
      if (lookahead == '@') ADVANCE(18);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '!' ||
          lookahead == '#') ADVANCE(104);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(41)
      END_STATE();
    case 42:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_semicolon);
      if (lookahead == '%') ADVANCE(35);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(48);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '.') ADVANCE(93);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(35);
      if (lookahead == '-') ADVANCE(27);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(48);
      if (lookahead == '>') ADVANCE(91);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(35);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(35);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(48);
      if (lookahead == '>') ADVANCE(84);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '%') ADVANCE(103);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(50);
      if (sym_comment_character_set_1(lookahead)) ADVANCE(104);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_any);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_zero);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_boundary);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_symbol_group);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '<') ADVANCE(19);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_COMMA);
      if (lookahead == ',') ADVANCE(100);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_colon);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_complement);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_term_complement);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_term_complement);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == '\\') ADVANCE(98);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_contains);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_plus);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_star);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_repeat);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_repeat);
      if (lookahead == ',') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_repeat);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_upper);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_lower);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_reverse);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_inverse);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_ignore);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_ignore);
      if (lookahead == '/') ADVANCE(97);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_ignore_inside);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_union);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_union);
      if (lookahead == '|') ADVANCE(96);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_intersect);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_subtract);
      if (lookahead == '>') ADVANCE(85);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '%') ADVANCE(35);
      if (!sym_symbol_character_set_3(lookahead)) ADVANCE(48);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '@') ADVANCE(90);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LPAREN_DASH_GT_RPAREN);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LPAREN_LT_DASH_RPAREN);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_AT_DASH_GT);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_DASH_GT_AT);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_AT_GT);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_GT_AT);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LBRACK_DOT);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DOT_RBRACK);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_BSLASH_SLASH);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_COMMA_COMMA);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_crossproduct);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_compose);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(50);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(104);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 40},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 1},
  [10] = {.lex_state = 1},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 1},
  [13] = {.lex_state = 1},
  [14] = {.lex_state = 1},
  [15] = {.lex_state = 1},
  [16] = {.lex_state = 1},
  [17] = {.lex_state = 38},
  [18] = {.lex_state = 1},
  [19] = {.lex_state = 38},
  [20] = {.lex_state = 38},
  [21] = {.lex_state = 38},
  [22] = {.lex_state = 38},
  [23] = {.lex_state = 38},
  [24] = {.lex_state = 38},
  [25] = {.lex_state = 1},
  [26] = {.lex_state = 38},
  [27] = {.lex_state = 38},
  [28] = {.lex_state = 38},
  [29] = {.lex_state = 38},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 1},
  [32] = {.lex_state = 38},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 38},
  [36] = {.lex_state = 1},
  [37] = {.lex_state = 1},
  [38] = {.lex_state = 38},
  [39] = {.lex_state = 1},
  [40] = {.lex_state = 1},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 1},
  [43] = {.lex_state = 1},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 1},
  [60] = {.lex_state = 38},
  [61] = {.lex_state = 38},
  [62] = {.lex_state = 38},
  [63] = {.lex_state = 38},
  [64] = {.lex_state = 38},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 38},
  [67] = {.lex_state = 38},
  [68] = {.lex_state = 38},
  [69] = {.lex_state = 38},
  [70] = {.lex_state = 38},
  [71] = {.lex_state = 38},
  [72] = {.lex_state = 38},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 38},
  [80] = {.lex_state = 38},
  [81] = {.lex_state = 38},
  [82] = {.lex_state = 38},
  [83] = {.lex_state = 38},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 38},
  [95] = {.lex_state = 38},
  [96] = {.lex_state = 38},
  [97] = {.lex_state = 38},
  [98] = {.lex_state = 38},
  [99] = {.lex_state = 38},
  [100] = {.lex_state = 38},
  [101] = {.lex_state = 38},
  [102] = {.lex_state = 38},
  [103] = {.lex_state = 38},
  [104] = {.lex_state = 38},
  [105] = {.lex_state = 3},
  [106] = {.lex_state = 38},
  [107] = {.lex_state = 38},
  [108] = {.lex_state = 3},
  [109] = {.lex_state = 3},
  [110] = {.lex_state = 38},
  [111] = {.lex_state = 3},
  [112] = {.lex_state = 3},
  [113] = {.lex_state = 3},
  [114] = {.lex_state = 3},
  [115] = {.lex_state = 3},
  [116] = {.lex_state = 3},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 3},
  [119] = {.lex_state = 3},
  [120] = {.lex_state = 3},
  [121] = {.lex_state = 3},
  [122] = {.lex_state = 3},
  [123] = {.lex_state = 3},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 38},
  [126] = {.lex_state = 3},
  [127] = {.lex_state = 38},
  [128] = {.lex_state = 3},
  [129] = {.lex_state = 38},
  [130] = {.lex_state = 38},
  [131] = {.lex_state = 3},
  [132] = {.lex_state = 3},
  [133] = {.lex_state = 3},
  [134] = {.lex_state = 38},
  [135] = {.lex_state = 3},
  [136] = {.lex_state = 3},
  [137] = {.lex_state = 38},
  [138] = {.lex_state = 3},
  [139] = {.lex_state = 3},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 3},
  [142] = {.lex_state = 38},
  [143] = {.lex_state = 38},
  [144] = {.lex_state = 3},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 3},
  [147] = {.lex_state = 3},
  [148] = {.lex_state = 3},
  [149] = {.lex_state = 3},
  [150] = {.lex_state = 3},
  [151] = {.lex_state = 3},
  [152] = {.lex_state = 3},
  [153] = {.lex_state = 3},
  [154] = {.lex_state = 3},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 3},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 3},
  [159] = {.lex_state = 38},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 38},
  [162] = {.lex_state = 38},
  [163] = {.lex_state = 38},
  [164] = {.lex_state = 38},
  [165] = {.lex_state = 38},
  [166] = {.lex_state = 3},
  [167] = {.lex_state = 38},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 38},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 38},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 38},
  [175] = {.lex_state = 3},
  [176] = {.lex_state = 3},
  [177] = {.lex_state = 3},
  [178] = {.lex_state = 3},
  [179] = {.lex_state = 3},
  [180] = {.lex_state = 3},
  [181] = {.lex_state = 3},
  [182] = {.lex_state = 3},
  [183] = {.lex_state = 3},
  [184] = {.lex_state = 38},
  [185] = {.lex_state = 38},
  [186] = {.lex_state = 38},
  [187] = {.lex_state = 38},
  [188] = {.lex_state = 3},
  [189] = {.lex_state = 3},
  [190] = {.lex_state = 3},
  [191] = {.lex_state = 3},
  [192] = {.lex_state = 3},
  [193] = {.lex_state = 3},
  [194] = {.lex_state = 3},
  [195] = {.lex_state = 3},
  [196] = {.lex_state = 3},
  [197] = {.lex_state = 3},
  [198] = {.lex_state = 2},
  [199] = {.lex_state = 2},
  [200] = {.lex_state = 3},
  [201] = {.lex_state = 2},
  [202] = {.lex_state = 2},
  [203] = {.lex_state = 2},
  [204] = {.lex_state = 3},
  [205] = {.lex_state = 2},
  [206] = {.lex_state = 2},
  [207] = {.lex_state = 3},
  [208] = {.lex_state = 3},
  [209] = {.lex_state = 2},
  [210] = {.lex_state = 2},
  [211] = {.lex_state = 2},
  [212] = {.lex_state = 39},
  [213] = {.lex_state = 2},
  [214] = {.lex_state = 39},
  [215] = {.lex_state = 39},
  [216] = {.lex_state = 2},
  [217] = {.lex_state = 39},
  [218] = {.lex_state = 39},
  [219] = {.lex_state = 2},
  [220] = {.lex_state = 39},
  [221] = {.lex_state = 39},
  [222] = {.lex_state = 2},
  [223] = {.lex_state = 2},
  [224] = {.lex_state = 2},
  [225] = {.lex_state = 2},
  [226] = {.lex_state = 39},
  [227] = {.lex_state = 2},
  [228] = {.lex_state = 2},
  [229] = {.lex_state = 2},
  [230] = {.lex_state = 2},
  [231] = {.lex_state = 2},
  [232] = {.lex_state = 2},
  [233] = {.lex_state = 39},
  [234] = {.lex_state = 2},
  [235] = {.lex_state = 39},
  [236] = {.lex_state = 39},
  [237] = {.lex_state = 39},
  [238] = {.lex_state = 2},
  [239] = {.lex_state = 2},
  [240] = {.lex_state = 4},
  [241] = {.lex_state = 2},
  [242] = {.lex_state = 2},
  [243] = {.lex_state = 2},
  [244] = {.lex_state = 4},
  [245] = {.lex_state = 39},
  [246] = {.lex_state = 39},
  [247] = {.lex_state = 2},
  [248] = {.lex_state = 2},
  [249] = {.lex_state = 39},
  [250] = {.lex_state = 2},
  [251] = {.lex_state = 39},
  [252] = {.lex_state = 39},
  [253] = {.lex_state = 39},
  [254] = {.lex_state = 39},
  [255] = {.lex_state = 39},
  [256] = {.lex_state = 39},
  [257] = {.lex_state = 39},
  [258] = {.lex_state = 39},
  [259] = {.lex_state = 39},
  [260] = {.lex_state = 4},
  [261] = {.lex_state = 2},
  [262] = {.lex_state = 4},
  [263] = {.lex_state = 4},
  [264] = {.lex_state = 4},
  [265] = {.lex_state = 4},
  [266] = {.lex_state = 4},
  [267] = {.lex_state = 4},
  [268] = {.lex_state = 2},
  [269] = {.lex_state = 2},
  [270] = {.lex_state = 2},
  [271] = {.lex_state = 4},
  [272] = {.lex_state = 4},
  [273] = {.lex_state = 39},
  [274] = {.lex_state = 4},
  [275] = {.lex_state = 39},
  [276] = {.lex_state = 4},
  [277] = {.lex_state = 4},
  [278] = {.lex_state = 39},
  [279] = {.lex_state = 39},
  [280] = {.lex_state = 39},
  [281] = {.lex_state = 39},
  [282] = {.lex_state = 4},
  [283] = {.lex_state = 4},
  [284] = {.lex_state = 4},
  [285] = {.lex_state = 4},
  [286] = {.lex_state = 39},
  [287] = {.lex_state = 2},
  [288] = {.lex_state = 4},
  [289] = {.lex_state = 4},
  [290] = {.lex_state = 2},
  [291] = {.lex_state = 4},
  [292] = {.lex_state = 4},
  [293] = {.lex_state = 39},
  [294] = {.lex_state = 4},
  [295] = {.lex_state = 4},
  [296] = {.lex_state = 39},
  [297] = {.lex_state = 39},
  [298] = {.lex_state = 39},
  [299] = {.lex_state = 39},
  [300] = {.lex_state = 39},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 2},
  [303] = {.lex_state = 2},
  [304] = {.lex_state = 2},
  [305] = {.lex_state = 4},
  [306] = {.lex_state = 4},
  [307] = {.lex_state = 4},
  [308] = {.lex_state = 4},
  [309] = {.lex_state = 2},
  [310] = {.lex_state = 4},
  [311] = {.lex_state = 4},
  [312] = {.lex_state = 4},
  [313] = {.lex_state = 39},
  [314] = {.lex_state = 4},
  [315] = {.lex_state = 2},
  [316] = {.lex_state = 4},
  [317] = {.lex_state = 39},
  [318] = {.lex_state = 4},
  [319] = {.lex_state = 4},
  [320] = {.lex_state = 4},
  [321] = {.lex_state = 4},
  [322] = {.lex_state = 2},
  [323] = {.lex_state = 4},
  [324] = {.lex_state = 4},
  [325] = {.lex_state = 4},
  [326] = {.lex_state = 2},
  [327] = {.lex_state = 2},
  [328] = {.lex_state = 2},
  [329] = {.lex_state = 4},
  [330] = {.lex_state = 2},
  [331] = {.lex_state = 1},
  [332] = {.lex_state = 4},
  [333] = {.lex_state = 4},
  [334] = {.lex_state = 2},
  [335] = {.lex_state = 4},
  [336] = {.lex_state = 2},
  [337] = {.lex_state = 2},
  [338] = {.lex_state = 2},
  [339] = {.lex_state = 2},
  [340] = {.lex_state = 2},
  [341] = {.lex_state = 2},
  [342] = {.lex_state = 4},
  [343] = {.lex_state = 4},
  [344] = {.lex_state = 2},
  [345] = {.lex_state = 2},
  [346] = {.lex_state = 4},
  [347] = {.lex_state = 2},
  [348] = {.lex_state = 4},
  [349] = {.lex_state = 4},
  [350] = {.lex_state = 4},
  [351] = {.lex_state = 2},
  [352] = {.lex_state = 4},
  [353] = {.lex_state = 4},
  [354] = {.lex_state = 2},
  [355] = {.lex_state = 2},
  [356] = {.lex_state = 2},
  [357] = {.lex_state = 2},
  [358] = {.lex_state = 4},
  [359] = {.lex_state = 4},
  [360] = {.lex_state = 2},
  [361] = {.lex_state = 4},
  [362] = {.lex_state = 1},
  [363] = {.lex_state = 1},
  [364] = {.lex_state = 2},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 1},
  [367] = {.lex_state = 2},
  [368] = {.lex_state = 1},
  [369] = {.lex_state = 1},
  [370] = {.lex_state = 2},
  [371] = {.lex_state = 2},
  [372] = {.lex_state = 2},
  [373] = {.lex_state = 2},
  [374] = {.lex_state = 2},
  [375] = {.lex_state = 2},
  [376] = {.lex_state = 2},
  [377] = {.lex_state = 38},
  [378] = {.lex_state = 2},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 1},
  [382] = {.lex_state = 1},
  [383] = {.lex_state = 1},
  [384] = {.lex_state = 1},
  [385] = {.lex_state = 1},
  [386] = {.lex_state = 38},
  [387] = {.lex_state = 4},
  [388] = {.lex_state = 1},
  [389] = {.lex_state = 2},
  [390] = {.lex_state = 1},
  [391] = {.lex_state = 38},
  [392] = {.lex_state = 1},
  [393] = {.lex_state = 1},
  [394] = {.lex_state = 1},
  [395] = {.lex_state = 1},
  [396] = {.lex_state = 1},
  [397] = {.lex_state = 38},
  [398] = {.lex_state = 1},
  [399] = {.lex_state = 1},
  [400] = {.lex_state = 1},
  [401] = {.lex_state = 1},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 1},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 38},
  [406] = {.lex_state = 38},
  [407] = {.lex_state = 1},
  [408] = {.lex_state = 1},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 1},
  [411] = {.lex_state = 38},
  [412] = {.lex_state = 38},
  [413] = {.lex_state = 1},
  [414] = {.lex_state = 1},
  [415] = {.lex_state = 1},
  [416] = {.lex_state = 1},
  [417] = {.lex_state = 1},
  [418] = {.lex_state = 1},
  [419] = {.lex_state = 1},
  [420] = {.lex_state = 1},
  [421] = {.lex_state = 38},
  [422] = {.lex_state = 3},
  [423] = {.lex_state = 1},
  [424] = {.lex_state = 38},
  [425] = {.lex_state = 38},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 1},
  [428] = {.lex_state = 1},
  [429] = {.lex_state = 38},
  [430] = {.lex_state = 3},
  [431] = {.lex_state = 1},
  [432] = {.lex_state = 38},
  [433] = {.lex_state = 1},
  [434] = {.lex_state = 1},
  [435] = {.lex_state = 38},
  [436] = {.lex_state = 38},
  [437] = {.lex_state = 38},
  [438] = {.lex_state = 38},
  [439] = {.lex_state = 3},
  [440] = {.lex_state = 3},
  [441] = {.lex_state = 38},
  [442] = {.lex_state = 3},
  [443] = {.lex_state = 38},
  [444] = {.lex_state = 3},
  [445] = {.lex_state = 38},
  [446] = {.lex_state = 3},
  [447] = {.lex_state = 3},
  [448] = {.lex_state = 1},
  [449] = {.lex_state = 38},
  [450] = {.lex_state = 3},
  [451] = {.lex_state = 1},
  [452] = {.lex_state = 38},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 38},
  [455] = {.lex_state = 3},
  [456] = {.lex_state = 38},
  [457] = {.lex_state = 38},
  [458] = {.lex_state = 38},
  [459] = {.lex_state = 38},
  [460] = {.lex_state = 38},
  [461] = {.lex_state = 38},
  [462] = {.lex_state = 38},
  [463] = {.lex_state = 38},
  [464] = {.lex_state = 38},
  [465] = {.lex_state = 38},
  [466] = {.lex_state = 38},
  [467] = {.lex_state = 38},
  [468] = {.lex_state = 38},
  [469] = {.lex_state = 3},
  [470] = {.lex_state = 38},
  [471] = {.lex_state = 3},
  [472] = {.lex_state = 1},
  [473] = {.lex_state = 3},
  [474] = {.lex_state = 38},
  [475] = {.lex_state = 38},
  [476] = {.lex_state = 38},
  [477] = {.lex_state = 38},
  [478] = {.lex_state = 3},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 3},
  [481] = {.lex_state = 38},
  [482] = {.lex_state = 38},
  [483] = {.lex_state = 3},
  [484] = {.lex_state = 3},
  [485] = {.lex_state = 38},
  [486] = {.lex_state = 38},
  [487] = {.lex_state = 1},
  [488] = {.lex_state = 38},
  [489] = {.lex_state = 38},
  [490] = {.lex_state = 38},
  [491] = {.lex_state = 3},
  [492] = {.lex_state = 3},
  [493] = {.lex_state = 38},
  [494] = {.lex_state = 3},
  [495] = {.lex_state = 3},
  [496] = {.lex_state = 3},
  [497] = {.lex_state = 38},
  [498] = {.lex_state = 3},
  [499] = {.lex_state = 3},
  [500] = {.lex_state = 3},
  [501] = {.lex_state = 3},
  [502] = {.lex_state = 3},
  [503] = {.lex_state = 3},
  [504] = {.lex_state = 3},
  [505] = {.lex_state = 3},
  [506] = {.lex_state = 3},
  [507] = {.lex_state = 3},
  [508] = {.lex_state = 3},
  [509] = {.lex_state = 3},
  [510] = {.lex_state = 3},
  [511] = {.lex_state = 3},
  [512] = {.lex_state = 3},
  [513] = {.lex_state = 3},
  [514] = {.lex_state = 3},
  [515] = {.lex_state = 3},
  [516] = {.lex_state = 3},
  [517] = {.lex_state = 1},
  [518] = {.lex_state = 38},
  [519] = {.lex_state = 3},
  [520] = {.lex_state = 3},
  [521] = {.lex_state = 3},
  [522] = {.lex_state = 3},
  [523] = {.lex_state = 38},
  [524] = {.lex_state = 3},
  [525] = {.lex_state = 3},
  [526] = {.lex_state = 3},
  [527] = {.lex_state = 38},
  [528] = {.lex_state = 38},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 1},
  [531] = {.lex_state = 3},
  [532] = {.lex_state = 3},
  [533] = {.lex_state = 1},
  [534] = {.lex_state = 1},
  [535] = {.lex_state = 3},
  [536] = {.lex_state = 1},
  [537] = {.lex_state = 1},
  [538] = {.lex_state = 3},
  [539] = {.lex_state = 1},
  [540] = {.lex_state = 3},
  [541] = {.lex_state = 3},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 1},
  [544] = {.lex_state = 1},
  [545] = {.lex_state = 38},
  [546] = {.lex_state = 1},
  [547] = {.lex_state = 2},
  [548] = {.lex_state = 2},
  [549] = {.lex_state = 2},
  [550] = {.lex_state = 2},
  [551] = {.lex_state = 2},
  [552] = {.lex_state = 2},
  [553] = {.lex_state = 2},
  [554] = {.lex_state = 2},
  [555] = {.lex_state = 2},
  [556] = {.lex_state = 2},
  [557] = {.lex_state = 3},
  [558] = {.lex_state = 2},
  [559] = {.lex_state = 39},
  [560] = {.lex_state = 1},
  [561] = {.lex_state = 39},
  [562] = {.lex_state = 2},
  [563] = {.lex_state = 2},
  [564] = {.lex_state = 2},
  [565] = {.lex_state = 2},
  [566] = {.lex_state = 2},
  [567] = {.lex_state = 2},
  [568] = {.lex_state = 2},
  [569] = {.lex_state = 2},
  [570] = {.lex_state = 1},
  [571] = {.lex_state = 2},
  [572] = {.lex_state = 2},
  [573] = {.lex_state = 2},
  [574] = {.lex_state = 39},
  [575] = {.lex_state = 2},
  [576] = {.lex_state = 2},
  [577] = {.lex_state = 1},
  [578] = {.lex_state = 39},
  [579] = {.lex_state = 2},
  [580] = {.lex_state = 39},
  [581] = {.lex_state = 2},
  [582] = {.lex_state = 39},
  [583] = {.lex_state = 1},
  [584] = {.lex_state = 1},
  [585] = {.lex_state = 39},
  [586] = {.lex_state = 39},
  [587] = {.lex_state = 2},
  [588] = {.lex_state = 2},
  [589] = {.lex_state = 39},
  [590] = {.lex_state = 39},
  [591] = {.lex_state = 39},
  [592] = {.lex_state = 2},
  [593] = {.lex_state = 1},
  [594] = {.lex_state = 1},
  [595] = {.lex_state = 1},
  [596] = {.lex_state = 2},
  [597] = {.lex_state = 4},
  [598] = {.lex_state = 39},
  [599] = {.lex_state = 4},
  [600] = {.lex_state = 39},
  [601] = {.lex_state = 39},
  [602] = {.lex_state = 39},
  [603] = {.lex_state = 4},
  [604] = {.lex_state = 4},
  [605] = {.lex_state = 39},
  [606] = {.lex_state = 39},
  [607] = {.lex_state = 4},
  [608] = {.lex_state = 4},
  [609] = {.lex_state = 4},
  [610] = {.lex_state = 4},
  [611] = {.lex_state = 4},
  [612] = {.lex_state = 4},
  [613] = {.lex_state = 39},
  [614] = {.lex_state = 39},
  [615] = {.lex_state = 39},
  [616] = {.lex_state = 39},
  [617] = {.lex_state = 39},
  [618] = {.lex_state = 39},
  [619] = {.lex_state = 39},
  [620] = {.lex_state = 39},
  [621] = {.lex_state = 39},
  [622] = {.lex_state = 39},
  [623] = {.lex_state = 39},
  [624] = {.lex_state = 4},
  [625] = {.lex_state = 39},
  [626] = {.lex_state = 39},
  [627] = {.lex_state = 4},
  [628] = {.lex_state = 4},
  [629] = {.lex_state = 4},
  [630] = {.lex_state = 4},
  [631] = {.lex_state = 4},
  [632] = {.lex_state = 4},
  [633] = {.lex_state = 4},
  [634] = {.lex_state = 4},
  [635] = {.lex_state = 4},
  [636] = {.lex_state = 4},
  [637] = {.lex_state = 4},
  [638] = {.lex_state = 4},
  [639] = {.lex_state = 4},
  [640] = {.lex_state = 4},
  [641] = {.lex_state = 4},
  [642] = {.lex_state = 4},
  [643] = {.lex_state = 4},
  [644] = {.lex_state = 4},
  [645] = {.lex_state = 4},
  [646] = {.lex_state = 5},
  [647] = {.lex_state = 5},
  [648] = {.lex_state = 5},
  [649] = {.lex_state = 5},
  [650] = {.lex_state = 5},
  [651] = {.lex_state = 5},
  [652] = {.lex_state = 5},
  [653] = {.lex_state = 5},
  [654] = {.lex_state = 5},
  [655] = {.lex_state = 5},
  [656] = {.lex_state = 5},
  [657] = {.lex_state = 5},
  [658] = {.lex_state = 5},
  [659] = {.lex_state = 5},
  [660] = {.lex_state = 5},
  [661] = {.lex_state = 5},
  [662] = {.lex_state = 5},
  [663] = {.lex_state = 5},
  [664] = {.lex_state = 5},
  [665] = {.lex_state = 5},
  [666] = {.lex_state = 5},
  [667] = {.lex_state = 5},
  [668] = {.lex_state = 5},
  [669] = {.lex_state = 5},
  [670] = {.lex_state = 5},
  [671] = {.lex_state = 5},
  [672] = {.lex_state = 5},
  [673] = {.lex_state = 5},
  [674] = {.lex_state = 5},
  [675] = {.lex_state = 5},
  [676] = {.lex_state = 5},
  [677] = {.lex_state = 5},
  [678] = {.lex_state = 5},
  [679] = {.lex_state = 5},
  [680] = {.lex_state = 5},
  [681] = {.lex_state = 5},
  [682] = {.lex_state = 40},
  [683] = {.lex_state = 40},
  [684] = {.lex_state = 5},
  [685] = {.lex_state = 5},
  [686] = {.lex_state = 5},
  [687] = {.lex_state = 40},
  [688] = {.lex_state = 40},
  [689] = {.lex_state = 5},
  [690] = {.lex_state = 40},
  [691] = {.lex_state = 5},
  [692] = {.lex_state = 40},
  [693] = {.lex_state = 40},
  [694] = {.lex_state = 40},
  [695] = {.lex_state = 5},
  [696] = {.lex_state = 5},
  [697] = {.lex_state = 40},
  [698] = {.lex_state = 40},
  [699] = {.lex_state = 40},
  [700] = {.lex_state = 5},
  [701] = {.lex_state = 5},
  [702] = {.lex_state = 40},
  [703] = {.lex_state = 5},
  [704] = {.lex_state = 5},
  [705] = {.lex_state = 5},
  [706] = {.lex_state = 40},
  [707] = {.lex_state = 5},
  [708] = {.lex_state = 5},
  [709] = {.lex_state = 40},
  [710] = {.lex_state = 40},
  [711] = {.lex_state = 5},
  [712] = {.lex_state = 40},
  [713] = {.lex_state = 40},
  [714] = {.lex_state = 40},
  [715] = {.lex_state = 40},
  [716] = {.lex_state = 40},
  [717] = {.lex_state = 40},
  [718] = {.lex_state = 40},
  [719] = {.lex_state = 40},
  [720] = {.lex_state = 40},
  [721] = {.lex_state = 40},
  [722] = {.lex_state = 40},
  [723] = {.lex_state = 40},
  [724] = {.lex_state = 40},
  [725] = {.lex_state = 40},
  [726] = {.lex_state = 40},
  [727] = {.lex_state = 40},
  [728] = {.lex_state = 40},
  [729] = {.lex_state = 40},
  [730] = {.lex_state = 40},
  [731] = {.lex_state = 40},
  [732] = {.lex_state = 40},
  [733] = {.lex_state = 40},
  [734] = {.lex_state = 40},
  [735] = {.lex_state = 40},
  [736] = {.lex_state = 40},
  [737] = {.lex_state = 40},
  [738] = {.lex_state = 40},
  [739] = {.lex_state = 40},
  [740] = {.lex_state = 40},
  [741] = {.lex_state = 40},
  [742] = {.lex_state = 40},
  [743] = {.lex_state = 40},
  [744] = {.lex_state = 40},
  [745] = {.lex_state = 40},
  [746] = {.lex_state = 40},
  [747] = {.lex_state = 40},
  [748] = {.lex_state = 40},
  [749] = {.lex_state = 40},
  [750] = {.lex_state = 40},
  [751] = {.lex_state = 40},
  [752] = {.lex_state = 40},
  [753] = {.lex_state = 40},
  [754] = {.lex_state = 40},
  [755] = {.lex_state = 40},
  [756] = {.lex_state = 40},
  [757] = {.lex_state = 40},
  [758] = {.lex_state = 40},
  [759] = {.lex_state = 40},
  [760] = {.lex_state = 40},
  [761] = {.lex_state = 40},
  [762] = {.lex_state = 40},
  [763] = {.lex_state = 40},
  [764] = {.lex_state = 40},
  [765] = {.lex_state = 40},
  [766] = {.lex_state = 40},
  [767] = {.lex_state = 40},
  [768] = {.lex_state = 40},
  [769] = {.lex_state = 40},
  [770] = {.lex_state = 40},
  [771] = {.lex_state = 40},
  [772] = {.lex_state = 40},
  [773] = {.lex_state = 40},
  [774] = {.lex_state = 40},
  [775] = {.lex_state = 40},
  [776] = {.lex_state = 40},
  [777] = {.lex_state = 40},
  [778] = {.lex_state = 40},
  [779] = {.lex_state = 40},
  [780] = {.lex_state = 40},
  [781] = {.lex_state = 40},
  [782] = {.lex_state = 40},
  [783] = {.lex_state = 40},
  [784] = {.lex_state = 40},
  [785] = {.lex_state = 40},
  [786] = {.lex_state = 40},
  [787] = {.lex_state = 40},
  [788] = {.lex_state = 40},
  [789] = {.lex_state = 40},
  [790] = {.lex_state = 40},
  [791] = {.lex_state = 40},
  [792] = {.lex_state = 40},
  [793] = {.lex_state = 40},
  [794] = {.lex_state = 40},
  [795] = {.lex_state = 40},
  [796] = {.lex_state = 40},
  [797] = {.lex_state = 40},
  [798] = {.lex_state = 40},
  [799] = {.lex_state = 40},
  [800] = {.lex_state = 40},
  [801] = {.lex_state = 40},
  [802] = {.lex_state = 40},
  [803] = {.lex_state = 40},
  [804] = {.lex_state = 40},
  [805] = {.lex_state = 40},
  [806] = {.lex_state = 40},
  [807] = {.lex_state = 40},
  [808] = {.lex_state = 40},
  [809] = {.lex_state = 40},
  [810] = {.lex_state = 40},
  [811] = {.lex_state = 40},
  [812] = {.lex_state = 40},
  [813] = {.lex_state = 40},
  [814] = {.lex_state = 40},
  [815] = {.lex_state = 40},
  [816] = {.lex_state = 40},
  [817] = {.lex_state = 40},
  [818] = {.lex_state = 40},
  [819] = {.lex_state = 40},
  [820] = {.lex_state = 40},
  [821] = {.lex_state = 40},
  [822] = {.lex_state = 40},
  [823] = {.lex_state = 40},
  [824] = {.lex_state = 40},
  [825] = {.lex_state = 40},
  [826] = {.lex_state = 40},
  [827] = {.lex_state = 40},
  [828] = {.lex_state = 40},
  [829] = {.lex_state = 40},
  [830] = {.lex_state = 40},
  [831] = {.lex_state = 40},
  [832] = {.lex_state = 40},
  [833] = {.lex_state = 40},
  [834] = {.lex_state = 40},
  [835] = {.lex_state = 40},
  [836] = {.lex_state = 40},
  [837] = {.lex_state = 40},
  [838] = {.lex_state = 40},
  [839] = {.lex_state = 40},
  [840] = {.lex_state = 40},
  [841] = {.lex_state = 40},
  [842] = {.lex_state = 40},
  [843] = {.lex_state = 40},
  [844] = {.lex_state = 40},
  [845] = {.lex_state = 40},
  [846] = {.lex_state = 40},
  [847] = {.lex_state = 40},
  [848] = {.lex_state = 40},
  [849] = {.lex_state = 40},
  [850] = {.lex_state = 40},
  [851] = {.lex_state = 40},
  [852] = {.lex_state = 40},
  [853] = {.lex_state = 40},
  [854] = {.lex_state = 40},
  [855] = {.lex_state = 40},
  [856] = {.lex_state = 40},
  [857] = {.lex_state = 40},
  [858] = {.lex_state = 40},
  [859] = {.lex_state = 40},
  [860] = {.lex_state = 40},
  [861] = {.lex_state = 40},
  [862] = {.lex_state = 40},
  [863] = {.lex_state = 40},
  [864] = {.lex_state = 40},
  [865] = {.lex_state = 40},
  [866] = {.lex_state = 40},
  [867] = {.lex_state = 40},
  [868] = {.lex_state = 40},
  [869] = {.lex_state = 40},
  [870] = {.lex_state = 40},
  [871] = {.lex_state = 40},
  [872] = {.lex_state = 40},
  [873] = {.lex_state = 40},
  [874] = {.lex_state = 40},
  [875] = {.lex_state = 40},
  [876] = {.lex_state = 40},
  [877] = {.lex_state = 40},
  [878] = {.lex_state = 40},
  [879] = {.lex_state = 40},
  [880] = {.lex_state = 40},
  [881] = {.lex_state = 40},
  [882] = {.lex_state = 40},
  [883] = {.lex_state = 40},
  [884] = {.lex_state = 40},
  [885] = {.lex_state = 40},
  [886] = {.lex_state = 40},
  [887] = {.lex_state = 40},
  [888] = {.lex_state = 40},
  [889] = {.lex_state = 40},
  [890] = {.lex_state = 40},
  [891] = {.lex_state = 40},
  [892] = {.lex_state = 40},
  [893] = {.lex_state = 5},
  [894] = {.lex_state = 40},
  [895] = {.lex_state = 41},
  [896] = {.lex_state = 41},
  [897] = {.lex_state = 41},
  [898] = {.lex_state = 41},
  [899] = {.lex_state = 41},
  [900] = {.lex_state = 41},
  [901] = {.lex_state = 41},
  [902] = {.lex_state = 41},
  [903] = {.lex_state = 41},
  [904] = {.lex_state = 41},
  [905] = {.lex_state = 41},
  [906] = {.lex_state = 41},
  [907] = {.lex_state = 40},
  [908] = {.lex_state = 40},
  [909] = {.lex_state = 40},
  [910] = {.lex_state = 40},
  [911] = {.lex_state = 40},
  [912] = {.lex_state = 40},
  [913] = {.lex_state = 40},
  [914] = {.lex_state = 40},
  [915] = {.lex_state = 40},
  [916] = {.lex_state = 40},
  [917] = {.lex_state = 40},
  [918] = {.lex_state = 40},
  [919] = {.lex_state = 40},
  [920] = {.lex_state = 40},
  [921] = {.lex_state = 41},
  [922] = {.lex_state = 40},
  [923] = {.lex_state = 41},
  [924] = {.lex_state = 41},
  [925] = {.lex_state = 41},
  [926] = {.lex_state = 41},
  [927] = {.lex_state = 41},
  [928] = {.lex_state = 40},
  [929] = {.lex_state = 41},
  [930] = {.lex_state = 40},
  [931] = {.lex_state = 40},
  [932] = {.lex_state = 41},
  [933] = {.lex_state = 41},
  [934] = {.lex_state = 40},
  [935] = {.lex_state = 41},
  [936] = {.lex_state = 41},
  [937] = {.lex_state = 41},
  [938] = {.lex_state = 41},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_semicolon] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_symbol] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_any] = ACTIONS(1),
    [sym_zero] = ACTIONS(1),
    [sym_boundary] = ACTIONS(1),
    [sym_symbol_group] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [sym_colon] = ACTIONS(1),
    [sym_complement] = ACTIONS(1),
    [sym_term_complement] = ACTIONS(1),
    [sym_contains] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
    [sym_star] = ACTIONS(1),
    [sym_repeat] = ACTIONS(1),
    [sym_upper] = ACTIONS(1),
    [sym_lower] = ACTIONS(1),
    [sym_reverse] = ACTIONS(1),
    [sym_inverse] = ACTIONS(1),
    [sym_ignore] = ACTIONS(1),
    [sym_ignore_inside] = ACTIONS(1),
    [sym_union] = ACTIONS(1),
    [sym_intersect] = ACTIONS(1),
    [sym_subtract] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(1),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(1),
    [anon_sym_AT_DASH_GT] = ACTIONS(1),
    [anon_sym_DASH_GT_AT] = ACTIONS(1),
    [anon_sym_AT_GT] = ACTIONS(1),
    [anon_sym_GT_AT] = ACTIONS(1),
    [anon_sym_LBRACK_DOT] = ACTIONS(1),
    [anon_sym_DOT_RBRACK] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [anon_sym_BSLASH_SLASH] = ACTIONS(1),
    [anon_sym_COMMA_COMMA] = ACTIONS(1),
    [sym_crossproduct] = ACTIONS(1),
    [sym_compose] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(926),
    [sym_expression] = STATE(300),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [aux_sym_source_file_repeat1] = STATE(697),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(21),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(31),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(21),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [anon_sym_COMMA_COMMA] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(59),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(77),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(83),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(87),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(89),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(35),
    [sym_term_complement] = ACTIONS(37),
    [sym_contains] = ACTIONS(35),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(45),
    [sym_intersect] = ACTIONS(47),
    [sym_subtract] = ACTIONS(45),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(49),
    [anon_sym_DOT_RBRACK] = ACTIONS(87),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [anon_sym_COMMA_COMMA] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_expression] = STATE(16),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(728),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(33),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(41),
    [sym_ignore_inside] = ACTIONS(43),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(87),
    [sym_semicolon] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(89),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [anon_sym_COMMA_COMMA] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_expression] = STATE(6),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_RBRACK] = ACTIONS(121),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_RPAREN] = ACTIONS(121),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(119),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_RBRACK] = ACTIONS(121),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [anon_sym_COMMA_COMMA] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(123),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym_semicolon] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(61),
    [sym_semicolon] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(31),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [anon_sym_COMMA_COMMA] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym_semicolon] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(141),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(143),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym_semicolon] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(145),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_expression] = STATE(7),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_RBRACK] = ACTIONS(149),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(147),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_RBRACK] = ACTIONS(149),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [anon_sym_COMMA_COMMA] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_expression] = STATE(5),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(331),
    [sym_single_replace] = STATE(331),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(390),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(21),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(21),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(21),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(151),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(21),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(31),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(155),
    [sym_term_complement] = ACTIONS(157),
    [sym_contains] = ACTIONS(155),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(159),
    [sym_ignore_inside] = ACTIONS(161),
    [sym_union] = ACTIONS(163),
    [sym_intersect] = ACTIONS(165),
    [sym_subtract] = ACTIONS(163),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [anon_sym_COMMA_COMMA] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(155),
    [sym_term_complement] = ACTIONS(157),
    [sym_contains] = ACTIONS(155),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(159),
    [sym_ignore_inside] = ACTIONS(161),
    [sym_union] = ACTIONS(163),
    [sym_intersect] = ACTIONS(165),
    [sym_subtract] = ACTIONS(163),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(155),
    [sym_term_complement] = ACTIONS(157),
    [sym_contains] = ACTIONS(155),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(159),
    [sym_ignore_inside] = ACTIONS(161),
    [sym_union] = ACTIONS(163),
    [sym_intersect] = ACTIONS(165),
    [sym_subtract] = ACTIONS(163),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(155),
    [sym_term_complement] = ACTIONS(157),
    [sym_contains] = ACTIONS(155),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(159),
    [sym_ignore_inside] = ACTIONS(161),
    [sym_union] = ACTIONS(163),
    [sym_intersect] = ACTIONS(165),
    [sym_subtract] = ACTIONS(163),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(155),
    [sym_term_complement] = ACTIONS(157),
    [sym_contains] = ACTIONS(155),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(159),
    [sym_ignore_inside] = ACTIONS(161),
    [sym_union] = ACTIONS(163),
    [sym_intersect] = ACTIONS(165),
    [sym_subtract] = ACTIONS(163),
    [anon_sym_EQ_GT] = ACTIONS(169),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(155),
    [sym_term_complement] = ACTIONS(157),
    [sym_contains] = ACTIONS(155),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(159),
    [sym_ignore_inside] = ACTIONS(161),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(87),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(89),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(155),
    [sym_term_complement] = ACTIONS(157),
    [sym_contains] = ACTIONS(155),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(159),
    [sym_ignore_inside] = ACTIONS(161),
    [sym_union] = ACTIONS(163),
    [sym_intersect] = ACTIONS(165),
    [sym_subtract] = ACTIONS(163),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [anon_sym_COMMA_COMMA] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(159),
    [sym_ignore_inside] = ACTIONS(161),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_expression] = STATE(55),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(718),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(153),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(87),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(87),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(87),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_expression] = STATE(37),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(720),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(55),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(125),
    [sym_complement] = ACTIONS(127),
    [sym_term_complement] = ACTIONS(129),
    [sym_contains] = ACTIONS(127),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(131),
    [sym_ignore_inside] = ACTIONS(133),
    [sym_union] = ACTIONS(135),
    [sym_intersect] = ACTIONS(137),
    [sym_subtract] = ACTIONS(135),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(139),
    [anon_sym_DOT_RBRACK] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(171),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_expression] = STATE(28),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(733),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym_semicolon] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(101),
    [sym_complement] = ACTIONS(103),
    [sym_term_complement] = ACTIONS(105),
    [sym_contains] = ACTIONS(103),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(109),
    [sym_ignore_inside] = ACTIONS(111),
    [sym_union] = ACTIONS(113),
    [sym_intersect] = ACTIONS(115),
    [sym_subtract] = ACTIONS(113),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(117),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(175),
    [sym_term_complement] = ACTIONS(177),
    [sym_contains] = ACTIONS(175),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(179),
    [sym_ignore_inside] = ACTIONS(181),
    [sym_union] = ACTIONS(183),
    [sym_intersect] = ACTIONS(185),
    [sym_subtract] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym_semicolon] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(205),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(31),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(175),
    [sym_term_complement] = ACTIONS(177),
    [sym_contains] = ACTIONS(175),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(179),
    [sym_ignore_inside] = ACTIONS(181),
    [sym_union] = ACTIONS(183),
    [sym_intersect] = ACTIONS(185),
    [sym_subtract] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [anon_sym_COMMA_COMMA] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(61),
    [sym_semicolon] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(175),
    [sym_term_complement] = ACTIONS(177),
    [sym_contains] = ACTIONS(175),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(179),
    [sym_ignore_inside] = ACTIONS(181),
    [sym_union] = ACTIONS(183),
    [sym_intersect] = ACTIONS(185),
    [sym_subtract] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_expression] = STATE(31),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(175),
    [sym_term_complement] = ACTIONS(177),
    [sym_contains] = ACTIONS(175),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(179),
    [sym_ignore_inside] = ACTIONS(181),
    [sym_union] = ACTIONS(183),
    [sym_intersect] = ACTIONS(185),
    [sym_subtract] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(175),
    [sym_term_complement] = ACTIONS(177),
    [sym_contains] = ACTIONS(175),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(179),
    [sym_ignore_inside] = ACTIONS(181),
    [sym_union] = ACTIONS(183),
    [sym_intersect] = ACTIONS(185),
    [sym_subtract] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(207),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(175),
    [sym_term_complement] = ACTIONS(177),
    [sym_contains] = ACTIONS(175),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(179),
    [sym_ignore_inside] = ACTIONS(181),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(179),
    [sym_ignore_inside] = ACTIONS(181),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_expression] = STATE(46),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(67),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(67),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(67),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(67),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_expression] = STATE(25),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_RBRACK] = ACTIONS(121),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_RPAREN] = ACTIONS(121),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_RBRACK] = ACTIONS(121),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_expression] = STATE(47),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_expression] = STATE(48),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_RBRACK] = ACTIONS(121),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_RPAREN] = ACTIONS(121),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(119),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_RBRACK] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [anon_sym_COMMA_COMMA] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_expression] = STATE(45),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(380),
    [sym_single_replace] = STATE(380),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(365),
    [sym_conditional_replace] = STATE(369),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_RBRACK] = ACTIONS(149),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_RBRACK] = ACTIONS(149),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_expression] = STATE(49),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(385),
    [sym_single_replace] = STATE(385),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(426),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_RBRACK] = ACTIONS(149),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(147),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_RBRACK] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [anon_sym_COMMA_COMMA] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym_semicolon] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(21),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(61),
    [sym_semicolon] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(21),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(21),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(211),
    [sym_term_complement] = ACTIONS(213),
    [sym_contains] = ACTIONS(211),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(215),
    [sym_ignore_inside] = ACTIONS(217),
    [sym_union] = ACTIONS(219),
    [sym_intersect] = ACTIONS(221),
    [sym_subtract] = ACTIONS(219),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(211),
    [sym_term_complement] = ACTIONS(213),
    [sym_contains] = ACTIONS(211),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(215),
    [sym_ignore_inside] = ACTIONS(217),
    [sym_union] = ACTIONS(219),
    [sym_intersect] = ACTIONS(221),
    [sym_subtract] = ACTIONS(219),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(211),
    [sym_term_complement] = ACTIONS(213),
    [sym_contains] = ACTIONS(211),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(215),
    [sym_ignore_inside] = ACTIONS(217),
    [sym_union] = ACTIONS(219),
    [sym_intersect] = ACTIONS(221),
    [sym_subtract] = ACTIONS(219),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(211),
    [sym_term_complement] = ACTIONS(213),
    [sym_contains] = ACTIONS(211),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(215),
    [sym_ignore_inside] = ACTIONS(217),
    [sym_union] = ACTIONS(219),
    [sym_intersect] = ACTIONS(221),
    [sym_subtract] = ACTIONS(219),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(211),
    [sym_term_complement] = ACTIONS(213),
    [sym_contains] = ACTIONS(211),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(215),
    [sym_ignore_inside] = ACTIONS(217),
    [sym_union] = ACTIONS(219),
    [sym_intersect] = ACTIONS(221),
    [sym_subtract] = ACTIONS(219),
    [anon_sym_EQ_GT] = ACTIONS(225),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(211),
    [sym_term_complement] = ACTIONS(213),
    [sym_contains] = ACTIONS(211),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(215),
    [sym_ignore_inside] = ACTIONS(217),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(215),
    [sym_ignore_inside] = ACTIONS(217),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym_semicolon] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(227),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_expression] = STATE(21),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_semicolon] = ACTIONS(147),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(147),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [anon_sym_COMMA_COMMA] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_expression] = STATE(22),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(121),
    [sym_semicolon] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(119),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [anon_sym_COMMA_COMMA] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_expression] = STATE(23),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(386),
    [sym_single_replace] = STATE(386),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(436),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym_semicolon] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(89),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [anon_sym_COMMA_COMMA] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(87),
    [sym_semicolon] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(87),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_expression] = STATE(99),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(713),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(55),
    [sym_semicolon] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(189),
    [sym_complement] = ACTIONS(191),
    [sym_term_complement] = ACTIONS(193),
    [sym_contains] = ACTIONS(191),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(195),
    [sym_ignore_inside] = ACTIONS(197),
    [sym_union] = ACTIONS(199),
    [sym_intersect] = ACTIONS(201),
    [sym_subtract] = ACTIONS(199),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(261),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(263),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_expression] = STATE(71),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(712),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(87),
    [sym_semicolon] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(89),
    [sym_colon] = ACTIONS(173),
    [sym_complement] = ACTIONS(175),
    [sym_term_complement] = ACTIONS(177),
    [sym_contains] = ACTIONS(175),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(179),
    [sym_ignore_inside] = ACTIONS(181),
    [sym_union] = ACTIONS(183),
    [sym_intersect] = ACTIONS(185),
    [sym_subtract] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [anon_sym_COMMA_COMMA] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(265),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [sym_expression] = STATE(92),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_arrow] = STATE(738),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_RBRACK] = ACTIONS(87),
    [sym_symbol] = ACTIONS(23),
    [sym_string] = ACTIONS(25),
    [sym_any] = ACTIONS(25),
    [sym_zero] = ACTIONS(25),
    [sym_boundary] = ACTIONS(25),
    [sym_symbol_group] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(87),
    [sym_colon] = ACTIONS(209),
    [sym_complement] = ACTIONS(211),
    [sym_term_complement] = ACTIONS(213),
    [sym_contains] = ACTIONS(211),
    [sym_plus] = ACTIONS(39),
    [sym_star] = ACTIONS(39),
    [sym_repeat] = ACTIONS(39),
    [sym_upper] = ACTIONS(39),
    [sym_lower] = ACTIONS(39),
    [sym_reverse] = ACTIONS(39),
    [sym_inverse] = ACTIONS(39),
    [sym_ignore] = ACTIONS(215),
    [sym_ignore_inside] = ACTIONS(217),
    [sym_union] = ACTIONS(219),
    [sym_intersect] = ACTIONS(221),
    [sym_subtract] = ACTIONS(219),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(57),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [anon_sym_COMMA_COMMA] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(31),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(31),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [anon_sym_COMMA_COMMA] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [122] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(241),
    [sym_complement] = ACTIONS(243),
    [sym_term_complement] = ACTIONS(245),
    [sym_contains] = ACTIONS(243),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(249),
    [sym_ignore_inside] = ACTIONS(251),
    [sym_union] = ACTIONS(253),
    [sym_intersect] = ACTIONS(255),
    [sym_subtract] = ACTIONS(253),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(257),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [123] = {
    [sym_expression] = STATE(113),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(715),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [124] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(87),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(87),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [125] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [126] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [127] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(87),
    [sym_semicolon] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(87),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(285),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(285),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(291),
    [sym_union] = ACTIONS(293),
    [sym_intersect] = ACTIONS(295),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [128] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [129] = {
    [sym_expression] = STATE(63),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(67),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(67),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(67),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [130] = {
    [sym_expression] = STATE(64),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [131] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [132] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [133] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(297),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [134] = {
    [sym_expression] = STATE(61),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(121),
    [sym_semicolon] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(119),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [anon_sym_COMMA_COMMA] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [135] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [136] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [137] = {
    [sym_expression] = STATE(66),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(429),
    [sym_single_replace] = STATE(429),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(464),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_semicolon] = ACTIONS(147),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(147),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [anon_sym_COMMA_COMMA] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [138] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [139] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [140] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(21),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(31),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [141] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [142] = {
    [sym_expression] = STATE(81),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [143] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(21),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(285),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(285),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(291),
    [sym_union] = ACTIONS(293),
    [sym_intersect] = ACTIONS(295),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [144] = {
    [sym_expression] = STATE(121),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [145] = {
    [sym_expression] = STATE(122),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(119),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym__] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [anon_sym_COMMA_COMMA] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [146] = {
    [sym_expression] = STATE(111),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(430),
    [sym_single_replace] = STATE(430),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(439),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(147),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym__] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [anon_sym_COMMA_COMMA] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [147] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [148] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(303),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [149] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [150] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(305),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [151] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [152] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(307),
    [sym_term_complement] = ACTIONS(309),
    [sym_contains] = ACTIONS(307),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(303),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [153] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(307),
    [sym_term_complement] = ACTIONS(309),
    [sym_contains] = ACTIONS(307),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(303),
    [sym_union] = ACTIONS(313),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(313),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(317),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [154] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(307),
    [sym_term_complement] = ACTIONS(309),
    [sym_contains] = ACTIONS(307),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(303),
    [sym_union] = ACTIONS(313),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(313),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [155] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(307),
    [sym_term_complement] = ACTIONS(309),
    [sym_contains] = ACTIONS(307),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(303),
    [sym_union] = ACTIONS(313),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(313),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [156] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(307),
    [sym_term_complement] = ACTIONS(309),
    [sym_contains] = ACTIONS(307),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(303),
    [sym_union] = ACTIONS(313),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(313),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [157] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(31),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(307),
    [sym_term_complement] = ACTIONS(309),
    [sym_contains] = ACTIONS(307),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(303),
    [sym_union] = ACTIONS(313),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(313),
    [anon_sym__] = ACTIONS(31),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [anon_sym_COMMA_COMMA] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [158] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [159] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(61),
    [sym_semicolon] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(285),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(285),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(291),
    [sym_union] = ACTIONS(293),
    [sym_intersect] = ACTIONS(295),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [160] = {
    [sym_expression] = STATE(148),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(721),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(89),
    [sym_colon] = ACTIONS(299),
    [sym_complement] = ACTIONS(307),
    [sym_term_complement] = ACTIONS(309),
    [sym_contains] = ACTIONS(307),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(301),
    [sym_ignore_inside] = ACTIONS(303),
    [sym_union] = ACTIONS(313),
    [sym_intersect] = ACTIONS(315),
    [sym_subtract] = ACTIONS(313),
    [anon_sym__] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [anon_sym_COMMA_COMMA] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [161] = {
    [sym_expression] = STATE(82),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(121),
    [sym_semicolon] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [162] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(285),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(285),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(291),
    [sym_union] = ACTIONS(293),
    [sym_intersect] = ACTIONS(295),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [163] = {
    [sym_expression] = STATE(83),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(437),
    [sym_single_replace] = STATE(437),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(412),
    [sym_conditional_replace] = STATE(397),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_semicolon] = ACTIONS(147),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [164] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(285),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(285),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(291),
    [sym_union] = ACTIONS(293),
    [sym_intersect] = ACTIONS(295),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [165] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(285),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(285),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(291),
    [sym_union] = ACTIONS(293),
    [sym_intersect] = ACTIONS(295),
    [sym_subtract] = ACTIONS(293),
    [anon_sym_EQ_GT] = ACTIONS(319),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [166] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(321),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [167] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(91),
    [sym_symbol] = ACTIONS(93),
    [sym_string] = ACTIONS(95),
    [sym_any] = ACTIONS(95),
    [sym_zero] = ACTIONS(95),
    [sym_boundary] = ACTIONS(95),
    [sym_symbol_group] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(97),
    [anon_sym_BQUOTE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(285),
    [sym_term_complement] = ACTIONS(287),
    [sym_contains] = ACTIONS(285),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(291),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [168] = {
    [sym_expression] = STATE(87),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_RBRACK] = ACTIONS(149),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_RBRACK] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [169] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [170] = {
    [sym_expression] = STATE(86),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_RBRACK] = ACTIONS(121),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_RPAREN] = ACTIONS(121),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_RBRACK] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [171] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(283),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(107),
    [sym_star] = ACTIONS(107),
    [sym_repeat] = ACTIONS(107),
    [sym_upper] = ACTIONS(107),
    [sym_lower] = ACTIONS(107),
    [sym_reverse] = ACTIONS(107),
    [sym_inverse] = ACTIONS(107),
    [sym_ignore] = ACTIONS(289),
    [sym_ignore_inside] = ACTIONS(291),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [172] = {
    [sym_expression] = STATE(85),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [173] = {
    [sym_expression] = STATE(84),
    [sym_optional] = STATE(420),
    [sym_substitute] = STATE(420),
    [sym_restrict] = STATE(420),
    [sym_simple_replace] = STATE(404),
    [sym_single_replace] = STATE(404),
    [sym_mark] = STATE(420),
    [sym_parallel_replace] = STATE(402),
    [sym_conditional_replace] = STATE(433),
    [sym_parallel_conditional_replace] = STATE(420),
    [anon_sym_LBRACK] = ACTIONS(67),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(67),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(67),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(67),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [174] = {
    [sym_expression] = STATE(171),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_arrow] = STATE(747),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [175] = {
    [sym_expression] = STATE(126),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(743),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(55),
    [sym_colon] = ACTIONS(267),
    [sym_complement] = ACTIONS(269),
    [sym_term_complement] = ACTIONS(271),
    [sym_contains] = ACTIONS(269),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(273),
    [sym_ignore_inside] = ACTIONS(275),
    [sym_union] = ACTIONS(277),
    [sym_intersect] = ACTIONS(279),
    [sym_subtract] = ACTIONS(277),
    [anon_sym__] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(55),
    [anon_sym_DASH_GT] = ACTIONS(57),
    [anon_sym_LT_DASH] = ACTIONS(55),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(55),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(55),
    [anon_sym_AT_DASH_GT] = ACTIONS(55),
    [anon_sym_DASH_GT_AT] = ACTIONS(55),
    [anon_sym_AT_GT] = ACTIONS(55),
    [anon_sym_GT_AT] = ACTIONS(55),
    [anon_sym_LBRACK_DOT] = ACTIONS(281),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(323),
    [anon_sym_PIPE_PIPE] = ACTIONS(55),
    [anon_sym_SLASH_SLASH] = ACTIONS(55),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(55),
    [anon_sym_BSLASH_SLASH] = ACTIONS(55),
    [sym_crossproduct] = ACTIONS(55),
    [sym_compose] = ACTIONS(55),
    [sym_comment] = ACTIONS(3),
  },
  [176] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(327),
    [sym_ignore_inside] = ACTIONS(329),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [177] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(21),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(331),
    [sym_term_complement] = ACTIONS(333),
    [sym_contains] = ACTIONS(331),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(327),
    [sym_ignore_inside] = ACTIONS(329),
    [sym_union] = ACTIONS(335),
    [sym_intersect] = ACTIONS(337),
    [sym_subtract] = ACTIONS(335),
    [anon_sym__] = ACTIONS(31),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(21),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(21),
    [anon_sym_BSLASH_SLASH] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [178] = {
    [sym_expression] = STATE(156),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [179] = {
    [sym_expression] = STATE(155),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(119),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym__] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [anon_sym_COMMA_COMMA] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [180] = {
    [sym_expression] = STATE(154),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(147),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym__] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [anon_sym_COMMA_COMMA] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [181] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(331),
    [sym_term_complement] = ACTIONS(333),
    [sym_contains] = ACTIONS(331),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(327),
    [sym_ignore_inside] = ACTIONS(329),
    [sym_union] = ACTIONS(335),
    [sym_intersect] = ACTIONS(337),
    [sym_subtract] = ACTIONS(335),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_SLASH_SLASH] = ACTIONS(61),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(61),
    [anon_sym_BSLASH_SLASH] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [182] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(331),
    [sym_term_complement] = ACTIONS(333),
    [sym_contains] = ACTIONS(331),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(327),
    [sym_ignore_inside] = ACTIONS(329),
    [sym_union] = ACTIONS(335),
    [sym_intersect] = ACTIONS(337),
    [sym_subtract] = ACTIONS(335),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [183] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(331),
    [sym_term_complement] = ACTIONS(333),
    [sym_contains] = ACTIONS(331),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(327),
    [sym_ignore_inside] = ACTIONS(329),
    [sym_union] = ACTIONS(335),
    [sym_intersect] = ACTIONS(337),
    [sym_subtract] = ACTIONS(335),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [184] = {
    [sym_expression] = STATE(143),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(67),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(67),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(67),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [185] = {
    [sym_expression] = STATE(159),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [186] = {
    [sym_expression] = STATE(162),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(121),
    [sym_semicolon] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [187] = {
    [sym_expression] = STATE(164),
    [sym_optional] = STATE(481),
    [sym_substitute] = STATE(481),
    [sym_restrict] = STATE(481),
    [sym_simple_replace] = STATE(463),
    [sym_single_replace] = STATE(463),
    [sym_mark] = STATE(481),
    [sym_parallel_replace] = STATE(474),
    [sym_conditional_replace] = STATE(449),
    [sym_parallel_conditional_replace] = STATE(481),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_semicolon] = ACTIONS(147),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [188] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(331),
    [sym_term_complement] = ACTIONS(333),
    [sym_contains] = ACTIONS(331),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(327),
    [sym_ignore_inside] = ACTIONS(329),
    [sym_union] = ACTIONS(335),
    [sym_intersect] = ACTIONS(337),
    [sym_subtract] = ACTIONS(335),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(341),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [189] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(331),
    [sym_term_complement] = ACTIONS(333),
    [sym_contains] = ACTIONS(331),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(327),
    [sym_ignore_inside] = ACTIONS(329),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [190] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(231),
    [sym_symbol] = ACTIONS(233),
    [sym_string] = ACTIONS(235),
    [sym_any] = ACTIONS(235),
    [sym_zero] = ACTIONS(235),
    [sym_boundary] = ACTIONS(235),
    [sym_symbol_group] = ACTIONS(235),
    [anon_sym_LPAREN] = ACTIONS(237),
    [anon_sym_BQUOTE] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(87),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(331),
    [sym_term_complement] = ACTIONS(333),
    [sym_contains] = ACTIONS(331),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(327),
    [sym_ignore_inside] = ACTIONS(329),
    [sym_union] = ACTIONS(335),
    [sym_intersect] = ACTIONS(337),
    [sym_subtract] = ACTIONS(335),
    [anon_sym__] = ACTIONS(89),
    [anon_sym_EQ_GT] = ACTIONS(87),
    [anon_sym_DASH_GT] = ACTIONS(89),
    [anon_sym_LT_DASH] = ACTIONS(87),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(87),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(87),
    [anon_sym_AT_DASH_GT] = ACTIONS(87),
    [anon_sym_DASH_GT_AT] = ACTIONS(87),
    [anon_sym_AT_GT] = ACTIONS(87),
    [anon_sym_GT_AT] = ACTIONS(87),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(87),
    [anon_sym_SLASH_SLASH] = ACTIONS(87),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(87),
    [anon_sym_BSLASH_SLASH] = ACTIONS(87),
    [sym_crossproduct] = ACTIONS(87),
    [sym_compose] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
  },
  [191] = {
    [sym_expression] = STATE(136),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym__] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [192] = {
    [sym_expression] = STATE(138),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym__] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [193] = {
    [sym_expression] = STATE(139),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(440),
    [sym_single_replace] = STATE(440),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(480),
    [sym_conditional_replace] = STATE(473),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [194] = {
    [sym_expression] = STATE(157),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(447),
    [sym_single_replace] = STATE(447),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(506),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(67),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(67),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(67),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [195] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(247),
    [sym_star] = ACTIONS(247),
    [sym_repeat] = ACTIONS(247),
    [sym_upper] = ACTIONS(247),
    [sym_lower] = ACTIONS(247),
    [sym_reverse] = ACTIONS(247),
    [sym_inverse] = ACTIONS(247),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [196] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [197] = {
    [sym_expression] = STATE(176),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_arrow] = STATE(723),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(325),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [198] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(343),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [199] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(343),
    [sym_complement] = ACTIONS(357),
    [sym_term_complement] = ACTIONS(357),
    [sym_contains] = ACTIONS(357),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(359),
    [sym_ignore_inside] = ACTIONS(359),
    [sym_union] = ACTIONS(361),
    [sym_intersect] = ACTIONS(361),
    [sym_subtract] = ACTIONS(363),
    [anon_sym_EQ_GT] = ACTIONS(365),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [200] = {
    [sym_expression] = STATE(183),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(147),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(147),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(147),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym__] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(149),
    [anon_sym_SLASH_SLASH] = ACTIONS(149),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(149),
    [anon_sym_BSLASH_SLASH] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [201] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(343),
    [sym_complement] = ACTIONS(357),
    [sym_term_complement] = ACTIONS(357),
    [sym_contains] = ACTIONS(357),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(359),
    [sym_ignore_inside] = ACTIONS(359),
    [sym_union] = ACTIONS(361),
    [sym_intersect] = ACTIONS(361),
    [sym_subtract] = ACTIONS(363),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [202] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(343),
    [sym_complement] = ACTIONS(357),
    [sym_term_complement] = ACTIONS(357),
    [sym_contains] = ACTIONS(357),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(359),
    [sym_ignore_inside] = ACTIONS(359),
    [sym_union] = ACTIONS(361),
    [sym_intersect] = ACTIONS(361),
    [sym_subtract] = ACTIONS(363),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [203] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(343),
    [sym_complement] = ACTIONS(357),
    [sym_term_complement] = ACTIONS(357),
    [sym_contains] = ACTIONS(357),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(359),
    [sym_ignore_inside] = ACTIONS(359),
    [sym_union] = ACTIONS(361),
    [sym_intersect] = ACTIONS(361),
    [sym_subtract] = ACTIONS(363),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [204] = {
    [sym_expression] = STATE(177),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(67),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(67),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(67),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_PIPE_PIPE] = ACTIONS(65),
    [anon_sym_SLASH_SLASH] = ACTIONS(65),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(65),
    [anon_sym_BSLASH_SLASH] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [205] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(21),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(31),
    [sym_colon] = ACTIONS(343),
    [sym_complement] = ACTIONS(357),
    [sym_term_complement] = ACTIONS(357),
    [sym_contains] = ACTIONS(357),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(359),
    [sym_ignore_inside] = ACTIONS(359),
    [sym_union] = ACTIONS(361),
    [sym_intersect] = ACTIONS(361),
    [sym_subtract] = ACTIONS(363),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(21),
    [anon_sym_COMMA_COMMA] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [206] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(343),
    [sym_complement] = ACTIONS(357),
    [sym_term_complement] = ACTIONS(357),
    [sym_contains] = ACTIONS(357),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(359),
    [sym_ignore_inside] = ACTIONS(359),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(167),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [207] = {
    [sym_expression] = STATE(181),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(71),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(71),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(71),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_PIPE_PIPE] = ACTIONS(69),
    [anon_sym_SLASH_SLASH] = ACTIONS(69),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(69),
    [anon_sym_BSLASH_SLASH] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [208] = {
    [sym_expression] = STATE(182),
    [sym_optional] = STATE(505),
    [sym_substitute] = STATE(505),
    [sym_restrict] = STATE(505),
    [sym_simple_replace] = STATE(508),
    [sym_single_replace] = STATE(508),
    [sym_mark] = STATE(505),
    [sym_parallel_replace] = STATE(502),
    [sym_conditional_replace] = STATE(498),
    [sym_parallel_conditional_replace] = STATE(505),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(119),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(119),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(119),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym__] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(121),
    [anon_sym_SLASH_SLASH] = ACTIONS(121),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(121),
    [anon_sym_BSLASH_SLASH] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [209] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [210] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(343),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(359),
    [sym_ignore_inside] = ACTIONS(359),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [211] = {
    [sym_expression] = STATE(210),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(748),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(343),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [212] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(61),
    [sym_semicolon] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(369),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(371),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(375),
    [sym_ignore_inside] = ACTIONS(375),
    [sym_union] = ACTIONS(377),
    [sym_intersect] = ACTIONS(377),
    [sym_subtract] = ACTIONS(379),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [213] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(61),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [214] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(369),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(371),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(375),
    [sym_ignore_inside] = ACTIONS(375),
    [sym_union] = ACTIONS(377),
    [sym_intersect] = ACTIONS(377),
    [sym_subtract] = ACTIONS(379),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [215] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(31),
    [sym_colon] = ACTIONS(369),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(371),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(375),
    [sym_ignore_inside] = ACTIONS(375),
    [sym_union] = ACTIONS(377),
    [sym_intersect] = ACTIONS(377),
    [sym_subtract] = ACTIONS(379),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_COMMA_COMMA] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [216] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [217] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(369),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(371),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(375),
    [sym_ignore_inside] = ACTIONS(375),
    [sym_union] = ACTIONS(377),
    [sym_intersect] = ACTIONS(377),
    [sym_subtract] = ACTIONS(379),
    [anon_sym_EQ_GT] = ACTIONS(393),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [218] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(369),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(371),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(375),
    [sym_ignore_inside] = ACTIONS(375),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [219] = {
    [sym_expression] = STATE(205),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(67),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(65),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(65),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(65),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [220] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(369),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [221] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(369),
    [sym_complement] = ACTIONS(371),
    [sym_term_complement] = ACTIONS(371),
    [sym_contains] = ACTIONS(371),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(375),
    [sym_ignore_inside] = ACTIONS(375),
    [sym_union] = ACTIONS(377),
    [sym_intersect] = ACTIONS(377),
    [sym_subtract] = ACTIONS(379),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(187),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [222] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [223] = {
    [sym_expression] = STATE(203),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_RBRACK] = ACTIONS(149),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(147),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(149),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(149),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(149),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_RBRACK] = ACTIONS(149),
    [anon_sym_COMMA_COMMA] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [224] = {
    [sym_expression] = STATE(201),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_RBRACK] = ACTIONS(121),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_RPAREN] = ACTIONS(121),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(119),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(121),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(121),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_RBRACK] = ACTIONS(121),
    [anon_sym_COMMA_COMMA] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [225] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [226] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(369),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [227] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [228] = {
    [sym_expression] = STATE(202),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(381),
    [sym_single_replace] = STATE(381),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(547),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(69),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(69),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(69),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [229] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [230] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [231] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [232] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(21),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(21),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [233] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [234] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [235] = {
    [sym_expression] = STATE(235),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(749),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(369),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(375),
    [sym_ignore_inside] = ACTIONS(375),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [236] = {
    [sym_expression] = STATE(214),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(121),
    [sym_semicolon] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(119),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(121),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(121),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_COMMA_COMMA] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [237] = {
    [sym_expression] = STATE(215),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(65),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(65),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(65),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [238] = {
    [sym_expression] = STATE(232),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(67),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(65),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(65),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(65),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [239] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [240] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(407),
    [sym_complement] = ACTIONS(409),
    [sym_term_complement] = ACTIONS(409),
    [sym_contains] = ACTIONS(409),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(413),
    [sym_ignore_inside] = ACTIONS(413),
    [sym_union] = ACTIONS(415),
    [sym_intersect] = ACTIONS(415),
    [sym_subtract] = ACTIONS(417),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [241] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [242] = {
    [sym_expression] = STATE(230),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_RBRACK] = ACTIONS(121),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_RPAREN] = ACTIONS(121),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(121),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(121),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_RBRACK] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [243] = {
    [sym_expression] = STATE(222),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_RBRACK] = ACTIONS(149),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(149),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(149),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(149),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_DOT_RBRACK] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [244] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(63),
    [sym_colon] = ACTIONS(407),
    [sym_complement] = ACTIONS(409),
    [sym_term_complement] = ACTIONS(409),
    [sym_contains] = ACTIONS(409),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(413),
    [sym_ignore_inside] = ACTIONS(413),
    [sym_union] = ACTIONS(415),
    [sym_intersect] = ACTIONS(415),
    [sym_subtract] = ACTIONS(417),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_COMMA_COMMA] = ACTIONS(61),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [245] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(21),
    [sym_colon] = ACTIONS(423),
    [sym_complement] = ACTIONS(425),
    [sym_term_complement] = ACTIONS(425),
    [sym_contains] = ACTIONS(425),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(427),
    [sym_ignore_inside] = ACTIONS(427),
    [sym_union] = ACTIONS(429),
    [sym_intersect] = ACTIONS(429),
    [sym_subtract] = ACTIONS(431),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [246] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(423),
    [sym_complement] = ACTIONS(425),
    [sym_term_complement] = ACTIONS(425),
    [sym_contains] = ACTIONS(425),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(427),
    [sym_ignore_inside] = ACTIONS(427),
    [sym_union] = ACTIONS(429),
    [sym_intersect] = ACTIONS(429),
    [sym_subtract] = ACTIONS(431),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [247] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [248] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [249] = {
    [sym_expression] = STATE(212),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(69),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(69),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(69),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [250] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [251] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(423),
    [sym_complement] = ACTIONS(425),
    [sym_term_complement] = ACTIONS(425),
    [sym_contains] = ACTIONS(425),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(427),
    [sym_ignore_inside] = ACTIONS(427),
    [sym_union] = ACTIONS(429),
    [sym_intersect] = ACTIONS(429),
    [sym_subtract] = ACTIONS(431),
    [anon_sym_EQ_GT] = ACTIONS(433),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [252] = {
    [sym_expression] = STATE(221),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(406),
    [sym_single_replace] = STATE(406),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(574),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_semicolon] = ACTIONS(147),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(147),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(149),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(149),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(149),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_COMMA_COMMA] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [253] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(61),
    [sym_semicolon] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(423),
    [sym_complement] = ACTIONS(425),
    [sym_term_complement] = ACTIONS(425),
    [sym_contains] = ACTIONS(425),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(427),
    [sym_ignore_inside] = ACTIONS(427),
    [sym_union] = ACTIONS(429),
    [sym_intersect] = ACTIONS(429),
    [sym_subtract] = ACTIONS(431),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [254] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(423),
    [sym_complement] = ACTIONS(425),
    [sym_term_complement] = ACTIONS(425),
    [sym_contains] = ACTIONS(425),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(427),
    [sym_ignore_inside] = ACTIONS(427),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [255] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(423),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [256] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [257] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(423),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(427),
    [sym_ignore_inside] = ACTIONS(427),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [258] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(423),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [259] = {
    [sym_expression] = STATE(257),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(725),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(423),
    [sym_complement] = ACTIONS(425),
    [sym_term_complement] = ACTIONS(425),
    [sym_contains] = ACTIONS(425),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(427),
    [sym_ignore_inside] = ACTIONS(427),
    [sym_union] = ACTIONS(429),
    [sym_intersect] = ACTIONS(429),
    [sym_subtract] = ACTIONS(431),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [260] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(407),
    [sym_complement] = ACTIONS(409),
    [sym_term_complement] = ACTIONS(409),
    [sym_contains] = ACTIONS(409),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(413),
    [sym_ignore_inside] = ACTIONS(413),
    [sym_union] = ACTIONS(415),
    [sym_intersect] = ACTIONS(415),
    [sym_subtract] = ACTIONS(417),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [261] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(21),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [262] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(407),
    [sym_complement] = ACTIONS(409),
    [sym_term_complement] = ACTIONS(409),
    [sym_contains] = ACTIONS(409),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(413),
    [sym_ignore_inside] = ACTIONS(413),
    [sym_union] = ACTIONS(415),
    [sym_intersect] = ACTIONS(415),
    [sym_subtract] = ACTIONS(417),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(439),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [263] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(407),
    [sym_complement] = ACTIONS(409),
    [sym_term_complement] = ACTIONS(409),
    [sym_contains] = ACTIONS(409),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(413),
    [sym_ignore_inside] = ACTIONS(413),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [264] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(407),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [265] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [266] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(407),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(413),
    [sym_ignore_inside] = ACTIONS(413),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [267] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(407),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [268] = {
    [sym_expression] = STATE(213),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(71),
    [anon_sym_RBRACK] = ACTIONS(69),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(69),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(69),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(69),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_DOT_RBRACK] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [269] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [270] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [271] = {
    [sym_expression] = STATE(266),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(734),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(31),
    [sym_colon] = ACTIONS(407),
    [sym_complement] = ACTIONS(409),
    [sym_term_complement] = ACTIONS(409),
    [sym_contains] = ACTIONS(409),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(413),
    [sym_ignore_inside] = ACTIONS(413),
    [sym_union] = ACTIONS(415),
    [sym_intersect] = ACTIONS(415),
    [sym_subtract] = ACTIONS(417),
    [anon_sym__] = ACTIONS(31),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(311),
    [anon_sym_COMMA_COMMA] = ACTIONS(21),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [272] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(443),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(445),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(447),
    [sym_ignore_inside] = ACTIONS(447),
    [sym_union] = ACTIONS(449),
    [sym_intersect] = ACTIONS(449),
    [sym_subtract] = ACTIONS(451),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [273] = {
    [sym_expression] = STATE(286),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(737),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [sym_colon] = ACTIONS(453),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(455),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(457),
    [sym_intersect] = ACTIONS(457),
    [sym_subtract] = ACTIONS(459),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [274] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(443),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [275] = {
    [sym_expression] = STATE(286),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(737),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [sym_colon] = ACTIONS(453),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(455),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(457),
    [sym_intersect] = ACTIONS(457),
    [sym_subtract] = ACTIONS(459),
    [anon_sym_EQ_GT] = ACTIONS(461),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [276] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(443),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [277] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [278] = {
    [sym_expression] = STATE(259),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_semicolon] = ACTIONS(147),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(149),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(149),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(149),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [279] = {
    [sym_expression] = STATE(286),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(737),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [sym_colon] = ACTIONS(453),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(455),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [280] = {
    [sym_expression] = STATE(286),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(737),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [sym_colon] = ACTIONS(453),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [281] = {
    [sym_expression] = STATE(286),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(737),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_semicolon] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [282] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(53),
    [sym_colon] = ACTIONS(443),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(447),
    [sym_ignore_inside] = ACTIONS(447),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [283] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(443),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(445),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(447),
    [sym_ignore_inside] = ACTIONS(447),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [284] = {
    [sym_expression] = STATE(271),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(67),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(65),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(65),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(65),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_COMMA_COMMA] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [285] = {
    [sym_expression] = STATE(260),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(119),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(121),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(121),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym__] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_COMMA_COMMA] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [286] = {
    [sym_expression] = STATE(286),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(737),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [sym_colon] = ACTIONS(453),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(455),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [287] = {
    [sym_expression] = STATE(261),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(67),
    [anon_sym_RBRACK] = ACTIONS(65),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(65),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(65),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(65),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [anon_sym_DOT_RBRACK] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [288] = {
    [sym_expression] = STATE(240),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(147),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(149),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(149),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(149),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym__] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [anon_sym_COMMA_COMMA] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [289] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(75),
    [sym_colon] = ACTIONS(443),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(445),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(447),
    [sym_ignore_inside] = ACTIONS(447),
    [sym_union] = ACTIONS(449),
    [sym_intersect] = ACTIONS(449),
    [sym_subtract] = ACTIONS(451),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(463),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [290] = {
    [sym_expression] = STATE(270),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(119),
    [anon_sym_RBRACK] = ACTIONS(121),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_RPAREN] = ACTIONS(121),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(121),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(121),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [anon_sym_DOT_RBRACK] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [291] = {
    [sym_expression] = STATE(244),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(478),
    [sym_single_replace] = STATE(478),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(610),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(71),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(69),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(69),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(69),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [anon_sym_COMMA_COMMA] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [292] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(443),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(445),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(447),
    [sym_ignore_inside] = ACTIONS(447),
    [sym_union] = ACTIONS(449),
    [sym_intersect] = ACTIONS(449),
    [sym_subtract] = ACTIONS(451),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [293] = {
    [sym_expression] = STATE(286),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(737),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [sym_colon] = ACTIONS(453),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [294] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(21),
    [sym_colon] = ACTIONS(443),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(445),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(447),
    [sym_ignore_inside] = ACTIONS(447),
    [sym_union] = ACTIONS(449),
    [sym_intersect] = ACTIONS(449),
    [sym_subtract] = ACTIONS(451),
    [anon_sym__] = ACTIONS(31),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [295] = {
    [sym_expression] = STATE(282),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(735),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [anon_sym_COMMA] = ACTIONS(61),
    [sym_colon] = ACTIONS(443),
    [sym_complement] = ACTIONS(445),
    [sym_term_complement] = ACTIONS(445),
    [sym_contains] = ACTIONS(445),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(447),
    [sym_ignore_inside] = ACTIONS(447),
    [sym_union] = ACTIONS(449),
    [sym_intersect] = ACTIONS(449),
    [sym_subtract] = ACTIONS(451),
    [anon_sym__] = ACTIONS(63),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_DASH_GT] = ACTIONS(63),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(61),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(61),
    [anon_sym_AT_DASH_GT] = ACTIONS(61),
    [anon_sym_DASH_GT_AT] = ACTIONS(61),
    [anon_sym_AT_GT] = ACTIONS(61),
    [anon_sym_GT_AT] = ACTIONS(61),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(61),
    [sym_compose] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [296] = {
    [sym_expression] = STATE(245),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(65),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(65),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(65),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [297] = {
    [sym_expression] = STATE(246),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(121),
    [sym_semicolon] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(121),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(121),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [298] = {
    [sym_expression] = STATE(286),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(737),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [sym_colon] = ACTIONS(453),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(455),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(457),
    [sym_intersect] = ACTIONS(457),
    [sym_subtract] = ACTIONS(459),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [299] = {
    [sym_expression] = STATE(253),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(445),
    [sym_single_replace] = STATE(445),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(482),
    [sym_conditional_replace] = STATE(578),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_semicolon] = ACTIONS(71),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(69),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(69),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(69),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [300] = {
    [sym_expression] = STATE(286),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_arrow] = STATE(737),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(465),
    [sym_semicolon] = ACTIONS(467),
    [anon_sym_LBRACK] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [sym_string] = ACTIONS(9),
    [sym_any] = ACTIONS(9),
    [sym_zero] = ACTIONS(9),
    [sym_boundary] = ACTIONS(9),
    [sym_symbol_group] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [sym_colon] = ACTIONS(453),
    [sym_complement] = ACTIONS(15),
    [sym_term_complement] = ACTIONS(15),
    [sym_contains] = ACTIONS(15),
    [sym_plus] = ACTIONS(373),
    [sym_star] = ACTIONS(373),
    [sym_repeat] = ACTIONS(373),
    [sym_upper] = ACTIONS(373),
    [sym_lower] = ACTIONS(373),
    [sym_reverse] = ACTIONS(373),
    [sym_inverse] = ACTIONS(373),
    [sym_ignore] = ACTIONS(455),
    [sym_ignore_inside] = ACTIONS(455),
    [sym_union] = ACTIONS(457),
    [sym_intersect] = ACTIONS(457),
    [sym_subtract] = ACTIONS(459),
    [anon_sym_EQ_GT] = ACTIONS(461),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(17),
    [sym_crossproduct] = ACTIONS(469),
    [sym_compose] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
  },
  [301] = {
    [sym_condition_operators] = STATE(664),
    [aux_sym_parallel_replace_repeat1] = STATE(472),
    [anon_sym_LBRACK] = ACTIONS(471),
    [anon_sym_RBRACK] = ACTIONS(473),
    [sym_symbol] = ACTIONS(471),
    [sym_string] = ACTIONS(473),
    [sym_any] = ACTIONS(473),
    [sym_zero] = ACTIONS(473),
    [sym_boundary] = ACTIONS(473),
    [sym_symbol_group] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_RPAREN] = ACTIONS(473),
    [anon_sym_BQUOTE] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(471),
    [sym_colon] = ACTIONS(473),
    [sym_complement] = ACTIONS(473),
    [sym_term_complement] = ACTIONS(471),
    [sym_contains] = ACTIONS(473),
    [sym_plus] = ACTIONS(473),
    [sym_star] = ACTIONS(473),
    [sym_repeat] = ACTIONS(473),
    [sym_upper] = ACTIONS(473),
    [sym_lower] = ACTIONS(473),
    [sym_reverse] = ACTIONS(473),
    [sym_inverse] = ACTIONS(473),
    [sym_ignore] = ACTIONS(471),
    [sym_ignore_inside] = ACTIONS(473),
    [sym_union] = ACTIONS(471),
    [sym_intersect] = ACTIONS(473),
    [sym_subtract] = ACTIONS(471),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_DASH_GT] = ACTIONS(471),
    [anon_sym_LT_DASH] = ACTIONS(473),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(473),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(473),
    [anon_sym_AT_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_AT] = ACTIONS(473),
    [anon_sym_AT_GT] = ACTIONS(473),
    [anon_sym_GT_AT] = ACTIONS(473),
    [anon_sym_LBRACK_DOT] = ACTIONS(473),
    [anon_sym_DOT_RBRACK] = ACTIONS(473),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(473),
    [anon_sym_BSLASH_SLASH] = ACTIONS(473),
    [anon_sym_COMMA_COMMA] = ACTIONS(473),
    [sym_crossproduct] = ACTIONS(473),
    [sym_compose] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [302] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(475),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [303] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(479),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [304] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(481),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(483),
    [sym_compose] = ACTIONS(483),
    [sym_comment] = ACTIONS(3),
  },
  [305] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(495),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [306] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [307] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(73),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(75),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(75),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [308] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(75),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [309] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(501),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(483),
    [sym_compose] = ACTIONS(483),
    [sym_comment] = ACTIONS(3),
  },
  [310] = {
    [sym_expression] = STATE(272),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(147),
    [sym_symbol] = ACTIONS(147),
    [sym_string] = ACTIONS(149),
    [sym_any] = ACTIONS(149),
    [sym_zero] = ACTIONS(149),
    [sym_boundary] = ACTIONS(149),
    [sym_symbol_group] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [sym_colon] = ACTIONS(149),
    [sym_complement] = ACTIONS(149),
    [sym_term_complement] = ACTIONS(149),
    [sym_contains] = ACTIONS(149),
    [sym_plus] = ACTIONS(149),
    [sym_star] = ACTIONS(149),
    [sym_repeat] = ACTIONS(149),
    [sym_upper] = ACTIONS(149),
    [sym_lower] = ACTIONS(149),
    [sym_reverse] = ACTIONS(149),
    [sym_inverse] = ACTIONS(149),
    [sym_ignore] = ACTIONS(149),
    [sym_ignore_inside] = ACTIONS(149),
    [sym_union] = ACTIONS(149),
    [sym_intersect] = ACTIONS(149),
    [sym_subtract] = ACTIONS(147),
    [anon_sym__] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_DASH_GT] = ACTIONS(147),
    [anon_sym_LT_DASH] = ACTIONS(149),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(149),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(149),
    [anon_sym_AT_DASH_GT] = ACTIONS(149),
    [anon_sym_DASH_GT_AT] = ACTIONS(149),
    [anon_sym_AT_GT] = ACTIONS(149),
    [anon_sym_GT_AT] = ACTIONS(149),
    [anon_sym_LBRACK_DOT] = ACTIONS(149),
    [sym_crossproduct] = ACTIONS(149),
    [sym_compose] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [311] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(503),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [312] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(505),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [313] = {
    [sym_expression] = STATE(298),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_semicolon] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(65),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(65),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(65),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [314] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(507),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [315] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(509),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [316] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(511),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [317] = {
    [sym_expression] = STATE(273),
    [sym_optional] = STATE(625),
    [sym_substitute] = STATE(625),
    [sym_restrict] = STATE(625),
    [sym_simple_replace] = STATE(454),
    [sym_single_replace] = STATE(454),
    [sym_mark] = STATE(625),
    [sym_parallel_replace] = STATE(545),
    [sym_conditional_replace] = STATE(620),
    [sym_parallel_conditional_replace] = STATE(625),
    [ts_builtin_sym_end] = ACTIONS(121),
    [sym_semicolon] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(121),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(121),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [318] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [319] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [320] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(513),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [321] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(515),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [322] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(517),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [323] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(519),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [324] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(521),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [325] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(523),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [326] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(525),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [327] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(527),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(483),
    [sym_compose] = ACTIONS(483),
    [sym_comment] = ACTIONS(3),
  },
  [328] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(529),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(483),
    [sym_compose] = ACTIONS(483),
    [sym_comment] = ACTIONS(3),
  },
  [329] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(531),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [330] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(533),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(483),
    [sym_compose] = ACTIONS(483),
    [sym_comment] = ACTIONS(3),
  },
  [331] = {
    [sym_condition_operators] = STATE(653),
    [aux_sym_parallel_replace_repeat1] = STATE(383),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(539),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [332] = {
    [sym_expression] = STATE(295),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(71),
    [sym_symbol] = ACTIONS(71),
    [sym_string] = ACTIONS(69),
    [sym_any] = ACTIONS(69),
    [sym_zero] = ACTIONS(69),
    [sym_boundary] = ACTIONS(69),
    [sym_symbol_group] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(69),
    [sym_colon] = ACTIONS(69),
    [sym_complement] = ACTIONS(69),
    [sym_term_complement] = ACTIONS(69),
    [sym_contains] = ACTIONS(69),
    [sym_plus] = ACTIONS(69),
    [sym_star] = ACTIONS(69),
    [sym_repeat] = ACTIONS(69),
    [sym_upper] = ACTIONS(69),
    [sym_lower] = ACTIONS(69),
    [sym_reverse] = ACTIONS(69),
    [sym_inverse] = ACTIONS(69),
    [sym_ignore] = ACTIONS(69),
    [sym_ignore_inside] = ACTIONS(69),
    [sym_union] = ACTIONS(69),
    [sym_intersect] = ACTIONS(69),
    [sym_subtract] = ACTIONS(71),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_EQ_GT] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(71),
    [anon_sym_LT_DASH] = ACTIONS(69),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(69),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(69),
    [anon_sym_AT_DASH_GT] = ACTIONS(69),
    [anon_sym_DASH_GT_AT] = ACTIONS(69),
    [anon_sym_AT_GT] = ACTIONS(69),
    [anon_sym_GT_AT] = ACTIONS(69),
    [anon_sym_LBRACK_DOT] = ACTIONS(69),
    [sym_crossproduct] = ACTIONS(69),
    [sym_compose] = ACTIONS(69),
    [sym_comment] = ACTIONS(3),
  },
  [333] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [334] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(543),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [335] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(31),
    [anon_sym_EQ_GT] = ACTIONS(21),
    [anon_sym_DASH_GT] = ACTIONS(31),
    [anon_sym_LT_DASH] = ACTIONS(21),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(21),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(21),
    [anon_sym_AT_DASH_GT] = ACTIONS(21),
    [anon_sym_DASH_GT_AT] = ACTIONS(21),
    [anon_sym_AT_GT] = ACTIONS(21),
    [anon_sym_GT_AT] = ACTIONS(21),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(21),
    [sym_compose] = ACTIONS(21),
    [sym_comment] = ACTIONS(3),
  },
  [336] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(545),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [337] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(547),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [338] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(549),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [339] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(551),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [340] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_RPAREN] = ACTIONS(553),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [341] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(555),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [342] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(557),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [343] = {
    [sym_expression] = STATE(294),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [anon_sym_COMMA] = ACTIONS(65),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(65),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(65),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(65),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [344] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(559),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [345] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(561),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [346] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(563),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [347] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(565),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [348] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(567),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [349] = {
    [sym_expression] = STATE(292),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(492),
    [sym_single_replace] = STATE(492),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(513),
    [sym_conditional_replace] = STATE(608),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_COMMA] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(121),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(121),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym__] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [350] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(53),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(53),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(53),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym__] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [351] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(569),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [352] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(571),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [353] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(573),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [354] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(575),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [355] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [anon_sym_DOT_RBRACK] = ACTIONS(577),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [356] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_RBRACK] = ACTIONS(579),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [357] = {
    [sym_expression] = STATE(227),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(714),
    [sym_simple_replace] = STATE(415),
    [sym_single_replace] = STATE(415),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(418),
    [sym_conditional_replace] = STATE(556),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(581),
    [sym_colon] = ACTIONS(381),
    [sym_complement] = ACTIONS(383),
    [sym_term_complement] = ACTIONS(383),
    [sym_contains] = ACTIONS(383),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(385),
    [sym_ignore_inside] = ACTIONS(385),
    [sym_union] = ACTIONS(387),
    [sym_intersect] = ACTIONS(387),
    [sym_subtract] = ACTIONS(389),
    [anon_sym_EQ_GT] = ACTIONS(391),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(483),
    [sym_compose] = ACTIONS(483),
    [sym_comment] = ACTIONS(3),
  },
  [358] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(583),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [359] = {
    [sym_expression] = STATE(318),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_arrow] = STATE(727),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(397),
    [sym_symbol] = ACTIONS(399),
    [sym_string] = ACTIONS(401),
    [sym_any] = ACTIONS(401),
    [sym_zero] = ACTIONS(401),
    [sym_boundary] = ACTIONS(401),
    [sym_symbol_group] = ACTIONS(401),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(405),
    [sym_colon] = ACTIONS(485),
    [sym_complement] = ACTIONS(487),
    [sym_term_complement] = ACTIONS(487),
    [sym_contains] = ACTIONS(487),
    [sym_plus] = ACTIONS(411),
    [sym_star] = ACTIONS(411),
    [sym_repeat] = ACTIONS(411),
    [sym_upper] = ACTIONS(411),
    [sym_lower] = ACTIONS(411),
    [sym_reverse] = ACTIONS(411),
    [sym_inverse] = ACTIONS(411),
    [sym_ignore] = ACTIONS(489),
    [sym_ignore_inside] = ACTIONS(489),
    [sym_union] = ACTIONS(491),
    [sym_intersect] = ACTIONS(491),
    [sym_subtract] = ACTIONS(493),
    [anon_sym__] = ACTIONS(585),
    [anon_sym_EQ_GT] = ACTIONS(497),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(339),
    [sym_crossproduct] = ACTIONS(499),
    [sym_compose] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
  },
  [360] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(729),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [361] = {
    [sym_expression] = STATE(335),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(67),
    [sym_symbol] = ACTIONS(67),
    [sym_string] = ACTIONS(65),
    [sym_any] = ACTIONS(65),
    [sym_zero] = ACTIONS(65),
    [sym_boundary] = ACTIONS(65),
    [sym_symbol_group] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [sym_colon] = ACTIONS(65),
    [sym_complement] = ACTIONS(65),
    [sym_term_complement] = ACTIONS(65),
    [sym_contains] = ACTIONS(65),
    [sym_plus] = ACTIONS(65),
    [sym_star] = ACTIONS(65),
    [sym_repeat] = ACTIONS(65),
    [sym_upper] = ACTIONS(65),
    [sym_lower] = ACTIONS(65),
    [sym_reverse] = ACTIONS(65),
    [sym_inverse] = ACTIONS(65),
    [sym_ignore] = ACTIONS(65),
    [sym_ignore_inside] = ACTIONS(65),
    [sym_union] = ACTIONS(65),
    [sym_intersect] = ACTIONS(65),
    [sym_subtract] = ACTIONS(67),
    [anon_sym__] = ACTIONS(67),
    [anon_sym_EQ_GT] = ACTIONS(65),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LT_DASH] = ACTIONS(65),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(65),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(65),
    [anon_sym_AT_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_AT] = ACTIONS(65),
    [anon_sym_AT_GT] = ACTIONS(65),
    [anon_sym_GT_AT] = ACTIONS(65),
    [anon_sym_LBRACK_DOT] = ACTIONS(65),
    [sym_crossproduct] = ACTIONS(65),
    [sym_compose] = ACTIONS(65),
    [sym_comment] = ACTIONS(3),
  },
  [362] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(573),
    [anon_sym_LBRACK] = ACTIONS(587),
    [anon_sym_RBRACK] = ACTIONS(589),
    [sym_symbol] = ACTIONS(587),
    [sym_string] = ACTIONS(589),
    [sym_any] = ACTIONS(589),
    [sym_zero] = ACTIONS(589),
    [sym_boundary] = ACTIONS(589),
    [sym_symbol_group] = ACTIONS(589),
    [anon_sym_LPAREN] = ACTIONS(587),
    [anon_sym_RPAREN] = ACTIONS(589),
    [anon_sym_BQUOTE] = ACTIONS(589),
    [anon_sym_COMMA] = ACTIONS(587),
    [sym_colon] = ACTIONS(589),
    [sym_complement] = ACTIONS(589),
    [sym_term_complement] = ACTIONS(587),
    [sym_contains] = ACTIONS(589),
    [sym_plus] = ACTIONS(589),
    [sym_star] = ACTIONS(589),
    [sym_repeat] = ACTIONS(589),
    [sym_upper] = ACTIONS(589),
    [sym_lower] = ACTIONS(589),
    [sym_reverse] = ACTIONS(589),
    [sym_inverse] = ACTIONS(589),
    [sym_ignore] = ACTIONS(587),
    [sym_ignore_inside] = ACTIONS(589),
    [sym_union] = ACTIONS(587),
    [sym_intersect] = ACTIONS(589),
    [sym_subtract] = ACTIONS(587),
    [anon_sym_EQ_GT] = ACTIONS(589),
    [anon_sym_DASH_GT] = ACTIONS(587),
    [anon_sym_LT_DASH] = ACTIONS(589),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(589),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(589),
    [anon_sym_AT_DASH_GT] = ACTIONS(589),
    [anon_sym_DASH_GT_AT] = ACTIONS(589),
    [anon_sym_AT_GT] = ACTIONS(589),
    [anon_sym_GT_AT] = ACTIONS(589),
    [anon_sym_LBRACK_DOT] = ACTIONS(589),
    [anon_sym_DOT_RBRACK] = ACTIONS(589),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(589),
    [anon_sym_PIPE_PIPE] = ACTIONS(589),
    [anon_sym_SLASH_SLASH] = ACTIONS(589),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(589),
    [anon_sym_BSLASH_SLASH] = ACTIONS(589),
    [anon_sym_COMMA_COMMA] = ACTIONS(589),
    [sym_crossproduct] = ACTIONS(589),
    [sym_compose] = ACTIONS(589),
    [sym_comment] = ACTIONS(3),
  },
  [363] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(368),
    [anon_sym_LBRACK] = ACTIONS(591),
    [anon_sym_RBRACK] = ACTIONS(593),
    [sym_symbol] = ACTIONS(591),
    [sym_string] = ACTIONS(593),
    [sym_any] = ACTIONS(593),
    [sym_zero] = ACTIONS(593),
    [sym_boundary] = ACTIONS(593),
    [sym_symbol_group] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_RPAREN] = ACTIONS(593),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(591),
    [sym_colon] = ACTIONS(593),
    [sym_complement] = ACTIONS(593),
    [sym_term_complement] = ACTIONS(591),
    [sym_contains] = ACTIONS(593),
    [sym_plus] = ACTIONS(593),
    [sym_star] = ACTIONS(593),
    [sym_repeat] = ACTIONS(593),
    [sym_upper] = ACTIONS(593),
    [sym_lower] = ACTIONS(593),
    [sym_reverse] = ACTIONS(593),
    [sym_inverse] = ACTIONS(593),
    [sym_ignore] = ACTIONS(591),
    [sym_ignore_inside] = ACTIONS(593),
    [sym_union] = ACTIONS(591),
    [sym_intersect] = ACTIONS(593),
    [sym_subtract] = ACTIONS(591),
    [anon_sym_EQ_GT] = ACTIONS(593),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_LT_DASH] = ACTIONS(593),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(593),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(593),
    [anon_sym_AT_DASH_GT] = ACTIONS(593),
    [anon_sym_DASH_GT_AT] = ACTIONS(593),
    [anon_sym_AT_GT] = ACTIONS(593),
    [anon_sym_GT_AT] = ACTIONS(593),
    [anon_sym_LBRACK_DOT] = ACTIONS(593),
    [anon_sym_DOT_RBRACK] = ACTIONS(593),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(593),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(593),
    [anon_sym_BSLASH_SLASH] = ACTIONS(593),
    [anon_sym_COMMA_COMMA] = ACTIONS(595),
    [sym_crossproduct] = ACTIONS(593),
    [sym_compose] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [364] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(741),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [365] = {
    [sym_condition_operators] = STATE(653),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [366] = {
    [aux_sym_parallel_replace_repeat1] = STATE(366),
    [anon_sym_LBRACK] = ACTIONS(471),
    [anon_sym_RBRACK] = ACTIONS(473),
    [sym_symbol] = ACTIONS(471),
    [sym_string] = ACTIONS(473),
    [sym_any] = ACTIONS(473),
    [sym_zero] = ACTIONS(473),
    [sym_boundary] = ACTIONS(473),
    [sym_symbol_group] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_RPAREN] = ACTIONS(473),
    [anon_sym_BQUOTE] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(597),
    [sym_colon] = ACTIONS(473),
    [sym_complement] = ACTIONS(473),
    [sym_term_complement] = ACTIONS(471),
    [sym_contains] = ACTIONS(473),
    [sym_plus] = ACTIONS(473),
    [sym_star] = ACTIONS(473),
    [sym_repeat] = ACTIONS(473),
    [sym_upper] = ACTIONS(473),
    [sym_lower] = ACTIONS(473),
    [sym_reverse] = ACTIONS(473),
    [sym_inverse] = ACTIONS(473),
    [sym_ignore] = ACTIONS(471),
    [sym_ignore_inside] = ACTIONS(473),
    [sym_union] = ACTIONS(471),
    [sym_intersect] = ACTIONS(473),
    [sym_subtract] = ACTIONS(471),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_DASH_GT] = ACTIONS(471),
    [anon_sym_LT_DASH] = ACTIONS(473),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(473),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(473),
    [anon_sym_AT_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_AT] = ACTIONS(473),
    [anon_sym_AT_GT] = ACTIONS(473),
    [anon_sym_GT_AT] = ACTIONS(473),
    [anon_sym_LBRACK_DOT] = ACTIONS(473),
    [anon_sym_DOT_RBRACK] = ACTIONS(473),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(473),
    [anon_sym_BSLASH_SLASH] = ACTIONS(473),
    [anon_sym_COMMA_COMMA] = ACTIONS(473),
    [sym_crossproduct] = ACTIONS(473),
    [sym_compose] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [367] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(740),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [368] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(368),
    [anon_sym_LBRACK] = ACTIONS(587),
    [anon_sym_RBRACK] = ACTIONS(589),
    [sym_symbol] = ACTIONS(587),
    [sym_string] = ACTIONS(589),
    [sym_any] = ACTIONS(589),
    [sym_zero] = ACTIONS(589),
    [sym_boundary] = ACTIONS(589),
    [sym_symbol_group] = ACTIONS(589),
    [anon_sym_LPAREN] = ACTIONS(587),
    [anon_sym_RPAREN] = ACTIONS(589),
    [anon_sym_BQUOTE] = ACTIONS(589),
    [anon_sym_COMMA] = ACTIONS(587),
    [sym_colon] = ACTIONS(589),
    [sym_complement] = ACTIONS(589),
    [sym_term_complement] = ACTIONS(587),
    [sym_contains] = ACTIONS(589),
    [sym_plus] = ACTIONS(589),
    [sym_star] = ACTIONS(589),
    [sym_repeat] = ACTIONS(589),
    [sym_upper] = ACTIONS(589),
    [sym_lower] = ACTIONS(589),
    [sym_reverse] = ACTIONS(589),
    [sym_inverse] = ACTIONS(589),
    [sym_ignore] = ACTIONS(587),
    [sym_ignore_inside] = ACTIONS(589),
    [sym_union] = ACTIONS(587),
    [sym_intersect] = ACTIONS(589),
    [sym_subtract] = ACTIONS(587),
    [anon_sym_EQ_GT] = ACTIONS(589),
    [anon_sym_DASH_GT] = ACTIONS(587),
    [anon_sym_LT_DASH] = ACTIONS(589),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(589),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(589),
    [anon_sym_AT_DASH_GT] = ACTIONS(589),
    [anon_sym_DASH_GT_AT] = ACTIONS(589),
    [anon_sym_AT_GT] = ACTIONS(589),
    [anon_sym_GT_AT] = ACTIONS(589),
    [anon_sym_LBRACK_DOT] = ACTIONS(589),
    [anon_sym_DOT_RBRACK] = ACTIONS(589),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(589),
    [anon_sym_PIPE_PIPE] = ACTIONS(589),
    [anon_sym_SLASH_SLASH] = ACTIONS(589),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(589),
    [anon_sym_BSLASH_SLASH] = ACTIONS(589),
    [anon_sym_COMMA_COMMA] = ACTIONS(600),
    [sym_crossproduct] = ACTIONS(589),
    [sym_compose] = ACTIONS(589),
    [sym_comment] = ACTIONS(3),
  },
  [369] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(363),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(595),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [370] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(736),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [371] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(726),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [372] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(731),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [373] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(716),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [374] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(717),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [375] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(719),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [376] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(724),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [377] = {
    [sym_condition_operators] = STATE(664),
    [aux_sym_parallel_replace_repeat1] = STATE(472),
    [ts_builtin_sym_end] = ACTIONS(473),
    [sym_semicolon] = ACTIONS(471),
    [anon_sym_LBRACK] = ACTIONS(471),
    [sym_symbol] = ACTIONS(471),
    [sym_string] = ACTIONS(473),
    [sym_any] = ACTIONS(473),
    [sym_zero] = ACTIONS(473),
    [sym_boundary] = ACTIONS(473),
    [sym_symbol_group] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_BQUOTE] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(471),
    [sym_colon] = ACTIONS(473),
    [sym_complement] = ACTIONS(473),
    [sym_term_complement] = ACTIONS(471),
    [sym_contains] = ACTIONS(473),
    [sym_plus] = ACTIONS(473),
    [sym_star] = ACTIONS(473),
    [sym_repeat] = ACTIONS(473),
    [sym_upper] = ACTIONS(473),
    [sym_lower] = ACTIONS(473),
    [sym_reverse] = ACTIONS(473),
    [sym_inverse] = ACTIONS(473),
    [sym_ignore] = ACTIONS(471),
    [sym_ignore_inside] = ACTIONS(473),
    [sym_union] = ACTIONS(471),
    [sym_intersect] = ACTIONS(473),
    [sym_subtract] = ACTIONS(471),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_DASH_GT] = ACTIONS(471),
    [anon_sym_LT_DASH] = ACTIONS(473),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(473),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(473),
    [anon_sym_AT_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_AT] = ACTIONS(473),
    [anon_sym_AT_GT] = ACTIONS(473),
    [anon_sym_GT_AT] = ACTIONS(473),
    [anon_sym_LBRACK_DOT] = ACTIONS(473),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(473),
    [anon_sym_BSLASH_SLASH] = ACTIONS(473),
    [anon_sym_COMMA_COMMA] = ACTIONS(473),
    [sym_crossproduct] = ACTIONS(473),
    [sym_compose] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [378] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(739),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [379] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(368),
    [anon_sym_LBRACK] = ACTIONS(591),
    [anon_sym_RBRACK] = ACTIONS(593),
    [sym_symbol] = ACTIONS(591),
    [sym_string] = ACTIONS(593),
    [sym_any] = ACTIONS(593),
    [sym_zero] = ACTIONS(593),
    [sym_boundary] = ACTIONS(593),
    [sym_symbol_group] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_RPAREN] = ACTIONS(593),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(591),
    [sym_colon] = ACTIONS(593),
    [sym_complement] = ACTIONS(593),
    [sym_term_complement] = ACTIONS(591),
    [sym_contains] = ACTIONS(593),
    [sym_plus] = ACTIONS(593),
    [sym_star] = ACTIONS(593),
    [sym_repeat] = ACTIONS(593),
    [sym_upper] = ACTIONS(593),
    [sym_lower] = ACTIONS(593),
    [sym_reverse] = ACTIONS(593),
    [sym_inverse] = ACTIONS(593),
    [sym_ignore] = ACTIONS(591),
    [sym_ignore_inside] = ACTIONS(593),
    [sym_union] = ACTIONS(591),
    [sym_intersect] = ACTIONS(593),
    [sym_subtract] = ACTIONS(591),
    [anon_sym_EQ_GT] = ACTIONS(593),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_LT_DASH] = ACTIONS(593),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(593),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(593),
    [anon_sym_AT_DASH_GT] = ACTIONS(593),
    [anon_sym_DASH_GT_AT] = ACTIONS(593),
    [anon_sym_AT_GT] = ACTIONS(593),
    [anon_sym_GT_AT] = ACTIONS(593),
    [anon_sym_LBRACK_DOT] = ACTIONS(593),
    [anon_sym_DOT_RBRACK] = ACTIONS(593),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(593),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(593),
    [anon_sym_BSLASH_SLASH] = ACTIONS(593),
    [anon_sym_COMMA_COMMA] = ACTIONS(593),
    [sym_crossproduct] = ACTIONS(593),
    [sym_compose] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [380] = {
    [sym_condition_operators] = STATE(653),
    [aux_sym_parallel_replace_repeat1] = STATE(413),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(603),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [381] = {
    [sym_condition_operators] = STATE(651),
    [aux_sym_parallel_replace_repeat1] = STATE(419),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(605),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [382] = {
    [aux_sym_context_list_repeat1] = STATE(388),
    [anon_sym_LBRACK] = ACTIONS(607),
    [anon_sym_RBRACK] = ACTIONS(609),
    [sym_symbol] = ACTIONS(607),
    [sym_string] = ACTIONS(609),
    [sym_any] = ACTIONS(609),
    [sym_zero] = ACTIONS(609),
    [sym_boundary] = ACTIONS(609),
    [sym_symbol_group] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(607),
    [anon_sym_RPAREN] = ACTIONS(609),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(607),
    [sym_colon] = ACTIONS(609),
    [sym_complement] = ACTIONS(609),
    [sym_term_complement] = ACTIONS(607),
    [sym_contains] = ACTIONS(609),
    [sym_plus] = ACTIONS(609),
    [sym_star] = ACTIONS(609),
    [sym_repeat] = ACTIONS(609),
    [sym_upper] = ACTIONS(609),
    [sym_lower] = ACTIONS(609),
    [sym_reverse] = ACTIONS(609),
    [sym_inverse] = ACTIONS(609),
    [sym_ignore] = ACTIONS(607),
    [sym_ignore_inside] = ACTIONS(609),
    [sym_union] = ACTIONS(607),
    [sym_intersect] = ACTIONS(609),
    [sym_subtract] = ACTIONS(607),
    [anon_sym_EQ_GT] = ACTIONS(609),
    [anon_sym_DASH_GT] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(609),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(609),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(609),
    [anon_sym_AT_DASH_GT] = ACTIONS(609),
    [anon_sym_DASH_GT_AT] = ACTIONS(609),
    [anon_sym_AT_GT] = ACTIONS(609),
    [anon_sym_GT_AT] = ACTIONS(609),
    [anon_sym_LBRACK_DOT] = ACTIONS(609),
    [anon_sym_DOT_RBRACK] = ACTIONS(609),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(609),
    [anon_sym_PIPE_PIPE] = ACTIONS(609),
    [anon_sym_SLASH_SLASH] = ACTIONS(609),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(609),
    [anon_sym_BSLASH_SLASH] = ACTIONS(609),
    [anon_sym_COMMA_COMMA] = ACTIONS(609),
    [sym_crossproduct] = ACTIONS(609),
    [sym_compose] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
  },
  [383] = {
    [aux_sym_parallel_replace_repeat1] = STATE(366),
    [anon_sym_LBRACK] = ACTIONS(611),
    [anon_sym_RBRACK] = ACTIONS(613),
    [sym_symbol] = ACTIONS(611),
    [sym_string] = ACTIONS(613),
    [sym_any] = ACTIONS(613),
    [sym_zero] = ACTIONS(613),
    [sym_boundary] = ACTIONS(613),
    [sym_symbol_group] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(613),
    [anon_sym_BQUOTE] = ACTIONS(613),
    [anon_sym_COMMA] = ACTIONS(611),
    [sym_colon] = ACTIONS(613),
    [sym_complement] = ACTIONS(613),
    [sym_term_complement] = ACTIONS(611),
    [sym_contains] = ACTIONS(613),
    [sym_plus] = ACTIONS(613),
    [sym_star] = ACTIONS(613),
    [sym_repeat] = ACTIONS(613),
    [sym_upper] = ACTIONS(613),
    [sym_lower] = ACTIONS(613),
    [sym_reverse] = ACTIONS(613),
    [sym_inverse] = ACTIONS(613),
    [sym_ignore] = ACTIONS(611),
    [sym_ignore_inside] = ACTIONS(613),
    [sym_union] = ACTIONS(611),
    [sym_intersect] = ACTIONS(613),
    [sym_subtract] = ACTIONS(611),
    [anon_sym_EQ_GT] = ACTIONS(613),
    [anon_sym_DASH_GT] = ACTIONS(611),
    [anon_sym_LT_DASH] = ACTIONS(613),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(613),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(613),
    [anon_sym_AT_DASH_GT] = ACTIONS(613),
    [anon_sym_DASH_GT_AT] = ACTIONS(613),
    [anon_sym_AT_GT] = ACTIONS(613),
    [anon_sym_GT_AT] = ACTIONS(613),
    [anon_sym_LBRACK_DOT] = ACTIONS(613),
    [anon_sym_DOT_RBRACK] = ACTIONS(613),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(613),
    [anon_sym_PIPE_PIPE] = ACTIONS(613),
    [anon_sym_SLASH_SLASH] = ACTIONS(613),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(613),
    [anon_sym_BSLASH_SLASH] = ACTIONS(613),
    [anon_sym_COMMA_COMMA] = ACTIONS(613),
    [sym_crossproduct] = ACTIONS(613),
    [sym_compose] = ACTIONS(613),
    [sym_comment] = ACTIONS(3),
  },
  [384] = {
    [aux_sym_context_list_repeat1] = STATE(382),
    [anon_sym_LBRACK] = ACTIONS(615),
    [anon_sym_RBRACK] = ACTIONS(617),
    [sym_symbol] = ACTIONS(615),
    [sym_string] = ACTIONS(617),
    [sym_any] = ACTIONS(617),
    [sym_zero] = ACTIONS(617),
    [sym_boundary] = ACTIONS(617),
    [sym_symbol_group] = ACTIONS(617),
    [anon_sym_LPAREN] = ACTIONS(615),
    [anon_sym_RPAREN] = ACTIONS(617),
    [anon_sym_BQUOTE] = ACTIONS(617),
    [anon_sym_COMMA] = ACTIONS(615),
    [sym_colon] = ACTIONS(617),
    [sym_complement] = ACTIONS(617),
    [sym_term_complement] = ACTIONS(615),
    [sym_contains] = ACTIONS(617),
    [sym_plus] = ACTIONS(617),
    [sym_star] = ACTIONS(617),
    [sym_repeat] = ACTIONS(617),
    [sym_upper] = ACTIONS(617),
    [sym_lower] = ACTIONS(617),
    [sym_reverse] = ACTIONS(617),
    [sym_inverse] = ACTIONS(617),
    [sym_ignore] = ACTIONS(615),
    [sym_ignore_inside] = ACTIONS(617),
    [sym_union] = ACTIONS(615),
    [sym_intersect] = ACTIONS(617),
    [sym_subtract] = ACTIONS(615),
    [anon_sym_EQ_GT] = ACTIONS(617),
    [anon_sym_DASH_GT] = ACTIONS(615),
    [anon_sym_LT_DASH] = ACTIONS(617),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(617),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(617),
    [anon_sym_AT_DASH_GT] = ACTIONS(617),
    [anon_sym_DASH_GT_AT] = ACTIONS(617),
    [anon_sym_AT_GT] = ACTIONS(617),
    [anon_sym_GT_AT] = ACTIONS(617),
    [anon_sym_LBRACK_DOT] = ACTIONS(617),
    [anon_sym_DOT_RBRACK] = ACTIONS(617),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(617),
    [anon_sym_PIPE_PIPE] = ACTIONS(617),
    [anon_sym_SLASH_SLASH] = ACTIONS(617),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(617),
    [anon_sym_BSLASH_SLASH] = ACTIONS(617),
    [anon_sym_COMMA_COMMA] = ACTIONS(617),
    [sym_crossproduct] = ACTIONS(617),
    [sym_compose] = ACTIONS(617),
    [sym_comment] = ACTIONS(3),
  },
  [385] = {
    [sym_condition_operators] = STATE(657),
    [aux_sym_parallel_replace_repeat1] = STATE(419),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(605),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [386] = {
    [sym_condition_operators] = STATE(646),
    [aux_sym_parallel_replace_repeat1] = STATE(391),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(619),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [387] = {
    [sym_expression] = STATE(333),
    [sym_optional] = STATE(640),
    [sym_substitute] = STATE(640),
    [sym_restrict] = STATE(640),
    [sym_simple_replace] = STATE(507),
    [sym_single_replace] = STATE(507),
    [sym_mark] = STATE(640),
    [sym_parallel_replace] = STATE(557),
    [sym_conditional_replace] = STATE(645),
    [sym_parallel_conditional_replace] = STATE(640),
    [anon_sym_LBRACK] = ACTIONS(119),
    [sym_symbol] = ACTIONS(119),
    [sym_string] = ACTIONS(121),
    [sym_any] = ACTIONS(121),
    [sym_zero] = ACTIONS(121),
    [sym_boundary] = ACTIONS(121),
    [sym_symbol_group] = ACTIONS(121),
    [anon_sym_LPAREN] = ACTIONS(119),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [sym_colon] = ACTIONS(121),
    [sym_complement] = ACTIONS(121),
    [sym_term_complement] = ACTIONS(121),
    [sym_contains] = ACTIONS(121),
    [sym_plus] = ACTIONS(121),
    [sym_star] = ACTIONS(121),
    [sym_repeat] = ACTIONS(121),
    [sym_upper] = ACTIONS(121),
    [sym_lower] = ACTIONS(121),
    [sym_reverse] = ACTIONS(121),
    [sym_inverse] = ACTIONS(121),
    [sym_ignore] = ACTIONS(121),
    [sym_ignore_inside] = ACTIONS(121),
    [sym_union] = ACTIONS(121),
    [sym_intersect] = ACTIONS(121),
    [sym_subtract] = ACTIONS(119),
    [anon_sym__] = ACTIONS(119),
    [anon_sym_EQ_GT] = ACTIONS(121),
    [anon_sym_DASH_GT] = ACTIONS(119),
    [anon_sym_LT_DASH] = ACTIONS(121),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(121),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(121),
    [anon_sym_AT_DASH_GT] = ACTIONS(121),
    [anon_sym_DASH_GT_AT] = ACTIONS(121),
    [anon_sym_AT_GT] = ACTIONS(121),
    [anon_sym_GT_AT] = ACTIONS(121),
    [anon_sym_LBRACK_DOT] = ACTIONS(121),
    [sym_crossproduct] = ACTIONS(121),
    [sym_compose] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
  },
  [388] = {
    [aux_sym_context_list_repeat1] = STATE(388),
    [anon_sym_LBRACK] = ACTIONS(621),
    [anon_sym_RBRACK] = ACTIONS(623),
    [sym_symbol] = ACTIONS(621),
    [sym_string] = ACTIONS(623),
    [sym_any] = ACTIONS(623),
    [sym_zero] = ACTIONS(623),
    [sym_boundary] = ACTIONS(623),
    [sym_symbol_group] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(621),
    [anon_sym_RPAREN] = ACTIONS(623),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_COMMA] = ACTIONS(625),
    [sym_colon] = ACTIONS(623),
    [sym_complement] = ACTIONS(623),
    [sym_term_complement] = ACTIONS(621),
    [sym_contains] = ACTIONS(623),
    [sym_plus] = ACTIONS(623),
    [sym_star] = ACTIONS(623),
    [sym_repeat] = ACTIONS(623),
    [sym_upper] = ACTIONS(623),
    [sym_lower] = ACTIONS(623),
    [sym_reverse] = ACTIONS(623),
    [sym_inverse] = ACTIONS(623),
    [sym_ignore] = ACTIONS(621),
    [sym_ignore_inside] = ACTIONS(623),
    [sym_union] = ACTIONS(621),
    [sym_intersect] = ACTIONS(623),
    [sym_subtract] = ACTIONS(621),
    [anon_sym_EQ_GT] = ACTIONS(623),
    [anon_sym_DASH_GT] = ACTIONS(621),
    [anon_sym_LT_DASH] = ACTIONS(623),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(623),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(623),
    [anon_sym_AT_DASH_GT] = ACTIONS(623),
    [anon_sym_DASH_GT_AT] = ACTIONS(623),
    [anon_sym_AT_GT] = ACTIONS(623),
    [anon_sym_GT_AT] = ACTIONS(623),
    [anon_sym_LBRACK_DOT] = ACTIONS(623),
    [anon_sym_DOT_RBRACK] = ACTIONS(623),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [anon_sym_SLASH_SLASH] = ACTIONS(623),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(623),
    [anon_sym_BSLASH_SLASH] = ACTIONS(623),
    [anon_sym_COMMA_COMMA] = ACTIONS(623),
    [sym_crossproduct] = ACTIONS(623),
    [sym_compose] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
  },
  [389] = {
    [sym_expression] = STATE(248),
    [sym_optional] = STATE(562),
    [sym_substitute] = STATE(562),
    [sym_restrict] = STATE(562),
    [sym_arrow] = STATE(730),
    [sym_simple_replace] = STATE(423),
    [sym_single_replace] = STATE(423),
    [sym_mark] = STATE(562),
    [sym_parallel_replace] = STATE(517),
    [sym_conditional_replace] = STATE(563),
    [sym_parallel_conditional_replace] = STATE(562),
    [anon_sym_LBRACK] = ACTIONS(347),
    [sym_symbol] = ACTIONS(349),
    [sym_string] = ACTIONS(351),
    [sym_any] = ACTIONS(351),
    [sym_zero] = ACTIONS(351),
    [sym_boundary] = ACTIONS(351),
    [sym_symbol_group] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(355),
    [sym_colon] = ACTIONS(395),
    [sym_complement] = ACTIONS(419),
    [sym_term_complement] = ACTIONS(419),
    [sym_contains] = ACTIONS(419),
    [sym_plus] = ACTIONS(345),
    [sym_star] = ACTIONS(345),
    [sym_repeat] = ACTIONS(345),
    [sym_upper] = ACTIONS(345),
    [sym_lower] = ACTIONS(345),
    [sym_reverse] = ACTIONS(345),
    [sym_inverse] = ACTIONS(345),
    [sym_ignore] = ACTIONS(421),
    [sym_ignore_inside] = ACTIONS(421),
    [sym_union] = ACTIONS(435),
    [sym_intersect] = ACTIONS(435),
    [sym_subtract] = ACTIONS(437),
    [anon_sym_EQ_GT] = ACTIONS(441),
    [anon_sym_DASH_GT] = ACTIONS(79),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(81),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(81),
    [anon_sym_AT_DASH_GT] = ACTIONS(81),
    [anon_sym_DASH_GT_AT] = ACTIONS(81),
    [anon_sym_AT_GT] = ACTIONS(81),
    [anon_sym_GT_AT] = ACTIONS(81),
    [anon_sym_LBRACK_DOT] = ACTIONS(223),
    [sym_crossproduct] = ACTIONS(477),
    [sym_compose] = ACTIONS(477),
    [sym_comment] = ACTIONS(3),
  },
  [390] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(379),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(595),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [391] = {
    [aux_sym_parallel_replace_repeat1] = STATE(438),
    [ts_builtin_sym_end] = ACTIONS(613),
    [sym_semicolon] = ACTIONS(611),
    [anon_sym_LBRACK] = ACTIONS(611),
    [sym_symbol] = ACTIONS(611),
    [sym_string] = ACTIONS(613),
    [sym_any] = ACTIONS(613),
    [sym_zero] = ACTIONS(613),
    [sym_boundary] = ACTIONS(613),
    [sym_symbol_group] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_BQUOTE] = ACTIONS(613),
    [anon_sym_COMMA] = ACTIONS(611),
    [sym_colon] = ACTIONS(613),
    [sym_complement] = ACTIONS(613),
    [sym_term_complement] = ACTIONS(611),
    [sym_contains] = ACTIONS(613),
    [sym_plus] = ACTIONS(613),
    [sym_star] = ACTIONS(613),
    [sym_repeat] = ACTIONS(613),
    [sym_upper] = ACTIONS(613),
    [sym_lower] = ACTIONS(613),
    [sym_reverse] = ACTIONS(613),
    [sym_inverse] = ACTIONS(613),
    [sym_ignore] = ACTIONS(611),
    [sym_ignore_inside] = ACTIONS(613),
    [sym_union] = ACTIONS(611),
    [sym_intersect] = ACTIONS(613),
    [sym_subtract] = ACTIONS(611),
    [anon_sym_EQ_GT] = ACTIONS(613),
    [anon_sym_DASH_GT] = ACTIONS(611),
    [anon_sym_LT_DASH] = ACTIONS(613),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(613),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(613),
    [anon_sym_AT_DASH_GT] = ACTIONS(613),
    [anon_sym_DASH_GT_AT] = ACTIONS(613),
    [anon_sym_AT_GT] = ACTIONS(613),
    [anon_sym_GT_AT] = ACTIONS(613),
    [anon_sym_LBRACK_DOT] = ACTIONS(613),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(613),
    [anon_sym_PIPE_PIPE] = ACTIONS(613),
    [anon_sym_SLASH_SLASH] = ACTIONS(613),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(613),
    [anon_sym_BSLASH_SLASH] = ACTIONS(613),
    [anon_sym_COMMA_COMMA] = ACTIONS(613),
    [sym_crossproduct] = ACTIONS(613),
    [sym_compose] = ACTIONS(613),
    [sym_comment] = ACTIONS(3),
  },
  [392] = {
    [anon_sym_LBRACK] = ACTIONS(621),
    [anon_sym_RBRACK] = ACTIONS(623),
    [sym_symbol] = ACTIONS(621),
    [sym_string] = ACTIONS(623),
    [sym_any] = ACTIONS(623),
    [sym_zero] = ACTIONS(623),
    [sym_boundary] = ACTIONS(623),
    [sym_symbol_group] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(621),
    [anon_sym_RPAREN] = ACTIONS(623),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_COMMA] = ACTIONS(621),
    [sym_colon] = ACTIONS(623),
    [sym_complement] = ACTIONS(623),
    [sym_term_complement] = ACTIONS(621),
    [sym_contains] = ACTIONS(623),
    [sym_plus] = ACTIONS(623),
    [sym_star] = ACTIONS(623),
    [sym_repeat] = ACTIONS(623),
    [sym_upper] = ACTIONS(623),
    [sym_lower] = ACTIONS(623),
    [sym_reverse] = ACTIONS(623),
    [sym_inverse] = ACTIONS(623),
    [sym_ignore] = ACTIONS(621),
    [sym_ignore_inside] = ACTIONS(623),
    [sym_union] = ACTIONS(621),
    [sym_intersect] = ACTIONS(623),
    [sym_subtract] = ACTIONS(621),
    [anon_sym_EQ_GT] = ACTIONS(623),
    [anon_sym_DASH_GT] = ACTIONS(621),
    [anon_sym_LT_DASH] = ACTIONS(623),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(623),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(623),
    [anon_sym_AT_DASH_GT] = ACTIONS(623),
    [anon_sym_DASH_GT_AT] = ACTIONS(623),
    [anon_sym_AT_GT] = ACTIONS(623),
    [anon_sym_GT_AT] = ACTIONS(623),
    [anon_sym_LBRACK_DOT] = ACTIONS(623),
    [anon_sym_DOT_RBRACK] = ACTIONS(623),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [anon_sym_SLASH_SLASH] = ACTIONS(623),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(623),
    [anon_sym_BSLASH_SLASH] = ACTIONS(623),
    [anon_sym_COMMA_COMMA] = ACTIONS(623),
    [sym_crossproduct] = ACTIONS(623),
    [sym_compose] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
  },
  [393] = {
    [anon_sym_LBRACK] = ACTIONS(628),
    [anon_sym_RBRACK] = ACTIONS(630),
    [sym_symbol] = ACTIONS(628),
    [sym_string] = ACTIONS(630),
    [sym_any] = ACTIONS(630),
    [sym_zero] = ACTIONS(630),
    [sym_boundary] = ACTIONS(630),
    [sym_symbol_group] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_RPAREN] = ACTIONS(630),
    [anon_sym_BQUOTE] = ACTIONS(630),
    [anon_sym_COMMA] = ACTIONS(628),
    [sym_colon] = ACTIONS(630),
    [sym_complement] = ACTIONS(630),
    [sym_term_complement] = ACTIONS(628),
    [sym_contains] = ACTIONS(630),
    [sym_plus] = ACTIONS(630),
    [sym_star] = ACTIONS(630),
    [sym_repeat] = ACTIONS(630),
    [sym_upper] = ACTIONS(630),
    [sym_lower] = ACTIONS(630),
    [sym_reverse] = ACTIONS(630),
    [sym_inverse] = ACTIONS(630),
    [sym_ignore] = ACTIONS(628),
    [sym_ignore_inside] = ACTIONS(630),
    [sym_union] = ACTIONS(628),
    [sym_intersect] = ACTIONS(630),
    [sym_subtract] = ACTIONS(628),
    [anon_sym_EQ_GT] = ACTIONS(630),
    [anon_sym_DASH_GT] = ACTIONS(628),
    [anon_sym_LT_DASH] = ACTIONS(630),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(630),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(630),
    [anon_sym_AT_DASH_GT] = ACTIONS(630),
    [anon_sym_DASH_GT_AT] = ACTIONS(630),
    [anon_sym_AT_GT] = ACTIONS(630),
    [anon_sym_GT_AT] = ACTIONS(630),
    [anon_sym_LBRACK_DOT] = ACTIONS(630),
    [anon_sym_DOT_RBRACK] = ACTIONS(630),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(630),
    [anon_sym_PIPE_PIPE] = ACTIONS(630),
    [anon_sym_SLASH_SLASH] = ACTIONS(630),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(630),
    [anon_sym_BSLASH_SLASH] = ACTIONS(630),
    [anon_sym_COMMA_COMMA] = ACTIONS(630),
    [sym_crossproduct] = ACTIONS(630),
    [sym_compose] = ACTIONS(630),
    [sym_comment] = ACTIONS(3),
  },
  [394] = {
    [anon_sym_LBRACK] = ACTIONS(73),
    [anon_sym_RBRACK] = ACTIONS(75),
    [sym_symbol] = ACTIONS(73),
    [sym_string] = ACTIONS(75),
    [sym_any] = ACTIONS(75),
    [sym_zero] = ACTIONS(75),
    [sym_boundary] = ACTIONS(75),
    [sym_symbol_group] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_RPAREN] = ACTIONS(75),
    [anon_sym_BQUOTE] = ACTIONS(75),
    [anon_sym_COMMA] = ACTIONS(73),
    [sym_colon] = ACTIONS(75),
    [sym_complement] = ACTIONS(75),
    [sym_term_complement] = ACTIONS(73),
    [sym_contains] = ACTIONS(75),
    [sym_plus] = ACTIONS(75),
    [sym_star] = ACTIONS(75),
    [sym_repeat] = ACTIONS(75),
    [sym_upper] = ACTIONS(75),
    [sym_lower] = ACTIONS(75),
    [sym_reverse] = ACTIONS(75),
    [sym_inverse] = ACTIONS(75),
    [sym_ignore] = ACTIONS(73),
    [sym_ignore_inside] = ACTIONS(75),
    [sym_union] = ACTIONS(73),
    [sym_intersect] = ACTIONS(75),
    [sym_subtract] = ACTIONS(73),
    [anon_sym_EQ_GT] = ACTIONS(75),
    [anon_sym_DASH_GT] = ACTIONS(73),
    [anon_sym_LT_DASH] = ACTIONS(75),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(75),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(75),
    [anon_sym_AT_DASH_GT] = ACTIONS(75),
    [anon_sym_DASH_GT_AT] = ACTIONS(75),
    [anon_sym_AT_GT] = ACTIONS(75),
    [anon_sym_GT_AT] = ACTIONS(75),
    [anon_sym_LBRACK_DOT] = ACTIONS(75),
    [anon_sym_DOT_RBRACK] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(75),
    [anon_sym_PIPE_PIPE] = ACTIONS(75),
    [anon_sym_SLASH_SLASH] = ACTIONS(75),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(75),
    [anon_sym_BSLASH_SLASH] = ACTIONS(75),
    [anon_sym_COMMA_COMMA] = ACTIONS(75),
    [sym_crossproduct] = ACTIONS(75),
    [sym_compose] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [395] = {
    [aux_sym_context_list_repeat1] = STATE(403),
    [anon_sym_LBRACK] = ACTIONS(615),
    [anon_sym_RBRACK] = ACTIONS(617),
    [sym_symbol] = ACTIONS(615),
    [sym_string] = ACTIONS(617),
    [sym_any] = ACTIONS(617),
    [sym_zero] = ACTIONS(617),
    [sym_boundary] = ACTIONS(617),
    [sym_symbol_group] = ACTIONS(617),
    [anon_sym_LPAREN] = ACTIONS(615),
    [anon_sym_RPAREN] = ACTIONS(617),
    [anon_sym_BQUOTE] = ACTIONS(617),
    [anon_sym_COMMA] = ACTIONS(617),
    [sym_colon] = ACTIONS(617),
    [sym_complement] = ACTIONS(617),
    [sym_term_complement] = ACTIONS(615),
    [sym_contains] = ACTIONS(617),
    [sym_plus] = ACTIONS(617),
    [sym_star] = ACTIONS(617),
    [sym_repeat] = ACTIONS(617),
    [sym_upper] = ACTIONS(617),
    [sym_lower] = ACTIONS(617),
    [sym_reverse] = ACTIONS(617),
    [sym_inverse] = ACTIONS(617),
    [sym_ignore] = ACTIONS(615),
    [sym_ignore_inside] = ACTIONS(617),
    [sym_union] = ACTIONS(615),
    [sym_intersect] = ACTIONS(617),
    [sym_subtract] = ACTIONS(615),
    [anon_sym_EQ_GT] = ACTIONS(617),
    [anon_sym_DASH_GT] = ACTIONS(615),
    [anon_sym_LT_DASH] = ACTIONS(617),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(617),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(617),
    [anon_sym_AT_DASH_GT] = ACTIONS(617),
    [anon_sym_DASH_GT_AT] = ACTIONS(617),
    [anon_sym_AT_GT] = ACTIONS(617),
    [anon_sym_GT_AT] = ACTIONS(617),
    [anon_sym_LBRACK_DOT] = ACTIONS(617),
    [anon_sym_DOT_RBRACK] = ACTIONS(617),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(617),
    [anon_sym_PIPE_PIPE] = ACTIONS(617),
    [anon_sym_SLASH_SLASH] = ACTIONS(617),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(617),
    [anon_sym_BSLASH_SLASH] = ACTIONS(617),
    [sym_crossproduct] = ACTIONS(617),
    [sym_compose] = ACTIONS(617),
    [sym_comment] = ACTIONS(3),
  },
  [396] = {
    [aux_sym_context_list_repeat1] = STATE(396),
    [anon_sym_LBRACK] = ACTIONS(621),
    [anon_sym_RBRACK] = ACTIONS(623),
    [sym_symbol] = ACTIONS(621),
    [sym_string] = ACTIONS(623),
    [sym_any] = ACTIONS(623),
    [sym_zero] = ACTIONS(623),
    [sym_boundary] = ACTIONS(623),
    [sym_symbol_group] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(621),
    [anon_sym_RPAREN] = ACTIONS(623),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_COMMA] = ACTIONS(632),
    [sym_colon] = ACTIONS(623),
    [sym_complement] = ACTIONS(623),
    [sym_term_complement] = ACTIONS(621),
    [sym_contains] = ACTIONS(623),
    [sym_plus] = ACTIONS(623),
    [sym_star] = ACTIONS(623),
    [sym_repeat] = ACTIONS(623),
    [sym_upper] = ACTIONS(623),
    [sym_lower] = ACTIONS(623),
    [sym_reverse] = ACTIONS(623),
    [sym_inverse] = ACTIONS(623),
    [sym_ignore] = ACTIONS(621),
    [sym_ignore_inside] = ACTIONS(623),
    [sym_union] = ACTIONS(621),
    [sym_intersect] = ACTIONS(623),
    [sym_subtract] = ACTIONS(621),
    [anon_sym_EQ_GT] = ACTIONS(623),
    [anon_sym_DASH_GT] = ACTIONS(621),
    [anon_sym_LT_DASH] = ACTIONS(623),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(623),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(623),
    [anon_sym_AT_DASH_GT] = ACTIONS(623),
    [anon_sym_DASH_GT_AT] = ACTIONS(623),
    [anon_sym_AT_GT] = ACTIONS(623),
    [anon_sym_GT_AT] = ACTIONS(623),
    [anon_sym_LBRACK_DOT] = ACTIONS(623),
    [anon_sym_DOT_RBRACK] = ACTIONS(623),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [anon_sym_SLASH_SLASH] = ACTIONS(623),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(623),
    [anon_sym_BSLASH_SLASH] = ACTIONS(623),
    [sym_crossproduct] = ACTIONS(623),
    [sym_compose] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
  },
  [397] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(425),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(635),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [398] = {
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_RBRACK] = ACTIONS(639),
    [sym_symbol] = ACTIONS(637),
    [sym_string] = ACTIONS(639),
    [sym_any] = ACTIONS(639),
    [sym_zero] = ACTIONS(639),
    [sym_boundary] = ACTIONS(639),
    [sym_symbol_group] = ACTIONS(639),
    [anon_sym_LPAREN] = ACTIONS(637),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_BQUOTE] = ACTIONS(639),
    [anon_sym_COMMA] = ACTIONS(637),
    [sym_colon] = ACTIONS(639),
    [sym_complement] = ACTIONS(639),
    [sym_term_complement] = ACTIONS(637),
    [sym_contains] = ACTIONS(639),
    [sym_plus] = ACTIONS(639),
    [sym_star] = ACTIONS(639),
    [sym_repeat] = ACTIONS(639),
    [sym_upper] = ACTIONS(639),
    [sym_lower] = ACTIONS(639),
    [sym_reverse] = ACTIONS(639),
    [sym_inverse] = ACTIONS(639),
    [sym_ignore] = ACTIONS(637),
    [sym_ignore_inside] = ACTIONS(639),
    [sym_union] = ACTIONS(637),
    [sym_intersect] = ACTIONS(639),
    [sym_subtract] = ACTIONS(637),
    [anon_sym_EQ_GT] = ACTIONS(639),
    [anon_sym_DASH_GT] = ACTIONS(637),
    [anon_sym_LT_DASH] = ACTIONS(639),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(639),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(639),
    [anon_sym_AT_DASH_GT] = ACTIONS(639),
    [anon_sym_DASH_GT_AT] = ACTIONS(639),
    [anon_sym_AT_GT] = ACTIONS(639),
    [anon_sym_GT_AT] = ACTIONS(639),
    [anon_sym_LBRACK_DOT] = ACTIONS(639),
    [anon_sym_DOT_RBRACK] = ACTIONS(639),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(639),
    [anon_sym_PIPE_PIPE] = ACTIONS(639),
    [anon_sym_SLASH_SLASH] = ACTIONS(639),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(639),
    [anon_sym_BSLASH_SLASH] = ACTIONS(639),
    [anon_sym_COMMA_COMMA] = ACTIONS(639),
    [sym_crossproduct] = ACTIONS(639),
    [sym_compose] = ACTIONS(639),
    [sym_comment] = ACTIONS(3),
  },
  [399] = {
    [aux_sym_parallel_replace_repeat1] = STATE(399),
    [anon_sym_LBRACK] = ACTIONS(471),
    [anon_sym_RBRACK] = ACTIONS(473),
    [sym_symbol] = ACTIONS(471),
    [sym_string] = ACTIONS(473),
    [sym_any] = ACTIONS(473),
    [sym_zero] = ACTIONS(473),
    [sym_boundary] = ACTIONS(473),
    [sym_symbol_group] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_RPAREN] = ACTIONS(473),
    [anon_sym_BQUOTE] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(641),
    [sym_colon] = ACTIONS(473),
    [sym_complement] = ACTIONS(473),
    [sym_term_complement] = ACTIONS(471),
    [sym_contains] = ACTIONS(473),
    [sym_plus] = ACTIONS(473),
    [sym_star] = ACTIONS(473),
    [sym_repeat] = ACTIONS(473),
    [sym_upper] = ACTIONS(473),
    [sym_lower] = ACTIONS(473),
    [sym_reverse] = ACTIONS(473),
    [sym_inverse] = ACTIONS(473),
    [sym_ignore] = ACTIONS(471),
    [sym_ignore_inside] = ACTIONS(473),
    [sym_union] = ACTIONS(471),
    [sym_intersect] = ACTIONS(473),
    [sym_subtract] = ACTIONS(471),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_DASH_GT] = ACTIONS(471),
    [anon_sym_LT_DASH] = ACTIONS(473),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(473),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(473),
    [anon_sym_AT_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_AT] = ACTIONS(473),
    [anon_sym_AT_GT] = ACTIONS(473),
    [anon_sym_GT_AT] = ACTIONS(473),
    [anon_sym_LBRACK_DOT] = ACTIONS(473),
    [anon_sym_DOT_RBRACK] = ACTIONS(473),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(473),
    [anon_sym_BSLASH_SLASH] = ACTIONS(473),
    [sym_crossproduct] = ACTIONS(473),
    [sym_compose] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [400] = {
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [sym_symbol] = ACTIONS(644),
    [sym_string] = ACTIONS(646),
    [sym_any] = ACTIONS(646),
    [sym_zero] = ACTIONS(646),
    [sym_boundary] = ACTIONS(646),
    [sym_symbol_group] = ACTIONS(646),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_RPAREN] = ACTIONS(646),
    [anon_sym_BQUOTE] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(644),
    [sym_colon] = ACTIONS(646),
    [sym_complement] = ACTIONS(646),
    [sym_term_complement] = ACTIONS(644),
    [sym_contains] = ACTIONS(646),
    [sym_plus] = ACTIONS(646),
    [sym_star] = ACTIONS(646),
    [sym_repeat] = ACTIONS(646),
    [sym_upper] = ACTIONS(646),
    [sym_lower] = ACTIONS(646),
    [sym_reverse] = ACTIONS(646),
    [sym_inverse] = ACTIONS(646),
    [sym_ignore] = ACTIONS(644),
    [sym_ignore_inside] = ACTIONS(646),
    [sym_union] = ACTIONS(644),
    [sym_intersect] = ACTIONS(646),
    [sym_subtract] = ACTIONS(644),
    [anon_sym_EQ_GT] = ACTIONS(646),
    [anon_sym_DASH_GT] = ACTIONS(644),
    [anon_sym_LT_DASH] = ACTIONS(646),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(646),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(646),
    [anon_sym_AT_DASH_GT] = ACTIONS(646),
    [anon_sym_DASH_GT_AT] = ACTIONS(646),
    [anon_sym_AT_GT] = ACTIONS(646),
    [anon_sym_GT_AT] = ACTIONS(646),
    [anon_sym_LBRACK_DOT] = ACTIONS(646),
    [anon_sym_DOT_RBRACK] = ACTIONS(646),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(646),
    [anon_sym_PIPE_PIPE] = ACTIONS(646),
    [anon_sym_SLASH_SLASH] = ACTIONS(646),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(646),
    [anon_sym_BSLASH_SLASH] = ACTIONS(646),
    [anon_sym_COMMA_COMMA] = ACTIONS(646),
    [sym_crossproduct] = ACTIONS(646),
    [sym_compose] = ACTIONS(646),
    [sym_comment] = ACTIONS(3),
  },
  [401] = {
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(53),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [402] = {
    [sym_condition_operators] = STATE(657),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [403] = {
    [aux_sym_context_list_repeat1] = STATE(396),
    [anon_sym_LBRACK] = ACTIONS(607),
    [anon_sym_RBRACK] = ACTIONS(609),
    [sym_symbol] = ACTIONS(607),
    [sym_string] = ACTIONS(609),
    [sym_any] = ACTIONS(609),
    [sym_zero] = ACTIONS(609),
    [sym_boundary] = ACTIONS(609),
    [sym_symbol_group] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(607),
    [anon_sym_RPAREN] = ACTIONS(609),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(609),
    [sym_colon] = ACTIONS(609),
    [sym_complement] = ACTIONS(609),
    [sym_term_complement] = ACTIONS(607),
    [sym_contains] = ACTIONS(609),
    [sym_plus] = ACTIONS(609),
    [sym_star] = ACTIONS(609),
    [sym_repeat] = ACTIONS(609),
    [sym_upper] = ACTIONS(609),
    [sym_lower] = ACTIONS(609),
    [sym_reverse] = ACTIONS(609),
    [sym_inverse] = ACTIONS(609),
    [sym_ignore] = ACTIONS(607),
    [sym_ignore_inside] = ACTIONS(609),
    [sym_union] = ACTIONS(607),
    [sym_intersect] = ACTIONS(609),
    [sym_subtract] = ACTIONS(607),
    [anon_sym_EQ_GT] = ACTIONS(609),
    [anon_sym_DASH_GT] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(609),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(609),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(609),
    [anon_sym_AT_DASH_GT] = ACTIONS(609),
    [anon_sym_DASH_GT_AT] = ACTIONS(609),
    [anon_sym_AT_GT] = ACTIONS(609),
    [anon_sym_GT_AT] = ACTIONS(609),
    [anon_sym_LBRACK_DOT] = ACTIONS(609),
    [anon_sym_DOT_RBRACK] = ACTIONS(609),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(609),
    [anon_sym_PIPE_PIPE] = ACTIONS(609),
    [anon_sym_SLASH_SLASH] = ACTIONS(609),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(609),
    [anon_sym_BSLASH_SLASH] = ACTIONS(609),
    [sym_crossproduct] = ACTIONS(609),
    [sym_compose] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
  },
  [404] = {
    [sym_condition_operators] = STATE(657),
    [aux_sym_parallel_replace_repeat1] = STATE(453),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(648),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [405] = {
    [aux_sym_context_list_repeat1] = STATE(405),
    [ts_builtin_sym_end] = ACTIONS(623),
    [sym_semicolon] = ACTIONS(621),
    [anon_sym_LBRACK] = ACTIONS(621),
    [sym_symbol] = ACTIONS(621),
    [sym_string] = ACTIONS(623),
    [sym_any] = ACTIONS(623),
    [sym_zero] = ACTIONS(623),
    [sym_boundary] = ACTIONS(623),
    [sym_symbol_group] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(621),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_COMMA] = ACTIONS(650),
    [sym_colon] = ACTIONS(623),
    [sym_complement] = ACTIONS(623),
    [sym_term_complement] = ACTIONS(621),
    [sym_contains] = ACTIONS(623),
    [sym_plus] = ACTIONS(623),
    [sym_star] = ACTIONS(623),
    [sym_repeat] = ACTIONS(623),
    [sym_upper] = ACTIONS(623),
    [sym_lower] = ACTIONS(623),
    [sym_reverse] = ACTIONS(623),
    [sym_inverse] = ACTIONS(623),
    [sym_ignore] = ACTIONS(621),
    [sym_ignore_inside] = ACTIONS(623),
    [sym_union] = ACTIONS(621),
    [sym_intersect] = ACTIONS(623),
    [sym_subtract] = ACTIONS(621),
    [anon_sym_EQ_GT] = ACTIONS(623),
    [anon_sym_DASH_GT] = ACTIONS(621),
    [anon_sym_LT_DASH] = ACTIONS(623),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(623),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(623),
    [anon_sym_AT_DASH_GT] = ACTIONS(623),
    [anon_sym_DASH_GT_AT] = ACTIONS(623),
    [anon_sym_AT_GT] = ACTIONS(623),
    [anon_sym_GT_AT] = ACTIONS(623),
    [anon_sym_LBRACK_DOT] = ACTIONS(623),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [anon_sym_SLASH_SLASH] = ACTIONS(623),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(623),
    [anon_sym_BSLASH_SLASH] = ACTIONS(623),
    [anon_sym_COMMA_COMMA] = ACTIONS(623),
    [sym_crossproduct] = ACTIONS(623),
    [sym_compose] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
  },
  [406] = {
    [sym_condition_operators] = STATE(678),
    [aux_sym_parallel_replace_repeat1] = STATE(443),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(653),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [407] = {
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(657),
    [sym_symbol] = ACTIONS(655),
    [sym_string] = ACTIONS(657),
    [sym_any] = ACTIONS(657),
    [sym_zero] = ACTIONS(657),
    [sym_boundary] = ACTIONS(657),
    [sym_symbol_group] = ACTIONS(657),
    [anon_sym_LPAREN] = ACTIONS(655),
    [anon_sym_RPAREN] = ACTIONS(657),
    [anon_sym_BQUOTE] = ACTIONS(657),
    [anon_sym_COMMA] = ACTIONS(655),
    [sym_colon] = ACTIONS(657),
    [sym_complement] = ACTIONS(657),
    [sym_term_complement] = ACTIONS(655),
    [sym_contains] = ACTIONS(657),
    [sym_plus] = ACTIONS(657),
    [sym_star] = ACTIONS(657),
    [sym_repeat] = ACTIONS(657),
    [sym_upper] = ACTIONS(657),
    [sym_lower] = ACTIONS(657),
    [sym_reverse] = ACTIONS(657),
    [sym_inverse] = ACTIONS(657),
    [sym_ignore] = ACTIONS(655),
    [sym_ignore_inside] = ACTIONS(657),
    [sym_union] = ACTIONS(655),
    [sym_intersect] = ACTIONS(657),
    [sym_subtract] = ACTIONS(655),
    [anon_sym_EQ_GT] = ACTIONS(657),
    [anon_sym_DASH_GT] = ACTIONS(655),
    [anon_sym_LT_DASH] = ACTIONS(657),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(657),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(657),
    [anon_sym_AT_DASH_GT] = ACTIONS(657),
    [anon_sym_DASH_GT_AT] = ACTIONS(657),
    [anon_sym_AT_GT] = ACTIONS(657),
    [anon_sym_GT_AT] = ACTIONS(657),
    [anon_sym_LBRACK_DOT] = ACTIONS(657),
    [anon_sym_DOT_RBRACK] = ACTIONS(657),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(657),
    [anon_sym_PIPE_PIPE] = ACTIONS(657),
    [anon_sym_SLASH_SLASH] = ACTIONS(657),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(657),
    [anon_sym_BSLASH_SLASH] = ACTIONS(657),
    [anon_sym_COMMA_COMMA] = ACTIONS(657),
    [sym_crossproduct] = ACTIONS(657),
    [sym_compose] = ACTIONS(657),
    [sym_comment] = ACTIONS(3),
  },
  [408] = {
    [anon_sym_LBRACK] = ACTIONS(659),
    [anon_sym_RBRACK] = ACTIONS(661),
    [sym_symbol] = ACTIONS(659),
    [sym_string] = ACTIONS(661),
    [sym_any] = ACTIONS(661),
    [sym_zero] = ACTIONS(661),
    [sym_boundary] = ACTIONS(661),
    [sym_symbol_group] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(659),
    [anon_sym_RPAREN] = ACTIONS(661),
    [anon_sym_BQUOTE] = ACTIONS(661),
    [anon_sym_COMMA] = ACTIONS(659),
    [sym_colon] = ACTIONS(661),
    [sym_complement] = ACTIONS(661),
    [sym_term_complement] = ACTIONS(659),
    [sym_contains] = ACTIONS(661),
    [sym_plus] = ACTIONS(661),
    [sym_star] = ACTIONS(661),
    [sym_repeat] = ACTIONS(661),
    [sym_upper] = ACTIONS(661),
    [sym_lower] = ACTIONS(661),
    [sym_reverse] = ACTIONS(661),
    [sym_inverse] = ACTIONS(661),
    [sym_ignore] = ACTIONS(659),
    [sym_ignore_inside] = ACTIONS(661),
    [sym_union] = ACTIONS(659),
    [sym_intersect] = ACTIONS(661),
    [sym_subtract] = ACTIONS(659),
    [anon_sym_EQ_GT] = ACTIONS(661),
    [anon_sym_DASH_GT] = ACTIONS(659),
    [anon_sym_LT_DASH] = ACTIONS(661),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(661),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(661),
    [anon_sym_AT_DASH_GT] = ACTIONS(661),
    [anon_sym_DASH_GT_AT] = ACTIONS(661),
    [anon_sym_AT_GT] = ACTIONS(661),
    [anon_sym_GT_AT] = ACTIONS(661),
    [anon_sym_LBRACK_DOT] = ACTIONS(661),
    [anon_sym_DOT_RBRACK] = ACTIONS(661),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(661),
    [anon_sym_PIPE_PIPE] = ACTIONS(661),
    [anon_sym_SLASH_SLASH] = ACTIONS(661),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(661),
    [anon_sym_BSLASH_SLASH] = ACTIONS(661),
    [anon_sym_COMMA_COMMA] = ACTIONS(661),
    [sym_crossproduct] = ACTIONS(661),
    [sym_compose] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
  },
  [409] = {
    [aux_sym_context_list_repeat1] = STATE(427),
    [anon_sym_LBRACK] = ACTIONS(615),
    [anon_sym_RBRACK] = ACTIONS(617),
    [sym_symbol] = ACTIONS(615),
    [sym_string] = ACTIONS(617),
    [sym_any] = ACTIONS(617),
    [sym_zero] = ACTIONS(617),
    [sym_boundary] = ACTIONS(617),
    [sym_symbol_group] = ACTIONS(617),
    [anon_sym_LPAREN] = ACTIONS(615),
    [anon_sym_RPAREN] = ACTIONS(617),
    [anon_sym_BQUOTE] = ACTIONS(617),
    [anon_sym_COMMA] = ACTIONS(615),
    [sym_colon] = ACTIONS(617),
    [sym_complement] = ACTIONS(617),
    [sym_term_complement] = ACTIONS(615),
    [sym_contains] = ACTIONS(617),
    [sym_plus] = ACTIONS(617),
    [sym_star] = ACTIONS(617),
    [sym_repeat] = ACTIONS(617),
    [sym_upper] = ACTIONS(617),
    [sym_lower] = ACTIONS(617),
    [sym_reverse] = ACTIONS(617),
    [sym_inverse] = ACTIONS(617),
    [sym_ignore] = ACTIONS(615),
    [sym_ignore_inside] = ACTIONS(617),
    [sym_union] = ACTIONS(615),
    [sym_intersect] = ACTIONS(617),
    [sym_subtract] = ACTIONS(615),
    [anon_sym_EQ_GT] = ACTIONS(617),
    [anon_sym_DASH_GT] = ACTIONS(615),
    [anon_sym_LT_DASH] = ACTIONS(617),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(617),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(617),
    [anon_sym_AT_DASH_GT] = ACTIONS(617),
    [anon_sym_DASH_GT_AT] = ACTIONS(617),
    [anon_sym_AT_GT] = ACTIONS(617),
    [anon_sym_GT_AT] = ACTIONS(617),
    [anon_sym_LBRACK_DOT] = ACTIONS(617),
    [anon_sym_DOT_RBRACK] = ACTIONS(617),
    [anon_sym_PIPE_PIPE] = ACTIONS(617),
    [anon_sym_SLASH_SLASH] = ACTIONS(617),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(617),
    [anon_sym_BSLASH_SLASH] = ACTIONS(617),
    [anon_sym_COMMA_COMMA] = ACTIONS(617),
    [sym_crossproduct] = ACTIONS(617),
    [sym_compose] = ACTIONS(617),
    [sym_comment] = ACTIONS(3),
  },
  [410] = {
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_RBRACK] = ACTIONS(53),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(53),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(53),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_RBRACK] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [411] = {
    [aux_sym_context_list_repeat1] = STATE(421),
    [ts_builtin_sym_end] = ACTIONS(617),
    [sym_semicolon] = ACTIONS(615),
    [anon_sym_LBRACK] = ACTIONS(615),
    [sym_symbol] = ACTIONS(615),
    [sym_string] = ACTIONS(617),
    [sym_any] = ACTIONS(617),
    [sym_zero] = ACTIONS(617),
    [sym_boundary] = ACTIONS(617),
    [sym_symbol_group] = ACTIONS(617),
    [anon_sym_LPAREN] = ACTIONS(615),
    [anon_sym_BQUOTE] = ACTIONS(617),
    [anon_sym_COMMA] = ACTIONS(615),
    [sym_colon] = ACTIONS(617),
    [sym_complement] = ACTIONS(617),
    [sym_term_complement] = ACTIONS(615),
    [sym_contains] = ACTIONS(617),
    [sym_plus] = ACTIONS(617),
    [sym_star] = ACTIONS(617),
    [sym_repeat] = ACTIONS(617),
    [sym_upper] = ACTIONS(617),
    [sym_lower] = ACTIONS(617),
    [sym_reverse] = ACTIONS(617),
    [sym_inverse] = ACTIONS(617),
    [sym_ignore] = ACTIONS(615),
    [sym_ignore_inside] = ACTIONS(617),
    [sym_union] = ACTIONS(615),
    [sym_intersect] = ACTIONS(617),
    [sym_subtract] = ACTIONS(615),
    [anon_sym_EQ_GT] = ACTIONS(617),
    [anon_sym_DASH_GT] = ACTIONS(615),
    [anon_sym_LT_DASH] = ACTIONS(617),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(617),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(617),
    [anon_sym_AT_DASH_GT] = ACTIONS(617),
    [anon_sym_DASH_GT_AT] = ACTIONS(617),
    [anon_sym_AT_GT] = ACTIONS(617),
    [anon_sym_GT_AT] = ACTIONS(617),
    [anon_sym_LBRACK_DOT] = ACTIONS(617),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(617),
    [anon_sym_PIPE_PIPE] = ACTIONS(617),
    [anon_sym_SLASH_SLASH] = ACTIONS(617),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(617),
    [anon_sym_BSLASH_SLASH] = ACTIONS(617),
    [anon_sym_COMMA_COMMA] = ACTIONS(617),
    [sym_crossproduct] = ACTIONS(617),
    [sym_compose] = ACTIONS(617),
    [sym_comment] = ACTIONS(3),
  },
  [412] = {
    [sym_condition_operators] = STATE(646),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [413] = {
    [aux_sym_parallel_replace_repeat1] = STATE(399),
    [anon_sym_LBRACK] = ACTIONS(611),
    [anon_sym_RBRACK] = ACTIONS(613),
    [sym_symbol] = ACTIONS(611),
    [sym_string] = ACTIONS(613),
    [sym_any] = ACTIONS(613),
    [sym_zero] = ACTIONS(613),
    [sym_boundary] = ACTIONS(613),
    [sym_symbol_group] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(613),
    [anon_sym_BQUOTE] = ACTIONS(613),
    [anon_sym_COMMA] = ACTIONS(613),
    [sym_colon] = ACTIONS(613),
    [sym_complement] = ACTIONS(613),
    [sym_term_complement] = ACTIONS(611),
    [sym_contains] = ACTIONS(613),
    [sym_plus] = ACTIONS(613),
    [sym_star] = ACTIONS(613),
    [sym_repeat] = ACTIONS(613),
    [sym_upper] = ACTIONS(613),
    [sym_lower] = ACTIONS(613),
    [sym_reverse] = ACTIONS(613),
    [sym_inverse] = ACTIONS(613),
    [sym_ignore] = ACTIONS(611),
    [sym_ignore_inside] = ACTIONS(613),
    [sym_union] = ACTIONS(611),
    [sym_intersect] = ACTIONS(613),
    [sym_subtract] = ACTIONS(611),
    [anon_sym_EQ_GT] = ACTIONS(613),
    [anon_sym_DASH_GT] = ACTIONS(611),
    [anon_sym_LT_DASH] = ACTIONS(613),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(613),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(613),
    [anon_sym_AT_DASH_GT] = ACTIONS(613),
    [anon_sym_DASH_GT_AT] = ACTIONS(613),
    [anon_sym_AT_GT] = ACTIONS(613),
    [anon_sym_GT_AT] = ACTIONS(613),
    [anon_sym_LBRACK_DOT] = ACTIONS(613),
    [anon_sym_DOT_RBRACK] = ACTIONS(613),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(613),
    [anon_sym_PIPE_PIPE] = ACTIONS(613),
    [anon_sym_SLASH_SLASH] = ACTIONS(613),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(613),
    [anon_sym_BSLASH_SLASH] = ACTIONS(613),
    [sym_crossproduct] = ACTIONS(613),
    [sym_compose] = ACTIONS(613),
    [sym_comment] = ACTIONS(3),
  },
  [414] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(414),
    [anon_sym_LBRACK] = ACTIONS(587),
    [anon_sym_RBRACK] = ACTIONS(589),
    [sym_symbol] = ACTIONS(587),
    [sym_string] = ACTIONS(589),
    [sym_any] = ACTIONS(589),
    [sym_zero] = ACTIONS(589),
    [sym_boundary] = ACTIONS(589),
    [sym_symbol_group] = ACTIONS(589),
    [anon_sym_LPAREN] = ACTIONS(587),
    [anon_sym_RPAREN] = ACTIONS(589),
    [anon_sym_BQUOTE] = ACTIONS(589),
    [anon_sym_COMMA] = ACTIONS(587),
    [sym_colon] = ACTIONS(589),
    [sym_complement] = ACTIONS(589),
    [sym_term_complement] = ACTIONS(587),
    [sym_contains] = ACTIONS(589),
    [sym_plus] = ACTIONS(589),
    [sym_star] = ACTIONS(589),
    [sym_repeat] = ACTIONS(589),
    [sym_upper] = ACTIONS(589),
    [sym_lower] = ACTIONS(589),
    [sym_reverse] = ACTIONS(589),
    [sym_inverse] = ACTIONS(589),
    [sym_ignore] = ACTIONS(587),
    [sym_ignore_inside] = ACTIONS(589),
    [sym_union] = ACTIONS(587),
    [sym_intersect] = ACTIONS(589),
    [sym_subtract] = ACTIONS(587),
    [anon_sym_EQ_GT] = ACTIONS(589),
    [anon_sym_DASH_GT] = ACTIONS(587),
    [anon_sym_LT_DASH] = ACTIONS(589),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(589),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(589),
    [anon_sym_AT_DASH_GT] = ACTIONS(589),
    [anon_sym_DASH_GT_AT] = ACTIONS(589),
    [anon_sym_AT_GT] = ACTIONS(589),
    [anon_sym_GT_AT] = ACTIONS(589),
    [anon_sym_LBRACK_DOT] = ACTIONS(589),
    [anon_sym_DOT_RBRACK] = ACTIONS(589),
    [anon_sym_PIPE_PIPE] = ACTIONS(589),
    [anon_sym_SLASH_SLASH] = ACTIONS(589),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(589),
    [anon_sym_BSLASH_SLASH] = ACTIONS(589),
    [anon_sym_COMMA_COMMA] = ACTIONS(663),
    [sym_crossproduct] = ACTIONS(589),
    [sym_compose] = ACTIONS(589),
    [sym_comment] = ACTIONS(3),
  },
  [415] = {
    [sym_condition_operators] = STATE(651),
    [aux_sym_parallel_replace_repeat1] = STATE(453),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(648),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [416] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(414),
    [anon_sym_LBRACK] = ACTIONS(591),
    [anon_sym_RBRACK] = ACTIONS(593),
    [sym_symbol] = ACTIONS(591),
    [sym_string] = ACTIONS(593),
    [sym_any] = ACTIONS(593),
    [sym_zero] = ACTIONS(593),
    [sym_boundary] = ACTIONS(593),
    [sym_symbol_group] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_RPAREN] = ACTIONS(593),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(591),
    [sym_colon] = ACTIONS(593),
    [sym_complement] = ACTIONS(593),
    [sym_term_complement] = ACTIONS(591),
    [sym_contains] = ACTIONS(593),
    [sym_plus] = ACTIONS(593),
    [sym_star] = ACTIONS(593),
    [sym_repeat] = ACTIONS(593),
    [sym_upper] = ACTIONS(593),
    [sym_lower] = ACTIONS(593),
    [sym_reverse] = ACTIONS(593),
    [sym_inverse] = ACTIONS(593),
    [sym_ignore] = ACTIONS(591),
    [sym_ignore_inside] = ACTIONS(593),
    [sym_union] = ACTIONS(591),
    [sym_intersect] = ACTIONS(593),
    [sym_subtract] = ACTIONS(591),
    [anon_sym_EQ_GT] = ACTIONS(593),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_LT_DASH] = ACTIONS(593),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(593),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(593),
    [anon_sym_AT_DASH_GT] = ACTIONS(593),
    [anon_sym_DASH_GT_AT] = ACTIONS(593),
    [anon_sym_AT_GT] = ACTIONS(593),
    [anon_sym_GT_AT] = ACTIONS(593),
    [anon_sym_LBRACK_DOT] = ACTIONS(593),
    [anon_sym_DOT_RBRACK] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(593),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(593),
    [anon_sym_BSLASH_SLASH] = ACTIONS(593),
    [anon_sym_COMMA_COMMA] = ACTIONS(666),
    [sym_crossproduct] = ACTIONS(593),
    [sym_compose] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [417] = {
    [aux_sym_parallel_replace_repeat1] = STATE(417),
    [anon_sym_LBRACK] = ACTIONS(471),
    [anon_sym_RBRACK] = ACTIONS(473),
    [sym_symbol] = ACTIONS(471),
    [sym_string] = ACTIONS(473),
    [sym_any] = ACTIONS(473),
    [sym_zero] = ACTIONS(473),
    [sym_boundary] = ACTIONS(473),
    [sym_symbol_group] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_RPAREN] = ACTIONS(473),
    [anon_sym_BQUOTE] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(668),
    [sym_colon] = ACTIONS(473),
    [sym_complement] = ACTIONS(473),
    [sym_term_complement] = ACTIONS(471),
    [sym_contains] = ACTIONS(473),
    [sym_plus] = ACTIONS(473),
    [sym_star] = ACTIONS(473),
    [sym_repeat] = ACTIONS(473),
    [sym_upper] = ACTIONS(473),
    [sym_lower] = ACTIONS(473),
    [sym_reverse] = ACTIONS(473),
    [sym_inverse] = ACTIONS(473),
    [sym_ignore] = ACTIONS(471),
    [sym_ignore_inside] = ACTIONS(473),
    [sym_union] = ACTIONS(471),
    [sym_intersect] = ACTIONS(473),
    [sym_subtract] = ACTIONS(471),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_DASH_GT] = ACTIONS(471),
    [anon_sym_LT_DASH] = ACTIONS(473),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(473),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(473),
    [anon_sym_AT_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_AT] = ACTIONS(473),
    [anon_sym_AT_GT] = ACTIONS(473),
    [anon_sym_GT_AT] = ACTIONS(473),
    [anon_sym_LBRACK_DOT] = ACTIONS(473),
    [anon_sym_DOT_RBRACK] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(473),
    [anon_sym_BSLASH_SLASH] = ACTIONS(473),
    [anon_sym_COMMA_COMMA] = ACTIONS(473),
    [sym_crossproduct] = ACTIONS(473),
    [sym_compose] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [418] = {
    [sym_condition_operators] = STATE(651),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [419] = {
    [aux_sym_parallel_replace_repeat1] = STATE(417),
    [anon_sym_LBRACK] = ACTIONS(611),
    [anon_sym_RBRACK] = ACTIONS(613),
    [sym_symbol] = ACTIONS(611),
    [sym_string] = ACTIONS(613),
    [sym_any] = ACTIONS(613),
    [sym_zero] = ACTIONS(613),
    [sym_boundary] = ACTIONS(613),
    [sym_symbol_group] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(613),
    [anon_sym_BQUOTE] = ACTIONS(613),
    [anon_sym_COMMA] = ACTIONS(611),
    [sym_colon] = ACTIONS(613),
    [sym_complement] = ACTIONS(613),
    [sym_term_complement] = ACTIONS(611),
    [sym_contains] = ACTIONS(613),
    [sym_plus] = ACTIONS(613),
    [sym_star] = ACTIONS(613),
    [sym_repeat] = ACTIONS(613),
    [sym_upper] = ACTIONS(613),
    [sym_lower] = ACTIONS(613),
    [sym_reverse] = ACTIONS(613),
    [sym_inverse] = ACTIONS(613),
    [sym_ignore] = ACTIONS(611),
    [sym_ignore_inside] = ACTIONS(613),
    [sym_union] = ACTIONS(611),
    [sym_intersect] = ACTIONS(613),
    [sym_subtract] = ACTIONS(611),
    [anon_sym_EQ_GT] = ACTIONS(613),
    [anon_sym_DASH_GT] = ACTIONS(611),
    [anon_sym_LT_DASH] = ACTIONS(613),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(613),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(613),
    [anon_sym_AT_DASH_GT] = ACTIONS(613),
    [anon_sym_DASH_GT_AT] = ACTIONS(613),
    [anon_sym_AT_GT] = ACTIONS(613),
    [anon_sym_GT_AT] = ACTIONS(613),
    [anon_sym_LBRACK_DOT] = ACTIONS(613),
    [anon_sym_DOT_RBRACK] = ACTIONS(613),
    [anon_sym_PIPE_PIPE] = ACTIONS(613),
    [anon_sym_SLASH_SLASH] = ACTIONS(613),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(613),
    [anon_sym_BSLASH_SLASH] = ACTIONS(613),
    [anon_sym_COMMA_COMMA] = ACTIONS(613),
    [sym_crossproduct] = ACTIONS(613),
    [sym_compose] = ACTIONS(613),
    [sym_comment] = ACTIONS(3),
  },
  [420] = {
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [421] = {
    [aux_sym_context_list_repeat1] = STATE(405),
    [ts_builtin_sym_end] = ACTIONS(609),
    [sym_semicolon] = ACTIONS(607),
    [anon_sym_LBRACK] = ACTIONS(607),
    [sym_symbol] = ACTIONS(607),
    [sym_string] = ACTIONS(609),
    [sym_any] = ACTIONS(609),
    [sym_zero] = ACTIONS(609),
    [sym_boundary] = ACTIONS(609),
    [sym_symbol_group] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(607),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(607),
    [sym_colon] = ACTIONS(609),
    [sym_complement] = ACTIONS(609),
    [sym_term_complement] = ACTIONS(607),
    [sym_contains] = ACTIONS(609),
    [sym_plus] = ACTIONS(609),
    [sym_star] = ACTIONS(609),
    [sym_repeat] = ACTIONS(609),
    [sym_upper] = ACTIONS(609),
    [sym_lower] = ACTIONS(609),
    [sym_reverse] = ACTIONS(609),
    [sym_inverse] = ACTIONS(609),
    [sym_ignore] = ACTIONS(607),
    [sym_ignore_inside] = ACTIONS(609),
    [sym_union] = ACTIONS(607),
    [sym_intersect] = ACTIONS(609),
    [sym_subtract] = ACTIONS(607),
    [anon_sym_EQ_GT] = ACTIONS(609),
    [anon_sym_DASH_GT] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(609),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(609),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(609),
    [anon_sym_AT_DASH_GT] = ACTIONS(609),
    [anon_sym_DASH_GT_AT] = ACTIONS(609),
    [anon_sym_AT_GT] = ACTIONS(609),
    [anon_sym_GT_AT] = ACTIONS(609),
    [anon_sym_LBRACK_DOT] = ACTIONS(609),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(609),
    [anon_sym_PIPE_PIPE] = ACTIONS(609),
    [anon_sym_SLASH_SLASH] = ACTIONS(609),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(609),
    [anon_sym_BSLASH_SLASH] = ACTIONS(609),
    [anon_sym_COMMA_COMMA] = ACTIONS(609),
    [sym_crossproduct] = ACTIONS(609),
    [sym_compose] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
  },
  [422] = {
    [sym_condition_operators] = STATE(664),
    [aux_sym_parallel_replace_repeat1] = STATE(472),
    [anon_sym_LBRACK] = ACTIONS(471),
    [sym_symbol] = ACTIONS(471),
    [sym_string] = ACTIONS(473),
    [sym_any] = ACTIONS(473),
    [sym_zero] = ACTIONS(473),
    [sym_boundary] = ACTIONS(473),
    [sym_symbol_group] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_BQUOTE] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(471),
    [sym_colon] = ACTIONS(473),
    [sym_complement] = ACTIONS(473),
    [sym_term_complement] = ACTIONS(471),
    [sym_contains] = ACTIONS(473),
    [sym_plus] = ACTIONS(473),
    [sym_star] = ACTIONS(473),
    [sym_repeat] = ACTIONS(473),
    [sym_upper] = ACTIONS(473),
    [sym_lower] = ACTIONS(473),
    [sym_reverse] = ACTIONS(473),
    [sym_inverse] = ACTIONS(473),
    [sym_ignore] = ACTIONS(471),
    [sym_ignore_inside] = ACTIONS(473),
    [sym_union] = ACTIONS(471),
    [sym_intersect] = ACTIONS(473),
    [sym_subtract] = ACTIONS(471),
    [anon_sym__] = ACTIONS(471),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_DASH_GT] = ACTIONS(471),
    [anon_sym_LT_DASH] = ACTIONS(473),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(473),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(473),
    [anon_sym_AT_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_AT] = ACTIONS(473),
    [anon_sym_AT_GT] = ACTIONS(473),
    [anon_sym_GT_AT] = ACTIONS(473),
    [anon_sym_LBRACK_DOT] = ACTIONS(473),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(473),
    [anon_sym_BSLASH_SLASH] = ACTIONS(473),
    [anon_sym_COMMA_COMMA] = ACTIONS(473),
    [sym_crossproduct] = ACTIONS(473),
    [sym_compose] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [423] = {
    [sym_condition_operators] = STATE(664),
    [aux_sym_parallel_replace_repeat1] = STATE(472),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(648),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [424] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(573),
    [ts_builtin_sym_end] = ACTIONS(589),
    [sym_semicolon] = ACTIONS(587),
    [anon_sym_LBRACK] = ACTIONS(587),
    [sym_symbol] = ACTIONS(587),
    [sym_string] = ACTIONS(589),
    [sym_any] = ACTIONS(589),
    [sym_zero] = ACTIONS(589),
    [sym_boundary] = ACTIONS(589),
    [sym_symbol_group] = ACTIONS(589),
    [anon_sym_LPAREN] = ACTIONS(587),
    [anon_sym_BQUOTE] = ACTIONS(589),
    [anon_sym_COMMA] = ACTIONS(587),
    [sym_colon] = ACTIONS(589),
    [sym_complement] = ACTIONS(589),
    [sym_term_complement] = ACTIONS(587),
    [sym_contains] = ACTIONS(589),
    [sym_plus] = ACTIONS(589),
    [sym_star] = ACTIONS(589),
    [sym_repeat] = ACTIONS(589),
    [sym_upper] = ACTIONS(589),
    [sym_lower] = ACTIONS(589),
    [sym_reverse] = ACTIONS(589),
    [sym_inverse] = ACTIONS(589),
    [sym_ignore] = ACTIONS(587),
    [sym_ignore_inside] = ACTIONS(589),
    [sym_union] = ACTIONS(587),
    [sym_intersect] = ACTIONS(589),
    [sym_subtract] = ACTIONS(587),
    [anon_sym_EQ_GT] = ACTIONS(589),
    [anon_sym_DASH_GT] = ACTIONS(587),
    [anon_sym_LT_DASH] = ACTIONS(589),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(589),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(589),
    [anon_sym_AT_DASH_GT] = ACTIONS(589),
    [anon_sym_DASH_GT_AT] = ACTIONS(589),
    [anon_sym_AT_GT] = ACTIONS(589),
    [anon_sym_GT_AT] = ACTIONS(589),
    [anon_sym_LBRACK_DOT] = ACTIONS(589),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(589),
    [anon_sym_PIPE_PIPE] = ACTIONS(589),
    [anon_sym_SLASH_SLASH] = ACTIONS(589),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(589),
    [anon_sym_BSLASH_SLASH] = ACTIONS(589),
    [anon_sym_COMMA_COMMA] = ACTIONS(589),
    [sym_crossproduct] = ACTIONS(589),
    [sym_compose] = ACTIONS(589),
    [sym_comment] = ACTIONS(3),
  },
  [425] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(432),
    [ts_builtin_sym_end] = ACTIONS(593),
    [sym_semicolon] = ACTIONS(591),
    [anon_sym_LBRACK] = ACTIONS(591),
    [sym_symbol] = ACTIONS(591),
    [sym_string] = ACTIONS(593),
    [sym_any] = ACTIONS(593),
    [sym_zero] = ACTIONS(593),
    [sym_boundary] = ACTIONS(593),
    [sym_symbol_group] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(591),
    [sym_colon] = ACTIONS(593),
    [sym_complement] = ACTIONS(593),
    [sym_term_complement] = ACTIONS(591),
    [sym_contains] = ACTIONS(593),
    [sym_plus] = ACTIONS(593),
    [sym_star] = ACTIONS(593),
    [sym_repeat] = ACTIONS(593),
    [sym_upper] = ACTIONS(593),
    [sym_lower] = ACTIONS(593),
    [sym_reverse] = ACTIONS(593),
    [sym_inverse] = ACTIONS(593),
    [sym_ignore] = ACTIONS(591),
    [sym_ignore_inside] = ACTIONS(593),
    [sym_union] = ACTIONS(591),
    [sym_intersect] = ACTIONS(593),
    [sym_subtract] = ACTIONS(591),
    [anon_sym_EQ_GT] = ACTIONS(593),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_LT_DASH] = ACTIONS(593),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(593),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(593),
    [anon_sym_AT_DASH_GT] = ACTIONS(593),
    [anon_sym_DASH_GT_AT] = ACTIONS(593),
    [anon_sym_AT_GT] = ACTIONS(593),
    [anon_sym_GT_AT] = ACTIONS(593),
    [anon_sym_LBRACK_DOT] = ACTIONS(593),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(593),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(593),
    [anon_sym_BSLASH_SLASH] = ACTIONS(593),
    [anon_sym_COMMA_COMMA] = ACTIONS(635),
    [sym_crossproduct] = ACTIONS(593),
    [sym_compose] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [426] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(434),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(666),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [427] = {
    [aux_sym_context_list_repeat1] = STATE(428),
    [anon_sym_LBRACK] = ACTIONS(607),
    [anon_sym_RBRACK] = ACTIONS(609),
    [sym_symbol] = ACTIONS(607),
    [sym_string] = ACTIONS(609),
    [sym_any] = ACTIONS(609),
    [sym_zero] = ACTIONS(609),
    [sym_boundary] = ACTIONS(609),
    [sym_symbol_group] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(607),
    [anon_sym_RPAREN] = ACTIONS(609),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(607),
    [sym_colon] = ACTIONS(609),
    [sym_complement] = ACTIONS(609),
    [sym_term_complement] = ACTIONS(607),
    [sym_contains] = ACTIONS(609),
    [sym_plus] = ACTIONS(609),
    [sym_star] = ACTIONS(609),
    [sym_repeat] = ACTIONS(609),
    [sym_upper] = ACTIONS(609),
    [sym_lower] = ACTIONS(609),
    [sym_reverse] = ACTIONS(609),
    [sym_inverse] = ACTIONS(609),
    [sym_ignore] = ACTIONS(607),
    [sym_ignore_inside] = ACTIONS(609),
    [sym_union] = ACTIONS(607),
    [sym_intersect] = ACTIONS(609),
    [sym_subtract] = ACTIONS(607),
    [anon_sym_EQ_GT] = ACTIONS(609),
    [anon_sym_DASH_GT] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(609),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(609),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(609),
    [anon_sym_AT_DASH_GT] = ACTIONS(609),
    [anon_sym_DASH_GT_AT] = ACTIONS(609),
    [anon_sym_AT_GT] = ACTIONS(609),
    [anon_sym_GT_AT] = ACTIONS(609),
    [anon_sym_LBRACK_DOT] = ACTIONS(609),
    [anon_sym_DOT_RBRACK] = ACTIONS(609),
    [anon_sym_PIPE_PIPE] = ACTIONS(609),
    [anon_sym_SLASH_SLASH] = ACTIONS(609),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(609),
    [anon_sym_BSLASH_SLASH] = ACTIONS(609),
    [anon_sym_COMMA_COMMA] = ACTIONS(609),
    [sym_crossproduct] = ACTIONS(609),
    [sym_compose] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
  },
  [428] = {
    [aux_sym_context_list_repeat1] = STATE(428),
    [anon_sym_LBRACK] = ACTIONS(621),
    [anon_sym_RBRACK] = ACTIONS(623),
    [sym_symbol] = ACTIONS(621),
    [sym_string] = ACTIONS(623),
    [sym_any] = ACTIONS(623),
    [sym_zero] = ACTIONS(623),
    [sym_boundary] = ACTIONS(623),
    [sym_symbol_group] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(621),
    [anon_sym_RPAREN] = ACTIONS(623),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_COMMA] = ACTIONS(671),
    [sym_colon] = ACTIONS(623),
    [sym_complement] = ACTIONS(623),
    [sym_term_complement] = ACTIONS(621),
    [sym_contains] = ACTIONS(623),
    [sym_plus] = ACTIONS(623),
    [sym_star] = ACTIONS(623),
    [sym_repeat] = ACTIONS(623),
    [sym_upper] = ACTIONS(623),
    [sym_lower] = ACTIONS(623),
    [sym_reverse] = ACTIONS(623),
    [sym_inverse] = ACTIONS(623),
    [sym_ignore] = ACTIONS(621),
    [sym_ignore_inside] = ACTIONS(623),
    [sym_union] = ACTIONS(621),
    [sym_intersect] = ACTIONS(623),
    [sym_subtract] = ACTIONS(621),
    [anon_sym_EQ_GT] = ACTIONS(623),
    [anon_sym_DASH_GT] = ACTIONS(621),
    [anon_sym_LT_DASH] = ACTIONS(623),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(623),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(623),
    [anon_sym_AT_DASH_GT] = ACTIONS(623),
    [anon_sym_DASH_GT_AT] = ACTIONS(623),
    [anon_sym_AT_GT] = ACTIONS(623),
    [anon_sym_GT_AT] = ACTIONS(623),
    [anon_sym_LBRACK_DOT] = ACTIONS(623),
    [anon_sym_DOT_RBRACK] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [anon_sym_SLASH_SLASH] = ACTIONS(623),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(623),
    [anon_sym_BSLASH_SLASH] = ACTIONS(623),
    [anon_sym_COMMA_COMMA] = ACTIONS(623),
    [sym_crossproduct] = ACTIONS(623),
    [sym_compose] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
  },
  [429] = {
    [sym_condition_operators] = STATE(660),
    [aux_sym_parallel_replace_repeat1] = STATE(443),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(653),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [430] = {
    [sym_condition_operators] = STATE(674),
    [aux_sym_parallel_replace_repeat1] = STATE(471),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(674),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym__] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [431] = {
    [anon_sym_LBRACK] = ACTIONS(676),
    [anon_sym_RBRACK] = ACTIONS(678),
    [sym_symbol] = ACTIONS(676),
    [sym_string] = ACTIONS(678),
    [sym_any] = ACTIONS(678),
    [sym_zero] = ACTIONS(678),
    [sym_boundary] = ACTIONS(678),
    [sym_symbol_group] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(676),
    [anon_sym_RPAREN] = ACTIONS(678),
    [anon_sym_BQUOTE] = ACTIONS(678),
    [anon_sym_COMMA] = ACTIONS(676),
    [sym_colon] = ACTIONS(678),
    [sym_complement] = ACTIONS(678),
    [sym_term_complement] = ACTIONS(676),
    [sym_contains] = ACTIONS(678),
    [sym_plus] = ACTIONS(678),
    [sym_star] = ACTIONS(678),
    [sym_repeat] = ACTIONS(678),
    [sym_upper] = ACTIONS(678),
    [sym_lower] = ACTIONS(678),
    [sym_reverse] = ACTIONS(678),
    [sym_inverse] = ACTIONS(678),
    [sym_ignore] = ACTIONS(676),
    [sym_ignore_inside] = ACTIONS(678),
    [sym_union] = ACTIONS(676),
    [sym_intersect] = ACTIONS(678),
    [sym_subtract] = ACTIONS(676),
    [anon_sym_EQ_GT] = ACTIONS(678),
    [anon_sym_DASH_GT] = ACTIONS(676),
    [anon_sym_LT_DASH] = ACTIONS(678),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(678),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(678),
    [anon_sym_AT_DASH_GT] = ACTIONS(678),
    [anon_sym_DASH_GT_AT] = ACTIONS(678),
    [anon_sym_AT_GT] = ACTIONS(678),
    [anon_sym_GT_AT] = ACTIONS(678),
    [anon_sym_LBRACK_DOT] = ACTIONS(678),
    [anon_sym_DOT_RBRACK] = ACTIONS(678),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(678),
    [anon_sym_PIPE_PIPE] = ACTIONS(678),
    [anon_sym_SLASH_SLASH] = ACTIONS(678),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(678),
    [anon_sym_BSLASH_SLASH] = ACTIONS(678),
    [anon_sym_COMMA_COMMA] = ACTIONS(678),
    [sym_crossproduct] = ACTIONS(678),
    [sym_compose] = ACTIONS(678),
    [sym_comment] = ACTIONS(3),
  },
  [432] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(432),
    [ts_builtin_sym_end] = ACTIONS(589),
    [sym_semicolon] = ACTIONS(587),
    [anon_sym_LBRACK] = ACTIONS(587),
    [sym_symbol] = ACTIONS(587),
    [sym_string] = ACTIONS(589),
    [sym_any] = ACTIONS(589),
    [sym_zero] = ACTIONS(589),
    [sym_boundary] = ACTIONS(589),
    [sym_symbol_group] = ACTIONS(589),
    [anon_sym_LPAREN] = ACTIONS(587),
    [anon_sym_BQUOTE] = ACTIONS(589),
    [anon_sym_COMMA] = ACTIONS(587),
    [sym_colon] = ACTIONS(589),
    [sym_complement] = ACTIONS(589),
    [sym_term_complement] = ACTIONS(587),
    [sym_contains] = ACTIONS(589),
    [sym_plus] = ACTIONS(589),
    [sym_star] = ACTIONS(589),
    [sym_repeat] = ACTIONS(589),
    [sym_upper] = ACTIONS(589),
    [sym_lower] = ACTIONS(589),
    [sym_reverse] = ACTIONS(589),
    [sym_inverse] = ACTIONS(589),
    [sym_ignore] = ACTIONS(587),
    [sym_ignore_inside] = ACTIONS(589),
    [sym_union] = ACTIONS(587),
    [sym_intersect] = ACTIONS(589),
    [sym_subtract] = ACTIONS(587),
    [anon_sym_EQ_GT] = ACTIONS(589),
    [anon_sym_DASH_GT] = ACTIONS(587),
    [anon_sym_LT_DASH] = ACTIONS(589),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(589),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(589),
    [anon_sym_AT_DASH_GT] = ACTIONS(589),
    [anon_sym_DASH_GT_AT] = ACTIONS(589),
    [anon_sym_AT_GT] = ACTIONS(589),
    [anon_sym_GT_AT] = ACTIONS(589),
    [anon_sym_LBRACK_DOT] = ACTIONS(589),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(589),
    [anon_sym_PIPE_PIPE] = ACTIONS(589),
    [anon_sym_SLASH_SLASH] = ACTIONS(589),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(589),
    [anon_sym_BSLASH_SLASH] = ACTIONS(589),
    [anon_sym_COMMA_COMMA] = ACTIONS(680),
    [sym_crossproduct] = ACTIONS(589),
    [sym_compose] = ACTIONS(589),
    [sym_comment] = ACTIONS(3),
  },
  [433] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(416),
    [anon_sym_LBRACK] = ACTIONS(535),
    [anon_sym_RBRACK] = ACTIONS(537),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_RBRACK] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(666),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [434] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(414),
    [anon_sym_LBRACK] = ACTIONS(591),
    [anon_sym_RBRACK] = ACTIONS(593),
    [sym_symbol] = ACTIONS(591),
    [sym_string] = ACTIONS(593),
    [sym_any] = ACTIONS(593),
    [sym_zero] = ACTIONS(593),
    [sym_boundary] = ACTIONS(593),
    [sym_symbol_group] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_RPAREN] = ACTIONS(593),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(591),
    [sym_colon] = ACTIONS(593),
    [sym_complement] = ACTIONS(593),
    [sym_term_complement] = ACTIONS(591),
    [sym_contains] = ACTIONS(593),
    [sym_plus] = ACTIONS(593),
    [sym_star] = ACTIONS(593),
    [sym_repeat] = ACTIONS(593),
    [sym_upper] = ACTIONS(593),
    [sym_lower] = ACTIONS(593),
    [sym_reverse] = ACTIONS(593),
    [sym_inverse] = ACTIONS(593),
    [sym_ignore] = ACTIONS(591),
    [sym_ignore_inside] = ACTIONS(593),
    [sym_union] = ACTIONS(591),
    [sym_intersect] = ACTIONS(593),
    [sym_subtract] = ACTIONS(591),
    [anon_sym_EQ_GT] = ACTIONS(593),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_LT_DASH] = ACTIONS(593),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(593),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(593),
    [anon_sym_AT_DASH_GT] = ACTIONS(593),
    [anon_sym_DASH_GT_AT] = ACTIONS(593),
    [anon_sym_AT_GT] = ACTIONS(593),
    [anon_sym_GT_AT] = ACTIONS(593),
    [anon_sym_LBRACK_DOT] = ACTIONS(593),
    [anon_sym_DOT_RBRACK] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(593),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(593),
    [anon_sym_BSLASH_SLASH] = ACTIONS(593),
    [anon_sym_COMMA_COMMA] = ACTIONS(593),
    [sym_crossproduct] = ACTIONS(593),
    [sym_compose] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [435] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(432),
    [ts_builtin_sym_end] = ACTIONS(593),
    [sym_semicolon] = ACTIONS(591),
    [anon_sym_LBRACK] = ACTIONS(591),
    [sym_symbol] = ACTIONS(591),
    [sym_string] = ACTIONS(593),
    [sym_any] = ACTIONS(593),
    [sym_zero] = ACTIONS(593),
    [sym_boundary] = ACTIONS(593),
    [sym_symbol_group] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(591),
    [sym_colon] = ACTIONS(593),
    [sym_complement] = ACTIONS(593),
    [sym_term_complement] = ACTIONS(591),
    [sym_contains] = ACTIONS(593),
    [sym_plus] = ACTIONS(593),
    [sym_star] = ACTIONS(593),
    [sym_repeat] = ACTIONS(593),
    [sym_upper] = ACTIONS(593),
    [sym_lower] = ACTIONS(593),
    [sym_reverse] = ACTIONS(593),
    [sym_inverse] = ACTIONS(593),
    [sym_ignore] = ACTIONS(591),
    [sym_ignore_inside] = ACTIONS(593),
    [sym_union] = ACTIONS(591),
    [sym_intersect] = ACTIONS(593),
    [sym_subtract] = ACTIONS(591),
    [anon_sym_EQ_GT] = ACTIONS(593),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_LT_DASH] = ACTIONS(593),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(593),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(593),
    [anon_sym_AT_DASH_GT] = ACTIONS(593),
    [anon_sym_DASH_GT_AT] = ACTIONS(593),
    [anon_sym_AT_GT] = ACTIONS(593),
    [anon_sym_GT_AT] = ACTIONS(593),
    [anon_sym_LBRACK_DOT] = ACTIONS(593),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(593),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(593),
    [anon_sym_BSLASH_SLASH] = ACTIONS(593),
    [anon_sym_COMMA_COMMA] = ACTIONS(593),
    [sym_crossproduct] = ACTIONS(593),
    [sym_compose] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [436] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(435),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(635),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [437] = {
    [sym_condition_operators] = STATE(646),
    [aux_sym_parallel_replace_repeat1] = STATE(465),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(683),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [438] = {
    [aux_sym_parallel_replace_repeat1] = STATE(438),
    [ts_builtin_sym_end] = ACTIONS(473),
    [sym_semicolon] = ACTIONS(471),
    [anon_sym_LBRACK] = ACTIONS(471),
    [sym_symbol] = ACTIONS(471),
    [sym_string] = ACTIONS(473),
    [sym_any] = ACTIONS(473),
    [sym_zero] = ACTIONS(473),
    [sym_boundary] = ACTIONS(473),
    [sym_symbol_group] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_BQUOTE] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(685),
    [sym_colon] = ACTIONS(473),
    [sym_complement] = ACTIONS(473),
    [sym_term_complement] = ACTIONS(471),
    [sym_contains] = ACTIONS(473),
    [sym_plus] = ACTIONS(473),
    [sym_star] = ACTIONS(473),
    [sym_repeat] = ACTIONS(473),
    [sym_upper] = ACTIONS(473),
    [sym_lower] = ACTIONS(473),
    [sym_reverse] = ACTIONS(473),
    [sym_inverse] = ACTIONS(473),
    [sym_ignore] = ACTIONS(471),
    [sym_ignore_inside] = ACTIONS(473),
    [sym_union] = ACTIONS(471),
    [sym_intersect] = ACTIONS(473),
    [sym_subtract] = ACTIONS(471),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_DASH_GT] = ACTIONS(471),
    [anon_sym_LT_DASH] = ACTIONS(473),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(473),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(473),
    [anon_sym_AT_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_AT] = ACTIONS(473),
    [anon_sym_AT_GT] = ACTIONS(473),
    [anon_sym_GT_AT] = ACTIONS(473),
    [anon_sym_LBRACK_DOT] = ACTIONS(473),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(473),
    [anon_sym_BSLASH_SLASH] = ACTIONS(473),
    [anon_sym_COMMA_COMMA] = ACTIONS(473),
    [sym_crossproduct] = ACTIONS(473),
    [sym_compose] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [439] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(450),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym__] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(688),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [440] = {
    [sym_condition_operators] = STATE(674),
    [aux_sym_parallel_replace_repeat1] = STATE(525),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(690),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym__] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [441] = {
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_semicolon] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(51),
    [sym_symbol] = ACTIONS(51),
    [sym_string] = ACTIONS(53),
    [sym_any] = ACTIONS(53),
    [sym_zero] = ACTIONS(53),
    [sym_boundary] = ACTIONS(53),
    [sym_symbol_group] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_COMMA] = ACTIONS(51),
    [sym_colon] = ACTIONS(53),
    [sym_complement] = ACTIONS(53),
    [sym_term_complement] = ACTIONS(51),
    [sym_contains] = ACTIONS(53),
    [sym_plus] = ACTIONS(53),
    [sym_star] = ACTIONS(53),
    [sym_repeat] = ACTIONS(53),
    [sym_upper] = ACTIONS(53),
    [sym_lower] = ACTIONS(53),
    [sym_reverse] = ACTIONS(53),
    [sym_inverse] = ACTIONS(53),
    [sym_ignore] = ACTIONS(51),
    [sym_ignore_inside] = ACTIONS(53),
    [sym_union] = ACTIONS(51),
    [sym_intersect] = ACTIONS(53),
    [sym_subtract] = ACTIONS(51),
    [anon_sym_EQ_GT] = ACTIONS(53),
    [anon_sym_DASH_GT] = ACTIONS(51),
    [anon_sym_LT_DASH] = ACTIONS(53),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(53),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(53),
    [anon_sym_AT_DASH_GT] = ACTIONS(53),
    [anon_sym_DASH_GT_AT] = ACTIONS(53),
    [anon_sym_AT_GT] = ACTIONS(53),
    [anon_sym_GT_AT] = ACTIONS(53),
    [anon_sym_LBRACK_DOT] = ACTIONS(53),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(53),
    [anon_sym_PIPE_PIPE] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(53),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(53),
    [anon_sym_BSLASH_SLASH] = ACTIONS(53),
    [anon_sym_COMMA_COMMA] = ACTIONS(53),
    [sym_crossproduct] = ACTIONS(53),
    [sym_compose] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
  },
  [442] = {
    [aux_sym_context_list_repeat1] = STATE(442),
    [anon_sym_LBRACK] = ACTIONS(621),
    [sym_symbol] = ACTIONS(621),
    [sym_string] = ACTIONS(623),
    [sym_any] = ACTIONS(623),
    [sym_zero] = ACTIONS(623),
    [sym_boundary] = ACTIONS(623),
    [sym_symbol_group] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(621),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_COMMA] = ACTIONS(692),
    [sym_colon] = ACTIONS(623),
    [sym_complement] = ACTIONS(623),
    [sym_term_complement] = ACTIONS(621),
    [sym_contains] = ACTIONS(623),
    [sym_plus] = ACTIONS(623),
    [sym_star] = ACTIONS(623),
    [sym_repeat] = ACTIONS(623),
    [sym_upper] = ACTIONS(623),
    [sym_lower] = ACTIONS(623),
    [sym_reverse] = ACTIONS(623),
    [sym_inverse] = ACTIONS(623),
    [sym_ignore] = ACTIONS(621),
    [sym_ignore_inside] = ACTIONS(623),
    [sym_union] = ACTIONS(621),
    [sym_intersect] = ACTIONS(623),
    [sym_subtract] = ACTIONS(621),
    [anon_sym__] = ACTIONS(621),
    [anon_sym_EQ_GT] = ACTIONS(623),
    [anon_sym_DASH_GT] = ACTIONS(621),
    [anon_sym_LT_DASH] = ACTIONS(623),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(623),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(623),
    [anon_sym_AT_DASH_GT] = ACTIONS(623),
    [anon_sym_DASH_GT_AT] = ACTIONS(623),
    [anon_sym_AT_GT] = ACTIONS(623),
    [anon_sym_GT_AT] = ACTIONS(623),
    [anon_sym_LBRACK_DOT] = ACTIONS(623),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [anon_sym_SLASH_SLASH] = ACTIONS(623),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(623),
    [anon_sym_BSLASH_SLASH] = ACTIONS(623),
    [anon_sym_COMMA_COMMA] = ACTIONS(623),
    [sym_crossproduct] = ACTIONS(623),
    [sym_compose] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
  },
  [443] = {
    [aux_sym_parallel_replace_repeat1] = STATE(490),
    [ts_builtin_sym_end] = ACTIONS(613),
    [sym_semicolon] = ACTIONS(611),
    [anon_sym_LBRACK] = ACTIONS(611),
    [sym_symbol] = ACTIONS(611),
    [sym_string] = ACTIONS(613),
    [sym_any] = ACTIONS(613),
    [sym_zero] = ACTIONS(613),
    [sym_boundary] = ACTIONS(613),
    [sym_symbol_group] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_BQUOTE] = ACTIONS(613),
    [anon_sym_COMMA] = ACTIONS(611),
    [sym_colon] = ACTIONS(613),
    [sym_complement] = ACTIONS(613),
    [sym_term_complement] = ACTIONS(611),
    [sym_contains] = ACTIONS(613),
    [sym_plus] = ACTIONS(613),
    [sym_star] = ACTIONS(613),
    [sym_repeat] = ACTIONS(613),
    [sym_upper] = ACTIONS(613),
    [sym_lower] = ACTIONS(613),
    [sym_reverse] = ACTIONS(613),
    [sym_inverse] = ACTIONS(613),
    [sym_ignore] = ACTIONS(611),
    [sym_ignore_inside] = ACTIONS(613),
    [sym_union] = ACTIONS(611),
    [sym_intersect] = ACTIONS(613),
    [sym_subtract] = ACTIONS(611),
    [anon_sym_EQ_GT] = ACTIONS(613),
    [anon_sym_DASH_GT] = ACTIONS(611),
    [anon_sym_LT_DASH] = ACTIONS(613),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(613),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(613),
    [anon_sym_AT_DASH_GT] = ACTIONS(613),
    [anon_sym_DASH_GT_AT] = ACTIONS(613),
    [anon_sym_AT_GT] = ACTIONS(613),
    [anon_sym_GT_AT] = ACTIONS(613),
    [anon_sym_LBRACK_DOT] = ACTIONS(613),
    [anon_sym_PIPE_PIPE] = ACTIONS(613),
    [anon_sym_SLASH_SLASH] = ACTIONS(613),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(613),
    [anon_sym_BSLASH_SLASH] = ACTIONS(613),
    [anon_sym_COMMA_COMMA] = ACTIONS(613),
    [sym_crossproduct] = ACTIONS(613),
    [sym_compose] = ACTIONS(613),
    [sym_comment] = ACTIONS(3),
  },
  [444] = {
    [aux_sym_context_list_repeat1] = STATE(446),
    [anon_sym_LBRACK] = ACTIONS(615),
    [sym_symbol] = ACTIONS(615),
    [sym_string] = ACTIONS(617),
    [sym_any] = ACTIONS(617),
    [sym_zero] = ACTIONS(617),
    [sym_boundary] = ACTIONS(617),
    [sym_symbol_group] = ACTIONS(617),
    [anon_sym_LPAREN] = ACTIONS(615),
    [anon_sym_BQUOTE] = ACTIONS(617),
    [anon_sym_COMMA] = ACTIONS(615),
    [sym_colon] = ACTIONS(617),
    [sym_complement] = ACTIONS(617),
    [sym_term_complement] = ACTIONS(615),
    [sym_contains] = ACTIONS(617),
    [sym_plus] = ACTIONS(617),
    [sym_star] = ACTIONS(617),
    [sym_repeat] = ACTIONS(617),
    [sym_upper] = ACTIONS(617),
    [sym_lower] = ACTIONS(617),
    [sym_reverse] = ACTIONS(617),
    [sym_inverse] = ACTIONS(617),
    [sym_ignore] = ACTIONS(615),
    [sym_ignore_inside] = ACTIONS(617),
    [sym_union] = ACTIONS(615),
    [sym_intersect] = ACTIONS(617),
    [sym_subtract] = ACTIONS(615),
    [anon_sym__] = ACTIONS(615),
    [anon_sym_EQ_GT] = ACTIONS(617),
    [anon_sym_DASH_GT] = ACTIONS(615),
    [anon_sym_LT_DASH] = ACTIONS(617),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(617),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(617),
    [anon_sym_AT_DASH_GT] = ACTIONS(617),
    [anon_sym_DASH_GT_AT] = ACTIONS(617),
    [anon_sym_AT_GT] = ACTIONS(617),
    [anon_sym_GT_AT] = ACTIONS(617),
    [anon_sym_LBRACK_DOT] = ACTIONS(617),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(617),
    [anon_sym_PIPE_PIPE] = ACTIONS(617),
    [anon_sym_SLASH_SLASH] = ACTIONS(617),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(617),
    [anon_sym_BSLASH_SLASH] = ACTIONS(617),
    [anon_sym_COMMA_COMMA] = ACTIONS(617),
    [sym_crossproduct] = ACTIONS(617),
    [sym_compose] = ACTIONS(617),
    [sym_comment] = ACTIONS(3),
  },
  [445] = {
    [sym_condition_operators] = STATE(678),
    [aux_sym_parallel_replace_repeat1] = STATE(527),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(695),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [446] = {
    [aux_sym_context_list_repeat1] = STATE(442),
    [anon_sym_LBRACK] = ACTIONS(607),
    [sym_symbol] = ACTIONS(607),
    [sym_string] = ACTIONS(609),
    [sym_any] = ACTIONS(609),
    [sym_zero] = ACTIONS(609),
    [sym_boundary] = ACTIONS(609),
    [sym_symbol_group] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(607),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(607),
    [sym_colon] = ACTIONS(609),
    [sym_complement] = ACTIONS(609),
    [sym_term_complement] = ACTIONS(607),
    [sym_contains] = ACTIONS(609),
    [sym_plus] = ACTIONS(609),
    [sym_star] = ACTIONS(609),
    [sym_repeat] = ACTIONS(609),
    [sym_upper] = ACTIONS(609),
    [sym_lower] = ACTIONS(609),
    [sym_reverse] = ACTIONS(609),
    [sym_inverse] = ACTIONS(609),
    [sym_ignore] = ACTIONS(607),
    [sym_ignore_inside] = ACTIONS(609),
    [sym_union] = ACTIONS(607),
    [sym_intersect] = ACTIONS(609),
    [sym_subtract] = ACTIONS(607),
    [anon_sym__] = ACTIONS(607),
    [anon_sym_EQ_GT] = ACTIONS(609),
    [anon_sym_DASH_GT] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(609),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(609),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(609),
    [anon_sym_AT_DASH_GT] = ACTIONS(609),
    [anon_sym_DASH_GT_AT] = ACTIONS(609),
    [anon_sym_AT_GT] = ACTIONS(609),
    [anon_sym_GT_AT] = ACTIONS(609),
    [anon_sym_LBRACK_DOT] = ACTIONS(609),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(609),
    [anon_sym_PIPE_PIPE] = ACTIONS(609),
    [anon_sym_SLASH_SLASH] = ACTIONS(609),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(609),
    [anon_sym_BSLASH_SLASH] = ACTIONS(609),
    [anon_sym_COMMA_COMMA] = ACTIONS(609),
    [sym_crossproduct] = ACTIONS(609),
    [sym_compose] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
  },
  [447] = {
    [sym_condition_operators] = STATE(656),
    [aux_sym_parallel_replace_repeat1] = STATE(501),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(697),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym__] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [anon_sym_COMMA_COMMA] = ACTIONS(537),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [448] = {
    [aux_sym_context_list_repeat1] = STATE(451),
    [anon_sym_LBRACK] = ACTIONS(607),
    [anon_sym_RBRACK] = ACTIONS(609),
    [sym_symbol] = ACTIONS(607),
    [sym_string] = ACTIONS(609),
    [sym_any] = ACTIONS(609),
    [sym_zero] = ACTIONS(609),
    [sym_boundary] = ACTIONS(609),
    [sym_symbol_group] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(607),
    [anon_sym_RPAREN] = ACTIONS(609),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(609),
    [sym_colon] = ACTIONS(609),
    [sym_complement] = ACTIONS(609),
    [sym_term_complement] = ACTIONS(607),
    [sym_contains] = ACTIONS(609),
    [sym_plus] = ACTIONS(609),
    [sym_star] = ACTIONS(609),
    [sym_repeat] = ACTIONS(609),
    [sym_upper] = ACTIONS(609),
    [sym_lower] = ACTIONS(609),
    [sym_reverse] = ACTIONS(609),
    [sym_inverse] = ACTIONS(609),
    [sym_ignore] = ACTIONS(607),
    [sym_ignore_inside] = ACTIONS(609),
    [sym_union] = ACTIONS(607),
    [sym_intersect] = ACTIONS(609),
    [sym_subtract] = ACTIONS(607),
    [anon_sym_EQ_GT] = ACTIONS(609),
    [anon_sym_DASH_GT] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(609),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(609),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(609),
    [anon_sym_AT_DASH_GT] = ACTIONS(609),
    [anon_sym_DASH_GT_AT] = ACTIONS(609),
    [anon_sym_AT_GT] = ACTIONS(609),
    [anon_sym_GT_AT] = ACTIONS(609),
    [anon_sym_LBRACK_DOT] = ACTIONS(609),
    [anon_sym_DOT_RBRACK] = ACTIONS(609),
    [anon_sym_PIPE_PIPE] = ACTIONS(609),
    [anon_sym_SLASH_SLASH] = ACTIONS(609),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(609),
    [anon_sym_BSLASH_SLASH] = ACTIONS(609),
    [sym_crossproduct] = ACTIONS(609),
    [sym_compose] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
  },
  [449] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(457),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(699),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [450] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(483),
    [anon_sym_LBRACK] = ACTIONS(591),
    [sym_symbol] = ACTIONS(591),
    [sym_string] = ACTIONS(593),
    [sym_any] = ACTIONS(593),
    [sym_zero] = ACTIONS(593),
    [sym_boundary] = ACTIONS(593),
    [sym_symbol_group] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(591),
    [sym_colon] = ACTIONS(593),
    [sym_complement] = ACTIONS(593),
    [sym_term_complement] = ACTIONS(591),
    [sym_contains] = ACTIONS(593),
    [sym_plus] = ACTIONS(593),
    [sym_star] = ACTIONS(593),
    [sym_repeat] = ACTIONS(593),
    [sym_upper] = ACTIONS(593),
    [sym_lower] = ACTIONS(593),
    [sym_reverse] = ACTIONS(593),
    [sym_inverse] = ACTIONS(593),
    [sym_ignore] = ACTIONS(591),
    [sym_ignore_inside] = ACTIONS(593),
    [sym_union] = ACTIONS(591),
    [sym_intersect] = ACTIONS(593),
    [sym_subtract] = ACTIONS(591),
    [anon_sym__] = ACTIONS(591),
    [anon_sym_EQ_GT] = ACTIONS(593),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_LT_DASH] = ACTIONS(593),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(593),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(593),
    [anon_sym_AT_DASH_GT] = ACTIONS(593),
    [anon_sym_DASH_GT_AT] = ACTIONS(593),
    [anon_sym_AT_GT] = ACTIONS(593),
    [anon_sym_GT_AT] = ACTIONS(593),
    [anon_sym_LBRACK_DOT] = ACTIONS(593),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(593),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(593),
    [anon_sym_BSLASH_SLASH] = ACTIONS(593),
    [anon_sym_COMMA_COMMA] = ACTIONS(593),
    [sym_crossproduct] = ACTIONS(593),
    [sym_compose] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [451] = {
    [aux_sym_context_list_repeat1] = STATE(451),
    [anon_sym_LBRACK] = ACTIONS(621),
    [anon_sym_RBRACK] = ACTIONS(623),
    [sym_symbol] = ACTIONS(621),
    [sym_string] = ACTIONS(623),
    [sym_any] = ACTIONS(623),
    [sym_zero] = ACTIONS(623),
    [sym_boundary] = ACTIONS(623),
    [sym_symbol_group] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(621),
    [anon_sym_RPAREN] = ACTIONS(623),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_COMMA] = ACTIONS(701),
    [sym_colon] = ACTIONS(623),
    [sym_complement] = ACTIONS(623),
    [sym_term_complement] = ACTIONS(621),
    [sym_contains] = ACTIONS(623),
    [sym_plus] = ACTIONS(623),
    [sym_star] = ACTIONS(623),
    [sym_repeat] = ACTIONS(623),
    [sym_upper] = ACTIONS(623),
    [sym_lower] = ACTIONS(623),
    [sym_reverse] = ACTIONS(623),
    [sym_inverse] = ACTIONS(623),
    [sym_ignore] = ACTIONS(621),
    [sym_ignore_inside] = ACTIONS(623),
    [sym_union] = ACTIONS(621),
    [sym_intersect] = ACTIONS(623),
    [sym_subtract] = ACTIONS(621),
    [anon_sym_EQ_GT] = ACTIONS(623),
    [anon_sym_DASH_GT] = ACTIONS(621),
    [anon_sym_LT_DASH] = ACTIONS(623),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(623),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(623),
    [anon_sym_AT_DASH_GT] = ACTIONS(623),
    [anon_sym_DASH_GT_AT] = ACTIONS(623),
    [anon_sym_AT_GT] = ACTIONS(623),
    [anon_sym_GT_AT] = ACTIONS(623),
    [anon_sym_LBRACK_DOT] = ACTIONS(623),
    [anon_sym_DOT_RBRACK] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [anon_sym_SLASH_SLASH] = ACTIONS(623),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(623),
    [anon_sym_BSLASH_SLASH] = ACTIONS(623),
    [sym_crossproduct] = ACTIONS(623),
    [sym_compose] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
  },
  [452] = {
    [aux_sym_context_list_repeat1] = STATE(452),
    [ts_builtin_sym_end] = ACTIONS(623),
    [sym_semicolon] = ACTIONS(621),
    [anon_sym_LBRACK] = ACTIONS(621),
    [sym_symbol] = ACTIONS(621),
    [sym_string] = ACTIONS(623),
    [sym_any] = ACTIONS(623),
    [sym_zero] = ACTIONS(623),
    [sym_boundary] = ACTIONS(623),
    [sym_symbol_group] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(621),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_COMMA] = ACTIONS(704),
    [sym_colon] = ACTIONS(623),
    [sym_complement] = ACTIONS(623),
    [sym_term_complement] = ACTIONS(621),
    [sym_contains] = ACTIONS(623),
    [sym_plus] = ACTIONS(623),
    [sym_star] = ACTIONS(623),
    [sym_repeat] = ACTIONS(623),
    [sym_upper] = ACTIONS(623),
    [sym_lower] = ACTIONS(623),
    [sym_reverse] = ACTIONS(623),
    [sym_inverse] = ACTIONS(623),
    [sym_ignore] = ACTIONS(621),
    [sym_ignore_inside] = ACTIONS(623),
    [sym_union] = ACTIONS(621),
    [sym_intersect] = ACTIONS(623),
    [sym_subtract] = ACTIONS(621),
    [anon_sym_EQ_GT] = ACTIONS(623),
    [anon_sym_DASH_GT] = ACTIONS(621),
    [anon_sym_LT_DASH] = ACTIONS(623),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(623),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(623),
    [anon_sym_AT_DASH_GT] = ACTIONS(623),
    [anon_sym_DASH_GT_AT] = ACTIONS(623),
    [anon_sym_AT_GT] = ACTIONS(623),
    [anon_sym_GT_AT] = ACTIONS(623),
    [anon_sym_LBRACK_DOT] = ACTIONS(623),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [anon_sym_SLASH_SLASH] = ACTIONS(623),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(623),
    [anon_sym_BSLASH_SLASH] = ACTIONS(623),
    [sym_crossproduct] = ACTIONS(623),
    [sym_compose] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
  },
  [453] = {
    [aux_sym_parallel_replace_repeat1] = STATE(479),
    [anon_sym_LBRACK] = ACTIONS(611),
    [anon_sym_RBRACK] = ACTIONS(613),
    [sym_symbol] = ACTIONS(611),
    [sym_string] = ACTIONS(613),
    [sym_any] = ACTIONS(613),
    [sym_zero] = ACTIONS(613),
    [sym_boundary] = ACTIONS(613),
    [sym_symbol_group] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(613),
    [anon_sym_BQUOTE] = ACTIONS(613),
    [anon_sym_COMMA] = ACTIONS(613),
    [sym_colon] = ACTIONS(613),
    [sym_complement] = ACTIONS(613),
    [sym_term_complement] = ACTIONS(611),
    [sym_contains] = ACTIONS(613),
    [sym_plus] = ACTIONS(613),
    [sym_star] = ACTIONS(613),
    [sym_repeat] = ACTIONS(613),
    [sym_upper] = ACTIONS(613),
    [sym_lower] = ACTIONS(613),
    [sym_reverse] = ACTIONS(613),
    [sym_inverse] = ACTIONS(613),
    [sym_ignore] = ACTIONS(611),
    [sym_ignore_inside] = ACTIONS(613),
    [sym_union] = ACTIONS(611),
    [sym_intersect] = ACTIONS(613),
    [sym_subtract] = ACTIONS(611),
    [anon_sym_EQ_GT] = ACTIONS(613),
    [anon_sym_DASH_GT] = ACTIONS(611),
    [anon_sym_LT_DASH] = ACTIONS(613),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(613),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(613),
    [anon_sym_AT_DASH_GT] = ACTIONS(613),
    [anon_sym_DASH_GT_AT] = ACTIONS(613),
    [anon_sym_AT_GT] = ACTIONS(613),
    [anon_sym_GT_AT] = ACTIONS(613),
    [anon_sym_LBRACK_DOT] = ACTIONS(613),
    [anon_sym_DOT_RBRACK] = ACTIONS(613),
    [anon_sym_PIPE_PIPE] = ACTIONS(613),
    [anon_sym_SLASH_SLASH] = ACTIONS(613),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(613),
    [anon_sym_BSLASH_SLASH] = ACTIONS(613),
    [sym_crossproduct] = ACTIONS(613),
    [sym_compose] = ACTIONS(613),
    [sym_comment] = ACTIONS(3),
  },
  [454] = {
    [sym_condition_operators] = STATE(675),
    [aux_sym_parallel_replace_repeat1] = STATE(493),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(695),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [455] = {
    [aux_sym_parallel_replace_repeat1] = STATE(455),
    [anon_sym_LBRACK] = ACTIONS(471),
    [sym_symbol] = ACTIONS(471),
    [sym_string] = ACTIONS(473),
    [sym_any] = ACTIONS(473),
    [sym_zero] = ACTIONS(473),
    [sym_boundary] = ACTIONS(473),
    [sym_symbol_group] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_BQUOTE] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(707),
    [sym_colon] = ACTIONS(473),
    [sym_complement] = ACTIONS(473),
    [sym_term_complement] = ACTIONS(471),
    [sym_contains] = ACTIONS(473),
    [sym_plus] = ACTIONS(473),
    [sym_star] = ACTIONS(473),
    [sym_repeat] = ACTIONS(473),
    [sym_upper] = ACTIONS(473),
    [sym_lower] = ACTIONS(473),
    [sym_reverse] = ACTIONS(473),
    [sym_inverse] = ACTIONS(473),
    [sym_ignore] = ACTIONS(471),
    [sym_ignore_inside] = ACTIONS(473),
    [sym_union] = ACTIONS(471),
    [sym_intersect] = ACTIONS(473),
    [sym_subtract] = ACTIONS(471),
    [anon_sym__] = ACTIONS(471),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_DASH_GT] = ACTIONS(471),
    [anon_sym_LT_DASH] = ACTIONS(473),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(473),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(473),
    [anon_sym_AT_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_AT] = ACTIONS(473),
    [anon_sym_AT_GT] = ACTIONS(473),
    [anon_sym_GT_AT] = ACTIONS(473),
    [anon_sym_LBRACK_DOT] = ACTIONS(473),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(473),
    [anon_sym_BSLASH_SLASH] = ACTIONS(473),
    [anon_sym_COMMA_COMMA] = ACTIONS(473),
    [sym_crossproduct] = ACTIONS(473),
    [sym_compose] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [456] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(461),
    [ts_builtin_sym_end] = ACTIONS(593),
    [sym_semicolon] = ACTIONS(591),
    [anon_sym_LBRACK] = ACTIONS(591),
    [sym_symbol] = ACTIONS(591),
    [sym_string] = ACTIONS(593),
    [sym_any] = ACTIONS(593),
    [sym_zero] = ACTIONS(593),
    [sym_boundary] = ACTIONS(593),
    [sym_symbol_group] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(591),
    [sym_colon] = ACTIONS(593),
    [sym_complement] = ACTIONS(593),
    [sym_term_complement] = ACTIONS(591),
    [sym_contains] = ACTIONS(593),
    [sym_plus] = ACTIONS(593),
    [sym_star] = ACTIONS(593),
    [sym_repeat] = ACTIONS(593),
    [sym_upper] = ACTIONS(593),
    [sym_lower] = ACTIONS(593),
    [sym_reverse] = ACTIONS(593),
    [sym_inverse] = ACTIONS(593),
    [sym_ignore] = ACTIONS(591),
    [sym_ignore_inside] = ACTIONS(593),
    [sym_union] = ACTIONS(591),
    [sym_intersect] = ACTIONS(593),
    [sym_subtract] = ACTIONS(591),
    [anon_sym_EQ_GT] = ACTIONS(593),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_LT_DASH] = ACTIONS(593),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(593),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(593),
    [anon_sym_AT_DASH_GT] = ACTIONS(593),
    [anon_sym_DASH_GT_AT] = ACTIONS(593),
    [anon_sym_AT_GT] = ACTIONS(593),
    [anon_sym_GT_AT] = ACTIONS(593),
    [anon_sym_LBRACK_DOT] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(593),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(593),
    [anon_sym_BSLASH_SLASH] = ACTIONS(593),
    [anon_sym_COMMA_COMMA] = ACTIONS(593),
    [sym_crossproduct] = ACTIONS(593),
    [sym_compose] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [457] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(461),
    [ts_builtin_sym_end] = ACTIONS(593),
    [sym_semicolon] = ACTIONS(591),
    [anon_sym_LBRACK] = ACTIONS(591),
    [sym_symbol] = ACTIONS(591),
    [sym_string] = ACTIONS(593),
    [sym_any] = ACTIONS(593),
    [sym_zero] = ACTIONS(593),
    [sym_boundary] = ACTIONS(593),
    [sym_symbol_group] = ACTIONS(593),
    [anon_sym_LPAREN] = ACTIONS(591),
    [anon_sym_BQUOTE] = ACTIONS(593),
    [anon_sym_COMMA] = ACTIONS(591),
    [sym_colon] = ACTIONS(593),
    [sym_complement] = ACTIONS(593),
    [sym_term_complement] = ACTIONS(591),
    [sym_contains] = ACTIONS(593),
    [sym_plus] = ACTIONS(593),
    [sym_star] = ACTIONS(593),
    [sym_repeat] = ACTIONS(593),
    [sym_upper] = ACTIONS(593),
    [sym_lower] = ACTIONS(593),
    [sym_reverse] = ACTIONS(593),
    [sym_inverse] = ACTIONS(593),
    [sym_ignore] = ACTIONS(591),
    [sym_ignore_inside] = ACTIONS(593),
    [sym_union] = ACTIONS(591),
    [sym_intersect] = ACTIONS(593),
    [sym_subtract] = ACTIONS(591),
    [anon_sym_EQ_GT] = ACTIONS(593),
    [anon_sym_DASH_GT] = ACTIONS(591),
    [anon_sym_LT_DASH] = ACTIONS(593),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(593),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(593),
    [anon_sym_AT_DASH_GT] = ACTIONS(593),
    [anon_sym_DASH_GT_AT] = ACTIONS(593),
    [anon_sym_AT_GT] = ACTIONS(593),
    [anon_sym_GT_AT] = ACTIONS(593),
    [anon_sym_LBRACK_DOT] = ACTIONS(593),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_SLASH_SLASH] = ACTIONS(593),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(593),
    [anon_sym_BSLASH_SLASH] = ACTIONS(593),
    [anon_sym_COMMA_COMMA] = ACTIONS(699),
    [sym_crossproduct] = ACTIONS(593),
    [sym_compose] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [458] = {
    [aux_sym_context_list_repeat1] = STATE(466),
    [ts_builtin_sym_end] = ACTIONS(617),
    [sym_semicolon] = ACTIONS(615),
    [anon_sym_LBRACK] = ACTIONS(615),
    [sym_symbol] = ACTIONS(615),
    [sym_string] = ACTIONS(617),
    [sym_any] = ACTIONS(617),
    [sym_zero] = ACTIONS(617),
    [sym_boundary] = ACTIONS(617),
    [sym_symbol_group] = ACTIONS(617),
    [anon_sym_LPAREN] = ACTIONS(615),
    [anon_sym_BQUOTE] = ACTIONS(617),
    [anon_sym_COMMA] = ACTIONS(617),
    [sym_colon] = ACTIONS(617),
    [sym_complement] = ACTIONS(617),
    [sym_term_complement] = ACTIONS(615),
    [sym_contains] = ACTIONS(617),
    [sym_plus] = ACTIONS(617),
    [sym_star] = ACTIONS(617),
    [sym_repeat] = ACTIONS(617),
    [sym_upper] = ACTIONS(617),
    [sym_lower] = ACTIONS(617),
    [sym_reverse] = ACTIONS(617),
    [sym_inverse] = ACTIONS(617),
    [sym_ignore] = ACTIONS(615),
    [sym_ignore_inside] = ACTIONS(617),
    [sym_union] = ACTIONS(615),
    [sym_intersect] = ACTIONS(617),
    [sym_subtract] = ACTIONS(615),
    [anon_sym_EQ_GT] = ACTIONS(617),
    [anon_sym_DASH_GT] = ACTIONS(615),
    [anon_sym_LT_DASH] = ACTIONS(617),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(617),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(617),
    [anon_sym_AT_DASH_GT] = ACTIONS(617),
    [anon_sym_DASH_GT_AT] = ACTIONS(617),
    [anon_sym_AT_GT] = ACTIONS(617),
    [anon_sym_GT_AT] = ACTIONS(617),
    [anon_sym_LBRACK_DOT] = ACTIONS(617),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(617),
    [anon_sym_PIPE_PIPE] = ACTIONS(617),
    [anon_sym_SLASH_SLASH] = ACTIONS(617),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(617),
    [anon_sym_BSLASH_SLASH] = ACTIONS(617),
    [sym_crossproduct] = ACTIONS(617),
    [sym_compose] = ACTIONS(617),
    [sym_comment] = ACTIONS(3),
  },
  [459] = {
    [ts_builtin_sym_end] = ACTIONS(623),
    [sym_semicolon] = ACTIONS(621),
    [anon_sym_LBRACK] = ACTIONS(621),
    [sym_symbol] = ACTIONS(621),
    [sym_string] = ACTIONS(623),
    [sym_any] = ACTIONS(623),
    [sym_zero] = ACTIONS(623),
    [sym_boundary] = ACTIONS(623),
    [sym_symbol_group] = ACTIONS(623),
    [anon_sym_LPAREN] = ACTIONS(621),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_COMMA] = ACTIONS(621),
    [sym_colon] = ACTIONS(623),
    [sym_complement] = ACTIONS(623),
    [sym_term_complement] = ACTIONS(621),
    [sym_contains] = ACTIONS(623),
    [sym_plus] = ACTIONS(623),
    [sym_star] = ACTIONS(623),
    [sym_repeat] = ACTIONS(623),
    [sym_upper] = ACTIONS(623),
    [sym_lower] = ACTIONS(623),
    [sym_reverse] = ACTIONS(623),
    [sym_inverse] = ACTIONS(623),
    [sym_ignore] = ACTIONS(621),
    [sym_ignore_inside] = ACTIONS(623),
    [sym_union] = ACTIONS(621),
    [sym_intersect] = ACTIONS(623),
    [sym_subtract] = ACTIONS(621),
    [anon_sym_EQ_GT] = ACTIONS(623),
    [anon_sym_DASH_GT] = ACTIONS(621),
    [anon_sym_LT_DASH] = ACTIONS(623),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(623),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(623),
    [anon_sym_AT_DASH_GT] = ACTIONS(623),
    [anon_sym_DASH_GT_AT] = ACTIONS(623),
    [anon_sym_AT_GT] = ACTIONS(623),
    [anon_sym_GT_AT] = ACTIONS(623),
    [anon_sym_LBRACK_DOT] = ACTIONS(623),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [anon_sym_SLASH_SLASH] = ACTIONS(623),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(623),
    [anon_sym_BSLASH_SLASH] = ACTIONS(623),
    [anon_sym_COMMA_COMMA] = ACTIONS(623),
    [sym_crossproduct] = ACTIONS(623),
    [sym_compose] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
  },
  [460] = {
    [aux_sym_parallel_replace_repeat1] = STATE(460),
    [ts_builtin_sym_end] = ACTIONS(473),
    [sym_semicolon] = ACTIONS(471),
    [anon_sym_LBRACK] = ACTIONS(471),
    [sym_symbol] = ACTIONS(471),
    [sym_string] = ACTIONS(473),
    [sym_any] = ACTIONS(473),
    [sym_zero] = ACTIONS(473),
    [sym_boundary] = ACTIONS(473),
    [sym_symbol_group] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_BQUOTE] = ACTIONS(473),
    [anon_sym_COMMA] = ACTIONS(710),
    [sym_colon] = ACTIONS(473),
    [sym_complement] = ACTIONS(473),
    [sym_term_complement] = ACTIONS(471),
    [sym_contains] = ACTIONS(473),
    [sym_plus] = ACTIONS(473),
    [sym_star] = ACTIONS(473),
    [sym_repeat] = ACTIONS(473),
    [sym_upper] = ACTIONS(473),
    [sym_lower] = ACTIONS(473),
    [sym_reverse] = ACTIONS(473),
    [sym_inverse] = ACTIONS(473),
    [sym_ignore] = ACTIONS(471),
    [sym_ignore_inside] = ACTIONS(473),
    [sym_union] = ACTIONS(471),
    [sym_intersect] = ACTIONS(473),
    [sym_subtract] = ACTIONS(471),
    [anon_sym_EQ_GT] = ACTIONS(473),
    [anon_sym_DASH_GT] = ACTIONS(471),
    [anon_sym_LT_DASH] = ACTIONS(473),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(473),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(473),
    [anon_sym_AT_DASH_GT] = ACTIONS(473),
    [anon_sym_DASH_GT_AT] = ACTIONS(473),
    [anon_sym_AT_GT] = ACTIONS(473),
    [anon_sym_GT_AT] = ACTIONS(473),
    [anon_sym_LBRACK_DOT] = ACTIONS(473),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(473),
    [anon_sym_PIPE_PIPE] = ACTIONS(473),
    [anon_sym_SLASH_SLASH] = ACTIONS(473),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(473),
    [anon_sym_BSLASH_SLASH] = ACTIONS(473),
    [sym_crossproduct] = ACTIONS(473),
    [sym_compose] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [461] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(461),
    [ts_builtin_sym_end] = ACTIONS(589),
    [sym_semicolon] = ACTIONS(587),
    [anon_sym_LBRACK] = ACTIONS(587),
    [sym_symbol] = ACTIONS(587),
    [sym_string] = ACTIONS(589),
    [sym_any] = ACTIONS(589),
    [sym_zero] = ACTIONS(589),
    [sym_boundary] = ACTIONS(589),
    [sym_symbol_group] = ACTIONS(589),
    [anon_sym_LPAREN] = ACTIONS(587),
    [anon_sym_BQUOTE] = ACTIONS(589),
    [anon_sym_COMMA] = ACTIONS(587),
    [sym_colon] = ACTIONS(589),
    [sym_complement] = ACTIONS(589),
    [sym_term_complement] = ACTIONS(587),
    [sym_contains] = ACTIONS(589),
    [sym_plus] = ACTIONS(589),
    [sym_star] = ACTIONS(589),
    [sym_repeat] = ACTIONS(589),
    [sym_upper] = ACTIONS(589),
    [sym_lower] = ACTIONS(589),
    [sym_reverse] = ACTIONS(589),
    [sym_inverse] = ACTIONS(589),
    [sym_ignore] = ACTIONS(587),
    [sym_ignore_inside] = ACTIONS(589),
    [sym_union] = ACTIONS(587),
    [sym_intersect] = ACTIONS(589),
    [sym_subtract] = ACTIONS(587),
    [anon_sym_EQ_GT] = ACTIONS(589),
    [anon_sym_DASH_GT] = ACTIONS(587),
    [anon_sym_LT_DASH] = ACTIONS(589),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(589),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(589),
    [anon_sym_AT_DASH_GT] = ACTIONS(589),
    [anon_sym_DASH_GT_AT] = ACTIONS(589),
    [anon_sym_AT_GT] = ACTIONS(589),
    [anon_sym_GT_AT] = ACTIONS(589),
    [anon_sym_LBRACK_DOT] = ACTIONS(589),
    [anon_sym_PIPE_PIPE] = ACTIONS(589),
    [anon_sym_SLASH_SLASH] = ACTIONS(589),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(589),
    [anon_sym_BSLASH_SLASH] = ACTIONS(589),
    [anon_sym_COMMA_COMMA] = ACTIONS(713),
    [sym_crossproduct] = ACTIONS(589),
    [sym_compose] = ACTIONS(589),
    [sym_comment] = ACTIONS(3),
  },
  [462] = {
    [aux_sym_context_list_repeat1] = STATE(486),
    [ts_builtin_sym_end] = ACTIONS(609),
    [sym_semicolon] = ACTIONS(607),
    [anon_sym_LBRACK] = ACTIONS(607),
    [sym_symbol] = ACTIONS(607),
    [sym_string] = ACTIONS(609),
    [sym_any] = ACTIONS(609),
    [sym_zero] = ACTIONS(609),
    [sym_boundary] = ACTIONS(609),
    [sym_symbol_group] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(607),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(607),
    [sym_colon] = ACTIONS(609),
    [sym_complement] = ACTIONS(609),
    [sym_term_complement] = ACTIONS(607),
    [sym_contains] = ACTIONS(609),
    [sym_plus] = ACTIONS(609),
    [sym_star] = ACTIONS(609),
    [sym_repeat] = ACTIONS(609),
    [sym_upper] = ACTIONS(609),
    [sym_lower] = ACTIONS(609),
    [sym_reverse] = ACTIONS(609),
    [sym_inverse] = ACTIONS(609),
    [sym_ignore] = ACTIONS(607),
    [sym_ignore_inside] = ACTIONS(609),
    [sym_union] = ACTIONS(607),
    [sym_intersect] = ACTIONS(609),
    [sym_subtract] = ACTIONS(607),
    [anon_sym_EQ_GT] = ACTIONS(609),
    [anon_sym_DASH_GT] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(609),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(609),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(609),
    [anon_sym_AT_DASH_GT] = ACTIONS(609),
    [anon_sym_DASH_GT_AT] = ACTIONS(609),
    [anon_sym_AT_GT] = ACTIONS(609),
    [anon_sym_GT_AT] = ACTIONS(609),
    [anon_sym_LBRACK_DOT] = ACTIONS(609),
    [anon_sym_PIPE_PIPE] = ACTIONS(609),
    [anon_sym_SLASH_SLASH] = ACTIONS(609),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(609),
    [anon_sym_BSLASH_SLASH] = ACTIONS(609),
    [anon_sym_COMMA_COMMA] = ACTIONS(609),
    [sym_crossproduct] = ACTIONS(609),
    [sym_compose] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
  },
  [463] = {
    [sym_condition_operators] = STATE(660),
    [aux_sym_parallel_replace_repeat1] = STATE(527),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(695),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_SLASH_SLASH] = ACTIONS(541),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(541),
    [anon_sym_BSLASH_SLASH] = ACTIONS(541),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [464] = {
    [aux_sym_parallel_conditional_replace_repeat1] = STATE(456),
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_semicolon] = ACTIONS(535),
    [anon_sym_LBRACK] = ACTIONS(535),
    [sym_symbol] = ACTIONS(535),
    [sym_string] = ACTIONS(537),
    [sym_any] = ACTIONS(537),
    [sym_zero] = ACTIONS(537),
    [sym_boundary] = ACTIONS(537),
    [sym_symbol_group] = ACTIONS(537),
    [anon_sym_LPAREN] = ACTIONS(535),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(535),
    [sym_colon] = ACTIONS(537),
    [sym_complement] = ACTIONS(537),
    [sym_term_complement] = ACTIONS(535),
    [sym_contains] = ACTIONS(537),
    [sym_plus] = ACTIONS(537),
    [sym_star] = ACTIONS(537),
    [sym_repeat] = ACTIONS(537),
    [sym_upper] = ACTIONS(537),
    [sym_lower] = ACTIONS(537),
    [sym_reverse] = ACTIONS(537),
    [sym_inverse] = ACTIONS(537),
    [sym_ignore] = ACTIONS(535),
    [sym_ignore_inside] = ACTIONS(537),
    [sym_union] = ACTIONS(535),
    [sym_intersect] = ACTIONS(537),
    [sym_subtract] = ACTIONS(535),
    [anon_sym_EQ_GT] = ACTIONS(537),
    [anon_sym_DASH_GT] = ACTIONS(535),
    [anon_sym_LT_DASH] = ACTIONS(537),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(537),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(537),
    [anon_sym_AT_DASH_GT] = ACTIONS(537),
    [anon_sym_DASH_GT_AT] = ACTIONS(537),
    [anon_sym_AT_GT] = ACTIONS(537),
    [anon_sym_GT_AT] = ACTIONS(537),
    [anon_sym_LBRACK_DOT] = ACTIONS(537),
    [anon_sym_PIPE_PIPE] = ACTIONS(537),
    [anon_sym_SLASH_SLASH] = ACTIONS(537),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(537),
    [anon_sym_BSLASH_SLASH] = ACTIONS(537),
    [anon_sym_COMMA_COMMA] = ACTIONS(699),
    [sym_crossproduct] = ACTIONS(537),
    [sym_compose] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
  },
  [465] = {
    [aux_sym_parallel_replace_repeat1] = STATE(460),
    [ts_builtin_sym_end] = ACTIONS(613),
    [sym_semicolon] = ACTIONS(611),
    [anon_sym_LBRACK] = ACTIONS(611),
    [sym_symbol] = ACTIONS(611),
    [sym_string] = ACTIONS(613),
    [sym_any] = ACTIONS(613),
    [sym_zero] = ACTIONS(613),
    [sym_boundary] = ACTIONS(613),
    [sym_symbol_group] = ACTIONS(613),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_BQUOTE] = ACTIONS(613),
    [anon_sym_COMMA] = ACTIONS(613),
    [sym_colon] = ACTIONS(613),
    [sym_complement] = ACTIONS(613),
    [sym_term_complement] = ACTIONS(611),
    [sym_contains] = ACTIONS(613),
    [sym_plus] = ACTIONS(613),
    [sym_star] = ACTIONS(613),
    [sym_repeat] = ACTIONS(613),
    [sym_upper] = ACTIONS(613),
    [sym_lower] = ACTIONS(613),
    [sym_reverse] = ACTIONS(613),
    [sym_inverse] = ACTIONS(613),
    [sym_ignore] = ACTIONS(611),
    [sym_ignore_inside] = ACTIONS(613),
    [sym_union] = ACTIONS(611),
    [sym_intersect] = ACTIONS(613),
    [sym_subtract] = ACTIONS(611),
    [anon_sym_EQ_GT] = ACTIONS(613),
    [anon_sym_DASH_GT] = ACTIONS(611),
    [anon_sym_LT_DASH] = ACTIONS(613),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(613),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(613),
    [anon_sym_AT_DASH_GT] = ACTIONS(613),
    [anon_sym_DASH_GT_AT] = ACTIONS(613),
    [anon_sym_AT_GT] = ACTIONS(613),
    [anon_sym_GT_AT] = ACTIONS(613),
    [anon_sym_LBRACK_DOT] = ACTIONS(613),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(613),
    [anon_sym_PIPE_PIPE] = ACTIONS(613),
    [anon_sym_SLASH_SLASH] = ACTIONS(613),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(613),
    [anon_sym_BSLASH_SLASH] = ACTIONS(613),
    [sym_crossproduct] = ACTIONS(613),
    [sym_compose] = ACTIONS(613),
    [sym_comment] = ACTIONS(3),
  },
  [466] = {
    [aux_sym_context_list_repeat1] = STATE(452),
    [ts_builtin_sym_end] = ACTIONS(609),
    [sym_semicolon] = ACTIONS(607),
    [anon_sym_LBRACK] = ACTIONS(607),
    [sym_symbol] = ACTIONS(607),
    [sym_string] = ACTIONS(609),
    [sym_any] = ACTIONS(609),
    [sym_zero] = ACTIONS(609),
    [sym_boundary] = ACTIONS(609),
    [sym_symbol_group] = ACTIONS(609),
    [anon_sym_LPAREN] = ACTIONS(607),
    [anon_sym_BQUOTE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(609),
    [sym_colon] = ACTIONS(609),
    [sym_complement] = ACTIONS(609),
    [sym_term_complement] = ACTIONS(607),
    [sym_contains] = ACTIONS(609),
    [sym_plus] = ACTIONS(609),
    [sym_star] = ACTIONS(609),
    [sym_repeat] = ACTIONS(609),
    [sym_upper] = ACTIONS(609),
    [sym_lower] = ACTIONS(609),
    [sym_reverse] = ACTIONS(609),
    [sym_inverse] = ACTIONS(609),
    [sym_ignore] = ACTIONS(607),
    [sym_ignore_inside] = ACTIONS(609),
    [sym_union] = ACTIONS(607),
    [sym_intersect] = ACTIONS(609),
    [sym_subtract] = ACTIONS(607),
    [anon_sym_EQ_GT] = ACTIONS(609),
    [anon_sym_DASH_GT] = ACTIONS(607),
    [anon_sym_LT_DASH] = ACTIONS(609),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(609),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(609),
    [anon_sym_AT_DASH_GT] = ACTIONS(609),
    [anon_sym_DASH_GT_AT] = ACTIONS(609),
    [anon_sym_AT_GT] = ACTIONS(609),
    [anon_sym_GT_AT] = ACTIONS(609),
    [anon_sym_LBRACK_DOT] = ACTIONS(609),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(609),
    [anon_sym_PIPE_PIPE] = ACTIONS(609),
    [anon_sym_SLASH_SLASH] = ACTIONS(609),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(609),
    [anon_sym_BSLASH_SLASH] = ACTIONS(609),
    [sym_crossproduct] = ACTIONS(609),
    [sym_compose] = ACTIONS(609),
    [sym_comment] = ACTIONS(3),
  },
  [467] = {
    [ts_builtin_sym_end] = ACTIONS(678),
    [sym_semicolon] = ACTIONS(676),
    [anon_sym_LBRACK] = ACTIONS(676),
    [sym_symbol] = ACTIONS(676),
    [sym_string] = ACTIONS(678),
    [sym_any] = ACTIONS(678),
    [sym_zero] = ACTIONS(678),
    [sym_boundary] = ACTIONS(678),
    [sym_symbol_group] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(676),
    [anon_sym_BQUOTE] = ACTIONS(678),
    [anon_sym_COMMA] = ACTIONS(676),
    [sym_colon] = ACTIONS(678),
    [sym_complement] = ACTIONS(678),
    [sym_term_complement] = ACTIONS(676),
    [sym_contains] = ACTIONS(678),
    [sym_plus] = ACTIONS(678),
    [sym_star] = ACTIONS(678),
    [sym_repeat] = ACTIONS(678),
    [sym_upper] = ACTIONS(678),
    [sym_lower] = ACTIONS(678),
    [sym_reverse] = ACTIONS(678),
    [sym_inverse] = ACTIONS(678),
    [sym_ignore] = ACTIONS(676),
    [sym_ignore_inside] = ACTIONS(678),
    [sym_union] = ACTIONS(676),
    [sym_intersect] = ACTIONS(678),
    [sym_subtract] = ACTIONS(676),
    [anon_sym_EQ_GT] = ACTIONS(678),
    [anon_sym_DASH_GT] = ACTIONS(676),
    [anon_sym_LT_DASH] = ACTIONS(678),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(678),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(678),
    [anon_sym_AT_DASH_GT] = ACTIONS(678),
    [anon_sym_DASH_GT_AT] = ACTIONS(678),
    [anon_sym_AT_GT] = ACTIONS(678),
    [anon_sym_GT_AT] = ACTIONS(678),
    [anon_sym_LBRACK_DOT] = ACTIONS(678),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(678),
    [anon_sym_PIPE_PIPE] = ACTIONS(678),
    [anon_sym_SLASH_SLASH] = ACTIONS(678),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(678),
    [anon_sym_BSLASH_SLASH] = ACTIONS(678),
    [anon_sym_COMMA_COMMA] = ACTIONS(678),
    [sym_crossproduct] = ACTIONS(678),
    [sym_compose] = ACTIONS(678),
    [sym_comment] = ACTIONS(3),
  },
  [468] = {
    [ts_builtin_sym_end] = ACTIONS(661),
    [sym_semicolon] = ACTIONS(659),
    [anon_sym_LBRACK] = ACTIONS(659),
    [sym_symbol] = ACTIONS(659),
    [sym_string] = ACTIONS(661),
    [sym_any] = ACTIONS(661),
    [sym_zero] = ACTIONS(661),
    [sym_boundary] = ACTIONS(661),
    [sym_symbol_group] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(659),
    [anon_sym_BQUOTE] = ACTIONS(661),
    [anon_sym_COMMA] = ACTIONS(659),
    [sym_colon] = ACTIONS(661),
    [sym_complement] = ACTIONS(661),
    [sym_term_complement] = ACTIONS(659),
    [sym_contains] = ACTIONS(661),
    [sym_plus] = ACTIONS(661),
    [sym_star] = ACTIONS(661),
    [sym_repeat] = ACTIONS(661),
    [sym_upper] = ACTIONS(661),
    [sym_lower] = ACTIONS(661),
    [sym_reverse] = ACTIONS(661),
    [sym_inverse] = ACTIONS(661),
    [sym_ignore] = ACTIONS(659),
    [sym_ignore_inside] = ACTIONS(661),
    [sym_union] = ACTIONS(659),
    [sym_intersect] = ACTIONS(661),
    [sym_subtract] = ACTIONS(659),
    [anon_sym_EQ_GT] = ACTIONS(661),
    [anon_sym_DASH_GT] = ACTIONS(659),
    [anon_sym_LT_DASH] = ACTIONS(661),
    [anon_sym_LPAREN_DASH_GT_RPAREN] = ACTIONS(661),
    [anon_sym_LPAREN_LT_DASH_RPAREN] = ACTIONS(661),
    [anon_sym_AT_DASH_GT] = ACTIONS(661),
    [anon_sym_DASH_GT_AT] = ACTIONS(661),
    [anon_sym_AT_GT] = ACTIONS(661),
    [anon_sym_GT_AT] = ACTIONS(661),
    [anon_sym_LBRACK_DOT] = ACTIONS(661),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(661),
    [anon_sym_PIPE_PIPE] = ACTIONS(661),
    [anon_sym_SLASH_SLASH] = ACTIONS(661),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(661),
    [anon_sym_BSLASH_SLASH] = ACTIONS(6