#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 382
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 72
#define ALIAS_COUNT 1
#define TOKEN_COUNT 29
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 16
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 52

enum {
  sym_pattern_start = 1,
  sym_named_pattern_start = 2,
  sym_lexicon_start = 3,
  sym_alias = 4,
  sym_left_sieve = 5,
  sym_right_sieve = 6,
  anon_sym_PIPE = 7,
  sym_colon = 8,
  sym_question_op = 9,
  sym_star_op = 10,
  sym_plus_op = 11,
  anon_sym_LPAREN = 12,
  anon_sym_RPAREN = 13,
  anon_sym_DASH = 14,
  anon_sym_COMMA = 15,
  anon_sym_LBRACK = 16,
  anon_sym_RBRACK = 17,
  anon_sym_CARET = 18,
  sym_regex_string = 19,
  anon_sym_SLASH = 20,
  sym_lexicon_string = 21,
  sym_escaped_char = 22,
  sym_comment = 23,
  sym_identifier = 24,
  sym_tag = 25,
  sym_number = 26,
  sym__real_nl = 27,
  sym__ws = 28,
  sym_source_file = 29,
  sym_pattern_block = 30,
  sym_pattern_or = 31,
  sym_pattern_line = 32,
  sym_anonymous_pattern = 33,
  sym_pattern_option = 34,
  sym_pattern_operator = 35,
  sym_lexicon_reference = 36,
  sym_pattern_token = 37,
  sym_neg_tag = 38,
  sym__tag_or_neg = 39,
  sym__tag_list = 40,
  sym_tag_setting = 41,
  sym_tag_distribution_operator = 42,
  sym_tag_distribution = 43,
  sym__tag_filter_segment = 44,
  sym_tag_filter = 45,
  sym_anonymous_lexicon = 46,
  sym_lexicon_block = 47,
  sym_lexicon_line = 48,
  sym_regex_char_class = 49,
  aux_sym__plain_regex_string = 50,
  sym_regex_line = 51,
  sym_regex_group = 52,
  sym_regex = 53,
  sym__lexicon_side_left = 54,
  aux_sym__lexicon_side_right = 55,
  sym_lexicon_segment = 56,
  sym__end_com = 57,
  sym_alias_command = 58,
  sym_block_comment = 59,
  sym__nl = 60,
  aux_sym_source_file_repeat1 = 61,
  aux_sym_pattern_block_repeat1 = 62,
  aux_sym_pattern_line_repeat1 = 63,
  aux_sym__tag_list_repeat1 = 64,
  aux_sym_tag_filter_repeat1 = 65,
  aux_sym_lexicon_block_repeat1 = 66,
  aux_sym_lexicon_line_repeat1 = 67,
  aux_sym_regex_char_class_repeat1 = 68,
  aux_sym_regex_group_repeat1 = 69,
  aux_sym_regex_repeat1 = 70,
  aux_sym_block_comment_repeat1 = 71,
  anon_alias_sym_flattened_operator = 72,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_pattern_start] = "pattern_start",
  [sym_named_pattern_start] = "named_pattern_start",
  [sym_lexicon_start] = "lexicon_start",
  [sym_alias] = "alias",
  [sym_left_sieve] = "left_sieve",
  [sym_right_sieve] = "right_sieve",
  [anon_sym_PIPE] = "|",
  [sym_colon] = "colon",
  [sym_question_op] = "question_op",
  [sym_star_op] = "star_op",
  [sym_plus_op] = "plus_op",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DASH] = "-",
  [anon_sym_COMMA] = ",",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_CARET] = "^",
  [sym_regex_string] = "regex_string",
  [anon_sym_SLASH] = "/",
  [sym_lexicon_string] = "lexicon_string",
  [sym_escaped_char] = "escaped_char",
  [sym_comment] = "comment",
  [sym_identifier] = "identifier",
  [sym_tag] = "tag",
  [sym_number] = "number",
  [sym__real_nl] = "_real_nl",
  [sym__ws] = "_ws",
  [sym_source_file] = "source_file",
  [sym_pattern_block] = "pattern_block",
  [sym_pattern_or] = "pattern_or",
  [sym_pattern_line] = "pattern_line",
  [sym_anonymous_pattern] = "anonymous_pattern",
  [sym_pattern_option] = "pattern_option",
  [sym_pattern_operator] = "pattern_operator",
  [sym_lexicon_reference] = "lexicon_reference",
  [sym_pattern_token] = "pattern_token",
  [sym_neg_tag] = "neg_tag",
  [sym__tag_or_neg] = "_tag_or_neg",
  [sym__tag_list] = "_tag_list",
  [sym_tag_setting] = "tag_setting",
  [sym_tag_distribution_operator] = "tag_distribution_operator",
  [sym_tag_distribution] = "tag_distribution",
  [sym__tag_filter_segment] = "_tag_filter_segment",
  [sym_tag_filter] = "tag_filter",
  [sym_anonymous_lexicon] = "anonymous_lexicon",
  [sym_lexicon_block] = "lexicon_block",
  [sym_lexicon_line] = "lexicon_line",
  [sym_regex_char_class] = "regex_char_class",
  [aux_sym__plain_regex_string] = "_plain_regex_string",
  [sym_regex_line] = "regex_line",
  [sym_regex_group] = "regex_group",
  [sym_regex] = "regex",
  [sym__lexicon_side_left] = "_lexicon_side_left",
  [aux_sym__lexicon_side_right] = "_lexicon_side_right",
  [sym_lexicon_segment] = "lexicon_segment",
  [sym__end_com] = "_end_com",
  [sym_alias_command] = "alias_command",
  [sym_block_comment] = "block_comment",
  [sym__nl] = "_nl",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_pattern_block_repeat1] = "pattern_block_repeat1",
  [aux_sym_pattern_line_repeat1] = "pattern_line_repeat1",
  [aux_sym__tag_list_repeat1] = "_tag_list_repeat1",
  [aux_sym_tag_filter_repeat1] = "tag_filter_repeat1",
  [aux_sym_lexicon_block_repeat1] = "lexicon_block_repeat1",
  [aux_sym_lexicon_line_repeat1] = "lexicon_line_repeat1",
  [aux_sym_regex_char_class_repeat1] = "regex_char_class_repeat1",
  [aux_sym_regex_group_repeat1] = "regex_group_repeat1",
  [aux_sym_regex_repeat1] = "regex_repeat1",
  [aux_sym_block_comment_repeat1] = "block_comment_repeat1",
  [anon_alias_sym_flattened_operator] = "flattened_operator",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_pattern_start] = sym_pattern_start,
  [sym_named_pattern_start] = sym_named_pattern_start,
  [sym_lexicon_start] = sym_lexicon_start,
  [sym_alias] = sym_alias,
  [sym_left_sieve] = sym_left_sieve,
  [sym_right_sieve] = sym_right_sieve,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [sym_colon] = sym_colon,
  [sym_question_op] = sym_question_op,
  [sym_star_op] = sym_star_op,
  [sym_plus_op] = sym_plus_op,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_CARET] = anon_sym_CARET,
  [sym_regex_string] = sym_regex_string,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_lexicon_string] = sym_lexicon_string,
  [sym_escaped_char] = sym_escaped_char,
  [sym_comment] = sym_comment,
  [sym_identifier] = sym_identifier,
  [sym_tag] = sym_tag,
  [sym_number] = sym_number,
  [sym__real_nl] = sym__real_nl,
  [sym__ws] = sym__ws,
  [sym_source_file] = sym_source_file,
  [sym_pattern_block] = sym_pattern_block,
  [sym_pattern_or] = sym_pattern_or,
  [sym_pattern_line] = sym_pattern_line,
  [sym_anonymous_pattern] = sym_anonymous_pattern,
  [sym_pattern_option] = sym_pattern_option,
  [sym_pattern_operator] = sym_pattern_operator,
  [sym_lexicon_reference] = sym_lexicon_reference,
  [sym_pattern_token] = sym_pattern_token,
  [sym_neg_tag] = sym_neg_tag,
  [sym__tag_or_neg] = sym__tag_or_neg,
  [sym__tag_list] = sym__tag_list,
  [sym_tag_setting] = sym_tag_setting,
  [sym_tag_distribution_operator] = sym_tag_distribution_operator,
  [sym_tag_distribution] = sym_tag_distribution,
  [sym__tag_filter_segment] = sym__tag_filter_segment,
  [sym_tag_filter] = sym_tag_filter,
  [sym_anonymous_lexicon] = sym_anonymous_lexicon,
  [sym_lexicon_block] = sym_lexicon_block,
  [sym_lexicon_line] = sym_lexicon_line,
  [sym_regex_char_class] = sym_regex_char_class,
  [aux_sym__plain_regex_string] = aux_sym__plain_regex_string,
  [sym_regex_line] = sym_regex_line,
  [sym_regex_group] = sym_regex_group,
  [sym_regex] = sym_regex,
  [sym__lexicon_side_left] = sym__lexicon_side_left,
  [aux_sym__lexicon_side_right] = aux_sym__lexicon_side_right,
  [sym_lexicon_segment] = sym_lexicon_segment,
  [sym__end_com] = sym__end_com,
  [sym_alias_command] = sym_alias_command,
  [sym_block_comment] = sym_block_comment,
  [sym__nl] = sym__nl,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_pattern_block_repeat1] = aux_sym_pattern_block_repeat1,
  [aux_sym_pattern_line_repeat1] = aux_sym_pattern_line_repeat1,
  [aux_sym__tag_list_repeat1] = aux_sym__tag_list_repeat1,
  [aux_sym_tag_filter_repeat1] = aux_sym_tag_filter_repeat1,
  [aux_sym_lexicon_block_repeat1] = aux_sym_lexicon_block_repeat1,
  [aux_sym_lexicon_line_repeat1] = aux_sym_lexicon_line_repeat1,
  [aux_sym_regex_char_class_repeat1] = aux_sym_regex_char_class_repeat1,
  [aux_sym_regex_group_repeat1] = aux_sym_regex_group_repeat1,
  [aux_sym_regex_repeat1] = aux_sym_regex_repeat1,
  [aux_sym_block_comment_repeat1] = aux_sym_block_comment_repeat1,
  [anon_alias_sym_flattened_operator] = anon_alias_sym_flattened_operator,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_pattern_start] = {
    .visible = true,
    .named = true,
  },
  [sym_named_pattern_start] = {
    .visible = true,
    .named = true,
  },
  [sym_lexicon_start] = {
    .visible = true,
    .named = true,
  },
  [sym_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_left_sieve] = {
    .visible = true,
    .named = true,
  },
  [sym_right_sieve] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_question_op] = {
    .visible = true,
    .named = true,
  },
  [sym_star_op] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_op] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_lexicon_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escaped_char] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym__real_nl] = {
    .visible = false,
    .named = true,
  },
  [sym__ws] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_or] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_line] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_option] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lexicon_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_token] = {
    .visible = true,
    .named = true,
  },
  [sym_neg_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__tag_or_neg] = {
    .visible = false,
    .named = true,
  },
  [sym__tag_list] = {
    .visible = false,
    .named = true,
  },
  [sym_tag_setting] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_distribution_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_distribution] = {
    .visible = true,
    .named = true,
  },
  [sym__tag_filter_segment] = {
    .visible = false,
    .named = true,
  },
  [sym_tag_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_lexicon] = {
    .visible = true,
    .named = true,
  },
  [sym_lexicon_block] = {
    .visible = true,
    .named = true,
  },
  [sym_lexicon_line] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_char_class] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__plain_regex_string] = {
    .visible = false,
    .named = false,
  },
  [sym_regex_line] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_group] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym__lexicon_side_left] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__lexicon_side_right] = {
    .visible = false,
    .named = false,
  },
  [sym_lexicon_segment] = {
    .visible = true,
    .named = true,
  },
  [sym__end_com] = {
    .visible = false,
    .named = true,
  },
  [sym_alias_command] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__nl] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__tag_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tag_filter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lexicon_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lexicon_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_regex_char_class_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_regex_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_regex_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_flattened_operator] = {
    .visible = true,
    .named = false,
  },
};

enum {
  field_column = 1,
  field_columns = 2,
  field_comment = 3,
  field_defaults = 4,
  field_disjoint = 5,
  field_filter = 6,
  field_left = 7,
  field_name = 8,
  field_op = 9,
  field_operator = 10,
  field_right = 11,
  field_src = 12,
  field_tag = 13,
  field_tags = 14,
  field_trg = 15,
  field_whole = 16,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_column] = "column",
  [field_columns] = "columns",
  [field_comment] = "comment",
  [field_defaults] = "defaults",
  [field_disjoint] = "disjoint",
  [field_filter] = "filter",
  [field_left] = "left",
  [field_name] = "name",
  [field_op] = "op",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_src] = "src",
  [field_tag] = "tag",
  [field_tags] = "tags",
  [field_trg] = "trg",
  [field_whole] = "whole",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 2},
  [9] = {.index = 10, .length = 2},
  [10] = {.index = 12, .length = 2},
  [11] = {.index = 14, .length = 1},
  [12] = {.index = 15, .length = 2},
  [13] = {.index = 17, .length = 1},
  [14] = {.index = 18, .length = 1},
  [15] = {.index = 19, .length = 2},
  [16] = {.index = 21, .length = 2},
  [17] = {.index = 23, .length = 3},
  [18] = {.index = 26, .length = 3},
  [19] = {.index = 29, .length = 3},
  [20] = {.index = 32, .length = 2},
  [21] = {.index = 34, .length = 2},
  [23] = {.index = 36, .length = 1},
  [24] = {.index = 37, .length = 2},
  [25] = {.index = 39, .length = 1},
  [26] = {.index = 40, .length = 2},
  [27] = {.index = 42, .length = 2},
  [28] = {.index = 44, .length = 3},
  [29] = {.index = 47, .length = 2},
  [30] = {.index = 49, .length = 2},
  [31] = {.index = 51, .length = 4},
  [32] = {.index = 55, .length = 1},
  [33] = {.index = 56, .length = 3},
  [35] = {.index = 59, .length = 2},
  [36] = {.index = 61, .length = 2},
  [37] = {.index = 63, .length = 2},
  [38] = {.index = 65, .length = 2},
  [39] = {.index = 67, .length = 3},
  [40] = {.index = 70, .length = 3},
  [41] = {.index = 73, .length = 3},
  [42] = {.index = 76, .length = 3},
  [44] = {.index = 79, .length = 3},
  [45] = {.index = 82, .length = 3},
  [46] = {.index = 85, .length = 3},
  [47] = {.index = 88, .length = 3},
  [48] = {.index = 91, .length = 4},
  [49] = {.index = 95, .length = 1},
  [50] = {.index = 96, .length = 4},
  [51] = {.index = 100, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_comment, 0},
  [1] =
    {field_comment, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_whole, 0},
  [4] =
    {field_comment, 1, .inherited = true},
  [5] =
    {field_right, 1},
  [6] =
    {field_column, 1},
    {field_name, 0},
  [8] =
    {field_filter, 1},
    {field_name, 0},
  [10] =
    {field_operator, 1},
    {field_whole, 0},
  [12] =
    {field_filter, 1},
    {field_whole, 0},
  [14] =
    {field_left, 0},
  [15] =
    {field_operator, 2},
    {field_right, 1},
  [17] =
    {field_tags, 1},
  [18] =
    {field_tags, 0},
  [19] =
    {field_tags, 0},
    {field_whole, 1},
  [21] =
    {field_tags, 1},
    {field_whole, 0},
  [23] =
    {field_column, 2},
    {field_disjoint, 1},
    {field_name, 0},
  [26] =
    {field_column, 1},
    {field_filter, 2},
    {field_name, 0},
  [29] =
    {field_filter, 1},
    {field_operator, 2},
    {field_whole, 0},
  [32] =
    {field_left, 0},
    {field_operator, 2},
  [34] =
    {field_left, 0},
    {field_right, 2},
  [36] =
    {field_name, 2},
  [37] =
    {field_right, 1},
    {field_tags, 2},
  [39] =
    {field_tag, 1},
  [40] =
    {field_tags, 0},
    {field_tags, 2},
  [42] =
    {field_right, 2},
    {field_tags, 0},
  [44] =
    {field_tags, 0},
    {field_tags, 2},
    {field_whole, 1},
  [47] =
    {field_left, 1},
    {field_tags, 0},
  [49] =
    {field_left, 0},
    {field_tags, 2},
  [51] =
    {field_column, 2},
    {field_disjoint, 1},
    {field_filter, 3},
    {field_name, 0},
  [55] =
    {field_comment, 2},
  [56] =
    {field_left, 0},
    {field_operator, 3},
    {field_right, 2},
  [59] =
    {field_comment, 3, .inherited = true},
    {field_name, 2},
  [61] =
    {field_columns, 3},
    {field_name, 2},
  [63] =
    {field_defaults, 3},
    {field_name, 2},
  [65] =
    {field_src, 2},
    {field_trg, 4},
  [67] =
    {field_right, 2},
    {field_tags, 0},
    {field_tags, 3},
  [70] =
    {field_left, 1},
    {field_tags, 0},
    {field_tags, 3},
  [73] =
    {field_left, 1},
    {field_right, 3},
    {field_tags, 0},
  [76] =
    {field_left, 0},
    {field_right, 2},
    {field_tags, 3},
  [79] =
    {field_columns, 3},
    {field_defaults, 4},
    {field_name, 2},
  [82] =
    {field_columns, 3},
    {field_comment, 4, .inherited = true},
    {field_name, 2},
  [85] =
    {field_comment, 4, .inherited = true},
    {field_defaults, 3},
    {field_name, 2},
  [88] =
    {field_comment, 5, .inherited = true},
    {field_src, 2},
    {field_trg, 4},
  [91] =
    {field_left, 1},
    {field_right, 3},
    {field_tags, 0},
    {field_tags, 4},
  [95] =
    {field_op, 0},
  [96] =
    {field_columns, 3},
    {field_comment, 5, .inherited = true},
    {field_defaults, 4},
    {field_name, 2},
  [100] =
    {field_comment, 2, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [22] = {
    [2] = anon_alias_sym_flattened_operator,
  },
  [34] = {
    [3] = anon_alias_sym_flattened_operator,
  },
  [43] = {
    [4] = anon_alias_sym_flattened_operator,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_pattern_option, 2,
    sym_pattern_option,
    anon_alias_sym_flattened_operator,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 28,
  [34] = 34,
  [35] = 35,
  [36] = 34,
  [37] = 24,
  [38] = 25,
  [39] = 26,
  [40] = 18,
  [41] = 41,
  [42] = 42,
  [43] = 41,
  [44] = 35,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 21,
  [50] = 50,
  [51] = 48,
  [52] = 50,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 30,
  [63] = 27,
  [64] = 29,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 31,
  [72] = 72,
  [73] = 60,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 68,
  [78] = 78,
  [79] = 54,
  [80] = 80,
  [81] = 42,
  [82] = 65,
  [83] = 45,
  [84] = 84,
  [85] = 53,
  [86] = 32,
  [87] = 72,
  [88] = 88,
  [89] = 46,
  [90] = 90,
  [91] = 55,
  [92] = 67,
  [93] = 61,
  [94] = 59,
  [95] = 95,
  [96] = 96,
  [97] = 74,
  [98] = 58,
  [99] = 57,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 47,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 21,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 107,
  [123] = 88,
  [124] = 102,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 131,
  [134] = 130,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 125,
  [140] = 140,
  [141] = 119,
  [142] = 101,
  [143] = 143,
  [144] = 144,
  [145] = 100,
  [146] = 110,
  [147] = 147,
  [148] = 108,
  [149] = 109,
  [150] = 150,
  [151] = 127,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 143,
  [167] = 167,
  [168] = 165,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 157,
  [177] = 116,
  [178] = 135,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 126,
  [183] = 137,
  [184] = 184,
  [185] = 32,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 42,
  [191] = 175,
  [192] = 156,
  [193] = 193,
  [194] = 138,
  [195] = 195,
  [196] = 196,
  [197] = 187,
  [198] = 188,
  [199] = 171,
  [200] = 200,
  [201] = 173,
  [202] = 202,
  [203] = 189,
  [204] = 204,
  [205] = 179,
  [206] = 170,
  [207] = 207,
  [208] = 208,
  [209] = 172,
  [210] = 186,
  [211] = 211,
  [212] = 154,
  [213] = 180,
  [214] = 214,
  [215] = 184,
  [216] = 164,
  [217] = 207,
  [218] = 169,
  [219] = 181,
  [220] = 174,
  [221] = 138,
  [222] = 163,
  [223] = 47,
  [224] = 155,
  [225] = 21,
  [226] = 32,
  [227] = 42,
  [228] = 88,
  [229] = 229,
  [230] = 47,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 233,
  [237] = 234,
  [238] = 238,
  [239] = 239,
  [240] = 233,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 241,
  [245] = 245,
  [246] = 235,
  [247] = 247,
  [248] = 248,
  [249] = 232,
  [250] = 204,
  [251] = 251,
  [252] = 252,
  [253] = 241,
  [254] = 88,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 262,
  [266] = 258,
  [267] = 267,
  [268] = 264,
  [269] = 261,
  [270] = 270,
  [271] = 263,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 251,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 274,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 275,
  [299] = 259,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 279,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 297,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 306,
  [314] = 314,
  [315] = 302,
  [316] = 308,
  [317] = 283,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 290,
  [322] = 322,
  [323] = 323,
  [324] = 304,
  [325] = 325,
  [326] = 326,
  [327] = 295,
  [328] = 296,
  [329] = 329,
  [330] = 287,
  [331] = 331,
  [332] = 332,
  [333] = 323,
  [334] = 334,
  [335] = 294,
  [336] = 311,
  [337] = 331,
  [338] = 334,
  [339] = 259,
  [340] = 275,
  [341] = 341,
  [342] = 318,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 344,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 347,
  [360] = 360,
  [361] = 352,
  [362] = 362,
  [363] = 357,
  [364] = 364,
  [365] = 360,
  [366] = 354,
  [367] = 367,
  [368] = 346,
  [369] = 354,
  [370] = 360,
  [371] = 346,
  [372] = 346,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 353,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
};

static inline bool sym_regex_string_character_set_1(int32_t c) {
  return (c < '('
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '#'
        ? c == ' '
        : c <= '#')))
    : (c <= '+' || (c < '?'
      ? (c < ':'
        ? c == '/'
        : c <= ':')
      : (c <= '?' || (c >= '[' && c <= ']')))));
}

static inline bool sym_comment_character_set_1(int32_t c) {
  return (c < '<'
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < ':'
        ? (c >= '(' && c <= '+')
        : c <= ':')))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? (c >= '>' && c <= '?')
        : c <= '[')
      : (c <= ']' || c == '|'))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < ':'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '('
        ? c == ' '
        : c <= '+')))
    : (c <= ':' || (c < '['
      ? (c < '>'
        ? c == '<'
        : c <= '?')
      : (c <= '[' || (c < '|'
        ? c == ']'
        : c <= '|')))));
}

static inline bool sym_tag_character_set_1(int32_t c) {
  return (c < '<'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '('
        ? c == ' '
        : c <= ',')))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? (c >= '>' && c <= '?')
        : c <= '[')
      : (c <= '^' || c == '|'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(38);
      if (lookahead == '#') ADVANCE(82);
      if (lookahead == '(') ADVANCE(54);
      if (lookahead == ')') ADVANCE(55);
      if (lookahead == '*') ADVANCE(51);
      if (lookahead == '+') ADVANCE(52);
      if (lookahead == ',') ADVANCE(57);
      if (lookahead == '-') ADVANCE(56);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == '?') ADVANCE(50);
      if (lookahead == 'A') ADVANCE(23);
      if (lookahead == 'L') ADVANCE(19);
      if (lookahead == 'P') ADVANCE(16);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == ']') ADVANCE(59);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == '|') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(105);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(102);
      if (lookahead == '\r') SKIP(1)
      if (lookahead == '#') ADVANCE(82);
      if (lookahead == 'A') ADVANCE(23);
      if (lookahead == 'L') ADVANCE(19);
      if (lookahead == 'P') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(103);
      if (lookahead == '\r') SKIP(2)
      if (lookahead == '#') ADVANCE(81);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == '*') ADVANCE(51);
      if (lookahead == '+') ADVANCE(52);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == '?') ADVANCE(50);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '|') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(104);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ']') ADVANCE(99);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(103);
      if (lookahead == '\r') SKIP(3)
      if (lookahead == '#') ADVANCE(81);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '|') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(3);
      if (lookahead != 0 &&
          (lookahead < ')' || '+' < lookahead) &&
          lookahead != '?' &&
          lookahead != ']') ADVANCE(99);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(103);
      if (lookahead == '\r') SKIP(4)
      if (lookahead == '#') ADVANCE(82);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(104);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(79);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(103);
      if (lookahead == '\r') SKIP(5)
      if (lookahead == '#') ADVANCE(81);
      if (lookahead == '(') ADVANCE(54);
      if (lookahead == '*') ADVANCE(51);
      if (lookahead == '+') ADVANCE(52);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == '?') ADVANCE(50);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '|') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(104);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ']') ADVANCE(99);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(82);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == ']') ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead != 0) ADVANCE(79);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(81);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(107);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(7)
      if (lookahead != 0 &&
          (lookahead < ')' || '+' < lookahead) &&
          lookahead != '?' &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(99);
      END_STATE();
    case 8:
      if (lookahead == '(') ADVANCE(54);
      if (lookahead == ')') ADVANCE(55);
      if (lookahead == '*') ADVANCE(51);
      if (lookahead == '+') ADVANCE(52);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == '?') ADVANCE(50);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '|') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(107);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(8)
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(99);
      END_STATE();
    case 9:
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(55);
      if (lookahead == '*') ADVANCE(51);
      if (lookahead == '+') ADVANCE(52);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '?') ADVANCE(50);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == '|') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != ']') ADVANCE(61);
      END_STATE();
    case 10:
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(55);
      if (lookahead == '*') ADVANCE(51);
      if (lookahead == '+') ADVANCE(52);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == '?') ADVANCE(50);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == ']') ADVANCE(59);
      if (lookahead == '|') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(107);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(10)
      if (lookahead != 0) ADVANCE(99);
      END_STATE();
    case 11:
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (lookahead != 0 &&
          (lookahead < ')' || '+' < lookahead) &&
          lookahead != '?' &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(99);
      END_STATE();
    case 12:
      if (lookahead == '(') ADVANCE(32);
      if (lookahead == ',') ADVANCE(57);
      if (lookahead == '-') ADVANCE(56);
      if (lookahead == ']') ADVANCE(59);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == '|') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (lookahead != 0 &&
          (lookahead < ')' || '+' < lookahead) &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '?' &&
          lookahead != '[') ADVANCE(100);
      END_STATE();
    case 13:
      if (lookahead == ')') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == ',') ADVANCE(57);
      if (lookahead == '-') ADVANCE(56);
      if (lookahead == ']') ADVANCE(59);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == '|') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(107);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(14)
      if (lookahead != 0 &&
          (lookahead < '(' || '+' < lookahead) &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '?' &&
          lookahead != '[') ADVANCE(100);
      END_STATE();
    case 15:
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == ']') ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(107);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(15)
      if (lookahead != 0 &&
          lookahead != '#') ADVANCE(79);
      END_STATE();
    case 16:
      if (lookahead == 'A') ADVANCE(30);
      END_STATE();
    case 17:
      if (lookahead == 'A') ADVANCE(28);
      END_STATE();
    case 18:
      if (lookahead == 'C') ADVANCE(26);
      END_STATE();
    case 19:
      if (lookahead == 'E') ADVANCE(31);
      END_STATE();
    case 20:
      if (lookahead == 'E') ADVANCE(27);
      END_STATE();
    case 21:
      if (lookahead == 'I') ADVANCE(18);
      END_STATE();
    case 22:
      if (lookahead == 'I') ADVANCE(17);
      END_STATE();
    case 23:
      if (lookahead == 'L') ADVANCE(22);
      END_STATE();
    case 24:
      if (lookahead == 'N') ADVANCE(41);
      END_STATE();
    case 25:
      if (lookahead == 'N') ADVANCE(40);
      END_STATE();
    case 26:
      if (lookahead == 'O') ADVANCE(24);
      END_STATE();
    case 27:
      if (lookahead == 'R') ADVANCE(25);
      END_STATE();
    case 28:
      if (lookahead == 'S') ADVANCE(42);
      END_STATE();
    case 29:
      if (lookahead == 'T') ADVANCE(20);
      END_STATE();
    case 30:
      if (lookahead == 'T') ADVANCE(29);
      END_STATE();
    case 31:
      if (lookahead == 'X') ADVANCE(21);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(13);
      END_STATE();
    case 33:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(80);
      END_STATE();
    case 34:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') ADVANCE(102);
      if (lookahead == '\r') SKIP(34)
      if (lookahead == '#') ADVANCE(82);
      if (lookahead == 'A') ADVANCE(23);
      if (lookahead == 'L') ADVANCE(19);
      if (lookahead == 'P') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(1);
      END_STATE();
    case 35:
      if (eof) ADVANCE(38);
      if (lookahead == '#') ADVANCE(82);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == 'A') ADVANCE(70);
      if (lookahead == 'L') ADVANCE(66);
      if (lookahead == 'P') ADVANCE(63);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\\') ADVANCE(33);
      if (lookahead == ']') ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (lookahead != 0) ADVANCE(79);
      END_STATE();
    case 36:
      if (eof) ADVANCE(38);
      if (lookahead == '#') ADVANCE(81);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == 'A') ADVANCE(90);
      if (lookahead == 'L') ADVANCE(86);
      if (lookahead == 'P') ADVANCE(83);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(106);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(36)
      if (lookahead != 0 &&
          (lookahead < ')' || '+' < lookahead) &&
          lookahead != '?' &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(99);
      END_STATE();
    case 37:
      if (eof) ADVANCE(38);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == '<') ADVANCE(45);
      if (lookahead == '>') ADVANCE(46);
      if (lookahead == 'A') ADVANCE(90);
      if (lookahead == 'L') ADVANCE(86);
      if (lookahead == 'P') ADVANCE(83);
      if (lookahead == '[') ADVANCE(58);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(106);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(37)
      if (lookahead != 0 &&
          (lookahead < ')' || '+' < lookahead) &&
          lookahead != '?' &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(99);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_pattern_start);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_named_pattern_start);
      if (lookahead == 'S') ADVANCE(39);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_lexicon_start);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_alias);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_alias);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_alias);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_left_sieve);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_right_sieve);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (!sym_regex_string_character_set_1(lookahead)) ADVANCE(61);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_colon);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_question_op);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_star_op);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_plus_op);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(13);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_regex_string);
      if (!sym_regex_string_character_set_1(lookahead)) ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'A') ADVANCE(77);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'A') ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'C') ADVANCE(73);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'E') ADVANCE(78);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'E') ADVANCE(74);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'I') ADVANCE(65);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'I') ADVANCE(64);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'L') ADVANCE(69);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'N') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'N') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'O') ADVANCE(71);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'R') ADVANCE(72);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'S') ADVANCE(44);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'T') ADVANCE(67);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'T') ADVANCE(76);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead == 'X') ADVANCE(68);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_lexicon_string);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '#' &&
          lookahead != '/' &&
          lookahead != ':' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_escaped_char);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_comment);
      if (sym_comment_character_set_1(lookahead)) ADVANCE(82);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(81);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(82);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(97);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(95);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(93);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(98);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(94);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(85);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(84);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(89);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(41);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(40);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(91);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(92);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(43);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(87);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(96);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'X') ADVANCE(88);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_identifier);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_tag);
      if (!sym_tag_character_set_1(lookahead)) ADVANCE(100);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym__real_nl);
      if (lookahead == '\n') ADVANCE(102);
      if (lookahead == 'L') ADVANCE(19);
      if (lookahead == 'P') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(102);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym__real_nl);
      if (lookahead == '\n') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(103);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym__ws);
      if (lookahead == '\n') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(104);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym__ws);
      if (lookahead == 'L') ADVANCE(19);
      if (lookahead == 'P') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(105);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym__ws);
      if (lookahead == 'L') ADVANCE(86);
      if (lookahead == 'P') ADVANCE(83);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(106);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym__ws);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(107);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 34},
  [2] = {.lex_state = 37},
  [3] = {.lex_state = 37},
  [4] = {.lex_state = 37},
  [5] = {.lex_state = 37},
  [6] = {.lex_state = 37},
  [7] = {.lex_state = 35},
  [8] = {.lex_state = 35},
  [9] = {.lex_state = 35},
  [10] = {.lex_state = 35},
  [11] = {.lex_state = 35},
  [12] = {.lex_state = 35},
  [13] = {.lex_state = 35},
  [14] = {.lex_state = 35},
  [15] = {.lex_state = 35},
  [16] = {.lex_state = 10},
  [17] = {.lex_state = 10},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 10},
  [20] = {.lex_state = 3},
  [21] = {.lex_state = 36},
  [22] = {.lex_state = 10},
  [23] = {.lex_state = 3},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 5},
  [26] = {.lex_state = 10},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 10},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 36},
  [33] = {.lex_state = 3},
  [34] = {.lex_state = 10},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 10},
  [37] = {.lex_state = 10},
  [38] = {.lex_state = 8},
  [39] = {.lex_state = 10},
  [40] = {.lex_state = 10},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 36},
  [43] = {.lex_state = 10},
  [44] = {.lex_state = 10},
  [45] = {.lex_state = 2},
  [46] = {.lex_state = 2},
  [47] = {.lex_state = 36},
  [48] = {.lex_state = 10},
  [49] = {.lex_state = 35},
  [50] = {.lex_state = 9},
  [51] = {.lex_state = 10},
  [52] = {.lex_state = 9},
  [53] = {.lex_state = 2},
  [54] = {.lex_state = 2},
  [55] = {.lex_state = 2},
  [56] = {.lex_state = 9},
  [57] = {.lex_state = 2},
  [58] = {.lex_state = 2},
  [59] = {.lex_state = 2},
  [60] = {.lex_state = 9},
  [61] = {.lex_state = 2},
  [62] = {.lex_state = 10},
  [63] = {.lex_state = 10},
  [64] = {.lex_state = 10},
  [65] = {.lex_state = 2},
  [66] = {.lex_state = 9},
  [67] = {.lex_state = 2},
  [68] = {.lex_state = 2},
  [69] = {.lex_state = 9},
  [70] = {.lex_state = 9},
  [71] = {.lex_state = 10},
  [72] = {.lex_state = 2},
  [73] = {.lex_state = 9},
  [74] = {.lex_state = 11},
  [75] = {.lex_state = 35},
  [76] = {.lex_state = 37},
  [77] = {.lex_state = 10},
  [78] = {.lex_state = 9},
  [79] = {.lex_state = 10},
  [80] = {.lex_state = 9},
  [81] = {.lex_state = 35},
  [82] = {.lex_state = 10},
  [83] = {.lex_state = 10},
  [84] = {.lex_state = 37},
  [85] = {.lex_state = 10},
  [86] = {.lex_state = 35},
  [87] = {.lex_state = 10},
  [88] = {.lex_state = 37},
  [89] = {.lex_state = 10},
  [90] = {.lex_state = 37},
  [91] = {.lex_state = 10},
  [92] = {.lex_state = 10},
  [93] = {.lex_state = 10},
  [94] = {.lex_state = 10},
  [95] = {.lex_state = 37},
  [96] = {.lex_state = 11},
  [97] = {.lex_state = 11},
  [98] = {.lex_state = 10},
  [99] = {.lex_state = 10},
  [100] = {.lex_state = 2},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 2},
  [103] = {.lex_state = 6},
  [104] = {.lex_state = 6},
  [105] = {.lex_state = 6},
  [106] = {.lex_state = 6},
  [107] = {.lex_state = 2},
  [108] = {.lex_state = 2},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 6},
  [112] = {.lex_state = 6},
  [113] = {.lex_state = 6},
  [114] = {.lex_state = 35},
  [115] = {.lex_state = 6},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 9},
  [118] = {.lex_state = 7},
  [119] = {.lex_state = 10},
  [120] = {.lex_state = 9},
  [121] = {.lex_state = 9},
  [122] = {.lex_state = 10},
  [123] = {.lex_state = 35},
  [124] = {.lex_state = 10},
  [125] = {.lex_state = 14},
  [126] = {.lex_state = 2},
  [127] = {.lex_state = 15},
  [128] = {.lex_state = 35},
  [129] = {.lex_state = 35},
  [130] = {.lex_state = 10},
  [131] = {.lex_state = 10},
  [132] = {.lex_state = 9},
  [133] = {.lex_state = 10},
  [134] = {.lex_state = 3},
  [135] = {.lex_state = 2},
  [136] = {.lex_state = 9},
  [137] = {.lex_state = 2},
  [138] = {.lex_state = 2},
  [139] = {.lex_state = 14},
  [140] = {.lex_state = 14},
  [141] = {.lex_state = 10},
  [142] = {.lex_state = 10},
  [143] = {.lex_state = 2},
  [144] = {.lex_state = 9},
  [145] = {.lex_state = 10},
  [146] = {.lex_state = 10},
  [147] = {.lex_state = 14},
  [148] = {.lex_state = 10},
  [149] = {.lex_state = 10},
  [150] = {.lex_state = 35},
  [151] = {.lex_state = 15},
  [152] = {.lex_state = 35},
  [153] = {.lex_state = 6},
  [154] = {.lex_state = 4},
  [155] = {.lex_state = 4},
  [156] = {.lex_state = 12},
  [157] = {.lex_state = 6},
  [158] = {.lex_state = 35},
  [159] = {.lex_state = 35},
  [160] = {.lex_state = 35},
  [161] = {.lex_state = 35},
  [162] = {.lex_state = 35},
  [163] = {.lex_state = 2},
  [164] = {.lex_state = 4},
  [165] = {.lex_state = 11},
  [166] = {.lex_state = 10},
  [167] = {.lex_state = 35},
  [168] = {.lex_state = 11},
  [169] = {.lex_state = 2},
  [170] = {.lex_state = 4},
  [171] = {.lex_state = 2},
  [172] = {.lex_state = 4},
  [173] = {.lex_state = 4},
  [174] = {.lex_state = 4},
  [175] = {.lex_state = 11},
  [176] = {.lex_state = 6},
  [177] = {.lex_state = 10},
  [178] = {.lex_state = 10},
  [179] = {.lex_state = 4},
  [180] = {.lex_state = 4},
  [181] = {.lex_state = 4},
  [182] = {.lex_state = 10},
  [183] = {.lex_state = 10},
  [184] = {.lex_state = 2},
  [185] = {.lex_state = 7},
  [186] = {.lex_state = 2},
  [187] = {.lex_state = 2},
  [188] = {.lex_state = 4},
  [189] = {.lex_state = 2},
  [190] = {.lex_state = 7},
  [191] = {.lex_state = 11},
  [192] = {.lex_state = 12},
  [193] = {.lex_state = 6},
  [194] = {.lex_state = 10},
  [195] = {.lex_state = 12},
  [196] = {.lex_state = 12},
  [197] = {.lex_state = 10},
  [198] = {.lex_state = 15},
  [199] = {.lex_state = 10},
  [200] = {.lex_state = 5},
  [201] = {.lex_state = 15},
  [202] = {.lex_state = 9},
  [203] = {.lex_state = 10},
  [204] = {.lex_state = 9},
  [205] = {.lex_state = 15},
  [206] = {.lex_state = 15},
  [207] = {.lex_state = 3},
  [208] = {.lex_state = 9},
  [209] = {.lex_state = 15},
  [210] = {.lex_state = 10},
  [211] = {.lex_state = 9},
  [212] = {.lex_state = 15},
  [213] = {.lex_state = 15},
  [214] = {.lex_state = 9},
  [215] = {.lex_state = 10},
  [216] = {.lex_state = 15},
  [217] = {.lex_state = 10},
  [218] = {.lex_state = 10},
  [219] = {.lex_state = 15},
  [220] = {.lex_state = 15},
  [221] = {.lex_state = 9},
  [222] = {.lex_state = 10},
  [223] = {.lex_state = 7},
  [224] = {.lex_state = 15},
  [225] = {.lex_state = 6},
  [226] = {.lex_state = 6},
  [227] = {.lex_state = 6},
  [228] = {.lex_state = 10},
  [229] = {.lex_state = 2},
  [230] = {.lex_state = 6},
  [231] = {.lex_state = 14},
  [232] = {.lex_state = 2},
  [233] = {.lex_state = 14},
  [234] = {.lex_state = 6},
  [235] = {.lex_state = 2},
  [236] = {.lex_state = 14},
  [237] = {.lex_state = 6},
  [238] = {.lex_state = 2},
  [239] = {.lex_state = 2},
  [240] = {.lex_state = 14},
  [241] = {.lex_state = 12},
  [242] = {.lex_state = 12},
  [243] = {.lex_state = 2},
  [244] = {.lex_state = 12},
  [245] = {.lex_state = 2},
  [246] = {.lex_state = 10},
  [247] = {.lex_state = 35},
  [248] = {.lex_state = 35},
  [249] = {.lex_state = 10},
  [250] = {.lex_state = 10},
  [251] = {.lex_state = 2},
  [252] = {.lex_state = 14},
  [253] = {.lex_state = 12},
  [254] = {.lex_state = 6},
  [255] = {.lex_state = 2},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 2},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 6},
  [260] = {.lex_state = 14},
  [261] = {.lex_state = 14},
  [262] = {.lex_state = 14},
  [263] = {.lex_state = 14},
  [264] = {.lex_state = 14},
  [265] = {.lex_state = 14},
  [266] = {.lex_state = 10},
  [267] = {.lex_state = 6},
  [268] = {.lex_state = 14},
  [269] = {.lex_state = 14},
  [270] = {.lex_state = 14},
  [271] = {.lex_state = 14},
  [272] = {.lex_state = 12},
  [273] = {.lex_state = 6},
  [274] = {.lex_state = 2},
  [275] = {.lex_state = 6},
  [276] = {.lex_state = 10},
  [277] = {.lex_state = 6},
  [278] = {.lex_state = 2},
  [279] = {.lex_state = 2},
  [280] = {.lex_state = 14},
  [281] = {.lex_state = 2},
  [282] = {.lex_state = 14},
  [283] = {.lex_state = 2},
  [284] = {.lex_state = 12},
  [285] = {.lex_state = 12},
  [286] = {.lex_state = 12},
  [287] = {.lex_state = 2},
  [288] = {.lex_state = 14},
  [289] = {.lex_state = 12},
  [290] = {.lex_state = 2},
  [291] = {.lex_state = 14},
  [292] = {.lex_state = 10},
  [293] = {.lex_state = 14},
  [294] = {.lex_state = 2},
  [295] = {.lex_state = 2},
  [296] = {.lex_state = 2},
  [297] = {.lex_state = 2},
  [298] = {.lex_state = 2},
  [299] = {.lex_state = 2},
  [300] = {.lex_state = 14},
  [301] = {.lex_state = 14},
  [302] = {.lex_state = 2},
  [303] = {.lex_state = 10},
  [304] = {.lex_state = 2},
  [305] = {.lex_state = 14},
  [306] = {.lex_state = 2},
  [307] = {.lex_state = 3},
  [308] = {.lex_state = 12},
  [309] = {.lex_state = 10},
  [310] = {.lex_state = 3},
  [311] = {.lex_state = 10},
  [312] = {.lex_state = 3},
  [313] = {.lex_state = 10},
  [314] = {.lex_state = 3},
  [315] = {.lex_state = 10},
  [316] = {.lex_state = 12},
  [317] = {.lex_state = 10},
  [318] = {.lex_state = 11},
  [319] = {.lex_state = 3},
  [320] = {.lex_state = 12},
  [321] = {.lex_state = 10},
  [322] = {.lex_state = 3},
  [323] = {.lex_state = 12},
  [324] = {.lex_state = 10},
  [325] = {.lex_state = 3},
  [326] = {.lex_state = 12},
  [327] = {.lex_state = 10},
  [328] = {.lex_state = 10},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 10},
  [331] = {.lex_state = 10},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 12},
  [334] = {.lex_state = 12},
  [335] = {.lex_state = 10},
  [336] = {.lex_state = 10},
  [337] = {.lex_state = 10},
  [338] = {.lex_state = 12},
  [339] = {.lex_state = 10},
  [340] = {.lex_state = 10},
  [341] = {.lex_state = 3},
  [342] = {.lex_state = 11},
  [343] = {.lex_state = 3},
  [344] = {.lex_state = 12},
  [345] = {.lex_state = 35},
  [346] = {.lex_state = 3},
  [347] = {.lex_state = 9},
  [348] = {.lex_state = 3},
  [349] = {.lex_state = 35},
  [350] = {.lex_state = 35},
  [351] = {.lex_state = 12},
  [352] = {.lex_state = 35},
  [353] = {.lex_state = 9},
  [354] = {.lex_state = 35},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 35},
  [357] = {.lex_state = 35},
  [358] = {.lex_state = 11},
  [359] = {.lex_state = 9},
  [360] = {.lex_state = 35},
  [361] = {.lex_state = 35},
  [362] = {.lex_state = 11},
  [363] = {.lex_state = 35},
  [364] = {.lex_state = 11},
  [365] = {.lex_state = 35},
  [366] = {.lex_state = 35},
  [367] = {.lex_state = 3},
  [368] = {.lex_state = 3},
  [369] = {.lex_state = 35},
  [370] = {.lex_state = 35},
  [371] = {.lex_state = 3},
  [372] = {.lex_state = 3},
  [373] = {.lex_state = 10},
  [374] = {.lex_state = 10},
  [375] = {.lex_state = 11},
  [376] = {.lex_state = 9},
  [377] = {.lex_state = 10},
  [378] = {.lex_state = 35},
  [379] = {.lex_state = 12},
  [380] = {.lex_state = 10},
  [381] = {.lex_state = 12},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_pattern_start] = ACTIONS(1),
    [sym_named_pattern_start] = ACTIONS(1),
    [sym_lexicon_start] = ACTIONS(1),
    [sym_alias] = ACTIONS(1),
    [sym_left_sieve] = ACTIONS(1),
    [sym_right_sieve] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [sym_colon] = ACTIONS(1),
    [sym_question_op] = ACTIONS(1),
    [sym_star_op] = ACTIONS(1),
    [sym_plus_op] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [sym_escaped_char] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym__ws] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(355),
    [sym_pattern_block] = STATE(159),
    [sym_lexicon_block] = STATE(159),
    [sym_alias_command] = STATE(159),
    [sym_block_comment] = STATE(158),
    [aux_sym_source_file_repeat1] = STATE(159),
    [aux_sym_block_comment_repeat1] = STATE(81),
    [ts_builtin_sym_end] = ACTIONS(3),
    [sym_pattern_start] = ACTIONS(5),
    [sym_named_pattern_start] = ACTIONS(7),
    [sym_lexicon_start] = ACTIONS(9),
    [sym_alias] = ACTIONS(11),
    [sym_comment] = ACTIONS(13),
    [sym__real_nl] = ACTIONS(15),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 14,
    ACTIONS(17), 1,
      ts_builtin_sym_end,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym__ws,
    STATE(20), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(3), 2,
      sym_pattern_line,
      aux_sym_pattern_block_repeat1,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
    ACTIONS(19), 4,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
  [49] = 14,
    ACTIONS(33), 1,
      ts_builtin_sym_end,
    ACTIONS(40), 1,
      sym_colon,
    ACTIONS(43), 1,
      anon_sym_LPAREN,
    ACTIONS(46), 1,
      anon_sym_LBRACK,
    ACTIONS(49), 1,
      sym_identifier,
    ACTIONS(52), 1,
      sym__ws,
    STATE(20), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(37), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(3), 2,
      sym_pattern_line,
      aux_sym_pattern_block_repeat1,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
    ACTIONS(35), 4,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
  [98] = 14,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym__ws,
    ACTIONS(55), 1,
      ts_builtin_sym_end,
    STATE(20), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(3), 2,
      sym_pattern_line,
      aux_sym_pattern_block_repeat1,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
    ACTIONS(57), 4,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
  [147] = 14,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym__ws,
    ACTIONS(59), 1,
      ts_builtin_sym_end,
    STATE(20), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(3), 2,
      sym_pattern_line,
      aux_sym_pattern_block_repeat1,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
    ACTIONS(61), 4,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
  [196] = 14,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym__ws,
    ACTIONS(63), 1,
      ts_builtin_sym_end,
    STATE(20), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(3), 2,
      sym_pattern_line,
      aux_sym_pattern_block_repeat1,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
    ACTIONS(65), 4,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
  [245] = 12,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(77), 1,
      sym_lexicon_string,
    ACTIONS(79), 1,
      sym_escaped_char,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(69), 2,
      sym_named_pattern_start,
      sym_alias,
    STATE(12), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
    ACTIONS(67), 3,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
  [286] = 12,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(77), 1,
      sym_lexicon_string,
    ACTIONS(79), 1,
      sym_escaped_char,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(83), 2,
      sym_named_pattern_start,
      sym_alias,
    STATE(12), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
    ACTIONS(81), 3,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
  [327] = 12,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(77), 1,
      sym_lexicon_string,
    ACTIONS(79), 1,
      sym_escaped_char,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(87), 2,
      sym_named_pattern_start,
      sym_alias,
    STATE(12), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
    ACTIONS(85), 3,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
  [368] = 12,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(77), 1,
      sym_lexicon_string,
    ACTIONS(79), 1,
      sym_escaped_char,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(91), 2,
      sym_named_pattern_start,
      sym_alias,
    STATE(12), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
    ACTIONS(89), 3,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
  [409] = 12,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(77), 1,
      sym_lexicon_string,
    ACTIONS(79), 1,
      sym_escaped_char,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(95), 2,
      sym_named_pattern_start,
      sym_alias,
    STATE(12), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
    ACTIONS(93), 3,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
  [450] = 12,
    ACTIONS(101), 1,
      sym_colon,
    ACTIONS(104), 1,
      anon_sym_LBRACK,
    ACTIONS(107), 1,
      anon_sym_SLASH,
    ACTIONS(110), 1,
      sym_lexicon_string,
    ACTIONS(113), 1,
      sym_escaped_char,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(99), 2,
      sym_named_pattern_start,
      sym_alias,
    STATE(12), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
    ACTIONS(97), 3,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
  [491] = 12,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(77), 1,
      sym_lexicon_string,
    ACTIONS(79), 1,
      sym_escaped_char,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(118), 2,
      sym_named_pattern_start,
      sym_alias,
    STATE(12), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
    ACTIONS(116), 3,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
  [532] = 12,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(77), 1,
      sym_lexicon_string,
    ACTIONS(79), 1,
      sym_escaped_char,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(122), 2,
      sym_named_pattern_start,
      sym_alias,
    STATE(12), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
    ACTIONS(120), 3,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
  [573] = 12,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(77), 1,
      sym_lexicon_string,
    ACTIONS(79), 1,
      sym_escaped_char,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(126), 2,
      sym_named_pattern_start,
      sym_alias,
    STATE(12), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
    ACTIONS(124), 3,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
  [614] = 12,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(128), 1,
      sym__ws,
    STATE(20), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(4), 2,
      sym_pattern_line,
      aux_sym_pattern_block_repeat1,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [654] = 12,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(128), 1,
      sym__ws,
    STATE(20), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(6), 2,
      sym_pattern_line,
      aux_sym_pattern_block_repeat1,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [694] = 5,
    ACTIONS(134), 1,
      sym_identifier,
    STATE(30), 1,
      sym_lexicon_reference,
    STATE(116), 1,
      sym_pattern_operator,
    ACTIONS(132), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(130), 9,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [720] = 12,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(128), 1,
      sym__ws,
    STATE(20), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(5), 2,
      sym_pattern_line,
      aux_sym_pattern_block_repeat1,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [760] = 13,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(137), 1,
      sym_comment,
    ACTIONS(139), 1,
      sym__real_nl,
    STATE(33), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(76), 1,
      sym__nl,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [802] = 5,
    ACTIONS(141), 1,
      ts_builtin_sym_end,
    ACTIONS(145), 1,
      sym_comment,
    STATE(42), 1,
      aux_sym_block_comment_repeat1,
    STATE(88), 1,
      sym_block_comment,
    ACTIONS(143), 11,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
      sym__ws,
  [828] = 12,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(128), 1,
      sym__ws,
    STATE(20), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(2), 2,
      sym_pattern_line,
      aux_sym_pattern_block_repeat1,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [868] = 13,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(139), 1,
      sym__real_nl,
    ACTIONS(147), 1,
      sym_comment,
    STATE(33), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(90), 1,
      sym__nl,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(21), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [910] = 5,
    ACTIONS(151), 1,
      anon_sym_LBRACK,
    STATE(41), 1,
      sym_tag_filter,
    STATE(137), 1,
      sym_pattern_operator,
    ACTIONS(132), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(149), 9,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [936] = 5,
    ACTIONS(156), 1,
      sym_question_op,
    ACTIONS(159), 1,
      anon_sym_LBRACK,
    ACTIONS(162), 1,
      sym_number,
    STATE(68), 1,
      sym_tag_filter,
    ACTIONS(154), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [962] = 12,
    ACTIONS(166), 1,
      sym_colon,
    ACTIONS(168), 1,
      anon_sym_LPAREN,
    ACTIONS(170), 1,
      anon_sym_RPAREN,
    ACTIONS(172), 1,
      anon_sym_LBRACK,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(176), 1,
      sym__ws,
    STATE(28), 1,
      aux_sym_pattern_line_repeat1,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(124), 1,
      sym_pattern_token,
    STATE(222), 1,
      sym_pattern_option,
    ACTIONS(164), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [1001] = 3,
    STATE(126), 1,
      sym_pattern_operator,
    ACTIONS(132), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(178), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1022] = 12,
    ACTIONS(183), 1,
      sym_colon,
    ACTIONS(186), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_RPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(194), 1,
      sym_identifier,
    ACTIONS(197), 1,
      sym__ws,
    STATE(28), 1,
      aux_sym_pattern_line_repeat1,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(124), 1,
      sym_pattern_token,
    STATE(222), 1,
      sym_pattern_option,
    ACTIONS(180), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [1061] = 3,
    ACTIONS(201), 1,
      anon_sym_LBRACK,
    STATE(61), 1,
      sym_tag_filter,
    ACTIONS(199), 12,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1082] = 3,
    STATE(143), 1,
      sym_pattern_operator,
    ACTIONS(132), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(204), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1103] = 3,
    ACTIONS(208), 1,
      anon_sym_LBRACK,
    STATE(53), 1,
      sym_tag_filter,
    ACTIONS(206), 12,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1124] = 4,
    ACTIONS(211), 1,
      ts_builtin_sym_end,
    ACTIONS(215), 1,
      sym_comment,
    STATE(32), 1,
      aux_sym_block_comment_repeat1,
    ACTIONS(213), 11,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
      sym__ws,
  [1147] = 12,
    ACTIONS(189), 1,
      sym_comment,
    ACTIONS(197), 1,
      sym__real_nl,
    ACTIONS(221), 1,
      sym_colon,
    ACTIONS(224), 1,
      anon_sym_LPAREN,
    ACTIONS(227), 1,
      anon_sym_LBRACK,
    ACTIONS(230), 1,
      sym_identifier,
    STATE(33), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(218), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [1186] = 12,
    ACTIONS(166), 1,
      sym_colon,
    ACTIONS(168), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_LBRACK,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(233), 1,
      anon_sym_RPAREN,
    ACTIONS(235), 1,
      sym__ws,
    STATE(28), 1,
      aux_sym_pattern_line_repeat1,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(124), 1,
      sym_pattern_token,
    STATE(222), 1,
      sym_pattern_option,
    ACTIONS(164), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [1225] = 4,
    ACTIONS(237), 1,
      sym_colon,
    STATE(137), 1,
      sym_pattern_operator,
    ACTIONS(132), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(149), 9,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1248] = 12,
    ACTIONS(166), 1,
      sym_colon,
    ACTIONS(168), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_LBRACK,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(239), 1,
      anon_sym_RPAREN,
    ACTIONS(241), 1,
      sym__ws,
    STATE(28), 1,
      aux_sym_pattern_line_repeat1,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(124), 1,
      sym_pattern_token,
    STATE(222), 1,
      sym_pattern_option,
    ACTIONS(164), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [1287] = 6,
    ACTIONS(245), 1,
      anon_sym_LBRACK,
    ACTIONS(248), 1,
      sym__ws,
    STATE(43), 1,
      sym_tag_filter,
    STATE(183), 1,
      sym_pattern_operator,
    ACTIONS(243), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(149), 7,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_identifier,
  [1314] = 6,
    ACTIONS(250), 1,
      sym_question_op,
    ACTIONS(253), 1,
      anon_sym_LBRACK,
    ACTIONS(256), 1,
      sym_number,
    ACTIONS(258), 1,
      sym__ws,
    STATE(77), 1,
      sym_tag_filter,
    ACTIONS(154), 9,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_identifier,
  [1341] = 12,
    ACTIONS(166), 1,
      sym_colon,
    ACTIONS(168), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_LBRACK,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(260), 1,
      anon_sym_RPAREN,
    ACTIONS(262), 1,
      sym__ws,
    STATE(28), 1,
      aux_sym_pattern_line_repeat1,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(124), 1,
      sym_pattern_token,
    STATE(222), 1,
      sym_pattern_option,
    ACTIONS(164), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [1380] = 6,
    ACTIONS(264), 1,
      sym_identifier,
    ACTIONS(267), 1,
      sym__ws,
    STATE(62), 1,
      sym_lexicon_reference,
    STATE(177), 1,
      sym_pattern_operator,
    ACTIONS(243), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(130), 7,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
  [1407] = 3,
    STATE(135), 1,
      sym_pattern_operator,
    ACTIONS(132), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(269), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1428] = 4,
    ACTIONS(145), 1,
      sym_comment,
    ACTIONS(271), 1,
      ts_builtin_sym_end,
    STATE(32), 1,
      aux_sym_block_comment_repeat1,
    ACTIONS(273), 11,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
      sym__ws,
  [1451] = 4,
    ACTIONS(275), 1,
      sym__ws,
    STATE(178), 1,
      sym_pattern_operator,
    ACTIONS(243), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(269), 8,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [1473] = 5,
    ACTIONS(248), 1,
      sym__ws,
    ACTIONS(277), 1,
      sym_colon,
    STATE(183), 1,
      sym_pattern_operator,
    ACTIONS(243), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(149), 7,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [1497] = 1,
    ACTIONS(279), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1513] = 1,
    ACTIONS(281), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1529] = 2,
    ACTIONS(211), 1,
      ts_builtin_sym_end,
    ACTIONS(213), 12,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__ws,
  [1547] = 11,
    ACTIONS(166), 1,
      sym_colon,
    ACTIONS(168), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_LBRACK,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(283), 1,
      sym__ws,
    STATE(26), 1,
      aux_sym_pattern_line_repeat1,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(124), 1,
      sym_pattern_token,
    STATE(222), 1,
      sym_pattern_option,
    ACTIONS(164), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [1583] = 5,
    ACTIONS(285), 1,
      sym_comment,
    STATE(81), 1,
      aux_sym_block_comment_repeat1,
    STATE(123), 1,
      sym_block_comment,
    ACTIONS(143), 3,
      sym_named_pattern_start,
      sym_alias,
      sym_lexicon_string,
    ACTIONS(141), 7,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [1607] = 9,
    ACTIONS(287), 1,
      anon_sym_PIPE,
    ACTIONS(289), 1,
      sym_colon,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      sym_regex_string,
    ACTIONS(297), 1,
      anon_sym_SLASH,
    ACTIONS(299), 1,
      sym_escaped_char,
    STATE(144), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    STATE(69), 4,
      sym_pattern_or,
      sym_regex_line,
      sym_regex_group,
      aux_sym_regex_repeat1,
  [1639] = 11,
    ACTIONS(166), 1,
      sym_colon,
    ACTIONS(168), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_LBRACK,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(301), 1,
      sym__ws,
    STATE(39), 1,
      aux_sym_pattern_line_repeat1,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(124), 1,
      sym_pattern_token,
    STATE(222), 1,
      sym_pattern_option,
    ACTIONS(164), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [1675] = 9,
    ACTIONS(287), 1,
      anon_sym_PIPE,
    ACTIONS(289), 1,
      sym_colon,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      sym_regex_string,
    ACTIONS(299), 1,
      sym_escaped_char,
    ACTIONS(303), 1,
      anon_sym_SLASH,
    STATE(144), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    STATE(69), 4,
      sym_pattern_or,
      sym_regex_line,
      sym_regex_group,
      aux_sym_regex_repeat1,
  [1707] = 1,
    ACTIONS(305), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1723] = 1,
    ACTIONS(307), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1739] = 1,
    ACTIONS(309), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1755] = 9,
    ACTIONS(287), 1,
      anon_sym_PIPE,
    ACTIONS(289), 1,
      sym_colon,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      sym_regex_string,
    ACTIONS(299), 1,
      sym_escaped_char,
    ACTIONS(311), 1,
      anon_sym_RPAREN,
    STATE(144), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    STATE(70), 4,
      sym_pattern_or,
      sym_regex_line,
      sym_regex_group,
      aux_sym_regex_group_repeat1,
  [1787] = 1,
    ACTIONS(313), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1803] = 1,
    ACTIONS(315), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1819] = 1,
    ACTIONS(317), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1835] = 9,
    ACTIONS(287), 1,
      anon_sym_PIPE,
    ACTIONS(289), 1,
      sym_colon,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      sym_regex_string,
    ACTIONS(299), 1,
      sym_escaped_char,
    ACTIONS(319), 1,
      anon_sym_SLASH,
    STATE(144), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    STATE(50), 4,
      sym_pattern_or,
      sym_regex_line,
      sym_regex_group,
      aux_sym_regex_repeat1,
  [1867] = 1,
    ACTIONS(321), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1883] = 4,
    ACTIONS(323), 1,
      sym__ws,
    STATE(166), 1,
      sym_pattern_operator,
    ACTIONS(243), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(204), 8,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [1905] = 4,
    ACTIONS(325), 1,
      sym__ws,
    STATE(182), 1,
      sym_pattern_operator,
    ACTIONS(243), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(178), 8,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [1927] = 4,
    ACTIONS(327), 1,
      anon_sym_LBRACK,
    ACTIONS(330), 1,
      sym__ws,
    STATE(93), 1,
      sym_tag_filter,
    ACTIONS(199), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_identifier,
  [1949] = 1,
    ACTIONS(332), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [1965] = 9,
    ACTIONS(334), 1,
      anon_sym_PIPE,
    ACTIONS(337), 1,
      sym_colon,
    ACTIONS(340), 1,
      anon_sym_LPAREN,
    ACTIONS(343), 1,
      anon_sym_RPAREN,
    ACTIONS(345), 1,
      anon_sym_LBRACK,
    ACTIONS(348), 1,
      sym_regex_string,
    ACTIONS(351), 1,
      sym_escaped_char,
    STATE(144), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    STATE(66), 4,
      sym_pattern_or,
      sym_regex_line,
      sym_regex_group,
      aux_sym_regex_group_repeat1,
  [1997] = 1,
    ACTIONS(354), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [2013] = 1,
    ACTIONS(356), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [2029] = 9,
    ACTIONS(358), 1,
      anon_sym_PIPE,
    ACTIONS(361), 1,
      sym_colon,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(367), 1,
      anon_sym_LBRACK,
    ACTIONS(370), 1,
      sym_regex_string,
    ACTIONS(373), 1,
      anon_sym_SLASH,
    ACTIONS(375), 1,
      sym_escaped_char,
    STATE(144), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    STATE(69), 4,
      sym_pattern_or,
      sym_regex_line,
      sym_regex_group,
      aux_sym_regex_repeat1,
  [2061] = 9,
    ACTIONS(287), 1,
      anon_sym_PIPE,
    ACTIONS(289), 1,
      sym_colon,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      sym_regex_string,
    ACTIONS(299), 1,
      sym_escaped_char,
    ACTIONS(378), 1,
      anon_sym_RPAREN,
    STATE(144), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    STATE(66), 4,
      sym_pattern_or,
      sym_regex_line,
      sym_regex_group,
      aux_sym_regex_group_repeat1,
  [2093] = 4,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(383), 1,
      sym__ws,
    STATE(85), 1,
      sym_tag_filter,
    ACTIONS(206), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_identifier,
  [2115] = 1,
    ACTIONS(385), 13,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [2131] = 9,
    ACTIONS(287), 1,
      anon_sym_PIPE,
    ACTIONS(289), 1,
      sym_colon,
    ACTIONS(291), 1,
      anon_sym_LPAREN,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(295), 1,
      sym_regex_string,
    ACTIONS(299), 1,
      sym_escaped_char,
    ACTIONS(387), 1,
      anon_sym_SLASH,
    STATE(144), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    STATE(52), 4,
      sym_pattern_or,
      sym_regex_line,
      sym_regex_group,
      aux_sym_regex_repeat1,
  [2163] = 10,
    ACTIONS(391), 1,
      sym_colon,
    ACTIONS(393), 1,
      anon_sym_LPAREN,
    ACTIONS(395), 1,
      anon_sym_LBRACK,
    ACTIONS(397), 1,
      sym_identifier,
    STATE(36), 1,
      aux_sym_pattern_line_repeat1,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(124), 1,
      sym_pattern_token,
    STATE(222), 1,
      sym_pattern_option,
    ACTIONS(389), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [2196] = 9,
    ACTIONS(7), 1,
      sym_named_pattern_start,
    ACTIONS(285), 1,
      sym_comment,
    ACTIONS(399), 1,
      ts_builtin_sym_end,
    ACTIONS(401), 1,
      sym_pattern_start,
    ACTIONS(403), 1,
      sym_lexicon_start,
    ACTIONS(405), 1,
      sym_alias,
    STATE(81), 1,
      aux_sym_block_comment_repeat1,
    STATE(160), 1,
      sym_block_comment,
    STATE(161), 4,
      sym_pattern_block,
      sym_lexicon_block,
      sym_alias_command,
      aux_sym_source_file_repeat1,
  [2227] = 2,
    ACTIONS(407), 1,
      ts_builtin_sym_end,
    ACTIONS(409), 11,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
      sym__ws,
  [2244] = 2,
    ACTIONS(411), 1,
      sym__ws,
    ACTIONS(356), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2261] = 4,
    STATE(202), 1,
      sym_pattern_operator,
    ACTIONS(413), 2,
      anon_sym_PIPE,
      sym_regex_string,
    ACTIONS(417), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(415), 6,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [2282] = 2,
    ACTIONS(419), 1,
      sym__ws,
    ACTIONS(307), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2299] = 4,
    STATE(208), 1,
      sym_pattern_operator,
    ACTIONS(421), 2,
      anon_sym_PIPE,
      sym_regex_string,
    ACTIONS(417), 3,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
    ACTIONS(423), 6,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [2320] = 4,
    ACTIONS(285), 1,
      sym_comment,
    STATE(86), 1,
      aux_sym_block_comment_repeat1,
    ACTIONS(273), 3,
      sym_named_pattern_start,
      sym_alias,
      sym_lexicon_string,
    ACTIONS(271), 7,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [2341] = 2,
    ACTIONS(425), 1,
      sym__ws,
    ACTIONS(332), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2358] = 2,
    ACTIONS(427), 1,
      sym__ws,
    ACTIONS(279), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2375] = 2,
    ACTIONS(429), 1,
      ts_builtin_sym_end,
    ACTIONS(431), 11,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
      sym__ws,
  [2392] = 2,
    ACTIONS(433), 1,
      sym__ws,
    ACTIONS(305), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2409] = 4,
    ACTIONS(435), 1,
      sym_comment,
    STATE(86), 1,
      aux_sym_block_comment_repeat1,
    ACTIONS(213), 3,
      sym_named_pattern_start,
      sym_alias,
      sym_lexicon_string,
    ACTIONS(211), 7,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [2430] = 2,
    ACTIONS(438), 1,
      sym__ws,
    ACTIONS(385), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2447] = 2,
    ACTIONS(440), 1,
      ts_builtin_sym_end,
    ACTIONS(442), 11,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
      sym__ws,
  [2464] = 2,
    ACTIONS(444), 1,
      sym__ws,
    ACTIONS(281), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2481] = 2,
    ACTIONS(446), 1,
      ts_builtin_sym_end,
    ACTIONS(448), 11,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
      sym__ws,
  [2498] = 2,
    ACTIONS(450), 1,
      sym__ws,
    ACTIONS(309), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2515] = 2,
    ACTIONS(452), 1,
      sym__ws,
    ACTIONS(354), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2532] = 2,
    ACTIONS(454), 1,
      sym__ws,
    ACTIONS(321), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2549] = 2,
    ACTIONS(456), 1,
      sym__ws,
    ACTIONS(317), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2566] = 2,
    ACTIONS(458), 1,
      ts_builtin_sym_end,
    ACTIONS(460), 11,
      sym_pattern_start,
      sym_named_pattern_start,
      sym_lexicon_start,
      sym_alias,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
      sym__ws,
  [2583] = 10,
    ACTIONS(464), 1,
      sym_colon,
    ACTIONS(466), 1,
      anon_sym_LPAREN,
    ACTIONS(468), 1,
      anon_sym_LBRACK,
    ACTIONS(470), 1,
      sym_identifier,
    STATE(23), 1,
      aux_sym_pattern_line_repeat1,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(102), 1,
      sym_pattern_token,
    STATE(163), 1,
      sym_pattern_option,
    ACTIONS(462), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [2616] = 10,
    ACTIONS(391), 1,
      sym_colon,
    ACTIONS(393), 1,
      anon_sym_LPAREN,
    ACTIONS(395), 1,
      anon_sym_LBRACK,
    ACTIONS(397), 1,
      sym_identifier,
    STATE(34), 1,
      aux_sym_pattern_line_repeat1,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(124), 1,
      sym_pattern_token,
    STATE(222), 1,
      sym_pattern_option,
    ACTIONS(389), 2,
      sym_left_sieve,
      sym_right_sieve,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [2649] = 2,
    ACTIONS(472), 1,
      sym__ws,
    ACTIONS(315), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2666] = 2,
    ACTIONS(474), 1,
      sym__ws,
    ACTIONS(313), 11,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      sym_question_op,
      sym_star_op,
      sym_plus_op,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [2683] = 3,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    STATE(119), 1,
      sym_pattern_or,
    ACTIONS(476), 9,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [2701] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(482), 1,
      sym__ws,
    STATE(133), 1,
      sym_pattern_or,
    ACTIONS(480), 8,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
  [2721] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(486), 1,
      sym__ws,
    STATE(133), 1,
      sym_pattern_or,
    ACTIONS(484), 8,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
  [2741] = 9,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
    STATE(7), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
  [2771] = 9,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
    STATE(13), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
  [2801] = 9,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
    STATE(14), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
  [2831] = 9,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
    STATE(15), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
  [2861] = 3,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    STATE(119), 1,
      sym_pattern_or,
    ACTIONS(488), 9,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [2879] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(490), 1,
      sym__ws,
    STATE(133), 1,
      sym_pattern_or,
    ACTIONS(488), 8,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
  [2899] = 3,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    STATE(119), 1,
      sym_pattern_or,
    ACTIONS(492), 9,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [2917] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(494), 1,
      sym__ws,
    STATE(133), 1,
      sym_pattern_or,
    ACTIONS(492), 8,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
  [2937] = 9,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
    STATE(8), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
  [2967] = 9,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
    STATE(9), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
  [2997] = 9,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
    STATE(11), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
  [3027] = 2,
    ACTIONS(213), 3,
      sym_named_pattern_start,
      sym_alias,
      sym_lexicon_string,
    ACTIONS(211), 8,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
      sym_comment,
  [3043] = 9,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(239), 1,
      sym_lexicon_segment,
    STATE(258), 1,
      sym_regex,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
    STATE(10), 2,
      sym_lexicon_line,
      aux_sym_lexicon_block_repeat1,
  [3073] = 1,
    ACTIONS(496), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [3086] = 6,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(498), 1,
      anon_sym_PIPE,
    ACTIONS(502), 1,
      sym_regex_string,
    ACTIONS(504), 1,
      sym_escaped_char,
    STATE(121), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    ACTIONS(500), 4,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
  [3109] = 5,
    ACTIONS(141), 1,
      sym__ws,
    ACTIONS(506), 1,
      sym_comment,
    STATE(190), 1,
      aux_sym_block_comment_repeat1,
    STATE(228), 1,
      sym_block_comment,
    ACTIONS(143), 6,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [3130] = 9,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(508), 1,
      sym__ws,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(110), 1,
      sym_pattern_token,
    STATE(169), 1,
      sym_pattern_option,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [3159] = 6,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(510), 1,
      anon_sym_PIPE,
    ACTIONS(514), 1,
      sym_regex_string,
    ACTIONS(516), 1,
      sym_escaped_char,
    STATE(132), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    ACTIONS(512), 4,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
  [3182] = 6,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(518), 1,
      anon_sym_PIPE,
    ACTIONS(522), 1,
      sym_regex_string,
    ACTIONS(524), 1,
      sym_escaped_char,
    STATE(136), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    ACTIONS(520), 4,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
  [3205] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(526), 1,
      sym__ws,
    STATE(141), 1,
      sym_pattern_or,
    ACTIONS(488), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [3224] = 2,
    ACTIONS(442), 3,
      sym_named_pattern_start,
      sym_alias,
      sym_lexicon_string,
    ACTIONS(440), 7,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [3239] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(528), 1,
      sym__ws,
    STATE(131), 1,
      sym_pattern_or,
    ACTIONS(484), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [3258] = 6,
    ACTIONS(532), 1,
      anon_sym_DASH,
    ACTIONS(534), 1,
      sym_tag,
    ACTIONS(536), 1,
      sym__ws,
    STATE(350), 1,
      sym_tag_distribution_operator,
    ACTIONS(530), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    STATE(263), 4,
      sym_neg_tag,
      sym__tag_or_neg,
      sym_tag_distribution,
      sym__tag_filter_segment,
  [3281] = 1,
    ACTIONS(538), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [3294] = 9,
    ACTIONS(540), 1,
      sym_colon,
    ACTIONS(542), 1,
      anon_sym_LBRACK,
    ACTIONS(544), 1,
      anon_sym_SLASH,
    ACTIONS(548), 1,
      sym__ws,
    STATE(237), 1,
      sym_tag_setting,
    STATE(246), 1,
      sym__lexicon_side_left,
    STATE(266), 1,
      sym_regex,
    STATE(331), 1,
      sym_lexicon_segment,
    ACTIONS(546), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [3323] = 2,
    ACTIONS(552), 3,
      sym_named_pattern_start,
      sym_alias,
      sym_lexicon_string,
    ACTIONS(550), 7,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [3338] = 2,
    ACTIONS(556), 3,
      sym_named_pattern_start,
      sym_alias,
      sym_lexicon_string,
    ACTIONS(554), 7,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [3353] = 4,
    ACTIONS(197), 1,
      sym__ws,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    STATE(141), 1,
      sym_pattern_or,
    ACTIONS(189), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [3372] = 9,
    ACTIONS(166), 1,
      sym_colon,
    ACTIONS(168), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_LBRACK,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(558), 1,
      sym__ws,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(142), 1,
      sym_pattern_token,
    STATE(210), 1,
      sym_pattern_option,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [3401] = 6,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(498), 1,
      anon_sym_PIPE,
    ACTIONS(522), 1,
      sym_regex_string,
    ACTIONS(524), 1,
      sym_escaped_char,
    STATE(136), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    ACTIONS(500), 4,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
  [3424] = 9,
    ACTIONS(23), 1,
      sym_colon,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(560), 1,
      sym__ws,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(101), 1,
      sym_pattern_token,
    STATE(186), 1,
      sym_pattern_option,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [3453] = 4,
    ACTIONS(197), 1,
      sym__real_nl,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    STATE(119), 1,
      sym_pattern_or,
    ACTIONS(189), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
  [3472] = 1,
    ACTIONS(562), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [3485] = 6,
    ACTIONS(564), 1,
      anon_sym_PIPE,
    ACTIONS(568), 1,
      anon_sym_LBRACK,
    ACTIONS(571), 1,
      sym_regex_string,
    ACTIONS(574), 1,
      sym_escaped_char,
    STATE(136), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    ACTIONS(566), 4,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
  [3508] = 1,
    ACTIONS(577), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [3521] = 1,
    ACTIONS(579), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [3534] = 6,
    ACTIONS(532), 1,
      anon_sym_DASH,
    ACTIONS(581), 1,
      sym_tag,
    ACTIONS(583), 1,
      sym__ws,
    STATE(350), 1,
      sym_tag_distribution_operator,
    ACTIONS(530), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    STATE(271), 4,
      sym_neg_tag,
      sym__tag_or_neg,
      sym_tag_distribution,
      sym__tag_filter_segment,
  [3557] = 6,
    ACTIONS(532), 1,
      anon_sym_DASH,
    ACTIONS(585), 1,
      sym_tag,
    ACTIONS(587), 1,
      sym__ws,
    STATE(350), 1,
      sym_tag_distribution_operator,
    ACTIONS(530), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    STATE(288), 4,
      sym_neg_tag,
      sym__tag_or_neg,
      sym_tag_distribution,
      sym__tag_filter_segment,
  [3580] = 9,
    ACTIONS(166), 1,
      sym_colon,
    ACTIONS(168), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_LBRACK,
    ACTIONS(174), 1,
      sym_identifier,
    ACTIONS(589), 1,
      sym__ws,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(146), 1,
      sym_pattern_token,
    STATE(218), 1,
      sym_pattern_option,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [3609] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(591), 1,
      sym__ws,
    STATE(131), 1,
      sym_pattern_or,
    ACTIONS(480), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [3628] = 1,
    ACTIONS(593), 10,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [3641] = 7,
    ACTIONS(293), 1,
      anon_sym_LBRACK,
    ACTIONS(510), 1,
      anon_sym_PIPE,
    ACTIONS(522), 1,
      sym_regex_string,
    ACTIONS(524), 1,
      sym_escaped_char,
    ACTIONS(595), 1,
      sym_colon,
    STATE(136), 2,
      sym_regex_char_class,
      aux_sym__plain_regex_string,
    ACTIONS(512), 3,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
  [3666] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(597), 1,
      sym__ws,
    STATE(141), 1,
      sym_pattern_or,
    ACTIONS(476), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [3685] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(599), 1,
      sym__ws,
    STATE(131), 1,
      sym_pattern_or,
    ACTIONS(492), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [3704] = 6,
    ACTIONS(532), 1,
      anon_sym_DASH,
    ACTIONS(601), 1,
      sym_tag,
    ACTIONS(603), 1,
      sym__ws,
    STATE(350), 1,
      sym_tag_distribution_operator,
    ACTIONS(530), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    STATE(280), 4,
      sym_neg_tag,
      sym__tag_or_neg,
      sym_tag_distribution,
      sym__tag_filter_segment,
  [3727] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(605), 1,
      sym__ws,
    STATE(131), 1,
      sym_pattern_or,
    ACTIONS(488), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [3746] = 4,
    ACTIONS(478), 1,
      anon_sym_PIPE,
    ACTIONS(607), 1,
      sym__ws,
    STATE(141), 1,
      sym_pattern_or,
    ACTIONS(492), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [3765] = 2,
    ACTIONS(611), 3,
      sym_named_pattern_start,
      sym_alias,
      sym_lexicon_string,
    ACTIONS(609), 7,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [3780] = 9,
    ACTIONS(540), 1,
      sym_colon,
    ACTIONS(542), 1,
      anon_sym_LBRACK,
    ACTIONS(544), 1,
      anon_sym_SLASH,
    ACTIONS(613), 1,
      sym__ws,
    STATE(237), 1,
      sym_tag_setting,
    STATE(246), 1,
      sym__lexicon_side_left,
    STATE(266), 1,
      sym_regex,
    STATE(337), 1,
      sym_lexicon_segment,
    ACTIONS(546), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [3809] = 2,
    ACTIONS(617), 3,
      sym_named_pattern_start,
      sym_alias,
      sym_lexicon_string,
    ACTIONS(615), 7,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [3824] = 9,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(619), 1,
      sym_comment,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(258), 1,
      sym_regex,
    STATE(281), 1,
      sym_lexicon_segment,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [3853] = 5,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(170), 1,
      aux_sym__lexicon_side_right,
    STATE(306), 1,
      sym_tag_setting,
    ACTIONS(623), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(625), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [3873] = 5,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(181), 1,
      aux_sym__lexicon_side_right,
    STATE(283), 1,
      sym_tag_setting,
    ACTIONS(627), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(629), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [3893] = 5,
    ACTIONS(633), 1,
      anon_sym_DASH,
    ACTIONS(635), 1,
      sym_tag,
    STATE(350), 1,
      sym_tag_distribution_operator,
    ACTIONS(631), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    STATE(265), 4,
      sym_neg_tag,
      sym__tag_or_neg,
      sym_tag_distribution,
      sym__tag_filter_segment,
  [3913] = 8,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(637), 1,
      sym_colon,
    ACTIONS(639), 1,
      anon_sym_SLASH,
    STATE(237), 1,
      sym_tag_setting,
    STATE(246), 1,
      sym__lexicon_side_left,
    STATE(266), 1,
      sym_regex,
    STATE(336), 1,
      sym_lexicon_segment,
    ACTIONS(641), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [3939] = 6,
    ACTIONS(7), 1,
      sym_named_pattern_start,
    ACTIONS(399), 1,
      ts_builtin_sym_end,
    ACTIONS(401), 1,
      sym_pattern_start,
    ACTIONS(403), 1,
      sym_lexicon_start,
    ACTIONS(405), 1,
      sym_alias,
    STATE(161), 4,
      sym_pattern_block,
      sym_lexicon_block,
      sym_alias_command,
      aux_sym_source_file_repeat1,
  [3961] = 6,
    ACTIONS(7), 1,
      sym_named_pattern_start,
    ACTIONS(399), 1,
      ts_builtin_sym_end,
    ACTIONS(401), 1,
      sym_pattern_start,
    ACTIONS(403), 1,
      sym_lexicon_start,
    ACTIONS(405), 1,
      sym_alias,
    STATE(162), 4,
      sym_pattern_block,
      sym_lexicon_block,
      sym_alias_command,
      aux_sym_source_file_repeat1,
  [3983] = 6,
    ACTIONS(7), 1,
      sym_named_pattern_start,
    ACTIONS(401), 1,
      sym_pattern_start,
    ACTIONS(403), 1,
      sym_lexicon_start,
    ACTIONS(405), 1,
      sym_alias,
    ACTIONS(643), 1,
      ts_builtin_sym_end,
    STATE(167), 4,
      sym_pattern_block,
      sym_lexicon_block,
      sym_alias_command,
      aux_sym_source_file_repeat1,
  [4005] = 6,
    ACTIONS(7), 1,
      sym_named_pattern_start,
    ACTIONS(401), 1,
      sym_pattern_start,
    ACTIONS(403), 1,
      sym_lexicon_start,
    ACTIONS(405), 1,
      sym_alias,
    ACTIONS(643), 1,
      ts_builtin_sym_end,
    STATE(162), 4,
      sym_pattern_block,
      sym_lexicon_block,
      sym_alias_command,
      aux_sym_source_file_repeat1,
  [4027] = 6,
    ACTIONS(645), 1,
      ts_builtin_sym_end,
    ACTIONS(647), 1,
      sym_pattern_start,
    ACTIONS(650), 1,
      sym_named_pattern_start,
    ACTIONS(653), 1,
      sym_lexicon_start,
    ACTIONS(656), 1,
      sym_alias,
    STATE(162), 4,
      sym_pattern_block,
      sym_lexicon_block,
      sym_alias_command,
      aux_sym_source_file_repeat1,
  [4049] = 2,
    ACTIONS(659), 1,
      sym__ws,
    ACTIONS(484), 8,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
  [4063] = 5,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(174), 1,
      aux_sym__lexicon_side_right,
    STATE(290), 1,
      sym_tag_setting,
    ACTIONS(661), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(663), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [4083] = 8,
    ACTIONS(391), 1,
      sym_colon,
    ACTIONS(393), 1,
      anon_sym_LPAREN,
    ACTIONS(395), 1,
      anon_sym_LBRACK,
    ACTIONS(397), 1,
      sym_identifier,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(148), 1,
      sym_pattern_token,
    STATE(197), 1,
      sym_pattern_option,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [4109] = 2,
    ACTIONS(665), 1,
      sym__ws,
    ACTIONS(593), 8,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4123] = 6,
    ACTIONS(7), 1,
      sym_named_pattern_start,
    ACTIONS(401), 1,
      sym_pattern_start,
    ACTIONS(403), 1,
      sym_lexicon_start,
    ACTIONS(405), 1,
      sym_alias,
    ACTIONS(667), 1,
      ts_builtin_sym_end,
    STATE(162), 4,
      sym_pattern_block,
      sym_lexicon_block,
      sym_alias_command,
      aux_sym_source_file_repeat1,
  [4145] = 8,
    ACTIONS(464), 1,
      sym_colon,
    ACTIONS(466), 1,
      anon_sym_LPAREN,
    ACTIONS(468), 1,
      anon_sym_LBRACK,
    ACTIONS(470), 1,
      sym_identifier,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(108), 1,
      sym_pattern_token,
    STATE(187), 1,
      sym_pattern_option,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [4171] = 2,
    ACTIONS(671), 1,
      sym__ws,
    ACTIONS(669), 8,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
  [4185] = 5,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(174), 1,
      aux_sym__lexicon_side_right,
    STATE(294), 1,
      sym_tag_setting,
    ACTIONS(661), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(673), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [4205] = 1,
    ACTIONS(675), 9,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [4217] = 5,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(164), 1,
      aux_sym__lexicon_side_right,
    STATE(295), 1,
      sym_tag_setting,
    ACTIONS(677), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(679), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [4237] = 5,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(174), 1,
      aux_sym__lexicon_side_right,
    STATE(296), 1,
      sym_tag_setting,
    ACTIONS(661), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(681), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [4257] = 3,
    STATE(174), 1,
      aux_sym__lexicon_side_right,
    ACTIONS(685), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(683), 5,
      sym_colon,
      anon_sym_LBRACK,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [4273] = 8,
    ACTIONS(391), 1,
      sym_colon,
    ACTIONS(393), 1,
      anon_sym_LPAREN,
    ACTIONS(395), 1,
      anon_sym_LBRACK,
    ACTIONS(397), 1,
      sym_identifier,
    STATE(44), 1,
      sym_lexicon_reference,
    STATE(146), 1,
      sym_pattern_token,
    STATE(218), 1,
      sym_pattern_option,
    STATE(37), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [4299] = 8,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(637), 1,
      sym_colon,
    ACTIONS(639), 1,
      anon_sym_SLASH,
    STATE(237), 1,
      sym_tag_setting,
    STATE(246), 1,
      sym__lexicon_side_left,
    STATE(266), 1,
      sym_regex,
    STATE(311), 1,
      sym_lexicon_segment,
    ACTIONS(641), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [4325] = 2,
    ACTIONS(688), 1,
      sym__ws,
    ACTIONS(496), 8,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4339] = 2,
    ACTIONS(690), 1,
      sym__ws,
    ACTIONS(562), 8,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4353] = 5,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(173), 1,
      aux_sym__lexicon_side_right,
    STATE(302), 1,
      sym_tag_setting,
    ACTIONS(692), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(694), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [4373] = 3,
    STATE(174), 1,
      aux_sym__lexicon_side_right,
    ACTIONS(661), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(696), 5,
      sym_colon,
      anon_sym_LBRACK,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [4389] = 5,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(174), 1,
      aux_sym__lexicon_side_right,
    STATE(297), 1,
      sym_tag_setting,
    ACTIONS(661), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(698), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [4409] = 2,
    ACTIONS(700), 1,
      sym__ws,
    ACTIONS(538), 8,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4423] = 2,
    ACTIONS(702), 1,
      sym__ws,
    ACTIONS(577), 8,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4437] = 1,
    ACTIONS(704), 9,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [4449] = 4,
    ACTIONS(211), 1,
      sym__ws,
    ACTIONS(706), 1,
      sym_comment,
    STATE(185), 1,
      aux_sym_block_comment_repeat1,
    ACTIONS(213), 6,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4467] = 2,
    ACTIONS(711), 1,
      sym__ws,
    ACTIONS(709), 8,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
  [4481] = 2,
    ACTIONS(715), 1,
      sym__ws,
    ACTIONS(713), 8,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
  [4495] = 3,
    STATE(180), 1,
      aux_sym__lexicon_side_right,
    ACTIONS(719), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
    ACTIONS(717), 5,
      sym_colon,
      anon_sym_LBRACK,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [4511] = 1,
    ACTIONS(721), 9,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
      sym__real_nl,
      sym__ws,
  [4523] = 4,
    ACTIONS(271), 1,
      sym__ws,
    ACTIONS(506), 1,
      sym_comment,
    STATE(185), 1,
      aux_sym_block_comment_repeat1,
    ACTIONS(273), 6,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4541] = 8,
    ACTIONS(464), 1,
      sym_colon,
    ACTIONS(466), 1,
      anon_sym_LPAREN,
    ACTIONS(468), 1,
      anon_sym_LBRACK,
    ACTIONS(470), 1,
      sym_identifier,
    STATE(35), 1,
      sym_lexicon_reference,
    STATE(110), 1,
      sym_pattern_token,
    STATE(169), 1,
      sym_pattern_option,
    STATE(24), 2,
      sym_anonymous_pattern,
      sym_anonymous_lexicon,
  [4567] = 5,
    ACTIONS(633), 1,
      anon_sym_DASH,
    ACTIONS(723), 1,
      sym_tag,
    STATE(350), 1,
      sym_tag_distribution_operator,
    ACTIONS(631), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    STATE(262), 4,
      sym_neg_tag,
      sym__tag_or_neg,
      sym_tag_distribution,
      sym__tag_filter_segment,
  [4587] = 8,
    ACTIONS(71), 1,
      sym_colon,
    ACTIONS(73), 1,
      anon_sym_LBRACK,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    STATE(234), 1,
      sym_tag_setting,
    STATE(235), 1,
      sym__lexicon_side_left,
    STATE(258), 1,
      sym_regex,
    STATE(281), 1,
      sym_lexicon_segment,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [4613] = 2,
    ACTIONS(725), 1,
      sym__ws,
    ACTIONS(579), 8,
      sym_left_sieve,
      sym_right_sieve,
      anon_sym_PIPE,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4627] = 5,
    ACTIONS(633), 1,
      anon_sym_DASH,
    ACTIONS(727), 1,
      sym_tag,
    STATE(350), 1,
      sym_tag_distribution_operator,
    ACTIONS(631), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    STATE(301), 4,
      sym_neg_tag,
      sym__tag_or_neg,
      sym_tag_distribution,
      sym__tag_filter_segment,
  [4647] = 5,
    ACTIONS(633), 1,
      anon_sym_DASH,
    ACTIONS(729), 1,
      sym_tag,
    STATE(350), 1,
      sym_tag_distribution_operator,
    ACTIONS(631), 2,
      anon_sym_PIPE,
      anon_sym_CARET,
    STATE(280), 4,
      sym_neg_tag,
      sym__tag_or_neg,
      sym_tag_distribution,
      sym__tag_filter_segment,
  [4667] = 2,
    ACTIONS(731), 1,
      sym__ws,
    ACTIONS(713), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4680] = 4,
    ACTIONS(735), 1,
      sym__ws,
    STATE(213), 1,
      aux_sym__lexicon_side_right,
    ACTIONS(717), 3,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(733), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [4697] = 2,
    ACTIONS(737), 1,
      sym__ws,
    ACTIONS(675), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4710] = 8,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    ACTIONS(739), 1,
      sym_comment,
    ACTIONS(741), 1,
      sym_number,
    ACTIONS(743), 1,
      sym__real_nl,
    ACTIONS(745), 1,
      sym__ws,
    STATE(113), 1,
      sym__nl,
    STATE(256), 1,
      sym_tag_setting,
    STATE(322), 1,
      sym__end_com,
  [4735] = 6,
    ACTIONS(681), 1,
      anon_sym_RBRACK,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(751), 1,
      sym__ws,
    STATE(220), 1,
      aux_sym__lexicon_side_right,
    STATE(328), 1,
      sym_tag_setting,
    ACTIONS(749), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [4756] = 2,
    ACTIONS(753), 2,
      anon_sym_PIPE,
      sym_regex_string,
    ACTIONS(755), 6,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [4769] = 2,
    ACTIONS(757), 1,
      sym__ws,
    ACTIONS(721), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4782] = 2,
    ACTIONS(759), 2,
      anon_sym_PIPE,
      sym_regex_string,
    ACTIONS(761), 6,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [4795] = 6,
    ACTIONS(694), 1,
      anon_sym_RBRACK,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(765), 1,
      sym__ws,
    STATE(201), 1,
      aux_sym__lexicon_side_right,
    STATE(315), 1,
      sym_tag_setting,
    ACTIONS(763), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [4816] = 6,
    ACTIONS(673), 1,
      anon_sym_RBRACK,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(767), 1,
      sym__ws,
    STATE(220), 1,
      aux_sym__lexicon_side_right,
    STATE(335), 1,
      sym_tag_setting,
    ACTIONS(749), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [4837] = 2,
    ACTIONS(197), 1,
      sym__real_nl,
    ACTIONS(189), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
  [4850] = 2,
    ACTIONS(413), 2,
      anon_sym_PIPE,
      sym_regex_string,
    ACTIONS(415), 6,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [4863] = 6,
    ACTIONS(679), 1,
      anon_sym_RBRACK,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(771), 1,
      sym__ws,
    STATE(216), 1,
      aux_sym__lexicon_side_right,
    STATE(327), 1,
      sym_tag_setting,
    ACTIONS(769), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [4884] = 2,
    ACTIONS(773), 1,
      sym__ws,
    ACTIONS(709), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4897] = 2,
    ACTIONS(775), 2,
      anon_sym_PIPE,
      sym_regex_string,
    ACTIONS(777), 6,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [4910] = 6,
    ACTIONS(625), 1,
      anon_sym_RBRACK,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(781), 1,
      sym__ws,
    STATE(206), 1,
      aux_sym__lexicon_side_right,
    STATE(313), 1,
      sym_tag_setting,
    ACTIONS(779), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [4931] = 4,
    ACTIONS(783), 1,
      sym__ws,
    STATE(220), 1,
      aux_sym__lexicon_side_right,
    ACTIONS(696), 3,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(749), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [4948] = 2,
    ACTIONS(785), 2,
      anon_sym_PIPE,
      sym_regex_string,
    ACTIONS(787), 6,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [4961] = 2,
    ACTIONS(789), 1,
      sym__ws,
    ACTIONS(704), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [4974] = 6,
    ACTIONS(663), 1,
      anon_sym_RBRACK,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(791), 1,
      sym__ws,
    STATE(220), 1,
      aux_sym__lexicon_side_right,
    STATE(321), 1,
      sym_tag_setting,
    ACTIONS(749), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [4995] = 2,
    ACTIONS(197), 1,
      sym__ws,
    ACTIONS(189), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [5008] = 2,
    ACTIONS(793), 1,
      sym__ws,
    ACTIONS(669), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [5021] = 6,
    ACTIONS(698), 1,
      anon_sym_RBRACK,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      sym__ws,
    STATE(220), 1,
      aux_sym__lexicon_side_right,
    STATE(309), 1,
      sym_tag_setting,
    ACTIONS(749), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [5042] = 4,
    ACTIONS(800), 1,
      sym__ws,
    STATE(220), 1,
      aux_sym__lexicon_side_right,
    ACTIONS(683), 3,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(797), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [5059] = 2,
    ACTIONS(579), 2,
      anon_sym_PIPE,
      sym_regex_string,
    ACTIONS(725), 6,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_escaped_char,
  [5072] = 2,
    ACTIONS(802), 1,
      sym__ws,
    ACTIONS(484), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [5085] = 2,
    ACTIONS(211), 1,
      sym__ws,
    ACTIONS(213), 7,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_comment,
      sym_identifier,
  [5098] = 6,
    ACTIONS(629), 1,
      anon_sym_RBRACK,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(807), 1,
      sym__ws,
    STATE(219), 1,
      aux_sym__lexicon_side_right,
    STATE(317), 1,
      sym_tag_setting,
    ACTIONS(805), 3,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [5119] = 4,
    ACTIONS(809), 1,
      sym_comment,
    STATE(227), 1,
      aux_sym_block_comment_repeat1,
    STATE(254), 1,
      sym_block_comment,
    ACTIONS(141), 5,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [5136] = 3,
    ACTIONS(811), 1,
      sym_comment,
    STATE(226), 1,
      aux_sym_block_comment_repeat1,
    ACTIONS(211), 5,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [5150] = 3,
    ACTIONS(809), 1,
      sym_comment,
    STATE(226), 1,
      aux_sym_block_comment_repeat1,
    ACTIONS(271), 5,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [5164] = 2,
    ACTIONS(440), 1,
      sym__ws,
    ACTIONS(442), 6,
      sym_left_sieve,
      sym_right_sieve,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [5176] = 7,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    ACTIONS(739), 1,
      sym_comment,
    ACTIONS(743), 1,
      sym__real_nl,
    ACTIONS(745), 1,
      sym__ws,
    STATE(115), 1,
      sym__nl,
    STATE(257), 1,
      sym_tag_setting,
    STATE(307), 1,
      sym__end_com,
  [5198] = 1,
    ACTIONS(211), 6,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
      sym_comment,
  [5207] = 5,
    ACTIONS(532), 1,
      anon_sym_DASH,
    ACTIONS(814), 1,
      sym_tag,
    ACTIONS(816), 1,
      sym__ws,
    STATE(349), 1,
      sym__tag_list,
    STATE(270), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5224] = 4,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    ACTIONS(818), 1,
      sym_colon,
    STATE(304), 1,
      sym_tag_setting,
    ACTIONS(820), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5239] = 5,
    ACTIONS(532), 1,
      anon_sym_DASH,
    ACTIONS(814), 1,
      sym_tag,
    ACTIONS(822), 1,
      sym__ws,
    STATE(366), 1,
      sym__tag_list,
    STATE(270), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5256] = 5,
    ACTIONS(75), 1,
      anon_sym_SLASH,
    ACTIONS(824), 1,
      sym_colon,
    STATE(232), 1,
      sym__lexicon_side_left,
    STATE(251), 1,
      sym_regex,
    ACTIONS(79), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [5273] = 4,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    ACTIONS(826), 1,
      sym_colon,
    STATE(287), 1,
      sym_tag_setting,
    ACTIONS(828), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5288] = 5,
    ACTIONS(532), 1,
      anon_sym_DASH,
    ACTIONS(814), 1,
      sym_tag,
    ACTIONS(830), 1,
      sym__ws,
    STATE(354), 1,
      sym__tag_list,
    STATE(270), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5305] = 5,
    ACTIONS(639), 1,
      anon_sym_SLASH,
    ACTIONS(832), 1,
      sym_colon,
    STATE(249), 1,
      sym__lexicon_side_left,
    STATE(276), 1,
      sym_regex,
    ACTIONS(641), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [5322] = 6,
    ACTIONS(739), 1,
      sym_comment,
    ACTIONS(834), 1,
      sym__real_nl,
    ACTIONS(836), 1,
      sym__ws,
    STATE(150), 1,
      sym__nl,
    STATE(278), 1,
      aux_sym_lexicon_line_repeat1,
    STATE(329), 1,
      sym__end_com,
  [5341] = 6,
    ACTIONS(739), 1,
      sym_comment,
    ACTIONS(834), 1,
      sym__real_nl,
    ACTIONS(836), 1,
      sym__ws,
    STATE(129), 1,
      sym__nl,
    STATE(238), 1,
      aux_sym_lexicon_line_repeat1,
    STATE(314), 1,
      sym__end_com,
  [5360] = 5,
    ACTIONS(532), 1,
      anon_sym_DASH,
    ACTIONS(814), 1,
      sym_tag,
    ACTIONS(838), 1,
      sym__ws,
    STATE(369), 1,
      sym__tag_list,
    STATE(270), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5377] = 4,
    ACTIONS(633), 1,
      anon_sym_DASH,
    ACTIONS(840), 1,
      sym_tag,
    STATE(365), 1,
      sym__tag_list,
    STATE(270), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5391] = 4,
    ACTIONS(633), 1,
      anon_sym_DASH,
    ACTIONS(840), 1,
      sym_tag,
    STATE(378), 1,
      sym__tag_list,
    STATE(270), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5405] = 5,
    ACTIONS(739), 1,
      sym_comment,
    ACTIONS(745), 1,
      sym__ws,
    ACTIONS(842), 1,
      sym__real_nl,
    STATE(16), 1,
      sym__nl,
    STATE(332), 1,
      sym__end_com,
  [5421] = 4,
    ACTIONS(633), 1,
      anon_sym_DASH,
    ACTIONS(840), 1,
      sym_tag,
    STATE(370), 1,
      sym__tag_list,
    STATE(270), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5435] = 5,
    ACTIONS(739), 1,
      sym_comment,
    ACTIONS(745), 1,
      sym__ws,
    ACTIONS(834), 1,
      sym__real_nl,
    STATE(248), 1,
      sym__nl,
    STATE(310), 1,
      sym__end_com,
  [5451] = 5,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(828), 1,
      anon_sym_RBRACK,
    ACTIONS(844), 1,
      sym_colon,
    ACTIONS(846), 1,
      sym__ws,
    STATE(330), 1,
      sym_tag_setting,
  [5467] = 2,
    ACTIONS(850), 1,
      sym_named_pattern_start,
    ACTIONS(848), 4,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_alias,
  [5477] = 2,
    ACTIONS(854), 1,
      sym_named_pattern_start,
    ACTIONS(852), 4,
      ts_builtin_sym_end,
      sym_pattern_start,
      sym_lexicon_start,
      sym_alias,
  [5487] = 5,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_RBRACK,
    ACTIONS(856), 1,
      sym_colon,
    ACTIONS(858), 1,
      sym__ws,
    STATE(324), 1,
      sym_tag_setting,
  [5503] = 2,
    ACTIONS(761), 1,
      sym__ws,
    ACTIONS(759), 4,
      sym_colon,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      sym_identifier,
  [5513] = 3,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(304), 1,
      sym_tag_setting,
    ACTIONS(820), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5525] = 4,
    ACTIONS(532), 1,
      anon_sym_DASH,
    ACTIONS(860), 1,
      sym_tag,
    ACTIONS(862), 1,
      sym__ws,
    STATE(282), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5539] = 4,
    ACTIONS(633), 1,
      anon_sym_DASH,
    ACTIONS(840), 1,
      sym_tag,
    STATE(360), 1,
      sym__tag_list,
    STATE(270), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5553] = 1,
    ACTIONS(440), 5,
      sym_colon,
      anon_sym_LBRACK,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [5561] = 5,
    ACTIONS(739), 1,
      sym_comment,
    ACTIONS(745), 1,
      sym__ws,
    ACTIONS(842), 1,
      sym__real_nl,
    STATE(19), 1,
      sym__nl,
    STATE(325), 1,
      sym__end_com,
  [5577] = 5,
    ACTIONS(739), 1,
      sym_comment,
    ACTIONS(743), 1,
      sym__real_nl,
    ACTIONS(745), 1,
      sym__ws,
    STATE(112), 1,
      sym__nl,
    STATE(319), 1,
      sym__end_com,
  [5593] = 5,
    ACTIONS(739), 1,
      sym_comment,
    ACTIONS(743), 1,
      sym__real_nl,
    ACTIONS(745), 1,
      sym__ws,
    STATE(105), 1,
      sym__nl,
    STATE(343), 1,
      sym__end_com,
  [5609] = 3,
    ACTIONS(621), 1,
      anon_sym_LBRACK,
    STATE(287), 1,
      sym_tag_setting,
    ACTIONS(828), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5621] = 1,
    ACTIONS(864), 4,
      sym_colon,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [5628] = 4,
    ACTIONS(866), 1,
      anon_sym_COMMA,
    ACTIONS(869), 1,
      anon_sym_RBRACK,
    ACTIONS(871), 1,
      sym__ws,
    STATE(260), 1,
      aux_sym_tag_filter_repeat1,
  [5641] = 4,
    ACTIONS(874), 1,
      anon_sym_COMMA,
    ACTIONS(876), 1,
      anon_sym_RBRACK,
    ACTIONS(878), 1,
      sym__ws,
    STATE(260), 1,
      aux_sym_tag_filter_repeat1,
  [5654] = 4,
    ACTIONS(874), 1,
      anon_sym_COMMA,
    ACTIONS(880), 1,
      anon_sym_RBRACK,
    ACTIONS(882), 1,
      sym__ws,
    STATE(261), 1,
      aux_sym_tag_filter_repeat1,
  [5667] = 4,
    ACTIONS(874), 1,
      anon_sym_COMMA,
    ACTIONS(884), 1,
      anon_sym_RBRACK,
    ACTIONS(886), 1,
      sym__ws,
    STATE(268), 1,
      aux_sym_tag_filter_repeat1,
  [5680] = 4,
    ACTIONS(874), 1,
      anon_sym_COMMA,
    ACTIONS(880), 1,
      anon_sym_RBRACK,
    ACTIONS(882), 1,
      sym__ws,
    STATE(260), 1,
      aux_sym_tag_filter_repeat1,
  [5693] = 4,
    ACTIONS(874), 1,
      anon_sym_COMMA,
    ACTIONS(888), 1,
      anon_sym_RBRACK,
    ACTIONS(890), 1,
      sym__ws,
    STATE(269), 1,
      aux_sym_tag_filter_repeat1,
  [5706] = 4,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(828), 1,
      anon_sym_RBRACK,
    ACTIONS(846), 1,
      sym__ws,
    STATE(330), 1,
      sym_tag_setting,
  [5719] = 3,
    ACTIONS(892), 1,
      anon_sym_RBRACK,
    STATE(267), 1,
      aux_sym_regex_char_class_repeat1,
    ACTIONS(894), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [5730] = 4,
    ACTIONS(874), 1,
      anon_sym_COMMA,
    ACTIONS(888), 1,
      anon_sym_RBRACK,
    ACTIONS(890), 1,
      sym__ws,
    STATE(260), 1,
      aux_sym_tag_filter_repeat1,
  [5743] = 4,
    ACTIONS(874), 1,
      anon_sym_COMMA,
    ACTIONS(897), 1,
      anon_sym_RBRACK,
    ACTIONS(899), 1,
      sym__ws,
    STATE(260), 1,
      aux_sym_tag_filter_repeat1,
  [5756] = 4,
    ACTIONS(901), 1,
      anon_sym_COMMA,
    ACTIONS(903), 1,
      anon_sym_RBRACK,
    ACTIONS(905), 1,
      sym__ws,
    STATE(289), 1,
      aux_sym__tag_list_repeat1,
  [5769] = 4,
    ACTIONS(874), 1,
      anon_sym_COMMA,
    ACTIONS(907), 1,
      anon_sym_RBRACK,
    ACTIONS(909), 1,
      sym__ws,
    STATE(264), 1,
      aux_sym_tag_filter_repeat1,
  [5782] = 3,
    ACTIONS(633), 1,
      anon_sym_DASH,
    ACTIONS(911), 1,
      sym_tag,
    STATE(291), 2,
      sym_neg_tag,
      sym__tag_or_neg,
  [5793] = 3,
    ACTIONS(913), 1,
      anon_sym_RBRACK,
    STATE(277), 1,
      aux_sym_regex_char_class_repeat1,
    ACTIONS(915), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [5804] = 1,
    ACTIONS(917), 4,
      anon_sym_LBRACK,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5811] = 1,
    ACTIONS(919), 4,
      sym_colon,
      anon_sym_SLASH,
      sym_lexicon_string,
      sym_escaped_char,
  [5818] = 4,
    ACTIONS(747), 1,
      anon_sym_LBRACK,
    ACTIONS(820), 1,
      anon_sym_RBRACK,
    ACTIONS(858), 1,
      sym__ws,
    STATE(324), 1,
      sym_tag_setting,
  [5831] = 3,
    ACTIONS(921), 1,
      anon_sym_RBRACK,
    STATE(267), 1,
      aux_sym_regex_char_class_repeat1,
    ACTIONS(923), 2,
      sym_lexicon_string,
      sym_escaped_char,
  [5842] = 3,
    ACTIONS(927), 1,
      sym__ws,
    STATE(278), 1,
      aux_sym_lexicon_line_repeat1,
    ACTIONS(925), 2,
      sym_comment,
      sym__real_nl,
  [5853] = 1,
    ACTIONS(930), 4,
      anon_sym_LBRACK,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5860] = 2,
    ACTIONS(934), 1,
      sym__ws,
    ACTIONS(932), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [5868] = 1,
    ACTIONS(925), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5874] = 2,
    ACTIONS(938), 1,
      sym__ws,
    ACTIONS(936), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [5882] = 1,
    ACTIONS(940), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5888] = 3,
    ACTIONS(942), 1,
      anon_sym_COMMA,
    ACTIONS(944), 1,
      anon_sym_RBRACK,
    STATE(285), 1,
      aux_sym__tag_list_repeat1,
  [5898] = 3,
    ACTIONS(946), 1,
      anon_sym_COMMA,
    ACTIONS(949), 1,
      anon_sym_RBRACK,
    STATE(285), 1,
      aux_sym__tag_list_repeat1,
  [5908] = 3,
    ACTIONS(942), 1,
      anon_sym_COMMA,
    ACTIONS(951), 1,
      anon_sym_RBRACK,
    STATE(284), 1,
      aux_sym__tag_list_repeat1,
  [5918] = 1,
    ACTIONS(953), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5924] = 2,
    ACTIONS(955), 1,
      sym__ws,
    ACTIONS(869), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [5932] = 3,
    ACTIONS(942), 1,
      anon_sym_COMMA,
    ACTIONS(951), 1,
      anon_sym_RBRACK,
    STATE(285), 1,
      aux_sym__tag_list_repeat1,
  [5942] = 1,
    ACTIONS(957), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5948] = 2,
    ACTIONS(961), 1,
      sym__ws,
    ACTIONS(959), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [5956] = 2,
    ACTIONS(963), 1,
      sym__ws,
    ACTIONS(917), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [5964] = 2,
    ACTIONS(967), 1,
      sym__ws,
    ACTIONS(965), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [5972] = 1,
    ACTIONS(969), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5978] = 1,
    ACTIONS(971), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5984] = 1,
    ACTIONS(973), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5990] = 1,
    ACTIONS(975), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [5996] = 1,
    ACTIONS(977), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [6002] = 1,
    ACTIONS(979), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [6008] = 2,
    ACTIONS(983), 1,
      sym__ws,
    ACTIONS(981), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [6016] = 2,
    ACTIONS(987), 1,
      sym__ws,
    ACTIONS(985), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [6024] = 1,
    ACTIONS(989), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [6030] = 2,
    ACTIONS(991), 1,
      sym__ws,
    ACTIONS(930), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [6038] = 1,
    ACTIONS(993), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [6044] = 2,
    ACTIONS(997), 1,
      sym__ws,
    ACTIONS(995), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [6052] = 1,
    ACTIONS(999), 3,
      sym_comment,
      sym__real_nl,
      sym__ws,
  [6058] = 2,
    ACTIONS(1001), 1,
      sym__real_nl,
    STATE(104), 1,
      sym__nl,
  [6065] = 2,
    ACTIONS(1003), 1,
      anon_sym_COMMA,
    ACTIONS(1005), 1,
      anon_sym_RBRACK,
  [6072] = 2,
    ACTIONS(975), 1,
      anon_sym_RBRACK,
    ACTIONS(1007), 1,
      sym__ws,
  [6079] = 2,
    ACTIONS(1009), 1,
      sym__real_nl,
    STATE(247), 1,
      sym__nl,
  [6086] = 2,
    ACTIONS(1011), 1,
      anon_sym_RBRACK,
    ACTIONS(1013), 1,
      sym__ws,
  [6093] = 2,
    ACTIONS(139), 1,
      sym__real_nl,
    STATE(84), 1,
      sym__nl,
  [6100] = 2,
    ACTIONS(999), 1,
      anon_sym_RBRACK,
    ACTIONS(1015), 1,
      sym__ws,
  [6107] = 2,
    ACTIONS(1009), 1,
      sym__real_nl,
    STATE(152), 1,
      sym__nl,
  [6114] = 2,
    ACTIONS(989), 1,
      anon_sym_RBRACK,
    ACTIONS(1017), 1,
      sym__ws,
  [6121] = 2,
    ACTIONS(1003), 1,
      anon_sym_COMMA,
    ACTIONS(1019), 1,
      anon_sym_RBRACK,
  [6128] = 2,
    ACTIONS(940), 1,
      anon_sym_RBRACK,
    ACTIONS(1021), 1,
      sym__ws,
  [6135] = 2,
    ACTIONS(470), 1,
      sym_identifier,
    STATE(27), 1,
      sym_lexicon_reference,
  [6142] = 2,
    ACTIONS(1001), 1,
      sym__real_nl,
    STATE(103), 1,
      sym__nl,
  [6149] = 1,
    ACTIONS(1023), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [6154] = 2,
    ACTIONS(957), 1,
      anon_sym_RBRACK,
    ACTIONS(1025), 1,
      sym__ws,
  [6161] = 2,
    ACTIONS(1001), 1,
      sym__real_nl,
    STATE(111), 1,
      sym__nl,
  [6168] = 2,
    ACTIONS(1003), 1,
      anon_sym_COMMA,
    ACTIONS(1027), 1,
      anon_sym_RBRACK,
  [6175] = 2,
    ACTIONS(993), 1,
      anon_sym_RBRACK,
    ACTIONS(1029), 1,
      sym__ws,
  [6182] = 2,
    ACTIONS(1031), 1,
      sym__real_nl,
    STATE(17), 1,
      sym__nl,
  [6189] = 1,
    ACTIONS(1033), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [6194] = 2,
    ACTIONS(971), 1,
      anon_sym_RBRACK,
    ACTIONS(1035), 1,
      sym__ws,
  [6201] = 2,
    ACTIONS(973), 1,
      anon_sym_RBRACK,
    ACTIONS(1037), 1,
      sym__ws,
  [6208] = 2,
    ACTIONS(1009), 1,
      sym__real_nl,
    STATE(128), 1,
      sym__nl,
  [6215] = 2,
    ACTIONS(953), 1,
      anon_sym_RBRACK,
    ACTIONS(1039), 1,
      sym__ws,
  [6222] = 2,
    ACTIONS(1041), 1,
      anon_sym_RBRACK,
    ACTIONS(1043), 1,
      sym__ws,
  [6229] = 2,
    ACTIONS(1031), 1,
      sym__real_nl,
    STATE(22), 1,
      sym__nl,
  [6236] = 2,
    ACTIONS(1003), 1,
      anon_sym_COMMA,
    ACTIONS(1045), 1,
      anon_sym_RBRACK,
  [6243] = 2,
    ACTIONS(1003), 1,
      anon_sym_COMMA,
    ACTIONS(1047), 1,
      anon_sym_RBRACK,
  [6250] = 2,
    ACTIONS(969), 1,
      anon_sym_RBRACK,
    ACTIONS(1049), 1,
      sym__ws,
  [6257] = 2,
    ACTIONS(1051), 1,
      anon_sym_RBRACK,
    ACTIONS(1053), 1,
      sym__ws,
  [6264] = 2,
    ACTIONS(1055), 1,
      anon_sym_RBRACK,
    ACTIONS(1057), 1,
      sym__ws,
  [6271] = 2,
    ACTIONS(1003), 1,
      anon_sym_COMMA,
    ACTIONS(1059), 1,
      anon_sym_RBRACK,
  [6278] = 2,
    ACTIONS(864), 1,
      sym__ws,
    ACTIONS(979), 1,
      anon_sym_RBRACK,
  [6285] = 2,
    ACTIONS(919), 1,
      sym__ws,
    ACTIONS(977), 1,
      anon_sym_RBRACK,
  [6292] = 2,
    ACTIONS(139), 1,
      sym__real_nl,
    STATE(95), 1,
      sym__nl,
  [6299] = 2,
    ACTIONS(397), 1,
      sym_identifier,
    STATE(63), 1,
      sym_lexicon_reference,
  [6306] = 2,
    ACTIONS(1001), 1,
      sym__real_nl,
    STATE(106), 1,
      sym__nl,
  [6313] = 1,
    ACTIONS(1061), 1,
      sym_number,
  [6317] = 1,
    ACTIONS(619), 1,
      sym_comment,
  [6321] = 1,
    ACTIONS(1063), 1,
      sym__real_nl,
  [6325] = 1,
    ACTIONS(1065), 1,
      anon_sym_RPAREN,
  [6329] = 1,
    ACTIONS(1067), 1,
      sym__real_nl,
  [6333] = 1,
    ACTIONS(1069), 1,
      anon_sym_RBRACK,
  [6337] = 1,
    ACTIONS(1071), 1,
      anon_sym_LBRACK,
  [6341] = 1,
    ACTIONS(1073), 1,
      sym_number,
  [6345] = 1,
    ACTIONS(1075), 1,
      anon_sym_RBRACK,
  [6349] = 1,
    ACTIONS(1077), 1,
      anon_sym_RPAREN,
  [6353] = 1,
    ACTIONS(1079), 1,
      anon_sym_RBRACK,
  [6357] = 1,
    ACTIONS(1081), 1,
      ts_builtin_sym_end,
  [6361] = 1,
    ACTIONS(1083), 1,
      anon_sym_LBRACK,
  [6365] = 1,
    ACTIONS(1085), 1,
      anon_sym_RBRACK,
  [6369] = 1,
    ACTIONS(1087), 1,
      sym_identifier,
  [6373] = 1,
    ACTIONS(1089), 1,
      anon_sym_RPAREN,
  [6377] = 1,
    ACTIONS(1091), 1,
      anon_sym_RBRACK,
  [6381] = 1,
    ACTIONS(1093), 1,
      anon_sym_RBRACK,
  [6385] = 1,
    ACTIONS(1095), 1,
      sym_identifier,
  [6389] = 1,
    ACTIONS(1097), 1,
      anon_sym_RBRACK,
  [6393] = 1,
    ACTIONS(1099), 1,
      sym_identifier,
  [6397] = 1,
    ACTIONS(1101), 1,
      anon_sym_RBRACK,
  [6401] = 1,
    ACTIONS(1103), 1,
      anon_sym_RBRACK,
  [6405] = 1,
    ACTIONS(1105), 1,
      sym__real_nl,
  [6409] = 1,
    ACTIONS(1107), 1,
      sym__real_nl,
  [6413] = 1,
    ACTIONS(1109), 1,
      anon_sym_RBRACK,
  [6417] = 1,
    ACTIONS(1111), 1,
      anon_sym_RBRACK,
  [6421] = 1,
    ACTIONS(1113), 1,
      sym__real_nl,
  [6425] = 1,
    ACTIONS(1115), 1,
      sym__real_nl,
  [6429] = 1,
    ACTIONS(1117), 1,
      sym__ws,
  [6433] = 1,
    ACTIONS(1119), 1,
      sym__ws,
  [6437] = 1,
    ACTIONS(1121), 1,
      sym_identifier,
  [6441] = 1,
    ACTIONS(1123), 1,
      anon_sym_RPAREN,
  [6445] = 1,
    ACTIONS(1125), 1,
      sym__ws,
  [6449] = 1,
    ACTIONS(1127), 1,
      anon_sym_RBRACK,
  [6453] = 1,
    ACTIONS(1129), 1,
      sym_tag,
  [6457] = 1,
    ACTIONS(1131), 1,
      sym__ws,
  [6461] = 1,
    ACTIONS(1003), 1,
      anon_sym_COMMA,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 49,
  [SMALL_STATE(4)] = 98,
  [SMALL_STATE(5)] = 147,
  [SMALL_STATE(6)] = 196,
  [SMALL_STATE(7)] = 245,
  [SMALL_STATE(8)] = 286,
  [SMALL_STATE(9)] = 327,
  [SMALL_STATE(10)] = 368,
  [SMALL_STATE(11)] = 409,
  [SMALL_STATE(12)] = 450,
  [SMALL_STATE(13)] = 491,
  [SMALL_STATE(14)] = 532,
  [SMALL_STATE(15)] = 573,
  [SMALL_STATE(16)] = 614,
  [SMALL_STATE(17)] = 654,
  [SMALL_STATE(18)] = 694,
  [SMALL_STATE(19)] = 720,
  [SMALL_STATE(20)] = 760,
  [SMALL_STATE(21)] = 802,
  [SMALL_STATE(22)] = 828,
  [SMALL_STATE(23)] = 868,
  [SMALL_STATE(24)] = 910,
  [SMALL_STATE(25)] = 936,
  [SMALL_STATE(26)] = 962,
  [SMALL_STATE(27)] = 1001,
  [SMALL_STATE(28)] = 1022,
  [SMALL_STATE(29)] = 1061,
  [SMALL_STATE(30)] = 1082,
  [SMALL_STATE(31)] = 1103,
  [SMALL_STATE(32)] = 1124,
  [SMALL_STATE(33)] = 1147,
  [SMALL_STATE(34)] = 1186,
  [SMALL_STATE(35)] = 1225,
  [SMALL_STATE(36)] = 1248,
  [SMALL_STATE(37)] = 1287,
  [SMALL_STATE(38)] = 1314,
  [SMALL_STATE(39)] = 1341,
  [SMALL_STATE(40)] = 1380,
  [SMALL_STATE(41)] = 1407,
  [SMALL_STATE(42)] = 1428,
  [SMALL_STATE(43)] = 1451,
  [SMALL_STATE(44)] = 1473,
  [SMALL_STATE(45)] = 1497,
  [SMALL_STATE(46)] = 1513,
  [SMALL_STATE(47)] = 1529,
  [SMALL_STATE(48)] = 1547,
  [SMALL_STATE(49)] = 1583,
  [SMALL_STATE(50)] = 1607,
  [SMALL_STATE(51)] = 1639,
  [SMALL_STATE(52)] = 1675,
  [SMALL_STATE(53)] = 1707,
  [SMALL_STATE(54)] = 1723,
  [SMALL_STATE(55)] = 1739,
  [SMALL_STATE(56)] = 1755,
  [SMALL_STATE(57)] = 1787,
  [SMALL_STATE(58)] = 1803,
  [SMALL_STATE(59)] = 1819,
  [SMALL_STATE(60)] = 1835,
  [SMALL_STATE(61)] = 1867,
  [SMALL_STATE(62)] = 1883,
  [SMALL_STATE(63)] = 1905,
  [SMALL_STATE(64)] = 1927,
  [SMALL_STATE(65)] = 1949,
  [SMALL_STATE(66)] = 1965,
  [SMALL_STATE(67)] = 1997,
  [SMALL_STATE(68)] = 2013,
  [SMALL_STATE(69)] = 2029,
  [SMALL_STATE(70)] = 2061,
  [SMALL_STATE(71)] = 2093,
  [SMALL_STATE(72)] = 2115,
  [SMALL_STATE(73)] = 2131,
  [SMALL_STATE(74)] = 2163,
  [SMALL_STATE(75)] = 2196,
  [SMALL_STATE(76)] = 2227,
  [SMALL_STATE(77)] = 2244,
  [SMALL_STATE(78)] = 2261,
  [SMALL_STATE(79)] = 2282,
  [SMALL_STATE(80)] = 2299,
  [SMALL_STATE(81)] = 2320,
  [SMALL_STATE(82)] = 2341,
  [SMALL_STATE(83)] = 2358,
  [SMALL_STATE(84)] = 2375,
  [SMALL_STATE(85)] = 2392,
  [SMALL_STATE(86)] = 2409,
  [SMALL_STATE(87)] = 2430,
  [SMALL_STATE(88)] = 2447,
  [SMALL_STATE(89)] = 2464,
  [SMALL_STATE(90)] = 2481,
  [SMALL_STATE(91)] = 2498,
  [SMALL_STATE(92)] = 2515,
  [SMALL_STATE(93)] = 2532,
  [SMALL_STATE(94)] = 2549,
  [SMALL_STATE(95)] = 2566,
  [SMALL_STATE(96)] = 2583,
  [SMALL_STATE(97)] = 2616,
  [SMALL_STATE(98)] = 2649,
  [SMALL_STATE(99)] = 2666,
  [SMALL_STATE(100)] = 2683,
  [SMALL_STATE(101)] = 2701,
  [SMALL_STATE(102)] = 2721,
  [SMALL_STATE(103)] = 2741,
  [SMALL_STATE(104)] = 2771,
  [SMALL_STATE(105)] = 2801,
  [SMALL_STATE(106)] = 2831,
  [SMALL_STATE(107)] = 2861,
  [SMALL_STATE(108)] = 2879,
  [SMALL_STATE(109)] = 2899,
  [SMALL_STATE(110)] = 2917,
  [SMALL_STATE(111)] = 2937,
  [SMALL_STATE(112)] = 2967,
  [SMALL_STATE(113)] = 2997,
  [SMALL_STATE(114)] = 3027,
  [SMALL_STATE(115)] = 3043,
  [SMALL_STATE(116)] = 3073,
  [SMALL_STATE(117)] = 3086,
  [SMALL_STATE(118)] = 3109,
  [SMALL_STATE(119)] = 3130,
  [SMALL_STATE(120)] = 3159,
  [SMALL_STATE(121)] = 3182,
  [SMALL_STATE(122)] = 3205,
  [SMALL_STATE(123)] = 3224,
  [SMALL_STATE(124)] = 3239,
  [SMALL_STATE(125)] = 3258,
  [SMALL_STATE(126)] = 3281,
  [SMALL_STATE(127)] = 3294,
  [SMALL_STATE(128)] = 3323,
  [SMALL_STATE(129)] = 3338,
  [SMALL_STATE(130)] = 3353,
  [SMALL_STATE(131)] = 3372,
  [SMALL_STATE(132)] = 3401,
  [SMALL_STATE(133)] = 3424,
  [SMALL_STATE(134)] = 3453,
  [SMALL_STATE(135)] = 3472,
  [SMALL_STATE(136)] = 3485,
  [SMALL_STATE(137)] = 3508,
  [SMALL_STATE(138)] = 3521,
  [SMALL_STATE(139)] = 3534,
  [SMALL_STATE(140)] = 3557,
  [SMALL_STATE(141)] = 3580,
  [SMALL_STATE(142)] = 3609,
  [SMALL_STATE(143)] = 3628,
  [SMALL_STATE(144)] = 3641,
  [SMALL_STATE(145)] = 3666,
  [SMALL_STATE(146)] = 3685,
  [SMALL_STATE(147)] = 3704,
  [SMALL_STATE(148)] = 3727,
  [SMALL_STATE(149)] = 3746,
  [SMALL_STATE(150)] = 3765,
  [SMALL_STATE(151)] = 3780,
  [SMALL_STATE(152)] = 3809,
  [SMALL_STATE(153)] = 3824,
  [SMALL_STATE(154)] = 3853,
  [SMALL_STATE(155)] = 3873,
  [SMALL_STATE(156)] = 3893,
  [SMALL_STATE(157)] = 3913,
  [SMALL_STATE(158)] = 3939,
  [SMALL_STATE(159)] = 3961,
  [SMALL_STATE(160)] = 3983,
  [SMALL_STATE(161)] = 4005,
  [SMALL_STATE(162)] = 4027,
  [SMALL_STATE(163)] = 4049,
  [SMALL_STATE(164)] = 4063,
  [SMALL_STATE(165)] = 4083,
  [SMALL_STATE(166)] = 4109,
  [SMALL_STATE(167)] = 4123,
  [SMALL_STATE(168)] = 4145,
  [SMALL_STATE(169)] = 4171,
  [SMALL_STATE(170)] = 4185,
  [SMALL_STATE(171)] = 4205,
  [SMALL_STATE(172)] = 4217,
  [SMALL_STATE(173)] = 4237,
  [SMALL_STATE(174)] = 4257,
  [SMALL_STATE(175)] = 4273,
  [SMALL_STATE(176)] = 4299,
  [SMALL_STATE(177)] = 4325,
  [SMALL_STATE(178)] = 4339,
  [SMALL_STATE(179)] = 4353,
  [SMALL_STATE(180)] = 4373,
  [SMALL_STATE(181)] = 4389,
  [SMALL_STATE(182)] = 4409,
  [SMALL_STATE(183)] = 4423,
  [SMALL_STATE(184)] = 4437,
  [SMALL_STATE(185)] = 4449,
  [SMALL_STATE(186)] = 4467,
  [SMALL_STATE(187)] = 4481,
  [SMALL_STATE(188)] = 4495,
  [SMALL_STATE(189)] = 4511,
  [SMALL_STATE(190)] = 4523,
  [SMALL_STATE(191)] = 4541,
  [SMALL_STATE(192)] = 4567,
  [SMALL_STATE(193)] = 4587,
  [SMALL_STATE(194)] = 4613,
  [SMALL_STATE(195)] = 4627,
  [SMALL_STATE(196)] = 4647,
  [SMALL_STATE(197)] = 4667,
  [SMALL_STATE(198)] = 4680,
  [SMALL_STATE(199)] = 4697,
  [SMALL_STATE(200)] = 4710,
  [SMALL_STATE(201)] = 4735,
  [SMALL_STATE(202)] = 4756,
  [SMALL_STATE(203)] = 4769,
  [SMALL_STATE(204)] = 4782,
  [SMALL_STATE(205)] = 4795,
  [SMALL_STATE(206)] = 4816,
  [SMALL_STATE(207)] = 4837,
  [SMALL_STATE(208)] = 4850,
  [SMALL_STATE(209)] = 4863,
  [SMALL_STATE(210)] = 4884,
  [SMALL_STATE(211)] = 4897,
  [SMALL_STATE(212)] = 4910,
  [SMALL_STATE(213)] = 4931,
  [SMALL_STATE(214)] = 4948,
  [SMALL_STATE(215)] = 4961,
  [SMALL_STATE(216)] = 4974,
  [SMALL_STATE(217)] = 4995,
  [SMALL_STATE(218)] = 5008,
  [SMALL_STATE(219)] = 5021,
  [SMALL_STATE(220)] = 5042,
  [SMALL_STATE(221)] = 5059,
  [SMALL_STATE(222)] = 5072,
  [SMALL_STATE(223)] = 5085,
  [SMALL_STATE(224)] = 5098,
  [SMALL_STATE(225)] = 5119,
  [SMALL_STATE(226)] = 5136,
  [SMALL_STATE(227)] = 5150,
  [SMALL_STATE(228)] = 5164,
  [SMALL_STATE(229)] = 5176,
  [SMALL_STATE(230)] = 5198,
  [SMALL_STATE(231)] = 5207,
  [SMALL_STATE(232)] = 5224,
  [SMALL_STATE(233)] = 5239,
  [SMALL_STATE(234)] = 5256,
  [SMALL_STATE(235)] = 5273,
  [SMALL_STATE(236)] = 5288,
  [SMALL_STATE(237)] = 5305,
  [SMALL_STATE(238)] = 5322,
  [SMALL_STATE(239)] = 5341,
  [SMALL_STATE(240)] = 5360,
  [SMALL_STATE(241)] = 5377,
  [SMALL_STATE(242)] = 5391,
  [SMALL_STATE(243)] = 5405,
  [SMALL_STATE(244)] = 5421,
  [SMALL_STATE(245)] = 5435,
  [SMALL_STATE(246)] = 5451,
  [SMALL_STATE(247)] = 5467,
  [SMALL_STATE(248)] = 5477,
  [SMALL_STATE(249)] = 5487,
  [SMALL_STATE(250)] = 5503,
  [SMALL_STATE(251)] = 5513,
  [SMALL_STATE(252)] = 5525,
  [SMALL_STATE(253)] = 5539,
  [SMALL_STATE(254)] = 5553,
  [SMALL_STATE(255)] = 5561,
  [SMALL_STATE(256)] = 5577,
  [SMALL_STATE(257)] = 5593,
  [SMALL_STATE(258)] = 5609,
  [SMALL_STATE(259)] = 5621,
  [SMALL_STATE(260)] = 5628,
  [SMALL_STATE(261)] = 5641,
  [SMALL_STATE(262)] = 5654,
  [SMALL_STATE(263)] = 5667,
  [SMALL_STATE(264)] = 5680,
  [SMALL_STATE(265)] = 5693,
  [SMALL_STATE(266)] = 5706,
  [SMALL_STATE(267)] = 5719,
  [SMALL_STATE(268)] = 5730,
  [SMALL_STATE(269)] = 5743,
  [SMALL_STATE(270)] = 5756,
  [SMALL_STATE(271)] = 5769,
  [SMALL_STATE(272)] = 5782,
  [SMALL_STATE(273)] = 5793,
  [SMALL_STATE(274)] = 5804,
  [SMALL_STATE(275)] = 5811,
  [SMALL_STATE(276)] = 5818,
  [SMALL_STATE(277)] = 5831,
  [SMALL_STATE(278)] = 5842,
  [SMALL_STATE(279)] = 5853,
  [SMALL_STATE(280)] = 5860,
  [SMALL_STATE(281)] = 5868,
  [SMALL_STATE(282)] = 5874,
  [SMALL_STATE(283)] = 5882,
  [SMALL_STATE(284)] = 5888,
  [SMALL_STATE(285)] = 5898,
  [SMALL_STATE(286)] = 5908,
  [SMALL_STATE(287)] = 5918,
  [SMALL_STATE(288)] = 5924,
  [SMALL_STATE(289)] = 5932,
  [SMALL_STATE(290)] = 5942,
  [SMALL_STATE(291)] = 5948,
  [SMALL_STATE(292)] = 5956,
  [SMALL_STATE(293)] = 5964,
  [SMALL_STATE(294)] = 5972,
  [SMALL_STATE(295)] = 5978,
  [SMALL_STATE(296)] = 5984,
  [SMALL_STATE(297)] = 5990,
  [SMALL_STATE(298)] = 5996,
  [SMALL_STATE(299)] = 6002,
  [SMALL_STATE(300)] = 6008,
  [SMALL_STATE(301)] = 6016,
  [SMALL_STATE(302)] = 6024,
  [SMALL_STATE(303)] = 6030,
  [SMALL_STATE(304)] = 6038,
  [SMALL_STATE(305)] = 6044,
  [SMALL_STATE(306)] = 6052,
  [SMALL_STATE(307)] = 6058,
  [SMALL_STATE(308)] = 6065,
  [SMALL_STATE(309)] = 6072,
  [SMALL_STATE(310)] = 6079,
  [SMALL_STATE(311)] = 6086,
  [SMALL_STATE(312)] = 6093,
  [SMALL_STATE(313)] = 6100,
  [SMALL_STATE(314)] = 6107,
  [SMALL_STATE(315)] = 6114,
  [SMALL_STATE(316)] = 6121,
  [SMALL_STATE(317)] = 6128,
  [SMALL_STATE(318)] = 6135,
  [SMALL_STATE(319)] = 6142,
  [SMALL_STATE(320)] = 6149,
  [SMALL_STATE(321)] = 6154,
  [SMALL_STATE(322)] = 6161,
  [SMALL_STATE(323)] = 6168,
  [SMALL_STATE(324)] = 6175,
  [SMALL_STATE(325)] = 6182,
  [SMALL_STATE(326)] = 6189,
  [SMALL_STATE(327)] = 6194,
  [SMALL_STATE(328)] = 6201,
  [SMALL_STATE(329)] = 6208,
  [SMALL_STATE(330)] = 6215,
  [SMALL_STATE(331)] = 6222,
  [SMALL_STATE(332)] = 6229,
  [SMALL_STATE(333)] = 6236,
  [SMALL_STATE(334)] = 6243,
  [SMALL_STATE(335)] = 6250,
  [SMALL_STATE(336)] = 6257,
  [SMALL_STATE(337)] = 6264,
  [SMALL_STATE(338)] = 6271,
  [SMALL_STATE(339)] = 6278,
  [SMALL_STATE(340)] = 6285,
  [SMALL_STATE(341)] = 6292,
  [SMALL_STATE(342)] = 6299,
  [SMALL_STATE(343)] = 6306,
  [SMALL_STATE(344)] = 6313,
  [SMALL_STATE(345)] = 6317,
  [SMALL_STATE(346)] = 6321,
  [SMALL_STATE(347)] = 6325,
  [SMALL_STATE(348)] = 6329,
  [SMALL_STATE(349)] = 6333,
  [SMALL_STATE(350)] = 6337,
  [SMALL_STATE(351)] = 6341,
  [SMALL_STATE(352)] = 6345,
  [SMALL_STATE(353)] = 6349,
  [SMALL_STATE(354)] = 6353,
  [SMALL_STATE(355)] = 6357,
  [SMALL_STATE(356)] = 6361,
  [SMALL_STATE(357)] = 6365,
  [SMALL_STATE(358)] = 6369,
  [SMALL_STATE(359)] = 6373,
  [SMALL_STATE(360)] = 6377,
  [SMALL_STATE(361)] = 6381,
  [SMALL_STATE(362)] = 6385,
  [SMALL_STATE(363)] = 6389,
  [SMALL_STATE(364)] = 6393,
  [SMALL_STATE(365)] = 6397,
  [SMALL_STATE(366)] = 6401,
  [SMALL_STATE(367)] = 6405,
  [SMALL_STATE(368)] = 6409,
  [SMALL_STATE(369)] = 6413,
  [SMALL_STATE(370)] = 6417,
  [SMALL_STATE(371)] = 6421,
  [SMALL_STATE(372)] = 6425,
  [SMALL_STATE(373)] = 6429,
  [SMALL_STATE(374)] = 6433,
  [SMALL_STATE(375)] = 6437,
  [SMALL_STATE(376)] = 6441,
  [SMALL_STATE(377)] = 6445,
  [SMALL_STATE(378)] = 6449,
  [SMALL_STATE(379)] = 6453,
  [SMALL_STATE(380)] = 6457,
  [SMALL_STATE(381)] = 6461,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(377),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(374),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(373),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [17] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_block, 6, .production_id = 35),
  [19] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_block, 6, .production_id = 35),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [33] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_pattern_block_repeat1, 2),
  [35] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_pattern_block_repeat1, 2),
  [37] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_block_repeat1, 2), SHIFT_REPEAT(163),
  [40] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_block_repeat1, 2), SHIFT_REPEAT(318),
  [43] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_block_repeat1, 2), SHIFT_REPEAT(48),
  [46] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_block_repeat1, 2), SHIFT_REPEAT(127),
  [49] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_block_repeat1, 2), SHIFT_REPEAT(25),
  [52] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_block_repeat1, 2), SHIFT_REPEAT(96),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_block, 5, .production_id = 23),
  [57] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_block, 5, .production_id = 23),
  [59] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_block, 3),
  [61] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_block, 3),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_block, 4, .production_id = 5),
  [65] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_block, 4, .production_id = 5),
  [67] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_block, 7, .production_id = 46),
  [69] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_block, 7, .production_id = 46),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_block, 6, .production_id = 35),
  [83] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_block, 6, .production_id = 35),
  [85] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_block, 6, .production_id = 37),
  [87] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_block, 6, .production_id = 37),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_block, 6, .production_id = 36),
  [91] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_block, 6, .production_id = 36),
  [93] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_block, 5, .production_id = 23),
  [95] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_block, 5, .production_id = 23),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_lexicon_block_repeat1, 2),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_lexicon_block_repeat1, 2),
  [101] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_lexicon_block_repeat1, 2), SHIFT_REPEAT(155),
  [104] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_lexicon_block_repeat1, 2), SHIFT_REPEAT(233),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_lexicon_block_repeat1, 2), SHIFT_REPEAT(73),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_lexicon_block_repeat1, 2), SHIFT_REPEAT(188),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_lexicon_block_repeat1, 2), SHIFT_REPEAT(188),
  [116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_block, 7, .production_id = 45),
  [118] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_block, 7, .production_id = 45),
  [120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_block, 7, .production_id = 44),
  [122] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_block, 7, .production_id = 44),
  [124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_block, 8, .production_id = 50),
  [126] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_block, 8, .production_id = 50),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 2, .production_id = 11),
  [132] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_pattern_token, 2, .production_id = 11), SHIFT(25),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__nl, 1),
  [143] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__nl, 1),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(341),
  [149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 1, .production_id = 4),
  [151] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_pattern_token, 1, .production_id = 4), SHIFT(139),
  [154] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_reference, 1, .production_id = 3),
  [156] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_lexicon_reference, 1, .production_id = 3), SHIFT(344),
  [159] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_lexicon_reference, 1, .production_id = 3), SHIFT(139),
  [162] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [164] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [168] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [170] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [172] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 2, .production_id = 6),
  [180] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(222),
  [183] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(342),
  [186] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(51),
  [189] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2),
  [191] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(151),
  [194] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(38),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_pattern_line_repeat1, 2),
  [199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_reference, 3, .dynamic_precedence = 2, .production_id = 17),
  [201] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_lexicon_reference, 3, .dynamic_precedence = 2, .production_id = 17), SHIFT(139),
  [204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 3, .production_id = 21),
  [206] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_reference, 2, .production_id = 7),
  [208] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_lexicon_reference, 2, .production_id = 7), SHIFT(139),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_comment_repeat1, 2),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_comment_repeat1, 2),
  [215] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_comment_repeat1, 2), SHIFT_REPEAT(368),
  [218] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(163),
  [221] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(318),
  [224] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(48),
  [227] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(127),
  [230] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 2), SHIFT_REPEAT(25),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [239] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [245] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_pattern_token, 1, .production_id = 4), SHIFT(125),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 1, .production_id = 4),
  [250] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_lexicon_reference, 1, .production_id = 3), SHIFT(351),
  [253] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_lexicon_reference, 1, .production_id = 3), SHIFT(125),
  [256] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_reference, 1, .production_id = 3),
  [260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [264] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_pattern_token, 2, .production_id = 11), SHIFT(38),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 2, .production_id = 11),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 2, .production_id = 10),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_comment, 1),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_comment, 1),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 2, .production_id = 10),
  [277] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [279] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_lexicon, 3),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_filter, 5),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [295] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_reference, 3, .production_id = 18),
  [307] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_filter, 4),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_filter, 6),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_lexicon, 5),
  [315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_pattern, 5, .dynamic_precedence = 20),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_filter, 3),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_reference, 4, .dynamic_precedence = 2, .production_id = 31),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 3, .production_id = 21),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 2, .production_id = 6),
  [327] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_lexicon_reference, 3, .dynamic_precedence = 2, .production_id = 17), SHIFT(125),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_reference, 3, .dynamic_precedence = 2, .production_id = 17),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_pattern, 3, .dynamic_precedence = 20),
  [334] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_regex_group_repeat1, 2), SHIFT_REPEAT(204),
  [337] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_regex_group_repeat1, 2), SHIFT_REPEAT(120),
  [340] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_regex_group_repeat1, 2), SHIFT_REPEAT(56),
  [343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_regex_group_repeat1, 2),
  [345] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_regex_group_repeat1, 2), SHIFT_REPEAT(273),
  [348] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_regex_group_repeat1, 2), SHIFT_REPEAT(144),
  [351] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_regex_group_repeat1, 2), SHIFT_REPEAT(144),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_lexicon, 4),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_reference, 2, .production_id = 8),
  [358] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_regex_repeat1, 2), SHIFT_REPEAT(204),
  [361] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_regex_repeat1, 2), SHIFT_REPEAT(120),
  [364] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_regex_repeat1, 2), SHIFT_REPEAT(56),
  [367] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_regex_repeat1, 2), SHIFT_REPEAT(273),
  [370] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_regex_repeat1, 2), SHIFT_REPEAT(144),
  [373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_regex_repeat1, 2),
  [375] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_regex_repeat1, 2), SHIFT_REPEAT(144),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [380] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_lexicon_reference, 2, .production_id = 7), SHIFT(125),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_reference, 2, .production_id = 7),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_pattern, 4, .dynamic_precedence = 20),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_line, 2),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_line, 2),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_reference, 2, .production_id = 8),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_group, 3),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_group, 3),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_filter, 4),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_group, 2),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_group, 2),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_pattern, 3, .dynamic_precedence = 20),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_lexicon, 3),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_line, 3, .production_id = 2),
  [431] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_line, 3, .production_id = 2),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_reference, 3, .production_id = 18),
  [435] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_comment_repeat1, 2), SHIFT_REPEAT(372),
  [438] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_pattern, 4, .dynamic_precedence = 20),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__nl, 2),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__nl, 2),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_filter, 5),
  [446] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_line, 3),
  [448] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_line, 3),
  [450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_filter, 6),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_lexicon, 4),
  [454] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_reference, 4, .dynamic_precedence = 2, .production_id = 31),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_filter, 3),
  [458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_line, 4, .production_id = 32),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_line, 4, .production_id = 32),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_pattern, 5, .dynamic_precedence = 20),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_lexicon, 5),
  [476] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 6, .dynamic_precedence = 30),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [480] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 3, .dynamic_precedence = 30),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_pattern_line_repeat1, 1),
  [486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 5, .dynamic_precedence = 30),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 4, .dynamic_precedence = 30),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [496] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 3, .production_id = 20),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_line, 2),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_line, 2),
  [502] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_line, 1),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_line, 1),
  [514] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_line, 3),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_line, 3),
  [522] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_option, 5, .dynamic_precedence = 30),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [530] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [532] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [534] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 3, .production_id = 12),
  [540] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [542] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [544] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [546] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [550] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_line, 4, .production_id = 51),
  [552] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_line, 4, .production_id = 51),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_line, 2),
  [556] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_line, 2),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [562] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 3, .production_id = 19),
  [564] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__plain_regex_string, 2),
  [566] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__plain_regex_string, 2),
  [568] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__plain_regex_string, 2), SHIFT_REPEAT(273),
  [571] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__plain_regex_string, 2), SHIFT_REPEAT(136),
  [574] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__plain_regex_string, 2), SHIFT_REPEAT(136),
  [577] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 2, .production_id = 9),
  [579] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_operator, 1, .dynamic_precedence = 3),
  [581] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [585] = {.entry = {.count = 1, .reusable = false}}, SHIFT(288),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [593] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_token, 4, .production_id = 33),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [597] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_option, 6, .dynamic_precedence = 30),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(280),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_option, 4, .dynamic_precedence = 30),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_line, 3),
  [611] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_line, 3),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_line, 3, .production_id = 5),
  [617] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_line, 3, .production_id = 5),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [621] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [623] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [625] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 2, .production_id = 11),
  [627] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [629] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 1),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 2),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [647] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(255),
  [650] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(377),
  [653] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(374),
  [656] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(373),
  [659] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [661] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [663] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 4, .production_id = 41),
  [665] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 4, .production_id = 33),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 3),
  [669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 4, .dynamic_precedence = 30, .production_id = 34),
  [671] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [673] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 3, .production_id = 21),
  [675] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 4, .dynamic_precedence = 30, .production_id = 22),
  [677] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [679] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 3, .production_id = 29),
  [681] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 3, .production_id = 27),
  [683] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__lexicon_side_right, 2),
  [685] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__lexicon_side_right, 2), SHIFT_REPEAT(174),
  [688] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 3, .production_id = 20),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 3, .production_id = 19),
  [692] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [694] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 2, .production_id = 14),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__lexicon_side_left, 2),
  [698] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 2, .production_id = 6),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 3, .production_id = 12),
  [702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_token, 2, .production_id = 9),
  [704] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 6, .dynamic_precedence = 30, .production_id = 43),
  [706] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_comment_repeat1, 2), SHIFT_REPEAT(346),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 3, .dynamic_precedence = 30, .production_id = 22),
  [711] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 5, .dynamic_precedence = 30, .production_id = 43),
  [715] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [717] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__lexicon_side_left, 1),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [721] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_option, 5, .dynamic_precedence = 30, .production_id = 34),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [725] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_operator, 1, .dynamic_precedence = 3),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [733] = {.entry = {.count = 1, .reusable = false}}, SHIFT(213),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__lexicon_side_left, 1),
  [737] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_option, 4, .dynamic_precedence = 30, .production_id = 22),
  [739] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [741] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [743] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [745] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [747] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [749] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 3, .production_id = 27),
  [753] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_group, 4),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_group, 4),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_option, 5, .dynamic_precedence = 30, .production_id = 34),
  [759] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pattern_or, 1),
  [761] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_or, 1),
  [763] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [765] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 2, .production_id = 14),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 3, .production_id = 21),
  [769] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 3, .production_id = 29),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [775] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_char_class, 3),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_char_class, 3),
  [779] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [781] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 2, .production_id = 11),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__lexicon_side_left, 2),
  [785] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_char_class, 2),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_char_class, 2),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_option, 6, .dynamic_precedence = 30, .production_id = 43),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 4, .production_id = 41),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 2, .production_id = 6),
  [797] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__lexicon_side_right, 2), SHIFT_REPEAT(220),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__lexicon_side_right, 2),
  [802] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pattern_line_repeat1, 1), SHIFT_REPEAT(217),
  [805] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 1),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [811] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_comment_repeat1, 2), SHIFT_REPEAT(371),
  [814] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [818] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [820] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 2, .production_id = 15),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [826] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [828] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 1, .production_id = 4),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [834] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [836] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [842] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [844] = {.entry = {.count = 1, .reusable = false}}, SHIFT(212),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 1, .production_id = 4),
  [848] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alias_command, 7, .production_id = 47),
  [850] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alias_command, 7, .production_id = 47),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alias_command, 6, .production_id = 38),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alias_command, 6, .production_id = 38),
  [856] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [858] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 2, .production_id = 15),
  [860] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_setting, 3),
  [866] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_tag_filter_repeat1, 2), SHIFT_REPEAT(140),
  [869] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_tag_filter_repeat1, 2),
  [871] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_tag_filter_repeat1, 2), SHIFT_REPEAT(381),
  [874] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [876] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [878] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [880] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [884] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [888] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [892] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_regex_char_class_repeat1, 2),
  [894] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_regex_char_class_repeat1, 2), SHIFT_REPEAT(267),
  [897] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [901] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [903] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__tag_list, 1),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [907] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [917] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex, 3),
  [919] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_setting, 4),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [925] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_lexicon_line_repeat1, 2),
  [927] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_lexicon_line_repeat1, 2), SHIFT_REPEAT(193),
  [930] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex, 2),
  [932] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_tag_filter_repeat1, 3),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tag_filter_repeat1, 3),
  [936] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__tag_list_repeat1, 2),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [940] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 2, .production_id = 13),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [944] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__tag_list, 3),
  [946] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__tag_list_repeat1, 2), SHIFT_REPEAT(252),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__tag_list_repeat1, 2),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__tag_list, 2),
  [953] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 2, .production_id = 16),
  [955] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tag_filter_repeat1, 2),
  [957] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 5, .production_id = 48),
  [959] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__tag_list_repeat1, 3),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [963] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex, 3),
  [965] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_neg_tag, 2, .production_id = 25),
  [967] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_neg_tag, 2, .production_id = 25),
  [969] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 4, .production_id = 42),
  [971] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 4, .production_id = 40),
  [973] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 4, .production_id = 39),
  [975] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 3, .production_id = 24),
  [977] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_setting, 4),
  [979] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_setting, 3),
  [981] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_distribution, 4, .production_id = 49),
  [983] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_distribution, 4, .production_id = 49),
  [985] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_tag_filter_repeat1, 4),
  [987] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tag_filter_repeat1, 4),
  [989] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 3, .production_id = 26),
  [991] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex, 2),
  [993] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 3, .production_id = 28),
  [995] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tag_distribution, 5, .production_id = 49),
  [997] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_distribution, 5, .production_id = 49),
  [999] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lexicon_segment, 3, .production_id = 30),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1007] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 3, .production_id = 24),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1011] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1015] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 3, .production_id = 30),
  [1017] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 3, .production_id = 26),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1021] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 2, .production_id = 13),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__tag_list_repeat1, 3),
  [1025] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 5, .production_id = 48),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1029] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 3, .production_id = 28),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1033] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__tag_list_repeat1, 4),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 4, .production_id = 40),
  [1037] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 4, .production_id = 39),
  [1039] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 2, .production_id = 16),
  [1041] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1049] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lexicon_segment, 4, .production_id = 42),
  [1051] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1055] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1067] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__end_com, 1, .production_id = 1),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1081] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1083] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag_distribution_operator, 1),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__end_com, 2, .production_id = 2),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_lexd(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
